/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.Type;

@DatatypeDef(name="Period")
public class Period
extends Type
implements ICompositeType {
    @Child(name="start", type={DateTimeType.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Starting time with inclusive boundary", formalDefinition="The start of the period. The boundary is inclusive.")
    protected DateTimeType start;
    @Child(name="end", type={DateTimeType.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="End time with inclusive boundary, if not ongoing", formalDefinition="The end of the period. If the end of the period is missing, it means no end was known or planned at the time the instance was created. The start may be in the past, and the end date in the future, which means that period is expected/planned to end at that time.")
    protected DateTimeType end;
    private static final long serialVersionUID = 649791751L;

    public DateTimeType getStartElement() {
        if (this.start == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Period.start");
            }
            if (Configuration.doAutoCreate()) {
                this.start = new DateTimeType();
            }
        }
        return this.start;
    }

    public boolean hasStartElement() {
        return this.start != null && !this.start.isEmpty();
    }

    public boolean hasStart() {
        return this.start != null && !this.start.isEmpty();
    }

    public Period setStartElement(DateTimeType value) {
        this.start = value;
        return this;
    }

    public Date getStart() {
        return this.start == null ? null : (Date)this.start.getValue();
    }

    public Period setStart(Date value) {
        if (value == null) {
            this.start = null;
        } else {
            if (this.start == null) {
                this.start = new DateTimeType();
            }
            this.start.setValue(value);
        }
        return this;
    }

    public DateTimeType getEndElement() {
        if (this.end == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Period.end");
            }
            if (Configuration.doAutoCreate()) {
                this.end = new DateTimeType();
            }
        }
        return this.end;
    }

    public boolean hasEndElement() {
        return this.end != null && !this.end.isEmpty();
    }

    public boolean hasEnd() {
        return this.end != null && !this.end.isEmpty();
    }

    public Period setEndElement(DateTimeType value) {
        this.end = value;
        return this;
    }

    public Date getEnd() {
        return this.end == null ? null : (Date)this.end.getValue();
    }

    public Period setEnd(Date value) {
        if (value == null) {
            this.end = null;
        } else {
            if (this.end == null) {
                this.end = new DateTimeType();
            }
            this.end.setValue(value);
        }
        return this;
    }

    public Period setStart(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.start = new DateTimeType(theDate, thePrecision);
        return this;
    }

    public Period setEnd(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.end = new DateTimeType(theDate, thePrecision);
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("start", "dateTime", "The start of the period. The boundary is inclusive.", 0, 1, this.start));
        children.add(new Property("end", "dateTime", "The end of the period. If the end of the period is missing, it means no end was known or planned at the time the instance was created. The start may be in the past, and the end date in the future, which means that period is expected/planned to end at that time.", 0, 1, this.end));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 109757538: {
                return new Property("start", "dateTime", "The start of the period. The boundary is inclusive.", 0, 1, this.start);
            }
            case 100571: {
                return new Property("end", "dateTime", "The end of the period. If the end of the period is missing, it means no end was known or planned at the time the instance was created. The start may be in the past, and the end date in the future, which means that period is expected/planned to end at that time.", 0, 1, this.end);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 109757538: {
                Base[] baseArray;
                if (this.start == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.start;
                }
                return baseArray;
            }
            case 100571: {
                Base[] baseArray;
                if (this.end == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.end;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 109757538: {
                this.start = this.castToDateTime(value);
                return value;
            }
            case 100571: {
                this.end = this.castToDateTime(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("start")) {
            this.start = this.castToDateTime(value);
        } else if (name.equals("end")) {
            this.end = this.castToDateTime(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 109757538: {
                return this.getStartElement();
            }
            case 100571: {
                return this.getEndElement();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 109757538: {
                return new String[]{"dateTime"};
            }
            case 100571: {
                return new String[]{"dateTime"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("start")) {
            throw new FHIRException("Cannot call addChild on a primitive type Period.start");
        }
        if (name.equals("end")) {
            throw new FHIRException("Cannot call addChild on a primitive type Period.end");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Period";
    }

    @Override
    public Period copy() {
        Period dst = new Period();
        this.copyValues(dst);
        dst.start = this.start == null ? null : this.start.copy();
        dst.end = this.end == null ? null : this.end.copy();
        return dst;
    }

    @Override
    protected Period typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Period)) {
            return false;
        }
        Period o = (Period)other_;
        return Period.compareDeep(this.start, o.start, true) && Period.compareDeep(this.end, o.end, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Period)) {
            return false;
        }
        Period o = (Period)other_;
        return Period.compareValues(this.start, o.start, true) && Period.compareValues(this.end, o.end, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.start, this.end});
    }
}

