/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBaseReference;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.BaseReference;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.UriType;
import org.hl7.fhir.utilities.Utilities;

@DatatypeDef(name="Reference")
public class Reference
extends BaseReference
implements IBaseReference,
ICompositeType {
    @Child(name="reference", type={StringType.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Literal reference, Relative, internal or absolute URL", formalDefinition="A reference to a location at which the other resource is found. The reference may be a relative reference, in which case it is relative to the service base URL, or an absolute URL that resolves to the location where the resource is found. The reference may be version specific or not. If the reference is not to a FHIR RESTful server, then it should be assumed to be version specific. Internal fragment references (start with '#') refer to contained resources.")
    protected StringType reference;
    @Child(name="type", type={UriType.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Type the reference refers to (e.g. \"Patient\")", formalDefinition="The expected type of the target of the reference. If both Reference.type and Reference.reference are populated and Reference.reference is a FHIR URL, both SHALL be consistent.\n\nThe type is the Canonical URL of Resource Definition that is the type this reference refers to. References are URLs that are relative to http://hl7.org/fhir/StructureDefinition/ e.g. \"Patient\" is a reference to http://hl7.org/fhir/StructureDefinition/Patient. Absolute URLs are only allowed for logical models (and can only be used in references in logical models, not resources).")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/resource-types")
    protected UriType type;
    @Child(name="identifier", type={Identifier.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Logical reference, when literal reference is not known", formalDefinition="An identifier for the target resource. This is used when there is no way to reference the other resource directly, either because the entity it represents is not available through a FHIR server, or because there is no way for the author of the resource to convert a known identifier to an actual location. There is no requirement that a Reference.identifier point to something that is actually exposed as a FHIR instance, but it SHALL point to a business concept that would be expected to be exposed as a FHIR instance, and that instance would need to be of a FHIR resource type allowed by the reference.")
    protected Identifier identifier;
    @Child(name="display", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Text alternative for the resource", formalDefinition="Plain text narrative that identifies the resource in addition to the resource reference.")
    protected StringType display;
    private static final long serialVersionUID = 784245805L;

    public Reference() {
    }

    public Reference(String theReference) {
        super(theReference);
    }

    public Reference(IIdType theReference) {
        super(theReference);
    }

    public Reference(IAnyResource theResource) {
        super(theResource);
    }

    public StringType getReferenceElement_() {
        if (this.reference == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Reference.reference");
            }
            if (Configuration.doAutoCreate()) {
                this.reference = new StringType();
            }
        }
        return this.reference;
    }

    public boolean hasReferenceElement() {
        return this.reference != null && !this.reference.isEmpty();
    }

    public boolean hasReference() {
        return this.reference != null && !this.reference.isEmpty();
    }

    public Reference setReferenceElement(StringType value) {
        this.reference = value;
        return this;
    }

    @Override
    public String getReference() {
        return this.reference == null ? null : (String)this.reference.getValue();
    }

    public Reference setReference(String value) {
        if (Utilities.noString((String)value)) {
            this.reference = null;
        } else {
            if (this.reference == null) {
                this.reference = new StringType();
            }
            this.reference.setValue(value);
        }
        return this;
    }

    public UriType getTypeElement() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Reference.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new UriType();
            }
        }
        return this.type;
    }

    public boolean hasTypeElement() {
        return this.type != null && !this.type.isEmpty();
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public Reference setTypeElement(UriType value) {
        this.type = value;
        return this;
    }

    public String getType() {
        return this.type == null ? null : (String)this.type.getValue();
    }

    public Reference setType(String value) {
        if (Utilities.noString((String)value)) {
            this.type = null;
        } else {
            if (this.type == null) {
                this.type = new UriType();
            }
            this.type.setValue(value);
        }
        return this;
    }

    public Identifier getIdentifier() {
        if (this.identifier == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Reference.identifier");
            }
            if (Configuration.doAutoCreate()) {
                this.identifier = new Identifier();
            }
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        return this.identifier != null && !this.identifier.isEmpty();
    }

    public Reference setIdentifier(Identifier value) {
        this.identifier = value;
        return this;
    }

    public StringType getDisplayElement() {
        if (this.display == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Reference.display");
            }
            if (Configuration.doAutoCreate()) {
                this.display = new StringType();
            }
        }
        return this.display;
    }

    public boolean hasDisplayElement() {
        return this.display != null && !this.display.isEmpty();
    }

    public boolean hasDisplay() {
        return this.display != null && !this.display.isEmpty();
    }

    public Reference setDisplayElement(StringType value) {
        this.display = value;
        return this;
    }

    public String getDisplay() {
        return this.display == null ? null : (String)this.display.getValue();
    }

    public Reference setDisplay(String value) {
        if (Utilities.noString((String)value)) {
            this.display = null;
        } else {
            if (this.display == null) {
                this.display = new StringType();
            }
            this.display.setValue(value);
        }
        return this;
    }

    public Reference setReferenceElement(IIdType theReference) {
        if (theReference != null) {
            this.setReference(theReference.getValue());
        } else {
            this.setReference(null);
        }
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("reference", "string", "A reference to a location at which the other resource is found. The reference may be a relative reference, in which case it is relative to the service base URL, or an absolute URL that resolves to the location where the resource is found. The reference may be version specific or not. If the reference is not to a FHIR RESTful server, then it should be assumed to be version specific. Internal fragment references (start with '#') refer to contained resources.", 0, 1, this.reference));
        children.add(new Property("type", "uri", "The expected type of the target of the reference. If both Reference.type and Reference.reference are populated and Reference.reference is a FHIR URL, both SHALL be consistent.\n\nThe type is the Canonical URL of Resource Definition that is the type this reference refers to. References are URLs that are relative to http://hl7.org/fhir/StructureDefinition/ e.g. \"Patient\" is a reference to http://hl7.org/fhir/StructureDefinition/Patient. Absolute URLs are only allowed for logical models (and can only be used in references in logical models, not resources).", 0, 1, this.type));
        children.add(new Property("identifier", "Identifier", "An identifier for the target resource. This is used when there is no way to reference the other resource directly, either because the entity it represents is not available through a FHIR server, or because there is no way for the author of the resource to convert a known identifier to an actual location. There is no requirement that a Reference.identifier point to something that is actually exposed as a FHIR instance, but it SHALL point to a business concept that would be expected to be exposed as a FHIR instance, and that instance would need to be of a FHIR resource type allowed by the reference.", 0, 1, this.identifier));
        children.add(new Property("display", "string", "Plain text narrative that identifies the resource in addition to the resource reference.", 0, 1, this.display));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -925155509: {
                return new Property("reference", "string", "A reference to a location at which the other resource is found. The reference may be a relative reference, in which case it is relative to the service base URL, or an absolute URL that resolves to the location where the resource is found. The reference may be version specific or not. If the reference is not to a FHIR RESTful server, then it should be assumed to be version specific. Internal fragment references (start with '#') refer to contained resources.", 0, 1, this.reference);
            }
            case 3575610: {
                return new Property("type", "uri", "The expected type of the target of the reference. If both Reference.type and Reference.reference are populated and Reference.reference is a FHIR URL, both SHALL be consistent.\n\nThe type is the Canonical URL of Resource Definition that is the type this reference refers to. References are URLs that are relative to http://hl7.org/fhir/StructureDefinition/ e.g. \"Patient\" is a reference to http://hl7.org/fhir/StructureDefinition/Patient. Absolute URLs are only allowed for logical models (and can only be used in references in logical models, not resources).", 0, 1, this.type);
            }
            case -1618432855: {
                return new Property("identifier", "Identifier", "An identifier for the target resource. This is used when there is no way to reference the other resource directly, either because the entity it represents is not available through a FHIR server, or because there is no way for the author of the resource to convert a known identifier to an actual location. There is no requirement that a Reference.identifier point to something that is actually exposed as a FHIR instance, but it SHALL point to a business concept that would be expected to be exposed as a FHIR instance, and that instance would need to be of a FHIR resource type allowed by the reference.", 0, 1, this.identifier);
            }
            case 1671764162: {
                return new Property("display", "string", "Plain text narrative that identifies the resource in addition to the resource reference.", 0, 1, this.display);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -925155509: {
                Base[] baseArray;
                if (this.reference == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.reference;
                }
                return baseArray;
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.type;
                }
                return baseArray;
            }
            case -1618432855: {
                Base[] baseArray;
                if (this.identifier == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.identifier;
                }
                return baseArray;
            }
            case 1671764162: {
                Base[] baseArray;
                if (this.display == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.display;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -925155509: {
                this.reference = this.castToString(value);
                return value;
            }
            case 3575610: {
                this.type = this.castToUri(value);
                return value;
            }
            case -1618432855: {
                this.identifier = this.castToIdentifier(value);
                return value;
            }
            case 1671764162: {
                this.display = this.castToString(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("reference")) {
            this.reference = this.castToString(value);
        } else if (name.equals("type")) {
            this.type = this.castToUri(value);
        } else if (name.equals("identifier")) {
            this.identifier = this.castToIdentifier(value);
        } else if (name.equals("display")) {
            this.display = this.castToString(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -925155509: {
                return this.getReferenceElement_();
            }
            case 3575610: {
                return this.getTypeElement();
            }
            case -1618432855: {
                return this.getIdentifier();
            }
            case 1671764162: {
                return this.getDisplayElement();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -925155509: {
                return new String[]{"string"};
            }
            case 3575610: {
                return new String[]{"uri"};
            }
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 1671764162: {
                return new String[]{"string"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("reference")) {
            throw new FHIRException("Cannot call addChild on a primitive type Reference.reference");
        }
        if (name.equals("type")) {
            throw new FHIRException("Cannot call addChild on a primitive type Reference.type");
        }
        if (name.equals("identifier")) {
            this.identifier = new Identifier();
            return this.identifier;
        }
        if (name.equals("display")) {
            throw new FHIRException("Cannot call addChild on a primitive type Reference.display");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Reference";
    }

    @Override
    public Reference copy() {
        Reference dst = new Reference();
        this.copyValues(dst);
        dst.reference = this.reference == null ? null : this.reference.copy();
        dst.type = this.type == null ? null : this.type.copy();
        dst.identifier = this.identifier == null ? null : this.identifier.copy();
        dst.display = this.display == null ? null : this.display.copy();
        return dst;
    }

    @Override
    protected Reference typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Reference)) {
            return false;
        }
        Reference o = (Reference)other_;
        return Reference.compareDeep(this.reference, o.reference, true) && Reference.compareDeep(this.type, o.type, true) && Reference.compareDeep(this.identifier, o.identifier, true) && Reference.compareDeep(this.display, o.display, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Reference)) {
            return false;
        }
        Reference o = (Reference)other_;
        return Reference.compareValues(this.reference, o.reference, true) && Reference.compareValues(this.type, o.type, true) && Reference.compareValues(this.display, o.display, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.reference, this.type, this.identifier, this.display});
    }
}

