/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum Fundsreserve {
    PATIENT,
    PROVIDER,
    NONE,
    NULL;


    public static Fundsreserve fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("patient".equals(codeString)) {
            return PATIENT;
        }
        if ("provider".equals(codeString)) {
            return PROVIDER;
        }
        if ("none".equals(codeString)) {
            return NONE;
        }
        throw new FHIRException("Unknown Fundsreserve code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case PATIENT: {
                return "patient";
            }
            case PROVIDER: {
                return "provider";
            }
            case NONE: {
                return "none";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/fundsreserve";
    }

    public String getDefinition() {
        switch (this) {
            case PATIENT: {
                return "The payor is requested to reserve funds for the provision of the named services by any provider for settlement of future claims related to this request.";
            }
            case PROVIDER: {
                return "The payor is requested to reserve funds solely for the named provider for settlement of future claims related to this request.";
            }
            case NONE: {
                return "The payor is not being requested to reserve any funds for the settlement of future claims.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case PATIENT: {
                return "Patient";
            }
            case PROVIDER: {
                return "Provider";
            }
            case NONE: {
                return "None";
            }
        }
        return "?";
    }
}

