/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.context;

import ca.uhn.fhir.parser.DataFormatException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r4.conformance.ProfileUtilities;
import org.hl7.fhir.r4.context.BaseWorkerContext;
import org.hl7.fhir.r4.context.HTMLClientLogger;
import org.hl7.fhir.r4.context.IWorkerContext;
import org.hl7.fhir.r4.formats.IParser;
import org.hl7.fhir.r4.formats.JsonParser;
import org.hl7.fhir.r4.formats.ParserType;
import org.hl7.fhir.r4.formats.XmlParser;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.ElementDefinition;
import org.hl7.fhir.r4.model.MetadataResource;
import org.hl7.fhir.r4.model.Questionnaire;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.StructureDefinition;
import org.hl7.fhir.r4.model.StructureMap;
import org.hl7.fhir.r4.terminologies.TerminologyClient;
import org.hl7.fhir.r4.utils.INarrativeGenerator;
import org.hl7.fhir.r4.utils.IResourceValidator;
import org.hl7.fhir.r4.utils.NarrativeGenerator;
import org.hl7.fhir.utilities.CSFileInputStream;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.cache.NpmPackage;
import org.hl7.fhir.utilities.validation.ValidationMessage;

public class SimpleWorkerContext
extends BaseWorkerContext
implements IWorkerContext,
ProfileUtilities.ProfileKnowledgeProvider {
    private Questionnaire questionnaire;
    private Map<String, byte[]> binaries = new HashMap<String, byte[]>();
    private String version;
    private String revision;
    private String date;
    private IValidatorFactory validatorFactory;
    private boolean ignoreProfileErrors;

    public SimpleWorkerContext() throws FileNotFoundException, IOException, FHIRException {
    }

    public SimpleWorkerContext(SimpleWorkerContext other) throws FileNotFoundException, IOException, FHIRException {
        this.copy(other);
    }

    protected void copy(SimpleWorkerContext other) {
        super.copy(other);
        this.questionnaire = other.questionnaire;
        this.binaries.putAll(other.binaries);
        this.version = other.version;
        this.revision = other.revision;
        this.date = other.date;
        this.validatorFactory = other.validatorFactory;
    }

    public static SimpleWorkerContext fromPack(String path) throws FileNotFoundException, IOException, FHIRException {
        SimpleWorkerContext res = new SimpleWorkerContext();
        res.loadFromPack(path, null);
        return res;
    }

    public static SimpleWorkerContext fromPackage(NpmPackage pi, boolean allowDuplicates) throws FileNotFoundException, IOException, FHIRException {
        SimpleWorkerContext res = new SimpleWorkerContext();
        res.setAllowLoadingDuplicates(allowDuplicates);
        res.loadFromPackage(pi, null, new String[0]);
        return res;
    }

    public static SimpleWorkerContext fromPackage(NpmPackage pi) throws FileNotFoundException, IOException, FHIRException {
        SimpleWorkerContext res = new SimpleWorkerContext();
        res.loadFromPackage(pi, null, new String[0]);
        return res;
    }

    public static SimpleWorkerContext fromPackage(NpmPackage pi, IContextResourceLoader loader) throws FileNotFoundException, IOException, FHIRException {
        SimpleWorkerContext res = new SimpleWorkerContext();
        res.setAllowLoadingDuplicates(true);
        res.version = pi.getNpm().get("version").getAsString();
        res.loadFromPackage(pi, loader, new String[0]);
        return res;
    }

    public static SimpleWorkerContext fromPack(String path, boolean allowDuplicates) throws FileNotFoundException, IOException, FHIRException {
        SimpleWorkerContext res = new SimpleWorkerContext();
        res.setAllowLoadingDuplicates(allowDuplicates);
        res.loadFromPack(path, null);
        return res;
    }

    public static SimpleWorkerContext fromPack(String path, IContextResourceLoader loader) throws FileNotFoundException, IOException, FHIRException {
        SimpleWorkerContext res = new SimpleWorkerContext();
        res.loadFromPack(path, loader);
        return res;
    }

    public static SimpleWorkerContext fromClassPath() throws IOException, FHIRException {
        SimpleWorkerContext res = new SimpleWorkerContext();
        res.loadFromStream(SimpleWorkerContext.class.getResourceAsStream("validation.json.zip"), null);
        return res;
    }

    public static SimpleWorkerContext fromClassPath(String name) throws IOException, FHIRException {
        InputStream s = SimpleWorkerContext.class.getResourceAsStream("/" + name);
        SimpleWorkerContext res = new SimpleWorkerContext();
        res.loadFromStream(s, null);
        return res;
    }

    public static SimpleWorkerContext fromDefinitions(Map<String, byte[]> source) throws IOException, FHIRException {
        SimpleWorkerContext res = new SimpleWorkerContext();
        for (String name : source.keySet()) {
            res.loadDefinitionItem(name, new ByteArrayInputStream(source.get(name)), null);
        }
        return res;
    }

    public static SimpleWorkerContext fromDefinitions(Map<String, byte[]> source, IContextResourceLoader loader) throws FileNotFoundException, IOException, FHIRException {
        SimpleWorkerContext res = new SimpleWorkerContext();
        for (String name : source.keySet()) {
            try {
                res.loadDefinitionItem(name, new ByteArrayInputStream(source.get(name)), loader);
            }
            catch (Exception e) {
                System.out.println("Error loading " + name + ": " + e.getMessage());
                throw new FHIRException("Error loading " + name + ": " + e.getMessage(), (Throwable)e);
            }
        }
        return res;
    }

    private void loadDefinitionItem(String name, InputStream stream, IContextResourceLoader loader) throws IOException, FHIRException {
        if (name.endsWith(".xml")) {
            this.loadFromFile(stream, name, loader);
        } else if (name.endsWith(".json")) {
            this.loadFromFileJson(stream, name, loader);
        } else if (name.equals("version.info")) {
            this.readVersionInfo(stream);
        } else {
            this.loadBytes(name, stream);
        }
    }

    public String connectToTSServer(TerminologyClient client, String log) throws URISyntaxException, FHIRException {
        this.tlog("Connect to " + client.getAddress());
        this.txClient = client;
        this.txLog = new HTMLClientLogger(log);
        this.txClient.setLogger(this.txLog);
        return this.txClient.getCapabilitiesStatementQuick().getSoftware().getVersion();
    }

    public void loadFromFile(InputStream stream, String name, IContextResourceLoader loader) throws IOException, FHIRException {
        Resource f;
        try {
            if (loader != null) {
                f = loader.loadBundle(stream, false);
            } else {
                XmlParser xml = new XmlParser();
                f = xml.parse(stream);
            }
        }
        catch (DataFormatException e1) {
            throw new FHIRFormatError("Error parsing " + name + ":" + e1.getMessage(), (Throwable)e1);
        }
        catch (Exception e1) {
            throw new FHIRFormatError("Error parsing " + name + ":" + e1.getMessage(), (Throwable)e1);
        }
        if (f instanceof Bundle) {
            Resource bnd = f;
            for (Bundle.BundleEntryComponent e : ((Bundle)bnd).getEntry()) {
                if (e.getFullUrl() == null) {
                    this.logger.logDebugMessage(IWorkerContext.ILoggingService.LogCategory.CONTEXT, "unidentified resource in " + name + " (no fullUrl)");
                }
                this.cacheResource(e.getResource());
            }
        } else if (f instanceof MetadataResource) {
            MetadataResource m = (MetadataResource)f;
            this.cacheResource(m);
        }
    }

    private void loadFromFileJson(InputStream stream, String name, IContextResourceLoader loader) throws IOException, FHIRException {
        Bundle f = null;
        try {
            if (loader != null) {
                f = loader.loadBundle(stream, true);
            } else {
                JsonParser json = new JsonParser();
                Resource r = json.parse(stream);
                if (r instanceof Bundle) {
                    f = (Bundle)r;
                } else {
                    this.cacheResource(r);
                }
            }
        }
        catch (FHIRFormatError e1) {
            throw new FHIRFormatError(e1.getMessage(), (Throwable)e1);
        }
        if (f != null) {
            for (Bundle.BundleEntryComponent e : f.getEntry()) {
                this.cacheResource(e.getResource());
            }
        }
    }

    private void loadFromPack(String path, IContextResourceLoader loader) throws FileNotFoundException, IOException, FHIRException {
        this.loadFromStream((InputStream)new CSFileInputStream(path), loader);
    }

    public void loadFromPackage(NpmPackage pi, IContextResourceLoader loader, String ... types) throws FileNotFoundException, IOException, FHIRException {
        if (types.length == 0) {
            types = new String[]{"StructureDefinition", "ValueSet", "CodeSystem", "SearchParameter", "OperationDefinition", "Questionnaire", "ConceptMap", "StructureMap", "NamingSystem"};
        }
        for (String s : pi.listResources(types)) {
            this.loadDefinitionItem(s, pi.load("package", s), loader);
        }
        this.version = pi.version();
    }

    public void loadFromFile(String file, IContextResourceLoader loader) throws IOException, FHIRException {
        this.loadDefinitionItem(file, (InputStream)new CSFileInputStream(file), loader);
    }

    private void loadFromStream(InputStream stream, IContextResourceLoader loader) throws IOException, FHIRException {
        ZipEntry ze;
        ZipInputStream zip = new ZipInputStream(stream);
        while ((ze = zip.getNextEntry()) != null) {
            this.loadDefinitionItem(ze.getName(), zip, loader);
            zip.closeEntry();
        }
        zip.close();
    }

    private void readVersionInfo(InputStream stream) throws IOException, DefinitionException {
        String[] vi;
        byte[] bytes = IOUtils.toByteArray((InputStream)stream);
        this.binaries.put("version.info", bytes);
        for (String s : vi = new String(bytes).split("\\r?\\n")) {
            if (s.startsWith("version=")) {
                if (this.version == null) {
                    this.version = s.substring(8);
                } else if (!this.version.equals(s.substring(8))) {
                    throw new DefinitionException("Version mismatch. The context has version " + this.version + " loaded, and the new content being loaded is version " + s.substring(8));
                }
            }
            if (s.startsWith("revision=")) {
                this.revision = s.substring(9);
            }
            if (!s.startsWith("date=")) continue;
            this.date = s.substring(5);
        }
    }

    private void loadBytes(String name, InputStream stream) throws IOException {
        byte[] bytes = IOUtils.toByteArray((InputStream)stream);
        this.binaries.put(name, bytes);
    }

    @Override
    public IParser getParser(ParserType type) {
        switch (type) {
            case JSON: {
                return this.newJsonParser();
            }
            case XML: {
                return this.newXmlParser();
            }
        }
        throw new Error("Parser Type " + type.toString() + " not supported");
    }

    @Override
    public IParser getParser(String type) {
        if (type.equalsIgnoreCase("JSON")) {
            return new JsonParser();
        }
        if (type.equalsIgnoreCase("XML")) {
            return new XmlParser();
        }
        throw new Error("Parser Type " + type.toString() + " not supported");
    }

    @Override
    public IParser newJsonParser() {
        return new JsonParser();
    }

    @Override
    public IParser newXmlParser() {
        return new XmlParser();
    }

    @Override
    public INarrativeGenerator getNarrativeGenerator(String prefix, String basePath) {
        return new NarrativeGenerator(prefix, basePath, this);
    }

    @Override
    public IResourceValidator newValidator() throws FHIRException {
        if (this.validatorFactory == null) {
            throw new Error("No validator configured");
        }
        return this.validatorFactory.makeValidator(this);
    }

    @Override
    public List<String> getResourceNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (StructureDefinition sd : this.listStructures()) {
            if (sd.getKind() != StructureDefinition.StructureDefinitionKind.RESOURCE || sd.getDerivation() != StructureDefinition.TypeDerivationRule.SPECIALIZATION) continue;
            result.add(sd.getName());
        }
        Collections.sort(result);
        return result;
    }

    @Override
    public List<String> getTypeNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (StructureDefinition sd : this.listStructures()) {
            if (sd.getKind() == StructureDefinition.StructureDefinitionKind.LOGICAL || sd.getDerivation() != StructureDefinition.TypeDerivationRule.SPECIALIZATION) continue;
            result.add(sd.getName());
        }
        Collections.sort(result);
        return result;
    }

    @Override
    public String getAbbreviation(String name) {
        return "xxx";
    }

    @Override
    public boolean isDatatype(String typeSimple) {
        return false;
    }

    @Override
    public boolean isResource(String t) {
        StructureDefinition sd;
        try {
            sd = this.fetchResource(StructureDefinition.class, "http://hl7.org/fhir/StructureDefinition/" + t);
        }
        catch (Exception e) {
            return false;
        }
        if (sd == null) {
            return false;
        }
        if (sd.getDerivation() == StructureDefinition.TypeDerivationRule.CONSTRAINT) {
            return false;
        }
        return sd.getKind() == StructureDefinition.StructureDefinitionKind.RESOURCE;
    }

    @Override
    public boolean hasLinkFor(String typeSimple) {
        return false;
    }

    @Override
    public String getLinkFor(String corePath, String typeSimple) {
        return null;
    }

    @Override
    public ProfileUtilities.ProfileKnowledgeProvider.BindingResolution resolveBinding(StructureDefinition profile, ElementDefinition.ElementDefinitionBindingComponent binding, String path) {
        return null;
    }

    @Override
    public ProfileUtilities.ProfileKnowledgeProvider.BindingResolution resolveBinding(StructureDefinition profile, String url, String path) {
        return null;
    }

    @Override
    public String getLinkForProfile(StructureDefinition profile, String url) {
        return null;
    }

    public Questionnaire getQuestionnaire() {
        return this.questionnaire;
    }

    public void setQuestionnaire(Questionnaire questionnaire) {
        this.questionnaire = questionnaire;
    }

    @Override
    public Set<String> typeTails() {
        return new HashSet<String>(Arrays.asList("Integer", "UnsignedInt", "PositiveInt", "Decimal", "DateTime", "Date", "Time", "Instant", "String", "Uri", "Url", "Canonical", "Oid", "Uuid", "Id", "Boolean", "Code", "Markdown", "Base64Binary", "Coding", "CodeableConcept", "Attachment", "Identifier", "Quantity", "SampledData", "Range", "Period", "Ratio", "HumanName", "Address", "ContactPoint", "Timing", "Reference", "Annotation", "Signature", "Meta"));
    }

    @Override
    public List<StructureDefinition> allStructures() {
        ArrayList<StructureDefinition> result = new ArrayList<StructureDefinition>();
        HashSet<StructureDefinition> set = new HashSet<StructureDefinition>();
        for (StructureDefinition sd : this.listStructures()) {
            if (set.contains(sd)) continue;
            try {
                this.generateSnapshot(sd);
            }
            catch (Exception e) {
                System.out.println("Unable to generate snapshot for " + sd.getUrl() + " because " + e.getMessage());
            }
            result.add(sd);
            set.add(sd);
        }
        return result;
    }

    public void loadBinariesFromFolder(String folder) throws FileNotFoundException, Exception {
        for (String n : new File(folder).list()) {
            this.loadBytes(n, new FileInputStream(Utilities.path((String[])new String[]{folder, n})));
        }
    }

    public void loadBinariesFromFolder(NpmPackage pi) throws FileNotFoundException, Exception {
        for (String n : pi.list("other")) {
            this.loadBytes(n, pi.load("other", n));
        }
    }

    public void loadFromFolder(String folder) throws FileNotFoundException, Exception {
        for (String n : new File(folder).list()) {
            if (n.endsWith(".json")) {
                this.loadFromFile(Utilities.path((String[])new String[]{folder, n}), new JsonParser());
                continue;
            }
            if (!n.endsWith(".xml")) continue;
            this.loadFromFile(Utilities.path((String[])new String[]{folder, n}), new XmlParser());
        }
    }

    private void loadFromFile(String filename, IParser p) throws FileNotFoundException, Exception {
        try {
            Resource r = p.parse(new FileInputStream(filename));
            if (r.getResourceType() == ResourceType.Bundle) {
                for (Bundle.BundleEntryComponent e : ((Bundle)r).getEntry()) {
                    this.cacheResource(e.getResource());
                }
            } else {
                this.cacheResource(r);
            }
        }
        catch (Exception e) {
            return;
        }
    }

    public Map<String, byte[]> getBinaries() {
        return this.binaries;
    }

    @Override
    public boolean prependLinks() {
        return false;
    }

    @Override
    public boolean hasCache() {
        return false;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public List<StructureMap> findTransformsforSource(String url) {
        ArrayList<StructureMap> res = new ArrayList<StructureMap>();
        for (StructureMap map : this.listTransforms()) {
            boolean match = false;
            boolean ok = true;
            for (StructureMap.StructureMapStructureComponent t : map.getStructure()) {
                if (t.getMode() != StructureMap.StructureMapModelMode.SOURCE) continue;
                match = match || t.getUrl().equals(url);
                ok = ok && t.getUrl().equals(url);
            }
            if (!match || !ok) continue;
            res.add(map);
        }
        return res;
    }

    public IValidatorFactory getValidatorFactory() {
        return this.validatorFactory;
    }

    public void setValidatorFactory(IValidatorFactory validatorFactory) {
        this.validatorFactory = validatorFactory;
    }

    @Override
    public <T extends Resource> T fetchResource(Class<T> class_, String uri) {
        T r = super.fetchResource(class_, uri);
        if (r instanceof StructureDefinition) {
            StructureDefinition p = (StructureDefinition)r;
            try {
                this.generateSnapshot(p);
            }
            catch (Exception e) {
                System.out.println("Unable to generate snapshot for " + uri + ": " + e.getMessage());
            }
        }
        return r;
    }

    @Override
    public void generateSnapshot(StructureDefinition p) throws DefinitionException, FHIRException {
        if (!p.hasSnapshot() && p.getKind() != StructureDefinition.StructureDefinitionKind.LOGICAL) {
            if (!p.hasBaseDefinition()) {
                throw new DefinitionException("Profile " + p.getName() + " (" + p.getUrl() + ") has no base and no snapshot");
            }
            StructureDefinition sd = this.fetchResource(StructureDefinition.class, p.getBaseDefinition());
            if (sd == null) {
                throw new DefinitionException("Profile " + p.getName() + " (" + p.getUrl() + ") base " + p.getBaseDefinition() + " could not be resolved");
            }
            ArrayList<ValidationMessage> msgs = new ArrayList<ValidationMessage>();
            ArrayList<String> errors = new ArrayList<String>();
            ProfileUtilities pu = new ProfileUtilities(this, msgs, this);
            pu.setThrowException(false);
            pu.sortDifferential(sd, p, p.getUrl(), errors);
            for (String err : errors) {
                msgs.add(new ValidationMessage(ValidationMessage.Source.ProfileValidator, ValidationMessage.IssueType.EXCEPTION, p.getUserString("path"), "Error sorting Differential: " + err, ValidationMessage.IssueSeverity.ERROR));
            }
            pu.generateSnapshot(sd, p, p.getUrl(), Utilities.extractBaseUrl((String)sd.getUserString("path")), p.getName());
            for (ValidationMessage msg : msgs) {
                if ((this.ignoreProfileErrors || msg.getLevel() != ValidationMessage.IssueSeverity.ERROR) && msg.getLevel() != ValidationMessage.IssueSeverity.FATAL) continue;
                throw new DefinitionException("Profile " + p.getName() + " (" + p.getUrl() + "). Error generating snapshot: " + msg.getMessage());
            }
            if (!p.hasSnapshot()) {
                throw new FHIRException("Profile " + p.getName() + " (" + p.getUrl() + "). Error generating snapshot");
            }
            pu = null;
        }
    }

    public boolean isIgnoreProfileErrors() {
        return this.ignoreProfileErrors;
    }

    public void setIgnoreProfileErrors(boolean ignoreProfileErrors) {
        this.ignoreProfileErrors = ignoreProfileErrors;
    }

    public String listMapUrls() {
        return Utilities.listCanonicalUrls(this.transforms.keySet());
    }

    public static interface IValidatorFactory {
        public IResourceValidator makeValidator(IWorkerContext var1) throws FHIRException;
    }

    public static interface IContextResourceLoader {
        public Bundle loadBundle(InputStream var1, boolean var2) throws FHIRException, IOException;
    }
}

