/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4.model.Annotation;
import org.hl7.fhir.r4.model.BackboneElement;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.Device;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.Encounter;
import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Group;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Location;
import org.hl7.fhir.r4.model.Patient;
import org.hl7.fhir.r4.model.Practitioner;
import org.hl7.fhir.r4.model.PractitionerRole;
import org.hl7.fhir.r4.model.PrimitiveType;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="List", profile="http://hl7.org/fhir/StructureDefinition/ListResource")
public class ListResource
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Business identifier", formalDefinition="Identifier for the List assigned for business purposes outside the context of FHIR.")
    protected List<Identifier> identifier;
    @Child(name="status", type={CodeType.class}, order=1, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="current | retired | entered-in-error", formalDefinition="Indicates the current state of this list.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/list-status")
    protected Enumeration<ListStatus> status;
    @Child(name="mode", type={CodeType.class}, order=2, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="working | snapshot | changes", formalDefinition="How this list was prepared - whether it is a working list that is suitable for being maintained on an ongoing basis, or if it represents a snapshot of a list of items from another source, or whether it is a prepared list where items may be marked as added, modified or deleted.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/list-mode")
    protected Enumeration<ListMode> mode;
    @Child(name="title", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Descriptive name for the list", formalDefinition="A label for the list assigned by the author.")
    protected StringType title;
    @Child(name="code", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="What the purpose of this list is", formalDefinition="This code defines the purpose of the list - why it was created.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/list-example-codes")
    protected CodeableConcept code;
    @Child(name="subject", type={Patient.class, Group.class, Device.class, Location.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="If all resources have the same subject", formalDefinition="The common subject (or patient) of the resources that are in the list if there is one.")
    protected Reference subject;
    protected Resource subjectTarget;
    @Child(name="encounter", type={Encounter.class}, order=6, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Context in which list created", formalDefinition="The encounter that is the context in which this list was created.")
    protected Reference encounter;
    protected Encounter encounterTarget;
    @Child(name="date", type={DateTimeType.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When the list was prepared", formalDefinition="The date that the list was prepared.")
    protected DateTimeType date;
    @Child(name="source", type={Practitioner.class, PractitionerRole.class, Patient.class, Device.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who and/or what defined the list contents (aka Author)", formalDefinition="The entity responsible for deciding what the contents of the list were. Where the list was created by a human, this is the same as the author of the list.")
    protected Reference source;
    protected Resource sourceTarget;
    @Child(name="orderedBy", type={CodeableConcept.class}, order=9, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="What order the list has", formalDefinition="What order applies to the items in the list.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/list-order")
    protected CodeableConcept orderedBy;
    @Child(name="note", type={Annotation.class}, order=10, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Comments about the list", formalDefinition="Comments that apply to the overall list.")
    protected List<Annotation> note;
    @Child(name="entry", type={}, order=11, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Entries in the list", formalDefinition="Entries in this list.")
    protected List<ListEntryComponent> entry;
    @Child(name="emptyReason", type={CodeableConcept.class}, order=12, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Why list is empty", formalDefinition="If the list is empty, why the list is empty.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/list-empty-reason")
    protected CodeableConcept emptyReason;
    private static final long serialVersionUID = 2071342704L;
    @SearchParamDefinition(name="date", path="List.date", description="When the list was prepared", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="identifier", path="List.identifier", description="Business identifier", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="item", path="List.entry.item", description="Actual entry", type="reference")
    public static final String SP_ITEM = "item";
    public static final ReferenceClientParam ITEM = new ReferenceClientParam("item");
    public static final Include INCLUDE_ITEM = new Include("ListResource:item").toLocked();
    @SearchParamDefinition(name="empty-reason", path="List.emptyReason", description="Why list is empty", type="token")
    public static final String SP_EMPTY_REASON = "empty-reason";
    public static final TokenClientParam EMPTY_REASON = new TokenClientParam("empty-reason");
    @SearchParamDefinition(name="code", path="List.code", description="What the purpose of this list is", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="notes", path="List.note.text", description="The annotation  - text content (as markdown)", type="string")
    public static final String SP_NOTES = "notes";
    public static final StringClientParam NOTES = new StringClientParam("notes");
    @SearchParamDefinition(name="subject", path="List.subject", description="If all resources have the same subject", type="reference", target={Device.class, Group.class, Location.class, Patient.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("ListResource:subject").toLocked();
    @SearchParamDefinition(name="patient", path="List.subject.where(resolve() is Patient)", description="If all resources have the same subject", type="reference", target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("ListResource:patient").toLocked();
    @SearchParamDefinition(name="source", path="List.source", description="Who and/or what defined the list contents (aka Author)", type="reference", target={Device.class, Patient.class, Practitioner.class, PractitionerRole.class})
    public static final String SP_SOURCE = "source";
    public static final ReferenceClientParam SOURCE = new ReferenceClientParam("source");
    public static final Include INCLUDE_SOURCE = new Include("ListResource:source").toLocked();
    @SearchParamDefinition(name="encounter", path="List.encounter", description="Context in which list created", type="reference", target={Encounter.class})
    public static final String SP_ENCOUNTER = "encounter";
    public static final ReferenceClientParam ENCOUNTER = new ReferenceClientParam("encounter");
    public static final Include INCLUDE_ENCOUNTER = new Include("ListResource:encounter").toLocked();
    @SearchParamDefinition(name="title", path="List.title", description="Descriptive name for the list", type="string")
    public static final String SP_TITLE = "title";
    public static final StringClientParam TITLE = new StringClientParam("title");
    @SearchParamDefinition(name="status", path="List.status", description="current | retired | entered-in-error", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public ListResource() {
    }

    public ListResource(Enumeration<ListStatus> status, Enumeration<ListMode> mode) {
        this.status = status;
        this.mode = mode;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public ListResource setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public ListResource addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Enumeration<ListStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ListResource.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<ListStatus>(new ListStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public ListResource setStatusElement(Enumeration<ListStatus> value) {
        this.status = value;
        return this;
    }

    public ListStatus getStatus() {
        return this.status == null ? null : (ListStatus)((Object)this.status.getValue());
    }

    public ListResource setStatus(ListStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<ListStatus>(new ListStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public Enumeration<ListMode> getModeElement() {
        if (this.mode == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ListResource.mode");
            }
            if (Configuration.doAutoCreate()) {
                this.mode = new Enumeration<ListMode>(new ListModeEnumFactory());
            }
        }
        return this.mode;
    }

    public boolean hasModeElement() {
        return this.mode != null && !this.mode.isEmpty();
    }

    public boolean hasMode() {
        return this.mode != null && !this.mode.isEmpty();
    }

    public ListResource setModeElement(Enumeration<ListMode> value) {
        this.mode = value;
        return this;
    }

    public ListMode getMode() {
        return this.mode == null ? null : (ListMode)((Object)this.mode.getValue());
    }

    public ListResource setMode(ListMode value) {
        if (this.mode == null) {
            this.mode = new Enumeration<ListMode>(new ListModeEnumFactory());
        }
        this.mode.setValue((Object)value);
        return this;
    }

    public StringType getTitleElement() {
        if (this.title == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ListResource.title");
            }
            if (Configuration.doAutoCreate()) {
                this.title = new StringType();
            }
        }
        return this.title;
    }

    public boolean hasTitleElement() {
        return this.title != null && !this.title.isEmpty();
    }

    public boolean hasTitle() {
        return this.title != null && !this.title.isEmpty();
    }

    public ListResource setTitleElement(StringType value) {
        this.title = value;
        return this;
    }

    public String getTitle() {
        return this.title == null ? null : (String)this.title.getValue();
    }

    public ListResource setTitle(String value) {
        if (Utilities.noString((String)value)) {
            this.title = null;
        } else {
            if (this.title == null) {
                this.title = new StringType();
            }
            this.title.setValue(value);
        }
        return this;
    }

    public CodeableConcept getCode() {
        if (this.code == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ListResource.code");
            }
            if (Configuration.doAutoCreate()) {
                this.code = new CodeableConcept();
            }
        }
        return this.code;
    }

    public boolean hasCode() {
        return this.code != null && !this.code.isEmpty();
    }

    public ListResource setCode(CodeableConcept value) {
        this.code = value;
        return this;
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ListResource.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public ListResource setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public Resource getSubjectTarget() {
        return this.subjectTarget;
    }

    public ListResource setSubjectTarget(Resource value) {
        this.subjectTarget = value;
        return this;
    }

    public Reference getEncounter() {
        if (this.encounter == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ListResource.encounter");
            }
            if (Configuration.doAutoCreate()) {
                this.encounter = new Reference();
            }
        }
        return this.encounter;
    }

    public boolean hasEncounter() {
        return this.encounter != null && !this.encounter.isEmpty();
    }

    public ListResource setEncounter(Reference value) {
        this.encounter = value;
        return this;
    }

    public Encounter getEncounterTarget() {
        if (this.encounterTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ListResource.encounter");
            }
            if (Configuration.doAutoCreate()) {
                this.encounterTarget = new Encounter();
            }
        }
        return this.encounterTarget;
    }

    public ListResource setEncounterTarget(Encounter value) {
        this.encounterTarget = value;
        return this;
    }

    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ListResource.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    public ListResource setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    public ListResource setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    public Reference getSource() {
        if (this.source == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ListResource.source");
            }
            if (Configuration.doAutoCreate()) {
                this.source = new Reference();
            }
        }
        return this.source;
    }

    public boolean hasSource() {
        return this.source != null && !this.source.isEmpty();
    }

    public ListResource setSource(Reference value) {
        this.source = value;
        return this;
    }

    public Resource getSourceTarget() {
        return this.sourceTarget;
    }

    public ListResource setSourceTarget(Resource value) {
        this.sourceTarget = value;
        return this;
    }

    public CodeableConcept getOrderedBy() {
        if (this.orderedBy == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ListResource.orderedBy");
            }
            if (Configuration.doAutoCreate()) {
                this.orderedBy = new CodeableConcept();
            }
        }
        return this.orderedBy;
    }

    public boolean hasOrderedBy() {
        return this.orderedBy != null && !this.orderedBy.isEmpty();
    }

    public ListResource setOrderedBy(CodeableConcept value) {
        this.orderedBy = value;
        return this;
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public ListResource setNote(List<Annotation> theNote) {
        this.note = theNote;
        return this;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public ListResource addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public Annotation getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            this.addNote();
        }
        return this.getNote().get(0);
    }

    public List<ListEntryComponent> getEntry() {
        if (this.entry == null) {
            this.entry = new ArrayList<ListEntryComponent>();
        }
        return this.entry;
    }

    public ListResource setEntry(List<ListEntryComponent> theEntry) {
        this.entry = theEntry;
        return this;
    }

    public boolean hasEntry() {
        if (this.entry == null) {
            return false;
        }
        for (ListEntryComponent item : this.entry) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ListEntryComponent addEntry() {
        ListEntryComponent t = new ListEntryComponent();
        if (this.entry == null) {
            this.entry = new ArrayList<ListEntryComponent>();
        }
        this.entry.add(t);
        return t;
    }

    public ListResource addEntry(ListEntryComponent t) {
        if (t == null) {
            return this;
        }
        if (this.entry == null) {
            this.entry = new ArrayList<ListEntryComponent>();
        }
        this.entry.add(t);
        return this;
    }

    public ListEntryComponent getEntryFirstRep() {
        if (this.getEntry().isEmpty()) {
            this.addEntry();
        }
        return this.getEntry().get(0);
    }

    public CodeableConcept getEmptyReason() {
        if (this.emptyReason == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ListResource.emptyReason");
            }
            if (Configuration.doAutoCreate()) {
                this.emptyReason = new CodeableConcept();
            }
        }
        return this.emptyReason;
    }

    public boolean hasEmptyReason() {
        return this.emptyReason != null && !this.emptyReason.isEmpty();
    }

    public ListResource setEmptyReason(CodeableConcept value) {
        this.emptyReason = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Identifier for the List assigned for business purposes outside the context of FHIR.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_STATUS, SP_CODE, "Indicates the current state of this list.", 0, 1, this.status));
        children.add(new Property("mode", SP_CODE, "How this list was prepared - whether it is a working list that is suitable for being maintained on an ongoing basis, or if it represents a snapshot of a list of items from another source, or whether it is a prepared list where items may be marked as added, modified or deleted.", 0, 1, this.mode));
        children.add(new Property(SP_TITLE, "string", "A label for the list assigned by the author.", 0, 1, this.title));
        children.add(new Property(SP_CODE, "CodeableConcept", "This code defines the purpose of the list - why it was created.", 0, 1, this.code));
        children.add(new Property(SP_SUBJECT, "Reference(Patient|Group|Device|Location)", "The common subject (or patient) of the resources that are in the list if there is one.", 0, 1, this.subject));
        children.add(new Property(SP_ENCOUNTER, "Reference(Encounter)", "The encounter that is the context in which this list was created.", 0, 1, this.encounter));
        children.add(new Property(SP_DATE, "dateTime", "The date that the list was prepared.", 0, 1, this.date));
        children.add(new Property(SP_SOURCE, "Reference(Practitioner|PractitionerRole|Patient|Device)", "The entity responsible for deciding what the contents of the list were. Where the list was created by a human, this is the same as the author of the list.", 0, 1, this.source));
        children.add(new Property("orderedBy", "CodeableConcept", "What order applies to the items in the list.", 0, 1, this.orderedBy));
        children.add(new Property("note", "Annotation", "Comments that apply to the overall list.", 0, Integer.MAX_VALUE, this.note));
        children.add(new Property("entry", "", "Entries in this list.", 0, Integer.MAX_VALUE, this.entry));
        children.add(new Property("emptyReason", "CodeableConcept", "If the list is empty, why the list is empty.", 0, 1, this.emptyReason));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Identifier for the List assigned for business purposes outside the context of FHIR.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -892481550: {
                return new Property(SP_STATUS, SP_CODE, "Indicates the current state of this list.", 0, 1, this.status);
            }
            case 0x3339A3: {
                return new Property("mode", SP_CODE, "How this list was prepared - whether it is a working list that is suitable for being maintained on an ongoing basis, or if it represents a snapshot of a list of items from another source, or whether it is a prepared list where items may be marked as added, modified or deleted.", 0, 1, this.mode);
            }
            case 110371416: {
                return new Property(SP_TITLE, "string", "A label for the list assigned by the author.", 0, 1, this.title);
            }
            case 3059181: {
                return new Property(SP_CODE, "CodeableConcept", "This code defines the purpose of the list - why it was created.", 0, 1, this.code);
            }
            case -1867885268: {
                return new Property(SP_SUBJECT, "Reference(Patient|Group|Device|Location)", "The common subject (or patient) of the resources that are in the list if there is one.", 0, 1, this.subject);
            }
            case 1524132147: {
                return new Property(SP_ENCOUNTER, "Reference(Encounter)", "The encounter that is the context in which this list was created.", 0, 1, this.encounter);
            }
            case 3076014: {
                return new Property(SP_DATE, "dateTime", "The date that the list was prepared.", 0, 1, this.date);
            }
            case -896505829: {
                return new Property(SP_SOURCE, "Reference(Practitioner|PractitionerRole|Patient|Device)", "The entity responsible for deciding what the contents of the list were. Where the list was created by a human, this is the same as the author of the list.", 0, 1, this.source);
            }
            case -391079516: {
                return new Property("orderedBy", "CodeableConcept", "What order applies to the items in the list.", 0, 1, this.orderedBy);
            }
            case 3387378: {
                return new Property("note", "Annotation", "Comments that apply to the overall list.", 0, Integer.MAX_VALUE, this.note);
            }
            case 96667762: {
                return new Property("entry", "", "Entries in this list.", 0, Integer.MAX_VALUE, this.entry);
            }
            case 1140135409: {
                return new Property("emptyReason", "CodeableConcept", "If the list is empty, why the list is empty.", 0, 1, this.emptyReason);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case 0x3339A3: {
                Base[] baseArray;
                if (this.mode == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.mode;
                }
                return baseArray;
            }
            case 110371416: {
                Base[] baseArray;
                if (this.title == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.title;
                }
                return baseArray;
            }
            case 3059181: {
                Base[] baseArray;
                if (this.code == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.code;
                }
                return baseArray;
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.subject;
                }
                return baseArray;
            }
            case 1524132147: {
                Base[] baseArray;
                if (this.encounter == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.encounter;
                }
                return baseArray;
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.date;
                }
                return baseArray;
            }
            case -896505829: {
                Base[] baseArray;
                if (this.source == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.source;
                }
                return baseArray;
            }
            case -391079516: {
                Base[] baseArray;
                if (this.orderedBy == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.orderedBy;
                }
                return baseArray;
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
            case 96667762: {
                return this.entry == null ? new Base[]{} : this.entry.toArray(new Base[this.entry.size()]);
            }
            case 1140135409: {
                Base[] baseArray;
                if (this.emptyReason == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.emptyReason;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case -892481550: {
                value = new ListStatusEnumFactory().fromType(this.castToCode(value));
                this.status = value;
                return value;
            }
            case 0x3339A3: {
                value = new ListModeEnumFactory().fromType(this.castToCode(value));
                this.mode = value;
                return value;
            }
            case 110371416: {
                this.title = this.castToString(value);
                return value;
            }
            case 3059181: {
                this.code = this.castToCodeableConcept(value);
                return value;
            }
            case -1867885268: {
                this.subject = this.castToReference(value);
                return value;
            }
            case 1524132147: {
                this.encounter = this.castToReference(value);
                return value;
            }
            case 3076014: {
                this.date = this.castToDateTime(value);
                return value;
            }
            case -896505829: {
                this.source = this.castToReference(value);
                return value;
            }
            case -391079516: {
                this.orderedBy = this.castToCodeableConcept(value);
                return value;
            }
            case 3387378: {
                this.getNote().add(this.castToAnnotation(value));
                return value;
            }
            case 96667762: {
                this.getEntry().add((ListEntryComponent)((Object)value));
                return value;
            }
            case 1140135409: {
                this.emptyReason = this.castToCodeableConcept(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_STATUS)) {
            value = new ListStatusEnumFactory().fromType(this.castToCode(value));
            this.status = value;
        } else if (name.equals("mode")) {
            value = new ListModeEnumFactory().fromType(this.castToCode(value));
            this.mode = value;
        } else if (name.equals(SP_TITLE)) {
            this.title = this.castToString(value);
        } else if (name.equals(SP_CODE)) {
            this.code = this.castToCodeableConcept(value);
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = this.castToReference(value);
        } else if (name.equals(SP_ENCOUNTER)) {
            this.encounter = this.castToReference(value);
        } else if (name.equals(SP_DATE)) {
            this.date = this.castToDateTime(value);
        } else if (name.equals(SP_SOURCE)) {
            this.source = this.castToReference(value);
        } else if (name.equals("orderedBy")) {
            this.orderedBy = this.castToCodeableConcept(value);
        } else if (name.equals("note")) {
            this.getNote().add(this.castToAnnotation(value));
        } else if (name.equals("entry")) {
            this.getEntry().add((ListEntryComponent)((Object)value));
        } else if (name.equals("emptyReason")) {
            this.emptyReason = this.castToCodeableConcept(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 0x3339A3: {
                return this.getModeElement();
            }
            case 110371416: {
                return this.getTitleElement();
            }
            case 3059181: {
                return this.getCode();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case 1524132147: {
                return this.getEncounter();
            }
            case 3076014: {
                return this.getDateElement();
            }
            case -896505829: {
                return this.getSource();
            }
            case -391079516: {
                return this.getOrderedBy();
            }
            case 3387378: {
                return this.addNote();
            }
            case 96667762: {
                return this.addEntry();
            }
            case 1140135409: {
                return this.getEmptyReason();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -892481550: {
                return new String[]{SP_CODE};
            }
            case 0x3339A3: {
                return new String[]{SP_CODE};
            }
            case 110371416: {
                return new String[]{"string"};
            }
            case 3059181: {
                return new String[]{"CodeableConcept"};
            }
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case 1524132147: {
                return new String[]{"Reference"};
            }
            case 3076014: {
                return new String[]{"dateTime"};
            }
            case -896505829: {
                return new String[]{"Reference"};
            }
            case -391079516: {
                return new String[]{"CodeableConcept"};
            }
            case 3387378: {
                return new String[]{"Annotation"};
            }
            case 96667762: {
                return new String[0];
            }
            case 1140135409: {
                return new String[]{"CodeableConcept"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type ListResource.status");
        }
        if (name.equals("mode")) {
            throw new FHIRException("Cannot call addChild on a primitive type ListResource.mode");
        }
        if (name.equals(SP_TITLE)) {
            throw new FHIRException("Cannot call addChild on a primitive type ListResource.title");
        }
        if (name.equals(SP_CODE)) {
            this.code = new CodeableConcept();
            return this.code;
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals(SP_ENCOUNTER)) {
            this.encounter = new Reference();
            return this.encounter;
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a primitive type ListResource.date");
        }
        if (name.equals(SP_SOURCE)) {
            this.source = new Reference();
            return this.source;
        }
        if (name.equals("orderedBy")) {
            this.orderedBy = new CodeableConcept();
            return this.orderedBy;
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        if (name.equals("entry")) {
            return this.addEntry();
        }
        if (name.equals("emptyReason")) {
            this.emptyReason = new CodeableConcept();
            return this.emptyReason;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "List";
    }

    @Override
    public ListResource copy() {
        ListResource dst = new ListResource();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(ListResource dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        dst.mode = this.mode == null ? null : this.mode.copy();
        dst.title = this.title == null ? null : this.title.copy();
        dst.code = this.code == null ? null : this.code.copy();
        dst.subject = this.subject == null ? null : this.subject.copy();
        dst.encounter = this.encounter == null ? null : this.encounter.copy();
        dst.date = this.date == null ? null : this.date.copy();
        dst.source = this.source == null ? null : this.source.copy();
        CodeableConcept codeableConcept = dst.orderedBy = this.orderedBy == null ? null : this.orderedBy.copy();
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
        if (this.entry != null) {
            dst.entry = new ArrayList<ListEntryComponent>();
            for (ListEntryComponent listEntryComponent : this.entry) {
                dst.entry.add(listEntryComponent.copy());
            }
        }
        dst.emptyReason = this.emptyReason == null ? null : this.emptyReason.copy();
    }

    protected ListResource typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof ListResource)) {
            return false;
        }
        ListResource o = (ListResource)other_;
        return ListResource.compareDeep(this.identifier, o.identifier, true) && ListResource.compareDeep(this.status, o.status, true) && ListResource.compareDeep(this.mode, o.mode, true) && ListResource.compareDeep(this.title, o.title, true) && ListResource.compareDeep(this.code, o.code, true) && ListResource.compareDeep(this.subject, o.subject, true) && ListResource.compareDeep(this.encounter, o.encounter, true) && ListResource.compareDeep(this.date, o.date, true) && ListResource.compareDeep(this.source, o.source, true) && ListResource.compareDeep(this.orderedBy, o.orderedBy, true) && ListResource.compareDeep(this.note, o.note, true) && ListResource.compareDeep(this.entry, o.entry, true) && ListResource.compareDeep(this.emptyReason, o.emptyReason, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof ListResource)) {
            return false;
        }
        ListResource o = (ListResource)other_;
        return ListResource.compareValues(this.status, o.status, true) && ListResource.compareValues(this.mode, o.mode, true) && ListResource.compareValues(this.title, o.title, true) && ListResource.compareValues(this.date, o.date, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.status, this.mode, this.title, this.code, this.subject, this.encounter, this.date, this.source, this.orderedBy, this.note, this.entry, this.emptyReason});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.List;
    }

    @Block
    public static class ListEntryComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="flag", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Status/Workflow information about this item", formalDefinition="The flag allows the system constructing the list to indicate the role and significance of the item in the list.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/list-item-flag")
        protected CodeableConcept flag;
        @Child(name="deleted", type={BooleanType.class}, order=2, min=0, max=1, modifier=true, summary=false)
        @Description(shortDefinition="If this item is actually marked as deleted", formalDefinition="True if this item is marked as deleted in the list.")
        protected BooleanType deleted;
        @Child(name="date", type={DateTimeType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="When item added to list", formalDefinition="When this item was added to the list.")
        protected DateTimeType date;
        @Child(name="item", type={Reference.class}, order=4, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Actual entry", formalDefinition="A reference to the actual resource from which data was derived.")
        protected Reference item;
        protected Resource itemTarget;
        private static final long serialVersionUID = -758164425L;

        public ListEntryComponent() {
        }

        public ListEntryComponent(Reference item) {
            this.item = item;
        }

        public CodeableConcept getFlag() {
            if (this.flag == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ListEntryComponent.flag");
                }
                if (Configuration.doAutoCreate()) {
                    this.flag = new CodeableConcept();
                }
            }
            return this.flag;
        }

        public boolean hasFlag() {
            return this.flag != null && !this.flag.isEmpty();
        }

        public ListEntryComponent setFlag(CodeableConcept value) {
            this.flag = value;
            return this;
        }

        public BooleanType getDeletedElement() {
            if (this.deleted == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ListEntryComponent.deleted");
                }
                if (Configuration.doAutoCreate()) {
                    this.deleted = new BooleanType();
                }
            }
            return this.deleted;
        }

        public boolean hasDeletedElement() {
            return this.deleted != null && !this.deleted.isEmpty();
        }

        public boolean hasDeleted() {
            return this.deleted != null && !this.deleted.isEmpty();
        }

        public ListEntryComponent setDeletedElement(BooleanType value) {
            this.deleted = value;
            return this;
        }

        public boolean getDeleted() {
            return this.deleted == null || this.deleted.isEmpty() ? false : (Boolean)this.deleted.getValue();
        }

        public ListEntryComponent setDeleted(boolean value) {
            if (this.deleted == null) {
                this.deleted = new BooleanType();
            }
            this.deleted.setValue((Object)value);
            return this;
        }

        public DateTimeType getDateElement() {
            if (this.date == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ListEntryComponent.date");
                }
                if (Configuration.doAutoCreate()) {
                    this.date = new DateTimeType();
                }
            }
            return this.date;
        }

        public boolean hasDateElement() {
            return this.date != null && !this.date.isEmpty();
        }

        public boolean hasDate() {
            return this.date != null && !this.date.isEmpty();
        }

        public ListEntryComponent setDateElement(DateTimeType value) {
            this.date = value;
            return this;
        }

        public Date getDate() {
            return this.date == null ? null : (Date)this.date.getValue();
        }

        public ListEntryComponent setDate(Date value) {
            if (value == null) {
                this.date = null;
            } else {
                if (this.date == null) {
                    this.date = new DateTimeType();
                }
                this.date.setValue(value);
            }
            return this;
        }

        public Reference getItem() {
            if (this.item == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ListEntryComponent.item");
                }
                if (Configuration.doAutoCreate()) {
                    this.item = new Reference();
                }
            }
            return this.item;
        }

        public boolean hasItem() {
            return this.item != null && !this.item.isEmpty();
        }

        public ListEntryComponent setItem(Reference value) {
            this.item = value;
            return this;
        }

        public Resource getItemTarget() {
            return this.itemTarget;
        }

        public ListEntryComponent setItemTarget(Resource value) {
            this.itemTarget = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("flag", "CodeableConcept", "The flag allows the system constructing the list to indicate the role and significance of the item in the list.", 0, 1, this.flag));
            children.add(new Property("deleted", "boolean", "True if this item is marked as deleted in the list.", 0, 1, this.deleted));
            children.add(new Property(ListResource.SP_DATE, "dateTime", "When this item was added to the list.", 0, 1, this.date));
            children.add(new Property(ListResource.SP_ITEM, "Reference(Any)", "A reference to the actual resource from which data was derived.", 0, 1, this.item));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3145580: {
                    return new Property("flag", "CodeableConcept", "The flag allows the system constructing the list to indicate the role and significance of the item in the list.", 0, 1, this.flag);
                }
                case 1550463001: {
                    return new Property("deleted", "boolean", "True if this item is marked as deleted in the list.", 0, 1, this.deleted);
                }
                case 3076014: {
                    return new Property(ListResource.SP_DATE, "dateTime", "When this item was added to the list.", 0, 1, this.date);
                }
                case 3242771: {
                    return new Property(ListResource.SP_ITEM, "Reference(Any)", "A reference to the actual resource from which data was derived.", 0, 1, this.item);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3145580: {
                    Base[] baseArray;
                    if (this.flag == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.flag;
                    }
                    return baseArray;
                }
                case 1550463001: {
                    Base[] baseArray;
                    if (this.deleted == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.deleted;
                    }
                    return baseArray;
                }
                case 3076014: {
                    Base[] baseArray;
                    if (this.date == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.date;
                    }
                    return baseArray;
                }
                case 3242771: {
                    Base[] baseArray;
                    if (this.item == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.item;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3145580: {
                    this.flag = this.castToCodeableConcept(value);
                    return value;
                }
                case 1550463001: {
                    this.deleted = this.castToBoolean(value);
                    return value;
                }
                case 3076014: {
                    this.date = this.castToDateTime(value);
                    return value;
                }
                case 3242771: {
                    this.item = this.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("flag")) {
                this.flag = this.castToCodeableConcept(value);
            } else if (name.equals("deleted")) {
                this.deleted = this.castToBoolean(value);
            } else if (name.equals(ListResource.SP_DATE)) {
                this.date = this.castToDateTime(value);
            } else if (name.equals(ListResource.SP_ITEM)) {
                this.item = this.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3145580: {
                    return this.getFlag();
                }
                case 1550463001: {
                    return this.getDeletedElement();
                }
                case 3076014: {
                    return this.getDateElement();
                }
                case 3242771: {
                    return this.getItem();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3145580: {
                    return new String[]{"CodeableConcept"};
                }
                case 1550463001: {
                    return new String[]{"boolean"};
                }
                case 3076014: {
                    return new String[]{"dateTime"};
                }
                case 3242771: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("flag")) {
                this.flag = new CodeableConcept();
                return this.flag;
            }
            if (name.equals("deleted")) {
                throw new FHIRException("Cannot call addChild on a primitive type ListResource.deleted");
            }
            if (name.equals(ListResource.SP_DATE)) {
                throw new FHIRException("Cannot call addChild on a primitive type ListResource.date");
            }
            if (name.equals(ListResource.SP_ITEM)) {
                this.item = new Reference();
                return this.item;
            }
            return super.addChild(name);
        }

        @Override
        public ListEntryComponent copy() {
            ListEntryComponent dst = new ListEntryComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ListEntryComponent dst) {
            super.copyValues(dst);
            dst.flag = this.flag == null ? null : this.flag.copy();
            dst.deleted = this.deleted == null ? null : this.deleted.copy();
            dst.date = this.date == null ? null : this.date.copy();
            dst.item = this.item == null ? null : this.item.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ListEntryComponent)) {
                return false;
            }
            ListEntryComponent o = (ListEntryComponent)other_;
            return ListEntryComponent.compareDeep(this.flag, o.flag, true) && ListEntryComponent.compareDeep(this.deleted, o.deleted, true) && ListEntryComponent.compareDeep(this.date, o.date, true) && ListEntryComponent.compareDeep(this.item, o.item, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ListEntryComponent)) {
                return false;
            }
            ListEntryComponent o = (ListEntryComponent)other_;
            return ListEntryComponent.compareValues(this.deleted, o.deleted, true) && ListEntryComponent.compareValues(this.date, o.date, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.flag, this.deleted, this.date, this.item});
        }

        @Override
        public String fhirType() {
            return "List.entry";
        }
    }

    public static class ListModeEnumFactory
    implements EnumFactory<ListMode> {
        @Override
        public ListMode fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("working".equals(codeString)) {
                return ListMode.WORKING;
            }
            if ("snapshot".equals(codeString)) {
                return ListMode.SNAPSHOT;
            }
            if ("changes".equals(codeString)) {
                return ListMode.CHANGES;
            }
            throw new IllegalArgumentException("Unknown ListMode code '" + codeString + "'");
        }

        public Enumeration<ListMode> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ListMode>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("working".equals(codeString)) {
                return new Enumeration<ListMode>(this, ListMode.WORKING);
            }
            if ("snapshot".equals(codeString)) {
                return new Enumeration<ListMode>(this, ListMode.SNAPSHOT);
            }
            if ("changes".equals(codeString)) {
                return new Enumeration<ListMode>(this, ListMode.CHANGES);
            }
            throw new FHIRException("Unknown ListMode code '" + codeString + "'");
        }

        @Override
        public String toCode(ListMode code) {
            if (code == ListMode.WORKING) {
                return "working";
            }
            if (code == ListMode.SNAPSHOT) {
                return "snapshot";
            }
            if (code == ListMode.CHANGES) {
                return "changes";
            }
            return "?";
        }

        @Override
        public String toSystem(ListMode code) {
            return code.getSystem();
        }
    }

    public static enum ListMode {
        WORKING,
        SNAPSHOT,
        CHANGES,
        NULL;


        public static ListMode fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("working".equals(codeString)) {
                return WORKING;
            }
            if ("snapshot".equals(codeString)) {
                return SNAPSHOT;
            }
            if ("changes".equals(codeString)) {
                return CHANGES;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ListMode code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case WORKING: {
                    return "working";
                }
                case SNAPSHOT: {
                    return "snapshot";
                }
                case CHANGES: {
                    return "changes";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case WORKING: {
                    return "http://hl7.org/fhir/list-mode";
                }
                case SNAPSHOT: {
                    return "http://hl7.org/fhir/list-mode";
                }
                case CHANGES: {
                    return "http://hl7.org/fhir/list-mode";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case WORKING: {
                    return "This list is the master list, maintained in an ongoing fashion with regular updates as the real world list it is tracking changes.";
                }
                case SNAPSHOT: {
                    return "This list was prepared as a snapshot. It should not be assumed to be current.";
                }
                case CHANGES: {
                    return "A point-in-time list that shows what changes have been made or recommended.  E.g. a discharge medication list showing what was added and removed during an encounter.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case WORKING: {
                    return "Working List";
                }
                case SNAPSHOT: {
                    return "Snapshot List";
                }
                case CHANGES: {
                    return "Change List";
                }
            }
            return "?";
        }
    }

    public static class ListStatusEnumFactory
    implements EnumFactory<ListStatus> {
        @Override
        public ListStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("current".equals(codeString)) {
                return ListStatus.CURRENT;
            }
            if ("retired".equals(codeString)) {
                return ListStatus.RETIRED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ListStatus.ENTEREDINERROR;
            }
            throw new IllegalArgumentException("Unknown ListStatus code '" + codeString + "'");
        }

        public Enumeration<ListStatus> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ListStatus>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("current".equals(codeString)) {
                return new Enumeration<ListStatus>(this, ListStatus.CURRENT);
            }
            if ("retired".equals(codeString)) {
                return new Enumeration<ListStatus>(this, ListStatus.RETIRED);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<ListStatus>(this, ListStatus.ENTEREDINERROR);
            }
            throw new FHIRException("Unknown ListStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(ListStatus code) {
            if (code == ListStatus.CURRENT) {
                return "current";
            }
            if (code == ListStatus.RETIRED) {
                return "retired";
            }
            if (code == ListStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            return "?";
        }

        @Override
        public String toSystem(ListStatus code) {
            return code.getSystem();
        }
    }

    public static enum ListStatus {
        CURRENT,
        RETIRED,
        ENTEREDINERROR,
        NULL;


        public static ListStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("current".equals(codeString)) {
                return CURRENT;
            }
            if ("retired".equals(codeString)) {
                return RETIRED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ListStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case CURRENT: {
                    return "current";
                }
                case RETIRED: {
                    return "retired";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case CURRENT: {
                    return "http://hl7.org/fhir/list-status";
                }
                case RETIRED: {
                    return "http://hl7.org/fhir/list-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/list-status";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case CURRENT: {
                    return "The list is considered to be an active part of the patient's record.";
                }
                case RETIRED: {
                    return "The list is \"old\" and should no longer be considered accurate or relevant.";
                }
                case ENTEREDINERROR: {
                    return "The list was never accurate.  It is retained for medico-legal purposes only.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case CURRENT: {
                    return "Current";
                }
                case RETIRED: {
                    return "Retired";
                }
                case ENTEREDINERROR: {
                    return "Entered In Error";
                }
            }
            return "?";
        }
    }
}

