/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ContractDecisionMode {
    POLICY,
    NULL;


    public static ContractDecisionMode fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("policy".equals(codeString)) {
            return POLICY;
        }
        throw new FHIRException("Unknown ContractDecisionMode code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case POLICY: {
                return "policy";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/contract-decision-mode";
    }

    public String getDefinition() {
        switch (this) {
            case POLICY: {
                return "To be completed";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case POLICY: {
                return "Policy";
            }
        }
        return "?";
    }
}

