/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum InvoicePriceComponentType {
    BASE,
    SURCHARGE,
    DEDUCTION,
    DISCOUNT,
    TAX,
    INFORMATIONAL,
    NULL;


    public static InvoicePriceComponentType fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("base".equals(codeString)) {
            return BASE;
        }
        if ("surcharge".equals(codeString)) {
            return SURCHARGE;
        }
        if ("deduction".equals(codeString)) {
            return DEDUCTION;
        }
        if ("discount".equals(codeString)) {
            return DISCOUNT;
        }
        if ("tax".equals(codeString)) {
            return TAX;
        }
        if ("informational".equals(codeString)) {
            return INFORMATIONAL;
        }
        throw new FHIRException("Unknown InvoicePriceComponentType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case BASE: {
                return "base";
            }
            case SURCHARGE: {
                return "surcharge";
            }
            case DEDUCTION: {
                return "deduction";
            }
            case DISCOUNT: {
                return "discount";
            }
            case TAX: {
                return "tax";
            }
            case INFORMATIONAL: {
                return "informational";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/invoice-priceComponentType";
    }

    public String getDefinition() {
        switch (this) {
            case BASE: {
                return "the amount is the base price used for calculating the total price before applying surcharges, discount or taxes.";
            }
            case SURCHARGE: {
                return "the amount is a surcharge applied on the base price.";
            }
            case DEDUCTION: {
                return "the amount is a deduction applied on the base price.";
            }
            case DISCOUNT: {
                return "the amount is a discount applied on the base price.";
            }
            case TAX: {
                return "the amount is the tax component of the total price.";
            }
            case INFORMATIONAL: {
                return "the amount is of informational character, it has not been applied in the calculation of the total price.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case BASE: {
                return "base price";
            }
            case SURCHARGE: {
                return "surcharge";
            }
            case DEDUCTION: {
                return "deduction";
            }
            case DISCOUNT: {
                return "discount";
            }
            case TAX: {
                return "tax";
            }
            case INFORMATIONAL: {
                return "informational";
            }
        }
        return "?";
    }
}

