/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum MapModelMode {
    SOURCE,
    QUERIED,
    TARGET,
    PRODUCED,
    NULL;


    public static MapModelMode fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("source".equals(codeString)) {
            return SOURCE;
        }
        if ("queried".equals(codeString)) {
            return QUERIED;
        }
        if ("target".equals(codeString)) {
            return TARGET;
        }
        if ("produced".equals(codeString)) {
            return PRODUCED;
        }
        throw new FHIRException("Unknown MapModelMode code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case SOURCE: {
                return "source";
            }
            case QUERIED: {
                return "queried";
            }
            case TARGET: {
                return "target";
            }
            case PRODUCED: {
                return "produced";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/map-model-mode";
    }

    public String getDefinition() {
        switch (this) {
            case SOURCE: {
                return "This structure describes an instance passed to the mapping engine that is used a source of data.";
            }
            case QUERIED: {
                return "This structure describes an instance that the mapping engine may ask for that is used a source of data.";
            }
            case TARGET: {
                return "This structure describes an instance passed to the mapping engine that is used a target of data.";
            }
            case PRODUCED: {
                return "This structure describes an instance that the mapping engine may ask to create that is used a target of data.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case SOURCE: {
                return "Source Structure Definition";
            }
            case QUERIED: {
                return "Queried Structure Definition";
            }
            case TARGET: {
                return "Target Structure Definition";
            }
            case PRODUCED: {
                return "Produced Structure Definition";
            }
        }
        return "?";
    }
}

