/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum OrientationType {
    SENSE,
    ANTISENSE,
    NULL;


    public static OrientationType fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("sense".equals(codeString)) {
            return SENSE;
        }
        if ("antisense".equals(codeString)) {
            return ANTISENSE;
        }
        throw new FHIRException("Unknown OrientationType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case SENSE: {
                return "sense";
            }
            case ANTISENSE: {
                return "antisense";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/orientation-type";
    }

    public String getDefinition() {
        switch (this) {
            case SENSE: {
                return "Sense orientation of reference sequence.";
            }
            case ANTISENSE: {
                return "Antisense orientation of reference sequence.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case SENSE: {
                return "Sense orientation of referenceSeq";
            }
            case ANTISENSE: {
                return "Antisense orientation of referenceSeq";
            }
        }
        return "?";
    }
}

