/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum V3ActRelationshipSubset {
    _PARTICIPATIONSUBSET,
    FUTURE,
    FUTSUM,
    LAST,
    NEXT,
    PAST,
    FIRST,
    PREVSUM,
    RECENT,
    SUM,
    ACTRELATIONSHIPEXPECTEDSUBSET,
    ACTRELATIONSHIPPASTSUBSET,
    MAX,
    MIN,
    NULL;


    public static V3ActRelationshipSubset fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("_ParticipationSubset".equals(codeString)) {
            return _PARTICIPATIONSUBSET;
        }
        if ("FUTURE".equals(codeString)) {
            return FUTURE;
        }
        if ("FUTSUM".equals(codeString)) {
            return FUTSUM;
        }
        if ("LAST".equals(codeString)) {
            return LAST;
        }
        if ("NEXT".equals(codeString)) {
            return NEXT;
        }
        if ("PAST".equals(codeString)) {
            return PAST;
        }
        if ("FIRST".equals(codeString)) {
            return FIRST;
        }
        if ("PREVSUM".equals(codeString)) {
            return PREVSUM;
        }
        if ("RECENT".equals(codeString)) {
            return RECENT;
        }
        if ("SUM".equals(codeString)) {
            return SUM;
        }
        if ("ActRelationshipExpectedSubset".equals(codeString)) {
            return ACTRELATIONSHIPEXPECTEDSUBSET;
        }
        if ("ActRelationshipPastSubset".equals(codeString)) {
            return ACTRELATIONSHIPPASTSUBSET;
        }
        if ("MAX".equals(codeString)) {
            return MAX;
        }
        if ("MIN".equals(codeString)) {
            return MIN;
        }
        throw new FHIRException("Unknown V3ActRelationshipSubset code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case _PARTICIPATIONSUBSET: {
                return "_ParticipationSubset";
            }
            case FUTURE: {
                return "FUTURE";
            }
            case FUTSUM: {
                return "FUTSUM";
            }
            case LAST: {
                return "LAST";
            }
            case NEXT: {
                return "NEXT";
            }
            case PAST: {
                return "PAST";
            }
            case FIRST: {
                return "FIRST";
            }
            case PREVSUM: {
                return "PREVSUM";
            }
            case RECENT: {
                return "RECENT";
            }
            case SUM: {
                return "SUM";
            }
            case ACTRELATIONSHIPEXPECTEDSUBSET: {
                return "ActRelationshipExpectedSubset";
            }
            case ACTRELATIONSHIPPASTSUBSET: {
                return "ActRelationshipPastSubset";
            }
            case MAX: {
                return "MAX";
            }
            case MIN: {
                return "MIN";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/v3-ActRelationshipSubset";
    }

    public String getDefinition() {
        switch (this) {
            case _PARTICIPATIONSUBSET: {
                return "Used to indicate that the participation is a filtered subset of the total participations of the same type owned by the Act. \r\n\n                        Used when there is a need to limit the participations to the first, the last, the next or some other filtered subset.";
            }
            case FUTURE: {
                return "An occurrence that is scheduled to occur in the future. An Act whose effective time is greater than 'now', where 'now' is the time the instance is authored.";
            }
            case FUTSUM: {
                return "Represents a 'summary' of all acts that are scheduled to occur in the future (whose effective time is greater than 'now' where is the time the instance is authored.). The effectiveTime represents the outer boundary of all occurrences, repeatNumber represents the total number of repetitions, etc.";
            }
            case LAST: {
                return "Restricted to the latest known occurrence that is scheduled to occur. The Act with the highest known effective time.";
            }
            case NEXT: {
                return "Restricted to the nearest recent known occurrence scheduled to occur in the future. The Act with the lowest effective time, still greater than 'now'. ('now' is the time the instance is authored.)";
            }
            case PAST: {
                return "An occurrence that occurred or was scheduled to occur in the past. An Act whose effective time is less than 'now'. ('now' is the time the instance is authored.)";
            }
            case FIRST: {
                return "Restricted to the earliest known occurrence that occurred or was scheduled to occur in the past. The Act with the lowest effective time. ('now' is the time the instance is authored.)";
            }
            case PREVSUM: {
                return "Represents a 'summary' of all acts that previously occurred or were scheduled to occur. The effectiveTime represents the outer boundary of all occurrences, repeatNumber represents the total number of repetitions, etc. ('now' is the time the instance is authored.)";
            }
            case RECENT: {
                return "Restricted to the most recent known occurrence that occurred or was scheduled to occur in the past. The Act with the most recent effective time, still less than 'now'. ('now' is the time the instance is authored.)";
            }
            case SUM: {
                return "Represents a 'summary' of all acts that have occurred or were scheduled to occur and which are scheduled to occur in the future. The effectiveTime represents the outer boundary of all occurrences, repeatNumber represents the total number of repetitions, etc.";
            }
            case ACTRELATIONSHIPEXPECTEDSUBSET: {
                return "ActRelationshipExpectedSubset";
            }
            case ACTRELATIONSHIPPASTSUBSET: {
                return "ActRelationshipPastSubset";
            }
            case MAX: {
                return "The occurrence whose value attribute is greater than all other occurrences at the time the instance is created.";
            }
            case MIN: {
                return "The occurrence whose value attribute is less than all other occurrences at the time the instance is created.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case _PARTICIPATIONSUBSET: {
                return "ParticipationSubset";
            }
            case FUTURE: {
                return "expected future";
            }
            case FUTSUM: {
                return "future summary";
            }
            case LAST: {
                return "expected last";
            }
            case NEXT: {
                return "expected next";
            }
            case PAST: {
                return "previous";
            }
            case FIRST: {
                return "first known";
            }
            case PREVSUM: {
                return "previous summary";
            }
            case RECENT: {
                return "most recent";
            }
            case SUM: {
                return "summary";
            }
            case ACTRELATIONSHIPEXPECTEDSUBSET: {
                return "ActRelationshipExpectedSubset";
            }
            case ACTRELATIONSHIPPASTSUBSET: {
                return "ActRelationshipPastSubset";
            }
            case MAX: {
                return "maximum";
            }
            case MIN: {
                return "minimum";
            }
        }
        return "?";
    }
}

