/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum V3LanguageAbilityProficiency {
    E,
    F,
    G,
    P,
    NULL;


    public static V3LanguageAbilityProficiency fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("E".equals(codeString)) {
            return E;
        }
        if ("F".equals(codeString)) {
            return F;
        }
        if ("G".equals(codeString)) {
            return G;
        }
        if ("P".equals(codeString)) {
            return P;
        }
        throw new FHIRException("Unknown V3LanguageAbilityProficiency code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case E: {
                return "E";
            }
            case F: {
                return "F";
            }
            case G: {
                return "G";
            }
            case P: {
                return "P";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/v3-LanguageAbilityProficiency";
    }

    public String getDefinition() {
        switch (this) {
            case E: {
                return "Excellent";
            }
            case F: {
                return "Fair";
            }
            case G: {
                return "Good";
            }
            case P: {
                return "Poor";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case E: {
                return "Excellent";
            }
            case F: {
                return "Fair";
            }
            case G: {
                return "Good";
            }
            case P: {
                return "Poor";
            }
        }
        return "?";
    }
}

