/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum QuestionMaxOccurs {
    ASTERISK,
    NULL;


    public static QuestionMaxOccurs fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("*".equals(codeString)) {
            return ASTERISK;
        }
        throw new FHIRException("Unknown QuestionMaxOccurs code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case ASTERISK: {
                return "*";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/question-max-occurs";
    }

    public String getDefinition() {
        switch (this) {
            case ASTERISK: {
                return "Element can repeat an unlimited number of times.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case ASTERISK: {
                return "Repeating";
            }
        }
        return "?";
    }
}

