/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum V3EncounterAdmissionSource {
    E,
    LD,
    NB,
    NULL;


    public static V3EncounterAdmissionSource fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("E".equals(codeString)) {
            return E;
        }
        if ("LD".equals(codeString)) {
            return LD;
        }
        if ("NB".equals(codeString)) {
            return NB;
        }
        throw new FHIRException("Unknown V3EncounterAdmissionSource code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case E: {
                return "E";
            }
            case LD: {
                return "LD";
            }
            case NB: {
                return "NB";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/v3-EncounterAdmissionSource";
    }

    public String getDefinition() {
        switch (this) {
            case E: {
                return "emergency";
            }
            case LD: {
                return "labor and delivery";
            }
            case NB: {
                return "newborn";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case E: {
                return "emergency";
            }
            case LD: {
                return "labor and delivery";
            }
            case NB: {
                return "newborn";
            }
        }
        return "?";
    }
}

