/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4.model.Annotation;
import org.hl7.fhir.r4.model.BackboneElement;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.DecimalType;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.Encounter;
import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.IntegerType;
import org.hl7.fhir.r4.model.Patient;
import org.hl7.fhir.r4.model.Practitioner;
import org.hl7.fhir.r4.model.PractitionerRole;
import org.hl7.fhir.r4.model.PrimitiveType;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.Quantity;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="VisionPrescription", profile="http://hl7.org/fhir/StructureDefinition/VisionPrescription")
public class VisionPrescription
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Business Identifier for vision prescription", formalDefinition="A unique identifier assigned to this vision prescription.")
    protected List<Identifier> identifier;
    @Child(name="status", type={CodeType.class}, order=1, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="active | cancelled | draft | entered-in-error", formalDefinition="The status of the resource instance.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/fm-status")
    protected Enumeration<VisionStatus> status;
    @Child(name="created", type={DateTimeType.class}, order=2, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Response creation date", formalDefinition="The date this resource was created.")
    protected DateTimeType created;
    @Child(name="patient", type={Patient.class}, order=3, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who prescription is for", formalDefinition="A resource reference to the person to whom the vision prescription applies.")
    protected Reference patient;
    protected Patient patientTarget;
    @Child(name="encounter", type={Encounter.class}, order=4, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Created during encounter / admission / stay", formalDefinition="A reference to a resource that identifies the particular occurrence of contact between patient and health care provider during which the prescription was issued.")
    protected Reference encounter;
    protected Encounter encounterTarget;
    @Child(name="dateWritten", type={DateTimeType.class}, order=5, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When prescription was authorized", formalDefinition="The date (and perhaps time) when the prescription was written.")
    protected DateTimeType dateWritten;
    @Child(name="prescriber", type={Practitioner.class, PractitionerRole.class}, order=6, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who authorized the vision prescription", formalDefinition="The healthcare professional responsible for authorizing the prescription.")
    protected Reference prescriber;
    protected Resource prescriberTarget;
    @Child(name="lensSpecification", type={}, order=7, min=1, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Vision lens authorization", formalDefinition="Contain the details of  the individual lens specifications and serves as the authorization for the fullfillment by certified professionals.")
    protected List<VisionPrescriptionLensSpecificationComponent> lensSpecification;
    private static final long serialVersionUID = 988021071L;
    @SearchParamDefinition(name="prescriber", path="VisionPrescription.prescriber", description="Who authorized the vision prescription", type="reference", providesMembershipIn={@Compartment(name="Practitioner")}, target={Practitioner.class, PractitionerRole.class})
    public static final String SP_PRESCRIBER = "prescriber";
    public static final ReferenceClientParam PRESCRIBER = new ReferenceClientParam("prescriber");
    public static final Include INCLUDE_PRESCRIBER = new Include("VisionPrescription:prescriber").toLocked();
    @SearchParamDefinition(name="identifier", path="VisionPrescription.identifier", description="Return prescriptions with this external identifier", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="patient", path="VisionPrescription.patient", description="The identity of a patient to list dispenses for", type="reference", providesMembershipIn={@Compartment(name="Patient")}, target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("VisionPrescription:patient").toLocked();
    @SearchParamDefinition(name="datewritten", path="VisionPrescription.dateWritten", description="Return prescriptions written on this date", type="date")
    public static final String SP_DATEWRITTEN = "datewritten";
    public static final DateClientParam DATEWRITTEN = new DateClientParam("datewritten");
    @SearchParamDefinition(name="encounter", path="VisionPrescription.encounter", description="Return prescriptions with this encounter identifier", type="reference", providesMembershipIn={@Compartment(name="Encounter")}, target={Encounter.class})
    public static final String SP_ENCOUNTER = "encounter";
    public static final ReferenceClientParam ENCOUNTER = new ReferenceClientParam("encounter");
    public static final Include INCLUDE_ENCOUNTER = new Include("VisionPrescription:encounter").toLocked();
    @SearchParamDefinition(name="status", path="VisionPrescription.status", description="The status of the vision prescription", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public VisionPrescription() {
    }

    public VisionPrescription(Enumeration<VisionStatus> status, DateTimeType created, Reference patient, DateTimeType dateWritten, Reference prescriber) {
        this.status = status;
        this.created = created;
        this.patient = patient;
        this.dateWritten = dateWritten;
        this.prescriber = prescriber;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public VisionPrescription setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public VisionPrescription addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Enumeration<VisionStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create VisionPrescription.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<VisionStatus>(new VisionStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public VisionPrescription setStatusElement(Enumeration<VisionStatus> value) {
        this.status = value;
        return this;
    }

    public VisionStatus getStatus() {
        return this.status == null ? null : (VisionStatus)((Object)this.status.getValue());
    }

    public VisionPrescription setStatus(VisionStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<VisionStatus>(new VisionStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public DateTimeType getCreatedElement() {
        if (this.created == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create VisionPrescription.created");
            }
            if (Configuration.doAutoCreate()) {
                this.created = new DateTimeType();
            }
        }
        return this.created;
    }

    public boolean hasCreatedElement() {
        return this.created != null && !this.created.isEmpty();
    }

    public boolean hasCreated() {
        return this.created != null && !this.created.isEmpty();
    }

    public VisionPrescription setCreatedElement(DateTimeType value) {
        this.created = value;
        return this;
    }

    public Date getCreated() {
        return this.created == null ? null : (Date)this.created.getValue();
    }

    public VisionPrescription setCreated(Date value) {
        if (this.created == null) {
            this.created = new DateTimeType();
        }
        this.created.setValue(value);
        return this;
    }

    public Reference getPatient() {
        if (this.patient == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create VisionPrescription.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patient = new Reference();
            }
        }
        return this.patient;
    }

    public boolean hasPatient() {
        return this.patient != null && !this.patient.isEmpty();
    }

    public VisionPrescription setPatient(Reference value) {
        this.patient = value;
        return this;
    }

    public Patient getPatientTarget() {
        if (this.patientTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create VisionPrescription.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patientTarget = new Patient();
            }
        }
        return this.patientTarget;
    }

    public VisionPrescription setPatientTarget(Patient value) {
        this.patientTarget = value;
        return this;
    }

    public Reference getEncounter() {
        if (this.encounter == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create VisionPrescription.encounter");
            }
            if (Configuration.doAutoCreate()) {
                this.encounter = new Reference();
            }
        }
        return this.encounter;
    }

    public boolean hasEncounter() {
        return this.encounter != null && !this.encounter.isEmpty();
    }

    public VisionPrescription setEncounter(Reference value) {
        this.encounter = value;
        return this;
    }

    public Encounter getEncounterTarget() {
        if (this.encounterTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create VisionPrescription.encounter");
            }
            if (Configuration.doAutoCreate()) {
                this.encounterTarget = new Encounter();
            }
        }
        return this.encounterTarget;
    }

    public VisionPrescription setEncounterTarget(Encounter value) {
        this.encounterTarget = value;
        return this;
    }

    public DateTimeType getDateWrittenElement() {
        if (this.dateWritten == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create VisionPrescription.dateWritten");
            }
            if (Configuration.doAutoCreate()) {
                this.dateWritten = new DateTimeType();
            }
        }
        return this.dateWritten;
    }

    public boolean hasDateWrittenElement() {
        return this.dateWritten != null && !this.dateWritten.isEmpty();
    }

    public boolean hasDateWritten() {
        return this.dateWritten != null && !this.dateWritten.isEmpty();
    }

    public VisionPrescription setDateWrittenElement(DateTimeType value) {
        this.dateWritten = value;
        return this;
    }

    public Date getDateWritten() {
        return this.dateWritten == null ? null : (Date)this.dateWritten.getValue();
    }

    public VisionPrescription setDateWritten(Date value) {
        if (this.dateWritten == null) {
            this.dateWritten = new DateTimeType();
        }
        this.dateWritten.setValue(value);
        return this;
    }

    public Reference getPrescriber() {
        if (this.prescriber == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create VisionPrescription.prescriber");
            }
            if (Configuration.doAutoCreate()) {
                this.prescriber = new Reference();
            }
        }
        return this.prescriber;
    }

    public boolean hasPrescriber() {
        return this.prescriber != null && !this.prescriber.isEmpty();
    }

    public VisionPrescription setPrescriber(Reference value) {
        this.prescriber = value;
        return this;
    }

    public Resource getPrescriberTarget() {
        return this.prescriberTarget;
    }

    public VisionPrescription setPrescriberTarget(Resource value) {
        this.prescriberTarget = value;
        return this;
    }

    public List<VisionPrescriptionLensSpecificationComponent> getLensSpecification() {
        if (this.lensSpecification == null) {
            this.lensSpecification = new ArrayList<VisionPrescriptionLensSpecificationComponent>();
        }
        return this.lensSpecification;
    }

    public VisionPrescription setLensSpecification(List<VisionPrescriptionLensSpecificationComponent> theLensSpecification) {
        this.lensSpecification = theLensSpecification;
        return this;
    }

    public boolean hasLensSpecification() {
        if (this.lensSpecification == null) {
            return false;
        }
        for (VisionPrescriptionLensSpecificationComponent item : this.lensSpecification) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public VisionPrescriptionLensSpecificationComponent addLensSpecification() {
        VisionPrescriptionLensSpecificationComponent t = new VisionPrescriptionLensSpecificationComponent();
        if (this.lensSpecification == null) {
            this.lensSpecification = new ArrayList<VisionPrescriptionLensSpecificationComponent>();
        }
        this.lensSpecification.add(t);
        return t;
    }

    public VisionPrescription addLensSpecification(VisionPrescriptionLensSpecificationComponent t) {
        if (t == null) {
            return this;
        }
        if (this.lensSpecification == null) {
            this.lensSpecification = new ArrayList<VisionPrescriptionLensSpecificationComponent>();
        }
        this.lensSpecification.add(t);
        return this;
    }

    public VisionPrescriptionLensSpecificationComponent getLensSpecificationFirstRep() {
        if (this.getLensSpecification().isEmpty()) {
            this.addLensSpecification();
        }
        return this.getLensSpecification().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "A unique identifier assigned to this vision prescription.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_STATUS, "code", "The status of the resource instance.", 0, 1, this.status));
        children.add(new Property("created", "dateTime", "The date this resource was created.", 0, 1, this.created));
        children.add(new Property(SP_PATIENT, "Reference(Patient)", "A resource reference to the person to whom the vision prescription applies.", 0, 1, this.patient));
        children.add(new Property(SP_ENCOUNTER, "Reference(Encounter)", "A reference to a resource that identifies the particular occurrence of contact between patient and health care provider during which the prescription was issued.", 0, 1, this.encounter));
        children.add(new Property("dateWritten", "dateTime", "The date (and perhaps time) when the prescription was written.", 0, 1, this.dateWritten));
        children.add(new Property(SP_PRESCRIBER, "Reference(Practitioner|PractitionerRole)", "The healthcare professional responsible for authorizing the prescription.", 0, 1, this.prescriber));
        children.add(new Property("lensSpecification", "", "Contain the details of  the individual lens specifications and serves as the authorization for the fullfillment by certified professionals.", 0, Integer.MAX_VALUE, this.lensSpecification));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "A unique identifier assigned to this vision prescription.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The status of the resource instance.", 0, 1, this.status);
            }
            case 1028554472: {
                return new Property("created", "dateTime", "The date this resource was created.", 0, 1, this.created);
            }
            case -791418107: {
                return new Property(SP_PATIENT, "Reference(Patient)", "A resource reference to the person to whom the vision prescription applies.", 0, 1, this.patient);
            }
            case 1524132147: {
                return new Property(SP_ENCOUNTER, "Reference(Encounter)", "A reference to a resource that identifies the particular occurrence of contact between patient and health care provider during which the prescription was issued.", 0, 1, this.encounter);
            }
            case -1496880759: {
                return new Property("dateWritten", "dateTime", "The date (and perhaps time) when the prescription was written.", 0, 1, this.dateWritten);
            }
            case 1430631077: {
                return new Property(SP_PRESCRIBER, "Reference(Practitioner|PractitionerRole)", "The healthcare professional responsible for authorizing the prescription.", 0, 1, this.prescriber);
            }
            case -1767318363: {
                return new Property("lensSpecification", "", "Contain the details of  the individual lens specifications and serves as the authorization for the fullfillment by certified professionals.", 0, Integer.MAX_VALUE, this.lensSpecification);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case 1028554472: {
                Base[] baseArray;
                if (this.created == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.created;
                }
                return baseArray;
            }
            case -791418107: {
                Base[] baseArray;
                if (this.patient == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.patient;
                }
                return baseArray;
            }
            case 1524132147: {
                Base[] baseArray;
                if (this.encounter == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.encounter;
                }
                return baseArray;
            }
            case -1496880759: {
                Base[] baseArray;
                if (this.dateWritten == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.dateWritten;
                }
                return baseArray;
            }
            case 1430631077: {
                Base[] baseArray;
                if (this.prescriber == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.prescriber;
                }
                return baseArray;
            }
            case -1767318363: {
                return this.lensSpecification == null ? new Base[]{} : this.lensSpecification.toArray(new Base[this.lensSpecification.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case -892481550: {
                value = new VisionStatusEnumFactory().fromType(this.castToCode(value));
                this.status = value;
                return value;
            }
            case 1028554472: {
                this.created = this.castToDateTime(value);
                return value;
            }
            case -791418107: {
                this.patient = this.castToReference(value);
                return value;
            }
            case 1524132147: {
                this.encounter = this.castToReference(value);
                return value;
            }
            case -1496880759: {
                this.dateWritten = this.castToDateTime(value);
                return value;
            }
            case 1430631077: {
                this.prescriber = this.castToReference(value);
                return value;
            }
            case -1767318363: {
                this.getLensSpecification().add((VisionPrescriptionLensSpecificationComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_STATUS)) {
            value = new VisionStatusEnumFactory().fromType(this.castToCode(value));
            this.status = value;
        } else if (name.equals("created")) {
            this.created = this.castToDateTime(value);
        } else if (name.equals(SP_PATIENT)) {
            this.patient = this.castToReference(value);
        } else if (name.equals(SP_ENCOUNTER)) {
            this.encounter = this.castToReference(value);
        } else if (name.equals("dateWritten")) {
            this.dateWritten = this.castToDateTime(value);
        } else if (name.equals(SP_PRESCRIBER)) {
            this.prescriber = this.castToReference(value);
        } else if (name.equals("lensSpecification")) {
            this.getLensSpecification().add((VisionPrescriptionLensSpecificationComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public void removeChild(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().remove(this.castToIdentifier(value));
        } else if (name.equals(SP_STATUS)) {
            this.status = null;
        } else if (name.equals("created")) {
            this.created = null;
        } else if (name.equals(SP_PATIENT)) {
            this.patient = null;
        } else if (name.equals(SP_ENCOUNTER)) {
            this.encounter = null;
        } else if (name.equals("dateWritten")) {
            this.dateWritten = null;
        } else if (name.equals(SP_PRESCRIBER)) {
            this.prescriber = null;
        } else if (name.equals("lensSpecification")) {
            this.getLensSpecification().remove((VisionPrescriptionLensSpecificationComponent)value);
        } else {
            super.removeChild(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 1028554472: {
                return this.getCreatedElement();
            }
            case -791418107: {
                return this.getPatient();
            }
            case 1524132147: {
                return this.getEncounter();
            }
            case -1496880759: {
                return this.getDateWrittenElement();
            }
            case 1430631077: {
                return this.getPrescriber();
            }
            case -1767318363: {
                return this.addLensSpecification();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case 1028554472: {
                return new String[]{"dateTime"};
            }
            case -791418107: {
                return new String[]{"Reference"};
            }
            case 1524132147: {
                return new String[]{"Reference"};
            }
            case -1496880759: {
                return new String[]{"dateTime"};
            }
            case 1430631077: {
                return new String[]{"Reference"};
            }
            case -1767318363: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a singleton property VisionPrescription.status");
        }
        if (name.equals("created")) {
            throw new FHIRException("Cannot call addChild on a singleton property VisionPrescription.created");
        }
        if (name.equals(SP_PATIENT)) {
            this.patient = new Reference();
            return this.patient;
        }
        if (name.equals(SP_ENCOUNTER)) {
            this.encounter = new Reference();
            return this.encounter;
        }
        if (name.equals("dateWritten")) {
            throw new FHIRException("Cannot call addChild on a singleton property VisionPrescription.dateWritten");
        }
        if (name.equals(SP_PRESCRIBER)) {
            this.prescriber = new Reference();
            return this.prescriber;
        }
        if (name.equals("lensSpecification")) {
            return this.addLensSpecification();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "VisionPrescription";
    }

    @Override
    public VisionPrescription copy() {
        VisionPrescription dst = new VisionPrescription();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(VisionPrescription dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        dst.created = this.created == null ? null : this.created.copy();
        dst.patient = this.patient == null ? null : this.patient.copy();
        dst.encounter = this.encounter == null ? null : this.encounter.copy();
        dst.dateWritten = this.dateWritten == null ? null : this.dateWritten.copy();
        Reference reference = dst.prescriber = this.prescriber == null ? null : this.prescriber.copy();
        if (this.lensSpecification != null) {
            dst.lensSpecification = new ArrayList<VisionPrescriptionLensSpecificationComponent>();
            for (VisionPrescriptionLensSpecificationComponent visionPrescriptionLensSpecificationComponent : this.lensSpecification) {
                dst.lensSpecification.add(visionPrescriptionLensSpecificationComponent.copy());
            }
        }
    }

    protected VisionPrescription typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof VisionPrescription)) {
            return false;
        }
        VisionPrescription o = (VisionPrescription)other_;
        return VisionPrescription.compareDeep(this.identifier, o.identifier, true) && VisionPrescription.compareDeep(this.status, o.status, true) && VisionPrescription.compareDeep(this.created, o.created, true) && VisionPrescription.compareDeep(this.patient, o.patient, true) && VisionPrescription.compareDeep(this.encounter, o.encounter, true) && VisionPrescription.compareDeep(this.dateWritten, o.dateWritten, true) && VisionPrescription.compareDeep(this.prescriber, o.prescriber, true) && VisionPrescription.compareDeep(this.lensSpecification, o.lensSpecification, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof VisionPrescription)) {
            return false;
        }
        VisionPrescription o = (VisionPrescription)other_;
        return VisionPrescription.compareValues(this.status, o.status, true) && VisionPrescription.compareValues(this.created, o.created, true) && VisionPrescription.compareValues(this.dateWritten, o.dateWritten, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.status, this.created, this.patient, this.encounter, this.dateWritten, this.prescriber, this.lensSpecification});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.VisionPrescription;
    }

    @Block
    public static class PrismComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="amount", type={DecimalType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Amount of adjustment", formalDefinition="Amount of prism to compensate for eye alignment in fractional units.")
        protected DecimalType amount;
        @Child(name="base", type={CodeType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="up | down | in | out", formalDefinition="The relative base, or reference lens edge, for the prism.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/vision-base-codes")
        protected Enumeration<VisionBase> base;
        private static final long serialVersionUID = 1677247628L;

        public PrismComponent() {
        }

        public PrismComponent(DecimalType amount, Enumeration<VisionBase> base) {
            this.amount = amount;
            this.base = base;
        }

        public DecimalType getAmountElement() {
            if (this.amount == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PrismComponent.amount");
                }
                if (Configuration.doAutoCreate()) {
                    this.amount = new DecimalType();
                }
            }
            return this.amount;
        }

        public boolean hasAmountElement() {
            return this.amount != null && !this.amount.isEmpty();
        }

        public boolean hasAmount() {
            return this.amount != null && !this.amount.isEmpty();
        }

        public PrismComponent setAmountElement(DecimalType value) {
            this.amount = value;
            return this;
        }

        public BigDecimal getAmount() {
            return this.amount == null ? null : (BigDecimal)this.amount.getValue();
        }

        public PrismComponent setAmount(BigDecimal value) {
            if (this.amount == null) {
                this.amount = new DecimalType();
            }
            this.amount.setValue(value);
            return this;
        }

        public PrismComponent setAmount(long value) {
            this.amount = new DecimalType();
            this.amount.setValue(value);
            return this;
        }

        public PrismComponent setAmount(double value) {
            this.amount = new DecimalType();
            this.amount.setValue(value);
            return this;
        }

        public Enumeration<VisionBase> getBaseElement() {
            if (this.base == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PrismComponent.base");
                }
                if (Configuration.doAutoCreate()) {
                    this.base = new Enumeration<VisionBase>(new VisionBaseEnumFactory());
                }
            }
            return this.base;
        }

        public boolean hasBaseElement() {
            return this.base != null && !this.base.isEmpty();
        }

        public boolean hasBase() {
            return this.base != null && !this.base.isEmpty();
        }

        public PrismComponent setBaseElement(Enumeration<VisionBase> value) {
            this.base = value;
            return this;
        }

        public VisionBase getBase() {
            return this.base == null ? null : (VisionBase)((Object)this.base.getValue());
        }

        public PrismComponent setBase(VisionBase value) {
            if (this.base == null) {
                this.base = new Enumeration<VisionBase>(new VisionBaseEnumFactory());
            }
            this.base.setValue((Object)value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("amount", "decimal", "Amount of prism to compensate for eye alignment in fractional units.", 0, 1, this.amount));
            children.add(new Property("base", "code", "The relative base, or reference lens edge, for the prism.", 0, 1, this.base));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1413853096: {
                    return new Property("amount", "decimal", "Amount of prism to compensate for eye alignment in fractional units.", 0, 1, this.amount);
                }
                case 3016401: {
                    return new Property("base", "code", "The relative base, or reference lens edge, for the prism.", 0, 1, this.base);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1413853096: {
                    Base[] baseArray;
                    if (this.amount == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.amount;
                    }
                    return baseArray;
                }
                case 3016401: {
                    Base[] baseArray;
                    if (this.base == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.base;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1413853096: {
                    this.amount = this.castToDecimal(value);
                    return value;
                }
                case 3016401: {
                    value = new VisionBaseEnumFactory().fromType(this.castToCode(value));
                    this.base = value;
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("amount")) {
                this.amount = this.castToDecimal(value);
            } else if (name.equals("base")) {
                value = new VisionBaseEnumFactory().fromType(this.castToCode(value));
                this.base = value;
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("amount")) {
                this.amount = null;
            } else if (name.equals("base")) {
                this.base = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1413853096: {
                    return this.getAmountElement();
                }
                case 3016401: {
                    return this.getBaseElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1413853096: {
                    return new String[]{"decimal"};
                }
                case 3016401: {
                    return new String[]{"code"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("amount")) {
                throw new FHIRException("Cannot call addChild on a singleton property VisionPrescription.amount");
            }
            if (name.equals("base")) {
                throw new FHIRException("Cannot call addChild on a singleton property VisionPrescription.base");
            }
            return super.addChild(name);
        }

        @Override
        public PrismComponent copy() {
            PrismComponent dst = new PrismComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(PrismComponent dst) {
            super.copyValues(dst);
            dst.amount = this.amount == null ? null : this.amount.copy();
            dst.base = this.base == null ? null : this.base.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof PrismComponent)) {
                return false;
            }
            PrismComponent o = (PrismComponent)other_;
            return PrismComponent.compareDeep(this.amount, o.amount, true) && PrismComponent.compareDeep(this.base, o.base, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof PrismComponent)) {
                return false;
            }
            PrismComponent o = (PrismComponent)other_;
            return PrismComponent.compareValues(this.amount, o.amount, true) && PrismComponent.compareValues(this.base, o.base, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.amount, this.base});
        }

        @Override
        public String fhirType() {
            return "VisionPrescription.lensSpecification.prism";
        }
    }

    @Block
    public static class VisionPrescriptionLensSpecificationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="product", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Product to be supplied", formalDefinition="Identifies the type of vision correction product which is required for the patient.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/vision-product")
        protected CodeableConcept product;
        @Child(name="eye", type={CodeType.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="right | left", formalDefinition="The eye for which the lens specification applies.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/vision-eye-codes")
        protected Enumeration<VisionEyes> eye;
        @Child(name="sphere", type={DecimalType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Power of the lens", formalDefinition="Lens power measured in dioptres (0.25 units).")
        protected DecimalType sphere;
        @Child(name="cylinder", type={DecimalType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Lens power for astigmatism", formalDefinition="Power adjustment for astigmatism measured in dioptres (0.25 units).")
        protected DecimalType cylinder;
        @Child(name="axis", type={IntegerType.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Lens meridian which contain no power for astigmatism", formalDefinition="Adjustment for astigmatism measured in integer degrees.")
        protected IntegerType axis;
        @Child(name="prism", type={}, order=6, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Eye alignment compensation", formalDefinition="Allows for adjustment on two axis.")
        protected List<PrismComponent> prism;
        @Child(name="add", type={DecimalType.class}, order=7, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Added power for multifocal levels", formalDefinition="Power adjustment for multifocal lenses measured in dioptres (0.25 units).")
        protected DecimalType add;
        @Child(name="power", type={DecimalType.class}, order=8, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Contact lens power", formalDefinition="Contact lens power measured in dioptres (0.25 units).")
        protected DecimalType power;
        @Child(name="backCurve", type={DecimalType.class}, order=9, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Contact lens back curvature", formalDefinition="Back curvature measured in millimetres.")
        protected DecimalType backCurve;
        @Child(name="diameter", type={DecimalType.class}, order=10, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Contact lens diameter", formalDefinition="Contact lens diameter measured in millimetres.")
        protected DecimalType diameter;
        @Child(name="duration", type={Quantity.class}, order=11, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Lens wear duration", formalDefinition="The recommended maximum wear period for the lens.")
        protected Quantity duration;
        @Child(name="color", type={StringType.class}, order=12, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Color required", formalDefinition="Special color or pattern.")
        protected StringType color;
        @Child(name="brand", type={StringType.class}, order=13, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Brand required", formalDefinition="Brand recommendations or restrictions.")
        protected StringType brand;
        @Child(name="note", type={Annotation.class}, order=14, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Notes for coatings", formalDefinition="Notes for special requirements such as coatings and lens materials.")
        protected List<Annotation> note;
        private static final long serialVersionUID = 688924460L;

        public VisionPrescriptionLensSpecificationComponent() {
        }

        public VisionPrescriptionLensSpecificationComponent(CodeableConcept product, Enumeration<VisionEyes> eye) {
            this.product = product;
            this.eye = eye;
        }

        public CodeableConcept getProduct() {
            if (this.product == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create VisionPrescriptionLensSpecificationComponent.product");
                }
                if (Configuration.doAutoCreate()) {
                    this.product = new CodeableConcept();
                }
            }
            return this.product;
        }

        public boolean hasProduct() {
            return this.product != null && !this.product.isEmpty();
        }

        public VisionPrescriptionLensSpecificationComponent setProduct(CodeableConcept value) {
            this.product = value;
            return this;
        }

        public Enumeration<VisionEyes> getEyeElement() {
            if (this.eye == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create VisionPrescriptionLensSpecificationComponent.eye");
                }
                if (Configuration.doAutoCreate()) {
                    this.eye = new Enumeration<VisionEyes>(new VisionEyesEnumFactory());
                }
            }
            return this.eye;
        }

        public boolean hasEyeElement() {
            return this.eye != null && !this.eye.isEmpty();
        }

        public boolean hasEye() {
            return this.eye != null && !this.eye.isEmpty();
        }

        public VisionPrescriptionLensSpecificationComponent setEyeElement(Enumeration<VisionEyes> value) {
            this.eye = value;
            return this;
        }

        public VisionEyes getEye() {
            return this.eye == null ? null : (VisionEyes)((Object)this.eye.getValue());
        }

        public VisionPrescriptionLensSpecificationComponent setEye(VisionEyes value) {
            if (this.eye == null) {
                this.eye = new Enumeration<VisionEyes>(new VisionEyesEnumFactory());
            }
            this.eye.setValue((Object)value);
            return this;
        }

        public DecimalType getSphereElement() {
            if (this.sphere == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create VisionPrescriptionLensSpecificationComponent.sphere");
                }
                if (Configuration.doAutoCreate()) {
                    this.sphere = new DecimalType();
                }
            }
            return this.sphere;
        }

        public boolean hasSphereElement() {
            return this.sphere != null && !this.sphere.isEmpty();
        }

        public boolean hasSphere() {
            return this.sphere != null && !this.sphere.isEmpty();
        }

        public VisionPrescriptionLensSpecificationComponent setSphereElement(DecimalType value) {
            this.sphere = value;
            return this;
        }

        public BigDecimal getSphere() {
            return this.sphere == null ? null : (BigDecimal)this.sphere.getValue();
        }

        public VisionPrescriptionLensSpecificationComponent setSphere(BigDecimal value) {
            if (value == null) {
                this.sphere = null;
            } else {
                if (this.sphere == null) {
                    this.sphere = new DecimalType();
                }
                this.sphere.setValue(value);
            }
            return this;
        }

        public VisionPrescriptionLensSpecificationComponent setSphere(long value) {
            this.sphere = new DecimalType();
            this.sphere.setValue(value);
            return this;
        }

        public VisionPrescriptionLensSpecificationComponent setSphere(double value) {
            this.sphere = new DecimalType();
            this.sphere.setValue(value);
            return this;
        }

        public DecimalType getCylinderElement() {
            if (this.cylinder == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create VisionPrescriptionLensSpecificationComponent.cylinder");
                }
                if (Configuration.doAutoCreate()) {
                    this.cylinder = new DecimalType();
                }
            }
            return this.cylinder;
        }

        public boolean hasCylinderElement() {
            return this.cylinder != null && !this.cylinder.isEmpty();
        }

        public boolean hasCylinder() {
            return this.cylinder != null && !this.cylinder.isEmpty();
        }

        public VisionPrescriptionLensSpecificationComponent setCylinderElement(DecimalType value) {
            this.cylinder = value;
            return this;
        }

        public BigDecimal getCylinder() {
            return this.cylinder == null ? null : (BigDecimal)this.cylinder.getValue();
        }

        public VisionPrescriptionLensSpecificationComponent setCylinder(BigDecimal value) {
            if (value == null) {
                this.cylinder = null;
            } else {
                if (this.cylinder == null) {
                    this.cylinder = new DecimalType();
                }
                this.cylinder.setValue(value);
            }
            return this;
        }

        public VisionPrescriptionLensSpecificationComponent setCylinder(long value) {
            this.cylinder = new DecimalType();
            this.cylinder.setValue(value);
            return this;
        }

        public VisionPrescriptionLensSpecificationComponent setCylinder(double value) {
            this.cylinder = new DecimalType();
            this.cylinder.setValue(value);
            return this;
        }

        public IntegerType getAxisElement() {
            if (this.axis == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create VisionPrescriptionLensSpecificationComponent.axis");
                }
                if (Configuration.doAutoCreate()) {
                    this.axis = new IntegerType();
                }
            }
            return this.axis;
        }

        public boolean hasAxisElement() {
            return this.axis != null && !this.axis.isEmpty();
        }

        public boolean hasAxis() {
            return this.axis != null && !this.axis.isEmpty();
        }

        public VisionPrescriptionLensSpecificationComponent setAxisElement(IntegerType value) {
            this.axis = value;
            return this;
        }

        public int getAxis() {
            return this.axis == null || this.axis.isEmpty() ? 0 : (Integer)this.axis.getValue();
        }

        public VisionPrescriptionLensSpecificationComponent setAxis(int value) {
            if (this.axis == null) {
                this.axis = new IntegerType();
            }
            this.axis.setValue((Object)value);
            return this;
        }

        public List<PrismComponent> getPrism() {
            if (this.prism == null) {
                this.prism = new ArrayList<PrismComponent>();
            }
            return this.prism;
        }

        public VisionPrescriptionLensSpecificationComponent setPrism(List<PrismComponent> thePrism) {
            this.prism = thePrism;
            return this;
        }

        public boolean hasPrism() {
            if (this.prism == null) {
                return false;
            }
            for (PrismComponent item : this.prism) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public PrismComponent addPrism() {
            PrismComponent t = new PrismComponent();
            if (this.prism == null) {
                this.prism = new ArrayList<PrismComponent>();
            }
            this.prism.add(t);
            return t;
        }

        public VisionPrescriptionLensSpecificationComponent addPrism(PrismComponent t) {
            if (t == null) {
                return this;
            }
            if (this.prism == null) {
                this.prism = new ArrayList<PrismComponent>();
            }
            this.prism.add(t);
            return this;
        }

        public PrismComponent getPrismFirstRep() {
            if (this.getPrism().isEmpty()) {
                this.addPrism();
            }
            return this.getPrism().get(0);
        }

        public DecimalType getAddElement() {
            if (this.add == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create VisionPrescriptionLensSpecificationComponent.add");
                }
                if (Configuration.doAutoCreate()) {
                    this.add = new DecimalType();
                }
            }
            return this.add;
        }

        public boolean hasAddElement() {
            return this.add != null && !this.add.isEmpty();
        }

        public boolean hasAdd() {
            return this.add != null && !this.add.isEmpty();
        }

        public VisionPrescriptionLensSpecificationComponent setAddElement(DecimalType value) {
            this.add = value;
            return this;
        }

        public BigDecimal getAdd() {
            return this.add == null ? null : (BigDecimal)this.add.getValue();
        }

        public VisionPrescriptionLensSpecificationComponent setAdd(BigDecimal value) {
            if (value == null) {
                this.add = null;
            } else {
                if (this.add == null) {
                    this.add = new DecimalType();
                }
                this.add.setValue(value);
            }
            return this;
        }

        public VisionPrescriptionLensSpecificationComponent setAdd(long value) {
            this.add = new DecimalType();
            this.add.setValue(value);
            return this;
        }

        public VisionPrescriptionLensSpecificationComponent setAdd(double value) {
            this.add = new DecimalType();
            this.add.setValue(value);
            return this;
        }

        public DecimalType getPowerElement() {
            if (this.power == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create VisionPrescriptionLensSpecificationComponent.power");
                }
                if (Configuration.doAutoCreate()) {
                    this.power = new DecimalType();
                }
            }
            return this.power;
        }

        public boolean hasPowerElement() {
            return this.power != null && !this.power.isEmpty();
        }

        public boolean hasPower() {
            return this.power != null && !this.power.isEmpty();
        }

        public VisionPrescriptionLensSpecificationComponent setPowerElement(DecimalType value) {
            this.power = value;
            return this;
        }

        public BigDecimal getPower() {
            return this.power == null ? null : (BigDecimal)this.power.getValue();
        }

        public VisionPrescriptionLensSpecificationComponent setPower(BigDecimal value) {
            if (value == null) {
                this.power = null;
            } else {
                if (this.power == null) {
                    this.power = new DecimalType();
                }
                this.power.setValue(value);
            }
            return this;
        }

        public VisionPrescriptionLensSpecificationComponent setPower(long value) {
            this.power = new DecimalType();
            this.power.setValue(value);
            return this;
        }

        public VisionPrescriptionLensSpecificationComponent setPower(double value) {
            this.power = new DecimalType();
            this.power.setValue(value);
            return this;
        }

        public DecimalType getBackCurveElement() {
            if (this.backCurve == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create VisionPrescriptionLensSpecificationComponent.backCurve");
                }
                if (Configuration.doAutoCreate()) {
                    this.backCurve = new DecimalType();
                }
            }
            return this.backCurve;
        }

        public boolean hasBackCurveElement() {
            return this.backCurve != null && !this.backCurve.isEmpty();
        }

        public boolean hasBackCurve() {
            return this.backCurve != null && !this.backCurve.isEmpty();
        }

        public VisionPrescriptionLensSpecificationComponent setBackCurveElement(DecimalType value) {
            this.backCurve = value;
            return this;
        }

        public BigDecimal getBackCurve() {
            return this.backCurve == null ? null : (BigDecimal)this.backCurve.getValue();
        }

        public VisionPrescriptionLensSpecificationComponent setBackCurve(BigDecimal value) {
            if (value == null) {
                this.backCurve = null;
            } else {
                if (this.backCurve == null) {
                    this.backCurve = new DecimalType();
                }
                this.backCurve.setValue(value);
            }
            return this;
        }

        public VisionPrescriptionLensSpecificationComponent setBackCurve(long value) {
            this.backCurve = new DecimalType();
            this.backCurve.setValue(value);
            return this;
        }

        public VisionPrescriptionLensSpecificationComponent setBackCurve(double value) {
            this.backCurve = new DecimalType();
            this.backCurve.setValue(value);
            return this;
        }

        public DecimalType getDiameterElement() {
            if (this.diameter == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create VisionPrescriptionLensSpecificationComponent.diameter");
                }
                if (Configuration.doAutoCreate()) {
                    this.diameter = new DecimalType();
                }
            }
            return this.diameter;
        }

        public boolean hasDiameterElement() {
            return this.diameter != null && !this.diameter.isEmpty();
        }

        public boolean hasDiameter() {
            return this.diameter != null && !this.diameter.isEmpty();
        }

        public VisionPrescriptionLensSpecificationComponent setDiameterElement(DecimalType value) {
            this.diameter = value;
            return this;
        }

        public BigDecimal getDiameter() {
            return this.diameter == null ? null : (BigDecimal)this.diameter.getValue();
        }

        public VisionPrescriptionLensSpecificationComponent setDiameter(BigDecimal value) {
            if (value == null) {
                this.diameter = null;
            } else {
                if (this.diameter == null) {
                    this.diameter = new DecimalType();
                }
                this.diameter.setValue(value);
            }
            return this;
        }

        public VisionPrescriptionLensSpecificationComponent setDiameter(long value) {
            this.diameter = new DecimalType();
            this.diameter.setValue(value);
            return this;
        }

        public VisionPrescriptionLensSpecificationComponent setDiameter(double value) {
            this.diameter = new DecimalType();
            this.diameter.setValue(value);
            return this;
        }

        public Quantity getDuration() {
            if (this.duration == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create VisionPrescriptionLensSpecificationComponent.duration");
                }
                if (Configuration.doAutoCreate()) {
                    this.duration = new Quantity();
                }
            }
            return this.duration;
        }

        public boolean hasDuration() {
            return this.duration != null && !this.duration.isEmpty();
        }

        public VisionPrescriptionLensSpecificationComponent setDuration(Quantity value) {
            this.duration = value;
            return this;
        }

        public StringType getColorElement() {
            if (this.color == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create VisionPrescriptionLensSpecificationComponent.color");
                }
                if (Configuration.doAutoCreate()) {
                    this.color = new StringType();
                }
            }
            return this.color;
        }

        public boolean hasColorElement() {
            return this.color != null && !this.color.isEmpty();
        }

        public boolean hasColor() {
            return this.color != null && !this.color.isEmpty();
        }

        public VisionPrescriptionLensSpecificationComponent setColorElement(StringType value) {
            this.color = value;
            return this;
        }

        public String getColor() {
            return this.color == null ? null : (String)this.color.getValue();
        }

        public VisionPrescriptionLensSpecificationComponent setColor(String value) {
            if (Utilities.noString((String)value)) {
                this.color = null;
            } else {
                if (this.color == null) {
                    this.color = new StringType();
                }
                this.color.setValue(value);
            }
            return this;
        }

        public StringType getBrandElement() {
            if (this.brand == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create VisionPrescriptionLensSpecificationComponent.brand");
                }
                if (Configuration.doAutoCreate()) {
                    this.brand = new StringType();
                }
            }
            return this.brand;
        }

        public boolean hasBrandElement() {
            return this.brand != null && !this.brand.isEmpty();
        }

        public boolean hasBrand() {
            return this.brand != null && !this.brand.isEmpty();
        }

        public VisionPrescriptionLensSpecificationComponent setBrandElement(StringType value) {
            this.brand = value;
            return this;
        }

        public String getBrand() {
            return this.brand == null ? null : (String)this.brand.getValue();
        }

        public VisionPrescriptionLensSpecificationComponent setBrand(String value) {
            if (Utilities.noString((String)value)) {
                this.brand = null;
            } else {
                if (this.brand == null) {
                    this.brand = new StringType();
                }
                this.brand.setValue(value);
            }
            return this;
        }

        public List<Annotation> getNote() {
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            return this.note;
        }

        public VisionPrescriptionLensSpecificationComponent setNote(List<Annotation> theNote) {
            this.note = theNote;
            return this;
        }

        public boolean hasNote() {
            if (this.note == null) {
                return false;
            }
            for (Annotation item : this.note) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Annotation addNote() {
            Annotation t = new Annotation();
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            this.note.add(t);
            return t;
        }

        public VisionPrescriptionLensSpecificationComponent addNote(Annotation t) {
            if (t == null) {
                return this;
            }
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            this.note.add(t);
            return this;
        }

        public Annotation getNoteFirstRep() {
            if (this.getNote().isEmpty()) {
                this.addNote();
            }
            return this.getNote().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("product", "CodeableConcept", "Identifies the type of vision correction product which is required for the patient.", 0, 1, this.product));
            children.add(new Property("eye", "code", "The eye for which the lens specification applies.", 0, 1, this.eye));
            children.add(new Property("sphere", "decimal", "Lens power measured in dioptres (0.25 units).", 0, 1, this.sphere));
            children.add(new Property("cylinder", "decimal", "Power adjustment for astigmatism measured in dioptres (0.25 units).", 0, 1, this.cylinder));
            children.add(new Property("axis", "integer", "Adjustment for astigmatism measured in integer degrees.", 0, 1, this.axis));
            children.add(new Property("prism", "", "Allows for adjustment on two axis.", 0, Integer.MAX_VALUE, this.prism));
            children.add(new Property("add", "decimal", "Power adjustment for multifocal lenses measured in dioptres (0.25 units).", 0, 1, this.add));
            children.add(new Property("power", "decimal", "Contact lens power measured in dioptres (0.25 units).", 0, 1, this.power));
            children.add(new Property("backCurve", "decimal", "Back curvature measured in millimetres.", 0, 1, this.backCurve));
            children.add(new Property("diameter", "decimal", "Contact lens diameter measured in millimetres.", 0, 1, this.diameter));
            children.add(new Property("duration", "SimpleQuantity", "The recommended maximum wear period for the lens.", 0, 1, this.duration));
            children.add(new Property("color", "string", "Special color or pattern.", 0, 1, this.color));
            children.add(new Property("brand", "string", "Brand recommendations or restrictions.", 0, 1, this.brand));
            children.add(new Property("note", "Annotation", "Notes for special requirements such as coatings and lens materials.", 0, Integer.MAX_VALUE, this.note));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -309474065: {
                    return new Property("product", "CodeableConcept", "Identifies the type of vision correction product which is required for the patient.", 0, 1, this.product);
                }
                case 100913: {
                    return new Property("eye", "code", "The eye for which the lens specification applies.", 0, 1, this.eye);
                }
                case -895981619: {
                    return new Property("sphere", "decimal", "Lens power measured in dioptres (0.25 units).", 0, 1, this.sphere);
                }
                case -349378602: {
                    return new Property("cylinder", "decimal", "Power adjustment for astigmatism measured in dioptres (0.25 units).", 0, 1, this.cylinder);
                }
                case 3008417: {
                    return new Property("axis", "integer", "Adjustment for astigmatism measured in integer degrees.", 0, 1, this.axis);
                }
                case 106935105: {
                    return new Property("prism", "", "Allows for adjustment on two axis.", 0, Integer.MAX_VALUE, this.prism);
                }
                case 96417: {
                    return new Property("add", "decimal", "Power adjustment for multifocal lenses measured in dioptres (0.25 units).", 0, 1, this.add);
                }
                case 106858757: {
                    return new Property("power", "decimal", "Contact lens power measured in dioptres (0.25 units).", 0, 1, this.power);
                }
                case 1309344840: {
                    return new Property("backCurve", "decimal", "Back curvature measured in millimetres.", 0, 1, this.backCurve);
                }
                case -233204595: {
                    return new Property("diameter", "decimal", "Contact lens diameter measured in millimetres.", 0, 1, this.diameter);
                }
                case -1992012396: {
                    return new Property("duration", "SimpleQuantity", "The recommended maximum wear period for the lens.", 0, 1, this.duration);
                }
                case 94842723: {
                    return new Property("color", "string", "Special color or pattern.", 0, 1, this.color);
                }
                case 93997959: {
                    return new Property("brand", "string", "Brand recommendations or restrictions.", 0, 1, this.brand);
                }
                case 3387378: {
                    return new Property("note", "Annotation", "Notes for special requirements such as coatings and lens materials.", 0, Integer.MAX_VALUE, this.note);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -309474065: {
                    Base[] baseArray;
                    if (this.product == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.product;
                    }
                    return baseArray;
                }
                case 100913: {
                    Base[] baseArray;
                    if (this.eye == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.eye;
                    }
                    return baseArray;
                }
                case -895981619: {
                    Base[] baseArray;
                    if (this.sphere == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.sphere;
                    }
                    return baseArray;
                }
                case -349378602: {
                    Base[] baseArray;
                    if (this.cylinder == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.cylinder;
                    }
                    return baseArray;
                }
                case 3008417: {
                    Base[] baseArray;
                    if (this.axis == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.axis;
                    }
                    return baseArray;
                }
                case 106935105: {
                    return this.prism == null ? new Base[]{} : this.prism.toArray(new Base[this.prism.size()]);
                }
                case 96417: {
                    Base[] baseArray;
                    if (this.add == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.add;
                    }
                    return baseArray;
                }
                case 106858757: {
                    Base[] baseArray;
                    if (this.power == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.power;
                    }
                    return baseArray;
                }
                case 1309344840: {
                    Base[] baseArray;
                    if (this.backCurve == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray9 = new Base[1];
                        baseArray = baseArray9;
                        baseArray9[0] = this.backCurve;
                    }
                    return baseArray;
                }
                case -233204595: {
                    Base[] baseArray;
                    if (this.diameter == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray10 = new Base[1];
                        baseArray = baseArray10;
                        baseArray10[0] = this.diameter;
                    }
                    return baseArray;
                }
                case -1992012396: {
                    Base[] baseArray;
                    if (this.duration == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray11 = new Base[1];
                        baseArray = baseArray11;
                        baseArray11[0] = this.duration;
                    }
                    return baseArray;
                }
                case 94842723: {
                    Base[] baseArray;
                    if (this.color == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray12 = new Base[1];
                        baseArray = baseArray12;
                        baseArray12[0] = this.color;
                    }
                    return baseArray;
                }
                case 93997959: {
                    Base[] baseArray;
                    if (this.brand == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray13 = new Base[1];
                        baseArray = baseArray13;
                        baseArray13[0] = this.brand;
                    }
                    return baseArray;
                }
                case 3387378: {
                    return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -309474065: {
                    this.product = this.castToCodeableConcept(value);
                    return value;
                }
                case 100913: {
                    value = new VisionEyesEnumFactory().fromType(this.castToCode(value));
                    this.eye = value;
                    return value;
                }
                case -895981619: {
                    this.sphere = this.castToDecimal(value);
                    return value;
                }
                case -349378602: {
                    this.cylinder = this.castToDecimal(value);
                    return value;
                }
                case 3008417: {
                    this.axis = this.castToInteger(value);
                    return value;
                }
                case 106935105: {
                    this.getPrism().add((PrismComponent)((Object)value));
                    return value;
                }
                case 96417: {
                    this.add = this.castToDecimal(value);
                    return value;
                }
                case 106858757: {
                    this.power = this.castToDecimal(value);
                    return value;
                }
                case 1309344840: {
                    this.backCurve = this.castToDecimal(value);
                    return value;
                }
                case -233204595: {
                    this.diameter = this.castToDecimal(value);
                    return value;
                }
                case -1992012396: {
                    this.duration = this.castToQuantity(value);
                    return value;
                }
                case 94842723: {
                    this.color = this.castToString(value);
                    return value;
                }
                case 93997959: {
                    this.brand = this.castToString(value);
                    return value;
                }
                case 3387378: {
                    this.getNote().add(this.castToAnnotation(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("product")) {
                this.product = this.castToCodeableConcept(value);
            } else if (name.equals("eye")) {
                value = new VisionEyesEnumFactory().fromType(this.castToCode(value));
                this.eye = value;
            } else if (name.equals("sphere")) {
                this.sphere = this.castToDecimal(value);
            } else if (name.equals("cylinder")) {
                this.cylinder = this.castToDecimal(value);
            } else if (name.equals("axis")) {
                this.axis = this.castToInteger(value);
            } else if (name.equals("prism")) {
                this.getPrism().add((PrismComponent)((Object)value));
            } else if (name.equals("add")) {
                this.add = this.castToDecimal(value);
            } else if (name.equals("power")) {
                this.power = this.castToDecimal(value);
            } else if (name.equals("backCurve")) {
                this.backCurve = this.castToDecimal(value);
            } else if (name.equals("diameter")) {
                this.diameter = this.castToDecimal(value);
            } else if (name.equals("duration")) {
                this.duration = this.castToQuantity(value);
            } else if (name.equals("color")) {
                this.color = this.castToString(value);
            } else if (name.equals("brand")) {
                this.brand = this.castToString(value);
            } else if (name.equals("note")) {
                this.getNote().add(this.castToAnnotation(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("product")) {
                this.product = null;
            } else if (name.equals("eye")) {
                this.eye = null;
            } else if (name.equals("sphere")) {
                this.sphere = null;
            } else if (name.equals("cylinder")) {
                this.cylinder = null;
            } else if (name.equals("axis")) {
                this.axis = null;
            } else if (name.equals("prism")) {
                this.getPrism().remove((PrismComponent)value);
            } else if (name.equals("add")) {
                this.add = null;
            } else if (name.equals("power")) {
                this.power = null;
            } else if (name.equals("backCurve")) {
                this.backCurve = null;
            } else if (name.equals("diameter")) {
                this.diameter = null;
            } else if (name.equals("duration")) {
                this.duration = null;
            } else if (name.equals("color")) {
                this.color = null;
            } else if (name.equals("brand")) {
                this.brand = null;
            } else if (name.equals("note")) {
                this.getNote().remove(this.castToAnnotation(value));
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -309474065: {
                    return this.getProduct();
                }
                case 100913: {
                    return this.getEyeElement();
                }
                case -895981619: {
                    return this.getSphereElement();
                }
                case -349378602: {
                    return this.getCylinderElement();
                }
                case 3008417: {
                    return this.getAxisElement();
                }
                case 106935105: {
                    return this.addPrism();
                }
                case 96417: {
                    return this.getAddElement();
                }
                case 106858757: {
                    return this.getPowerElement();
                }
                case 1309344840: {
                    return this.getBackCurveElement();
                }
                case -233204595: {
                    return this.getDiameterElement();
                }
                case -1992012396: {
                    return this.getDuration();
                }
                case 94842723: {
                    return this.getColorElement();
                }
                case 93997959: {
                    return this.getBrandElement();
                }
                case 3387378: {
                    return this.addNote();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -309474065: {
                    return new String[]{"CodeableConcept"};
                }
                case 100913: {
                    return new String[]{"code"};
                }
                case -895981619: {
                    return new String[]{"decimal"};
                }
                case -349378602: {
                    return new String[]{"decimal"};
                }
                case 3008417: {
                    return new String[]{"integer"};
                }
                case 106935105: {
                    return new String[0];
                }
                case 96417: {
                    return new String[]{"decimal"};
                }
                case 106858757: {
                    return new String[]{"decimal"};
                }
                case 1309344840: {
                    return new String[]{"decimal"};
                }
                case -233204595: {
                    return new String[]{"decimal"};
                }
                case -1992012396: {
                    return new String[]{"SimpleQuantity"};
                }
                case 94842723: {
                    return new String[]{"string"};
                }
                case 93997959: {
                    return new String[]{"string"};
                }
                case 3387378: {
                    return new String[]{"Annotation"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("product")) {
                this.product = new CodeableConcept();
                return this.product;
            }
            if (name.equals("eye")) {
                throw new FHIRException("Cannot call addChild on a singleton property VisionPrescription.eye");
            }
            if (name.equals("sphere")) {
                throw new FHIRException("Cannot call addChild on a singleton property VisionPrescription.sphere");
            }
            if (name.equals("cylinder")) {
                throw new FHIRException("Cannot call addChild on a singleton property VisionPrescription.cylinder");
            }
            if (name.equals("axis")) {
                throw new FHIRException("Cannot call addChild on a singleton property VisionPrescription.axis");
            }
            if (name.equals("prism")) {
                return this.addPrism();
            }
            if (name.equals("add")) {
                throw new FHIRException("Cannot call addChild on a singleton property VisionPrescription.add");
            }
            if (name.equals("power")) {
                throw new FHIRException("Cannot call addChild on a singleton property VisionPrescription.power");
            }
            if (name.equals("backCurve")) {
                throw new FHIRException("Cannot call addChild on a singleton property VisionPrescription.backCurve");
            }
            if (name.equals("diameter")) {
                throw new FHIRException("Cannot call addChild on a singleton property VisionPrescription.diameter");
            }
            if (name.equals("duration")) {
                this.duration = new Quantity();
                return this.duration;
            }
            if (name.equals("color")) {
                throw new FHIRException("Cannot call addChild on a singleton property VisionPrescription.color");
            }
            if (name.equals("brand")) {
                throw new FHIRException("Cannot call addChild on a singleton property VisionPrescription.brand");
            }
            if (name.equals("note")) {
                return this.addNote();
            }
            return super.addChild(name);
        }

        @Override
        public VisionPrescriptionLensSpecificationComponent copy() {
            VisionPrescriptionLensSpecificationComponent dst = new VisionPrescriptionLensSpecificationComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(VisionPrescriptionLensSpecificationComponent dst) {
            super.copyValues(dst);
            dst.product = this.product == null ? null : this.product.copy();
            dst.eye = this.eye == null ? null : this.eye.copy();
            dst.sphere = this.sphere == null ? null : this.sphere.copy();
            dst.cylinder = this.cylinder == null ? null : this.cylinder.copy();
            IntegerType integerType = dst.axis = this.axis == null ? null : this.axis.copy();
            if (this.prism != null) {
                dst.prism = new ArrayList<PrismComponent>();
                for (PrismComponent prismComponent : this.prism) {
                    dst.prism.add(prismComponent.copy());
                }
            }
            dst.add = this.add == null ? null : this.add.copy();
            dst.power = this.power == null ? null : this.power.copy();
            dst.backCurve = this.backCurve == null ? null : this.backCurve.copy();
            dst.diameter = this.diameter == null ? null : this.diameter.copy();
            dst.duration = this.duration == null ? null : this.duration.copy();
            dst.color = this.color == null ? null : this.color.copy();
            StringType stringType = dst.brand = this.brand == null ? null : this.brand.copy();
            if (this.note != null) {
                dst.note = new ArrayList<Annotation>();
                for (Annotation annotation : this.note) {
                    dst.note.add(annotation.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof VisionPrescriptionLensSpecificationComponent)) {
                return false;
            }
            VisionPrescriptionLensSpecificationComponent o = (VisionPrescriptionLensSpecificationComponent)other_;
            return VisionPrescriptionLensSpecificationComponent.compareDeep(this.product, o.product, true) && VisionPrescriptionLensSpecificationComponent.compareDeep(this.eye, o.eye, true) && VisionPrescriptionLensSpecificationComponent.compareDeep(this.sphere, o.sphere, true) && VisionPrescriptionLensSpecificationComponent.compareDeep(this.cylinder, o.cylinder, true) && VisionPrescriptionLensSpecificationComponent.compareDeep(this.axis, o.axis, true) && VisionPrescriptionLensSpecificationComponent.compareDeep(this.prism, o.prism, true) && VisionPrescriptionLensSpecificationComponent.compareDeep(this.add, o.add, true) && VisionPrescriptionLensSpecificationComponent.compareDeep(this.power, o.power, true) && VisionPrescriptionLensSpecificationComponent.compareDeep(this.backCurve, o.backCurve, true) && VisionPrescriptionLensSpecificationComponent.compareDeep(this.diameter, o.diameter, true) && VisionPrescriptionLensSpecificationComponent.compareDeep(this.duration, o.duration, true) && VisionPrescriptionLensSpecificationComponent.compareDeep(this.color, o.color, true) && VisionPrescriptionLensSpecificationComponent.compareDeep(this.brand, o.brand, true) && VisionPrescriptionLensSpecificationComponent.compareDeep(this.note, o.note, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof VisionPrescriptionLensSpecificationComponent)) {
                return false;
            }
            VisionPrescriptionLensSpecificationComponent o = (VisionPrescriptionLensSpecificationComponent)other_;
            return VisionPrescriptionLensSpecificationComponent.compareValues(this.eye, o.eye, true) && VisionPrescriptionLensSpecificationComponent.compareValues(this.sphere, o.sphere, true) && VisionPrescriptionLensSpecificationComponent.compareValues(this.cylinder, o.cylinder, true) && VisionPrescriptionLensSpecificationComponent.compareValues(this.axis, o.axis, true) && VisionPrescriptionLensSpecificationComponent.compareValues(this.add, o.add, true) && VisionPrescriptionLensSpecificationComponent.compareValues(this.power, o.power, true) && VisionPrescriptionLensSpecificationComponent.compareValues(this.backCurve, o.backCurve, true) && VisionPrescriptionLensSpecificationComponent.compareValues(this.diameter, o.diameter, true) && VisionPrescriptionLensSpecificationComponent.compareValues(this.color, o.color, true) && VisionPrescriptionLensSpecificationComponent.compareValues(this.brand, o.brand, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.product, this.eye, this.sphere, this.cylinder, this.axis, this.prism, this.add, this.power, this.backCurve, this.diameter, this.duration, this.color, this.brand, this.note});
        }

        @Override
        public String fhirType() {
            return "VisionPrescription.lensSpecification";
        }
    }

    public static class VisionBaseEnumFactory
    implements EnumFactory<VisionBase> {
        @Override
        public VisionBase fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("up".equals(codeString)) {
                return VisionBase.UP;
            }
            if ("down".equals(codeString)) {
                return VisionBase.DOWN;
            }
            if ("in".equals(codeString)) {
                return VisionBase.IN;
            }
            if ("out".equals(codeString)) {
                return VisionBase.OUT;
            }
            throw new IllegalArgumentException("Unknown VisionBase code '" + codeString + "'");
        }

        public Enumeration<VisionBase> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<VisionBase>(this, VisionBase.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<VisionBase>(this, VisionBase.NULL, code);
            }
            if ("up".equals(codeString)) {
                return new Enumeration<VisionBase>(this, VisionBase.UP, code);
            }
            if ("down".equals(codeString)) {
                return new Enumeration<VisionBase>(this, VisionBase.DOWN, code);
            }
            if ("in".equals(codeString)) {
                return new Enumeration<VisionBase>(this, VisionBase.IN, code);
            }
            if ("out".equals(codeString)) {
                return new Enumeration<VisionBase>(this, VisionBase.OUT, code);
            }
            throw new FHIRException("Unknown VisionBase code '" + codeString + "'");
        }

        @Override
        public String toCode(VisionBase code) {
            if (code == VisionBase.UP) {
                return "up";
            }
            if (code == VisionBase.DOWN) {
                return "down";
            }
            if (code == VisionBase.IN) {
                return "in";
            }
            if (code == VisionBase.OUT) {
                return "out";
            }
            return "?";
        }

        @Override
        public String toSystem(VisionBase code) {
            return code.getSystem();
        }
    }

    public static enum VisionBase {
        UP,
        DOWN,
        IN,
        OUT,
        NULL;


        public static VisionBase fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("up".equals(codeString)) {
                return UP;
            }
            if ("down".equals(codeString)) {
                return DOWN;
            }
            if ("in".equals(codeString)) {
                return IN;
            }
            if ("out".equals(codeString)) {
                return OUT;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown VisionBase code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case UP: {
                    return "up";
                }
                case DOWN: {
                    return "down";
                }
                case IN: {
                    return "in";
                }
                case OUT: {
                    return "out";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case UP: {
                    return "http://hl7.org/fhir/vision-base-codes";
                }
                case DOWN: {
                    return "http://hl7.org/fhir/vision-base-codes";
                }
                case IN: {
                    return "http://hl7.org/fhir/vision-base-codes";
                }
                case OUT: {
                    return "http://hl7.org/fhir/vision-base-codes";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case UP: {
                    return "top.";
                }
                case DOWN: {
                    return "bottom.";
                }
                case IN: {
                    return "inner edge.";
                }
                case OUT: {
                    return "outer edge.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case UP: {
                    return "Up";
                }
                case DOWN: {
                    return "Down";
                }
                case IN: {
                    return "In";
                }
                case OUT: {
                    return "Out";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class VisionEyesEnumFactory
    implements EnumFactory<VisionEyes> {
        @Override
        public VisionEyes fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("right".equals(codeString)) {
                return VisionEyes.RIGHT;
            }
            if ("left".equals(codeString)) {
                return VisionEyes.LEFT;
            }
            throw new IllegalArgumentException("Unknown VisionEyes code '" + codeString + "'");
        }

        public Enumeration<VisionEyes> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<VisionEyes>(this, VisionEyes.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<VisionEyes>(this, VisionEyes.NULL, code);
            }
            if ("right".equals(codeString)) {
                return new Enumeration<VisionEyes>(this, VisionEyes.RIGHT, code);
            }
            if ("left".equals(codeString)) {
                return new Enumeration<VisionEyes>(this, VisionEyes.LEFT, code);
            }
            throw new FHIRException("Unknown VisionEyes code '" + codeString + "'");
        }

        @Override
        public String toCode(VisionEyes code) {
            if (code == VisionEyes.RIGHT) {
                return "right";
            }
            if (code == VisionEyes.LEFT) {
                return "left";
            }
            return "?";
        }

        @Override
        public String toSystem(VisionEyes code) {
            return code.getSystem();
        }
    }

    public static enum VisionEyes {
        RIGHT,
        LEFT,
        NULL;


        public static VisionEyes fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("right".equals(codeString)) {
                return RIGHT;
            }
            if ("left".equals(codeString)) {
                return LEFT;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown VisionEyes code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case RIGHT: {
                    return "right";
                }
                case LEFT: {
                    return "left";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case RIGHT: {
                    return "http://hl7.org/fhir/vision-eye-codes";
                }
                case LEFT: {
                    return "http://hl7.org/fhir/vision-eye-codes";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case RIGHT: {
                    return "Right Eye.";
                }
                case LEFT: {
                    return "Left Eye.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case RIGHT: {
                    return "Right Eye";
                }
                case LEFT: {
                    return "Left Eye";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class VisionStatusEnumFactory
    implements EnumFactory<VisionStatus> {
        @Override
        public VisionStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("active".equals(codeString)) {
                return VisionStatus.ACTIVE;
            }
            if ("cancelled".equals(codeString)) {
                return VisionStatus.CANCELLED;
            }
            if ("draft".equals(codeString)) {
                return VisionStatus.DRAFT;
            }
            if ("entered-in-error".equals(codeString)) {
                return VisionStatus.ENTEREDINERROR;
            }
            throw new IllegalArgumentException("Unknown VisionStatus code '" + codeString + "'");
        }

        public Enumeration<VisionStatus> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<VisionStatus>(this, VisionStatus.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<VisionStatus>(this, VisionStatus.NULL, code);
            }
            if ("active".equals(codeString)) {
                return new Enumeration<VisionStatus>(this, VisionStatus.ACTIVE, code);
            }
            if ("cancelled".equals(codeString)) {
                return new Enumeration<VisionStatus>(this, VisionStatus.CANCELLED, code);
            }
            if ("draft".equals(codeString)) {
                return new Enumeration<VisionStatus>(this, VisionStatus.DRAFT, code);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<VisionStatus>(this, VisionStatus.ENTEREDINERROR, code);
            }
            throw new FHIRException("Unknown VisionStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(VisionStatus code) {
            if (code == VisionStatus.ACTIVE) {
                return "active";
            }
            if (code == VisionStatus.CANCELLED) {
                return "cancelled";
            }
            if (code == VisionStatus.DRAFT) {
                return "draft";
            }
            if (code == VisionStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            return "?";
        }

        @Override
        public String toSystem(VisionStatus code) {
            return code.getSystem();
        }
    }

    public static enum VisionStatus {
        ACTIVE,
        CANCELLED,
        DRAFT,
        ENTEREDINERROR,
        NULL;


        public static VisionStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("active".equals(codeString)) {
                return ACTIVE;
            }
            if ("cancelled".equals(codeString)) {
                return CANCELLED;
            }
            if ("draft".equals(codeString)) {
                return DRAFT;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown VisionStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ACTIVE: {
                    return "active";
                }
                case CANCELLED: {
                    return "cancelled";
                }
                case DRAFT: {
                    return "draft";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ACTIVE: {
                    return "http://hl7.org/fhir/fm-status";
                }
                case CANCELLED: {
                    return "http://hl7.org/fhir/fm-status";
                }
                case DRAFT: {
                    return "http://hl7.org/fhir/fm-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/fm-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ACTIVE: {
                    return "The instance is currently in-force.";
                }
                case CANCELLED: {
                    return "The instance is withdrawn, rescinded or reversed.";
                }
                case DRAFT: {
                    return "A new instance the contents of which is not complete.";
                }
                case ENTEREDINERROR: {
                    return "The instance was entered in error.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ACTIVE: {
                    return "Active";
                }
                case CANCELLED: {
                    return "Cancelled";
                }
                case DRAFT: {
                    return "Draft";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

