/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ContractAssetscope {
    THING,
    NULL;


    public static ContractAssetscope fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("thing".equals(codeString)) {
            return THING;
        }
        throw new FHIRException("Unknown ContractAssetscope code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case THING: {
                return "thing";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/contract-asset-scope";
    }

    public String getDefinition() {
        switch (this) {
            case THING: {
                return "To be completed";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case THING: {
                return "Thing";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

