/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum V3ContainerSeparator {
    GEL,
    NONE,
    NULL;


    public static V3ContainerSeparator fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("GEL".equals(codeString)) {
            return GEL;
        }
        if ("NONE".equals(codeString)) {
            return NONE;
        }
        throw new FHIRException("Unknown V3ContainerSeparator code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case GEL: {
                return "GEL";
            }
            case NONE: {
                return "NONE";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/v3-ContainerSeparator";
    }

    public String getDefinition() {
        switch (this) {
            case GEL: {
                return "A gelatinous type of separator material.";
            }
            case NONE: {
                return "No separator material is present in the container.";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case GEL: {
                return "Gel";
            }
            case NONE: {
                return "None";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

