/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum V3Hl7ITSType {
    UML,
    XML,
    NULL;


    public static V3Hl7ITSType fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("UML".equals(codeString)) {
            return UML;
        }
        if ("XML".equals(codeString)) {
            return XML;
        }
        throw new FHIRException("Unknown V3Hl7ITSType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case UML: {
                return "UML";
            }
            case XML: {
                return "XML";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/v3-hl7ITSType";
    }

    public String getDefinition() {
        switch (this) {
            case UML: {
                return "Description: ITS based on the Universal Modeling Language.";
            }
            case XML: {
                return "Description: ITS based on the Extensible Markup Language.";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case UML: {
                return "universal modeling language";
            }
            case XML: {
                return "extensible markup language";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

