/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.profilemodel;

import java.util.List;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.ElementDefinition;
import org.hl7.fhir.r4.model.StructureDefinition;
import org.hl7.fhir.r4.profilemodel.PEBuilder;
import org.hl7.fhir.r4.profilemodel.PEDefinition;
import org.hl7.fhir.r4.profilemodel.PEType;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;

public class PEDefinitionTypeSlice
extends PEDefinition {
    protected ElementDefinition sliceDefinition;

    public PEDefinitionTypeSlice(PEBuilder builder, String name, StructureDefinition profile, ElementDefinition definition, ElementDefinition sliceDefinition, String ppath) {
        super(builder, name, profile, definition, ppath);
        this.sliceDefinition = sliceDefinition;
    }

    @Override
    public void listTypes(List<PEType> types) {
        for (ElementDefinition.TypeRefComponent t : this.definition.getType()) {
            if (t.hasProfile()) {
                for (CanonicalType u : t.getProfile()) {
                    types.add(this.builder.makeType(t, u));
                }
                continue;
            }
            if (t.getCode().startsWith("http://hl7.org/fhirpath/")) continue;
            types.add(new PEType(t.getWorkingCode(), t.getWorkingCode(), "http://hl7.org/fhir/StructureDefinition/" + t.getWorkingCode()));
        }
    }

    @Override
    protected void makeChildren(String typeUrl, List<PEDefinition> children, boolean allFixed) {
        children.addAll(this.builder.listChildren(allFixed, this, this.profile, this.definition, typeUrl, new String[0]));
    }

    @Override
    public String fhirpath() {
        String base = this.definition.getName().replace("[x]", "");
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder(" | ");
        for (ElementDefinition.TypeRefComponent t : this.definition.getType()) {
            b.append(base + ".ofType(" + t.getWorkingCode() + ")");
        }
        return b.toString();
    }
}

