/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.terminologies;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.CodeSystem;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Meta;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.r4.model.UriType;
import org.hl7.fhir.r4.utils.ToolingExtensions;
import org.hl7.fhir.utilities.StandardsStatus;
import org.hl7.fhir.utilities.Utilities;

public class CodeSystemUtilities {
    public static boolean isNotSelectable(CodeSystem cs, CodeSystem.ConceptDefinitionComponent def) {
        for (CodeSystem.ConceptPropertyComponent p : def.getProperty()) {
            if (!p.getCode().equals("notSelectable") || !p.hasValue() || !(p.getValue() instanceof BooleanType)) continue;
            return (Boolean)((BooleanType)p.getValue()).getValue();
        }
        return false;
    }

    public static void setNotSelectable(CodeSystem cs, CodeSystem.ConceptDefinitionComponent concept) throws FHIRFormatError {
        CodeSystemUtilities.defineNotSelectableProperty(cs);
        CodeSystem.ConceptPropertyComponent p = CodeSystemUtilities.getProperty(concept, "abstract");
        if (p != null) {
            p.setValue(new BooleanType(true));
        } else {
            concept.addProperty().setCode("notSelectable").setValue(new BooleanType(true));
        }
    }

    public static void defineNotSelectableProperty(CodeSystem cs) {
        CodeSystemUtilities.defineCodeSystemProperty(cs, "notSelectable", "Indicates that the code is abstract - only intended to be used as a selector for other concepts", CodeSystem.PropertyType.BOOLEAN);
    }

    public static Coding readCoding(String jurisdiction) {
        return jurisdiction == null || !jurisdiction.contains("#") ? null : new Coding().setCode(jurisdiction.substring(jurisdiction.indexOf("#") + 1)).setSystem(jurisdiction.substring(0, jurisdiction.indexOf("#")));
    }

    public static void setStatus(CodeSystem cs, CodeSystem.ConceptDefinitionComponent concept, ConceptStatus status) throws FHIRFormatError {
        CodeSystemUtilities.defineStatusProperty(cs);
        CodeSystem.ConceptPropertyComponent p = CodeSystemUtilities.getProperty(concept, "status");
        if (p != null) {
            p.setValue(new CodeType(status.toCode()));
        } else {
            concept.addProperty().setCode("status").setValue(new CodeType(status.toCode()));
        }
    }

    public static void defineStatusProperty(CodeSystem cs) {
        CodeSystemUtilities.defineCodeSystemProperty(cs, "status", "A property that indicates the status of the concept. One of active, experimental, deprecated, retired", CodeSystem.PropertyType.CODE);
    }

    private static void defineDeprecatedProperty(CodeSystem cs) {
        CodeSystemUtilities.defineCodeSystemProperty(cs, "deprecationDate", "The date at which a concept was deprecated. Concepts that are deprecated but not inactive can still be used, but their use is discouraged", CodeSystem.PropertyType.DATETIME);
    }

    public static void defineParentProperty(CodeSystem cs) {
        CodeSystemUtilities.defineCodeSystemProperty(cs, "parent", "The concept identified in this property is a parent of the concept on which it is a property. The property type will be 'code'. The meaning of parent/child relationships is defined by the hierarchyMeaning attribute", CodeSystem.PropertyType.CODE);
    }

    public static void defineChildProperty(CodeSystem cs) {
        CodeSystemUtilities.defineCodeSystemProperty(cs, "child", "The concept identified in this property is a child of the concept on which it is a property. The property type will be 'code'. The meaning of parent/child relationships is defined by the hierarchyMeaning attribute", CodeSystem.PropertyType.CODE);
    }

    public static boolean isDeprecated(CodeSystem cs, CodeSystem.ConceptDefinitionComponent def) {
        try {
            for (CodeSystem.ConceptPropertyComponent p : def.getProperty()) {
                if (p.getCode().equals("status") && p.hasValue() && p.hasValueCodeType() && p.getValueCodeType().getCode().equals("deprecated")) {
                    return true;
                }
                if (p.getCode().equals("deprecationDate") && p.hasValue() && p.getValue() instanceof DateTimeType) {
                    return ((DateTimeType)p.getValue()).before(new DateTimeType(Calendar.getInstance()));
                }
                if (!p.getCode().equals("deprecated") || !p.hasValue() || !(p.getValue() instanceof BooleanType)) continue;
                return (Boolean)((BooleanType)p.getValue()).getValue();
            }
            return false;
        }
        catch (FHIRException e) {
            return false;
        }
    }

    public static void setDeprecated(CodeSystem cs, CodeSystem.ConceptDefinitionComponent concept, DateTimeType date) throws FHIRFormatError {
        CodeSystemUtilities.setStatus(cs, concept, ConceptStatus.Deprecated);
        CodeSystemUtilities.defineDeprecatedProperty(cs);
        concept.addProperty().setCode("deprecationDate").setValue(date);
    }

    public static boolean isInactive(CodeSystem cs, CodeSystem.ConceptDefinitionComponent def) throws FHIRException {
        for (CodeSystem.ConceptPropertyComponent p : def.getProperty()) {
            if (!p.getCode().equals("status") || !p.hasValueStringType()) continue;
            return "inactive".equals(p.getValueStringType());
        }
        return false;
    }

    public static boolean isInactive(CodeSystem cs, String code) throws FHIRException {
        CodeSystem.ConceptDefinitionComponent def = CodeSystemUtilities.findCode(cs.getConcept(), code);
        if (def == null) {
            return true;
        }
        return CodeSystemUtilities.isInactive(cs, def);
    }

    public static CodeSystem.PropertyComponent defineCodeSystemProperty(CodeSystem cs, String code, String description, CodeSystem.PropertyType type) {
        for (CodeSystem.PropertyComponent p : cs.getProperty()) {
            if (!p.getCode().equals(code)) continue;
            return p;
        }
        CodeSystem.PropertyComponent p = cs.addProperty();
        p.setCode(code).setDescription(description).setType(type).setUri("http://hl7.org/fhir/concept-properties#" + code);
        return p;
    }

    public static String getCodeDefinition(CodeSystem cs, String code) {
        return CodeSystemUtilities.getCodeDefinition(cs.getConcept(), code);
    }

    private static String getCodeDefinition(List<CodeSystem.ConceptDefinitionComponent> list, String code) {
        for (CodeSystem.ConceptDefinitionComponent c : list) {
            if (c.hasCode() && c.getCode().equals(code)) {
                return c.getDefinition();
            }
            String s = CodeSystemUtilities.getCodeDefinition(c.getConcept(), code);
            if (s == null) continue;
            return s;
        }
        return null;
    }

    public static CodeSystem makeShareable(CodeSystem cs) {
        if (!cs.hasMeta()) {
            cs.setMeta(new Meta());
        }
        for (UriType uriType : cs.getMeta().getProfile()) {
            if (!((String)uriType.getValue()).equals("http://hl7.org/fhir/StructureDefinition/shareablecodesystem")) continue;
            return cs;
        }
        cs.getMeta().getProfile().add(new CanonicalType("http://hl7.org/fhir/StructureDefinition/shareablecodesystem"));
        return cs;
    }

    public static void setOID(CodeSystem cs, String oid) {
        if (!((String)oid).startsWith("urn:oid:")) {
            oid = "urn:oid:" + (String)oid;
        }
        if (!cs.hasIdentifier()) {
            cs.addIdentifier(new Identifier().setSystem("urn:ietf:rfc:3986").setValue((String)oid));
        } else if ("urn:ietf:rfc:3986".equals(cs.getIdentifierFirstRep().getSystem()) && cs.getIdentifierFirstRep().hasValue() && cs.getIdentifierFirstRep().getValue().startsWith("urn:oid:")) {
            cs.getIdentifierFirstRep().setValue((String)oid);
        } else {
            throw new Error("unable to set OID on code system");
        }
    }

    public static boolean hasOID(CodeSystem cs) {
        return CodeSystemUtilities.getOID(cs) != null;
    }

    public static String getOID(CodeSystem cs) {
        if (cs.hasIdentifier() && "urn:ietf:rfc:3986".equals(cs.getIdentifierFirstRep().getSystem()) && cs.getIdentifierFirstRep().hasValue() && cs.getIdentifierFirstRep().getValue().startsWith("urn:oid:")) {
            return cs.getIdentifierFirstRep().getValue().substring(8);
        }
        return null;
    }

    private static CodeSystem.ConceptDefinitionComponent findCode(List<CodeSystem.ConceptDefinitionComponent> list, String code) {
        for (CodeSystem.ConceptDefinitionComponent c : list) {
            if (c.getCode().equals(code)) {
                return c;
            }
            CodeSystem.ConceptDefinitionComponent s = CodeSystemUtilities.findCode(c.getConcept(), code);
            if (s == null) continue;
            return s;
        }
        return null;
    }

    public static void markStatus(CodeSystem cs, String wg, StandardsStatus status, String pckage, String fmm, String normativeVersion) throws FHIRException {
        String sfmm;
        if (wg != null && (!ToolingExtensions.hasExtension(cs, "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg") || Utilities.existsInList((String)ToolingExtensions.readStringExtension(cs, "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg"), (String[])new String[]{"fhir", "vocab"}) && !Utilities.existsInList((String)wg, (String[])new String[]{"fhir", "vocab"}))) {
            ToolingExtensions.setCodeExtension(cs, "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg", wg);
        }
        if (status != null) {
            StandardsStatus ss = ToolingExtensions.getStandardsStatus(cs);
            if (ss == null || ss.isLowerThan(status)) {
                ToolingExtensions.setStandardsStatus(cs, status, normativeVersion);
            }
            if (pckage != null) {
                if (!cs.hasUserData("ballot.package")) {
                    cs.setUserData("ballot.package", pckage);
                } else if (!pckage.equals(cs.getUserString("ballot.package")) && !"infrastructure".equals(cs.getUserString("ballot.package"))) {
                    System.out.println("Code System " + cs.getUrl() + ": ownership clash " + pckage + " vs " + cs.getUserString("ballot.package"));
                }
            }
            if (status == StandardsStatus.NORMATIVE) {
                cs.setExperimental(false);
                cs.setStatus(Enumerations.PublicationStatus.ACTIVE);
            }
        }
        if (fmm != null && (Utilities.noString((String)(sfmm = ToolingExtensions.readStringExtension(cs, "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm"))) || Integer.parseInt(sfmm) < Integer.parseInt(fmm))) {
            ToolingExtensions.setIntegerExtension(cs, "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm", Integer.parseInt(fmm));
        }
    }

    public static Type readProperty(CodeSystem.ConceptDefinitionComponent concept, String code) {
        for (CodeSystem.ConceptPropertyComponent p : concept.getProperty()) {
            if (!p.getCode().equals(code)) continue;
            return p.getValue();
        }
        return null;
    }

    public static CodeSystem.ConceptPropertyComponent getProperty(CodeSystem.ConceptDefinitionComponent concept, String code) {
        for (CodeSystem.ConceptPropertyComponent p : concept.getProperty()) {
            if (!p.getCode().equals(code)) continue;
            return p;
        }
        return null;
    }

    public static List<String> getOtherChildren(CodeSystem cs, CodeSystem.ConceptDefinitionComponent c) {
        ArrayList<String> res = new ArrayList<String>();
        for (CodeSystem.ConceptPropertyComponent p : c.getProperty()) {
            if (!"parent".equals(p.getCode())) continue;
            res.add(p.getValue().primitiveValue());
        }
        return res;
    }

    public static void addOtherChild(CodeSystem cs, CodeSystem.ConceptDefinitionComponent owner, String code) {
        CodeSystemUtilities.defineChildProperty(cs);
        owner.addProperty().setCode("child").setValue(new CodeType(code));
    }

    public static void sortAllCodes(CodeSystem cs) {
        CodeSystemUtilities.sortAllCodes(cs.getConcept());
    }

    public static void sortAllCodes(List<CodeSystem.ConceptDefinitionComponent> list) {
        Collections.sort(list, new ConceptDefinitionComponentSorter());
        for (CodeSystem.ConceptDefinitionComponent cd : list) {
            if (!cd.hasConcept()) continue;
            CodeSystemUtilities.sortAllCodes(cd.getConcept());
        }
    }

    public static class ConceptDefinitionComponentSorter
    implements Comparator<CodeSystem.ConceptDefinitionComponent> {
        @Override
        public int compare(CodeSystem.ConceptDefinitionComponent o1, CodeSystem.ConceptDefinitionComponent o2) {
            return o1.getCode().compareToIgnoreCase(o2.getCode());
        }
    }

    public static enum ConceptStatus {
        Active,
        Experimental,
        Deprecated,
        Retired;


        public String toCode() {
            switch (this) {
                case Active: {
                    return "active";
                }
                case Experimental: {
                    return "experimental";
                }
                case Deprecated: {
                    return "deprecated";
                }
                case Retired: {
                    return "retired";
                }
            }
            return null;
        }
    }
}

