/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4.model.ActivityDefinition;
import org.hl7.fhir.r4.model.Age;
import org.hl7.fhir.r4.model.AllergyIntolerance;
import org.hl7.fhir.r4.model.Annotation;
import org.hl7.fhir.r4.model.BackboneElement;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Condition;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.DateType;
import org.hl7.fhir.r4.model.DiagnosticReport;
import org.hl7.fhir.r4.model.DocumentReference;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Measure;
import org.hl7.fhir.r4.model.Observation;
import org.hl7.fhir.r4.model.OperationDefinition;
import org.hl7.fhir.r4.model.Patient;
import org.hl7.fhir.r4.model.Period;
import org.hl7.fhir.r4.model.PlanDefinition;
import org.hl7.fhir.r4.model.PrimitiveType;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.Questionnaire;
import org.hl7.fhir.r4.model.QuestionnaireResponse;
import org.hl7.fhir.r4.model.Range;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.r4.model.UriType;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="FamilyMemberHistory", profile="http://hl7.org/fhir/StructureDefinition/FamilyMemberHistory")
public class FamilyMemberHistory
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="External Id(s) for this record", formalDefinition="Business identifiers assigned to this family member history by the performer or other systems which remain constant as the resource is updated and propagates from server to server.")
    protected List<Identifier> identifier;
    @Child(name="instantiatesCanonical", type={CanonicalType.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Instantiates FHIR protocol or definition", formalDefinition="The URL pointing to a FHIR-defined protocol, guideline, orderset or other definition that is adhered to in whole or in part by this FamilyMemberHistory.")
    protected List<CanonicalType> instantiatesCanonical;
    @Child(name="instantiatesUri", type={UriType.class}, order=2, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Instantiates external protocol or definition", formalDefinition="The URL pointing to an externally maintained protocol, guideline, orderset or other definition that is adhered to in whole or in part by this FamilyMemberHistory.")
    protected List<UriType> instantiatesUri;
    @Child(name="status", type={CodeType.class}, order=3, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="partial | completed | entered-in-error | health-unknown", formalDefinition="A code specifying the status of the record of the family history of a specific family member.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/history-status")
    protected Enumeration<FamilyHistoryStatus> status;
    @Child(name="dataAbsentReason", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="subject-unknown | withheld | unable-to-obtain | deferred", formalDefinition="Describes why the family member's history is not available.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/history-absent-reason")
    protected CodeableConcept dataAbsentReason;
    @Child(name="patient", type={Patient.class}, order=5, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Patient history is about", formalDefinition="The person who this history concerns.")
    protected Reference patient;
    protected Patient patientTarget;
    @Child(name="date", type={DateTimeType.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When history was recorded or last updated", formalDefinition="The date (and possibly time) when the family member history was recorded or last updated.")
    protected DateTimeType date;
    @Child(name="name", type={StringType.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The family member described", formalDefinition="This will either be a name or a description; e.g. \"Aunt Susan\", \"my cousin with the red hair\".")
    protected StringType name;
    @Child(name="relationship", type={CodeableConcept.class}, order=8, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Relationship to the subject", formalDefinition="The type of relationship this person has to the patient (father, mother, brother etc.).")
    @Binding(valueSet="http://terminology.hl7.org/ValueSet/v3-FamilyMember")
    protected CodeableConcept relationship;
    @Child(name="sex", type={CodeableConcept.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="male | female | other | unknown", formalDefinition="The birth sex of the family member.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/administrative-gender")
    protected CodeableConcept sex;
    @Child(name="born", type={Period.class, DateType.class, StringType.class}, order=10, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="(approximate) date of birth", formalDefinition="The actual or approximate date of birth of the relative.")
    protected Type born;
    @Child(name="age", type={Age.class, Range.class, StringType.class}, order=11, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="(approximate) age", formalDefinition="The age of the relative at the time the family member history is recorded.")
    protected Type age;
    @Child(name="estimatedAge", type={BooleanType.class}, order=12, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Age is estimated?", formalDefinition="If true, indicates that the age value specified is an estimated value.")
    protected BooleanType estimatedAge;
    @Child(name="deceased", type={BooleanType.class, Age.class, Range.class, DateType.class, StringType.class}, order=13, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Dead? How old/when?", formalDefinition="Deceased flag or the actual or approximate age of the relative at the time of death for the family member history record.")
    protected Type deceased;
    @Child(name="reasonCode", type={CodeableConcept.class}, order=14, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Why was family member history performed?", formalDefinition="Describes why the family member history occurred in coded or textual form.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/clinical-findings")
    protected List<CodeableConcept> reasonCode;
    @Child(name="reasonReference", type={Condition.class, Observation.class, AllergyIntolerance.class, QuestionnaireResponse.class, DiagnosticReport.class, DocumentReference.class}, order=15, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Why was family member history performed?", formalDefinition="Indicates a Condition, Observation, AllergyIntolerance, or QuestionnaireResponse that justifies this family member history event.")
    protected List<Reference> reasonReference;
    protected List<Resource> reasonReferenceTarget;
    @Child(name="note", type={Annotation.class}, order=16, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="General note about related person", formalDefinition="This property allows a non condition-specific note to the made about the related person. Ideally, the note would be in the condition property, but this is not always possible.")
    protected List<Annotation> note;
    @Child(name="condition", type={}, order=17, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Condition that the related person had", formalDefinition="The significant Conditions (or condition) that the family member had. This is a repeating section to allow a system to represent more than one condition per resource, though there is nothing stopping multiple resources - one per condition.")
    protected List<FamilyMemberHistoryConditionComponent> condition;
    private static final long serialVersionUID = -455261406L;
    @SearchParamDefinition(name="date", path="FamilyMemberHistory.date", description="When history was recorded or last updated", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="identifier", path="FamilyMemberHistory.identifier", description="A search by a record identifier", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="code", path="FamilyMemberHistory.condition.code", description="A search by a condition code", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="patient", path="FamilyMemberHistory.patient", description="The identity of a subject to list family member history items for", type="reference", providesMembershipIn={@Compartment(name="Patient")}, target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("FamilyMemberHistory:patient").toLocked();
    @SearchParamDefinition(name="sex", path="FamilyMemberHistory.sex", description="A search by a sex code of a family member", type="token")
    public static final String SP_SEX = "sex";
    public static final TokenClientParam SEX = new TokenClientParam("sex");
    @SearchParamDefinition(name="instantiates-canonical", path="FamilyMemberHistory.instantiatesCanonical", description="Instantiates FHIR protocol or definition", type="reference", target={ActivityDefinition.class, Measure.class, OperationDefinition.class, PlanDefinition.class, Questionnaire.class})
    public static final String SP_INSTANTIATES_CANONICAL = "instantiates-canonical";
    public static final ReferenceClientParam INSTANTIATES_CANONICAL = new ReferenceClientParam("instantiates-canonical");
    public static final Include INCLUDE_INSTANTIATES_CANONICAL = new Include("FamilyMemberHistory:instantiates-canonical").toLocked();
    @SearchParamDefinition(name="instantiates-uri", path="FamilyMemberHistory.instantiatesUri", description="Instantiates external protocol or definition", type="uri")
    public static final String SP_INSTANTIATES_URI = "instantiates-uri";
    public static final UriClientParam INSTANTIATES_URI = new UriClientParam("instantiates-uri");
    @SearchParamDefinition(name="relationship", path="FamilyMemberHistory.relationship", description="A search by a relationship type", type="token")
    public static final String SP_RELATIONSHIP = "relationship";
    public static final TokenClientParam RELATIONSHIP = new TokenClientParam("relationship");
    @SearchParamDefinition(name="status", path="FamilyMemberHistory.status", description="partial | completed | entered-in-error | health-unknown", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public FamilyMemberHistory() {
    }

    public FamilyMemberHistory(Enumeration<FamilyHistoryStatus> status, Reference patient, CodeableConcept relationship) {
        this.status = status;
        this.patient = patient;
        this.relationship = relationship;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public FamilyMemberHistory setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public FamilyMemberHistory addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public List<CanonicalType> getInstantiatesCanonical() {
        if (this.instantiatesCanonical == null) {
            this.instantiatesCanonical = new ArrayList<CanonicalType>();
        }
        return this.instantiatesCanonical;
    }

    public FamilyMemberHistory setInstantiatesCanonical(List<CanonicalType> theInstantiatesCanonical) {
        this.instantiatesCanonical = theInstantiatesCanonical;
        return this;
    }

    public boolean hasInstantiatesCanonical() {
        if (this.instantiatesCanonical == null) {
            return false;
        }
        for (CanonicalType item : this.instantiatesCanonical) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CanonicalType addInstantiatesCanonicalElement() {
        CanonicalType t = new CanonicalType();
        if (this.instantiatesCanonical == null) {
            this.instantiatesCanonical = new ArrayList<CanonicalType>();
        }
        this.instantiatesCanonical.add(t);
        return t;
    }

    public FamilyMemberHistory addInstantiatesCanonical(String value) {
        CanonicalType t = new CanonicalType();
        t.setValue(value);
        if (this.instantiatesCanonical == null) {
            this.instantiatesCanonical = new ArrayList<CanonicalType>();
        }
        this.instantiatesCanonical.add(t);
        return this;
    }

    public boolean hasInstantiatesCanonical(String value) {
        if (this.instantiatesCanonical == null) {
            return false;
        }
        for (CanonicalType v : this.instantiatesCanonical) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public List<UriType> getInstantiatesUri() {
        if (this.instantiatesUri == null) {
            this.instantiatesUri = new ArrayList<UriType>();
        }
        return this.instantiatesUri;
    }

    public FamilyMemberHistory setInstantiatesUri(List<UriType> theInstantiatesUri) {
        this.instantiatesUri = theInstantiatesUri;
        return this;
    }

    public boolean hasInstantiatesUri() {
        if (this.instantiatesUri == null) {
            return false;
        }
        for (UriType item : this.instantiatesUri) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public UriType addInstantiatesUriElement() {
        UriType t = new UriType();
        if (this.instantiatesUri == null) {
            this.instantiatesUri = new ArrayList<UriType>();
        }
        this.instantiatesUri.add(t);
        return t;
    }

    public FamilyMemberHistory addInstantiatesUri(String value) {
        UriType t = new UriType();
        t.setValue(value);
        if (this.instantiatesUri == null) {
            this.instantiatesUri = new ArrayList<UriType>();
        }
        this.instantiatesUri.add(t);
        return this;
    }

    public boolean hasInstantiatesUri(String value) {
        if (this.instantiatesUri == null) {
            return false;
        }
        for (UriType v : this.instantiatesUri) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public Enumeration<FamilyHistoryStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create FamilyMemberHistory.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<FamilyHistoryStatus>(new FamilyHistoryStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public FamilyMemberHistory setStatusElement(Enumeration<FamilyHistoryStatus> value) {
        this.status = value;
        return this;
    }

    public FamilyHistoryStatus getStatus() {
        return this.status == null ? null : (FamilyHistoryStatus)((Object)this.status.getValue());
    }

    public FamilyMemberHistory setStatus(FamilyHistoryStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<FamilyHistoryStatus>(new FamilyHistoryStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public CodeableConcept getDataAbsentReason() {
        if (this.dataAbsentReason == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create FamilyMemberHistory.dataAbsentReason");
            }
            if (Configuration.doAutoCreate()) {
                this.dataAbsentReason = new CodeableConcept();
            }
        }
        return this.dataAbsentReason;
    }

    public boolean hasDataAbsentReason() {
        return this.dataAbsentReason != null && !this.dataAbsentReason.isEmpty();
    }

    public FamilyMemberHistory setDataAbsentReason(CodeableConcept value) {
        this.dataAbsentReason = value;
        return this;
    }

    public Reference getPatient() {
        if (this.patient == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create FamilyMemberHistory.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patient = new Reference();
            }
        }
        return this.patient;
    }

    public boolean hasPatient() {
        return this.patient != null && !this.patient.isEmpty();
    }

    public FamilyMemberHistory setPatient(Reference value) {
        this.patient = value;
        return this;
    }

    public Patient getPatientTarget() {
        if (this.patientTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create FamilyMemberHistory.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patientTarget = new Patient();
            }
        }
        return this.patientTarget;
    }

    public FamilyMemberHistory setPatientTarget(Patient value) {
        this.patientTarget = value;
        return this;
    }

    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create FamilyMemberHistory.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    public FamilyMemberHistory setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    public FamilyMemberHistory setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create FamilyMemberHistory.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    public FamilyMemberHistory setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    public FamilyMemberHistory setName(String value) {
        if (Utilities.noString((String)value)) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
        }
        return this;
    }

    public CodeableConcept getRelationship() {
        if (this.relationship == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create FamilyMemberHistory.relationship");
            }
            if (Configuration.doAutoCreate()) {
                this.relationship = new CodeableConcept();
            }
        }
        return this.relationship;
    }

    public boolean hasRelationship() {
        return this.relationship != null && !this.relationship.isEmpty();
    }

    public FamilyMemberHistory setRelationship(CodeableConcept value) {
        this.relationship = value;
        return this;
    }

    public CodeableConcept getSex() {
        if (this.sex == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create FamilyMemberHistory.sex");
            }
            if (Configuration.doAutoCreate()) {
                this.sex = new CodeableConcept();
            }
        }
        return this.sex;
    }

    public boolean hasSex() {
        return this.sex != null && !this.sex.isEmpty();
    }

    public FamilyMemberHistory setSex(CodeableConcept value) {
        this.sex = value;
        return this;
    }

    public Type getBorn() {
        return this.born;
    }

    public Period getBornPeriod() throws FHIRException {
        if (this.born == null) {
            this.born = new Period();
        }
        if (!(this.born instanceof Period)) {
            throw new FHIRException("Type mismatch: the type Period was expected, but " + this.born.getClass().getName() + " was encountered");
        }
        return (Period)this.born;
    }

    public boolean hasBornPeriod() {
        return this != null && this.born instanceof Period;
    }

    public DateType getBornDateType() throws FHIRException {
        if (this.born == null) {
            this.born = new DateType();
        }
        if (!(this.born instanceof DateType)) {
            throw new FHIRException("Type mismatch: the type DateType was expected, but " + this.born.getClass().getName() + " was encountered");
        }
        return (DateType)this.born;
    }

    public boolean hasBornDateType() {
        return this != null && this.born instanceof DateType;
    }

    public StringType getBornStringType() throws FHIRException {
        if (this.born == null) {
            this.born = new StringType();
        }
        if (!(this.born instanceof StringType)) {
            throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.born.getClass().getName() + " was encountered");
        }
        return (StringType)this.born;
    }

    public boolean hasBornStringType() {
        return this != null && this.born instanceof StringType;
    }

    public boolean hasBorn() {
        return this.born != null && !this.born.isEmpty();
    }

    public FamilyMemberHistory setBorn(Type value) {
        if (!(value == null || value instanceof Period || value instanceof DateType || value instanceof StringType)) {
            throw new Error("Not the right type for FamilyMemberHistory.born[x]: " + value.fhirType());
        }
        this.born = value;
        return this;
    }

    public Type getAge() {
        return this.age;
    }

    public Age getAgeAge() throws FHIRException {
        if (this.age == null) {
            this.age = new Age();
        }
        if (!(this.age instanceof Age)) {
            throw new FHIRException("Type mismatch: the type Age was expected, but " + this.age.getClass().getName() + " was encountered");
        }
        return (Age)this.age;
    }

    public boolean hasAgeAge() {
        return this != null && this.age instanceof Age;
    }

    public Range getAgeRange() throws FHIRException {
        if (this.age == null) {
            this.age = new Range();
        }
        if (!(this.age instanceof Range)) {
            throw new FHIRException("Type mismatch: the type Range was expected, but " + this.age.getClass().getName() + " was encountered");
        }
        return (Range)this.age;
    }

    public boolean hasAgeRange() {
        return this != null && this.age instanceof Range;
    }

    public StringType getAgeStringType() throws FHIRException {
        if (this.age == null) {
            this.age = new StringType();
        }
        if (!(this.age instanceof StringType)) {
            throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.age.getClass().getName() + " was encountered");
        }
        return (StringType)this.age;
    }

    public boolean hasAgeStringType() {
        return this != null && this.age instanceof StringType;
    }

    public boolean hasAge() {
        return this.age != null && !this.age.isEmpty();
    }

    public FamilyMemberHistory setAge(Type value) {
        if (!(value == null || value instanceof Age || value instanceof Range || value instanceof StringType)) {
            throw new Error("Not the right type for FamilyMemberHistory.age[x]: " + value.fhirType());
        }
        this.age = value;
        return this;
    }

    public BooleanType getEstimatedAgeElement() {
        if (this.estimatedAge == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create FamilyMemberHistory.estimatedAge");
            }
            if (Configuration.doAutoCreate()) {
                this.estimatedAge = new BooleanType();
            }
        }
        return this.estimatedAge;
    }

    public boolean hasEstimatedAgeElement() {
        return this.estimatedAge != null && !this.estimatedAge.isEmpty();
    }

    public boolean hasEstimatedAge() {
        return this.estimatedAge != null && !this.estimatedAge.isEmpty();
    }

    public FamilyMemberHistory setEstimatedAgeElement(BooleanType value) {
        this.estimatedAge = value;
        return this;
    }

    public boolean getEstimatedAge() {
        return this.estimatedAge == null || this.estimatedAge.isEmpty() ? false : (Boolean)this.estimatedAge.getValue();
    }

    public FamilyMemberHistory setEstimatedAge(boolean value) {
        if (this.estimatedAge == null) {
            this.estimatedAge = new BooleanType();
        }
        this.estimatedAge.setValue((Object)value);
        return this;
    }

    public Type getDeceased() {
        return this.deceased;
    }

    public BooleanType getDeceasedBooleanType() throws FHIRException {
        if (this.deceased == null) {
            this.deceased = new BooleanType();
        }
        if (!(this.deceased instanceof BooleanType)) {
            throw new FHIRException("Type mismatch: the type BooleanType was expected, but " + this.deceased.getClass().getName() + " was encountered");
        }
        return (BooleanType)this.deceased;
    }

    public boolean hasDeceasedBooleanType() {
        return this != null && this.deceased instanceof BooleanType;
    }

    public Age getDeceasedAge() throws FHIRException {
        if (this.deceased == null) {
            this.deceased = new Age();
        }
        if (!(this.deceased instanceof Age)) {
            throw new FHIRException("Type mismatch: the type Age was expected, but " + this.deceased.getClass().getName() + " was encountered");
        }
        return (Age)this.deceased;
    }

    public boolean hasDeceasedAge() {
        return this != null && this.deceased instanceof Age;
    }

    public Range getDeceasedRange() throws FHIRException {
        if (this.deceased == null) {
            this.deceased = new Range();
        }
        if (!(this.deceased instanceof Range)) {
            throw new FHIRException("Type mismatch: the type Range was expected, but " + this.deceased.getClass().getName() + " was encountered");
        }
        return (Range)this.deceased;
    }

    public boolean hasDeceasedRange() {
        return this != null && this.deceased instanceof Range;
    }

    public DateType getDeceasedDateType() throws FHIRException {
        if (this.deceased == null) {
            this.deceased = new DateType();
        }
        if (!(this.deceased instanceof DateType)) {
            throw new FHIRException("Type mismatch: the type DateType was expected, but " + this.deceased.getClass().getName() + " was encountered");
        }
        return (DateType)this.deceased;
    }

    public boolean hasDeceasedDateType() {
        return this != null && this.deceased instanceof DateType;
    }

    public StringType getDeceasedStringType() throws FHIRException {
        if (this.deceased == null) {
            this.deceased = new StringType();
        }
        if (!(this.deceased instanceof StringType)) {
            throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.deceased.getClass().getName() + " was encountered");
        }
        return (StringType)this.deceased;
    }

    public boolean hasDeceasedStringType() {
        return this != null && this.deceased instanceof StringType;
    }

    public boolean hasDeceased() {
        return this.deceased != null && !this.deceased.isEmpty();
    }

    public FamilyMemberHistory setDeceased(Type value) {
        if (!(value == null || value instanceof BooleanType || value instanceof Age || value instanceof Range || value instanceof DateType || value instanceof StringType)) {
            throw new Error("Not the right type for FamilyMemberHistory.deceased[x]: " + value.fhirType());
        }
        this.deceased = value;
        return this;
    }

    public List<CodeableConcept> getReasonCode() {
        if (this.reasonCode == null) {
            this.reasonCode = new ArrayList<CodeableConcept>();
        }
        return this.reasonCode;
    }

    public FamilyMemberHistory setReasonCode(List<CodeableConcept> theReasonCode) {
        this.reasonCode = theReasonCode;
        return this;
    }

    public boolean hasReasonCode() {
        if (this.reasonCode == null) {
            return false;
        }
        for (CodeableConcept item : this.reasonCode) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addReasonCode() {
        CodeableConcept t = new CodeableConcept();
        if (this.reasonCode == null) {
            this.reasonCode = new ArrayList<CodeableConcept>();
        }
        this.reasonCode.add(t);
        return t;
    }

    public FamilyMemberHistory addReasonCode(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.reasonCode == null) {
            this.reasonCode = new ArrayList<CodeableConcept>();
        }
        this.reasonCode.add(t);
        return this;
    }

    public CodeableConcept getReasonCodeFirstRep() {
        if (this.getReasonCode().isEmpty()) {
            this.addReasonCode();
        }
        return this.getReasonCode().get(0);
    }

    public List<Reference> getReasonReference() {
        if (this.reasonReference == null) {
            this.reasonReference = new ArrayList<Reference>();
        }
        return this.reasonReference;
    }

    public FamilyMemberHistory setReasonReference(List<Reference> theReasonReference) {
        this.reasonReference = theReasonReference;
        return this;
    }

    public boolean hasReasonReference() {
        if (this.reasonReference == null) {
            return false;
        }
        for (Reference item : this.reasonReference) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addReasonReference() {
        Reference t = new Reference();
        if (this.reasonReference == null) {
            this.reasonReference = new ArrayList<Reference>();
        }
        this.reasonReference.add(t);
        return t;
    }

    public FamilyMemberHistory addReasonReference(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.reasonReference == null) {
            this.reasonReference = new ArrayList<Reference>();
        }
        this.reasonReference.add(t);
        return this;
    }

    public Reference getReasonReferenceFirstRep() {
        if (this.getReasonReference().isEmpty()) {
            this.addReasonReference();
        }
        return this.getReasonReference().get(0);
    }

    @Deprecated
    public List<Resource> getReasonReferenceTarget() {
        if (this.reasonReferenceTarget == null) {
            this.reasonReferenceTarget = new ArrayList<Resource>();
        }
        return this.reasonReferenceTarget;
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public FamilyMemberHistory setNote(List<Annotation> theNote) {
        this.note = theNote;
        return this;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public FamilyMemberHistory addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public Annotation getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            this.addNote();
        }
        return this.getNote().get(0);
    }

    public List<FamilyMemberHistoryConditionComponent> getCondition() {
        if (this.condition == null) {
            this.condition = new ArrayList<FamilyMemberHistoryConditionComponent>();
        }
        return this.condition;
    }

    public FamilyMemberHistory setCondition(List<FamilyMemberHistoryConditionComponent> theCondition) {
        this.condition = theCondition;
        return this;
    }

    public boolean hasCondition() {
        if (this.condition == null) {
            return false;
        }
        for (FamilyMemberHistoryConditionComponent item : this.condition) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public FamilyMemberHistoryConditionComponent addCondition() {
        FamilyMemberHistoryConditionComponent t = new FamilyMemberHistoryConditionComponent();
        if (this.condition == null) {
            this.condition = new ArrayList<FamilyMemberHistoryConditionComponent>();
        }
        this.condition.add(t);
        return t;
    }

    public FamilyMemberHistory addCondition(FamilyMemberHistoryConditionComponent t) {
        if (t == null) {
            return this;
        }
        if (this.condition == null) {
            this.condition = new ArrayList<FamilyMemberHistoryConditionComponent>();
        }
        this.condition.add(t);
        return this;
    }

    public FamilyMemberHistoryConditionComponent getConditionFirstRep() {
        if (this.getCondition().isEmpty()) {
            this.addCondition();
        }
        return this.getCondition().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Business identifiers assigned to this family member history by the performer or other systems which remain constant as the resource is updated and propagates from server to server.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property("instantiatesCanonical", "canonical(PlanDefinition|Questionnaire|ActivityDefinition|Measure|OperationDefinition)", "The URL pointing to a FHIR-defined protocol, guideline, orderset or other definition that is adhered to in whole or in part by this FamilyMemberHistory.", 0, Integer.MAX_VALUE, this.instantiatesCanonical));
        children.add(new Property("instantiatesUri", "uri", "The URL pointing to an externally maintained protocol, guideline, orderset or other definition that is adhered to in whole or in part by this FamilyMemberHistory.", 0, Integer.MAX_VALUE, this.instantiatesUri));
        children.add(new Property(SP_STATUS, SP_CODE, "A code specifying the status of the record of the family history of a specific family member.", 0, 1, this.status));
        children.add(new Property("dataAbsentReason", "CodeableConcept", "Describes why the family member's history is not available.", 0, 1, this.dataAbsentReason));
        children.add(new Property(SP_PATIENT, "Reference(Patient)", "The person who this history concerns.", 0, 1, this.patient));
        children.add(new Property(SP_DATE, "dateTime", "The date (and possibly time) when the family member history was recorded or last updated.", 0, 1, this.date));
        children.add(new Property("name", "string", "This will either be a name or a description; e.g. \"Aunt Susan\", \"my cousin with the red hair\".", 0, 1, this.name));
        children.add(new Property(SP_RELATIONSHIP, "CodeableConcept", "The type of relationship this person has to the patient (father, mother, brother etc.).", 0, 1, this.relationship));
        children.add(new Property(SP_SEX, "CodeableConcept", "The birth sex of the family member.", 0, 1, this.sex));
        children.add(new Property("born[x]", "Period|date|string", "The actual or approximate date of birth of the relative.", 0, 1, this.born));
        children.add(new Property("age[x]", "Age|Range|string", "The age of the relative at the time the family member history is recorded.", 0, 1, this.age));
        children.add(new Property("estimatedAge", "boolean", "If true, indicates that the age value specified is an estimated value.", 0, 1, this.estimatedAge));
        children.add(new Property("deceased[x]", "boolean|Age|Range|date|string", "Deceased flag or the actual or approximate age of the relative at the time of death for the family member history record.", 0, 1, this.deceased));
        children.add(new Property("reasonCode", "CodeableConcept", "Describes why the family member history occurred in coded or textual form.", 0, Integer.MAX_VALUE, this.reasonCode));
        children.add(new Property("reasonReference", "Reference(Condition|Observation|AllergyIntolerance|QuestionnaireResponse|DiagnosticReport|DocumentReference)", "Indicates a Condition, Observation, AllergyIntolerance, or QuestionnaireResponse that justifies this family member history event.", 0, Integer.MAX_VALUE, this.reasonReference));
        children.add(new Property("note", "Annotation", "This property allows a non condition-specific note to the made about the related person. Ideally, the note would be in the condition property, but this is not always possible.", 0, Integer.MAX_VALUE, this.note));
        children.add(new Property("condition", "", "The significant Conditions (or condition) that the family member had. This is a repeating section to allow a system to represent more than one condition per resource, though there is nothing stopping multiple resources - one per condition.", 0, Integer.MAX_VALUE, this.condition));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Business identifiers assigned to this family member history by the performer or other systems which remain constant as the resource is updated and propagates from server to server.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case 8911915: {
                return new Property("instantiatesCanonical", "canonical(PlanDefinition|Questionnaire|ActivityDefinition|Measure|OperationDefinition)", "The URL pointing to a FHIR-defined protocol, guideline, orderset or other definition that is adhered to in whole or in part by this FamilyMemberHistory.", 0, Integer.MAX_VALUE, this.instantiatesCanonical);
            }
            case -1926393373: {
                return new Property("instantiatesUri", "uri", "The URL pointing to an externally maintained protocol, guideline, orderset or other definition that is adhered to in whole or in part by this FamilyMemberHistory.", 0, Integer.MAX_VALUE, this.instantiatesUri);
            }
            case -892481550: {
                return new Property(SP_STATUS, SP_CODE, "A code specifying the status of the record of the family history of a specific family member.", 0, 1, this.status);
            }
            case 1034315687: {
                return new Property("dataAbsentReason", "CodeableConcept", "Describes why the family member's history is not available.", 0, 1, this.dataAbsentReason);
            }
            case -791418107: {
                return new Property(SP_PATIENT, "Reference(Patient)", "The person who this history concerns.", 0, 1, this.patient);
            }
            case 3076014: {
                return new Property(SP_DATE, "dateTime", "The date (and possibly time) when the family member history was recorded or last updated.", 0, 1, this.date);
            }
            case 3373707: {
                return new Property("name", "string", "This will either be a name or a description; e.g. \"Aunt Susan\", \"my cousin with the red hair\".", 0, 1, this.name);
            }
            case -261851592: {
                return new Property(SP_RELATIONSHIP, "CodeableConcept", "The type of relationship this person has to the patient (father, mother, brother etc.).", 0, 1, this.relationship);
            }
            case 113766: {
                return new Property(SP_SEX, "CodeableConcept", "The birth sex of the family member.", 0, 1, this.sex);
            }
            case 67532951: {
                return new Property("born[x]", "Period|date|string", "The actual or approximate date of birth of the relative.", 0, 1, this.born);
            }
            case 3029833: {
                return new Property("born[x]", "Period|date|string", "The actual or approximate date of birth of the relative.", 0, 1, this.born);
            }
            case 1497711210: {
                return new Property("born[x]", "Period|date|string", "The actual or approximate date of birth of the relative.", 0, 1, this.born);
            }
            case 2092814999: {
                return new Property("born[x]", "Period|date|string", "The actual or approximate date of birth of the relative.", 0, 1, this.born);
            }
            case 1597451450: {
                return new Property("born[x]", "Period|date|string", "The actual or approximate date of birth of the relative.", 0, 1, this.born);
            }
            case -1419716831: {
                return new Property("age[x]", "Age|Range|string", "The age of the relative at the time the family member history is recorded.", 0, 1, this.age);
            }
            case 96511: {
                return new Property("age[x]", "Age|Range|string", "The age of the relative at the time the family member history is recorded.", 0, 1, this.age);
            }
            case -1419742336: {
                return new Property("age[x]", "Age|Range|string", "The age of the relative at the time the family member history is recorded.", 0, 1, this.age);
            }
            case 1442748286: {
                return new Property("age[x]", "Age|Range|string", "The age of the relative at the time the family member history is recorded.", 0, 1, this.age);
            }
            case 1821821424: {
                return new Property("age[x]", "Age|Range|string", "The age of the relative at the time the family member history is recorded.", 0, 1, this.age);
            }
            case 2130167587: {
                return new Property("estimatedAge", "boolean", "If true, indicates that the age value specified is an estimated value.", 0, 1, this.estimatedAge);
            }
            case -1311442804: {
                return new Property("deceased[x]", "boolean|Age|Range|date|string", "Deceased flag or the actual or approximate age of the relative at the time of death for the family member history record.", 0, 1, this.deceased);
            }
            case 561497972: {
                return new Property("deceased[x]", "boolean|Age|Range|date|string", "Deceased flag or the actual or approximate age of the relative at the time of death for the family member history record.", 0, 1, this.deceased);
            }
            case 497463828: {
                return new Property("deceased[x]", "boolean|Age|Range|date|string", "Deceased flag or the actual or approximate age of the relative at the time of death for the family member history record.", 0, 1, this.deceased);
            }
            case -1311468309: {
                return new Property("deceased[x]", "boolean|Age|Range|date|string", "Deceased flag or the actual or approximate age of the relative at the time of death for the family member history record.", 0, 1, this.deceased);
            }
            case -1880094167: {
                return new Property("deceased[x]", "boolean|Age|Range|date|string", "Deceased flag or the actual or approximate age of the relative at the time of death for the family member history record.", 0, 1, this.deceased);
            }
            case -2000727742: {
                return new Property("deceased[x]", "boolean|Age|Range|date|string", "Deceased flag or the actual or approximate age of the relative at the time of death for the family member history record.", 0, 1, this.deceased);
            }
            case 1892920485: {
                return new Property("deceased[x]", "boolean|Age|Range|date|string", "Deceased flag or the actual or approximate age of the relative at the time of death for the family member history record.", 0, 1, this.deceased);
            }
            case 722137681: {
                return new Property("reasonCode", "CodeableConcept", "Describes why the family member history occurred in coded or textual form.", 0, Integer.MAX_VALUE, this.reasonCode);
            }
            case -1146218137: {
                return new Property("reasonReference", "Reference(Condition|Observation|AllergyIntolerance|QuestionnaireResponse|DiagnosticReport|DocumentReference)", "Indicates a Condition, Observation, AllergyIntolerance, or QuestionnaireResponse that justifies this family member history event.", 0, Integer.MAX_VALUE, this.reasonReference);
            }
            case 3387378: {
                return new Property("note", "Annotation", "This property allows a non condition-specific note to the made about the related person. Ideally, the note would be in the condition property, but this is not always possible.", 0, Integer.MAX_VALUE, this.note);
            }
            case -861311717: {
                return new Property("condition", "", "The significant Conditions (or condition) that the family member had. This is a repeating section to allow a system to represent more than one condition per resource, though there is nothing stopping multiple resources - one per condition.", 0, Integer.MAX_VALUE, this.condition);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 8911915: {
                return this.instantiatesCanonical == null ? new Base[]{} : this.instantiatesCanonical.toArray(new Base[this.instantiatesCanonical.size()]);
            }
            case -1926393373: {
                return this.instantiatesUri == null ? new Base[]{} : this.instantiatesUri.toArray(new Base[this.instantiatesUri.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case 1034315687: {
                Base[] baseArray;
                if (this.dataAbsentReason == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.dataAbsentReason;
                }
                return baseArray;
            }
            case -791418107: {
                Base[] baseArray;
                if (this.patient == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.patient;
                }
                return baseArray;
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.date;
                }
                return baseArray;
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.name;
                }
                return baseArray;
            }
            case -261851592: {
                Base[] baseArray;
                if (this.relationship == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.relationship;
                }
                return baseArray;
            }
            case 113766: {
                Base[] baseArray;
                if (this.sex == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.sex;
                }
                return baseArray;
            }
            case 3029833: {
                Base[] baseArray;
                if (this.born == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.born;
                }
                return baseArray;
            }
            case 96511: {
                Base[] baseArray;
                if (this.age == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.age;
                }
                return baseArray;
            }
            case 2130167587: {
                Base[] baseArray;
                if (this.estimatedAge == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.estimatedAge;
                }
                return baseArray;
            }
            case 561497972: {
                Base[] baseArray;
                if (this.deceased == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.deceased;
                }
                return baseArray;
            }
            case 722137681: {
                return this.reasonCode == null ? new Base[]{} : this.reasonCode.toArray(new Base[this.reasonCode.size()]);
            }
            case -1146218137: {
                return this.reasonReference == null ? new Base[]{} : this.reasonReference.toArray(new Base[this.reasonReference.size()]);
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
            case -861311717: {
                return this.condition == null ? new Base[]{} : this.condition.toArray(new Base[this.condition.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case 8911915: {
                this.getInstantiatesCanonical().add(this.castToCanonical(value));
                return value;
            }
            case -1926393373: {
                this.getInstantiatesUri().add(this.castToUri(value));
                return value;
            }
            case -892481550: {
                value = new FamilyHistoryStatusEnumFactory().fromType(this.castToCode(value));
                this.status = value;
                return value;
            }
            case 1034315687: {
                this.dataAbsentReason = this.castToCodeableConcept(value);
                return value;
            }
            case -791418107: {
                this.patient = this.castToReference(value);
                return value;
            }
            case 3076014: {
                this.date = this.castToDateTime(value);
                return value;
            }
            case 3373707: {
                this.name = this.castToString(value);
                return value;
            }
            case -261851592: {
                this.relationship = this.castToCodeableConcept(value);
                return value;
            }
            case 113766: {
                this.sex = this.castToCodeableConcept(value);
                return value;
            }
            case 3029833: {
                this.born = this.castToType(value);
                return value;
            }
            case 96511: {
                this.age = this.castToType(value);
                return value;
            }
            case 2130167587: {
                this.estimatedAge = this.castToBoolean(value);
                return value;
            }
            case 561497972: {
                this.deceased = this.castToType(value);
                return value;
            }
            case 722137681: {
                this.getReasonCode().add(this.castToCodeableConcept(value));
                return value;
            }
            case -1146218137: {
                this.getReasonReference().add(this.castToReference(value));
                return value;
            }
            case 3387378: {
                this.getNote().add(this.castToAnnotation(value));
                return value;
            }
            case -861311717: {
                this.getCondition().add((FamilyMemberHistoryConditionComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals("instantiatesCanonical")) {
            this.getInstantiatesCanonical().add(this.castToCanonical(value));
        } else if (name.equals("instantiatesUri")) {
            this.getInstantiatesUri().add(this.castToUri(value));
        } else if (name.equals(SP_STATUS)) {
            value = new FamilyHistoryStatusEnumFactory().fromType(this.castToCode(value));
            this.status = value;
        } else if (name.equals("dataAbsentReason")) {
            this.dataAbsentReason = this.castToCodeableConcept(value);
        } else if (name.equals(SP_PATIENT)) {
            this.patient = this.castToReference(value);
        } else if (name.equals(SP_DATE)) {
            this.date = this.castToDateTime(value);
        } else if (name.equals("name")) {
            this.name = this.castToString(value);
        } else if (name.equals(SP_RELATIONSHIP)) {
            this.relationship = this.castToCodeableConcept(value);
        } else if (name.equals(SP_SEX)) {
            this.sex = this.castToCodeableConcept(value);
        } else if (name.equals("born[x]")) {
            this.born = this.castToType(value);
        } else if (name.equals("age[x]")) {
            this.age = this.castToType(value);
        } else if (name.equals("estimatedAge")) {
            this.estimatedAge = this.castToBoolean(value);
        } else if (name.equals("deceased[x]")) {
            this.deceased = this.castToType(value);
        } else if (name.equals("reasonCode")) {
            this.getReasonCode().add(this.castToCodeableConcept(value));
        } else if (name.equals("reasonReference")) {
            this.getReasonReference().add(this.castToReference(value));
        } else if (name.equals("note")) {
            this.getNote().add(this.castToAnnotation(value));
        } else if (name.equals("condition")) {
            this.getCondition().add((FamilyMemberHistoryConditionComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public void removeChild(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().remove(this.castToIdentifier(value));
        } else if (name.equals("instantiatesCanonical")) {
            this.getInstantiatesCanonical().remove(this.castToCanonical(value));
        } else if (name.equals("instantiatesUri")) {
            this.getInstantiatesUri().remove(this.castToUri(value));
        } else if (name.equals(SP_STATUS)) {
            this.status = null;
        } else if (name.equals("dataAbsentReason")) {
            this.dataAbsentReason = null;
        } else if (name.equals(SP_PATIENT)) {
            this.patient = null;
        } else if (name.equals(SP_DATE)) {
            this.date = null;
        } else if (name.equals("name")) {
            this.name = null;
        } else if (name.equals(SP_RELATIONSHIP)) {
            this.relationship = null;
        } else if (name.equals(SP_SEX)) {
            this.sex = null;
        } else if (name.equals("born[x]")) {
            this.born = null;
        } else if (name.equals("age[x]")) {
            this.age = null;
        } else if (name.equals("estimatedAge")) {
            this.estimatedAge = null;
        } else if (name.equals("deceased[x]")) {
            this.deceased = null;
        } else if (name.equals("reasonCode")) {
            this.getReasonCode().remove(this.castToCodeableConcept(value));
        } else if (name.equals("reasonReference")) {
            this.getReasonReference().remove(this.castToReference(value));
        } else if (name.equals("note")) {
            this.getNote().remove(this.castToAnnotation(value));
        } else if (name.equals("condition")) {
            this.getCondition().remove((FamilyMemberHistoryConditionComponent)value);
        } else {
            super.removeChild(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case 8911915: {
                return this.addInstantiatesCanonicalElement();
            }
            case -1926393373: {
                return this.addInstantiatesUriElement();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 1034315687: {
                return this.getDataAbsentReason();
            }
            case -791418107: {
                return this.getPatient();
            }
            case 3076014: {
                return this.getDateElement();
            }
            case 3373707: {
                return this.getNameElement();
            }
            case -261851592: {
                return this.getRelationship();
            }
            case 113766: {
                return this.getSex();
            }
            case 67532951: {
                return this.getBorn();
            }
            case 3029833: {
                return this.getBorn();
            }
            case -1419716831: {
                return this.getAge();
            }
            case 96511: {
                return this.getAge();
            }
            case 2130167587: {
                return this.getEstimatedAgeElement();
            }
            case -1311442804: {
                return this.getDeceased();
            }
            case 561497972: {
                return this.getDeceased();
            }
            case 722137681: {
                return this.addReasonCode();
            }
            case -1146218137: {
                return this.addReasonReference();
            }
            case 3387378: {
                return this.addNote();
            }
            case -861311717: {
                return this.addCondition();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 8911915: {
                return new String[]{"canonical"};
            }
            case -1926393373: {
                return new String[]{"uri"};
            }
            case -892481550: {
                return new String[]{SP_CODE};
            }
            case 1034315687: {
                return new String[]{"CodeableConcept"};
            }
            case -791418107: {
                return new String[]{"Reference"};
            }
            case 3076014: {
                return new String[]{"dateTime"};
            }
            case 3373707: {
                return new String[]{"string"};
            }
            case -261851592: {
                return new String[]{"CodeableConcept"};
            }
            case 113766: {
                return new String[]{"CodeableConcept"};
            }
            case 3029833: {
                return new String[]{"Period", SP_DATE, "string"};
            }
            case 96511: {
                return new String[]{"Age", "Range", "string"};
            }
            case 2130167587: {
                return new String[]{"boolean"};
            }
            case 561497972: {
                return new String[]{"boolean", "Age", "Range", SP_DATE, "string"};
            }
            case 722137681: {
                return new String[]{"CodeableConcept"};
            }
            case -1146218137: {
                return new String[]{"Reference"};
            }
            case 3387378: {
                return new String[]{"Annotation"};
            }
            case -861311717: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("instantiatesCanonical")) {
            throw new FHIRException("Cannot call addChild on a singleton property FamilyMemberHistory.instantiatesCanonical");
        }
        if (name.equals("instantiatesUri")) {
            throw new FHIRException("Cannot call addChild on a singleton property FamilyMemberHistory.instantiatesUri");
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a singleton property FamilyMemberHistory.status");
        }
        if (name.equals("dataAbsentReason")) {
            this.dataAbsentReason = new CodeableConcept();
            return this.dataAbsentReason;
        }
        if (name.equals(SP_PATIENT)) {
            this.patient = new Reference();
            return this.patient;
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a singleton property FamilyMemberHistory.date");
        }
        if (name.equals("name")) {
            throw new FHIRException("Cannot call addChild on a singleton property FamilyMemberHistory.name");
        }
        if (name.equals(SP_RELATIONSHIP)) {
            this.relationship = new CodeableConcept();
            return this.relationship;
        }
        if (name.equals(SP_SEX)) {
            this.sex = new CodeableConcept();
            return this.sex;
        }
        if (name.equals("bornPeriod")) {
            this.born = new Period();
            return this.born;
        }
        if (name.equals("bornDate")) {
            this.born = new DateType();
            return this.born;
        }
        if (name.equals("bornString")) {
            this.born = new StringType();
            return this.born;
        }
        if (name.equals("ageAge")) {
            this.age = new Age();
            return this.age;
        }
        if (name.equals("ageRange")) {
            this.age = new Range();
            return this.age;
        }
        if (name.equals("ageString")) {
            this.age = new StringType();
            return this.age;
        }
        if (name.equals("estimatedAge")) {
            throw new FHIRException("Cannot call addChild on a singleton property FamilyMemberHistory.estimatedAge");
        }
        if (name.equals("deceasedBoolean")) {
            this.deceased = new BooleanType();
            return this.deceased;
        }
        if (name.equals("deceasedAge")) {
            this.deceased = new Age();
            return this.deceased;
        }
        if (name.equals("deceasedRange")) {
            this.deceased = new Range();
            return this.deceased;
        }
        if (name.equals("deceasedDate")) {
            this.deceased = new DateType();
            return this.deceased;
        }
        if (name.equals("deceasedString")) {
            this.deceased = new StringType();
            return this.deceased;
        }
        if (name.equals("reasonCode")) {
            return this.addReasonCode();
        }
        if (name.equals("reasonReference")) {
            return this.addReasonReference();
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        if (name.equals("condition")) {
            return this.addCondition();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "FamilyMemberHistory";
    }

    @Override
    public FamilyMemberHistory copy() {
        FamilyMemberHistory dst = new FamilyMemberHistory();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(FamilyMemberHistory dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        if (this.instantiatesCanonical != null) {
            dst.instantiatesCanonical = new ArrayList<CanonicalType>();
            for (CanonicalType canonicalType : this.instantiatesCanonical) {
                dst.instantiatesCanonical.add(canonicalType.copy());
            }
        }
        if (this.instantiatesUri != null) {
            dst.instantiatesUri = new ArrayList<UriType>();
            for (UriType uriType : this.instantiatesUri) {
                dst.instantiatesUri.add(uriType.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        dst.dataAbsentReason = this.dataAbsentReason == null ? null : this.dataAbsentReason.copy();
        dst.patient = this.patient == null ? null : this.patient.copy();
        dst.date = this.date == null ? null : this.date.copy();
        dst.name = this.name == null ? null : this.name.copy();
        dst.relationship = this.relationship == null ? null : this.relationship.copy();
        dst.sex = this.sex == null ? null : this.sex.copy();
        dst.born = this.born == null ? null : this.born.copy();
        dst.age = this.age == null ? null : this.age.copy();
        dst.estimatedAge = this.estimatedAge == null ? null : this.estimatedAge.copy();
        Type type = dst.deceased = this.deceased == null ? null : this.deceased.copy();
        if (this.reasonCode != null) {
            dst.reasonCode = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.reasonCode) {
                dst.reasonCode.add(codeableConcept.copy());
            }
        }
        if (this.reasonReference != null) {
            dst.reasonReference = new ArrayList<Reference>();
            for (Reference reference : this.reasonReference) {
                dst.reasonReference.add(reference.copy());
            }
        }
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
        if (this.condition != null) {
            dst.condition = new ArrayList<FamilyMemberHistoryConditionComponent>();
            for (FamilyMemberHistoryConditionComponent familyMemberHistoryConditionComponent : this.condition) {
                dst.condition.add(familyMemberHistoryConditionComponent.copy());
            }
        }
    }

    protected FamilyMemberHistory typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof FamilyMemberHistory)) {
            return false;
        }
        FamilyMemberHistory o = (FamilyMemberHistory)other_;
        return FamilyMemberHistory.compareDeep(this.identifier, o.identifier, true) && FamilyMemberHistory.compareDeep(this.instantiatesCanonical, o.instantiatesCanonical, true) && FamilyMemberHistory.compareDeep(this.instantiatesUri, o.instantiatesUri, true) && FamilyMemberHistory.compareDeep(this.status, o.status, true) && FamilyMemberHistory.compareDeep(this.dataAbsentReason, o.dataAbsentReason, true) && FamilyMemberHistory.compareDeep(this.patient, o.patient, true) && FamilyMemberHistory.compareDeep(this.date, o.date, true) && FamilyMemberHistory.compareDeep(this.name, o.name, true) && FamilyMemberHistory.compareDeep(this.relationship, o.relationship, true) && FamilyMemberHistory.compareDeep(this.sex, o.sex, true) && FamilyMemberHistory.compareDeep(this.born, o.born, true) && FamilyMemberHistory.compareDeep(this.age, o.age, true) && FamilyMemberHistory.compareDeep(this.estimatedAge, o.estimatedAge, true) && FamilyMemberHistory.compareDeep(this.deceased, o.deceased, true) && FamilyMemberHistory.compareDeep(this.reasonCode, o.reasonCode, true) && FamilyMemberHistory.compareDeep(this.reasonReference, o.reasonReference, true) && FamilyMemberHistory.compareDeep(this.note, o.note, true) && FamilyMemberHistory.compareDeep(this.condition, o.condition, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof FamilyMemberHistory)) {
            return false;
        }
        FamilyMemberHistory o = (FamilyMemberHistory)other_;
        return FamilyMemberHistory.compareValues(this.instantiatesUri, o.instantiatesUri, true) && FamilyMemberHistory.compareValues(this.status, o.status, true) && FamilyMemberHistory.compareValues(this.date, o.date, true) && FamilyMemberHistory.compareValues(this.name, o.name, true) && FamilyMemberHistory.compareValues(this.estimatedAge, o.estimatedAge, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.instantiatesCanonical, this.instantiatesUri, this.status, this.dataAbsentReason, this.patient, this.date, this.name, this.relationship, this.sex, this.born, this.age, this.estimatedAge, this.deceased, this.reasonCode, this.reasonReference, this.note, this.condition});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.FamilyMemberHistory;
    }

    @Block
    public static class FamilyMemberHistoryConditionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Condition suffered by relation", formalDefinition="The actual condition specified. Could be a coded condition (like MI or Diabetes) or a less specific string like 'cancer' depending on how much is known about the condition and the capabilities of the creating system.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/condition-code")
        protected CodeableConcept code;
        @Child(name="outcome", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="deceased | permanent disability | etc.", formalDefinition="Indicates what happened following the condition.  If the condition resulted in death, deceased date is captured on the relation.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/condition-outcome")
        protected CodeableConcept outcome;
        @Child(name="contributedToDeath", type={BooleanType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Whether the condition contributed to the cause of death", formalDefinition="This condition contributed to the cause of death of the related person. If contributedToDeath is not populated, then it is unknown.")
        protected BooleanType contributedToDeath;
        @Child(name="onset", type={Age.class, Range.class, Period.class, StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="When condition first manifested", formalDefinition="Either the age of onset, range of approximate age or descriptive string can be recorded.  For conditions with multiple occurrences, this describes the first known occurrence.")
        protected Type onset;
        @Child(name="note", type={Annotation.class}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Extra information about condition", formalDefinition="An area where general notes can be placed about this specific condition.")
        protected List<Annotation> note;
        private static final long serialVersionUID = 1230182301L;

        public FamilyMemberHistoryConditionComponent() {
        }

        public FamilyMemberHistoryConditionComponent(CodeableConcept code) {
            this.code = code;
        }

        public CodeableConcept getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create FamilyMemberHistoryConditionComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableConcept();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public FamilyMemberHistoryConditionComponent setCode(CodeableConcept value) {
            this.code = value;
            return this;
        }

        public CodeableConcept getOutcome() {
            if (this.outcome == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create FamilyMemberHistoryConditionComponent.outcome");
                }
                if (Configuration.doAutoCreate()) {
                    this.outcome = new CodeableConcept();
                }
            }
            return this.outcome;
        }

        public boolean hasOutcome() {
            return this.outcome != null && !this.outcome.isEmpty();
        }

        public FamilyMemberHistoryConditionComponent setOutcome(CodeableConcept value) {
            this.outcome = value;
            return this;
        }

        public BooleanType getContributedToDeathElement() {
            if (this.contributedToDeath == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create FamilyMemberHistoryConditionComponent.contributedToDeath");
                }
                if (Configuration.doAutoCreate()) {
                    this.contributedToDeath = new BooleanType();
                }
            }
            return this.contributedToDeath;
        }

        public boolean hasContributedToDeathElement() {
            return this.contributedToDeath != null && !this.contributedToDeath.isEmpty();
        }

        public boolean hasContributedToDeath() {
            return this.contributedToDeath != null && !this.contributedToDeath.isEmpty();
        }

        public FamilyMemberHistoryConditionComponent setContributedToDeathElement(BooleanType value) {
            this.contributedToDeath = value;
            return this;
        }

        public boolean getContributedToDeath() {
            return this.contributedToDeath == null || this.contributedToDeath.isEmpty() ? false : (Boolean)this.contributedToDeath.getValue();
        }

        public FamilyMemberHistoryConditionComponent setContributedToDeath(boolean value) {
            if (this.contributedToDeath == null) {
                this.contributedToDeath = new BooleanType();
            }
            this.contributedToDeath.setValue((Object)value);
            return this;
        }

        public Type getOnset() {
            return this.onset;
        }

        public Age getOnsetAge() throws FHIRException {
            if (this.onset == null) {
                this.onset = new Age();
            }
            if (!(this.onset instanceof Age)) {
                throw new FHIRException("Type mismatch: the type Age was expected, but " + this.onset.getClass().getName() + " was encountered");
            }
            return (Age)this.onset;
        }

        public boolean hasOnsetAge() {
            return this != null && this.onset instanceof Age;
        }

        public Range getOnsetRange() throws FHIRException {
            if (this.onset == null) {
                this.onset = new Range();
            }
            if (!(this.onset instanceof Range)) {
                throw new FHIRException("Type mismatch: the type Range was expected, but " + this.onset.getClass().getName() + " was encountered");
            }
            return (Range)this.onset;
        }

        public boolean hasOnsetRange() {
            return this != null && this.onset instanceof Range;
        }

        public Period getOnsetPeriod() throws FHIRException {
            if (this.onset == null) {
                this.onset = new Period();
            }
            if (!(this.onset instanceof Period)) {
                throw new FHIRException("Type mismatch: the type Period was expected, but " + this.onset.getClass().getName() + " was encountered");
            }
            return (Period)this.onset;
        }

        public boolean hasOnsetPeriod() {
            return this != null && this.onset instanceof Period;
        }

        public StringType getOnsetStringType() throws FHIRException {
            if (this.onset == null) {
                this.onset = new StringType();
            }
            if (!(this.onset instanceof StringType)) {
                throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.onset.getClass().getName() + " was encountered");
            }
            return (StringType)this.onset;
        }

        public boolean hasOnsetStringType() {
            return this != null && this.onset instanceof StringType;
        }

        public boolean hasOnset() {
            return this.onset != null && !this.onset.isEmpty();
        }

        public FamilyMemberHistoryConditionComponent setOnset(Type value) {
            if (!(value == null || value instanceof Age || value instanceof Range || value instanceof Period || value instanceof StringType)) {
                throw new Error("Not the right type for FamilyMemberHistory.condition.onset[x]: " + value.fhirType());
            }
            this.onset = value;
            return this;
        }

        public List<Annotation> getNote() {
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            return this.note;
        }

        public FamilyMemberHistoryConditionComponent setNote(List<Annotation> theNote) {
            this.note = theNote;
            return this;
        }

        public boolean hasNote() {
            if (this.note == null) {
                return false;
            }
            for (Annotation item : this.note) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Annotation addNote() {
            Annotation t = new Annotation();
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            this.note.add(t);
            return t;
        }

        public FamilyMemberHistoryConditionComponent addNote(Annotation t) {
            if (t == null) {
                return this;
            }
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            this.note.add(t);
            return this;
        }

        public Annotation getNoteFirstRep() {
            if (this.getNote().isEmpty()) {
                this.addNote();
            }
            return this.getNote().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(FamilyMemberHistory.SP_CODE, "CodeableConcept", "The actual condition specified. Could be a coded condition (like MI or Diabetes) or a less specific string like 'cancer' depending on how much is known about the condition and the capabilities of the creating system.", 0, 1, this.code));
            children.add(new Property("outcome", "CodeableConcept", "Indicates what happened following the condition.  If the condition resulted in death, deceased date is captured on the relation.", 0, 1, this.outcome));
            children.add(new Property("contributedToDeath", "boolean", "This condition contributed to the cause of death of the related person. If contributedToDeath is not populated, then it is unknown.", 0, 1, this.contributedToDeath));
            children.add(new Property("onset[x]", "Age|Range|Period|string", "Either the age of onset, range of approximate age or descriptive string can be recorded.  For conditions with multiple occurrences, this describes the first known occurrence.", 0, 1, this.onset));
            children.add(new Property("note", "Annotation", "An area where general notes can be placed about this specific condition.", 0, Integer.MAX_VALUE, this.note));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property(FamilyMemberHistory.SP_CODE, "CodeableConcept", "The actual condition specified. Could be a coded condition (like MI or Diabetes) or a less specific string like 'cancer' depending on how much is known about the condition and the capabilities of the creating system.", 0, 1, this.code);
                }
                case -1106507950: {
                    return new Property("outcome", "CodeableConcept", "Indicates what happened following the condition.  If the condition resulted in death, deceased date is captured on the relation.", 0, 1, this.outcome);
                }
                case -363644638: {
                    return new Property("contributedToDeath", "boolean", "This condition contributed to the cause of death of the related person. If contributedToDeath is not populated, then it is unknown.", 0, 1, this.contributedToDeath);
                }
                case -1886216323: {
                    return new Property("onset[x]", "Age|Range|Period|string", "Either the age of onset, range of approximate age or descriptive string can be recorded.  For conditions with multiple occurrences, this describes the first known occurrence.", 0, 1, this.onset);
                }
                case 105901603: {
                    return new Property("onset[x]", "Age|Range|Period|string", "Either the age of onset, range of approximate age or descriptive string can be recorded.  For conditions with multiple occurrences, this describes the first known occurrence.", 0, 1, this.onset);
                }
                case -1886241828: {
                    return new Property("onset[x]", "Age|Range|Period|string", "Either the age of onset, range of approximate age or descriptive string can be recorded.  For conditions with multiple occurrences, this describes the first known occurrence.", 0, 1, this.onset);
                }
                case -186664742: {
                    return new Property("onset[x]", "Age|Range|Period|string", "Either the age of onset, range of approximate age or descriptive string can be recorded.  For conditions with multiple occurrences, this describes the first known occurrence.", 0, 1, this.onset);
                }
                case -1545082428: {
                    return new Property("onset[x]", "Age|Range|Period|string", "Either the age of onset, range of approximate age or descriptive string can be recorded.  For conditions with multiple occurrences, this describes the first known occurrence.", 0, 1, this.onset);
                }
                case -1445342188: {
                    return new Property("onset[x]", "Age|Range|Period|string", "Either the age of onset, range of approximate age or descriptive string can be recorded.  For conditions with multiple occurrences, this describes the first known occurrence.", 0, 1, this.onset);
                }
                case 3387378: {
                    return new Property("note", "Annotation", "An area where general notes can be placed about this specific condition.", 0, Integer.MAX_VALUE, this.note);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case -1106507950: {
                    Base[] baseArray;
                    if (this.outcome == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.outcome;
                    }
                    return baseArray;
                }
                case -363644638: {
                    Base[] baseArray;
                    if (this.contributedToDeath == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.contributedToDeath;
                    }
                    return baseArray;
                }
                case 105901603: {
                    Base[] baseArray;
                    if (this.onset == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.onset;
                    }
                    return baseArray;
                }
                case 3387378: {
                    return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = this.castToCodeableConcept(value);
                    return value;
                }
                case -1106507950: {
                    this.outcome = this.castToCodeableConcept(value);
                    return value;
                }
                case -363644638: {
                    this.contributedToDeath = this.castToBoolean(value);
                    return value;
                }
                case 105901603: {
                    this.onset = this.castToType(value);
                    return value;
                }
                case 3387378: {
                    this.getNote().add(this.castToAnnotation(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(FamilyMemberHistory.SP_CODE)) {
                this.code = this.castToCodeableConcept(value);
            } else if (name.equals("outcome")) {
                this.outcome = this.castToCodeableConcept(value);
            } else if (name.equals("contributedToDeath")) {
                this.contributedToDeath = this.castToBoolean(value);
            } else if (name.equals("onset[x]")) {
                this.onset = this.castToType(value);
            } else if (name.equals("note")) {
                this.getNote().add(this.castToAnnotation(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals(FamilyMemberHistory.SP_CODE)) {
                this.code = null;
            } else if (name.equals("outcome")) {
                this.outcome = null;
            } else if (name.equals("contributedToDeath")) {
                this.contributedToDeath = null;
            } else if (name.equals("onset[x]")) {
                this.onset = null;
            } else if (name.equals("note")) {
                this.getNote().remove(this.castToAnnotation(value));
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCode();
                }
                case -1106507950: {
                    return this.getOutcome();
                }
                case -363644638: {
                    return this.getContributedToDeathElement();
                }
                case -1886216323: {
                    return this.getOnset();
                }
                case 105901603: {
                    return this.getOnset();
                }
                case 3387378: {
                    return this.addNote();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"CodeableConcept"};
                }
                case -1106507950: {
                    return new String[]{"CodeableConcept"};
                }
                case -363644638: {
                    return new String[]{"boolean"};
                }
                case 105901603: {
                    return new String[]{"Age", "Range", "Period", "string"};
                }
                case 3387378: {
                    return new String[]{"Annotation"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(FamilyMemberHistory.SP_CODE)) {
                this.code = new CodeableConcept();
                return this.code;
            }
            if (name.equals("outcome")) {
                this.outcome = new CodeableConcept();
                return this.outcome;
            }
            if (name.equals("contributedToDeath")) {
                throw new FHIRException("Cannot call addChild on a singleton property FamilyMemberHistory.contributedToDeath");
            }
            if (name.equals("onsetAge")) {
                this.onset = new Age();
                return this.onset;
            }
            if (name.equals("onsetRange")) {
                this.onset = new Range();
                return this.onset;
            }
            if (name.equals("onsetPeriod")) {
                this.onset = new Period();
                return this.onset;
            }
            if (name.equals("onsetString")) {
                this.onset = new StringType();
                return this.onset;
            }
            if (name.equals("note")) {
                return this.addNote();
            }
            return super.addChild(name);
        }

        @Override
        public FamilyMemberHistoryConditionComponent copy() {
            FamilyMemberHistoryConditionComponent dst = new FamilyMemberHistoryConditionComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(FamilyMemberHistoryConditionComponent dst) {
            super.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            dst.outcome = this.outcome == null ? null : this.outcome.copy();
            dst.contributedToDeath = this.contributedToDeath == null ? null : this.contributedToDeath.copy();
            Type type = dst.onset = this.onset == null ? null : this.onset.copy();
            if (this.note != null) {
                dst.note = new ArrayList<Annotation>();
                for (Annotation i : this.note) {
                    dst.note.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof FamilyMemberHistoryConditionComponent)) {
                return false;
            }
            FamilyMemberHistoryConditionComponent o = (FamilyMemberHistoryConditionComponent)other_;
            return FamilyMemberHistoryConditionComponent.compareDeep(this.code, o.code, true) && FamilyMemberHistoryConditionComponent.compareDeep(this.outcome, o.outcome, true) && FamilyMemberHistoryConditionComponent.compareDeep(this.contributedToDeath, o.contributedToDeath, true) && FamilyMemberHistoryConditionComponent.compareDeep(this.onset, o.onset, true) && FamilyMemberHistoryConditionComponent.compareDeep(this.note, o.note, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof FamilyMemberHistoryConditionComponent)) {
                return false;
            }
            FamilyMemberHistoryConditionComponent o = (FamilyMemberHistoryConditionComponent)other_;
            return FamilyMemberHistoryConditionComponent.compareValues(this.contributedToDeath, o.contributedToDeath, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.code, this.outcome, this.contributedToDeath, this.onset, this.note});
        }

        @Override
        public String fhirType() {
            return "FamilyMemberHistory.condition";
        }
    }

    public static class FamilyHistoryStatusEnumFactory
    implements EnumFactory<FamilyHistoryStatus> {
        @Override
        public FamilyHistoryStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("partial".equals(codeString)) {
                return FamilyHistoryStatus.PARTIAL;
            }
            if ("completed".equals(codeString)) {
                return FamilyHistoryStatus.COMPLETED;
            }
            if ("entered-in-error".equals(codeString)) {
                return FamilyHistoryStatus.ENTEREDINERROR;
            }
            if ("health-unknown".equals(codeString)) {
                return FamilyHistoryStatus.HEALTHUNKNOWN;
            }
            throw new IllegalArgumentException("Unknown FamilyHistoryStatus code '" + codeString + "'");
        }

        public Enumeration<FamilyHistoryStatus> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<FamilyHistoryStatus>(this, FamilyHistoryStatus.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<FamilyHistoryStatus>(this, FamilyHistoryStatus.NULL, code);
            }
            if ("partial".equals(codeString)) {
                return new Enumeration<FamilyHistoryStatus>(this, FamilyHistoryStatus.PARTIAL, code);
            }
            if ("completed".equals(codeString)) {
                return new Enumeration<FamilyHistoryStatus>(this, FamilyHistoryStatus.COMPLETED, code);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<FamilyHistoryStatus>(this, FamilyHistoryStatus.ENTEREDINERROR, code);
            }
            if ("health-unknown".equals(codeString)) {
                return new Enumeration<FamilyHistoryStatus>(this, FamilyHistoryStatus.HEALTHUNKNOWN, code);
            }
            throw new FHIRException("Unknown FamilyHistoryStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(FamilyHistoryStatus code) {
            if (code == FamilyHistoryStatus.NULL) {
                return null;
            }
            if (code == FamilyHistoryStatus.PARTIAL) {
                return "partial";
            }
            if (code == FamilyHistoryStatus.COMPLETED) {
                return "completed";
            }
            if (code == FamilyHistoryStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            if (code == FamilyHistoryStatus.HEALTHUNKNOWN) {
                return "health-unknown";
            }
            return "?";
        }

        @Override
        public String toSystem(FamilyHistoryStatus code) {
            return code.getSystem();
        }
    }

    public static enum FamilyHistoryStatus {
        PARTIAL,
        COMPLETED,
        ENTEREDINERROR,
        HEALTHUNKNOWN,
        NULL;


        public static FamilyHistoryStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("partial".equals(codeString)) {
                return PARTIAL;
            }
            if ("completed".equals(codeString)) {
                return COMPLETED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if ("health-unknown".equals(codeString)) {
                return HEALTHUNKNOWN;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown FamilyHistoryStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case PARTIAL: {
                    return "partial";
                }
                case COMPLETED: {
                    return "completed";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case HEALTHUNKNOWN: {
                    return "health-unknown";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case PARTIAL: {
                    return "http://hl7.org/fhir/history-status";
                }
                case COMPLETED: {
                    return "http://hl7.org/fhir/history-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/history-status";
                }
                case HEALTHUNKNOWN: {
                    return "http://hl7.org/fhir/history-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case PARTIAL: {
                    return "Some health information is known and captured, but not complete - see notes for details.";
                }
                case COMPLETED: {
                    return "All available related health information is captured as of the date (and possibly time) when the family member history was taken.";
                }
                case ENTEREDINERROR: {
                    return "This instance should not have been part of this patient's medical record.";
                }
                case HEALTHUNKNOWN: {
                    return "Health information for this family member is unavailable/unknown.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case PARTIAL: {
                    return "Partial";
                }
                case COMPLETED: {
                    return "Completed";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
                case HEALTHUNKNOWN: {
                    return "Health Unknown";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

