/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum AdministrativeGender {
    MALE,
    FEMALE,
    OTHER,
    UNKNOWN,
    NULL;


    public static AdministrativeGender fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("male".equals(codeString)) {
            return MALE;
        }
        if ("female".equals(codeString)) {
            return FEMALE;
        }
        if ("other".equals(codeString)) {
            return OTHER;
        }
        if ("unknown".equals(codeString)) {
            return UNKNOWN;
        }
        throw new FHIRException("Unknown AdministrativeGender code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case MALE: {
                return "male";
            }
            case FEMALE: {
                return "female";
            }
            case OTHER: {
                return "other";
            }
            case UNKNOWN: {
                return "unknown";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/administrative-gender";
    }

    public String getDefinition() {
        switch (this) {
            case MALE: {
                return "Male.";
            }
            case FEMALE: {
                return "Female.";
            }
            case OTHER: {
                return "Other.";
            }
            case UNKNOWN: {
                return "Unknown.";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case MALE: {
                return "Male";
            }
            case FEMALE: {
                return "Female";
            }
            case OTHER: {
                return "Other";
            }
            case UNKNOWN: {
                return "Unknown";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

