/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.codesystems.BundleType;

public class BundleTypeEnumFactory
implements EnumFactory<BundleType> {
    @Override
    public BundleType fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("document".equals(codeString)) {
            return BundleType.DOCUMENT;
        }
        if ("message".equals(codeString)) {
            return BundleType.MESSAGE;
        }
        if ("transaction".equals(codeString)) {
            return BundleType.TRANSACTION;
        }
        if ("transaction-response".equals(codeString)) {
            return BundleType.TRANSACTIONRESPONSE;
        }
        if ("batch".equals(codeString)) {
            return BundleType.BATCH;
        }
        if ("batch-response".equals(codeString)) {
            return BundleType.BATCHRESPONSE;
        }
        if ("history".equals(codeString)) {
            return BundleType.HISTORY;
        }
        if ("searchset".equals(codeString)) {
            return BundleType.SEARCHSET;
        }
        if ("collection".equals(codeString)) {
            return BundleType.COLLECTION;
        }
        throw new IllegalArgumentException("Unknown BundleType code '" + codeString + "'");
    }

    @Override
    public String toCode(BundleType code) {
        if (code == BundleType.NULL) {
            return null;
        }
        if (code == BundleType.DOCUMENT) {
            return "document";
        }
        if (code == BundleType.MESSAGE) {
            return "message";
        }
        if (code == BundleType.TRANSACTION) {
            return "transaction";
        }
        if (code == BundleType.TRANSACTIONRESPONSE) {
            return "transaction-response";
        }
        if (code == BundleType.BATCH) {
            return "batch";
        }
        if (code == BundleType.BATCHRESPONSE) {
            return "batch-response";
        }
        if (code == BundleType.HISTORY) {
            return "history";
        }
        if (code == BundleType.SEARCHSET) {
            return "searchset";
        }
        if (code == BundleType.COLLECTION) {
            return "collection";
        }
        return "?";
    }

    @Override
    public String toSystem(BundleType code) {
        return code.getSystem();
    }
}

