/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.codesystems.CommunicationTopic;

public class CommunicationTopicEnumFactory
implements EnumFactory<CommunicationTopic> {
    @Override
    public CommunicationTopic fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("prescription-refill-request".equals(codeString)) {
            return CommunicationTopic.PRESCRIPTIONREFILLREQUEST;
        }
        if ("progress-update".equals(codeString)) {
            return CommunicationTopic.PROGRESSUPDATE;
        }
        if ("report-labs".equals(codeString)) {
            return CommunicationTopic.REPORTLABS;
        }
        if ("appointment-reminder".equals(codeString)) {
            return CommunicationTopic.APPOINTMENTREMINDER;
        }
        if ("phone-consult".equals(codeString)) {
            return CommunicationTopic.PHONECONSULT;
        }
        if ("summary-report".equals(codeString)) {
            return CommunicationTopic.SUMMARYREPORT;
        }
        throw new IllegalArgumentException("Unknown CommunicationTopic code '" + codeString + "'");
    }

    @Override
    public String toCode(CommunicationTopic code) {
        if (code == CommunicationTopic.NULL) {
            return null;
        }
        if (code == CommunicationTopic.PRESCRIPTIONREFILLREQUEST) {
            return "prescription-refill-request";
        }
        if (code == CommunicationTopic.PROGRESSUPDATE) {
            return "progress-update";
        }
        if (code == CommunicationTopic.REPORTLABS) {
            return "report-labs";
        }
        if (code == CommunicationTopic.APPOINTMENTREMINDER) {
            return "appointment-reminder";
        }
        if (code == CommunicationTopic.PHONECONSULT) {
            return "phone-consult";
        }
        if (code == CommunicationTopic.SUMMARYREPORT) {
            return "summary-report";
        }
        return "?";
    }

    @Override
    public String toSystem(CommunicationTopic code) {
        return code.getSystem();
    }
}

