/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ContractPartyRole {
    FLUNKY,
    NULL;


    public static ContractPartyRole fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("flunky".equals(codeString)) {
            return FLUNKY;
        }
        throw new FHIRException("Unknown ContractPartyRole code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case FLUNKY: {
                return "flunky";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/contract-party-role";
    }

    public String getDefinition() {
        switch (this) {
            case FLUNKY: {
                return "To be completed";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case FLUNKY: {
                return "FLunky";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

