/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum EventResourceTypes {
    CHARGEITEM,
    CLAIMRESPONSE,
    CLINICALIMPRESSION,
    COMMUNICATION,
    COMPOSITION,
    CONDITION,
    CONSENT,
    COVERAGE,
    DEVICEUSESTATEMENT,
    DIAGNOSTICREPORT,
    DOCUMENTMANIFEST,
    DOCUMENTREFERENCE,
    ENCOUNTER,
    ENROLLMENTRESPONSE,
    EPISODEOFCARE,
    EXPLANATIONOFBENEFIT,
    FAMILYMEMBERHISTORY,
    GUIDANCERESPONSE,
    IMAGINGSTUDY,
    IMMUNIZATION,
    MEASUREREPORT,
    MEDIA,
    MEDICATIONADMINISTRATION,
    MEDICATIONDISPENSE,
    MEDICATIONSTATEMENT,
    OBSERVATION,
    PAYMENTNOTICE,
    PAYMENTRECONCILIATION,
    PROCEDURE,
    PROCESSRESPONSE,
    QUESTIONNAIRERESPONSE,
    RISKASSESSMENT,
    SUPPLYDELIVERY,
    TASK,
    NULL;


    public static EventResourceTypes fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("ChargeItem".equals(codeString)) {
            return CHARGEITEM;
        }
        if ("ClaimResponse".equals(codeString)) {
            return CLAIMRESPONSE;
        }
        if ("ClinicalImpression".equals(codeString)) {
            return CLINICALIMPRESSION;
        }
        if ("Communication".equals(codeString)) {
            return COMMUNICATION;
        }
        if ("Composition".equals(codeString)) {
            return COMPOSITION;
        }
        if ("Condition".equals(codeString)) {
            return CONDITION;
        }
        if ("Consent".equals(codeString)) {
            return CONSENT;
        }
        if ("Coverage".equals(codeString)) {
            return COVERAGE;
        }
        if ("DeviceUseStatement".equals(codeString)) {
            return DEVICEUSESTATEMENT;
        }
        if ("DiagnosticReport".equals(codeString)) {
            return DIAGNOSTICREPORT;
        }
        if ("DocumentManifest".equals(codeString)) {
            return DOCUMENTMANIFEST;
        }
        if ("DocumentReference".equals(codeString)) {
            return DOCUMENTREFERENCE;
        }
        if ("Encounter".equals(codeString)) {
            return ENCOUNTER;
        }
        if ("EnrollmentResponse".equals(codeString)) {
            return ENROLLMENTRESPONSE;
        }
        if ("EpisodeOfCare".equals(codeString)) {
            return EPISODEOFCARE;
        }
        if ("ExplanationOfBenefit".equals(codeString)) {
            return EXPLANATIONOFBENEFIT;
        }
        if ("FamilyMemberHistory".equals(codeString)) {
            return FAMILYMEMBERHISTORY;
        }
        if ("GuidanceResponse".equals(codeString)) {
            return GUIDANCERESPONSE;
        }
        if ("ImagingStudy".equals(codeString)) {
            return IMAGINGSTUDY;
        }
        if ("Immunization".equals(codeString)) {
            return IMMUNIZATION;
        }
        if ("MeasureReport".equals(codeString)) {
            return MEASUREREPORT;
        }
        if ("Media".equals(codeString)) {
            return MEDIA;
        }
        if ("MedicationAdministration".equals(codeString)) {
            return MEDICATIONADMINISTRATION;
        }
        if ("MedicationDispense".equals(codeString)) {
            return MEDICATIONDISPENSE;
        }
        if ("MedicationStatement".equals(codeString)) {
            return MEDICATIONSTATEMENT;
        }
        if ("Observation".equals(codeString)) {
            return OBSERVATION;
        }
        if ("PaymentNotice".equals(codeString)) {
            return PAYMENTNOTICE;
        }
        if ("PaymentReconciliation".equals(codeString)) {
            return PAYMENTRECONCILIATION;
        }
        if ("Procedure".equals(codeString)) {
            return PROCEDURE;
        }
        if ("ProcessResponse".equals(codeString)) {
            return PROCESSRESPONSE;
        }
        if ("QuestionnaireResponse".equals(codeString)) {
            return QUESTIONNAIRERESPONSE;
        }
        if ("RiskAssessment".equals(codeString)) {
            return RISKASSESSMENT;
        }
        if ("SupplyDelivery".equals(codeString)) {
            return SUPPLYDELIVERY;
        }
        if ("Task".equals(codeString)) {
            return TASK;
        }
        throw new FHIRException("Unknown EventResourceTypes code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case CHARGEITEM: {
                return "ChargeItem";
            }
            case CLAIMRESPONSE: {
                return "ClaimResponse";
            }
            case CLINICALIMPRESSION: {
                return "ClinicalImpression";
            }
            case COMMUNICATION: {
                return "Communication";
            }
            case COMPOSITION: {
                return "Composition";
            }
            case CONDITION: {
                return "Condition";
            }
            case CONSENT: {
                return "Consent";
            }
            case COVERAGE: {
                return "Coverage";
            }
            case DEVICEUSESTATEMENT: {
                return "DeviceUseStatement";
            }
            case DIAGNOSTICREPORT: {
                return "DiagnosticReport";
            }
            case DOCUMENTMANIFEST: {
                return "DocumentManifest";
            }
            case DOCUMENTREFERENCE: {
                return "DocumentReference";
            }
            case ENCOUNTER: {
                return "Encounter";
            }
            case ENROLLMENTRESPONSE: {
                return "EnrollmentResponse";
            }
            case EPISODEOFCARE: {
                return "EpisodeOfCare";
            }
            case EXPLANATIONOFBENEFIT: {
                return "ExplanationOfBenefit";
            }
            case FAMILYMEMBERHISTORY: {
                return "FamilyMemberHistory";
            }
            case GUIDANCERESPONSE: {
                return "GuidanceResponse";
            }
            case IMAGINGSTUDY: {
                return "ImagingStudy";
            }
            case IMMUNIZATION: {
                return "Immunization";
            }
            case MEASUREREPORT: {
                return "MeasureReport";
            }
            case MEDIA: {
                return "Media";
            }
            case MEDICATIONADMINISTRATION: {
                return "MedicationAdministration";
            }
            case MEDICATIONDISPENSE: {
                return "MedicationDispense";
            }
            case MEDICATIONSTATEMENT: {
                return "MedicationStatement";
            }
            case OBSERVATION: {
                return "Observation";
            }
            case PAYMENTNOTICE: {
                return "PaymentNotice";
            }
            case PAYMENTRECONCILIATION: {
                return "PaymentReconciliation";
            }
            case PROCEDURE: {
                return "Procedure";
            }
            case PROCESSRESPONSE: {
                return "ProcessResponse";
            }
            case QUESTIONNAIRERESPONSE: {
                return "QuestionnaireResponse";
            }
            case RISKASSESSMENT: {
                return "RiskAssessment";
            }
            case SUPPLYDELIVERY: {
                return "SupplyDelivery";
            }
            case TASK: {
                return "Task";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/event-resource-types";
    }

    public String getDefinition() {
        switch (this) {
            case CHARGEITEM: {
                return "Item containing charge code(s) associated with the provision of healthcare provider products.";
            }
            case CLAIMRESPONSE: {
                return "Remittance resource.";
            }
            case CLINICALIMPRESSION: {
                return "A clinical assessment performed when planning treatments and management strategies for a patient.";
            }
            case COMMUNICATION: {
                return "A record of information transmitted from a sender to a receiver.";
            }
            case COMPOSITION: {
                return "A set of resources composed into a single coherent clinical statement with clinical attestation.";
            }
            case CONDITION: {
                return "Detailed information about conditions, problems or diagnoses.";
            }
            case CONSENT: {
                return "A healthcare consumer's policy choices to permits or denies recipients or roles to perform actions for specific purposes and periods of time.";
            }
            case COVERAGE: {
                return "Insurance or medical plan or a payment agreement.";
            }
            case DEVICEUSESTATEMENT: {
                return "Record of use of a device.";
            }
            case DIAGNOSTICREPORT: {
                return "A Diagnostic report - a combination of request information, atomic results, images, interpretation, as well as formatted reports.";
            }
            case DOCUMENTMANIFEST: {
                return "A list that defines a set of documents.";
            }
            case DOCUMENTREFERENCE: {
                return "A reference to a document.";
            }
            case ENCOUNTER: {
                return "An interaction during which services are provided to the patient.";
            }
            case ENROLLMENTRESPONSE: {
                return "EnrollmentResponse resource.";
            }
            case EPISODEOFCARE: {
                return "An association of a Patient with an Organization and  Healthcare Provider(s) for a period of time that the Organization assumes some level of responsibility.";
            }
            case EXPLANATIONOFBENEFIT: {
                return "Explanation of Benefit resource.";
            }
            case FAMILYMEMBERHISTORY: {
                return "Information about patient's relatives, relevant for patient.";
            }
            case GUIDANCERESPONSE: {
                return "The formal response to a guidance request.";
            }
            case IMAGINGSTUDY: {
                return "A set of images produced in single study (one or more series of references images).";
            }
            case IMMUNIZATION: {
                return "Immunization event information.";
            }
            case MEASUREREPORT: {
                return "Results of a measure evaluation.";
            }
            case MEDIA: {
                return "A photo, video, or audio recording acquired or used in healthcare. The actual content may be inline or provided by direct reference.";
            }
            case MEDICATIONADMINISTRATION: {
                return "Administration of medication to a patient.";
            }
            case MEDICATIONDISPENSE: {
                return "Dispensing a medication to a named patient.";
            }
            case MEDICATIONSTATEMENT: {
                return "Record of medication being taken by a patient.";
            }
            case OBSERVATION: {
                return "Measurements and simple assertions.";
            }
            case PAYMENTNOTICE: {
                return "PaymentNotice request.";
            }
            case PAYMENTRECONCILIATION: {
                return "PaymentReconciliation resource.";
            }
            case PROCEDURE: {
                return "An action that is being or was performed on a patient.";
            }
            case PROCESSRESPONSE: {
                return "ProcessResponse resource.";
            }
            case QUESTIONNAIRERESPONSE: {
                return "A structured set of questions and their answers.";
            }
            case RISKASSESSMENT: {
                return "Potential outcomes for a subject with likelihood.";
            }
            case SUPPLYDELIVERY: {
                return "Delivery of bulk Supplies.";
            }
            case TASK: {
                return "A task to be performed.";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case CHARGEITEM: {
                return "ChargeItem";
            }
            case CLAIMRESPONSE: {
                return "ClaimResponse";
            }
            case CLINICALIMPRESSION: {
                return "ClinicalImpression";
            }
            case COMMUNICATION: {
                return "Communication";
            }
            case COMPOSITION: {
                return "Composition";
            }
            case CONDITION: {
                return "Condition";
            }
            case CONSENT: {
                return "Consent";
            }
            case COVERAGE: {
                return "Coverage";
            }
            case DEVICEUSESTATEMENT: {
                return "DeviceUseStatement";
            }
            case DIAGNOSTICREPORT: {
                return "DiagnosticReport";
            }
            case DOCUMENTMANIFEST: {
                return "DocumentManifest";
            }
            case DOCUMENTREFERENCE: {
                return "DocumentReference";
            }
            case ENCOUNTER: {
                return "Encounter";
            }
            case ENROLLMENTRESPONSE: {
                return "EnrollmentResponse";
            }
            case EPISODEOFCARE: {
                return "EpisodeOfCare";
            }
            case EXPLANATIONOFBENEFIT: {
                return "ExplanationOfBenefit";
            }
            case FAMILYMEMBERHISTORY: {
                return "FamilyMemberHistory";
            }
            case GUIDANCERESPONSE: {
                return "GuidanceResponse";
            }
            case IMAGINGSTUDY: {
                return "ImagingStudy";
            }
            case IMMUNIZATION: {
                return "Immunization";
            }
            case MEASUREREPORT: {
                return "MeasureReport";
            }
            case MEDIA: {
                return "Media";
            }
            case MEDICATIONADMINISTRATION: {
                return "MedicationAdministration";
            }
            case MEDICATIONDISPENSE: {
                return "MedicationDispense";
            }
            case MEDICATIONSTATEMENT: {
                return "MedicationStatement";
            }
            case OBSERVATION: {
                return "Observation";
            }
            case PAYMENTNOTICE: {
                return "PaymentNotice";
            }
            case PAYMENTRECONCILIATION: {
                return "PaymentReconciliation";
            }
            case PROCEDURE: {
                return "Procedure";
            }
            case PROCESSRESPONSE: {
                return "ProcessResponse";
            }
            case QUESTIONNAIRERESPONSE: {
                return "QuestionnaireResponse";
            }
            case RISKASSESSMENT: {
                return "RiskAssessment";
            }
            case SUPPLYDELIVERY: {
                return "SupplyDelivery";
            }
            case TASK: {
                return "Task";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

