/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.codesystems.GenderIdentity;

public class GenderIdentityEnumFactory
implements EnumFactory<GenderIdentity> {
    @Override
    public GenderIdentity fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("transgender-female".equals(codeString)) {
            return GenderIdentity.TRANSGENDERFEMALE;
        }
        if ("transgender-male".equals(codeString)) {
            return GenderIdentity.TRANSGENDERMALE;
        }
        if ("non-binary".equals(codeString)) {
            return GenderIdentity.NONBINARY;
        }
        if ("male".equals(codeString)) {
            return GenderIdentity.MALE;
        }
        if ("female".equals(codeString)) {
            return GenderIdentity.FEMALE;
        }
        if ("other".equals(codeString)) {
            return GenderIdentity.OTHER;
        }
        if ("non-disclose".equals(codeString)) {
            return GenderIdentity.NONDISCLOSE;
        }
        throw new IllegalArgumentException("Unknown GenderIdentity code '" + codeString + "'");
    }

    @Override
    public String toCode(GenderIdentity code) {
        if (code == GenderIdentity.NULL) {
            return null;
        }
        if (code == GenderIdentity.TRANSGENDERFEMALE) {
            return "transgender-female";
        }
        if (code == GenderIdentity.TRANSGENDERMALE) {
            return "transgender-male";
        }
        if (code == GenderIdentity.NONBINARY) {
            return "non-binary";
        }
        if (code == GenderIdentity.MALE) {
            return "male";
        }
        if (code == GenderIdentity.FEMALE) {
            return "female";
        }
        if (code == GenderIdentity.OTHER) {
            return "other";
        }
        if (code == GenderIdentity.NONDISCLOSE) {
            return "non-disclose";
        }
        return "?";
    }

    @Override
    public String toSystem(GenderIdentity code) {
        return code.getSystem();
    }
}

