/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum HandlingCondition {
    ROOM,
    REFRIGERATED,
    FROZEN,
    NULL;


    public static HandlingCondition fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("room".equals(codeString)) {
            return ROOM;
        }
        if ("refrigerated".equals(codeString)) {
            return REFRIGERATED;
        }
        if ("frozen".equals(codeString)) {
            return FROZEN;
        }
        throw new FHIRException("Unknown HandlingCondition code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case ROOM: {
                return "room";
            }
            case REFRIGERATED: {
                return "refrigerated";
            }
            case FROZEN: {
                return "frozen";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/handling-condition";
    }

    public String getDefinition() {
        switch (this) {
            case ROOM: {
                return "room temperature.";
            }
            case REFRIGERATED: {
                return "refrigerated temperature.";
            }
            case FROZEN: {
                return "frozen temperature.";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case ROOM: {
                return "room temperature";
            }
            case REFRIGERATED: {
                return "refrigerated";
            }
            case FROZEN: {
                return "frozen";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

