/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.codesystems.MediaType;

public class MediaTypeEnumFactory
implements EnumFactory<MediaType> {
    @Override
    public MediaType fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("image".equals(codeString)) {
            return MediaType.IMAGE;
        }
        if ("video".equals(codeString)) {
            return MediaType.VIDEO;
        }
        if ("audio".equals(codeString)) {
            return MediaType.AUDIO;
        }
        throw new IllegalArgumentException("Unknown MediaType code '" + codeString + "'");
    }

    @Override
    public String toCode(MediaType code) {
        if (code == MediaType.NULL) {
            return null;
        }
        if (code == MediaType.IMAGE) {
            return "image";
        }
        if (code == MediaType.VIDEO) {
            return "video";
        }
        if (code == MediaType.AUDIO) {
            return "audio";
        }
        return "?";
    }

    @Override
    public String toSystem(MediaType code) {
        return code.getSystem();
    }
}

