/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum MedicationStatementStatus {
    ACTIVE,
    COMPLETED,
    ENTEREDINERROR,
    INTENDED,
    STOPPED,
    ONHOLD,
    UNKNOWN,
    NOTTAKEN,
    NULL;


    public static MedicationStatementStatus fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("active".equals(codeString)) {
            return ACTIVE;
        }
        if ("completed".equals(codeString)) {
            return COMPLETED;
        }
        if ("entered-in-error".equals(codeString)) {
            return ENTEREDINERROR;
        }
        if ("intended".equals(codeString)) {
            return INTENDED;
        }
        if ("stopped".equals(codeString)) {
            return STOPPED;
        }
        if ("on-hold".equals(codeString)) {
            return ONHOLD;
        }
        if ("unknown".equals(codeString)) {
            return UNKNOWN;
        }
        if ("not-taken".equals(codeString)) {
            return NOTTAKEN;
        }
        throw new FHIRException("Unknown MedicationStatementStatus code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case ACTIVE: {
                return "active";
            }
            case COMPLETED: {
                return "completed";
            }
            case ENTEREDINERROR: {
                return "entered-in-error";
            }
            case INTENDED: {
                return "intended";
            }
            case STOPPED: {
                return "stopped";
            }
            case ONHOLD: {
                return "on-hold";
            }
            case UNKNOWN: {
                return "unknown";
            }
            case NOTTAKEN: {
                return "not-taken";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/CodeSystem/medication-statement-status";
    }

    public String getDefinition() {
        switch (this) {
            case ACTIVE: {
                return "The medication is still being taken.";
            }
            case COMPLETED: {
                return "The medication is no longer being taken.";
            }
            case ENTEREDINERROR: {
                return "Some of the actions that are implied by the medication statement may have occurred.  For example, the patient may have taken some of the medication.  Clinical decision support systems should take this status into account.";
            }
            case INTENDED: {
                return "The medication may be taken at some time in the future.";
            }
            case STOPPED: {
                return "Actions implied by the statement have been permanently halted, before all of them occurred. This should not be used if the statement was entered in error.";
            }
            case ONHOLD: {
                return "Actions implied by the statement have been temporarily halted, but are expected to continue later. May also be called 'suspended'.";
            }
            case UNKNOWN: {
                return "The state of the medication use is not currently known.";
            }
            case NOTTAKEN: {
                return "The medication was not consumed by the patient";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case ACTIVE: {
                return "Active";
            }
            case COMPLETED: {
                return "Completed";
            }
            case ENTEREDINERROR: {
                return "Entered in Error";
            }
            case INTENDED: {
                return "Intended";
            }
            case STOPPED: {
                return "Stopped";
            }
            case ONHOLD: {
                return "On Hold";
            }
            case UNKNOWN: {
                return "Unknown";
            }
            case NOTTAKEN: {
                return "Not Taken";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

