/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum RelationType {
    TRIGGERS,
    ISREPLACEDBY,
    NULL;


    public static RelationType fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("triggers".equals(codeString)) {
            return TRIGGERS;
        }
        if ("is-replaced-by".equals(codeString)) {
            return ISREPLACEDBY;
        }
        throw new FHIRException("Unknown RelationType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case TRIGGERS: {
                return "triggers";
            }
            case ISREPLACEDBY: {
                return "is-replaced-by";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/relation-type";
    }

    public String getDefinition() {
        switch (this) {
            case TRIGGERS: {
                return "the related entry represents an activity that may be triggered by the current item.";
            }
            case ISREPLACEDBY: {
                return "the related entry represents an item that replaces the current retired item.";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case TRIGGERS: {
                return "Triggers";
            }
            case ISREPLACEDBY: {
                return "Replaced By";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

