/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum RestfulCapabilityMode {
    CLIENT,
    SERVER,
    NULL;


    public static RestfulCapabilityMode fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("client".equals(codeString)) {
            return CLIENT;
        }
        if ("server".equals(codeString)) {
            return SERVER;
        }
        throw new FHIRException("Unknown RestfulCapabilityMode code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case CLIENT: {
                return "client";
            }
            case SERVER: {
                return "server";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/restful-capability-mode";
    }

    public String getDefinition() {
        switch (this) {
            case CLIENT: {
                return "The application acts as a client for this resource.";
            }
            case SERVER: {
                return "The application acts as a server for this resource.";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case CLIENT: {
                return "Client";
            }
            case SERVER: {
                return "Server";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

