/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ServiceProduct {
    EXAM,
    FLUSHOT,
    NULL;


    public static ServiceProduct fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("exam".equals(codeString)) {
            return EXAM;
        }
        if ("flushot".equals(codeString)) {
            return FLUSHOT;
        }
        throw new FHIRException("Unknown ServiceProduct code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case EXAM: {
                return "exam";
            }
            case FLUSHOT: {
                return "flushot";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/ex-serviceproduct";
    }

    public String getDefinition() {
        switch (this) {
            case EXAM: {
                return "Exam";
            }
            case FLUSHOT: {
                return "Flu shot";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case EXAM: {
                return "Exam";
            }
            case FLUSHOT: {
                return "Flu shot";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

