/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.codesystems.VariableType;

public class VariableTypeEnumFactory
implements EnumFactory<VariableType> {
    @Override
    public VariableType fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("dichotomous".equals(codeString)) {
            return VariableType.DICHOTOMOUS;
        }
        if ("continuous".equals(codeString)) {
            return VariableType.CONTINUOUS;
        }
        if ("descriptive".equals(codeString)) {
            return VariableType.DESCRIPTIVE;
        }
        throw new IllegalArgumentException("Unknown VariableType code '" + codeString + "'");
    }

    @Override
    public String toCode(VariableType code) {
        if (code == VariableType.NULL) {
            return null;
        }
        if (code == VariableType.DICHOTOMOUS) {
            return "dichotomous";
        }
        if (code == VariableType.CONTINUOUS) {
            return "continuous";
        }
        if (code == VariableType.DESCRIPTIVE) {
            return "descriptive";
        }
        return "?";
    }

    @Override
    public String toSystem(VariableType code) {
        return code.getSystem();
    }
}

