/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.utils;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.Arrays;
import java.util.HashSet;
import org.hl7.fhir.r4.formats.IParser;
import org.hl7.fhir.r4.formats.JsonParser;
import org.hl7.fhir.r4.model.MetadataResource;
import org.hl7.fhir.r4.model.Parameters;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.filesystem.ManagedFileAccess;

public class ParametersBuilder {
    private String folder;
    private String baseId;

    public static void main(String[] args) throws FileNotFoundException, IOException {
        new ParametersBuilder(args[0], args[1]).process(args[2]);
    }

    protected ParametersBuilder(String folder, String baseId) {
        this.folder = folder;
        this.baseId = baseId;
    }

    private void process(String output) throws FileNotFoundException, IOException {
        Parameters p = new Parameters();
        HashSet<CallSite> ids = new HashSet<CallSite>();
        for (File f : ManagedFileAccess.file((String)this.folder).listFiles()) {
            if (!f.getName().startsWith(this.baseId) || !f.getName().startsWith(this.baseId)) continue;
            byte[] cnt = TextFile.fileToBytes((File)f);
            MetadataResource r = (MetadataResource)new JsonParser().parse(cnt = this.shaveZeros(cnt));
            if (ids.contains(r.getUrl() + "|" + r.getVersion())) continue;
            ids.add((CallSite)((Object)(r.getUrl() + "|" + r.getVersion())));
            p.addParameter().setName("tx-resource").setResource(r);
        }
        new JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).compose(ManagedFileAccess.outStream((String)output), p);
    }

    private byte[] shaveZeros(byte[] cnt) {
        for (int i = 0; i < cnt.length; ++i) {
            if (cnt[i] != 0) continue;
            return Arrays.copyOf(cnt, i - 1);
        }
        return cnt;
    }
}

