/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.context;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.context.IWorkerContext;
import org.hl7.fhir.r4.formats.IParser;
import org.hl7.fhir.r4.formats.JsonParser;
import org.hl7.fhir.r4.model.CodeSystem;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.UriType;
import org.hl7.fhir.r4.model.ValueSet;
import org.hl7.fhir.r4.terminologies.ValueSetExpander;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.filesystem.ManagedFileAccess;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.utilities.validation.ValidationOptions;

public class TerminologyCache {
    public static final boolean TRANSIENT = false;
    public static final boolean PERMANENT = true;
    private static final String NAME_FOR_NO_SYSTEM = "all-systems";
    private static final String ENTRY_MARKER = "-------------------------------------------------------------------------------------";
    private static final String BREAK = "####";
    private SystemNameKeyGenerator systemNameKeyGenerator = new SystemNameKeyGenerator();
    private Object lock;
    private String folder;
    private Map<String, NamedCache> caches = new HashMap<String, NamedCache>();

    protected SystemNameKeyGenerator getSystemNameKeyGenerator() {
        return this.systemNameKeyGenerator;
    }

    public TerminologyCache(Object lock, String folder) throws FileNotFoundException, IOException, FHIRException {
        this.lock = lock;
        this.folder = folder;
        if (folder != null) {
            this.load();
        }
    }

    public CacheToken generateValidationToken(ValidationOptions options, Coding code, ValueSet vs) {
        CacheToken ct = new CacheToken();
        ct.name = code.hasSystem() ? this.getSystemNameKeyGenerator().getNameForSystem(code.getSystem()) : NAME_FOR_NO_SYSTEM;
        JsonParser json = new JsonParser();
        json.setOutputStyle(IParser.OutputStyle.PRETTY);
        ValueSet vsc = this.getVSEssense(vs);
        try {
            ct.request = "{\"code\" : " + json.composeString(code, "code") + ", \"valueSet\" :" + (vsc == null ? "null" : json.composeString(vsc)) + (String)(options == null ? "" : ", " + options.toJson()) + "}";
        }
        catch (IOException e) {
            throw new Error(e);
        }
        ct.key = String.valueOf(this.hashNWS(ct.request));
        return ct;
    }

    public CacheToken generateValidationToken(ValidationOptions options, CodeableConcept code, ValueSet vs) {
        CacheToken ct = new CacheToken();
        for (Coding c : code.getCoding()) {
            if (!c.hasSystem()) continue;
            ct.setName(c.getSystem());
        }
        JsonParser json = new JsonParser();
        json.setOutputStyle(IParser.OutputStyle.PRETTY);
        ValueSet vsc = this.getVSEssense(vs);
        try {
            ct.request = "{\"code\" : " + json.composeString(code, "codeableConcept") + ", \"valueSet\" :" + json.composeString(vsc) + (String)(options == null ? "" : ", " + options.toJson()) + "}";
        }
        catch (IOException e) {
            throw new Error(e);
        }
        ct.key = String.valueOf(this.hashNWS(ct.request));
        return ct;
    }

    public ValueSet getVSEssense(ValueSet vs) {
        if (vs == null) {
            return null;
        }
        ValueSet vsc = new ValueSet();
        vsc.setCompose(vs.getCompose());
        if (vs.hasExpansion()) {
            vsc.getExpansion().getParameter().addAll(vs.getExpansion().getParameter());
            vsc.getExpansion().getContains().addAll(vs.getExpansion().getContains());
        }
        return vsc;
    }

    public CacheToken generateExpandToken(ValueSet vs, boolean heirarchical) {
        CacheToken ct = new CacheToken();
        ValueSet vsc = this.getVSEssense(vs);
        for (ValueSet.ConceptSetComponent conceptSetComponent : vs.getCompose().getInclude()) {
            if (!conceptSetComponent.hasSystem()) continue;
            ct.setName(conceptSetComponent.getSystem());
        }
        for (ValueSet.ConceptSetComponent conceptSetComponent : vs.getCompose().getExclude()) {
            if (!conceptSetComponent.hasSystem()) continue;
            ct.setName(conceptSetComponent.getSystem());
        }
        for (ValueSet.ValueSetExpansionContainsComponent valueSetExpansionContainsComponent : vs.getExpansion().getContains()) {
            if (!valueSetExpansionContainsComponent.hasSystem()) continue;
            ct.setName(valueSetExpansionContainsComponent.getSystem());
        }
        JsonParser json = new JsonParser();
        json.setOutputStyle(IParser.OutputStyle.PRETTY);
        try {
            ct.request = "{\"hierarchical\" : " + (heirarchical ? "true" : "false") + ", \"valueSet\" :" + json.composeString(vsc) + "}\r\n";
        }
        catch (IOException iOException) {
            throw new Error(iOException);
        }
        ct.key = String.valueOf(this.hashNWS(ct.request));
        return ct;
    }

    public NamedCache getNamedCache(CacheToken cacheToken) {
        NamedCache nc = this.caches.get(cacheToken.name);
        if (nc == null) {
            nc = new NamedCache();
            nc.name = cacheToken.name;
            this.caches.put(nc.name, nc);
        }
        return nc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValueSetExpander.ValueSetExpansionOutcome getExpansion(CacheToken cacheToken) {
        Object object = this.lock;
        synchronized (object) {
            NamedCache nc = this.getNamedCache(cacheToken);
            CacheEntry e = nc.map.get(cacheToken.key);
            if (e == null) {
                return null;
            }
            return e.e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheExpansion(CacheToken cacheToken, ValueSetExpander.ValueSetExpansionOutcome res, boolean persistent) {
        Object object = this.lock;
        synchronized (object) {
            NamedCache nc = this.getNamedCache(cacheToken);
            CacheEntry e = new CacheEntry();
            e.request = cacheToken.request;
            e.persistent = persistent;
            e.e = res;
            this.store(cacheToken, persistent, nc, e);
        }
    }

    public void store(CacheToken cacheToken, boolean persistent, NamedCache nc, CacheEntry e) {
        boolean n = nc.map.containsKey(cacheToken.key);
        nc.map.put(cacheToken.key, e);
        if (persistent) {
            if (n) {
                for (int i = nc.list.size() - 1; i >= 0; --i) {
                    if (!nc.list.get((int)i).request.equals(e.request)) continue;
                    nc.list.remove(i);
                }
            }
            nc.list.add(e);
            this.save(nc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IWorkerContext.ValidationResult getValidation(CacheToken cacheToken) {
        Object object = this.lock;
        synchronized (object) {
            NamedCache nc = this.getNamedCache(cacheToken);
            CacheEntry e = nc.map.get(cacheToken.key);
            if (e == null) {
                return null;
            }
            return e.v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheValidation(CacheToken cacheToken, IWorkerContext.ValidationResult res, boolean persistent) {
        Object object = this.lock;
        synchronized (object) {
            NamedCache nc = this.getNamedCache(cacheToken);
            CacheEntry e = new CacheEntry();
            e.request = cacheToken.request;
            e.persistent = persistent;
            e.v = res;
            this.store(cacheToken, persistent, nc, e);
        }
    }

    public void save() {
    }

    private void save(NamedCache nc) {
        if (this.folder == null) {
            return;
        }
        try {
            OutputStreamWriter sw = new OutputStreamWriter((OutputStream)ManagedFileAccess.outStream((String)Utilities.path((String[])new String[]{this.folder, nc.name + ".cache"})), "UTF-8");
            sw.write("-------------------------------------------------------------------------------------\r\n");
            JsonParser json = new JsonParser();
            json.setOutputStyle(IParser.OutputStyle.PRETTY);
            for (CacheEntry ce : nc.list) {
                sw.write(ce.request.trim());
                sw.write("####\r\n");
                if (ce.e != null) {
                    sw.write("e: {\r\n");
                    if (ce.e.getValueset() != null) {
                        sw.write("  \"valueSet\" : " + json.composeString(ce.e.getValueset()).trim() + ",\r\n");
                    }
                    sw.write("  \"error\" : \"" + Utilities.escapeJson((String)ce.e.getError()).trim() + "\"\r\n}\r\n");
                } else {
                    sw.write("v: {\r\n");
                    sw.write("  \"display\" : \"" + Utilities.escapeJson((String)ce.v.getDisplay()).trim() + "\",\r\n");
                    sw.write("  \"severity\" : " + (String)(ce.v.getSeverity() == null ? "null" : "\"" + ce.v.getSeverity().toCode().trim() + "\"") + ",\r\n");
                    sw.write("  \"error\" : \"" + Utilities.escapeJson((String)ce.v.getMessage()).trim() + "\"\r\n}\r\n");
                }
                sw.write("-------------------------------------------------------------------------------------\r\n");
            }
            sw.close();
        }
        catch (Exception e) {
            System.out.println("error saving " + nc.name + ": " + e.getMessage());
        }
    }

    private void load() throws FHIRException, IOException {
        for (String fn : ManagedFileAccess.file((String)this.folder).list()) {
            if (!fn.endsWith(".cache") || fn.equals("validation.cache")) continue;
            try {
                String title = fn.substring(0, fn.lastIndexOf("."));
                NamedCache nc = new NamedCache();
                nc.name = title;
                this.caches.put(title, nc);
                System.out.print(" - load " + title + ".cache");
                String src = TextFile.fileToString((String)Utilities.path((String[])new String[]{this.folder, fn}));
                if (src.startsWith("?")) {
                    src = src.substring(1);
                }
                int i = src.indexOf(ENTRY_MARKER);
                while (i > -1) {
                    String s = src.substring(0, i);
                    System.out.print(".");
                    src = src.substring(i + ENTRY_MARKER.length() + 1);
                    i = src.indexOf(ENTRY_MARKER);
                    if (Utilities.noString((String)s)) continue;
                    int j = s.indexOf(BREAK);
                    String q = s.substring(0, j);
                    String p = s.substring(j + BREAK.length() + 1).trim();
                    CacheEntry ce = new CacheEntry();
                    ce.persistent = true;
                    ce.request = q;
                    boolean e = p.charAt(0) == 'e';
                    p = p.substring(3);
                    JsonObject o = (JsonObject)new com.google.gson.JsonParser().parse(p);
                    String error = this.loadJS(o.get("error"));
                    if (e) {
                        ce.e = o.has("valueSet") ? new ValueSetExpander.ValueSetExpansionOutcome((ValueSet)new JsonParser().parse(o.getAsJsonObject("valueSet")), error, ValueSetExpander.TerminologyServiceErrorClass.UNKNOWN) : new ValueSetExpander.ValueSetExpansionOutcome(error, ValueSetExpander.TerminologyServiceErrorClass.UNKNOWN);
                    } else {
                        ValidationMessage.IssueSeverity severity = o.get("severity") instanceof JsonNull ? null : ValidationMessage.IssueSeverity.fromCode((String)o.get("severity").getAsString());
                        String display = this.loadJS(o.get("display"));
                        ce.v = new IWorkerContext.ValidationResult(severity, error, new CodeSystem.ConceptDefinitionComponent().setDisplay(display));
                    }
                    nc.map.put(String.valueOf(this.hashNWS(ce.request)), ce);
                    nc.list.add(ce);
                }
                System.out.println("done");
            }
            catch (Exception e) {
                throw new FHIRException("Error loading " + fn + ": " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private String loadJS(JsonElement e) {
        if (e == null) {
            return null;
        }
        if (!(e instanceof JsonPrimitive)) {
            return null;
        }
        String s = e.getAsString();
        if ("".equals(s)) {
            return null;
        }
        return s;
    }

    private String hashNWS(String s) {
        s = StringUtils.remove((String)s, (char)' ');
        s = StringUtils.remove((String)s, (char)'\n');
        s = StringUtils.remove((String)s, (char)'\r');
        return String.valueOf(s.hashCode());
    }

    public TerminologyCache copy() {
        return null;
    }

    public String summary(ValueSet vs) {
        if (vs == null) {
            return "null";
        }
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        for (ValueSet.ConceptSetComponent cc : vs.getCompose().getInclude()) {
            b.append("Include " + this.getIncSummary(cc));
        }
        for (ValueSet.ConceptSetComponent cc : vs.getCompose().getExclude()) {
            b.append("Exclude " + this.getIncSummary(cc));
        }
        return b.toString();
    }

    private String getIncSummary(ValueSet.ConceptSetComponent cc) {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        for (UriType uriType : cc.getValueSet()) {
            b.append(uriType.asStringValue());
        }
        String vsd = b.length() > 0 ? " where the codes are in the value sets (" + b.toString() + ")" : "";
        String string = cc.getSystem();
        if (cc.hasConcept()) {
            return Integer.toString(cc.getConcept().size()) + " codes from " + string + vsd;
        }
        if (cc.hasFilter()) {
            Object s = "";
            for (ValueSet.ConceptSetFilterComponent f : cc.getFilter()) {
                if (!Utilities.noString((String)s)) {
                    s = (String)s + " & ";
                }
                s = (String)s + f.getProperty() + " " + f.getOp().toCode() + " " + f.getValue();
            }
            return "from " + string + " where " + (String)s + vsd;
        }
        return "All codes from " + string + vsd;
    }

    public String summary(Coding code) {
        return code.getSystem() + "#" + code.getCode() + ": \"" + code.getDisplay() + "\"";
    }

    public String summary(CodeableConcept code) {
        StringBuilder b = new StringBuilder();
        b.append("{");
        boolean first = true;
        for (Coding c : code.getCoding()) {
            if (first) {
                first = false;
            } else {
                b.append(",");
            }
            b.append(this.summary(c));
        }
        b.append("}: \"");
        b.append(code.getText());
        b.append("\"");
        return b.toString();
    }

    private class NamedCache {
        private String name;
        private List<CacheEntry> list = new ArrayList<CacheEntry>();
        private Map<String, CacheEntry> map = new HashMap<String, CacheEntry>();

        private NamedCache() {
        }
    }

    private class CacheEntry {
        private String request;
        private boolean persistent;
        private IWorkerContext.ValidationResult v;
        private ValueSetExpander.ValueSetExpansionOutcome e;

        private CacheEntry() {
        }
    }

    public class CacheToken {
        private String name;
        private String key;
        private String request;

        public void setName(String n) {
            String systemName = TerminologyCache.this.getSystemNameKeyGenerator().getNameForSystem(n);
            if (this.name == null) {
                this.name = systemName;
            } else if (!systemName.equals(this.name)) {
                this.name = TerminologyCache.NAME_FOR_NO_SYSTEM;
            }
        }

        public String getName() {
            return this.name;
        }
    }

    public class SystemNameKeyGenerator {
        public static final String SNOMED_SCT_CODESYSTEM_URL = "http://snomed.info/sct";
        public static final String RXNORM_CODESYSTEM_URL = "http://www.nlm.nih.gov/research/umls/rxnorm";
        public static final String LOINC_CODESYSTEM_URL = "http://loinc.org";
        public static final String UCUM_CODESYSTEM_URL = "http://unitsofmeasure.org";
        public static final String HL7_TERMINOLOGY_CODESYSTEM_BASE_URL = "http://terminology.hl7.org/CodeSystem/";
        public static final String HL7_SID_CODESYSTEM_BASE_URL = "http://hl7.org/fhir/sid/";
        public static final String HL7_FHIR_CODESYSTEM_BASE_URL = "http://hl7.org/fhir/";
        public static final String ISO_CODESYSTEM_URN = "urn:iso:std:iso:";
        public static final String LANG_CODESYSTEM_URN = "urn:ietf:bcp:47";
        public static final String MIMETYPES_CODESYSTEM_URN = "urn:ietf:bcp:13";
        public static final String _11073_CODESYSTEM_URN = "urn:iso:std:iso:11073:10101";
        public static final String DICOM_CODESYSTEM_URL = "http://dicom.nema.org/resources/ontology/DCM";

        public String getNameForSystem(String system) {
            String systemVersion;
            int lastPipe = system.lastIndexOf(124);
            String systemBaseName = lastPipe == -1 ? system : system.substring(0, lastPipe);
            String string = systemVersion = lastPipe == -1 ? null : system.substring(lastPipe + 1);
            if (systemBaseName.equals(SNOMED_SCT_CODESYSTEM_URL)) {
                return this.getVersionedSystem("snomed", systemVersion);
            }
            if (systemBaseName.equals(RXNORM_CODESYSTEM_URL)) {
                return this.getVersionedSystem("rxnorm", systemVersion);
            }
            if (systemBaseName.equals(LOINC_CODESYSTEM_URL)) {
                return this.getVersionedSystem("loinc", systemVersion);
            }
            if (systemBaseName.equals(UCUM_CODESYSTEM_URL)) {
                return this.getVersionedSystem("ucum", systemVersion);
            }
            if (systemBaseName.startsWith(HL7_SID_CODESYSTEM_BASE_URL)) {
                return this.getVersionedSystem(this.normalizeBaseURL(HL7_SID_CODESYSTEM_BASE_URL, systemBaseName), systemVersion);
            }
            if (systemBaseName.equals(_11073_CODESYSTEM_URN)) {
                return this.getVersionedSystem("11073", systemVersion);
            }
            if (systemBaseName.startsWith(ISO_CODESYSTEM_URN)) {
                return this.getVersionedSystem("iso" + systemBaseName.substring(ISO_CODESYSTEM_URN.length()).replace(":", ""), systemVersion);
            }
            if (systemBaseName.startsWith(HL7_TERMINOLOGY_CODESYSTEM_BASE_URL)) {
                return this.getVersionedSystem(this.normalizeBaseURL(HL7_TERMINOLOGY_CODESYSTEM_BASE_URL, systemBaseName), systemVersion);
            }
            if (systemBaseName.startsWith(HL7_FHIR_CODESYSTEM_BASE_URL)) {
                return this.getVersionedSystem(this.normalizeBaseURL(HL7_FHIR_CODESYSTEM_BASE_URL, systemBaseName), systemVersion);
            }
            if (systemBaseName.equals(LANG_CODESYSTEM_URN)) {
                return this.getVersionedSystem("lang", systemVersion);
            }
            if (systemBaseName.equals(MIMETYPES_CODESYSTEM_URN)) {
                return this.getVersionedSystem("mimetypes", systemVersion);
            }
            if (systemBaseName.equals(DICOM_CODESYSTEM_URL)) {
                return this.getVersionedSystem("dicom", systemVersion);
            }
            return this.getVersionedSystem(systemBaseName.replace("/", "_").replace(":", "_").replace("?", "X").replace("#", "X"), systemVersion);
        }

        public String normalizeBaseURL(String baseUrl, String fullUrl) {
            return fullUrl.substring(baseUrl.length()).replace("/", "");
        }

        public String getVersionedSystem(String baseSystem, String version) {
            if (version != null) {
                return baseSystem + "_" + version;
            }
            return baseSystem;
        }
    }
}

