/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.formats;

import org.hl7.fhir.r4.formats.RdfParserBase;
import org.hl7.fhir.r4.model.Account;
import org.hl7.fhir.r4.model.ActivityDefinition;
import org.hl7.fhir.r4.model.Address;
import org.hl7.fhir.r4.model.AdverseEvent;
import org.hl7.fhir.r4.model.Age;
import org.hl7.fhir.r4.model.AllergyIntolerance;
import org.hl7.fhir.r4.model.Annotation;
import org.hl7.fhir.r4.model.Appointment;
import org.hl7.fhir.r4.model.AppointmentResponse;
import org.hl7.fhir.r4.model.Attachment;
import org.hl7.fhir.r4.model.AuditEvent;
import org.hl7.fhir.r4.model.BackboneElement;
import org.hl7.fhir.r4.model.Base64BinaryType;
import org.hl7.fhir.r4.model.Basic;
import org.hl7.fhir.r4.model.Binary;
import org.hl7.fhir.r4.model.BiologicallyDerivedProduct;
import org.hl7.fhir.r4.model.BodyStructure;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.CapabilityStatement;
import org.hl7.fhir.r4.model.CarePlan;
import org.hl7.fhir.r4.model.CareTeam;
import org.hl7.fhir.r4.model.CatalogEntry;
import org.hl7.fhir.r4.model.ChargeItem;
import org.hl7.fhir.r4.model.ChargeItemDefinition;
import org.hl7.fhir.r4.model.Claim;
import org.hl7.fhir.r4.model.ClaimResponse;
import org.hl7.fhir.r4.model.ClinicalImpression;
import org.hl7.fhir.r4.model.CodeSystem;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Communication;
import org.hl7.fhir.r4.model.CommunicationRequest;
import org.hl7.fhir.r4.model.CompartmentDefinition;
import org.hl7.fhir.r4.model.Composition;
import org.hl7.fhir.r4.model.ConceptMap;
import org.hl7.fhir.r4.model.Condition;
import org.hl7.fhir.r4.model.Consent;
import org.hl7.fhir.r4.model.ContactDetail;
import org.hl7.fhir.r4.model.ContactPoint;
import org.hl7.fhir.r4.model.Contract;
import org.hl7.fhir.r4.model.Contributor;
import org.hl7.fhir.r4.model.Count;
import org.hl7.fhir.r4.model.Coverage;
import org.hl7.fhir.r4.model.CoverageEligibilityRequest;
import org.hl7.fhir.r4.model.CoverageEligibilityResponse;
import org.hl7.fhir.r4.model.DataRequirement;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.DateType;
import org.hl7.fhir.r4.model.DecimalType;
import org.hl7.fhir.r4.model.DetectedIssue;
import org.hl7.fhir.r4.model.Device;
import org.hl7.fhir.r4.model.DeviceDefinition;
import org.hl7.fhir.r4.model.DeviceMetric;
import org.hl7.fhir.r4.model.DeviceRequest;
import org.hl7.fhir.r4.model.DeviceUseStatement;
import org.hl7.fhir.r4.model.DiagnosticReport;
import org.hl7.fhir.r4.model.Distance;
import org.hl7.fhir.r4.model.DocumentManifest;
import org.hl7.fhir.r4.model.DocumentReference;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.Dosage;
import org.hl7.fhir.r4.model.Duration;
import org.hl7.fhir.r4.model.EffectEvidenceSynthesis;
import org.hl7.fhir.r4.model.Element;
import org.hl7.fhir.r4.model.ElementDefinition;
import org.hl7.fhir.r4.model.Encounter;
import org.hl7.fhir.r4.model.Endpoint;
import org.hl7.fhir.r4.model.EnrollmentRequest;
import org.hl7.fhir.r4.model.EnrollmentResponse;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.EpisodeOfCare;
import org.hl7.fhir.r4.model.EventDefinition;
import org.hl7.fhir.r4.model.Evidence;
import org.hl7.fhir.r4.model.EvidenceVariable;
import org.hl7.fhir.r4.model.ExampleScenario;
import org.hl7.fhir.r4.model.ExplanationOfBenefit;
import org.hl7.fhir.r4.model.Expression;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.FamilyMemberHistory;
import org.hl7.fhir.r4.model.Flag;
import org.hl7.fhir.r4.model.Goal;
import org.hl7.fhir.r4.model.GraphDefinition;
import org.hl7.fhir.r4.model.Group;
import org.hl7.fhir.r4.model.GuidanceResponse;
import org.hl7.fhir.r4.model.HealthcareService;
import org.hl7.fhir.r4.model.HumanName;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.ImagingStudy;
import org.hl7.fhir.r4.model.Immunization;
import org.hl7.fhir.r4.model.ImmunizationEvaluation;
import org.hl7.fhir.r4.model.ImmunizationRecommendation;
import org.hl7.fhir.r4.model.ImplementationGuide;
import org.hl7.fhir.r4.model.InstantType;
import org.hl7.fhir.r4.model.InsurancePlan;
import org.hl7.fhir.r4.model.IntegerType;
import org.hl7.fhir.r4.model.Invoice;
import org.hl7.fhir.r4.model.Library;
import org.hl7.fhir.r4.model.Linkage;
import org.hl7.fhir.r4.model.ListResource;
import org.hl7.fhir.r4.model.Location;
import org.hl7.fhir.r4.model.MarkdownType;
import org.hl7.fhir.r4.model.MarketingStatus;
import org.hl7.fhir.r4.model.Measure;
import org.hl7.fhir.r4.model.MeasureReport;
import org.hl7.fhir.r4.model.Media;
import org.hl7.fhir.r4.model.Medication;
import org.hl7.fhir.r4.model.MedicationAdministration;
import org.hl7.fhir.r4.model.MedicationDispense;
import org.hl7.fhir.r4.model.MedicationKnowledge;
import org.hl7.fhir.r4.model.MedicationRequest;
import org.hl7.fhir.r4.model.MedicationStatement;
import org.hl7.fhir.r4.model.MedicinalProduct;
import org.hl7.fhir.r4.model.MedicinalProductAuthorization;
import org.hl7.fhir.r4.model.MedicinalProductContraindication;
import org.hl7.fhir.r4.model.MedicinalProductIndication;
import org.hl7.fhir.r4.model.MedicinalProductIngredient;
import org.hl7.fhir.r4.model.MedicinalProductInteraction;
import org.hl7.fhir.r4.model.MedicinalProductManufactured;
import org.hl7.fhir.r4.model.MedicinalProductPackaged;
import org.hl7.fhir.r4.model.MedicinalProductPharmaceutical;
import org.hl7.fhir.r4.model.MedicinalProductUndesirableEffect;
import org.hl7.fhir.r4.model.MessageDefinition;
import org.hl7.fhir.r4.model.MessageHeader;
import org.hl7.fhir.r4.model.Meta;
import org.hl7.fhir.r4.model.MolecularSequence;
import org.hl7.fhir.r4.model.Money;
import org.hl7.fhir.r4.model.NamingSystem;
import org.hl7.fhir.r4.model.Narrative;
import org.hl7.fhir.r4.model.NutritionOrder;
import org.hl7.fhir.r4.model.Observation;
import org.hl7.fhir.r4.model.ObservationDefinition;
import org.hl7.fhir.r4.model.OidType;
import org.hl7.fhir.r4.model.OperationDefinition;
import org.hl7.fhir.r4.model.OperationOutcome;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.OrganizationAffiliation;
import org.hl7.fhir.r4.model.ParameterDefinition;
import org.hl7.fhir.r4.model.Parameters;
import org.hl7.fhir.r4.model.Patient;
import org.hl7.fhir.r4.model.PaymentNotice;
import org.hl7.fhir.r4.model.PaymentReconciliation;
import org.hl7.fhir.r4.model.Period;
import org.hl7.fhir.r4.model.Person;
import org.hl7.fhir.r4.model.PlanDefinition;
import org.hl7.fhir.r4.model.Population;
import org.hl7.fhir.r4.model.PositiveIntType;
import org.hl7.fhir.r4.model.Practitioner;
import org.hl7.fhir.r4.model.PractitionerRole;
import org.hl7.fhir.r4.model.Procedure;
import org.hl7.fhir.r4.model.ProdCharacteristic;
import org.hl7.fhir.r4.model.ProductShelfLife;
import org.hl7.fhir.r4.model.Provenance;
import org.hl7.fhir.r4.model.Quantity;
import org.hl7.fhir.r4.model.Questionnaire;
import org.hl7.fhir.r4.model.QuestionnaireResponse;
import org.hl7.fhir.r4.model.Range;
import org.hl7.fhir.r4.model.Ratio;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.RelatedArtifact;
import org.hl7.fhir.r4.model.RelatedPerson;
import org.hl7.fhir.r4.model.RequestGroup;
import org.hl7.fhir.r4.model.ResearchDefinition;
import org.hl7.fhir.r4.model.ResearchElementDefinition;
import org.hl7.fhir.r4.model.ResearchStudy;
import org.hl7.fhir.r4.model.ResearchSubject;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.RiskAssessment;
import org.hl7.fhir.r4.model.RiskEvidenceSynthesis;
import org.hl7.fhir.r4.model.SampledData;
import org.hl7.fhir.r4.model.Schedule;
import org.hl7.fhir.r4.model.SearchParameter;
import org.hl7.fhir.r4.model.ServiceRequest;
import org.hl7.fhir.r4.model.Signature;
import org.hl7.fhir.r4.model.Slot;
import org.hl7.fhir.r4.model.Specimen;
import org.hl7.fhir.r4.model.SpecimenDefinition;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.StructureDefinition;
import org.hl7.fhir.r4.model.StructureMap;
import org.hl7.fhir.r4.model.Subscription;
import org.hl7.fhir.r4.model.Substance;
import org.hl7.fhir.r4.model.SubstanceAmount;
import org.hl7.fhir.r4.model.SubstanceNucleicAcid;
import org.hl7.fhir.r4.model.SubstancePolymer;
import org.hl7.fhir.r4.model.SubstanceProtein;
import org.hl7.fhir.r4.model.SubstanceReferenceInformation;
import org.hl7.fhir.r4.model.SubstanceSourceMaterial;
import org.hl7.fhir.r4.model.SubstanceSpecification;
import org.hl7.fhir.r4.model.SupplyDelivery;
import org.hl7.fhir.r4.model.SupplyRequest;
import org.hl7.fhir.r4.model.Task;
import org.hl7.fhir.r4.model.TerminologyCapabilities;
import org.hl7.fhir.r4.model.TestReport;
import org.hl7.fhir.r4.model.TestScript;
import org.hl7.fhir.r4.model.TimeType;
import org.hl7.fhir.r4.model.Timing;
import org.hl7.fhir.r4.model.TriggerDefinition;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.r4.model.UnsignedIntType;
import org.hl7.fhir.r4.model.UriType;
import org.hl7.fhir.r4.model.UrlType;
import org.hl7.fhir.r4.model.UsageContext;
import org.hl7.fhir.r4.model.UuidType;
import org.hl7.fhir.r4.model.ValueSet;
import org.hl7.fhir.r4.model.VerificationResult;
import org.hl7.fhir.r4.model.VisionPrescription;
import org.hl7.fhir.r4.utils.formats.Turtle;
import org.hl7.fhir.utilities.Utilities;

public class RdfParser
extends RdfParserBase {
    public RdfParser() {
    }

    public RdfParser(boolean allowUnknownContent) {
        this.setAllowUnknownContent(allowUnknownContent);
    }

    protected void composeElement(Turtle.Complex t, String parentType, String name, Element element, int index) {
        if (element == null) {
            return;
        }
        if (index > -1) {
            t.predicate("fhir:index", Integer.toString(index));
        }
        if (element.hasIdElement()) {
            this.composeString(t, "Element", "id", element.getIdElement(), -1);
        }
        for (int i = 0; i < element.getExtension().size(); ++i) {
            this.composeExtension(t, "Element", "extension", element.getExtension().get(i), i);
        }
    }

    protected void composeBackboneElement(Turtle.Complex t, String tType, String name, BackboneElement element, int index) {
        this.composeElement(t, tType, name, element, index);
        for (int i = 0; i < element.getModifierExtension().size(); ++i) {
            this.composeExtension(t, "Element", "modifierExtension", element.getModifierExtension().get(i), i);
        }
    }

    private void composeEnum(Turtle.Complex parent, String parentType, String name, Enumeration<? extends Enum> value, int index) {
        if (value == null) {
            return;
        }
        Turtle.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
        this.decorateCode(t, value);
    }

    protected void composeDate(Turtle.Complex parent, String parentType, String name, DateType value, int index) {
        if (value == null) {
            return;
        }
        Turtle.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
    }

    protected void composeDateTime(Turtle.Complex parent, String parentType, String name, DateTimeType value, int index) {
        if (value == null) {
            return;
        }
        Turtle.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
    }

    protected void composeCode(Turtle.Complex parent, String parentType, String name, CodeType value, int index) {
        if (value == null) {
            return;
        }
        Turtle.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
        this.decorateCode(t, value);
    }

    protected void composeString(Turtle.Complex parent, String parentType, String name, StringType value, int index) {
        if (value == null) {
            return;
        }
        Turtle.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
    }

    protected void composeInteger(Turtle.Complex parent, String parentType, String name, IntegerType value, int index) {
        if (value == null) {
            return;
        }
        Turtle.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
    }

    protected void composeOid(Turtle.Complex parent, String parentType, String name, OidType value, int index) {
        if (value == null) {
            return;
        }
        Turtle.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
    }

    protected void composeCanonical(Turtle.Complex parent, String parentType, String name, CanonicalType value, int index) {
        if (value == null) {
            return;
        }
        Turtle.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
    }

    protected void composeUri(Turtle.Complex parent, String parentType, String name, UriType value, int index) {
        if (value == null) {
            return;
        }
        Turtle.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
    }

    protected void composeUuid(Turtle.Complex parent, String parentType, String name, UuidType value, int index) {
        if (value == null) {
            return;
        }
        Turtle.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
    }

    protected void composeUrl(Turtle.Complex parent, String parentType, String name, UrlType value, int index) {
        if (value == null) {
            return;
        }
        Turtle.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
    }

    protected void composeInstant(Turtle.Complex parent, String parentType, String name, InstantType value, int index) {
        if (value == null) {
            return;
        }
        Turtle.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
    }

    protected void composeBoolean(Turtle.Complex parent, String parentType, String name, BooleanType value, int index) {
        if (value == null) {
            return;
        }
        Turtle.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
    }

    protected void composeBase64Binary(Turtle.Complex parent, String parentType, String name, Base64BinaryType value, int index) {
        if (value == null) {
            return;
        }
        Turtle.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
    }

    protected void composeUnsignedInt(Turtle.Complex parent, String parentType, String name, UnsignedIntType value, int index) {
        if (value == null) {
            return;
        }
        Turtle.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
    }

    protected void composeMarkdown(Turtle.Complex parent, String parentType, String name, MarkdownType value, int index) {
        if (value == null) {
            return;
        }
        Turtle.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
    }

    protected void composeTime(Turtle.Complex parent, String parentType, String name, TimeType value, int index) {
        if (value == null) {
            return;
        }
        Turtle.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
    }

    protected void composeId(Turtle.Complex parent, String parentType, String name, IdType value, int index) {
        if (value == null) {
            return;
        }
        Turtle.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
    }

    protected void composePositiveInt(Turtle.Complex parent, String parentType, String name, PositiveIntType value, int index) {
        if (value == null) {
            return;
        }
        Turtle.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
    }

    protected void composeDecimal(Turtle.Complex parent, String parentType, String name, DecimalType value, int index) {
        if (value == null) {
            return;
        }
        Turtle.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
    }

    protected void composeExtension(Turtle.Complex parent, String parentType, String name, Extension element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "Extension", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "Extension", "url", element.getUrlElement(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "Extension", "value", element.getValue(), -1);
        }
    }

    protected void composeNarrative(Turtle.Complex parent, String parentType, String name, Narrative element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "Narrative", name, element, index);
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Narrative", "status", element.getStatusElement(), -1);
        }
        if (element.hasDiv()) {
            this.composeXhtml(t, "Narrative", "div", element.getDiv(), -1);
        }
    }

    protected void composeMeta(Turtle.Complex parent, String parentType, String name, Meta element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "Meta", name, element, index);
        if (element.hasVersionIdElement()) {
            this.composeId(t, "Meta", "versionId", element.getVersionIdElement(), -1);
        }
        if (element.hasLastUpdatedElement()) {
            this.composeInstant(t, "Meta", "lastUpdated", element.getLastUpdatedElement(), -1);
        }
        if (element.hasSourceElement()) {
            this.composeUri(t, "Meta", "source", element.getSourceElement(), -1);
        }
        for (i = 0; i < element.getProfile().size(); ++i) {
            this.composeCanonical(t, "Meta", "profile", element.getProfile().get(i), i);
        }
        for (i = 0; i < element.getSecurity().size(); ++i) {
            this.composeCoding(t, "Meta", "security", element.getSecurity().get(i), i);
        }
        for (i = 0; i < element.getTag().size(); ++i) {
            this.composeCoding(t, "Meta", "tag", element.getTag().get(i), i);
        }
    }

    protected void composeAddress(Turtle.Complex parent, String parentType, String name, Address element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "Address", name, element, index);
        if (element.hasUseElement()) {
            this.composeEnum(t, "Address", "use", element.getUseElement(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeEnum(t, "Address", "type", element.getTypeElement(), -1);
        }
        if (element.hasTextElement()) {
            this.composeString(t, "Address", "text", element.getTextElement(), -1);
        }
        for (int i = 0; i < element.getLine().size(); ++i) {
            this.composeString(t, "Address", "line", element.getLine().get(i), i);
        }
        if (element.hasCityElement()) {
            this.composeString(t, "Address", "city", element.getCityElement(), -1);
        }
        if (element.hasDistrictElement()) {
            this.composeString(t, "Address", "district", element.getDistrictElement(), -1);
        }
        if (element.hasStateElement()) {
            this.composeString(t, "Address", "state", element.getStateElement(), -1);
        }
        if (element.hasPostalCodeElement()) {
            this.composeString(t, "Address", "postalCode", element.getPostalCodeElement(), -1);
        }
        if (element.hasCountryElement()) {
            this.composeString(t, "Address", "country", element.getCountryElement(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "Address", "period", element.getPeriod(), -1);
        }
    }

    protected void composeContributor(Turtle.Complex parent, String parentType, String name, Contributor element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "Contributor", name, element, index);
        if (element.hasTypeElement()) {
            this.composeEnum(t, "Contributor", "type", element.getTypeElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "Contributor", "name", element.getNameElement(), -1);
        }
        for (int i = 0; i < element.getContact().size(); ++i) {
            this.composeContactDetail(t, "Contributor", "contact", element.getContact().get(i), i);
        }
    }

    protected void composeAttachment(Turtle.Complex parent, String parentType, String name, Attachment element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "Attachment", name, element, index);
        if (element.hasContentTypeElement()) {
            this.composeCode(t, "Attachment", "contentType", element.getContentTypeElement(), -1);
        }
        if (element.hasLanguageElement()) {
            this.composeCode(t, "Attachment", "language", element.getLanguageElement(), -1);
        }
        if (element.hasDataElement()) {
            this.composeBase64Binary(t, "Attachment", "data", element.getDataElement(), -1);
        }
        if (element.hasUrlElement()) {
            this.composeUrl(t, "Attachment", "url", element.getUrlElement(), -1);
        }
        if (element.hasSizeElement()) {
            this.composeUnsignedInt(t, "Attachment", "size", element.getSizeElement(), -1);
        }
        if (element.hasHashElement()) {
            this.composeBase64Binary(t, "Attachment", "hash", element.getHashElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "Attachment", "title", element.getTitleElement(), -1);
        }
        if (element.hasCreationElement()) {
            this.composeDateTime(t, "Attachment", "creation", element.getCreationElement(), -1);
        }
    }

    protected void composeCount(Turtle.Complex parent, String parentType, String name, Count element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "Count", name, element, index);
    }

    protected void composeDataRequirement(Turtle.Complex parent, String parentType, String name, DataRequirement element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "DataRequirement", name, element, index);
        if (element.hasTypeElement()) {
            this.composeCode(t, "DataRequirement", "type", element.getTypeElement(), -1);
        }
        for (i = 0; i < element.getProfile().size(); ++i) {
            this.composeCanonical(t, "DataRequirement", "profile", element.getProfile().get(i), i);
        }
        if (element.hasSubject()) {
            this.composeType(t, "DataRequirement", "subject", element.getSubject(), -1);
        }
        for (i = 0; i < element.getMustSupport().size(); ++i) {
            this.composeString(t, "DataRequirement", "mustSupport", element.getMustSupport().get(i), i);
        }
        for (i = 0; i < element.getCodeFilter().size(); ++i) {
            this.composeDataRequirementDataRequirementCodeFilterComponent(t, "DataRequirement", "codeFilter", element.getCodeFilter().get(i), i);
        }
        for (i = 0; i < element.getDateFilter().size(); ++i) {
            this.composeDataRequirementDataRequirementDateFilterComponent(t, "DataRequirement", "dateFilter", element.getDateFilter().get(i), i);
        }
        if (element.hasLimitElement()) {
            this.composePositiveInt(t, "DataRequirement", "limit", element.getLimitElement(), -1);
        }
        for (i = 0; i < element.getSort().size(); ++i) {
            this.composeDataRequirementDataRequirementSortComponent(t, "DataRequirement", "sort", element.getSort().get(i), i);
        }
    }

    protected void composeDataRequirementDataRequirementCodeFilterComponent(Turtle.Complex parent, String parentType, String name, DataRequirement.DataRequirementCodeFilterComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "codeFilter", name, element, index);
        if (element.hasPathElement()) {
            this.composeString(t, "DataRequirement", "path", element.getPathElement(), -1);
        }
        if (element.hasSearchParamElement()) {
            this.composeString(t, "DataRequirement", "searchParam", element.getSearchParamElement(), -1);
        }
        if (element.hasValueSetElement()) {
            this.composeCanonical(t, "DataRequirement", "valueSet", element.getValueSetElement(), -1);
        }
        for (int i = 0; i < element.getCode().size(); ++i) {
            this.composeCoding(t, "DataRequirement", "code", element.getCode().get(i), i);
        }
    }

    protected void composeDataRequirementDataRequirementDateFilterComponent(Turtle.Complex parent, String parentType, String name, DataRequirement.DataRequirementDateFilterComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "dateFilter", name, element, index);
        if (element.hasPathElement()) {
            this.composeString(t, "DataRequirement", "path", element.getPathElement(), -1);
        }
        if (element.hasSearchParamElement()) {
            this.composeString(t, "DataRequirement", "searchParam", element.getSearchParamElement(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "DataRequirement", "value", element.getValue(), -1);
        }
    }

    protected void composeDataRequirementDataRequirementSortComponent(Turtle.Complex parent, String parentType, String name, DataRequirement.DataRequirementSortComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "sort", name, element, index);
        if (element.hasPathElement()) {
            this.composeString(t, "DataRequirement", "path", element.getPathElement(), -1);
        }
        if (element.hasDirectionElement()) {
            this.composeEnum(t, "DataRequirement", "direction", element.getDirectionElement(), -1);
        }
    }

    protected void composeDosage(Turtle.Complex parent, String parentType, String name, Dosage element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "Dosage", name, element, index);
        if (element.hasSequenceElement()) {
            this.composeInteger(t, "Dosage", "sequence", element.getSequenceElement(), -1);
        }
        if (element.hasTextElement()) {
            this.composeString(t, "Dosage", "text", element.getTextElement(), -1);
        }
        for (i = 0; i < element.getAdditionalInstruction().size(); ++i) {
            this.composeCodeableConcept(t, "Dosage", "additionalInstruction", element.getAdditionalInstruction().get(i), i);
        }
        if (element.hasPatientInstructionElement()) {
            this.composeString(t, "Dosage", "patientInstruction", element.getPatientInstructionElement(), -1);
        }
        if (element.hasTiming()) {
            this.composeTiming(t, "Dosage", "timing", element.getTiming(), -1);
        }
        if (element.hasAsNeeded()) {
            this.composeType(t, "Dosage", "asNeeded", element.getAsNeeded(), -1);
        }
        if (element.hasSite()) {
            this.composeCodeableConcept(t, "Dosage", "site", element.getSite(), -1);
        }
        if (element.hasRoute()) {
            this.composeCodeableConcept(t, "Dosage", "route", element.getRoute(), -1);
        }
        if (element.hasMethod()) {
            this.composeCodeableConcept(t, "Dosage", "method", element.getMethod(), -1);
        }
        for (i = 0; i < element.getDoseAndRate().size(); ++i) {
            this.composeDosageDosageDoseAndRateComponent(t, "Dosage", "doseAndRate", element.getDoseAndRate().get(i), i);
        }
        if (element.hasMaxDosePerPeriod()) {
            this.composeRatio(t, "Dosage", "maxDosePerPeriod", element.getMaxDosePerPeriod(), -1);
        }
        if (element.hasMaxDosePerAdministration()) {
            this.composeQuantity(t, "Dosage", "maxDosePerAdministration", element.getMaxDosePerAdministration(), -1);
        }
        if (element.hasMaxDosePerLifetime()) {
            this.composeQuantity(t, "Dosage", "maxDosePerLifetime", element.getMaxDosePerLifetime(), -1);
        }
    }

    protected void composeDosageDosageDoseAndRateComponent(Turtle.Complex parent, String parentType, String name, Dosage.DosageDoseAndRateComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "doseAndRate", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "Dosage", "type", element.getType(), -1);
        }
        if (element.hasDose()) {
            this.composeType(t, "Dosage", "dose", element.getDose(), -1);
        }
        if (element.hasRate()) {
            this.composeType(t, "Dosage", "rate", element.getRate(), -1);
        }
    }

    protected void composeMoney(Turtle.Complex parent, String parentType, String name, Money element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "Money", name, element, index);
        if (element.hasValueElement()) {
            this.composeDecimal(t, "Money", "value", element.getValueElement(), -1);
        }
        if (element.hasCurrencyElement()) {
            this.composeCode(t, "Money", "currency", element.getCurrencyElement(), -1);
        }
    }

    protected void composeHumanName(Turtle.Complex parent, String parentType, String name, HumanName element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "HumanName", name, element, index);
        if (element.hasUseElement()) {
            this.composeEnum(t, "HumanName", "use", element.getUseElement(), -1);
        }
        if (element.hasTextElement()) {
            this.composeString(t, "HumanName", "text", element.getTextElement(), -1);
        }
        if (element.hasFamilyElement()) {
            this.composeString(t, "HumanName", "family", element.getFamilyElement(), -1);
        }
        for (i = 0; i < element.getGiven().size(); ++i) {
            this.composeString(t, "HumanName", "given", element.getGiven().get(i), i);
        }
        for (i = 0; i < element.getPrefix().size(); ++i) {
            this.composeString(t, "HumanName", "prefix", element.getPrefix().get(i), i);
        }
        for (i = 0; i < element.getSuffix().size(); ++i) {
            this.composeString(t, "HumanName", "suffix", element.getSuffix().get(i), i);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "HumanName", "period", element.getPeriod(), -1);
        }
    }

    protected void composeContactPoint(Turtle.Complex parent, String parentType, String name, ContactPoint element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "ContactPoint", name, element, index);
        if (element.hasSystemElement()) {
            this.composeEnum(t, "ContactPoint", "system", element.getSystemElement(), -1);
        }
        if (element.hasValueElement()) {
            this.composeString(t, "ContactPoint", "value", element.getValueElement(), -1);
        }
        if (element.hasUseElement()) {
            this.composeEnum(t, "ContactPoint", "use", element.getUseElement(), -1);
        }
        if (element.hasRankElement()) {
            this.composePositiveInt(t, "ContactPoint", "rank", element.getRankElement(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "ContactPoint", "period", element.getPeriod(), -1);
        }
    }

    protected void composeMarketingStatus(Turtle.Complex parent, String parentType, String name, MarketingStatus element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "MarketingStatus", name, element, index);
        if (element.hasCountry()) {
            this.composeCodeableConcept(t, "MarketingStatus", "country", element.getCountry(), -1);
        }
        if (element.hasJurisdiction()) {
            this.composeCodeableConcept(t, "MarketingStatus", "jurisdiction", element.getJurisdiction(), -1);
        }
        if (element.hasStatus()) {
            this.composeCodeableConcept(t, "MarketingStatus", "status", element.getStatus(), -1);
        }
        if (element.hasDateRange()) {
            this.composePeriod(t, "MarketingStatus", "dateRange", element.getDateRange(), -1);
        }
        if (element.hasRestoreDateElement()) {
            this.composeDateTime(t, "MarketingStatus", "restoreDate", element.getRestoreDateElement(), -1);
        }
    }

    protected void composeIdentifier(Turtle.Complex parent, String parentType, String name, Identifier element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "Identifier", name, element, index);
        if (element.hasUseElement()) {
            this.composeEnum(t, "Identifier", "use", element.getUseElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "Identifier", "type", element.getType(), -1);
        }
        if (element.hasSystemElement()) {
            this.composeUri(t, "Identifier", "system", element.getSystemElement(), -1);
        }
        if (element.hasValueElement()) {
            this.composeString(t, "Identifier", "value", element.getValueElement(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "Identifier", "period", element.getPeriod(), -1);
        }
        if (element.hasAssigner()) {
            this.composeReference(t, "Identifier", "assigner", element.getAssigner(), -1);
        }
    }

    protected void composeSubstanceAmount(Turtle.Complex parent, String parentType, String name, SubstanceAmount element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "SubstanceAmount", name, element, index);
        if (element.hasAmount()) {
            this.composeType(t, "SubstanceAmount", "amount", element.getAmount(), -1);
        }
        if (element.hasAmountType()) {
            this.composeCodeableConcept(t, "SubstanceAmount", "amountType", element.getAmountType(), -1);
        }
        if (element.hasAmountTextElement()) {
            this.composeString(t, "SubstanceAmount", "amountText", element.getAmountTextElement(), -1);
        }
        if (element.hasReferenceRange()) {
            this.composeSubstanceAmountSubstanceAmountReferenceRangeComponent(t, "SubstanceAmount", "referenceRange", element.getReferenceRange(), -1);
        }
    }

    protected void composeSubstanceAmountSubstanceAmountReferenceRangeComponent(Turtle.Complex parent, String parentType, String name, SubstanceAmount.SubstanceAmountReferenceRangeComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "referenceRange", name, element, index);
        if (element.hasLowLimit()) {
            this.composeQuantity(t, "SubstanceAmount", "lowLimit", element.getLowLimit(), -1);
        }
        if (element.hasHighLimit()) {
            this.composeQuantity(t, "SubstanceAmount", "highLimit", element.getHighLimit(), -1);
        }
    }

    protected void composeCoding(Turtle.Complex parent, String parentType, String name, Coding element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "Coding", name, element, index);
        this.decorateCoding(t, element);
        if (element.hasSystemElement()) {
            this.composeUri(t, "Coding", "system", element.getSystemElement(), -1);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "Coding", "version", element.getVersionElement(), -1);
        }
        if (element.hasCodeElement()) {
            this.composeCode(t, "Coding", "code", element.getCodeElement(), -1);
        }
        if (element.hasDisplayElement()) {
            this.composeString(t, "Coding", "display", element.getDisplayElement(), -1);
        }
        if (element.hasUserSelectedElement()) {
            this.composeBoolean(t, "Coding", "userSelected", element.getUserSelectedElement(), -1);
        }
    }

    protected void composeSampledData(Turtle.Complex parent, String parentType, String name, SampledData element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "SampledData", name, element, index);
        if (element.hasOrigin()) {
            this.composeQuantity(t, "SampledData", "origin", element.getOrigin(), -1);
        }
        if (element.hasPeriodElement()) {
            this.composeDecimal(t, "SampledData", "period", element.getPeriodElement(), -1);
        }
        if (element.hasFactorElement()) {
            this.composeDecimal(t, "SampledData", "factor", element.getFactorElement(), -1);
        }
        if (element.hasLowerLimitElement()) {
            this.composeDecimal(t, "SampledData", "lowerLimit", element.getLowerLimitElement(), -1);
        }
        if (element.hasUpperLimitElement()) {
            this.composeDecimal(t, "SampledData", "upperLimit", element.getUpperLimitElement(), -1);
        }
        if (element.hasDimensionsElement()) {
            this.composePositiveInt(t, "SampledData", "dimensions", element.getDimensionsElement(), -1);
        }
        if (element.hasDataElement()) {
            this.composeString(t, "SampledData", "data", element.getDataElement(), -1);
        }
    }

    protected void composePopulation(Turtle.Complex parent, String parentType, String name, Population element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "Population", name, element, index);
        if (element.hasAge()) {
            this.composeType(t, "Population", "age", element.getAge(), -1);
        }
        if (element.hasGender()) {
            this.composeCodeableConcept(t, "Population", "gender", element.getGender(), -1);
        }
        if (element.hasRace()) {
            this.composeCodeableConcept(t, "Population", "race", element.getRace(), -1);
        }
        if (element.hasPhysiologicalCondition()) {
            this.composeCodeableConcept(t, "Population", "physiologicalCondition", element.getPhysiologicalCondition(), -1);
        }
    }

    protected void composeRatio(Turtle.Complex parent, String parentType, String name, Ratio element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "Ratio", name, element, index);
        if (element.hasNumerator()) {
            this.composeQuantity(t, "Ratio", "numerator", element.getNumerator(), -1);
        }
        if (element.hasDenominator()) {
            this.composeQuantity(t, "Ratio", "denominator", element.getDenominator(), -1);
        }
    }

    protected void composeDistance(Turtle.Complex parent, String parentType, String name, Distance element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "Distance", name, element, index);
    }

    protected void composeAge(Turtle.Complex parent, String parentType, String name, Age element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "Age", name, element, index);
    }

    protected void composeReference(Turtle.Complex parent, String parentType, String name, Reference element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "Reference", name, element, index);
        if (element.hasReferenceElement()) {
            this.composeString(t, "Reference", "reference", element.getReferenceElement_(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeUri(t, "Reference", "type", element.getTypeElement(), -1);
        }
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "Reference", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasDisplayElement()) {
            this.composeString(t, "Reference", "display", element.getDisplayElement(), -1);
        }
    }

    protected void composeTriggerDefinition(Turtle.Complex parent, String parentType, String name, TriggerDefinition element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "TriggerDefinition", name, element, index);
        if (element.hasTypeElement()) {
            this.composeEnum(t, "TriggerDefinition", "type", element.getTypeElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "TriggerDefinition", "name", element.getNameElement(), -1);
        }
        if (element.hasTiming()) {
            this.composeType(t, "TriggerDefinition", "timing", element.getTiming(), -1);
        }
        for (int i = 0; i < element.getData().size(); ++i) {
            this.composeDataRequirement(t, "TriggerDefinition", "data", element.getData().get(i), i);
        }
        if (element.hasCondition()) {
            this.composeExpression(t, "TriggerDefinition", "condition", element.getCondition(), -1);
        }
    }

    protected void composeQuantity(Turtle.Complex parent, String parentType, String name, Quantity element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "Quantity", name, element, index);
        if (element.hasValueElement()) {
            this.composeDecimal(t, "Quantity", "value", element.getValueElement(), -1);
        }
        if (element.hasComparatorElement()) {
            this.composeEnum(t, "Quantity", "comparator", element.getComparatorElement(), -1);
        }
        if (element.hasUnitElement()) {
            this.composeString(t, "Quantity", "unit", element.getUnitElement(), -1);
        }
        if (element.hasSystemElement()) {
            this.composeUri(t, "Quantity", "system", element.getSystemElement(), -1);
        }
        if (element.hasCodeElement()) {
            this.composeCode(t, "Quantity", "code", element.getCodeElement(), -1);
        }
    }

    protected void composePeriod(Turtle.Complex parent, String parentType, String name, Period element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "Period", name, element, index);
        if (element.hasStartElement()) {
            this.composeDateTime(t, "Period", "start", element.getStartElement(), -1);
        }
        if (element.hasEndElement()) {
            this.composeDateTime(t, "Period", "end", element.getEndElement(), -1);
        }
    }

    protected void composeDuration(Turtle.Complex parent, String parentType, String name, Duration element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "Duration", name, element, index);
    }

    protected void composeRange(Turtle.Complex parent, String parentType, String name, Range element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "Range", name, element, index);
        if (element.hasLow()) {
            this.composeQuantity(t, "Range", "low", element.getLow(), -1);
        }
        if (element.hasHigh()) {
            this.composeQuantity(t, "Range", "high", element.getHigh(), -1);
        }
    }

    protected void composeRelatedArtifact(Turtle.Complex parent, String parentType, String name, RelatedArtifact element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "RelatedArtifact", name, element, index);
        if (element.hasTypeElement()) {
            this.composeEnum(t, "RelatedArtifact", "type", element.getTypeElement(), -1);
        }
        if (element.hasLabelElement()) {
            this.composeString(t, "RelatedArtifact", "label", element.getLabelElement(), -1);
        }
        if (element.hasDisplayElement()) {
            this.composeString(t, "RelatedArtifact", "display", element.getDisplayElement(), -1);
        }
        if (element.hasCitationElement()) {
            this.composeMarkdown(t, "RelatedArtifact", "citation", element.getCitationElement(), -1);
        }
        if (element.hasUrlElement()) {
            this.composeUrl(t, "RelatedArtifact", "url", element.getUrlElement(), -1);
        }
        if (element.hasDocument()) {
            this.composeAttachment(t, "RelatedArtifact", "document", element.getDocument(), -1);
        }
        if (element.hasResourceElement()) {
            this.composeCanonical(t, "RelatedArtifact", "resource", element.getResourceElement(), -1);
        }
    }

    protected void composeAnnotation(Turtle.Complex parent, String parentType, String name, Annotation element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "Annotation", name, element, index);
        if (element.hasAuthor()) {
            this.composeType(t, "Annotation", "author", element.getAuthor(), -1);
        }
        if (element.hasTimeElement()) {
            this.composeDateTime(t, "Annotation", "time", element.getTimeElement(), -1);
        }
        if (element.hasTextElement()) {
            this.composeMarkdown(t, "Annotation", "text", element.getTextElement(), -1);
        }
    }

    protected void composeProductShelfLife(Turtle.Complex parent, String parentType, String name, ProductShelfLife element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "ProductShelfLife", name, element, index);
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "ProductShelfLife", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "ProductShelfLife", "type", element.getType(), -1);
        }
        if (element.hasPeriod()) {
            this.composeQuantity(t, "ProductShelfLife", "period", element.getPeriod(), -1);
        }
        for (int i = 0; i < element.getSpecialPrecautionsForStorage().size(); ++i) {
            this.composeCodeableConcept(t, "ProductShelfLife", "specialPrecautionsForStorage", element.getSpecialPrecautionsForStorage().get(i), i);
        }
    }

    protected void composeContactDetail(Turtle.Complex parent, String parentType, String name, ContactDetail element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "ContactDetail", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "ContactDetail", "name", element.getNameElement(), -1);
        }
        for (int i = 0; i < element.getTelecom().size(); ++i) {
            this.composeContactPoint(t, "ContactDetail", "telecom", element.getTelecom().get(i), i);
        }
    }

    protected void composeUsageContext(Turtle.Complex parent, String parentType, String name, UsageContext element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "UsageContext", name, element, index);
        if (element.hasCode()) {
            this.composeCoding(t, "UsageContext", "code", element.getCode(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "UsageContext", "value", element.getValue(), -1);
        }
    }

    protected void composeExpression(Turtle.Complex parent, String parentType, String name, Expression element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "Expression", name, element, index);
        if (element.hasDescriptionElement()) {
            this.composeString(t, "Expression", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeId(t, "Expression", "name", element.getNameElement(), -1);
        }
        if (element.hasLanguageElement()) {
            this.composeCode(t, "Expression", "language", element.getLanguageElement(), -1);
        }
        if (element.hasExpressionElement()) {
            this.composeString(t, "Expression", "expression", element.getExpressionElement(), -1);
        }
        if (element.hasReferenceElement()) {
            this.composeUri(t, "Expression", "reference", element.getReferenceElement(), -1);
        }
    }

    protected void composeSignature(Turtle.Complex parent, String parentType, String name, Signature element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "Signature", name, element, index);
        for (int i = 0; i < element.getType().size(); ++i) {
            this.composeCoding(t, "Signature", "type", element.getType().get(i), i);
        }
        if (element.hasWhenElement()) {
            this.composeInstant(t, "Signature", "when", element.getWhenElement(), -1);
        }
        if (element.hasWho()) {
            this.composeReference(t, "Signature", "who", element.getWho(), -1);
        }
        if (element.hasOnBehalfOf()) {
            this.composeReference(t, "Signature", "onBehalfOf", element.getOnBehalfOf(), -1);
        }
        if (element.hasTargetFormatElement()) {
            this.composeCode(t, "Signature", "targetFormat", element.getTargetFormatElement(), -1);
        }
        if (element.hasSigFormatElement()) {
            this.composeCode(t, "Signature", "sigFormat", element.getSigFormatElement(), -1);
        }
        if (element.hasDataElement()) {
            this.composeBase64Binary(t, "Signature", "data", element.getDataElement(), -1);
        }
    }

    protected void composeTiming(Turtle.Complex parent, String parentType, String name, Timing element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "Timing", name, element, index);
        for (int i = 0; i < element.getEvent().size(); ++i) {
            this.composeDateTime(t, "Timing", "event", element.getEvent().get(i), i);
        }
        if (element.hasRepeat()) {
            this.composeTimingTimingRepeatComponent(t, "Timing", "repeat", element.getRepeat(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "Timing", "code", element.getCode(), -1);
        }
    }

    protected void composeTimingTimingRepeatComponent(Turtle.Complex parent, String parentType, String name, Timing.TimingRepeatComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "repeat", name, element, index);
        if (element.hasBounds()) {
            this.composeType(t, "Timing", "bounds", element.getBounds(), -1);
        }
        if (element.hasCountElement()) {
            this.composePositiveInt(t, "Timing", "count", element.getCountElement(), -1);
        }
        if (element.hasCountMaxElement()) {
            this.composePositiveInt(t, "Timing", "countMax", element.getCountMaxElement(), -1);
        }
        if (element.hasDurationElement()) {
            this.composeDecimal(t, "Timing", "duration", element.getDurationElement(), -1);
        }
        if (element.hasDurationMaxElement()) {
            this.composeDecimal(t, "Timing", "durationMax", element.getDurationMaxElement(), -1);
        }
        if (element.hasDurationUnitElement()) {
            this.composeEnum(t, "Timing", "durationUnit", element.getDurationUnitElement(), -1);
        }
        if (element.hasFrequencyElement()) {
            this.composePositiveInt(t, "Timing", "frequency", element.getFrequencyElement(), -1);
        }
        if (element.hasFrequencyMaxElement()) {
            this.composePositiveInt(t, "Timing", "frequencyMax", element.getFrequencyMaxElement(), -1);
        }
        if (element.hasPeriodElement()) {
            this.composeDecimal(t, "Timing", "period", element.getPeriodElement(), -1);
        }
        if (element.hasPeriodMaxElement()) {
            this.composeDecimal(t, "Timing", "periodMax", element.getPeriodMaxElement(), -1);
        }
        if (element.hasPeriodUnitElement()) {
            this.composeEnum(t, "Timing", "periodUnit", element.getPeriodUnitElement(), -1);
        }
        for (i = 0; i < element.getDayOfWeek().size(); ++i) {
            this.composeEnum(t, "Timing", "dayOfWeek", element.getDayOfWeek().get(i), i);
        }
        for (i = 0; i < element.getTimeOfDay().size(); ++i) {
            this.composeTime(t, "Timing", "timeOfDay", element.getTimeOfDay().get(i), i);
        }
        for (i = 0; i < element.getWhen().size(); ++i) {
            this.composeEnum(t, "Timing", "when", element.getWhen().get(i), i);
        }
        if (element.hasOffsetElement()) {
            this.composeUnsignedInt(t, "Timing", "offset", element.getOffsetElement(), -1);
        }
    }

    protected void composeProdCharacteristic(Turtle.Complex parent, String parentType, String name, ProdCharacteristic element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "ProdCharacteristic", name, element, index);
        if (element.hasHeight()) {
            this.composeQuantity(t, "ProdCharacteristic", "height", element.getHeight(), -1);
        }
        if (element.hasWidth()) {
            this.composeQuantity(t, "ProdCharacteristic", "width", element.getWidth(), -1);
        }
        if (element.hasDepth()) {
            this.composeQuantity(t, "ProdCharacteristic", "depth", element.getDepth(), -1);
        }
        if (element.hasWeight()) {
            this.composeQuantity(t, "ProdCharacteristic", "weight", element.getWeight(), -1);
        }
        if (element.hasNominalVolume()) {
            this.composeQuantity(t, "ProdCharacteristic", "nominalVolume", element.getNominalVolume(), -1);
        }
        if (element.hasExternalDiameter()) {
            this.composeQuantity(t, "ProdCharacteristic", "externalDiameter", element.getExternalDiameter(), -1);
        }
        if (element.hasShapeElement()) {
            this.composeString(t, "ProdCharacteristic", "shape", element.getShapeElement(), -1);
        }
        for (i = 0; i < element.getColor().size(); ++i) {
            this.composeString(t, "ProdCharacteristic", "color", element.getColor().get(i), i);
        }
        for (i = 0; i < element.getImprint().size(); ++i) {
            this.composeString(t, "ProdCharacteristic", "imprint", element.getImprint().get(i), i);
        }
        for (i = 0; i < element.getImage().size(); ++i) {
            this.composeAttachment(t, "ProdCharacteristic", "image", element.getImage().get(i), i);
        }
        if (element.hasScoring()) {
            this.composeCodeableConcept(t, "ProdCharacteristic", "scoring", element.getScoring(), -1);
        }
    }

    protected void composeCodeableConcept(Turtle.Complex parent, String parentType, String name, CodeableConcept element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "CodeableConcept", name, element, index);
        this.decorateCodeableConcept(t, element);
        for (int i = 0; i < element.getCoding().size(); ++i) {
            this.composeCoding(t, "CodeableConcept", "coding", element.getCoding().get(i), i);
        }
        if (element.hasTextElement()) {
            this.composeString(t, "CodeableConcept", "text", element.getTextElement(), -1);
        }
    }

    protected void composeParameterDefinition(Turtle.Complex parent, String parentType, String name, ParameterDefinition element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "ParameterDefinition", name, element, index);
        if (element.hasNameElement()) {
            this.composeCode(t, "ParameterDefinition", "name", element.getNameElement(), -1);
        }
        if (element.hasUseElement()) {
            this.composeEnum(t, "ParameterDefinition", "use", element.getUseElement(), -1);
        }
        if (element.hasMinElement()) {
            this.composeInteger(t, "ParameterDefinition", "min", element.getMinElement(), -1);
        }
        if (element.hasMaxElement()) {
            this.composeString(t, "ParameterDefinition", "max", element.getMaxElement(), -1);
        }
        if (element.hasDocumentationElement()) {
            this.composeString(t, "ParameterDefinition", "documentation", element.getDocumentationElement(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeCode(t, "ParameterDefinition", "type", element.getTypeElement(), -1);
        }
        if (element.hasProfileElement()) {
            this.composeCanonical(t, "ParameterDefinition", "profile", element.getProfileElement(), -1);
        }
    }

    protected void composeElementDefinition(Turtle.Complex parent, String parentType, String name, ElementDefinition element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "ElementDefinition", name, element, index);
        if (element.hasPathElement()) {
            this.composeString(t, "ElementDefinition", "path", element.getPathElement(), -1);
        }
        for (i = 0; i < element.getRepresentation().size(); ++i) {
            this.composeEnum(t, "ElementDefinition", "representation", element.getRepresentation().get(i), i);
        }
        if (element.hasSliceNameElement()) {
            this.composeString(t, "ElementDefinition", "sliceName", element.getSliceNameElement(), -1);
        }
        if (element.hasSliceIsConstrainingElement()) {
            this.composeBoolean(t, "ElementDefinition", "sliceIsConstraining", element.getSliceIsConstrainingElement(), -1);
        }
        if (element.hasLabelElement()) {
            this.composeString(t, "ElementDefinition", "label", element.getLabelElement(), -1);
        }
        for (i = 0; i < element.getCode().size(); ++i) {
            this.composeCoding(t, "ElementDefinition", "code", element.getCode().get(i), i);
        }
        if (element.hasSlicing()) {
            this.composeElementDefinitionElementDefinitionSlicingComponent(t, "ElementDefinition", "slicing", element.getSlicing(), -1);
        }
        if (element.hasShortElement()) {
            this.composeString(t, "ElementDefinition", "short", element.getShortElement(), -1);
        }
        if (element.hasDefinitionElement()) {
            this.composeMarkdown(t, "ElementDefinition", "definition", element.getDefinitionElement(), -1);
        }
        if (element.hasCommentElement()) {
            this.composeMarkdown(t, "ElementDefinition", "comment", element.getCommentElement(), -1);
        }
        if (element.hasRequirementsElement()) {
            this.composeMarkdown(t, "ElementDefinition", "requirements", element.getRequirementsElement(), -1);
        }
        for (i = 0; i < element.getAlias().size(); ++i) {
            this.composeString(t, "ElementDefinition", "alias", element.getAlias().get(i), i);
        }
        if (element.hasMinElement()) {
            this.composeUnsignedInt(t, "ElementDefinition", "min", element.getMinElement(), -1);
        }
        if (element.hasMaxElement()) {
            this.composeString(t, "ElementDefinition", "max", element.getMaxElement(), -1);
        }
        if (element.hasBase()) {
            this.composeElementDefinitionElementDefinitionBaseComponent(t, "ElementDefinition", "base", element.getBase(), -1);
        }
        if (element.hasContentReferenceElement()) {
            this.composeUri(t, "ElementDefinition", "contentReference", element.getContentReferenceElement(), -1);
        }
        for (i = 0; i < element.getType().size(); ++i) {
            this.composeElementDefinitionTypeRefComponent(t, "ElementDefinition", "type", element.getType().get(i), i);
        }
        if (element.hasDefaultValue()) {
            this.composeType(t, "ElementDefinition", "defaultValue", element.getDefaultValue(), -1);
        }
        if (element.hasMeaningWhenMissingElement()) {
            this.composeMarkdown(t, "ElementDefinition", "meaningWhenMissing", element.getMeaningWhenMissingElement(), -1);
        }
        if (element.hasOrderMeaningElement()) {
            this.composeString(t, "ElementDefinition", "orderMeaning", element.getOrderMeaningElement(), -1);
        }
        if (element.hasFixed()) {
            this.composeType(t, "ElementDefinition", "fixed", element.getFixed(), -1);
        }
        if (element.hasPattern()) {
            this.composeType(t, "ElementDefinition", "pattern", element.getPattern(), -1);
        }
        for (i = 0; i < element.getExample().size(); ++i) {
            this.composeElementDefinitionElementDefinitionExampleComponent(t, "ElementDefinition", "example", element.getExample().get(i), i);
        }
        if (element.hasMinValue()) {
            this.composeType(t, "ElementDefinition", "minValue", element.getMinValue(), -1);
        }
        if (element.hasMaxValue()) {
            this.composeType(t, "ElementDefinition", "maxValue", element.getMaxValue(), -1);
        }
        if (element.hasMaxLengthElement()) {
            this.composeInteger(t, "ElementDefinition", "maxLength", element.getMaxLengthElement(), -1);
        }
        for (i = 0; i < element.getCondition().size(); ++i) {
            this.composeId(t, "ElementDefinition", "condition", element.getCondition().get(i), i);
        }
        for (i = 0; i < element.getConstraint().size(); ++i) {
            this.composeElementDefinitionElementDefinitionConstraintComponent(t, "ElementDefinition", "constraint", element.getConstraint().get(i), i);
        }
        if (element.hasMustSupportElement()) {
            this.composeBoolean(t, "ElementDefinition", "mustSupport", element.getMustSupportElement(), -1);
        }
        if (element.hasIsModifierElement()) {
            this.composeBoolean(t, "ElementDefinition", "isModifier", element.getIsModifierElement(), -1);
        }
        if (element.hasIsModifierReasonElement()) {
            this.composeString(t, "ElementDefinition", "isModifierReason", element.getIsModifierReasonElement(), -1);
        }
        if (element.hasIsSummaryElement()) {
            this.composeBoolean(t, "ElementDefinition", "isSummary", element.getIsSummaryElement(), -1);
        }
        if (element.hasBinding()) {
            this.composeElementDefinitionElementDefinitionBindingComponent(t, "ElementDefinition", "binding", element.getBinding(), -1);
        }
        for (i = 0; i < element.getMapping().size(); ++i) {
            this.composeElementDefinitionElementDefinitionMappingComponent(t, "ElementDefinition", "mapping", element.getMapping().get(i), i);
        }
    }

    protected void composeElementDefinitionElementDefinitionSlicingComponent(Turtle.Complex parent, String parentType, String name, ElementDefinition.ElementDefinitionSlicingComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "slicing", name, element, index);
        for (int i = 0; i < element.getDiscriminator().size(); ++i) {
            this.composeElementDefinitionElementDefinitionSlicingDiscriminatorComponent(t, "ElementDefinition", "discriminator", element.getDiscriminator().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "ElementDefinition", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasOrderedElement()) {
            this.composeBoolean(t, "ElementDefinition", "ordered", element.getOrderedElement(), -1);
        }
        if (element.hasRulesElement()) {
            this.composeEnum(t, "ElementDefinition", "rules", element.getRulesElement(), -1);
        }
    }

    protected void composeElementDefinitionElementDefinitionSlicingDiscriminatorComponent(Turtle.Complex parent, String parentType, String name, ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "discriminator", name, element, index);
        if (element.hasTypeElement()) {
            this.composeEnum(t, "ElementDefinition", "type", element.getTypeElement(), -1);
        }
        if (element.hasPathElement()) {
            this.composeString(t, "ElementDefinition", "path", element.getPathElement(), -1);
        }
    }

    protected void composeElementDefinitionElementDefinitionBaseComponent(Turtle.Complex parent, String parentType, String name, ElementDefinition.ElementDefinitionBaseComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "base", name, element, index);
        if (element.hasPathElement()) {
            this.composeString(t, "ElementDefinition", "path", element.getPathElement(), -1);
        }
        if (element.hasMinElement()) {
            this.composeUnsignedInt(t, "ElementDefinition", "min", element.getMinElement(), -1);
        }
        if (element.hasMaxElement()) {
            this.composeString(t, "ElementDefinition", "max", element.getMaxElement(), -1);
        }
    }

    protected void composeElementDefinitionTypeRefComponent(Turtle.Complex parent, String parentType, String name, ElementDefinition.TypeRefComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "type", name, element, index);
        if (element.hasCodeElement()) {
            this.composeUri(t, "ElementDefinition", "code", element.getCodeElement(), -1);
        }
        for (i = 0; i < element.getProfile().size(); ++i) {
            this.composeCanonical(t, "ElementDefinition", "profile", element.getProfile().get(i), i);
        }
        for (i = 0; i < element.getTargetProfile().size(); ++i) {
            this.composeCanonical(t, "ElementDefinition", "targetProfile", element.getTargetProfile().get(i), i);
        }
        for (i = 0; i < element.getAggregation().size(); ++i) {
            this.composeEnum(t, "ElementDefinition", "aggregation", element.getAggregation().get(i), i);
        }
        if (element.hasVersioningElement()) {
            this.composeEnum(t, "ElementDefinition", "versioning", element.getVersioningElement(), -1);
        }
    }

    protected void composeElementDefinitionElementDefinitionExampleComponent(Turtle.Complex parent, String parentType, String name, ElementDefinition.ElementDefinitionExampleComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "example", name, element, index);
        if (element.hasLabelElement()) {
            this.composeString(t, "ElementDefinition", "label", element.getLabelElement(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "ElementDefinition", "value", element.getValue(), -1);
        }
    }

    protected void composeElementDefinitionElementDefinitionConstraintComponent(Turtle.Complex parent, String parentType, String name, ElementDefinition.ElementDefinitionConstraintComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "constraint", name, element, index);
        if (element.hasKeyElement()) {
            this.composeId(t, "ElementDefinition", "key", element.getKeyElement(), -1);
        }
        if (element.hasRequirementsElement()) {
            this.composeString(t, "ElementDefinition", "requirements", element.getRequirementsElement(), -1);
        }
        if (element.hasSeverityElement()) {
            this.composeEnum(t, "ElementDefinition", "severity", element.getSeverityElement(), -1);
        }
        if (element.hasHumanElement()) {
            this.composeString(t, "ElementDefinition", "human", element.getHumanElement(), -1);
        }
        if (element.hasExpressionElement()) {
            this.composeString(t, "ElementDefinition", "expression", element.getExpressionElement(), -1);
        }
        if (element.hasXpathElement()) {
            this.composeString(t, "ElementDefinition", "xpath", element.getXpathElement(), -1);
        }
        if (element.hasSourceElement()) {
            this.composeCanonical(t, "ElementDefinition", "source", element.getSourceElement(), -1);
        }
    }

    protected void composeElementDefinitionElementDefinitionBindingComponent(Turtle.Complex parent, String parentType, String name, ElementDefinition.ElementDefinitionBindingComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "binding", name, element, index);
        if (element.hasStrengthElement()) {
            this.composeEnum(t, "ElementDefinition", "strength", element.getStrengthElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "ElementDefinition", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasValueSetElement()) {
            this.composeCanonical(t, "ElementDefinition", "valueSet", element.getValueSetElement(), -1);
        }
    }

    protected void composeElementDefinitionElementDefinitionMappingComponent(Turtle.Complex parent, String parentType, String name, ElementDefinition.ElementDefinitionMappingComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "mapping", name, element, index);
        if (element.hasIdentityElement()) {
            this.composeId(t, "ElementDefinition", "identity", element.getIdentityElement(), -1);
        }
        if (element.hasLanguageElement()) {
            this.composeCode(t, "ElementDefinition", "language", element.getLanguageElement(), -1);
        }
        if (element.hasMapElement()) {
            this.composeString(t, "ElementDefinition", "map", element.getMapElement(), -1);
        }
        if (element.hasCommentElement()) {
            this.composeString(t, "ElementDefinition", "comment", element.getCommentElement(), -1);
        }
    }

    protected void composeDomainResource(Turtle.Complex t, String parentType, String name, DomainResource element, int index) {
        int i;
        this.composeResource(t, parentType, name, element, index);
        if (element.hasText()) {
            this.composeNarrative(t, "DomainResource", "text", element.getText(), -1);
        }
        for (i = 0; i < element.getContained().size(); ++i) {
            this.composeResource(t, "DomainResource", "contained", element.getContained().get(i), i);
        }
        for (i = 0; i < element.getExtension().size(); ++i) {
            this.composeExtension(t, "DomainResource", "extension", element.getExtension().get(i), i);
        }
        for (i = 0; i < element.getModifierExtension().size(); ++i) {
            this.composeExtension(t, "DomainResource", "modifierExtension", element.getModifierExtension().get(i), i);
        }
    }

    protected void composeParameters(Turtle.Complex parent, String parentType, String name, Parameters element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeResource(t, "Parameters", name, element, index);
        for (int i = 0; i < element.getParameter().size(); ++i) {
            this.composeParametersParametersParameterComponent(t, "Parameters", "parameter", element.getParameter().get(i), i);
        }
    }

    protected void composeParametersParametersParameterComponent(Turtle.Complex parent, String parentType, String name, Parameters.ParametersParameterComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "parameter", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "Parameters", "name", element.getNameElement(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "Parameters", "value", element.getValue(), -1);
        }
        if (element.hasResource()) {
            this.composeResource(t, "Parameters", "resource", element.getResource(), -1);
        }
        for (int i = 0; i < element.getPart().size(); ++i) {
            this.composeParametersParametersParameterComponent(t, "Parameters", "part", element.getPart().get(i), i);
        }
    }

    protected void composeResource(Turtle.Complex t, String parentType, String name, Resource element, int index) {
        if (element.hasIdElement()) {
            this.composeId(t, "Resource", "id", element.getIdElement(), -1);
        }
        if (element.hasMeta()) {
            this.composeMeta(t, "Resource", "meta", element.getMeta(), -1);
        }
        if (element.hasImplicitRulesElement()) {
            this.composeUri(t, "Resource", "implicitRules", element.getImplicitRulesElement(), -1);
        }
        if (element.hasLanguageElement()) {
            this.composeCode(t, "Resource", "language", element.getLanguageElement(), -1);
        }
    }

    protected void composeAccount(Turtle.Complex parent, String parentType, String name, Account element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Account", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Account", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Account", "status", element.getStatusElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "Account", "type", element.getType(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "Account", "name", element.getNameElement(), -1);
        }
        for (i = 0; i < element.getSubject().size(); ++i) {
            this.composeReference(t, "Account", "subject", element.getSubject().get(i), i);
        }
        if (element.hasServicePeriod()) {
            this.composePeriod(t, "Account", "servicePeriod", element.getServicePeriod(), -1);
        }
        for (i = 0; i < element.getCoverage().size(); ++i) {
            this.composeAccountCoverageComponent(t, "Account", "coverage", element.getCoverage().get(i), i);
        }
        if (element.hasOwner()) {
            this.composeReference(t, "Account", "owner", element.getOwner(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "Account", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getGuarantor().size(); ++i) {
            this.composeAccountGuarantorComponent(t, "Account", "guarantor", element.getGuarantor().get(i), i);
        }
        if (element.hasPartOf()) {
            this.composeReference(t, "Account", "partOf", element.getPartOf(), -1);
        }
    }

    protected void composeAccountCoverageComponent(Turtle.Complex parent, String parentType, String name, Account.CoverageComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "coverage", name, element, index);
        if (element.hasCoverage()) {
            this.composeReference(t, "Account", "coverage", element.getCoverage(), -1);
        }
        if (element.hasPriorityElement()) {
            this.composePositiveInt(t, "Account", "priority", element.getPriorityElement(), -1);
        }
    }

    protected void composeAccountGuarantorComponent(Turtle.Complex parent, String parentType, String name, Account.GuarantorComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "guarantor", name, element, index);
        if (element.hasParty()) {
            this.composeReference(t, "Account", "party", element.getParty(), -1);
        }
        if (element.hasOnHoldElement()) {
            this.composeBoolean(t, "Account", "onHold", element.getOnHoldElement(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "Account", "period", element.getPeriod(), -1);
        }
    }

    protected void composeActivityDefinition(Turtle.Complex parent, String parentType, String name, ActivityDefinition element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "ActivityDefinition", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "ActivityDefinition", "url", element.getUrlElement(), -1);
        }
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "ActivityDefinition", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "ActivityDefinition", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "ActivityDefinition", "name", element.getNameElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "ActivityDefinition", "title", element.getTitleElement(), -1);
        }
        if (element.hasSubtitleElement()) {
            this.composeString(t, "ActivityDefinition", "subtitle", element.getSubtitleElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "ActivityDefinition", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "ActivityDefinition", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasSubject()) {
            this.composeType(t, "ActivityDefinition", "subject", element.getSubject(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "ActivityDefinition", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "ActivityDefinition", "publisher", element.getPublisherElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeContactDetail(t, "ActivityDefinition", "contact", element.getContact().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "ActivityDefinition", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getUseContext().size(); ++i) {
            this.composeUsageContext(t, "ActivityDefinition", "useContext", element.getUseContext().get(i), i);
        }
        for (i = 0; i < element.getJurisdiction().size(); ++i) {
            this.composeCodeableConcept(t, "ActivityDefinition", "jurisdiction", element.getJurisdiction().get(i), i);
        }
        if (element.hasPurposeElement()) {
            this.composeMarkdown(t, "ActivityDefinition", "purpose", element.getPurposeElement(), -1);
        }
        if (element.hasUsageElement()) {
            this.composeString(t, "ActivityDefinition", "usage", element.getUsageElement(), -1);
        }
        if (element.hasCopyrightElement()) {
            this.composeMarkdown(t, "ActivityDefinition", "copyright", element.getCopyrightElement(), -1);
        }
        if (element.hasApprovalDateElement()) {
            this.composeDate(t, "ActivityDefinition", "approvalDate", element.getApprovalDateElement(), -1);
        }
        if (element.hasLastReviewDateElement()) {
            this.composeDate(t, "ActivityDefinition", "lastReviewDate", element.getLastReviewDateElement(), -1);
        }
        if (element.hasEffectivePeriod()) {
            this.composePeriod(t, "ActivityDefinition", "effectivePeriod", element.getEffectivePeriod(), -1);
        }
        for (i = 0; i < element.getTopic().size(); ++i) {
            this.composeCodeableConcept(t, "ActivityDefinition", "topic", element.getTopic().get(i), i);
        }
        for (i = 0; i < element.getAuthor().size(); ++i) {
            this.composeContactDetail(t, "ActivityDefinition", "author", element.getAuthor().get(i), i);
        }
        for (i = 0; i < element.getEditor().size(); ++i) {
            this.composeContactDetail(t, "ActivityDefinition", "editor", element.getEditor().get(i), i);
        }
        for (i = 0; i < element.getReviewer().size(); ++i) {
            this.composeContactDetail(t, "ActivityDefinition", "reviewer", element.getReviewer().get(i), i);
        }
        for (i = 0; i < element.getEndorser().size(); ++i) {
            this.composeContactDetail(t, "ActivityDefinition", "endorser", element.getEndorser().get(i), i);
        }
        for (i = 0; i < element.getRelatedArtifact().size(); ++i) {
            this.composeRelatedArtifact(t, "ActivityDefinition", "relatedArtifact", element.getRelatedArtifact().get(i), i);
        }
        for (i = 0; i < element.getLibrary().size(); ++i) {
            this.composeCanonical(t, "ActivityDefinition", "library", element.getLibrary().get(i), i);
        }
        if (element.hasKindElement()) {
            this.composeEnum(t, "ActivityDefinition", "kind", element.getKindElement(), -1);
        }
        if (element.hasProfileElement()) {
            this.composeCanonical(t, "ActivityDefinition", "profile", element.getProfileElement(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "ActivityDefinition", "code", element.getCode(), -1);
        }
        if (element.hasIntentElement()) {
            this.composeEnum(t, "ActivityDefinition", "intent", element.getIntentElement(), -1);
        }
        if (element.hasPriorityElement()) {
            this.composeEnum(t, "ActivityDefinition", "priority", element.getPriorityElement(), -1);
        }
        if (element.hasDoNotPerformElement()) {
            this.composeBoolean(t, "ActivityDefinition", "doNotPerform", element.getDoNotPerformElement(), -1);
        }
        if (element.hasTiming()) {
            this.composeType(t, "ActivityDefinition", "timing", element.getTiming(), -1);
        }
        if (element.hasLocation()) {
            this.composeReference(t, "ActivityDefinition", "location", element.getLocation(), -1);
        }
        for (i = 0; i < element.getParticipant().size(); ++i) {
            this.composeActivityDefinitionActivityDefinitionParticipantComponent(t, "ActivityDefinition", "participant", element.getParticipant().get(i), i);
        }
        if (element.hasProduct()) {
            this.composeType(t, "ActivityDefinition", "product", element.getProduct(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "ActivityDefinition", "quantity", element.getQuantity(), -1);
        }
        for (i = 0; i < element.getDosage().size(); ++i) {
            this.composeDosage(t, "ActivityDefinition", "dosage", element.getDosage().get(i), i);
        }
        for (i = 0; i < element.getBodySite().size(); ++i) {
            this.composeCodeableConcept(t, "ActivityDefinition", "bodySite", element.getBodySite().get(i), i);
        }
        for (i = 0; i < element.getSpecimenRequirement().size(); ++i) {
            this.composeReference(t, "ActivityDefinition", "specimenRequirement", element.getSpecimenRequirement().get(i), i);
        }
        for (i = 0; i < element.getObservationRequirement().size(); ++i) {
            this.composeReference(t, "ActivityDefinition", "observationRequirement", element.getObservationRequirement().get(i), i);
        }
        for (i = 0; i < element.getObservationResultRequirement().size(); ++i) {
            this.composeReference(t, "ActivityDefinition", "observationResultRequirement", element.getObservationResultRequirement().get(i), i);
        }
        if (element.hasTransformElement()) {
            this.composeCanonical(t, "ActivityDefinition", "transform", element.getTransformElement(), -1);
        }
        for (i = 0; i < element.getDynamicValue().size(); ++i) {
            this.composeActivityDefinitionActivityDefinitionDynamicValueComponent(t, "ActivityDefinition", "dynamicValue", element.getDynamicValue().get(i), i);
        }
    }

    protected void composeActivityDefinitionActivityDefinitionParticipantComponent(Turtle.Complex parent, String parentType, String name, ActivityDefinition.ActivityDefinitionParticipantComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "participant", name, element, index);
        if (element.hasTypeElement()) {
            this.composeEnum(t, "ActivityDefinition", "type", element.getTypeElement(), -1);
        }
        if (element.hasRole()) {
            this.composeCodeableConcept(t, "ActivityDefinition", "role", element.getRole(), -1);
        }
    }

    protected void composeActivityDefinitionActivityDefinitionDynamicValueComponent(Turtle.Complex parent, String parentType, String name, ActivityDefinition.ActivityDefinitionDynamicValueComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "dynamicValue", name, element, index);
        if (element.hasPathElement()) {
            this.composeString(t, "ActivityDefinition", "path", element.getPathElement(), -1);
        }
        if (element.hasExpression()) {
            this.composeExpression(t, "ActivityDefinition", "expression", element.getExpression(), -1);
        }
    }

    protected void composeAdverseEvent(Turtle.Complex parent, String parentType, String name, AdverseEvent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "AdverseEvent", name, element, index);
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "AdverseEvent", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasActualityElement()) {
            this.composeEnum(t, "AdverseEvent", "actuality", element.getActualityElement(), -1);
        }
        for (i = 0; i < element.getCategory().size(); ++i) {
            this.composeCodeableConcept(t, "AdverseEvent", "category", element.getCategory().get(i), i);
        }
        if (element.hasEvent()) {
            this.composeCodeableConcept(t, "AdverseEvent", "event", element.getEvent(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "AdverseEvent", "subject", element.getSubject(), -1);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "AdverseEvent", "encounter", element.getEncounter(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "AdverseEvent", "date", element.getDateElement(), -1);
        }
        if (element.hasDetectedElement()) {
            this.composeDateTime(t, "AdverseEvent", "detected", element.getDetectedElement(), -1);
        }
        if (element.hasRecordedDateElement()) {
            this.composeDateTime(t, "AdverseEvent", "recordedDate", element.getRecordedDateElement(), -1);
        }
        for (i = 0; i < element.getResultingCondition().size(); ++i) {
            this.composeReference(t, "AdverseEvent", "resultingCondition", element.getResultingCondition().get(i), i);
        }
        if (element.hasLocation()) {
            this.composeReference(t, "AdverseEvent", "location", element.getLocation(), -1);
        }
        if (element.hasSeriousness()) {
            this.composeCodeableConcept(t, "AdverseEvent", "seriousness", element.getSeriousness(), -1);
        }
        if (element.hasSeverity()) {
            this.composeCodeableConcept(t, "AdverseEvent", "severity", element.getSeverity(), -1);
        }
        if (element.hasOutcome()) {
            this.composeCodeableConcept(t, "AdverseEvent", "outcome", element.getOutcome(), -1);
        }
        if (element.hasRecorder()) {
            this.composeReference(t, "AdverseEvent", "recorder", element.getRecorder(), -1);
        }
        for (i = 0; i < element.getContributor().size(); ++i) {
            this.composeReference(t, "AdverseEvent", "contributor", element.getContributor().get(i), i);
        }
        for (i = 0; i < element.getSuspectEntity().size(); ++i) {
            this.composeAdverseEventAdverseEventSuspectEntityComponent(t, "AdverseEvent", "suspectEntity", element.getSuspectEntity().get(i), i);
        }
        for (i = 0; i < element.getSubjectMedicalHistory().size(); ++i) {
            this.composeReference(t, "AdverseEvent", "subjectMedicalHistory", element.getSubjectMedicalHistory().get(i), i);
        }
        for (i = 0; i < element.getReferenceDocument().size(); ++i) {
            this.composeReference(t, "AdverseEvent", "referenceDocument", element.getReferenceDocument().get(i), i);
        }
        for (i = 0; i < element.getStudy().size(); ++i) {
            this.composeReference(t, "AdverseEvent", "study", element.getStudy().get(i), i);
        }
    }

    protected void composeAdverseEventAdverseEventSuspectEntityComponent(Turtle.Complex parent, String parentType, String name, AdverseEvent.AdverseEventSuspectEntityComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "suspectEntity", name, element, index);
        if (element.hasInstance()) {
            this.composeReference(t, "AdverseEvent", "instance", element.getInstance(), -1);
        }
        for (int i = 0; i < element.getCausality().size(); ++i) {
            this.composeAdverseEventAdverseEventSuspectEntityCausalityComponent(t, "AdverseEvent", "causality", element.getCausality().get(i), i);
        }
    }

    protected void composeAdverseEventAdverseEventSuspectEntityCausalityComponent(Turtle.Complex parent, String parentType, String name, AdverseEvent.AdverseEventSuspectEntityCausalityComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "causality", name, element, index);
        if (element.hasAssessment()) {
            this.composeCodeableConcept(t, "AdverseEvent", "assessment", element.getAssessment(), -1);
        }
        if (element.hasProductRelatednessElement()) {
            this.composeString(t, "AdverseEvent", "productRelatedness", element.getProductRelatednessElement(), -1);
        }
        if (element.hasAuthor()) {
            this.composeReference(t, "AdverseEvent", "author", element.getAuthor(), -1);
        }
        if (element.hasMethod()) {
            this.composeCodeableConcept(t, "AdverseEvent", "method", element.getMethod(), -1);
        }
    }

    protected void composeAllergyIntolerance(Turtle.Complex parent, String parentType, String name, AllergyIntolerance element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "AllergyIntolerance", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "AllergyIntolerance", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasClinicalStatus()) {
            this.composeCodeableConcept(t, "AllergyIntolerance", "clinicalStatus", element.getClinicalStatus(), -1);
        }
        if (element.hasVerificationStatus()) {
            this.composeCodeableConcept(t, "AllergyIntolerance", "verificationStatus", element.getVerificationStatus(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeEnum(t, "AllergyIntolerance", "type", element.getTypeElement(), -1);
        }
        for (i = 0; i < element.getCategory().size(); ++i) {
            this.composeEnum(t, "AllergyIntolerance", "category", element.getCategory().get(i), i);
        }
        if (element.hasCriticalityElement()) {
            this.composeEnum(t, "AllergyIntolerance", "criticality", element.getCriticalityElement(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "AllergyIntolerance", "code", element.getCode(), -1);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "AllergyIntolerance", "patient", element.getPatient(), -1);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "AllergyIntolerance", "encounter", element.getEncounter(), -1);
        }
        if (element.hasOnset()) {
            this.composeType(t, "AllergyIntolerance", "onset", element.getOnset(), -1);
        }
        if (element.hasRecordedDateElement()) {
            this.composeDateTime(t, "AllergyIntolerance", "recordedDate", element.getRecordedDateElement(), -1);
        }
        if (element.hasRecorder()) {
            this.composeReference(t, "AllergyIntolerance", "recorder", element.getRecorder(), -1);
        }
        if (element.hasAsserter()) {
            this.composeReference(t, "AllergyIntolerance", "asserter", element.getAsserter(), -1);
        }
        if (element.hasLastOccurrenceElement()) {
            this.composeDateTime(t, "AllergyIntolerance", "lastOccurrence", element.getLastOccurrenceElement(), -1);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "AllergyIntolerance", "note", element.getNote().get(i), i);
        }
        for (i = 0; i < element.getReaction().size(); ++i) {
            this.composeAllergyIntoleranceAllergyIntoleranceReactionComponent(t, "AllergyIntolerance", "reaction", element.getReaction().get(i), i);
        }
    }

    protected void composeAllergyIntoleranceAllergyIntoleranceReactionComponent(Turtle.Complex parent, String parentType, String name, AllergyIntolerance.AllergyIntoleranceReactionComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "reaction", name, element, index);
        if (element.hasSubstance()) {
            this.composeCodeableConcept(t, "AllergyIntolerance", "substance", element.getSubstance(), -1);
        }
        for (i = 0; i < element.getManifestation().size(); ++i) {
            this.composeCodeableConcept(t, "AllergyIntolerance", "manifestation", element.getManifestation().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "AllergyIntolerance", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasOnsetElement()) {
            this.composeDateTime(t, "AllergyIntolerance", "onset", element.getOnsetElement(), -1);
        }
        if (element.hasSeverityElement()) {
            this.composeEnum(t, "AllergyIntolerance", "severity", element.getSeverityElement(), -1);
        }
        if (element.hasExposureRoute()) {
            this.composeCodeableConcept(t, "AllergyIntolerance", "exposureRoute", element.getExposureRoute(), -1);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "AllergyIntolerance", "note", element.getNote().get(i), i);
        }
    }

    protected void composeAppointment(Turtle.Complex parent, String parentType, String name, Appointment element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Appointment", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Appointment", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Appointment", "status", element.getStatusElement(), -1);
        }
        if (element.hasCancelationReason()) {
            this.composeCodeableConcept(t, "Appointment", "cancelationReason", element.getCancelationReason(), -1);
        }
        for (i = 0; i < element.getServiceCategory().size(); ++i) {
            this.composeCodeableConcept(t, "Appointment", "serviceCategory", element.getServiceCategory().get(i), i);
        }
        for (i = 0; i < element.getServiceType().size(); ++i) {
            this.composeCodeableConcept(t, "Appointment", "serviceType", element.getServiceType().get(i), i);
        }
        for (i = 0; i < element.getSpecialty().size(); ++i) {
            this.composeCodeableConcept(t, "Appointment", "specialty", element.getSpecialty().get(i), i);
        }
        if (element.hasAppointmentType()) {
            this.composeCodeableConcept(t, "Appointment", "appointmentType", element.getAppointmentType(), -1);
        }
        for (i = 0; i < element.getReasonCode().size(); ++i) {
            this.composeCodeableConcept(t, "Appointment", "reasonCode", element.getReasonCode().get(i), i);
        }
        for (i = 0; i < element.getReasonReference().size(); ++i) {
            this.composeReference(t, "Appointment", "reasonReference", element.getReasonReference().get(i), i);
        }
        if (element.hasPriorityElement()) {
            this.composeUnsignedInt(t, "Appointment", "priority", element.getPriorityElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "Appointment", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getSupportingInformation().size(); ++i) {
            this.composeReference(t, "Appointment", "supportingInformation", element.getSupportingInformation().get(i), i);
        }
        if (element.hasStartElement()) {
            this.composeInstant(t, "Appointment", "start", element.getStartElement(), -1);
        }
        if (element.hasEndElement()) {
            this.composeInstant(t, "Appointment", "end", element.getEndElement(), -1);
        }
        if (element.hasMinutesDurationElement()) {
            this.composePositiveInt(t, "Appointment", "minutesDuration", element.getMinutesDurationElement(), -1);
        }
        for (i = 0; i < element.getSlot().size(); ++i) {
            this.composeReference(t, "Appointment", "slot", element.getSlot().get(i), i);
        }
        if (element.hasCreatedElement()) {
            this.composeDateTime(t, "Appointment", "created", element.getCreatedElement(), -1);
        }
        if (element.hasCommentElement()) {
            this.composeString(t, "Appointment", "comment", element.getCommentElement(), -1);
        }
        if (element.hasPatientInstructionElement()) {
            this.composeString(t, "Appointment", "patientInstruction", element.getPatientInstructionElement(), -1);
        }
        for (i = 0; i < element.getBasedOn().size(); ++i) {
            this.composeReference(t, "Appointment", "basedOn", element.getBasedOn().get(i), i);
        }
        for (i = 0; i < element.getParticipant().size(); ++i) {
            this.composeAppointmentAppointmentParticipantComponent(t, "Appointment", "participant", element.getParticipant().get(i), i);
        }
        for (i = 0; i < element.getRequestedPeriod().size(); ++i) {
            this.composePeriod(t, "Appointment", "requestedPeriod", element.getRequestedPeriod().get(i), i);
        }
    }

    protected void composeAppointmentAppointmentParticipantComponent(Turtle.Complex parent, String parentType, String name, Appointment.AppointmentParticipantComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "participant", name, element, index);
        for (int i = 0; i < element.getType().size(); ++i) {
            this.composeCodeableConcept(t, "Appointment", "type", element.getType().get(i), i);
        }
        if (element.hasActor()) {
            this.composeReference(t, "Appointment", "actor", element.getActor(), -1);
        }
        if (element.hasRequiredElement()) {
            this.composeEnum(t, "Appointment", "required", element.getRequiredElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Appointment", "status", element.getStatusElement(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "Appointment", "period", element.getPeriod(), -1);
        }
    }

    protected void composeAppointmentResponse(Turtle.Complex parent, String parentType, String name, AppointmentResponse element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "AppointmentResponse", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "AppointmentResponse", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasAppointment()) {
            this.composeReference(t, "AppointmentResponse", "appointment", element.getAppointment(), -1);
        }
        if (element.hasStartElement()) {
            this.composeInstant(t, "AppointmentResponse", "start", element.getStartElement(), -1);
        }
        if (element.hasEndElement()) {
            this.composeInstant(t, "AppointmentResponse", "end", element.getEndElement(), -1);
        }
        for (i = 0; i < element.getParticipantType().size(); ++i) {
            this.composeCodeableConcept(t, "AppointmentResponse", "participantType", element.getParticipantType().get(i), i);
        }
        if (element.hasActor()) {
            this.composeReference(t, "AppointmentResponse", "actor", element.getActor(), -1);
        }
        if (element.hasParticipantStatusElement()) {
            this.composeEnum(t, "AppointmentResponse", "participantStatus", element.getParticipantStatusElement(), -1);
        }
        if (element.hasCommentElement()) {
            this.composeString(t, "AppointmentResponse", "comment", element.getCommentElement(), -1);
        }
    }

    protected void composeAuditEvent(Turtle.Complex parent, String parentType, String name, AuditEvent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "AuditEvent", name, element, index);
        if (element.hasType()) {
            this.composeCoding(t, "AuditEvent", "type", element.getType(), -1);
        }
        for (i = 0; i < element.getSubtype().size(); ++i) {
            this.composeCoding(t, "AuditEvent", "subtype", element.getSubtype().get(i), i);
        }
        if (element.hasActionElement()) {
            this.composeEnum(t, "AuditEvent", "action", element.getActionElement(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "AuditEvent", "period", element.getPeriod(), -1);
        }
        if (element.hasRecordedElement()) {
            this.composeInstant(t, "AuditEvent", "recorded", element.getRecordedElement(), -1);
        }
        if (element.hasOutcomeElement()) {
            this.composeEnum(t, "AuditEvent", "outcome", element.getOutcomeElement(), -1);
        }
        if (element.hasOutcomeDescElement()) {
            this.composeString(t, "AuditEvent", "outcomeDesc", element.getOutcomeDescElement(), -1);
        }
        for (i = 0; i < element.getPurposeOfEvent().size(); ++i) {
            this.composeCodeableConcept(t, "AuditEvent", "purposeOfEvent", element.getPurposeOfEvent().get(i), i);
        }
        for (i = 0; i < element.getAgent().size(); ++i) {
            this.composeAuditEventAuditEventAgentComponent(t, "AuditEvent", "agent", element.getAgent().get(i), i);
        }
        if (element.hasSource()) {
            this.composeAuditEventAuditEventSourceComponent(t, "AuditEvent", "source", element.getSource(), -1);
        }
        for (i = 0; i < element.getEntity().size(); ++i) {
            this.composeAuditEventAuditEventEntityComponent(t, "AuditEvent", "entity", element.getEntity().get(i), i);
        }
    }

    protected void composeAuditEventAuditEventAgentComponent(Turtle.Complex parent, String parentType, String name, AuditEvent.AuditEventAgentComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "agent", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "AuditEvent", "type", element.getType(), -1);
        }
        for (i = 0; i < element.getRole().size(); ++i) {
            this.composeCodeableConcept(t, "AuditEvent", "role", element.getRole().get(i), i);
        }
        if (element.hasWho()) {
            this.composeReference(t, "AuditEvent", "who", element.getWho(), -1);
        }
        if (element.hasAltIdElement()) {
            this.composeString(t, "AuditEvent", "altId", element.getAltIdElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "AuditEvent", "name", element.getNameElement(), -1);
        }
        if (element.hasRequestorElement()) {
            this.composeBoolean(t, "AuditEvent", "requestor", element.getRequestorElement(), -1);
        }
        if (element.hasLocation()) {
            this.composeReference(t, "AuditEvent", "location", element.getLocation(), -1);
        }
        for (i = 0; i < element.getPolicy().size(); ++i) {
            this.composeUri(t, "AuditEvent", "policy", element.getPolicy().get(i), i);
        }
        if (element.hasMedia()) {
            this.composeCoding(t, "AuditEvent", "media", element.getMedia(), -1);
        }
        if (element.hasNetwork()) {
            this.composeAuditEventAuditEventAgentNetworkComponent(t, "AuditEvent", "network", element.getNetwork(), -1);
        }
        for (i = 0; i < element.getPurposeOfUse().size(); ++i) {
            this.composeCodeableConcept(t, "AuditEvent", "purposeOfUse", element.getPurposeOfUse().get(i), i);
        }
    }

    protected void composeAuditEventAuditEventAgentNetworkComponent(Turtle.Complex parent, String parentType, String name, AuditEvent.AuditEventAgentNetworkComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "network", name, element, index);
        if (element.hasAddressElement()) {
            this.composeString(t, "AuditEvent", "address", element.getAddressElement(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeEnum(t, "AuditEvent", "type", element.getTypeElement(), -1);
        }
    }

    protected void composeAuditEventAuditEventSourceComponent(Turtle.Complex parent, String parentType, String name, AuditEvent.AuditEventSourceComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "source", name, element, index);
        if (element.hasSiteElement()) {
            this.composeString(t, "AuditEvent", "site", element.getSiteElement(), -1);
        }
        if (element.hasObserver()) {
            this.composeReference(t, "AuditEvent", "observer", element.getObserver(), -1);
        }
        for (int i = 0; i < element.getType().size(); ++i) {
            this.composeCoding(t, "AuditEvent", "type", element.getType().get(i), i);
        }
    }

    protected void composeAuditEventAuditEventEntityComponent(Turtle.Complex parent, String parentType, String name, AuditEvent.AuditEventEntityComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "entity", name, element, index);
        if (element.hasWhat()) {
            this.composeReference(t, "AuditEvent", "what", element.getWhat(), -1);
        }
        if (element.hasType()) {
            this.composeCoding(t, "AuditEvent", "type", element.getType(), -1);
        }
        if (element.hasRole()) {
            this.composeCoding(t, "AuditEvent", "role", element.getRole(), -1);
        }
        if (element.hasLifecycle()) {
            this.composeCoding(t, "AuditEvent", "lifecycle", element.getLifecycle(), -1);
        }
        for (i = 0; i < element.getSecurityLabel().size(); ++i) {
            this.composeCoding(t, "AuditEvent", "securityLabel", element.getSecurityLabel().get(i), i);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "AuditEvent", "name", element.getNameElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "AuditEvent", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasQueryElement()) {
            this.composeBase64Binary(t, "AuditEvent", "query", element.getQueryElement(), -1);
        }
        for (i = 0; i < element.getDetail().size(); ++i) {
            this.composeAuditEventAuditEventEntityDetailComponent(t, "AuditEvent", "detail", element.getDetail().get(i), i);
        }
    }

    protected void composeAuditEventAuditEventEntityDetailComponent(Turtle.Complex parent, String parentType, String name, AuditEvent.AuditEventEntityDetailComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "detail", name, element, index);
        if (element.hasTypeElement()) {
            this.composeString(t, "AuditEvent", "type", element.getTypeElement(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "AuditEvent", "value", element.getValue(), -1);
        }
    }

    protected void composeBasic(Turtle.Complex parent, String parentType, String name, Basic element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Basic", name, element, index);
        for (int i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Basic", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "Basic", "code", element.getCode(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "Basic", "subject", element.getSubject(), -1);
        }
        if (element.hasCreatedElement()) {
            this.composeDate(t, "Basic", "created", element.getCreatedElement(), -1);
        }
        if (element.hasAuthor()) {
            this.composeReference(t, "Basic", "author", element.getAuthor(), -1);
        }
    }

    protected void composeBinary(Turtle.Complex parent, String parentType, String name, Binary element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeResource(t, "Binary", name, element, index);
        if (element.hasContentTypeElement()) {
            this.composeCode(t, "Binary", "contentType", element.getContentTypeElement(), -1);
        }
        if (element.hasSecurityContext()) {
            this.composeReference(t, "Binary", "securityContext", element.getSecurityContext(), -1);
        }
        if (element.hasDataElement()) {
            this.composeBase64Binary(t, "Binary", "data", element.getDataElement(), -1);
        }
    }

    protected void composeBiologicallyDerivedProduct(Turtle.Complex parent, String parentType, String name, BiologicallyDerivedProduct element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "BiologicallyDerivedProduct", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "BiologicallyDerivedProduct", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasProductCategoryElement()) {
            this.composeEnum(t, "BiologicallyDerivedProduct", "productCategory", element.getProductCategoryElement(), -1);
        }
        if (element.hasProductCode()) {
            this.composeCodeableConcept(t, "BiologicallyDerivedProduct", "productCode", element.getProductCode(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "BiologicallyDerivedProduct", "status", element.getStatusElement(), -1);
        }
        for (i = 0; i < element.getRequest().size(); ++i) {
            this.composeReference(t, "BiologicallyDerivedProduct", "request", element.getRequest().get(i), i);
        }
        if (element.hasQuantityElement()) {
            this.composeInteger(t, "BiologicallyDerivedProduct", "quantity", element.getQuantityElement(), -1);
        }
        for (i = 0; i < element.getParent().size(); ++i) {
            this.composeReference(t, "BiologicallyDerivedProduct", "parent", element.getParent().get(i), i);
        }
        if (element.hasCollection()) {
            this.composeBiologicallyDerivedProductBiologicallyDerivedProductCollectionComponent(t, "BiologicallyDerivedProduct", "collection", element.getCollection(), -1);
        }
        for (i = 0; i < element.getProcessing().size(); ++i) {
            this.composeBiologicallyDerivedProductBiologicallyDerivedProductProcessingComponent(t, "BiologicallyDerivedProduct", "processing", element.getProcessing().get(i), i);
        }
        if (element.hasManipulation()) {
            this.composeBiologicallyDerivedProductBiologicallyDerivedProductManipulationComponent(t, "BiologicallyDerivedProduct", "manipulation", element.getManipulation(), -1);
        }
        for (i = 0; i < element.getStorage().size(); ++i) {
            this.composeBiologicallyDerivedProductBiologicallyDerivedProductStorageComponent(t, "BiologicallyDerivedProduct", "storage", element.getStorage().get(i), i);
        }
    }

    protected void composeBiologicallyDerivedProductBiologicallyDerivedProductCollectionComponent(Turtle.Complex parent, String parentType, String name, BiologicallyDerivedProduct.BiologicallyDerivedProductCollectionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "collection", name, element, index);
        if (element.hasCollector()) {
            this.composeReference(t, "BiologicallyDerivedProduct", "collector", element.getCollector(), -1);
        }
        if (element.hasSource()) {
            this.composeReference(t, "BiologicallyDerivedProduct", "source", element.getSource(), -1);
        }
        if (element.hasCollected()) {
            this.composeType(t, "BiologicallyDerivedProduct", "collected", element.getCollected(), -1);
        }
    }

    protected void composeBiologicallyDerivedProductBiologicallyDerivedProductProcessingComponent(Turtle.Complex parent, String parentType, String name, BiologicallyDerivedProduct.BiologicallyDerivedProductProcessingComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "processing", name, element, index);
        if (element.hasDescriptionElement()) {
            this.composeString(t, "BiologicallyDerivedProduct", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasProcedure()) {
            this.composeCodeableConcept(t, "BiologicallyDerivedProduct", "procedure", element.getProcedure(), -1);
        }
        if (element.hasAdditive()) {
            this.composeReference(t, "BiologicallyDerivedProduct", "additive", element.getAdditive(), -1);
        }
        if (element.hasTime()) {
            this.composeType(t, "BiologicallyDerivedProduct", "time", element.getTime(), -1);
        }
    }

    protected void composeBiologicallyDerivedProductBiologicallyDerivedProductManipulationComponent(Turtle.Complex parent, String parentType, String name, BiologicallyDerivedProduct.BiologicallyDerivedProductManipulationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "manipulation", name, element, index);
        if (element.hasDescriptionElement()) {
            this.composeString(t, "BiologicallyDerivedProduct", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasTime()) {
            this.composeType(t, "BiologicallyDerivedProduct", "time", element.getTime(), -1);
        }
    }

    protected void composeBiologicallyDerivedProductBiologicallyDerivedProductStorageComponent(Turtle.Complex parent, String parentType, String name, BiologicallyDerivedProduct.BiologicallyDerivedProductStorageComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "storage", name, element, index);
        if (element.hasDescriptionElement()) {
            this.composeString(t, "BiologicallyDerivedProduct", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasTemperatureElement()) {
            this.composeDecimal(t, "BiologicallyDerivedProduct", "temperature", element.getTemperatureElement(), -1);
        }
        if (element.hasScaleElement()) {
            this.composeEnum(t, "BiologicallyDerivedProduct", "scale", element.getScaleElement(), -1);
        }
        if (element.hasDuration()) {
            this.composePeriod(t, "BiologicallyDerivedProduct", "duration", element.getDuration(), -1);
        }
    }

    protected void composeBodyStructure(Turtle.Complex parent, String parentType, String name, BodyStructure element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "BodyStructure", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "BodyStructure", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasActiveElement()) {
            this.composeBoolean(t, "BodyStructure", "active", element.getActiveElement(), -1);
        }
        if (element.hasMorphology()) {
            this.composeCodeableConcept(t, "BodyStructure", "morphology", element.getMorphology(), -1);
        }
        if (element.hasLocation()) {
            this.composeCodeableConcept(t, "BodyStructure", "location", element.getLocation(), -1);
        }
        for (i = 0; i < element.getLocationQualifier().size(); ++i) {
            this.composeCodeableConcept(t, "BodyStructure", "locationQualifier", element.getLocationQualifier().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "BodyStructure", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getImage().size(); ++i) {
            this.composeAttachment(t, "BodyStructure", "image", element.getImage().get(i), i);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "BodyStructure", "patient", element.getPatient(), -1);
        }
    }

    protected void composeBundle(Turtle.Complex parent, String parentType, String name, Bundle element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeResource(t, "Bundle", name, element, index);
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "Bundle", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeEnum(t, "Bundle", "type", element.getTypeElement(), -1);
        }
        if (element.hasTimestampElement()) {
            this.composeInstant(t, "Bundle", "timestamp", element.getTimestampElement(), -1);
        }
        if (element.hasTotalElement()) {
            this.composeUnsignedInt(t, "Bundle", "total", element.getTotalElement(), -1);
        }
        for (i = 0; i < element.getLink().size(); ++i) {
            this.composeBundleBundleLinkComponent(t, "Bundle", "link", element.getLink().get(i), i);
        }
        for (i = 0; i < element.getEntry().size(); ++i) {
            this.composeBundleBundleEntryComponent(t, "Bundle", "entry", element.getEntry().get(i), i);
        }
        if (element.hasSignature()) {
            this.composeSignature(t, "Bundle", "signature", element.getSignature(), -1);
        }
    }

    protected void composeBundleBundleLinkComponent(Turtle.Complex parent, String parentType, String name, Bundle.BundleLinkComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "link", name, element, index);
        if (element.hasRelationElement()) {
            this.composeString(t, "Bundle", "relation", element.getRelationElement(), -1);
        }
        if (element.hasUrlElement()) {
            this.composeUri(t, "Bundle", "url", element.getUrlElement(), -1);
        }
    }

    protected void composeBundleBundleEntryComponent(Turtle.Complex parent, String parentType, String name, Bundle.BundleEntryComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "entry", name, element, index);
        for (int i = 0; i < element.getLink().size(); ++i) {
            this.composeBundleBundleLinkComponent(t, "Bundle", "link", element.getLink().get(i), i);
        }
        if (element.hasFullUrlElement()) {
            this.composeUri(t, "Bundle", "fullUrl", element.getFullUrlElement(), -1);
        }
        if (element.hasResource()) {
            this.composeResource(t, "Bundle", "resource", element.getResource(), -1);
        }
        if (element.hasSearch()) {
            this.composeBundleBundleEntrySearchComponent(t, "Bundle", "search", element.getSearch(), -1);
        }
        if (element.hasRequest()) {
            this.composeBundleBundleEntryRequestComponent(t, "Bundle", "request", element.getRequest(), -1);
        }
        if (element.hasResponse()) {
            this.composeBundleBundleEntryResponseComponent(t, "Bundle", "response", element.getResponse(), -1);
        }
    }

    protected void composeBundleBundleEntrySearchComponent(Turtle.Complex parent, String parentType, String name, Bundle.BundleEntrySearchComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "search", name, element, index);
        if (element.hasModeElement()) {
            this.composeEnum(t, "Bundle", "mode", element.getModeElement(), -1);
        }
        if (element.hasScoreElement()) {
            this.composeDecimal(t, "Bundle", "score", element.getScoreElement(), -1);
        }
    }

    protected void composeBundleBundleEntryRequestComponent(Turtle.Complex parent, String parentType, String name, Bundle.BundleEntryRequestComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "request", name, element, index);
        if (element.hasMethodElement()) {
            this.composeEnum(t, "Bundle", "method", element.getMethodElement(), -1);
        }
        if (element.hasUrlElement()) {
            this.composeUri(t, "Bundle", "url", element.getUrlElement(), -1);
        }
        if (element.hasIfNoneMatchElement()) {
            this.composeString(t, "Bundle", "ifNoneMatch", element.getIfNoneMatchElement(), -1);
        }
        if (element.hasIfModifiedSinceElement()) {
            this.composeInstant(t, "Bundle", "ifModifiedSince", element.getIfModifiedSinceElement(), -1);
        }
        if (element.hasIfMatchElement()) {
            this.composeString(t, "Bundle", "ifMatch", element.getIfMatchElement(), -1);
        }
        if (element.hasIfNoneExistElement()) {
            this.composeString(t, "Bundle", "ifNoneExist", element.getIfNoneExistElement(), -1);
        }
    }

    protected void composeBundleBundleEntryResponseComponent(Turtle.Complex parent, String parentType, String name, Bundle.BundleEntryResponseComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "response", name, element, index);
        if (element.hasStatusElement()) {
            this.composeString(t, "Bundle", "status", element.getStatusElement(), -1);
        }
        if (element.hasLocationElement()) {
            this.composeUri(t, "Bundle", "location", element.getLocationElement(), -1);
        }
        if (element.hasEtagElement()) {
            this.composeString(t, "Bundle", "etag", element.getEtagElement(), -1);
        }
        if (element.hasLastModifiedElement()) {
            this.composeInstant(t, "Bundle", "lastModified", element.getLastModifiedElement(), -1);
        }
        if (element.hasOutcome()) {
            this.composeResource(t, "Bundle", "outcome", element.getOutcome(), -1);
        }
    }

    protected void composeCapabilityStatement(Turtle.Complex parent, String parentType, String name, CapabilityStatement element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "CapabilityStatement", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "CapabilityStatement", "url", element.getUrlElement(), -1);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "CapabilityStatement", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "CapabilityStatement", "name", element.getNameElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "CapabilityStatement", "title", element.getTitleElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "CapabilityStatement", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "CapabilityStatement", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "CapabilityStatement", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "CapabilityStatement", "publisher", element.getPublisherElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeContactDetail(t, "CapabilityStatement", "contact", element.getContact().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "CapabilityStatement", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getUseContext().size(); ++i) {
            this.composeUsageContext(t, "CapabilityStatement", "useContext", element.getUseContext().get(i), i);
        }
        for (i = 0; i < element.getJurisdiction().size(); ++i) {
            this.composeCodeableConcept(t, "CapabilityStatement", "jurisdiction", element.getJurisdiction().get(i), i);
        }
        if (element.hasPurposeElement()) {
            this.composeMarkdown(t, "CapabilityStatement", "purpose", element.getPurposeElement(), -1);
        }
        if (element.hasCopyrightElement()) {
            this.composeMarkdown(t, "CapabilityStatement", "copyright", element.getCopyrightElement(), -1);
        }
        if (element.hasKindElement()) {
            this.composeEnum(t, "CapabilityStatement", "kind", element.getKindElement(), -1);
        }
        for (i = 0; i < element.getInstantiates().size(); ++i) {
            this.composeCanonical(t, "CapabilityStatement", "instantiates", element.getInstantiates().get(i), i);
        }
        for (i = 0; i < element.getImports().size(); ++i) {
            this.composeCanonical(t, "CapabilityStatement", "imports", element.getImports().get(i), i);
        }
        if (element.hasSoftware()) {
            this.composeCapabilityStatementCapabilityStatementSoftwareComponent(t, "CapabilityStatement", "software", element.getSoftware(), -1);
        }
        if (element.hasImplementation()) {
            this.composeCapabilityStatementCapabilityStatementImplementationComponent(t, "CapabilityStatement", "implementation", element.getImplementation(), -1);
        }
        if (element.hasFhirVersionElement()) {
            this.composeEnum(t, "CapabilityStatement", "fhirVersion", element.getFhirVersionElement(), -1);
        }
        for (i = 0; i < element.getFormat().size(); ++i) {
            this.composeCode(t, "CapabilityStatement", "format", element.getFormat().get(i), i);
        }
        for (i = 0; i < element.getPatchFormat().size(); ++i) {
            this.composeCode(t, "CapabilityStatement", "patchFormat", element.getPatchFormat().get(i), i);
        }
        for (i = 0; i < element.getImplementationGuide().size(); ++i) {
            this.composeCanonical(t, "CapabilityStatement", "implementationGuide", element.getImplementationGuide().get(i), i);
        }
        for (i = 0; i < element.getRest().size(); ++i) {
            this.composeCapabilityStatementCapabilityStatementRestComponent(t, "CapabilityStatement", "rest", element.getRest().get(i), i);
        }
        for (i = 0; i < element.getMessaging().size(); ++i) {
            this.composeCapabilityStatementCapabilityStatementMessagingComponent(t, "CapabilityStatement", "messaging", element.getMessaging().get(i), i);
        }
        for (i = 0; i < element.getDocument().size(); ++i) {
            this.composeCapabilityStatementCapabilityStatementDocumentComponent(t, "CapabilityStatement", "document", element.getDocument().get(i), i);
        }
    }

    protected void composeCapabilityStatementCapabilityStatementSoftwareComponent(Turtle.Complex parent, String parentType, String name, CapabilityStatement.CapabilityStatementSoftwareComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "software", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "CapabilityStatement", "name", element.getNameElement(), -1);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "CapabilityStatement", "version", element.getVersionElement(), -1);
        }
        if (element.hasReleaseDateElement()) {
            this.composeDateTime(t, "CapabilityStatement", "releaseDate", element.getReleaseDateElement(), -1);
        }
    }

    protected void composeCapabilityStatementCapabilityStatementImplementationComponent(Turtle.Complex parent, String parentType, String name, CapabilityStatement.CapabilityStatementImplementationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "implementation", name, element, index);
        if (element.hasDescriptionElement()) {
            this.composeString(t, "CapabilityStatement", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasUrlElement()) {
            this.composeUrl(t, "CapabilityStatement", "url", element.getUrlElement(), -1);
        }
        if (element.hasCustodian()) {
            this.composeReference(t, "CapabilityStatement", "custodian", element.getCustodian(), -1);
        }
    }

    protected void composeCapabilityStatementCapabilityStatementRestComponent(Turtle.Complex parent, String parentType, String name, CapabilityStatement.CapabilityStatementRestComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "rest", name, element, index);
        if (element.hasModeElement()) {
            this.composeEnum(t, "CapabilityStatement", "mode", element.getModeElement(), -1);
        }
        if (element.hasDocumentationElement()) {
            this.composeMarkdown(t, "CapabilityStatement", "documentation", element.getDocumentationElement(), -1);
        }
        if (element.hasSecurity()) {
            this.composeCapabilityStatementCapabilityStatementRestSecurityComponent(t, "CapabilityStatement", "security", element.getSecurity(), -1);
        }
        for (i = 0; i < element.getResource().size(); ++i) {
            this.composeCapabilityStatementCapabilityStatementRestResourceComponent(t, "CapabilityStatement", "resource", element.getResource().get(i), i);
        }
        for (i = 0; i < element.getInteraction().size(); ++i) {
            this.composeCapabilityStatementSystemInteractionComponent(t, "CapabilityStatement", "interaction", element.getInteraction().get(i), i);
        }
        for (i = 0; i < element.getSearchParam().size(); ++i) {
            this.composeCapabilityStatementCapabilityStatementRestResourceSearchParamComponent(t, "CapabilityStatement", "searchParam", element.getSearchParam().get(i), i);
        }
        for (i = 0; i < element.getOperation().size(); ++i) {
            this.composeCapabilityStatementCapabilityStatementRestResourceOperationComponent(t, "CapabilityStatement", "operation", element.getOperation().get(i), i);
        }
        for (i = 0; i < element.getCompartment().size(); ++i) {
            this.composeCanonical(t, "CapabilityStatement", "compartment", element.getCompartment().get(i), i);
        }
    }

    protected void composeCapabilityStatementCapabilityStatementRestSecurityComponent(Turtle.Complex parent, String parentType, String name, CapabilityStatement.CapabilityStatementRestSecurityComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "security", name, element, index);
        if (element.hasCorsElement()) {
            this.composeBoolean(t, "CapabilityStatement", "cors", element.getCorsElement(), -1);
        }
        for (int i = 0; i < element.getService().size(); ++i) {
            this.composeCodeableConcept(t, "CapabilityStatement", "service", element.getService().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "CapabilityStatement", "description", element.getDescriptionElement(), -1);
        }
    }

    protected void composeCapabilityStatementCapabilityStatementRestResourceComponent(Turtle.Complex parent, String parentType, String name, CapabilityStatement.CapabilityStatementRestResourceComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "resource", name, element, index);
        if (element.hasTypeElement()) {
            this.composeCode(t, "CapabilityStatement", "type", element.getTypeElement(), -1);
        }
        if (element.hasProfileElement()) {
            this.composeCanonical(t, "CapabilityStatement", "profile", element.getProfileElement(), -1);
        }
        for (i = 0; i < element.getSupportedProfile().size(); ++i) {
            this.composeCanonical(t, "CapabilityStatement", "supportedProfile", element.getSupportedProfile().get(i), i);
        }
        if (element.hasDocumentationElement()) {
            this.composeMarkdown(t, "CapabilityStatement", "documentation", element.getDocumentationElement(), -1);
        }
        for (i = 0; i < element.getInteraction().size(); ++i) {
            this.composeCapabilityStatementResourceInteractionComponent(t, "CapabilityStatement", "interaction", element.getInteraction().get(i), i);
        }
        if (element.hasVersioningElement()) {
            this.composeEnum(t, "CapabilityStatement", "versioning", element.getVersioningElement(), -1);
        }
        if (element.hasReadHistoryElement()) {
            this.composeBoolean(t, "CapabilityStatement", "readHistory", element.getReadHistoryElement(), -1);
        }
        if (element.hasUpdateCreateElement()) {
            this.composeBoolean(t, "CapabilityStatement", "updateCreate", element.getUpdateCreateElement(), -1);
        }
        if (element.hasConditionalCreateElement()) {
            this.composeBoolean(t, "CapabilityStatement", "conditionalCreate", element.getConditionalCreateElement(), -1);
        }
        if (element.hasConditionalReadElement()) {
            this.composeEnum(t, "CapabilityStatement", "conditionalRead", element.getConditionalReadElement(), -1);
        }
        if (element.hasConditionalUpdateElement()) {
            this.composeBoolean(t, "CapabilityStatement", "conditionalUpdate", element.getConditionalUpdateElement(), -1);
        }
        if (element.hasConditionalDeleteElement()) {
            this.composeEnum(t, "CapabilityStatement", "conditionalDelete", element.getConditionalDeleteElement(), -1);
        }
        for (i = 0; i < element.getReferencePolicy().size(); ++i) {
            this.composeEnum(t, "CapabilityStatement", "referencePolicy", element.getReferencePolicy().get(i), i);
        }
        for (i = 0; i < element.getSearchInclude().size(); ++i) {
            this.composeString(t, "CapabilityStatement", "searchInclude", element.getSearchInclude().get(i), i);
        }
        for (i = 0; i < element.getSearchRevInclude().size(); ++i) {
            this.composeString(t, "CapabilityStatement", "searchRevInclude", element.getSearchRevInclude().get(i), i);
        }
        for (i = 0; i < element.getSearchParam().size(); ++i) {
            this.composeCapabilityStatementCapabilityStatementRestResourceSearchParamComponent(t, "CapabilityStatement", "searchParam", element.getSearchParam().get(i), i);
        }
        for (i = 0; i < element.getOperation().size(); ++i) {
            this.composeCapabilityStatementCapabilityStatementRestResourceOperationComponent(t, "CapabilityStatement", "operation", element.getOperation().get(i), i);
        }
    }

    protected void composeCapabilityStatementResourceInteractionComponent(Turtle.Complex parent, String parentType, String name, CapabilityStatement.ResourceInteractionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "interaction", name, element, index);
        if (element.hasCodeElement()) {
            this.composeEnum(t, "CapabilityStatement", "code", element.getCodeElement(), -1);
        }
        if (element.hasDocumentationElement()) {
            this.composeMarkdown(t, "CapabilityStatement", "documentation", element.getDocumentationElement(), -1);
        }
    }

    protected void composeCapabilityStatementCapabilityStatementRestResourceSearchParamComponent(Turtle.Complex parent, String parentType, String name, CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "searchParam", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "CapabilityStatement", "name", element.getNameElement(), -1);
        }
        if (element.hasDefinitionElement()) {
            this.composeCanonical(t, "CapabilityStatement", "definition", element.getDefinitionElement(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeEnum(t, "CapabilityStatement", "type", element.getTypeElement(), -1);
        }
        if (element.hasDocumentationElement()) {
            this.composeMarkdown(t, "CapabilityStatement", "documentation", element.getDocumentationElement(), -1);
        }
    }

    protected void composeCapabilityStatementCapabilityStatementRestResourceOperationComponent(Turtle.Complex parent, String parentType, String name, CapabilityStatement.CapabilityStatementRestResourceOperationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "operation", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "CapabilityStatement", "name", element.getNameElement(), -1);
        }
        if (element.hasDefinitionElement()) {
            this.composeCanonical(t, "CapabilityStatement", "definition", element.getDefinitionElement(), -1);
        }
        if (element.hasDocumentationElement()) {
            this.composeMarkdown(t, "CapabilityStatement", "documentation", element.getDocumentationElement(), -1);
        }
    }

    protected void composeCapabilityStatementSystemInteractionComponent(Turtle.Complex parent, String parentType, String name, CapabilityStatement.SystemInteractionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "interaction", name, element, index);
        if (element.hasCodeElement()) {
            this.composeEnum(t, "CapabilityStatement", "code", element.getCodeElement(), -1);
        }
        if (element.hasDocumentationElement()) {
            this.composeMarkdown(t, "CapabilityStatement", "documentation", element.getDocumentationElement(), -1);
        }
    }

    protected void composeCapabilityStatementCapabilityStatementMessagingComponent(Turtle.Complex parent, String parentType, String name, CapabilityStatement.CapabilityStatementMessagingComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "messaging", name, element, index);
        for (i = 0; i < element.getEndpoint().size(); ++i) {
            this.composeCapabilityStatementCapabilityStatementMessagingEndpointComponent(t, "CapabilityStatement", "endpoint", element.getEndpoint().get(i), i);
        }
        if (element.hasReliableCacheElement()) {
            this.composeUnsignedInt(t, "CapabilityStatement", "reliableCache", element.getReliableCacheElement(), -1);
        }
        if (element.hasDocumentationElement()) {
            this.composeMarkdown(t, "CapabilityStatement", "documentation", element.getDocumentationElement(), -1);
        }
        for (i = 0; i < element.getSupportedMessage().size(); ++i) {
            this.composeCapabilityStatementCapabilityStatementMessagingSupportedMessageComponent(t, "CapabilityStatement", "supportedMessage", element.getSupportedMessage().get(i), i);
        }
    }

    protected void composeCapabilityStatementCapabilityStatementMessagingEndpointComponent(Turtle.Complex parent, String parentType, String name, CapabilityStatement.CapabilityStatementMessagingEndpointComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "endpoint", name, element, index);
        if (element.hasProtocol()) {
            this.composeCoding(t, "CapabilityStatement", "protocol", element.getProtocol(), -1);
        }
        if (element.hasAddressElement()) {
            this.composeUrl(t, "CapabilityStatement", "address", element.getAddressElement(), -1);
        }
    }

    protected void composeCapabilityStatementCapabilityStatementMessagingSupportedMessageComponent(Turtle.Complex parent, String parentType, String name, CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "supportedMessage", name, element, index);
        if (element.hasModeElement()) {
            this.composeEnum(t, "CapabilityStatement", "mode", element.getModeElement(), -1);
        }
        if (element.hasDefinitionElement()) {
            this.composeCanonical(t, "CapabilityStatement", "definition", element.getDefinitionElement(), -1);
        }
    }

    protected void composeCapabilityStatementCapabilityStatementDocumentComponent(Turtle.Complex parent, String parentType, String name, CapabilityStatement.CapabilityStatementDocumentComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "document", name, element, index);
        if (element.hasModeElement()) {
            this.composeEnum(t, "CapabilityStatement", "mode", element.getModeElement(), -1);
        }
        if (element.hasDocumentationElement()) {
            this.composeMarkdown(t, "CapabilityStatement", "documentation", element.getDocumentationElement(), -1);
        }
        if (element.hasProfileElement()) {
            this.composeCanonical(t, "CapabilityStatement", "profile", element.getProfileElement(), -1);
        }
    }

    protected void composeCarePlan(Turtle.Complex parent, String parentType, String name, CarePlan element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "CarePlan", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "CarePlan", "identifier", element.getIdentifier().get(i), i);
        }
        for (i = 0; i < element.getInstantiatesCanonical().size(); ++i) {
            this.composeCanonical(t, "CarePlan", "instantiatesCanonical", element.getInstantiatesCanonical().get(i), i);
        }
        for (i = 0; i < element.getInstantiatesUri().size(); ++i) {
            this.composeUri(t, "CarePlan", "instantiatesUri", element.getInstantiatesUri().get(i), i);
        }
        for (i = 0; i < element.getBasedOn().size(); ++i) {
            this.composeReference(t, "CarePlan", "basedOn", element.getBasedOn().get(i), i);
        }
        for (i = 0; i < element.getReplaces().size(); ++i) {
            this.composeReference(t, "CarePlan", "replaces", element.getReplaces().get(i), i);
        }
        for (i = 0; i < element.getPartOf().size(); ++i) {
            this.composeReference(t, "CarePlan", "partOf", element.getPartOf().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "CarePlan", "status", element.getStatusElement(), -1);
        }
        if (element.hasIntentElement()) {
            this.composeEnum(t, "CarePlan", "intent", element.getIntentElement(), -1);
        }
        for (i = 0; i < element.getCategory().size(); ++i) {
            this.composeCodeableConcept(t, "CarePlan", "category", element.getCategory().get(i), i);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "CarePlan", "title", element.getTitleElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "CarePlan", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "CarePlan", "subject", element.getSubject(), -1);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "CarePlan", "encounter", element.getEncounter(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "CarePlan", "period", element.getPeriod(), -1);
        }
        if (element.hasCreatedElement()) {
            this.composeDateTime(t, "CarePlan", "created", element.getCreatedElement(), -1);
        }
        if (element.hasAuthor()) {
            this.composeReference(t, "CarePlan", "author", element.getAuthor(), -1);
        }
        for (i = 0; i < element.getContributor().size(); ++i) {
            this.composeReference(t, "CarePlan", "contributor", element.getContributor().get(i), i);
        }
        for (i = 0; i < element.getCareTeam().size(); ++i) {
            this.composeReference(t, "CarePlan", "careTeam", element.getCareTeam().get(i), i);
        }
        for (i = 0; i < element.getAddresses().size(); ++i) {
            this.composeReference(t, "CarePlan", "addresses", element.getAddresses().get(i), i);
        }
        for (i = 0; i < element.getSupportingInfo().size(); ++i) {
            this.composeReference(t, "CarePlan", "supportingInfo", element.getSupportingInfo().get(i), i);
        }
        for (i = 0; i < element.getGoal().size(); ++i) {
            this.composeReference(t, "CarePlan", "goal", element.getGoal().get(i), i);
        }
        for (i = 0; i < element.getActivity().size(); ++i) {
            this.composeCarePlanCarePlanActivityComponent(t, "CarePlan", "activity", element.getActivity().get(i), i);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "CarePlan", "note", element.getNote().get(i), i);
        }
    }

    protected void composeCarePlanCarePlanActivityComponent(Turtle.Complex parent, String parentType, String name, CarePlan.CarePlanActivityComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "activity", name, element, index);
        for (i = 0; i < element.getOutcomeCodeableConcept().size(); ++i) {
            this.composeCodeableConcept(t, "CarePlan", "outcomeCodeableConcept", element.getOutcomeCodeableConcept().get(i), i);
        }
        for (i = 0; i < element.getOutcomeReference().size(); ++i) {
            this.composeReference(t, "CarePlan", "outcomeReference", element.getOutcomeReference().get(i), i);
        }
        for (i = 0; i < element.getProgress().size(); ++i) {
            this.composeAnnotation(t, "CarePlan", "progress", element.getProgress().get(i), i);
        }
        if (element.hasReference()) {
            this.composeReference(t, "CarePlan", "reference", element.getReference(), -1);
        }
        if (element.hasDetail()) {
            this.composeCarePlanCarePlanActivityDetailComponent(t, "CarePlan", "detail", element.getDetail(), -1);
        }
    }

    protected void composeCarePlanCarePlanActivityDetailComponent(Turtle.Complex parent, String parentType, String name, CarePlan.CarePlanActivityDetailComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "detail", name, element, index);
        if (element.hasKindElement()) {
            this.composeEnum(t, "CarePlan", "kind", element.getKindElement(), -1);
        }
        for (i = 0; i < element.getInstantiatesCanonical().size(); ++i) {
            this.composeCanonical(t, "CarePlan", "instantiatesCanonical", element.getInstantiatesCanonical().get(i), i);
        }
        for (i = 0; i < element.getInstantiatesUri().size(); ++i) {
            this.composeUri(t, "CarePlan", "instantiatesUri", element.getInstantiatesUri().get(i), i);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "CarePlan", "code", element.getCode(), -1);
        }
        for (i = 0; i < element.getReasonCode().size(); ++i) {
            this.composeCodeableConcept(t, "CarePlan", "reasonCode", element.getReasonCode().get(i), i);
        }
        for (i = 0; i < element.getReasonReference().size(); ++i) {
            this.composeReference(t, "CarePlan", "reasonReference", element.getReasonReference().get(i), i);
        }
        for (i = 0; i < element.getGoal().size(); ++i) {
            this.composeReference(t, "CarePlan", "goal", element.getGoal().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "CarePlan", "status", element.getStatusElement(), -1);
        }
        if (element.hasStatusReason()) {
            this.composeCodeableConcept(t, "CarePlan", "statusReason", element.getStatusReason(), -1);
        }
        if (element.hasDoNotPerformElement()) {
            this.composeBoolean(t, "CarePlan", "doNotPerform", element.getDoNotPerformElement(), -1);
        }
        if (element.hasScheduled()) {
            this.composeType(t, "CarePlan", "scheduled", element.getScheduled(), -1);
        }
        if (element.hasLocation()) {
            this.composeReference(t, "CarePlan", "location", element.getLocation(), -1);
        }
        for (i = 0; i < element.getPerformer().size(); ++i) {
            this.composeReference(t, "CarePlan", "performer", element.getPerformer().get(i), i);
        }
        if (element.hasProduct()) {
            this.composeType(t, "CarePlan", "product", element.getProduct(), -1);
        }
        if (element.hasDailyAmount()) {
            this.composeQuantity(t, "CarePlan", "dailyAmount", element.getDailyAmount(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "CarePlan", "quantity", element.getQuantity(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "CarePlan", "description", element.getDescriptionElement(), -1);
        }
    }

    protected void composeCareTeam(Turtle.Complex parent, String parentType, String name, CareTeam element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "CareTeam", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "CareTeam", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "CareTeam", "status", element.getStatusElement(), -1);
        }
        for (i = 0; i < element.getCategory().size(); ++i) {
            this.composeCodeableConcept(t, "CareTeam", "category", element.getCategory().get(i), i);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "CareTeam", "name", element.getNameElement(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "CareTeam", "subject", element.getSubject(), -1);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "CareTeam", "encounter", element.getEncounter(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "CareTeam", "period", element.getPeriod(), -1);
        }
        for (i = 0; i < element.getParticipant().size(); ++i) {
            this.composeCareTeamCareTeamParticipantComponent(t, "CareTeam", "participant", element.getParticipant().get(i), i);
        }
        for (i = 0; i < element.getReasonCode().size(); ++i) {
            this.composeCodeableConcept(t, "CareTeam", "reasonCode", element.getReasonCode().get(i), i);
        }
        for (i = 0; i < element.getReasonReference().size(); ++i) {
            this.composeReference(t, "CareTeam", "reasonReference", element.getReasonReference().get(i), i);
        }
        for (i = 0; i < element.getManagingOrganization().size(); ++i) {
            this.composeReference(t, "CareTeam", "managingOrganization", element.getManagingOrganization().get(i), i);
        }
        for (i = 0; i < element.getTelecom().size(); ++i) {
            this.composeContactPoint(t, "CareTeam", "telecom", element.getTelecom().get(i), i);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "CareTeam", "note", element.getNote().get(i), i);
        }
    }

    protected void composeCareTeamCareTeamParticipantComponent(Turtle.Complex parent, String parentType, String name, CareTeam.CareTeamParticipantComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "participant", name, element, index);
        for (int i = 0; i < element.getRole().size(); ++i) {
            this.composeCodeableConcept(t, "CareTeam", "role", element.getRole().get(i), i);
        }
        if (element.hasMember()) {
            this.composeReference(t, "CareTeam", "member", element.getMember(), -1);
        }
        if (element.hasOnBehalfOf()) {
            this.composeReference(t, "CareTeam", "onBehalfOf", element.getOnBehalfOf(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "CareTeam", "period", element.getPeriod(), -1);
        }
    }

    protected void composeCatalogEntry(Turtle.Complex parent, String parentType, String name, CatalogEntry element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "CatalogEntry", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "CatalogEntry", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "CatalogEntry", "type", element.getType(), -1);
        }
        if (element.hasOrderableElement()) {
            this.composeBoolean(t, "CatalogEntry", "orderable", element.getOrderableElement(), -1);
        }
        if (element.hasReferencedItem()) {
            this.composeReference(t, "CatalogEntry", "referencedItem", element.getReferencedItem(), -1);
        }
        for (i = 0; i < element.getAdditionalIdentifier().size(); ++i) {
            this.composeIdentifier(t, "CatalogEntry", "additionalIdentifier", element.getAdditionalIdentifier().get(i), i);
        }
        for (i = 0; i < element.getClassification().size(); ++i) {
            this.composeCodeableConcept(t, "CatalogEntry", "classification", element.getClassification().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "CatalogEntry", "status", element.getStatusElement(), -1);
        }
        if (element.hasValidityPeriod()) {
            this.composePeriod(t, "CatalogEntry", "validityPeriod", element.getValidityPeriod(), -1);
        }
        if (element.hasValidToElement()) {
            this.composeDateTime(t, "CatalogEntry", "validTo", element.getValidToElement(), -1);
        }
        if (element.hasLastUpdatedElement()) {
            this.composeDateTime(t, "CatalogEntry", "lastUpdated", element.getLastUpdatedElement(), -1);
        }
        for (i = 0; i < element.getAdditionalCharacteristic().size(); ++i) {
            this.composeCodeableConcept(t, "CatalogEntry", "additionalCharacteristic", element.getAdditionalCharacteristic().get(i), i);
        }
        for (i = 0; i < element.getAdditionalClassification().size(); ++i) {
            this.composeCodeableConcept(t, "CatalogEntry", "additionalClassification", element.getAdditionalClassification().get(i), i);
        }
        for (i = 0; i < element.getRelatedEntry().size(); ++i) {
            this.composeCatalogEntryCatalogEntryRelatedEntryComponent(t, "CatalogEntry", "relatedEntry", element.getRelatedEntry().get(i), i);
        }
    }

    protected void composeCatalogEntryCatalogEntryRelatedEntryComponent(Turtle.Complex parent, String parentType, String name, CatalogEntry.CatalogEntryRelatedEntryComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "relatedEntry", name, element, index);
        if (element.hasRelationtypeElement()) {
            this.composeEnum(t, "CatalogEntry", "relationtype", element.getRelationtypeElement(), -1);
        }
        if (element.hasItem()) {
            this.composeReference(t, "CatalogEntry", "item", element.getItem(), -1);
        }
    }

    protected void composeChargeItem(Turtle.Complex parent, String parentType, String name, ChargeItem element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "ChargeItem", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "ChargeItem", "identifier", element.getIdentifier().get(i), i);
        }
        for (i = 0; i < element.getDefinitionUri().size(); ++i) {
            this.composeUri(t, "ChargeItem", "definitionUri", element.getDefinitionUri().get(i), i);
        }
        for (i = 0; i < element.getDefinitionCanonical().size(); ++i) {
            this.composeCanonical(t, "ChargeItem", "definitionCanonical", element.getDefinitionCanonical().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "ChargeItem", "status", element.getStatusElement(), -1);
        }
        for (i = 0; i < element.getPartOf().size(); ++i) {
            this.composeReference(t, "ChargeItem", "partOf", element.getPartOf().get(i), i);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "ChargeItem", "code", element.getCode(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "ChargeItem", "subject", element.getSubject(), -1);
        }
        if (element.hasContext()) {
            this.composeReference(t, "ChargeItem", "context", element.getContext(), -1);
        }
        if (element.hasOccurrence()) {
            this.composeType(t, "ChargeItem", "occurrence", element.getOccurrence(), -1);
        }
        for (i = 0; i < element.getPerformer().size(); ++i) {
            this.composeChargeItemChargeItemPerformerComponent(t, "ChargeItem", "performer", element.getPerformer().get(i), i);
        }
        if (element.hasPerformingOrganization()) {
            this.composeReference(t, "ChargeItem", "performingOrganization", element.getPerformingOrganization(), -1);
        }
        if (element.hasRequestingOrganization()) {
            this.composeReference(t, "ChargeItem", "requestingOrganization", element.getRequestingOrganization(), -1);
        }
        if (element.hasCostCenter()) {
            this.composeReference(t, "ChargeItem", "costCenter", element.getCostCenter(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "ChargeItem", "quantity", element.getQuantity(), -1);
        }
        for (i = 0; i < element.getBodysite().size(); ++i) {
            this.composeCodeableConcept(t, "ChargeItem", "bodysite", element.getBodysite().get(i), i);
        }
        if (element.hasFactorOverrideElement()) {
            this.composeDecimal(t, "ChargeItem", "factorOverride", element.getFactorOverrideElement(), -1);
        }
        if (element.hasPriceOverride()) {
            this.composeMoney(t, "ChargeItem", "priceOverride", element.getPriceOverride(), -1);
        }
        if (element.hasOverrideReasonElement()) {
            this.composeString(t, "ChargeItem", "overrideReason", element.getOverrideReasonElement(), -1);
        }
        if (element.hasEnterer()) {
            this.composeReference(t, "ChargeItem", "enterer", element.getEnterer(), -1);
        }
        if (element.hasEnteredDateElement()) {
            this.composeDateTime(t, "ChargeItem", "enteredDate", element.getEnteredDateElement(), -1);
        }
        for (i = 0; i < element.getReason().size(); ++i) {
            this.composeCodeableConcept(t, "ChargeItem", "reason", element.getReason().get(i), i);
        }
        for (i = 0; i < element.getService().size(); ++i) {
            this.composeReference(t, "ChargeItem", "service", element.getService().get(i), i);
        }
        if (element.hasProduct()) {
            this.composeType(t, "ChargeItem", "product", element.getProduct(), -1);
        }
        for (i = 0; i < element.getAccount().size(); ++i) {
            this.composeReference(t, "ChargeItem", "account", element.getAccount().get(i), i);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "ChargeItem", "note", element.getNote().get(i), i);
        }
        for (i = 0; i < element.getSupportingInformation().size(); ++i) {
            this.composeReference(t, "ChargeItem", "supportingInformation", element.getSupportingInformation().get(i), i);
        }
    }

    protected void composeChargeItemChargeItemPerformerComponent(Turtle.Complex parent, String parentType, String name, ChargeItem.ChargeItemPerformerComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "performer", name, element, index);
        if (element.hasFunction()) {
            this.composeCodeableConcept(t, "ChargeItem", "function", element.getFunction(), -1);
        }
        if (element.hasActor()) {
            this.composeReference(t, "ChargeItem", "actor", element.getActor(), -1);
        }
    }

    protected void composeChargeItemDefinition(Turtle.Complex parent, String parentType, String name, ChargeItemDefinition element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "ChargeItemDefinition", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "ChargeItemDefinition", "url", element.getUrlElement(), -1);
        }
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "ChargeItemDefinition", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "ChargeItemDefinition", "version", element.getVersionElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "ChargeItemDefinition", "title", element.getTitleElement(), -1);
        }
        for (i = 0; i < element.getDerivedFromUri().size(); ++i) {
            this.composeUri(t, "ChargeItemDefinition", "derivedFromUri", element.getDerivedFromUri().get(i), i);
        }
        for (i = 0; i < element.getPartOf().size(); ++i) {
            this.composeCanonical(t, "ChargeItemDefinition", "partOf", element.getPartOf().get(i), i);
        }
        for (i = 0; i < element.getReplaces().size(); ++i) {
            this.composeCanonical(t, "ChargeItemDefinition", "replaces", element.getReplaces().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "ChargeItemDefinition", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "ChargeItemDefinition", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "ChargeItemDefinition", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "ChargeItemDefinition", "publisher", element.getPublisherElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeContactDetail(t, "ChargeItemDefinition", "contact", element.getContact().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "ChargeItemDefinition", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getUseContext().size(); ++i) {
            this.composeUsageContext(t, "ChargeItemDefinition", "useContext", element.getUseContext().get(i), i);
        }
        for (i = 0; i < element.getJurisdiction().size(); ++i) {
            this.composeCodeableConcept(t, "ChargeItemDefinition", "jurisdiction", element.getJurisdiction().get(i), i);
        }
        if (element.hasCopyrightElement()) {
            this.composeMarkdown(t, "ChargeItemDefinition", "copyright", element.getCopyrightElement(), -1);
        }
        if (element.hasApprovalDateElement()) {
            this.composeDate(t, "ChargeItemDefinition", "approvalDate", element.getApprovalDateElement(), -1);
        }
        if (element.hasLastReviewDateElement()) {
            this.composeDate(t, "ChargeItemDefinition", "lastReviewDate", element.getLastReviewDateElement(), -1);
        }
        if (element.hasEffectivePeriod()) {
            this.composePeriod(t, "ChargeItemDefinition", "effectivePeriod", element.getEffectivePeriod(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "ChargeItemDefinition", "code", element.getCode(), -1);
        }
        for (i = 0; i < element.getInstance().size(); ++i) {
            this.composeReference(t, "ChargeItemDefinition", "instance", element.getInstance().get(i), i);
        }
        for (i = 0; i < element.getApplicability().size(); ++i) {
            this.composeChargeItemDefinitionChargeItemDefinitionApplicabilityComponent(t, "ChargeItemDefinition", "applicability", element.getApplicability().get(i), i);
        }
        for (i = 0; i < element.getPropertyGroup().size(); ++i) {
            this.composeChargeItemDefinitionChargeItemDefinitionPropertyGroupComponent(t, "ChargeItemDefinition", "propertyGroup", element.getPropertyGroup().get(i), i);
        }
    }

    protected void composeChargeItemDefinitionChargeItemDefinitionApplicabilityComponent(Turtle.Complex parent, String parentType, String name, ChargeItemDefinition.ChargeItemDefinitionApplicabilityComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "applicability", name, element, index);
        if (element.hasDescriptionElement()) {
            this.composeString(t, "ChargeItemDefinition", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasLanguageElement()) {
            this.composeString(t, "ChargeItemDefinition", "language", element.getLanguageElement(), -1);
        }
        if (element.hasExpressionElement()) {
            this.composeString(t, "ChargeItemDefinition", "expression", element.getExpressionElement(), -1);
        }
    }

    protected void composeChargeItemDefinitionChargeItemDefinitionPropertyGroupComponent(Turtle.Complex parent, String parentType, String name, ChargeItemDefinition.ChargeItemDefinitionPropertyGroupComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "propertyGroup", name, element, index);
        for (i = 0; i < element.getApplicability().size(); ++i) {
            this.composeChargeItemDefinitionChargeItemDefinitionApplicabilityComponent(t, "ChargeItemDefinition", "applicability", element.getApplicability().get(i), i);
        }
        for (i = 0; i < element.getPriceComponent().size(); ++i) {
            this.composeChargeItemDefinitionChargeItemDefinitionPropertyGroupPriceComponentComponent(t, "ChargeItemDefinition", "priceComponent", element.getPriceComponent().get(i), i);
        }
    }

    protected void composeChargeItemDefinitionChargeItemDefinitionPropertyGroupPriceComponentComponent(Turtle.Complex parent, String parentType, String name, ChargeItemDefinition.ChargeItemDefinitionPropertyGroupPriceComponentComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "priceComponent", name, element, index);
        if (element.hasTypeElement()) {
            this.composeEnum(t, "ChargeItemDefinition", "type", element.getTypeElement(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "ChargeItemDefinition", "code", element.getCode(), -1);
        }
        if (element.hasFactorElement()) {
            this.composeDecimal(t, "ChargeItemDefinition", "factor", element.getFactorElement(), -1);
        }
        if (element.hasAmount()) {
            this.composeMoney(t, "ChargeItemDefinition", "amount", element.getAmount(), -1);
        }
    }

    protected void composeClaim(Turtle.Complex parent, String parentType, String name, Claim element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Claim", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Claim", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Claim", "status", element.getStatusElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "Claim", "type", element.getType(), -1);
        }
        if (element.hasSubType()) {
            this.composeCodeableConcept(t, "Claim", "subType", element.getSubType(), -1);
        }
        if (element.hasUseElement()) {
            this.composeEnum(t, "Claim", "use", element.getUseElement(), -1);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "Claim", "patient", element.getPatient(), -1);
        }
        if (element.hasBillablePeriod()) {
            this.composePeriod(t, "Claim", "billablePeriod", element.getBillablePeriod(), -1);
        }
        if (element.hasCreatedElement()) {
            this.composeDateTime(t, "Claim", "created", element.getCreatedElement(), -1);
        }
        if (element.hasEnterer()) {
            this.composeReference(t, "Claim", "enterer", element.getEnterer(), -1);
        }
        if (element.hasInsurer()) {
            this.composeReference(t, "Claim", "insurer", element.getInsurer(), -1);
        }
        if (element.hasProvider()) {
            this.composeReference(t, "Claim", "provider", element.getProvider(), -1);
        }
        if (element.hasPriority()) {
            this.composeCodeableConcept(t, "Claim", "priority", element.getPriority(), -1);
        }
        if (element.hasFundsReserve()) {
            this.composeCodeableConcept(t, "Claim", "fundsReserve", element.getFundsReserve(), -1);
        }
        for (i = 0; i < element.getRelated().size(); ++i) {
            this.composeClaimRelatedClaimComponent(t, "Claim", "related", element.getRelated().get(i), i);
        }
        if (element.hasPrescription()) {
            this.composeReference(t, "Claim", "prescription", element.getPrescription(), -1);
        }
        if (element.hasOriginalPrescription()) {
            this.composeReference(t, "Claim", "originalPrescription", element.getOriginalPrescription(), -1);
        }
        if (element.hasPayee()) {
            this.composeClaimPayeeComponent(t, "Claim", "payee", element.getPayee(), -1);
        }
        if (element.hasReferral()) {
            this.composeReference(t, "Claim", "referral", element.getReferral(), -1);
        }
        if (element.hasFacility()) {
            this.composeReference(t, "Claim", "facility", element.getFacility(), -1);
        }
        for (i = 0; i < element.getCareTeam().size(); ++i) {
            this.composeClaimCareTeamComponent(t, "Claim", "careTeam", element.getCareTeam().get(i), i);
        }
        for (i = 0; i < element.getSupportingInfo().size(); ++i) {
            this.composeClaimSupportingInformationComponent(t, "Claim", "supportingInfo", element.getSupportingInfo().get(i), i);
        }
        for (i = 0; i < element.getDiagnosis().size(); ++i) {
            this.composeClaimDiagnosisComponent(t, "Claim", "diagnosis", element.getDiagnosis().get(i), i);
        }
        for (i = 0; i < element.getProcedure().size(); ++i) {
            this.composeClaimProcedureComponent(t, "Claim", "procedure", element.getProcedure().get(i), i);
        }
        for (i = 0; i < element.getInsurance().size(); ++i) {
            this.composeClaimInsuranceComponent(t, "Claim", "insurance", element.getInsurance().get(i), i);
        }
        if (element.hasAccident()) {
            this.composeClaimAccidentComponent(t, "Claim", "accident", element.getAccident(), -1);
        }
        for (i = 0; i < element.getItem().size(); ++i) {
            this.composeClaimItemComponent(t, "Claim", "item", element.getItem().get(i), i);
        }
        if (element.hasTotal()) {
            this.composeMoney(t, "Claim", "total", element.getTotal(), -1);
        }
    }

    protected void composeClaimRelatedClaimComponent(Turtle.Complex parent, String parentType, String name, Claim.RelatedClaimComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "related", name, element, index);
        if (element.hasClaim()) {
            this.composeReference(t, "Claim", "claim", element.getClaim(), -1);
        }
        if (element.hasRelationship()) {
            this.composeCodeableConcept(t, "Claim", "relationship", element.getRelationship(), -1);
        }
        if (element.hasReference()) {
            this.composeIdentifier(t, "Claim", "reference", element.getReference(), -1);
        }
    }

    protected void composeClaimPayeeComponent(Turtle.Complex parent, String parentType, String name, Claim.PayeeComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "payee", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "Claim", "type", element.getType(), -1);
        }
        if (element.hasParty()) {
            this.composeReference(t, "Claim", "party", element.getParty(), -1);
        }
    }

    protected void composeClaimCareTeamComponent(Turtle.Complex parent, String parentType, String name, Claim.CareTeamComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "careTeam", name, element, index);
        if (element.hasSequenceElement()) {
            this.composePositiveInt(t, "Claim", "sequence", element.getSequenceElement(), -1);
        }
        if (element.hasProvider()) {
            this.composeReference(t, "Claim", "provider", element.getProvider(), -1);
        }
        if (element.hasResponsibleElement()) {
            this.composeBoolean(t, "Claim", "responsible", element.getResponsibleElement(), -1);
        }
        if (element.hasRole()) {
            this.composeCodeableConcept(t, "Claim", "role", element.getRole(), -1);
        }
        if (element.hasQualification()) {
            this.composeCodeableConcept(t, "Claim", "qualification", element.getQualification(), -1);
        }
    }

    protected void composeClaimSupportingInformationComponent(Turtle.Complex parent, String parentType, String name, Claim.SupportingInformationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "supportingInfo", name, element, index);
        if (element.hasSequenceElement()) {
            this.composePositiveInt(t, "Claim", "sequence", element.getSequenceElement(), -1);
        }
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "Claim", "category", element.getCategory(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "Claim", "code", element.getCode(), -1);
        }
        if (element.hasTiming()) {
            this.composeType(t, "Claim", "timing", element.getTiming(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "Claim", "value", element.getValue(), -1);
        }
        if (element.hasReason()) {
            this.composeCodeableConcept(t, "Claim", "reason", element.getReason(), -1);
        }
    }

    protected void composeClaimDiagnosisComponent(Turtle.Complex parent, String parentType, String name, Claim.DiagnosisComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "diagnosis", name, element, index);
        if (element.hasSequenceElement()) {
            this.composePositiveInt(t, "Claim", "sequence", element.getSequenceElement(), -1);
        }
        if (element.hasDiagnosis()) {
            this.composeType(t, "Claim", "diagnosis", element.getDiagnosis(), -1);
        }
        for (int i = 0; i < element.getType().size(); ++i) {
            this.composeCodeableConcept(t, "Claim", "type", element.getType().get(i), i);
        }
        if (element.hasOnAdmission()) {
            this.composeCodeableConcept(t, "Claim", "onAdmission", element.getOnAdmission(), -1);
        }
        if (element.hasPackageCode()) {
            this.composeCodeableConcept(t, "Claim", "packageCode", element.getPackageCode(), -1);
        }
    }

    protected void composeClaimProcedureComponent(Turtle.Complex parent, String parentType, String name, Claim.ProcedureComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "procedure", name, element, index);
        if (element.hasSequenceElement()) {
            this.composePositiveInt(t, "Claim", "sequence", element.getSequenceElement(), -1);
        }
        for (i = 0; i < element.getType().size(); ++i) {
            this.composeCodeableConcept(t, "Claim", "type", element.getType().get(i), i);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "Claim", "date", element.getDateElement(), -1);
        }
        if (element.hasProcedure()) {
            this.composeType(t, "Claim", "procedure", element.getProcedure(), -1);
        }
        for (i = 0; i < element.getUdi().size(); ++i) {
            this.composeReference(t, "Claim", "udi", element.getUdi().get(i), i);
        }
    }

    protected void composeClaimInsuranceComponent(Turtle.Complex parent, String parentType, String name, Claim.InsuranceComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "insurance", name, element, index);
        if (element.hasSequenceElement()) {
            this.composePositiveInt(t, "Claim", "sequence", element.getSequenceElement(), -1);
        }
        if (element.hasFocalElement()) {
            this.composeBoolean(t, "Claim", "focal", element.getFocalElement(), -1);
        }
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "Claim", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasCoverage()) {
            this.composeReference(t, "Claim", "coverage", element.getCoverage(), -1);
        }
        if (element.hasBusinessArrangementElement()) {
            this.composeString(t, "Claim", "businessArrangement", element.getBusinessArrangementElement(), -1);
        }
        for (int i = 0; i < element.getPreAuthRef().size(); ++i) {
            this.composeString(t, "Claim", "preAuthRef", element.getPreAuthRef().get(i), i);
        }
        if (element.hasClaimResponse()) {
            this.composeReference(t, "Claim", "claimResponse", element.getClaimResponse(), -1);
        }
    }

    protected void composeClaimAccidentComponent(Turtle.Complex parent, String parentType, String name, Claim.AccidentComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "accident", name, element, index);
        if (element.hasDateElement()) {
            this.composeDate(t, "Claim", "date", element.getDateElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "Claim", "type", element.getType(), -1);
        }
        if (element.hasLocation()) {
            this.composeType(t, "Claim", "location", element.getLocation(), -1);
        }
    }

    protected void composeClaimItemComponent(Turtle.Complex parent, String parentType, String name, Claim.ItemComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "item", name, element, index);
        if (element.hasSequenceElement()) {
            this.composePositiveInt(t, "Claim", "sequence", element.getSequenceElement(), -1);
        }
        for (i = 0; i < element.getCareTeamSequence().size(); ++i) {
            this.composePositiveInt(t, "Claim", "careTeamSequence", element.getCareTeamSequence().get(i), i);
        }
        for (i = 0; i < element.getDiagnosisSequence().size(); ++i) {
            this.composePositiveInt(t, "Claim", "diagnosisSequence", element.getDiagnosisSequence().get(i), i);
        }
        for (i = 0; i < element.getProcedureSequence().size(); ++i) {
            this.composePositiveInt(t, "Claim", "procedureSequence", element.getProcedureSequence().get(i), i);
        }
        for (i = 0; i < element.getInformationSequence().size(); ++i) {
            this.composePositiveInt(t, "Claim", "informationSequence", element.getInformationSequence().get(i), i);
        }
        if (element.hasRevenue()) {
            this.composeCodeableConcept(t, "Claim", "revenue", element.getRevenue(), -1);
        }
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "Claim", "category", element.getCategory(), -1);
        }
        if (element.hasProductOrService()) {
            this.composeCodeableConcept(t, "Claim", "productOrService", element.getProductOrService(), -1);
        }
        for (i = 0; i < element.getModifier().size(); ++i) {
            this.composeCodeableConcept(t, "Claim", "modifier", element.getModifier().get(i), i);
        }
        for (i = 0; i < element.getProgramCode().size(); ++i) {
            this.composeCodeableConcept(t, "Claim", "programCode", element.getProgramCode().get(i), i);
        }
        if (element.hasServiced()) {
            this.composeType(t, "Claim", "serviced", element.getServiced(), -1);
        }
        if (element.hasLocation()) {
            this.composeType(t, "Claim", "location", element.getLocation(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "Claim", "quantity", element.getQuantity(), -1);
        }
        if (element.hasUnitPrice()) {
            this.composeMoney(t, "Claim", "unitPrice", element.getUnitPrice(), -1);
        }
        if (element.hasFactorElement()) {
            this.composeDecimal(t, "Claim", "factor", element.getFactorElement(), -1);
        }
        if (element.hasNet()) {
            this.composeMoney(t, "Claim", "net", element.getNet(), -1);
        }
        for (i = 0; i < element.getUdi().size(); ++i) {
            this.composeReference(t, "Claim", "udi", element.getUdi().get(i), i);
        }
        if (element.hasBodySite()) {
            this.composeCodeableConcept(t, "Claim", "bodySite", element.getBodySite(), -1);
        }
        for (i = 0; i < element.getSubSite().size(); ++i) {
            this.composeCodeableConcept(t, "Claim", "subSite", element.getSubSite().get(i), i);
        }
        for (i = 0; i < element.getEncounter().size(); ++i) {
            this.composeReference(t, "Claim", "encounter", element.getEncounter().get(i), i);
        }
        for (i = 0; i < element.getDetail().size(); ++i) {
            this.composeClaimDetailComponent(t, "Claim", "detail", element.getDetail().get(i), i);
        }
    }

    protected void composeClaimDetailComponent(Turtle.Complex parent, String parentType, String name, Claim.DetailComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "detail", name, element, index);
        if (element.hasSequenceElement()) {
            this.composePositiveInt(t, "Claim", "sequence", element.getSequenceElement(), -1);
        }
        if (element.hasRevenue()) {
            this.composeCodeableConcept(t, "Claim", "revenue", element.getRevenue(), -1);
        }
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "Claim", "category", element.getCategory(), -1);
        }
        if (element.hasProductOrService()) {
            this.composeCodeableConcept(t, "Claim", "productOrService", element.getProductOrService(), -1);
        }
        for (i = 0; i < element.getModifier().size(); ++i) {
            this.composeCodeableConcept(t, "Claim", "modifier", element.getModifier().get(i), i);
        }
        for (i = 0; i < element.getProgramCode().size(); ++i) {
            this.composeCodeableConcept(t, "Claim", "programCode", element.getProgramCode().get(i), i);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "Claim", "quantity", element.getQuantity(), -1);
        }
        if (element.hasUnitPrice()) {
            this.composeMoney(t, "Claim", "unitPrice", element.getUnitPrice(), -1);
        }
        if (element.hasFactorElement()) {
            this.composeDecimal(t, "Claim", "factor", element.getFactorElement(), -1);
        }
        if (element.hasNet()) {
            this.composeMoney(t, "Claim", "net", element.getNet(), -1);
        }
        for (i = 0; i < element.getUdi().size(); ++i) {
            this.composeReference(t, "Claim", "udi", element.getUdi().get(i), i);
        }
        for (i = 0; i < element.getSubDetail().size(); ++i) {
            this.composeClaimSubDetailComponent(t, "Claim", "subDetail", element.getSubDetail().get(i), i);
        }
    }

    protected void composeClaimSubDetailComponent(Turtle.Complex parent, String parentType, String name, Claim.SubDetailComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "subDetail", name, element, index);
        if (element.hasSequenceElement()) {
            this.composePositiveInt(t, "Claim", "sequence", element.getSequenceElement(), -1);
        }
        if (element.hasRevenue()) {
            this.composeCodeableConcept(t, "Claim", "revenue", element.getRevenue(), -1);
        }
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "Claim", "category", element.getCategory(), -1);
        }
        if (element.hasProductOrService()) {
            this.composeCodeableConcept(t, "Claim", "productOrService", element.getProductOrService(), -1);
        }
        for (i = 0; i < element.getModifier().size(); ++i) {
            this.composeCodeableConcept(t, "Claim", "modifier", element.getModifier().get(i), i);
        }
        for (i = 0; i < element.getProgramCode().size(); ++i) {
            this.composeCodeableConcept(t, "Claim", "programCode", element.getProgramCode().get(i), i);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "Claim", "quantity", element.getQuantity(), -1);
        }
        if (element.hasUnitPrice()) {
            this.composeMoney(t, "Claim", "unitPrice", element.getUnitPrice(), -1);
        }
        if (element.hasFactorElement()) {
            this.composeDecimal(t, "Claim", "factor", element.getFactorElement(), -1);
        }
        if (element.hasNet()) {
            this.composeMoney(t, "Claim", "net", element.getNet(), -1);
        }
        for (i = 0; i < element.getUdi().size(); ++i) {
            this.composeReference(t, "Claim", "udi", element.getUdi().get(i), i);
        }
    }

    protected void composeClaimResponse(Turtle.Complex parent, String parentType, String name, ClaimResponse element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "ClaimResponse", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "ClaimResponse", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "ClaimResponse", "status", element.getStatusElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "ClaimResponse", "type", element.getType(), -1);
        }
        if (element.hasSubType()) {
            this.composeCodeableConcept(t, "ClaimResponse", "subType", element.getSubType(), -1);
        }
        if (element.hasUseElement()) {
            this.composeEnum(t, "ClaimResponse", "use", element.getUseElement(), -1);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "ClaimResponse", "patient", element.getPatient(), -1);
        }
        if (element.hasCreatedElement()) {
            this.composeDateTime(t, "ClaimResponse", "created", element.getCreatedElement(), -1);
        }
        if (element.hasInsurer()) {
            this.composeReference(t, "ClaimResponse", "insurer", element.getInsurer(), -1);
        }
        if (element.hasRequestor()) {
            this.composeReference(t, "ClaimResponse", "requestor", element.getRequestor(), -1);
        }
        if (element.hasRequest()) {
            this.composeReference(t, "ClaimResponse", "request", element.getRequest(), -1);
        }
        if (element.hasOutcomeElement()) {
            this.composeEnum(t, "ClaimResponse", "outcome", element.getOutcomeElement(), -1);
        }
        if (element.hasDispositionElement()) {
            this.composeString(t, "ClaimResponse", "disposition", element.getDispositionElement(), -1);
        }
        if (element.hasPreAuthRefElement()) {
            this.composeString(t, "ClaimResponse", "preAuthRef", element.getPreAuthRefElement(), -1);
        }
        if (element.hasPreAuthPeriod()) {
            this.composePeriod(t, "ClaimResponse", "preAuthPeriod", element.getPreAuthPeriod(), -1);
        }
        if (element.hasPayeeType()) {
            this.composeCodeableConcept(t, "ClaimResponse", "payeeType", element.getPayeeType(), -1);
        }
        for (i = 0; i < element.getItem().size(); ++i) {
            this.composeClaimResponseItemComponent(t, "ClaimResponse", "item", element.getItem().get(i), i);
        }
        for (i = 0; i < element.getAddItem().size(); ++i) {
            this.composeClaimResponseAddedItemComponent(t, "ClaimResponse", "addItem", element.getAddItem().get(i), i);
        }
        for (i = 0; i < element.getAdjudication().size(); ++i) {
            this.composeClaimResponseAdjudicationComponent(t, "ClaimResponse", "adjudication", element.getAdjudication().get(i), i);
        }
        for (i = 0; i < element.getTotal().size(); ++i) {
            this.composeClaimResponseTotalComponent(t, "ClaimResponse", "total", element.getTotal().get(i), i);
        }
        if (element.hasPayment()) {
            this.composeClaimResponsePaymentComponent(t, "ClaimResponse", "payment", element.getPayment(), -1);
        }
        if (element.hasFundsReserve()) {
            this.composeCodeableConcept(t, "ClaimResponse", "fundsReserve", element.getFundsReserve(), -1);
        }
        if (element.hasFormCode()) {
            this.composeCodeableConcept(t, "ClaimResponse", "formCode", element.getFormCode(), -1);
        }
        if (element.hasForm()) {
            this.composeAttachment(t, "ClaimResponse", "form", element.getForm(), -1);
        }
        for (i = 0; i < element.getProcessNote().size(); ++i) {
            this.composeClaimResponseNoteComponent(t, "ClaimResponse", "processNote", element.getProcessNote().get(i), i);
        }
        for (i = 0; i < element.getCommunicationRequest().size(); ++i) {
            this.composeReference(t, "ClaimResponse", "communicationRequest", element.getCommunicationRequest().get(i), i);
        }
        for (i = 0; i < element.getInsurance().size(); ++i) {
            this.composeClaimResponseInsuranceComponent(t, "ClaimResponse", "insurance", element.getInsurance().get(i), i);
        }
        for (i = 0; i < element.getError().size(); ++i) {
            this.composeClaimResponseErrorComponent(t, "ClaimResponse", "error", element.getError().get(i), i);
        }
    }

    protected void composeClaimResponseItemComponent(Turtle.Complex parent, String parentType, String name, ClaimResponse.ItemComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "item", name, element, index);
        if (element.hasItemSequenceElement()) {
            this.composePositiveInt(t, "ClaimResponse", "itemSequence", element.getItemSequenceElement(), -1);
        }
        for (i = 0; i < element.getNoteNumber().size(); ++i) {
            this.composePositiveInt(t, "ClaimResponse", "noteNumber", element.getNoteNumber().get(i), i);
        }
        for (i = 0; i < element.getAdjudication().size(); ++i) {
            this.composeClaimResponseAdjudicationComponent(t, "ClaimResponse", "adjudication", element.getAdjudication().get(i), i);
        }
        for (i = 0; i < element.getDetail().size(); ++i) {
            this.composeClaimResponseItemDetailComponent(t, "ClaimResponse", "detail", element.getDetail().get(i), i);
        }
    }

    protected void composeClaimResponseAdjudicationComponent(Turtle.Complex parent, String parentType, String name, ClaimResponse.AdjudicationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "adjudication", name, element, index);
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "ClaimResponse", "category", element.getCategory(), -1);
        }
        if (element.hasReason()) {
            this.composeCodeableConcept(t, "ClaimResponse", "reason", element.getReason(), -1);
        }
        if (element.hasAmount()) {
            this.composeMoney(t, "ClaimResponse", "amount", element.getAmount(), -1);
        }
        if (element.hasValueElement()) {
            this.composeDecimal(t, "ClaimResponse", "value", element.getValueElement(), -1);
        }
    }

    protected void composeClaimResponseItemDetailComponent(Turtle.Complex parent, String parentType, String name, ClaimResponse.ItemDetailComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "detail", name, element, index);
        if (element.hasDetailSequenceElement()) {
            this.composePositiveInt(t, "ClaimResponse", "detailSequence", element.getDetailSequenceElement(), -1);
        }
        for (i = 0; i < element.getNoteNumber().size(); ++i) {
            this.composePositiveInt(t, "ClaimResponse", "noteNumber", element.getNoteNumber().get(i), i);
        }
        for (i = 0; i < element.getAdjudication().size(); ++i) {
            this.composeClaimResponseAdjudicationComponent(t, "ClaimResponse", "adjudication", element.getAdjudication().get(i), i);
        }
        for (i = 0; i < element.getSubDetail().size(); ++i) {
            this.composeClaimResponseSubDetailComponent(t, "ClaimResponse", "subDetail", element.getSubDetail().get(i), i);
        }
    }

    protected void composeClaimResponseSubDetailComponent(Turtle.Complex parent, String parentType, String name, ClaimResponse.SubDetailComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "subDetail", name, element, index);
        if (element.hasSubDetailSequenceElement()) {
            this.composePositiveInt(t, "ClaimResponse", "subDetailSequence", element.getSubDetailSequenceElement(), -1);
        }
        for (i = 0; i < element.getNoteNumber().size(); ++i) {
            this.composePositiveInt(t, "ClaimResponse", "noteNumber", element.getNoteNumber().get(i), i);
        }
        for (i = 0; i < element.getAdjudication().size(); ++i) {
            this.composeClaimResponseAdjudicationComponent(t, "ClaimResponse", "adjudication", element.getAdjudication().get(i), i);
        }
    }

    protected void composeClaimResponseAddedItemComponent(Turtle.Complex parent, String parentType, String name, ClaimResponse.AddedItemComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "addItem", name, element, index);
        for (i = 0; i < element.getItemSequence().size(); ++i) {
            this.composePositiveInt(t, "ClaimResponse", "itemSequence", element.getItemSequence().get(i), i);
        }
        for (i = 0; i < element.getDetailSequence().size(); ++i) {
            this.composePositiveInt(t, "ClaimResponse", "detailSequence", element.getDetailSequence().get(i), i);
        }
        for (i = 0; i < element.getSubdetailSequence().size(); ++i) {
            this.composePositiveInt(t, "ClaimResponse", "subdetailSequence", element.getSubdetailSequence().get(i), i);
        }
        for (i = 0; i < element.getProvider().size(); ++i) {
            this.composeReference(t, "ClaimResponse", "provider", element.getProvider().get(i), i);
        }
        if (element.hasProductOrService()) {
            this.composeCodeableConcept(t, "ClaimResponse", "productOrService", element.getProductOrService(), -1);
        }
        for (i = 0; i < element.getModifier().size(); ++i) {
            this.composeCodeableConcept(t, "ClaimResponse", "modifier", element.getModifier().get(i), i);
        }
        for (i = 0; i < element.getProgramCode().size(); ++i) {
            this.composeCodeableConcept(t, "ClaimResponse", "programCode", element.getProgramCode().get(i), i);
        }
        if (element.hasServiced()) {
            this.composeType(t, "ClaimResponse", "serviced", element.getServiced(), -1);
        }
        if (element.hasLocation()) {
            this.composeType(t, "ClaimResponse", "location", element.getLocation(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "ClaimResponse", "quantity", element.getQuantity(), -1);
        }
        if (element.hasUnitPrice()) {
            this.composeMoney(t, "ClaimResponse", "unitPrice", element.getUnitPrice(), -1);
        }
        if (element.hasFactorElement()) {
            this.composeDecimal(t, "ClaimResponse", "factor", element.getFactorElement(), -1);
        }
        if (element.hasNet()) {
            this.composeMoney(t, "ClaimResponse", "net", element.getNet(), -1);
        }
        if (element.hasBodySite()) {
            this.composeCodeableConcept(t, "ClaimResponse", "bodySite", element.getBodySite(), -1);
        }
        for (i = 0; i < element.getSubSite().size(); ++i) {
            this.composeCodeableConcept(t, "ClaimResponse", "subSite", element.getSubSite().get(i), i);
        }
        for (i = 0; i < element.getNoteNumber().size(); ++i) {
            this.composePositiveInt(t, "ClaimResponse", "noteNumber", element.getNoteNumber().get(i), i);
        }
        for (i = 0; i < element.getAdjudication().size(); ++i) {
            this.composeClaimResponseAdjudicationComponent(t, "ClaimResponse", "adjudication", element.getAdjudication().get(i), i);
        }
        for (i = 0; i < element.getDetail().size(); ++i) {
            this.composeClaimResponseAddedItemDetailComponent(t, "ClaimResponse", "detail", element.getDetail().get(i), i);
        }
    }

    protected void composeClaimResponseAddedItemDetailComponent(Turtle.Complex parent, String parentType, String name, ClaimResponse.AddedItemDetailComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "detail", name, element, index);
        if (element.hasProductOrService()) {
            this.composeCodeableConcept(t, "ClaimResponse", "productOrService", element.getProductOrService(), -1);
        }
        for (i = 0; i < element.getModifier().size(); ++i) {
            this.composeCodeableConcept(t, "ClaimResponse", "modifier", element.getModifier().get(i), i);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "ClaimResponse", "quantity", element.getQuantity(), -1);
        }
        if (element.hasUnitPrice()) {
            this.composeMoney(t, "ClaimResponse", "unitPrice", element.getUnitPrice(), -1);
        }
        if (element.hasFactorElement()) {
            this.composeDecimal(t, "ClaimResponse", "factor", element.getFactorElement(), -1);
        }
        if (element.hasNet()) {
            this.composeMoney(t, "ClaimResponse", "net", element.getNet(), -1);
        }
        for (i = 0; i < element.getNoteNumber().size(); ++i) {
            this.composePositiveInt(t, "ClaimResponse", "noteNumber", element.getNoteNumber().get(i), i);
        }
        for (i = 0; i < element.getAdjudication().size(); ++i) {
            this.composeClaimResponseAdjudicationComponent(t, "ClaimResponse", "adjudication", element.getAdjudication().get(i), i);
        }
        for (i = 0; i < element.getSubDetail().size(); ++i) {
            this.composeClaimResponseAddedItemSubDetailComponent(t, "ClaimResponse", "subDetail", element.getSubDetail().get(i), i);
        }
    }

    protected void composeClaimResponseAddedItemSubDetailComponent(Turtle.Complex parent, String parentType, String name, ClaimResponse.AddedItemSubDetailComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "subDetail", name, element, index);
        if (element.hasProductOrService()) {
            this.composeCodeableConcept(t, "ClaimResponse", "productOrService", element.getProductOrService(), -1);
        }
        for (i = 0; i < element.getModifier().size(); ++i) {
            this.composeCodeableConcept(t, "ClaimResponse", "modifier", element.getModifier().get(i), i);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "ClaimResponse", "quantity", element.getQuantity(), -1);
        }
        if (element.hasUnitPrice()) {
            this.composeMoney(t, "ClaimResponse", "unitPrice", element.getUnitPrice(), -1);
        }
        if (element.hasFactorElement()) {
            this.composeDecimal(t, "ClaimResponse", "factor", element.getFactorElement(), -1);
        }
        if (element.hasNet()) {
            this.composeMoney(t, "ClaimResponse", "net", element.getNet(), -1);
        }
        for (i = 0; i < element.getNoteNumber().size(); ++i) {
            this.composePositiveInt(t, "ClaimResponse", "noteNumber", element.getNoteNumber().get(i), i);
        }
        for (i = 0; i < element.getAdjudication().size(); ++i) {
            this.composeClaimResponseAdjudicationComponent(t, "ClaimResponse", "adjudication", element.getAdjudication().get(i), i);
        }
    }

    protected void composeClaimResponseTotalComponent(Turtle.Complex parent, String parentType, String name, ClaimResponse.TotalComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "total", name, element, index);
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "ClaimResponse", "category", element.getCategory(), -1);
        }
        if (element.hasAmount()) {
            this.composeMoney(t, "ClaimResponse", "amount", element.getAmount(), -1);
        }
    }

    protected void composeClaimResponsePaymentComponent(Turtle.Complex parent, String parentType, String name, ClaimResponse.PaymentComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "payment", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "ClaimResponse", "type", element.getType(), -1);
        }
        if (element.hasAdjustment()) {
            this.composeMoney(t, "ClaimResponse", "adjustment", element.getAdjustment(), -1);
        }
        if (element.hasAdjustmentReason()) {
            this.composeCodeableConcept(t, "ClaimResponse", "adjustmentReason", element.getAdjustmentReason(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDate(t, "ClaimResponse", "date", element.getDateElement(), -1);
        }
        if (element.hasAmount()) {
            this.composeMoney(t, "ClaimResponse", "amount", element.getAmount(), -1);
        }
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "ClaimResponse", "identifier", element.getIdentifier(), -1);
        }
    }

    protected void composeClaimResponseNoteComponent(Turtle.Complex parent, String parentType, String name, ClaimResponse.NoteComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "processNote", name, element, index);
        if (element.hasNumberElement()) {
            this.composePositiveInt(t, "ClaimResponse", "number", element.getNumberElement(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeEnum(t, "ClaimResponse", "type", element.getTypeElement(), -1);
        }
        if (element.hasTextElement()) {
            this.composeString(t, "ClaimResponse", "text", element.getTextElement(), -1);
        }
        if (element.hasLanguage()) {
            this.composeCodeableConcept(t, "ClaimResponse", "language", element.getLanguage(), -1);
        }
    }

    protected void composeClaimResponseInsuranceComponent(Turtle.Complex parent, String parentType, String name, ClaimResponse.InsuranceComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "insurance", name, element, index);
        if (element.hasSequenceElement()) {
            this.composePositiveInt(t, "ClaimResponse", "sequence", element.getSequenceElement(), -1);
        }
        if (element.hasFocalElement()) {
            this.composeBoolean(t, "ClaimResponse", "focal", element.getFocalElement(), -1);
        }
        if (element.hasCoverage()) {
            this.composeReference(t, "ClaimResponse", "coverage", element.getCoverage(), -1);
        }
        if (element.hasBusinessArrangementElement()) {
            this.composeString(t, "ClaimResponse", "businessArrangement", element.getBusinessArrangementElement(), -1);
        }
        if (element.hasClaimResponse()) {
            this.composeReference(t, "ClaimResponse", "claimResponse", element.getClaimResponse(), -1);
        }
    }

    protected void composeClaimResponseErrorComponent(Turtle.Complex parent, String parentType, String name, ClaimResponse.ErrorComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "error", name, element, index);
        if (element.hasItemSequenceElement()) {
            this.composePositiveInt(t, "ClaimResponse", "itemSequence", element.getItemSequenceElement(), -1);
        }
        if (element.hasDetailSequenceElement()) {
            this.composePositiveInt(t, "ClaimResponse", "detailSequence", element.getDetailSequenceElement(), -1);
        }
        if (element.hasSubDetailSequenceElement()) {
            this.composePositiveInt(t, "ClaimResponse", "subDetailSequence", element.getSubDetailSequenceElement(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "ClaimResponse", "code", element.getCode(), -1);
        }
    }

    protected void composeClinicalImpression(Turtle.Complex parent, String parentType, String name, ClinicalImpression element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "ClinicalImpression", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "ClinicalImpression", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "ClinicalImpression", "status", element.getStatusElement(), -1);
        }
        if (element.hasStatusReason()) {
            this.composeCodeableConcept(t, "ClinicalImpression", "statusReason", element.getStatusReason(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "ClinicalImpression", "code", element.getCode(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "ClinicalImpression", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "ClinicalImpression", "subject", element.getSubject(), -1);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "ClinicalImpression", "encounter", element.getEncounter(), -1);
        }
        if (element.hasEffective()) {
            this.composeType(t, "ClinicalImpression", "effective", element.getEffective(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "ClinicalImpression", "date", element.getDateElement(), -1);
        }
        if (element.hasAssessor()) {
            this.composeReference(t, "ClinicalImpression", "assessor", element.getAssessor(), -1);
        }
        if (element.hasPrevious()) {
            this.composeReference(t, "ClinicalImpression", "previous", element.getPrevious(), -1);
        }
        for (i = 0; i < element.getProblem().size(); ++i) {
            this.composeReference(t, "ClinicalImpression", "problem", element.getProblem().get(i), i);
        }
        for (i = 0; i < element.getInvestigation().size(); ++i) {
            this.composeClinicalImpressionClinicalImpressionInvestigationComponent(t, "ClinicalImpression", "investigation", element.getInvestigation().get(i), i);
        }
        for (i = 0; i < element.getProtocol().size(); ++i) {
            this.composeUri(t, "ClinicalImpression", "protocol", element.getProtocol().get(i), i);
        }
        if (element.hasSummaryElement()) {
            this.composeString(t, "ClinicalImpression", "summary", element.getSummaryElement(), -1);
        }
        for (i = 0; i < element.getFinding().size(); ++i) {
            this.composeClinicalImpressionClinicalImpressionFindingComponent(t, "ClinicalImpression", "finding", element.getFinding().get(i), i);
        }
        for (i = 0; i < element.getPrognosisCodeableConcept().size(); ++i) {
            this.composeCodeableConcept(t, "ClinicalImpression", "prognosisCodeableConcept", element.getPrognosisCodeableConcept().get(i), i);
        }
        for (i = 0; i < element.getPrognosisReference().size(); ++i) {
            this.composeReference(t, "ClinicalImpression", "prognosisReference", element.getPrognosisReference().get(i), i);
        }
        for (i = 0; i < element.getSupportingInfo().size(); ++i) {
            this.composeReference(t, "ClinicalImpression", "supportingInfo", element.getSupportingInfo().get(i), i);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "ClinicalImpression", "note", element.getNote().get(i), i);
        }
    }

    protected void composeClinicalImpressionClinicalImpressionInvestigationComponent(Turtle.Complex parent, String parentType, String name, ClinicalImpression.ClinicalImpressionInvestigationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "investigation", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "ClinicalImpression", "code", element.getCode(), -1);
        }
        for (int i = 0; i < element.getItem().size(); ++i) {
            this.composeReference(t, "ClinicalImpression", "item", element.getItem().get(i), i);
        }
    }

    protected void composeClinicalImpressionClinicalImpressionFindingComponent(Turtle.Complex parent, String parentType, String name, ClinicalImpression.ClinicalImpressionFindingComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "finding", name, element, index);
        if (element.hasItemCodeableConcept()) {
            this.composeCodeableConcept(t, "ClinicalImpression", "itemCodeableConcept", element.getItemCodeableConcept(), -1);
        }
        if (element.hasItemReference()) {
            this.composeReference(t, "ClinicalImpression", "itemReference", element.getItemReference(), -1);
        }
        if (element.hasBasisElement()) {
            this.composeString(t, "ClinicalImpression", "basis", element.getBasisElement(), -1);
        }
    }

    protected void composeCodeSystem(Turtle.Complex parent, String parentType, String name, CodeSystem element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "CodeSystem", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "CodeSystem", "url", element.getUrlElement(), -1);
        }
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "CodeSystem", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "CodeSystem", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "CodeSystem", "name", element.getNameElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "CodeSystem", "title", element.getTitleElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "CodeSystem", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "CodeSystem", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "CodeSystem", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "CodeSystem", "publisher", element.getPublisherElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeContactDetail(t, "CodeSystem", "contact", element.getContact().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "CodeSystem", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getUseContext().size(); ++i) {
            this.composeUsageContext(t, "CodeSystem", "useContext", element.getUseContext().get(i), i);
        }
        for (i = 0; i < element.getJurisdiction().size(); ++i) {
            this.composeCodeableConcept(t, "CodeSystem", "jurisdiction", element.getJurisdiction().get(i), i);
        }
        if (element.hasPurposeElement()) {
            this.composeMarkdown(t, "CodeSystem", "purpose", element.getPurposeElement(), -1);
        }
        if (element.hasCopyrightElement()) {
            this.composeMarkdown(t, "CodeSystem", "copyright", element.getCopyrightElement(), -1);
        }
        if (element.hasCaseSensitiveElement()) {
            this.composeBoolean(t, "CodeSystem", "caseSensitive", element.getCaseSensitiveElement(), -1);
        }
        if (element.hasValueSetElement()) {
            this.composeCanonical(t, "CodeSystem", "valueSet", element.getValueSetElement(), -1);
        }
        if (element.hasHierarchyMeaningElement()) {
            this.composeEnum(t, "CodeSystem", "hierarchyMeaning", element.getHierarchyMeaningElement(), -1);
        }
        if (element.hasCompositionalElement()) {
            this.composeBoolean(t, "CodeSystem", "compositional", element.getCompositionalElement(), -1);
        }
        if (element.hasVersionNeededElement()) {
            this.composeBoolean(t, "CodeSystem", "versionNeeded", element.getVersionNeededElement(), -1);
        }
        if (element.hasContentElement()) {
            this.composeEnum(t, "CodeSystem", "content", element.getContentElement(), -1);
        }
        if (element.hasSupplementsElement()) {
            this.composeCanonical(t, "CodeSystem", "supplements", element.getSupplementsElement(), -1);
        }
        if (element.hasCountElement()) {
            this.composeUnsignedInt(t, "CodeSystem", "count", element.getCountElement(), -1);
        }
        for (i = 0; i < element.getFilter().size(); ++i) {
            this.composeCodeSystemCodeSystemFilterComponent(t, "CodeSystem", "filter", element.getFilter().get(i), i);
        }
        for (i = 0; i < element.getProperty().size(); ++i) {
            this.composeCodeSystemPropertyComponent(t, "CodeSystem", "property", element.getProperty().get(i), i);
        }
        for (i = 0; i < element.getConcept().size(); ++i) {
            this.composeCodeSystemConceptDefinitionComponent(t, "CodeSystem", "concept", element.getConcept().get(i), i);
        }
    }

    protected void composeCodeSystemCodeSystemFilterComponent(Turtle.Complex parent, String parentType, String name, CodeSystem.CodeSystemFilterComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "filter", name, element, index);
        if (element.hasCodeElement()) {
            this.composeCode(t, "CodeSystem", "code", element.getCodeElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "CodeSystem", "description", element.getDescriptionElement(), -1);
        }
        for (int i = 0; i < element.getOperator().size(); ++i) {
            this.composeEnum(t, "CodeSystem", "operator", element.getOperator().get(i), i);
        }
        if (element.hasValueElement()) {
            this.composeString(t, "CodeSystem", "value", element.getValueElement(), -1);
        }
    }

    protected void composeCodeSystemPropertyComponent(Turtle.Complex parent, String parentType, String name, CodeSystem.PropertyComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "property", name, element, index);
        if (element.hasCodeElement()) {
            this.composeCode(t, "CodeSystem", "code", element.getCodeElement(), -1);
        }
        if (element.hasUriElement()) {
            this.composeUri(t, "CodeSystem", "uri", element.getUriElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "CodeSystem", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeEnum(t, "CodeSystem", "type", element.getTypeElement(), -1);
        }
    }

    protected void composeCodeSystemConceptDefinitionComponent(Turtle.Complex parent, String parentType, String name, CodeSystem.ConceptDefinitionComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "concept", name, element, index);
        if (element.hasCodeElement()) {
            this.composeCode(t, "CodeSystem", "code", element.getCodeElement(), -1);
        }
        if (element.hasDisplayElement()) {
            this.composeString(t, "CodeSystem", "display", element.getDisplayElement(), -1);
        }
        if (element.hasDefinitionElement()) {
            this.composeString(t, "CodeSystem", "definition", element.getDefinitionElement(), -1);
        }
        for (i = 0; i < element.getDesignation().size(); ++i) {
            this.composeCodeSystemConceptDefinitionDesignationComponent(t, "CodeSystem", "designation", element.getDesignation().get(i), i);
        }
        for (i = 0; i < element.getProperty().size(); ++i) {
            this.composeCodeSystemConceptPropertyComponent(t, "CodeSystem", "property", element.getProperty().get(i), i);
        }
        for (i = 0; i < element.getConcept().size(); ++i) {
            this.composeCodeSystemConceptDefinitionComponent(t, "CodeSystem", "concept", element.getConcept().get(i), i);
        }
    }

    protected void composeCodeSystemConceptDefinitionDesignationComponent(Turtle.Complex parent, String parentType, String name, CodeSystem.ConceptDefinitionDesignationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "designation", name, element, index);
        if (element.hasLanguageElement()) {
            this.composeCode(t, "CodeSystem", "language", element.getLanguageElement(), -1);
        }
        if (element.hasUse()) {
            this.composeCoding(t, "CodeSystem", "use", element.getUse(), -1);
        }
        if (element.hasValueElement()) {
            this.composeString(t, "CodeSystem", "value", element.getValueElement(), -1);
        }
    }

    protected void composeCodeSystemConceptPropertyComponent(Turtle.Complex parent, String parentType, String name, CodeSystem.ConceptPropertyComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "property", name, element, index);
        if (element.hasCodeElement()) {
            this.composeCode(t, "CodeSystem", "code", element.getCodeElement(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "CodeSystem", "value", element.getValue(), -1);
        }
    }

    protected void composeCommunication(Turtle.Complex parent, String parentType, String name, Communication element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Communication", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Communication", "identifier", element.getIdentifier().get(i), i);
        }
        for (i = 0; i < element.getInstantiatesCanonical().size(); ++i) {
            this.composeCanonical(t, "Communication", "instantiatesCanonical", element.getInstantiatesCanonical().get(i), i);
        }
        for (i = 0; i < element.getInstantiatesUri().size(); ++i) {
            this.composeUri(t, "Communication", "instantiatesUri", element.getInstantiatesUri().get(i), i);
        }
        for (i = 0; i < element.getBasedOn().size(); ++i) {
            this.composeReference(t, "Communication", "basedOn", element.getBasedOn().get(i), i);
        }
        for (i = 0; i < element.getPartOf().size(); ++i) {
            this.composeReference(t, "Communication", "partOf", element.getPartOf().get(i), i);
        }
        for (i = 0; i < element.getInResponseTo().size(); ++i) {
            this.composeReference(t, "Communication", "inResponseTo", element.getInResponseTo().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Communication", "status", element.getStatusElement(), -1);
        }
        if (element.hasStatusReason()) {
            this.composeCodeableConcept(t, "Communication", "statusReason", element.getStatusReason(), -1);
        }
        for (i = 0; i < element.getCategory().size(); ++i) {
            this.composeCodeableConcept(t, "Communication", "category", element.getCategory().get(i), i);
        }
        if (element.hasPriorityElement()) {
            this.composeEnum(t, "Communication", "priority", element.getPriorityElement(), -1);
        }
        for (i = 0; i < element.getMedium().size(); ++i) {
            this.composeCodeableConcept(t, "Communication", "medium", element.getMedium().get(i), i);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "Communication", "subject", element.getSubject(), -1);
        }
        if (element.hasTopic()) {
            this.composeCodeableConcept(t, "Communication", "topic", element.getTopic(), -1);
        }
        for (i = 0; i < element.getAbout().size(); ++i) {
            this.composeReference(t, "Communication", "about", element.getAbout().get(i), i);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "Communication", "encounter", element.getEncounter(), -1);
        }
        if (element.hasSentElement()) {
            this.composeDateTime(t, "Communication", "sent", element.getSentElement(), -1);
        }
        if (element.hasReceivedElement()) {
            this.composeDateTime(t, "Communication", "received", element.getReceivedElement(), -1);
        }
        for (i = 0; i < element.getRecipient().size(); ++i) {
            this.composeReference(t, "Communication", "recipient", element.getRecipient().get(i), i);
        }
        if (element.hasSender()) {
            this.composeReference(t, "Communication", "sender", element.getSender(), -1);
        }
        for (i = 0; i < element.getReasonCode().size(); ++i) {
            this.composeCodeableConcept(t, "Communication", "reasonCode", element.getReasonCode().get(i), i);
        }
        for (i = 0; i < element.getReasonReference().size(); ++i) {
            this.composeReference(t, "Communication", "reasonReference", element.getReasonReference().get(i), i);
        }
        for (i = 0; i < element.getPayload().size(); ++i) {
            this.composeCommunicationCommunicationPayloadComponent(t, "Communication", "payload", element.getPayload().get(i), i);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "Communication", "note", element.getNote().get(i), i);
        }
    }

    protected void composeCommunicationCommunicationPayloadComponent(Turtle.Complex parent, String parentType, String name, Communication.CommunicationPayloadComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "payload", name, element, index);
        if (element.hasContent()) {
            this.composeType(t, "Communication", "content", element.getContent(), -1);
        }
    }

    protected void composeCommunicationRequest(Turtle.Complex parent, String parentType, String name, CommunicationRequest element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "CommunicationRequest", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "CommunicationRequest", "identifier", element.getIdentifier().get(i), i);
        }
        for (i = 0; i < element.getBasedOn().size(); ++i) {
            this.composeReference(t, "CommunicationRequest", "basedOn", element.getBasedOn().get(i), i);
        }
        for (i = 0; i < element.getReplaces().size(); ++i) {
            this.composeReference(t, "CommunicationRequest", "replaces", element.getReplaces().get(i), i);
        }
        if (element.hasGroupIdentifier()) {
            this.composeIdentifier(t, "CommunicationRequest", "groupIdentifier", element.getGroupIdentifier(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "CommunicationRequest", "status", element.getStatusElement(), -1);
        }
        if (element.hasStatusReason()) {
            this.composeCodeableConcept(t, "CommunicationRequest", "statusReason", element.getStatusReason(), -1);
        }
        for (i = 0; i < element.getCategory().size(); ++i) {
            this.composeCodeableConcept(t, "CommunicationRequest", "category", element.getCategory().get(i), i);
        }
        if (element.hasPriorityElement()) {
            this.composeEnum(t, "CommunicationRequest", "priority", element.getPriorityElement(), -1);
        }
        if (element.hasDoNotPerformElement()) {
            this.composeBoolean(t, "CommunicationRequest", "doNotPerform", element.getDoNotPerformElement(), -1);
        }
        for (i = 0; i < element.getMedium().size(); ++i) {
            this.composeCodeableConcept(t, "CommunicationRequest", "medium", element.getMedium().get(i), i);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "CommunicationRequest", "subject", element.getSubject(), -1);
        }
        for (i = 0; i < element.getAbout().size(); ++i) {
            this.composeReference(t, "CommunicationRequest", "about", element.getAbout().get(i), i);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "CommunicationRequest", "encounter", element.getEncounter(), -1);
        }
        for (i = 0; i < element.getPayload().size(); ++i) {
            this.composeCommunicationRequestCommunicationRequestPayloadComponent(t, "CommunicationRequest", "payload", element.getPayload().get(i), i);
        }
        if (element.hasOccurrence()) {
            this.composeType(t, "CommunicationRequest", "occurrence", element.getOccurrence(), -1);
        }
        if (element.hasAuthoredOnElement()) {
            this.composeDateTime(t, "CommunicationRequest", "authoredOn", element.getAuthoredOnElement(), -1);
        }
        if (element.hasRequester()) {
            this.composeReference(t, "CommunicationRequest", "requester", element.getRequester(), -1);
        }
        for (i = 0; i < element.getRecipient().size(); ++i) {
            this.composeReference(t, "CommunicationRequest", "recipient", element.getRecipient().get(i), i);
        }
        if (element.hasSender()) {
            this.composeReference(t, "CommunicationRequest", "sender", element.getSender(), -1);
        }
        for (i = 0; i < element.getReasonCode().size(); ++i) {
            this.composeCodeableConcept(t, "CommunicationRequest", "reasonCode", element.getReasonCode().get(i), i);
        }
        for (i = 0; i < element.getReasonReference().size(); ++i) {
            this.composeReference(t, "CommunicationRequest", "reasonReference", element.getReasonReference().get(i), i);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "CommunicationRequest", "note", element.getNote().get(i), i);
        }
    }

    protected void composeCommunicationRequestCommunicationRequestPayloadComponent(Turtle.Complex parent, String parentType, String name, CommunicationRequest.CommunicationRequestPayloadComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "payload", name, element, index);
        if (element.hasContent()) {
            this.composeType(t, "CommunicationRequest", "content", element.getContent(), -1);
        }
    }

    protected void composeCompartmentDefinition(Turtle.Complex parent, String parentType, String name, CompartmentDefinition element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "CompartmentDefinition", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "CompartmentDefinition", "url", element.getUrlElement(), -1);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "CompartmentDefinition", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "CompartmentDefinition", "name", element.getNameElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "CompartmentDefinition", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "CompartmentDefinition", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "CompartmentDefinition", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "CompartmentDefinition", "publisher", element.getPublisherElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeContactDetail(t, "CompartmentDefinition", "contact", element.getContact().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "CompartmentDefinition", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getUseContext().size(); ++i) {
            this.composeUsageContext(t, "CompartmentDefinition", "useContext", element.getUseContext().get(i), i);
        }
        if (element.hasPurposeElement()) {
            this.composeMarkdown(t, "CompartmentDefinition", "purpose", element.getPurposeElement(), -1);
        }
        if (element.hasCodeElement()) {
            this.composeEnum(t, "CompartmentDefinition", "code", element.getCodeElement(), -1);
        }
        if (element.hasSearchElement()) {
            this.composeBoolean(t, "CompartmentDefinition", "search", element.getSearchElement(), -1);
        }
        for (i = 0; i < element.getResource().size(); ++i) {
            this.composeCompartmentDefinitionCompartmentDefinitionResourceComponent(t, "CompartmentDefinition", "resource", element.getResource().get(i), i);
        }
    }

    protected void composeCompartmentDefinitionCompartmentDefinitionResourceComponent(Turtle.Complex parent, String parentType, String name, CompartmentDefinition.CompartmentDefinitionResourceComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "resource", name, element, index);
        if (element.hasCodeElement()) {
            this.composeCode(t, "CompartmentDefinition", "code", element.getCodeElement(), -1);
        }
        for (int i = 0; i < element.getParam().size(); ++i) {
            this.composeString(t, "CompartmentDefinition", "param", element.getParam().get(i), i);
        }
        if (element.hasDocumentationElement()) {
            this.composeString(t, "CompartmentDefinition", "documentation", element.getDocumentationElement(), -1);
        }
    }

    protected void composeComposition(Turtle.Complex parent, String parentType, String name, Composition element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Composition", name, element, index);
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "Composition", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Composition", "status", element.getStatusElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "Composition", "type", element.getType(), -1);
        }
        for (i = 0; i < element.getCategory().size(); ++i) {
            this.composeCodeableConcept(t, "Composition", "category", element.getCategory().get(i), i);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "Composition", "subject", element.getSubject(), -1);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "Composition", "encounter", element.getEncounter(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "Composition", "date", element.getDateElement(), -1);
        }
        for (i = 0; i < element.getAuthor().size(); ++i) {
            this.composeReference(t, "Composition", "author", element.getAuthor().get(i), i);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "Composition", "title", element.getTitleElement(), -1);
        }
        if (element.hasConfidentialityElement()) {
            this.composeEnum(t, "Composition", "confidentiality", element.getConfidentialityElement(), -1);
        }
        for (i = 0; i < element.getAttester().size(); ++i) {
            this.composeCompositionCompositionAttesterComponent(t, "Composition", "attester", element.getAttester().get(i), i);
        }
        if (element.hasCustodian()) {
            this.composeReference(t, "Composition", "custodian", element.getCustodian(), -1);
        }
        for (i = 0; i < element.getRelatesTo().size(); ++i) {
            this.composeCompositionCompositionRelatesToComponent(t, "Composition", "relatesTo", element.getRelatesTo().get(i), i);
        }
        for (i = 0; i < element.getEvent().size(); ++i) {
            this.composeCompositionCompositionEventComponent(t, "Composition", "event", element.getEvent().get(i), i);
        }
        for (i = 0; i < element.getSection().size(); ++i) {
            this.composeCompositionSectionComponent(t, "Composition", "section", element.getSection().get(i), i);
        }
    }

    protected void composeCompositionCompositionAttesterComponent(Turtle.Complex parent, String parentType, String name, Composition.CompositionAttesterComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "attester", name, element, index);
        if (element.hasModeElement()) {
            this.composeEnum(t, "Composition", "mode", element.getModeElement(), -1);
        }
        if (element.hasTimeElement()) {
            this.composeDateTime(t, "Composition", "time", element.getTimeElement(), -1);
        }
        if (element.hasParty()) {
            this.composeReference(t, "Composition", "party", element.getParty(), -1);
        }
    }

    protected void composeCompositionCompositionRelatesToComponent(Turtle.Complex parent, String parentType, String name, Composition.CompositionRelatesToComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "relatesTo", name, element, index);
        if (element.hasCodeElement()) {
            this.composeEnum(t, "Composition", "code", element.getCodeElement(), -1);
        }
        if (element.hasTarget()) {
            this.composeType(t, "Composition", "target", element.getTarget(), -1);
        }
    }

    protected void composeCompositionCompositionEventComponent(Turtle.Complex parent, String parentType, String name, Composition.CompositionEventComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "event", name, element, index);
        for (i = 0; i < element.getCode().size(); ++i) {
            this.composeCodeableConcept(t, "Composition", "code", element.getCode().get(i), i);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "Composition", "period", element.getPeriod(), -1);
        }
        for (i = 0; i < element.getDetail().size(); ++i) {
            this.composeReference(t, "Composition", "detail", element.getDetail().get(i), i);
        }
    }

    protected void composeCompositionSectionComponent(Turtle.Complex parent, String parentType, String name, Composition.SectionComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "section", name, element, index);
        if (element.hasTitleElement()) {
            this.composeString(t, "Composition", "title", element.getTitleElement(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "Composition", "code", element.getCode(), -1);
        }
        for (i = 0; i < element.getAuthor().size(); ++i) {
            this.composeReference(t, "Composition", "author", element.getAuthor().get(i), i);
        }
        if (element.hasFocus()) {
            this.composeReference(t, "Composition", "focus", element.getFocus(), -1);
        }
        if (element.hasText()) {
            this.composeNarrative(t, "Composition", "text", element.getText(), -1);
        }
        if (element.hasModeElement()) {
            this.composeEnum(t, "Composition", "mode", element.getModeElement(), -1);
        }
        if (element.hasOrderedBy()) {
            this.composeCodeableConcept(t, "Composition", "orderedBy", element.getOrderedBy(), -1);
        }
        for (i = 0; i < element.getEntry().size(); ++i) {
            this.composeReference(t, "Composition", "entry", element.getEntry().get(i), i);
        }
        if (element.hasEmptyReason()) {
            this.composeCodeableConcept(t, "Composition", "emptyReason", element.getEmptyReason(), -1);
        }
        for (i = 0; i < element.getSection().size(); ++i) {
            this.composeCompositionSectionComponent(t, "Composition", "section", element.getSection().get(i), i);
        }
    }

    protected void composeConceptMap(Turtle.Complex parent, String parentType, String name, ConceptMap element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "ConceptMap", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "ConceptMap", "url", element.getUrlElement(), -1);
        }
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "ConceptMap", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "ConceptMap", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "ConceptMap", "name", element.getNameElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "ConceptMap", "title", element.getTitleElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "ConceptMap", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "ConceptMap", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "ConceptMap", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "ConceptMap", "publisher", element.getPublisherElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeContactDetail(t, "ConceptMap", "contact", element.getContact().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "ConceptMap", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getUseContext().size(); ++i) {
            this.composeUsageContext(t, "ConceptMap", "useContext", element.getUseContext().get(i), i);
        }
        for (i = 0; i < element.getJurisdiction().size(); ++i) {
            this.composeCodeableConcept(t, "ConceptMap", "jurisdiction", element.getJurisdiction().get(i), i);
        }
        if (element.hasPurposeElement()) {
            this.composeMarkdown(t, "ConceptMap", "purpose", element.getPurposeElement(), -1);
        }
        if (element.hasCopyrightElement()) {
            this.composeMarkdown(t, "ConceptMap", "copyright", element.getCopyrightElement(), -1);
        }
        if (element.hasSource()) {
            this.composeType(t, "ConceptMap", "source", element.getSource(), -1);
        }
        if (element.hasTarget()) {
            this.composeType(t, "ConceptMap", "target", element.getTarget(), -1);
        }
        for (i = 0; i < element.getGroup().size(); ++i) {
            this.composeConceptMapConceptMapGroupComponent(t, "ConceptMap", "group", element.getGroup().get(i), i);
        }
    }

    protected void composeConceptMapConceptMapGroupComponent(Turtle.Complex parent, String parentType, String name, ConceptMap.ConceptMapGroupComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "group", name, element, index);
        if (element.hasSourceElement()) {
            this.composeUri(t, "ConceptMap", "source", element.getSourceElement(), -1);
        }
        if (element.hasSourceVersionElement()) {
            this.composeString(t, "ConceptMap", "sourceVersion", element.getSourceVersionElement(), -1);
        }
        if (element.hasTargetElement()) {
            this.composeUri(t, "ConceptMap", "target", element.getTargetElement(), -1);
        }
        if (element.hasTargetVersionElement()) {
            this.composeString(t, "ConceptMap", "targetVersion", element.getTargetVersionElement(), -1);
        }
        for (int i = 0; i < element.getElement().size(); ++i) {
            this.composeConceptMapSourceElementComponent(t, "ConceptMap", "element", element.getElement().get(i), i);
        }
        if (element.hasUnmapped()) {
            this.composeConceptMapConceptMapGroupUnmappedComponent(t, "ConceptMap", "unmapped", element.getUnmapped(), -1);
        }
    }

    protected void composeConceptMapSourceElementComponent(Turtle.Complex parent, String parentType, String name, ConceptMap.SourceElementComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "element", name, element, index);
        if (element.hasCodeElement()) {
            this.composeCode(t, "ConceptMap", "code", element.getCodeElement(), -1);
        }
        if (element.hasDisplayElement()) {
            this.composeString(t, "ConceptMap", "display", element.getDisplayElement(), -1);
        }
        for (int i = 0; i < element.getTarget().size(); ++i) {
            this.composeConceptMapTargetElementComponent(t, "ConceptMap", "target", element.getTarget().get(i), i);
        }
    }

    protected void composeConceptMapTargetElementComponent(Turtle.Complex parent, String parentType, String name, ConceptMap.TargetElementComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "target", name, element, index);
        if (element.hasCodeElement()) {
            this.composeCode(t, "ConceptMap", "code", element.getCodeElement(), -1);
        }
        if (element.hasDisplayElement()) {
            this.composeString(t, "ConceptMap", "display", element.getDisplayElement(), -1);
        }
        if (element.hasEquivalenceElement()) {
            this.composeEnum(t, "ConceptMap", "equivalence", element.getEquivalenceElement(), -1);
        }
        if (element.hasCommentElement()) {
            this.composeString(t, "ConceptMap", "comment", element.getCommentElement(), -1);
        }
        for (i = 0; i < element.getDependsOn().size(); ++i) {
            this.composeConceptMapOtherElementComponent(t, "ConceptMap", "dependsOn", element.getDependsOn().get(i), i);
        }
        for (i = 0; i < element.getProduct().size(); ++i) {
            this.composeConceptMapOtherElementComponent(t, "ConceptMap", "product", element.getProduct().get(i), i);
        }
    }

    protected void composeConceptMapOtherElementComponent(Turtle.Complex parent, String parentType, String name, ConceptMap.OtherElementComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "dependsOn", name, element, index);
        if (element.hasPropertyElement()) {
            this.composeUri(t, "ConceptMap", "property", element.getPropertyElement(), -1);
        }
        if (element.hasSystemElement()) {
            this.composeCanonical(t, "ConceptMap", "system", element.getSystemElement(), -1);
        }
        if (element.hasValueElement()) {
            this.composeString(t, "ConceptMap", "value", element.getValueElement(), -1);
        }
        if (element.hasDisplayElement()) {
            this.composeString(t, "ConceptMap", "display", element.getDisplayElement(), -1);
        }
    }

    protected void composeConceptMapConceptMapGroupUnmappedComponent(Turtle.Complex parent, String parentType, String name, ConceptMap.ConceptMapGroupUnmappedComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "unmapped", name, element, index);
        if (element.hasModeElement()) {
            this.composeEnum(t, "ConceptMap", "mode", element.getModeElement(), -1);
        }
        if (element.hasCodeElement()) {
            this.composeCode(t, "ConceptMap", "code", element.getCodeElement(), -1);
        }
        if (element.hasDisplayElement()) {
            this.composeString(t, "ConceptMap", "display", element.getDisplayElement(), -1);
        }
        if (element.hasUrlElement()) {
            this.composeCanonical(t, "ConceptMap", "url", element.getUrlElement(), -1);
        }
    }

    protected void composeCondition(Turtle.Complex parent, String parentType, String name, Condition element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Condition", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Condition", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasClinicalStatus()) {
            this.composeCodeableConcept(t, "Condition", "clinicalStatus", element.getClinicalStatus(), -1);
        }
        if (element.hasVerificationStatus()) {
            this.composeCodeableConcept(t, "Condition", "verificationStatus", element.getVerificationStatus(), -1);
        }
        for (i = 0; i < element.getCategory().size(); ++i) {
            this.composeCodeableConcept(t, "Condition", "category", element.getCategory().get(i), i);
        }
        if (element.hasSeverity()) {
            this.composeCodeableConcept(t, "Condition", "severity", element.getSeverity(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "Condition", "code", element.getCode(), -1);
        }
        for (i = 0; i < element.getBodySite().size(); ++i) {
            this.composeCodeableConcept(t, "Condition", "bodySite", element.getBodySite().get(i), i);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "Condition", "subject", element.getSubject(), -1);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "Condition", "encounter", element.getEncounter(), -1);
        }
        if (element.hasOnset()) {
            this.composeType(t, "Condition", "onset", element.getOnset(), -1);
        }
        if (element.hasAbatement()) {
            this.composeType(t, "Condition", "abatement", element.getAbatement(), -1);
        }
        if (element.hasRecordedDateElement()) {
            this.composeDateTime(t, "Condition", "recordedDate", element.getRecordedDateElement(), -1);
        }
        if (element.hasRecorder()) {
            this.composeReference(t, "Condition", "recorder", element.getRecorder(), -1);
        }
        if (element.hasAsserter()) {
            this.composeReference(t, "Condition", "asserter", element.getAsserter(), -1);
        }
        for (i = 0; i < element.getStage().size(); ++i) {
            this.composeConditionConditionStageComponent(t, "Condition", "stage", element.getStage().get(i), i);
        }
        for (i = 0; i < element.getEvidence().size(); ++i) {
            this.composeConditionConditionEvidenceComponent(t, "Condition", "evidence", element.getEvidence().get(i), i);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "Condition", "note", element.getNote().get(i), i);
        }
    }

    protected void composeConditionConditionStageComponent(Turtle.Complex parent, String parentType, String name, Condition.ConditionStageComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "stage", name, element, index);
        if (element.hasSummary()) {
            this.composeCodeableConcept(t, "Condition", "summary", element.getSummary(), -1);
        }
        for (int i = 0; i < element.getAssessment().size(); ++i) {
            this.composeReference(t, "Condition", "assessment", element.getAssessment().get(i), i);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "Condition", "type", element.getType(), -1);
        }
    }

    protected void composeConditionConditionEvidenceComponent(Turtle.Complex parent, String parentType, String name, Condition.ConditionEvidenceComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "evidence", name, element, index);
        for (i = 0; i < element.getCode().size(); ++i) {
            this.composeCodeableConcept(t, "Condition", "code", element.getCode().get(i), i);
        }
        for (i = 0; i < element.getDetail().size(); ++i) {
            this.composeReference(t, "Condition", "detail", element.getDetail().get(i), i);
        }
    }

    protected void composeConsent(Turtle.Complex parent, String parentType, String name, Consent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Consent", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Consent", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Consent", "status", element.getStatusElement(), -1);
        }
        if (element.hasScope()) {
            this.composeCodeableConcept(t, "Consent", "scope", element.getScope(), -1);
        }
        for (i = 0; i < element.getCategory().size(); ++i) {
            this.composeCodeableConcept(t, "Consent", "category", element.getCategory().get(i), i);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "Consent", "patient", element.getPatient(), -1);
        }
        if (element.hasDateTimeElement()) {
            this.composeDateTime(t, "Consent", "dateTime", element.getDateTimeElement(), -1);
        }
        for (i = 0; i < element.getPerformer().size(); ++i) {
            this.composeReference(t, "Consent", "performer", element.getPerformer().get(i), i);
        }
        for (i = 0; i < element.getOrganization().size(); ++i) {
            this.composeReference(t, "Consent", "organization", element.getOrganization().get(i), i);
        }
        if (element.hasSource()) {
            this.composeType(t, "Consent", "source", element.getSource(), -1);
        }
        for (i = 0; i < element.getPolicy().size(); ++i) {
            this.composeConsentConsentPolicyComponent(t, "Consent", "policy", element.getPolicy().get(i), i);
        }
        if (element.hasPolicyRule()) {
            this.composeCodeableConcept(t, "Consent", "policyRule", element.getPolicyRule(), -1);
        }
        for (i = 0; i < element.getVerification().size(); ++i) {
            this.composeConsentConsentVerificationComponent(t, "Consent", "verification", element.getVerification().get(i), i);
        }
        if (element.hasProvision()) {
            this.composeConsentprovisionComponent(t, "Consent", "provision", element.getProvision(), -1);
        }
    }

    protected void composeConsentConsentPolicyComponent(Turtle.Complex parent, String parentType, String name, Consent.ConsentPolicyComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "policy", name, element, index);
        if (element.hasAuthorityElement()) {
            this.composeUri(t, "Consent", "authority", element.getAuthorityElement(), -1);
        }
        if (element.hasUriElement()) {
            this.composeUri(t, "Consent", "uri", element.getUriElement(), -1);
        }
    }

    protected void composeConsentConsentVerificationComponent(Turtle.Complex parent, String parentType, String name, Consent.ConsentVerificationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "verification", name, element, index);
        if (element.hasVerifiedElement()) {
            this.composeBoolean(t, "Consent", "verified", element.getVerifiedElement(), -1);
        }
        if (element.hasVerifiedWith()) {
            this.composeReference(t, "Consent", "verifiedWith", element.getVerifiedWith(), -1);
        }
        if (element.hasVerificationDateElement()) {
            this.composeDateTime(t, "Consent", "verificationDate", element.getVerificationDateElement(), -1);
        }
    }

    protected void composeConsentprovisionComponent(Turtle.Complex parent, String parentType, String name, Consent.ProvisionComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "provision", name, element, index);
        if (element.hasTypeElement()) {
            this.composeEnum(t, "Consent", "type", element.getTypeElement(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "Consent", "period", element.getPeriod(), -1);
        }
        for (i = 0; i < element.getActor().size(); ++i) {
            this.composeConsentprovisionActorComponent(t, "Consent", "actor", element.getActor().get(i), i);
        }
        for (i = 0; i < element.getAction().size(); ++i) {
            this.composeCodeableConcept(t, "Consent", "action", element.getAction().get(i), i);
        }
        for (i = 0; i < element.getSecurityLabel().size(); ++i) {
            this.composeCoding(t, "Consent", "securityLabel", element.getSecurityLabel().get(i), i);
        }
        for (i = 0; i < element.getPurpose().size(); ++i) {
            this.composeCoding(t, "Consent", "purpose", element.getPurpose().get(i), i);
        }
        for (i = 0; i < element.getClass_().size(); ++i) {
            this.composeCoding(t, "Consent", "class", element.getClass_().get(i), i);
        }
        for (i = 0; i < element.getCode().size(); ++i) {
            this.composeCodeableConcept(t, "Consent", "code", element.getCode().get(i), i);
        }
        if (element.hasDataPeriod()) {
            this.composePeriod(t, "Consent", "dataPeriod", element.getDataPeriod(), -1);
        }
        for (i = 0; i < element.getData().size(); ++i) {
            this.composeConsentprovisionDataComponent(t, "Consent", "data", element.getData().get(i), i);
        }
        for (i = 0; i < element.getProvision().size(); ++i) {
            this.composeConsentprovisionComponent(t, "Consent", "provision", element.getProvision().get(i), i);
        }
    }

    protected void composeConsentprovisionActorComponent(Turtle.Complex parent, String parentType, String name, Consent.provisionActorComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "actor", name, element, index);
        if (element.hasRole()) {
            this.composeCodeableConcept(t, "Consent", "role", element.getRole(), -1);
        }
        if (element.hasReference()) {
            this.composeReference(t, "Consent", "reference", element.getReference(), -1);
        }
    }

    protected void composeConsentprovisionDataComponent(Turtle.Complex parent, String parentType, String name, Consent.provisionDataComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "data", name, element, index);
        if (element.hasMeaningElement()) {
            this.composeEnum(t, "Consent", "meaning", element.getMeaningElement(), -1);
        }
        if (element.hasReference()) {
            this.composeReference(t, "Consent", "reference", element.getReference(), -1);
        }
    }

    protected void composeContract(Turtle.Complex parent, String parentType, String name, Contract element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Contract", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Contract", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasUrlElement()) {
            this.composeUri(t, "Contract", "url", element.getUrlElement(), -1);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "Contract", "version", element.getVersionElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Contract", "status", element.getStatusElement(), -1);
        }
        if (element.hasLegalState()) {
            this.composeCodeableConcept(t, "Contract", "legalState", element.getLegalState(), -1);
        }
        if (element.hasInstantiatesCanonical()) {
            this.composeReference(t, "Contract", "instantiatesCanonical", element.getInstantiatesCanonical(), -1);
        }
        if (element.hasInstantiatesUriElement()) {
            this.composeUri(t, "Contract", "instantiatesUri", element.getInstantiatesUriElement(), -1);
        }
        if (element.hasContentDerivative()) {
            this.composeCodeableConcept(t, "Contract", "contentDerivative", element.getContentDerivative(), -1);
        }
        if (element.hasIssuedElement()) {
            this.composeDateTime(t, "Contract", "issued", element.getIssuedElement(), -1);
        }
        if (element.hasApplies()) {
            this.composePeriod(t, "Contract", "applies", element.getApplies(), -1);
        }
        if (element.hasExpirationType()) {
            this.composeCodeableConcept(t, "Contract", "expirationType", element.getExpirationType(), -1);
        }
        for (i = 0; i < element.getSubject().size(); ++i) {
            this.composeReference(t, "Contract", "subject", element.getSubject().get(i), i);
        }
        for (i = 0; i < element.getAuthority().size(); ++i) {
            this.composeReference(t, "Contract", "authority", element.getAuthority().get(i), i);
        }
        for (i = 0; i < element.getDomain().size(); ++i) {
            this.composeReference(t, "Contract", "domain", element.getDomain().get(i), i);
        }
        for (i = 0; i < element.getSite().size(); ++i) {
            this.composeReference(t, "Contract", "site", element.getSite().get(i), i);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "Contract", "name", element.getNameElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "Contract", "title", element.getTitleElement(), -1);
        }
        if (element.hasSubtitleElement()) {
            this.composeString(t, "Contract", "subtitle", element.getSubtitleElement(), -1);
        }
        for (i = 0; i < element.getAlias().size(); ++i) {
            this.composeString(t, "Contract", "alias", element.getAlias().get(i), i);
        }
        if (element.hasAuthor()) {
            this.composeReference(t, "Contract", "author", element.getAuthor(), -1);
        }
        if (element.hasScope()) {
            this.composeCodeableConcept(t, "Contract", "scope", element.getScope(), -1);
        }
        if (element.hasTopic()) {
            this.composeType(t, "Contract", "topic", element.getTopic(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "Contract", "type", element.getType(), -1);
        }
        for (i = 0; i < element.getSubType().size(); ++i) {
            this.composeCodeableConcept(t, "Contract", "subType", element.getSubType().get(i), i);
        }
        if (element.hasContentDefinition()) {
            this.composeContractContentDefinitionComponent(t, "Contract", "contentDefinition", element.getContentDefinition(), -1);
        }
        for (i = 0; i < element.getTerm().size(); ++i) {
            this.composeContractTermComponent(t, "Contract", "term", element.getTerm().get(i), i);
        }
        for (i = 0; i < element.getSupportingInfo().size(); ++i) {
            this.composeReference(t, "Contract", "supportingInfo", element.getSupportingInfo().get(i), i);
        }
        for (i = 0; i < element.getRelevantHistory().size(); ++i) {
            this.composeReference(t, "Contract", "relevantHistory", element.getRelevantHistory().get(i), i);
        }
        for (i = 0; i < element.getSigner().size(); ++i) {
            this.composeContractSignatoryComponent(t, "Contract", "signer", element.getSigner().get(i), i);
        }
        for (i = 0; i < element.getFriendly().size(); ++i) {
            this.composeContractFriendlyLanguageComponent(t, "Contract", "friendly", element.getFriendly().get(i), i);
        }
        for (i = 0; i < element.getLegal().size(); ++i) {
            this.composeContractLegalLanguageComponent(t, "Contract", "legal", element.getLegal().get(i), i);
        }
        for (i = 0; i < element.getRule().size(); ++i) {
            this.composeContractComputableLanguageComponent(t, "Contract", "rule", element.getRule().get(i), i);
        }
        if (element.hasLegallyBinding()) {
            this.composeType(t, "Contract", "legallyBinding", element.getLegallyBinding(), -1);
        }
    }

    protected void composeContractContentDefinitionComponent(Turtle.Complex parent, String parentType, String name, Contract.ContentDefinitionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "contentDefinition", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "Contract", "type", element.getType(), -1);
        }
        if (element.hasSubType()) {
            this.composeCodeableConcept(t, "Contract", "subType", element.getSubType(), -1);
        }
        if (element.hasPublisher()) {
            this.composeReference(t, "Contract", "publisher", element.getPublisher(), -1);
        }
        if (element.hasPublicationDateElement()) {
            this.composeDateTime(t, "Contract", "publicationDate", element.getPublicationDateElement(), -1);
        }
        if (element.hasPublicationStatusElement()) {
            this.composeEnum(t, "Contract", "publicationStatus", element.getPublicationStatusElement(), -1);
        }
        if (element.hasCopyrightElement()) {
            this.composeMarkdown(t, "Contract", "copyright", element.getCopyrightElement(), -1);
        }
    }

    protected void composeContractTermComponent(Turtle.Complex parent, String parentType, String name, Contract.TermComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "term", name, element, index);
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "Contract", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasIssuedElement()) {
            this.composeDateTime(t, "Contract", "issued", element.getIssuedElement(), -1);
        }
        if (element.hasApplies()) {
            this.composePeriod(t, "Contract", "applies", element.getApplies(), -1);
        }
        if (element.hasTopic()) {
            this.composeType(t, "Contract", "topic", element.getTopic(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "Contract", "type", element.getType(), -1);
        }
        if (element.hasSubType()) {
            this.composeCodeableConcept(t, "Contract", "subType", element.getSubType(), -1);
        }
        if (element.hasTextElement()) {
            this.composeString(t, "Contract", "text", element.getTextElement(), -1);
        }
        for (i = 0; i < element.getSecurityLabel().size(); ++i) {
            this.composeContractSecurityLabelComponent(t, "Contract", "securityLabel", element.getSecurityLabel().get(i), i);
        }
        if (element.hasOffer()) {
            this.composeContractContractOfferComponent(t, "Contract", "offer", element.getOffer(), -1);
        }
        for (i = 0; i < element.getAsset().size(); ++i) {
            this.composeContractContractAssetComponent(t, "Contract", "asset", element.getAsset().get(i), i);
        }
        for (i = 0; i < element.getAction().size(); ++i) {
            this.composeContractActionComponent(t, "Contract", "action", element.getAction().get(i), i);
        }
        for (i = 0; i < element.getGroup().size(); ++i) {
            this.composeContractTermComponent(t, "Contract", "group", element.getGroup().get(i), i);
        }
    }

    protected void composeContractSecurityLabelComponent(Turtle.Complex parent, String parentType, String name, Contract.SecurityLabelComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "securityLabel", name, element, index);
        for (i = 0; i < element.getNumber().size(); ++i) {
            this.composeUnsignedInt(t, "Contract", "number", element.getNumber().get(i), i);
        }
        if (element.hasClassification()) {
            this.composeCoding(t, "Contract", "classification", element.getClassification(), -1);
        }
        for (i = 0; i < element.getCategory().size(); ++i) {
            this.composeCoding(t, "Contract", "category", element.getCategory().get(i), i);
        }
        for (i = 0; i < element.getControl().size(); ++i) {
            this.composeCoding(t, "Contract", "control", element.getControl().get(i), i);
        }
    }

    protected void composeContractContractOfferComponent(Turtle.Complex parent, String parentType, String name, Contract.ContractOfferComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "offer", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Contract", "identifier", element.getIdentifier().get(i), i);
        }
        for (i = 0; i < element.getParty().size(); ++i) {
            this.composeContractContractPartyComponent(t, "Contract", "party", element.getParty().get(i), i);
        }
        if (element.hasTopic()) {
            this.composeReference(t, "Contract", "topic", element.getTopic(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "Contract", "type", element.getType(), -1);
        }
        if (element.hasDecision()) {
            this.composeCodeableConcept(t, "Contract", "decision", element.getDecision(), -1);
        }
        for (i = 0; i < element.getDecisionMode().size(); ++i) {
            this.composeCodeableConcept(t, "Contract", "decisionMode", element.getDecisionMode().get(i), i);
        }
        for (i = 0; i < element.getAnswer().size(); ++i) {
            this.composeContractAnswerComponent(t, "Contract", "answer", element.getAnswer().get(i), i);
        }
        if (element.hasTextElement()) {
            this.composeString(t, "Contract", "text", element.getTextElement(), -1);
        }
        for (i = 0; i < element.getLinkId().size(); ++i) {
            this.composeString(t, "Contract", "linkId", element.getLinkId().get(i), i);
        }
        for (i = 0; i < element.getSecurityLabelNumber().size(); ++i) {
            this.composeUnsignedInt(t, "Contract", "securityLabelNumber", element.getSecurityLabelNumber().get(i), i);
        }
    }

    protected void composeContractContractPartyComponent(Turtle.Complex parent, String parentType, String name, Contract.ContractPartyComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "party", name, element, index);
        for (int i = 0; i < element.getReference().size(); ++i) {
            this.composeReference(t, "Contract", "reference", element.getReference().get(i), i);
        }
        if (element.hasRole()) {
            this.composeCodeableConcept(t, "Contract", "role", element.getRole(), -1);
        }
    }

    protected void composeContractAnswerComponent(Turtle.Complex parent, String parentType, String name, Contract.AnswerComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "answer", name, element, index);
        if (element.hasValue()) {
            this.composeType(t, "Contract", "value", element.getValue(), -1);
        }
    }

    protected void composeContractContractAssetComponent(Turtle.Complex parent, String parentType, String name, Contract.ContractAssetComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "asset", name, element, index);
        if (element.hasScope()) {
            this.composeCodeableConcept(t, "Contract", "scope", element.getScope(), -1);
        }
        for (i = 0; i < element.getType().size(); ++i) {
            this.composeCodeableConcept(t, "Contract", "type", element.getType().get(i), i);
        }
        for (i = 0; i < element.getTypeReference().size(); ++i) {
            this.composeReference(t, "Contract", "typeReference", element.getTypeReference().get(i), i);
        }
        for (i = 0; i < element.getSubtype().size(); ++i) {
            this.composeCodeableConcept(t, "Contract", "subtype", element.getSubtype().get(i), i);
        }
        if (element.hasRelationship()) {
            this.composeCoding(t, "Contract", "relationship", element.getRelationship(), -1);
        }
        for (i = 0; i < element.getContext().size(); ++i) {
            this.composeContractAssetContextComponent(t, "Contract", "context", element.getContext().get(i), i);
        }
        if (element.hasConditionElement()) {
            this.composeString(t, "Contract", "condition", element.getConditionElement(), -1);
        }
        for (i = 0; i < element.getPeriodType().size(); ++i) {
            this.composeCodeableConcept(t, "Contract", "periodType", element.getPeriodType().get(i), i);
        }
        for (i = 0; i < element.getPeriod().size(); ++i) {
            this.composePeriod(t, "Contract", "period", element.getPeriod().get(i), i);
        }
        for (i = 0; i < element.getUsePeriod().size(); ++i) {
            this.composePeriod(t, "Contract", "usePeriod", element.getUsePeriod().get(i), i);
        }
        if (element.hasTextElement()) {
            this.composeString(t, "Contract", "text", element.getTextElement(), -1);
        }
        for (i = 0; i < element.getLinkId().size(); ++i) {
            this.composeString(t, "Contract", "linkId", element.getLinkId().get(i), i);
        }
        for (i = 0; i < element.getAnswer().size(); ++i) {
            this.composeContractAnswerComponent(t, "Contract", "answer", element.getAnswer().get(i), i);
        }
        for (i = 0; i < element.getSecurityLabelNumber().size(); ++i) {
            this.composeUnsignedInt(t, "Contract", "securityLabelNumber", element.getSecurityLabelNumber().get(i), i);
        }
        for (i = 0; i < element.getValuedItem().size(); ++i) {
            this.composeContractValuedItemComponent(t, "Contract", "valuedItem", element.getValuedItem().get(i), i);
        }
    }

    protected void composeContractAssetContextComponent(Turtle.Complex parent, String parentType, String name, Contract.AssetContextComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "context", name, element, index);
        if (element.hasReference()) {
            this.composeReference(t, "Contract", "reference", element.getReference(), -1);
        }
        for (int i = 0; i < element.getCode().size(); ++i) {
            this.composeCodeableConcept(t, "Contract", "code", element.getCode().get(i), i);
        }
        if (element.hasTextElement()) {
            this.composeString(t, "Contract", "text", element.getTextElement(), -1);
        }
    }

    protected void composeContractValuedItemComponent(Turtle.Complex parent, String parentType, String name, Contract.ValuedItemComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "valuedItem", name, element, index);
        if (element.hasEntity()) {
            this.composeType(t, "Contract", "entity", element.getEntity(), -1);
        }
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "Contract", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasEffectiveTimeElement()) {
            this.composeDateTime(t, "Contract", "effectiveTime", element.getEffectiveTimeElement(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "Contract", "quantity", element.getQuantity(), -1);
        }
        if (element.hasUnitPrice()) {
            this.composeMoney(t, "Contract", "unitPrice", element.getUnitPrice(), -1);
        }
        if (element.hasFactorElement()) {
            this.composeDecimal(t, "Contract", "factor", element.getFactorElement(), -1);
        }
        if (element.hasPointsElement()) {
            this.composeDecimal(t, "Contract", "points", element.getPointsElement(), -1);
        }
        if (element.hasNet()) {
            this.composeMoney(t, "Contract", "net", element.getNet(), -1);
        }
        if (element.hasPaymentElement()) {
            this.composeString(t, "Contract", "payment", element.getPaymentElement(), -1);
        }
        if (element.hasPaymentDateElement()) {
            this.composeDateTime(t, "Contract", "paymentDate", element.getPaymentDateElement(), -1);
        }
        if (element.hasResponsible()) {
            this.composeReference(t, "Contract", "responsible", element.getResponsible(), -1);
        }
        if (element.hasRecipient()) {
            this.composeReference(t, "Contract", "recipient", element.getRecipient(), -1);
        }
        for (i = 0; i < element.getLinkId().size(); ++i) {
            this.composeString(t, "Contract", "linkId", element.getLinkId().get(i), i);
        }
        for (i = 0; i < element.getSecurityLabelNumber().size(); ++i) {
            this.composeUnsignedInt(t, "Contract", "securityLabelNumber", element.getSecurityLabelNumber().get(i), i);
        }
    }

    protected void composeContractActionComponent(Turtle.Complex parent, String parentType, String name, Contract.ActionComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "action", name, element, index);
        if (element.hasDoNotPerformElement()) {
            this.composeBoolean(t, "Contract", "doNotPerform", element.getDoNotPerformElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "Contract", "type", element.getType(), -1);
        }
        for (i = 0; i < element.getSubject().size(); ++i) {
            this.composeContractActionSubjectComponent(t, "Contract", "subject", element.getSubject().get(i), i);
        }
        if (element.hasIntent()) {
            this.composeCodeableConcept(t, "Contract", "intent", element.getIntent(), -1);
        }
        for (i = 0; i < element.getLinkId().size(); ++i) {
            this.composeString(t, "Contract", "linkId", element.getLinkId().get(i), i);
        }
        if (element.hasStatus()) {
            this.composeCodeableConcept(t, "Contract", "status", element.getStatus(), -1);
        }
        if (element.hasContext()) {
            this.composeReference(t, "Contract", "context", element.getContext(), -1);
        }
        for (i = 0; i < element.getContextLinkId().size(); ++i) {
            this.composeString(t, "Contract", "contextLinkId", element.getContextLinkId().get(i), i);
        }
        if (element.hasOccurrence()) {
            this.composeType(t, "Contract", "occurrence", element.getOccurrence(), -1);
        }
        for (i = 0; i < element.getRequester().size(); ++i) {
            this.composeReference(t, "Contract", "requester", element.getRequester().get(i), i);
        }
        for (i = 0; i < element.getRequesterLinkId().size(); ++i) {
            this.composeString(t, "Contract", "requesterLinkId", element.getRequesterLinkId().get(i), i);
        }
        for (i = 0; i < element.getPerformerType().size(); ++i) {
            this.composeCodeableConcept(t, "Contract", "performerType", element.getPerformerType().get(i), i);
        }
        if (element.hasPerformerRole()) {
            this.composeCodeableConcept(t, "Contract", "performerRole", element.getPerformerRole(), -1);
        }
        if (element.hasPerformer()) {
            this.composeReference(t, "Contract", "performer", element.getPerformer(), -1);
        }
        for (i = 0; i < element.getPerformerLinkId().size(); ++i) {
            this.composeString(t, "Contract", "performerLinkId", element.getPerformerLinkId().get(i), i);
        }
        for (i = 0; i < element.getReasonCode().size(); ++i) {
            this.composeCodeableConcept(t, "Contract", "reasonCode", element.getReasonCode().get(i), i);
        }
        for (i = 0; i < element.getReasonReference().size(); ++i) {
            this.composeReference(t, "Contract", "reasonReference", element.getReasonReference().get(i), i);
        }
        for (i = 0; i < element.getReason().size(); ++i) {
            this.composeString(t, "Contract", "reason", element.getReason().get(i), i);
        }
        for (i = 0; i < element.getReasonLinkId().size(); ++i) {
            this.composeString(t, "Contract", "reasonLinkId", element.getReasonLinkId().get(i), i);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "Contract", "note", element.getNote().get(i), i);
        }
        for (i = 0; i < element.getSecurityLabelNumber().size(); ++i) {
            this.composeUnsignedInt(t, "Contract", "securityLabelNumber", element.getSecurityLabelNumber().get(i), i);
        }
    }

    protected void composeContractActionSubjectComponent(Turtle.Complex parent, String parentType, String name, Contract.ActionSubjectComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "subject", name, element, index);
        for (int i = 0; i < element.getReference().size(); ++i) {
            this.composeReference(t, "Contract", "reference", element.getReference().get(i), i);
        }
        if (element.hasRole()) {
            this.composeCodeableConcept(t, "Contract", "role", element.getRole(), -1);
        }
    }

    protected void composeContractSignatoryComponent(Turtle.Complex parent, String parentType, String name, Contract.SignatoryComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "signer", name, element, index);
        if (element.hasType()) {
            this.composeCoding(t, "Contract", "type", element.getType(), -1);
        }
        if (element.hasParty()) {
            this.composeReference(t, "Contract", "party", element.getParty(), -1);
        }
        for (int i = 0; i < element.getSignature().size(); ++i) {
            this.composeSignature(t, "Contract", "signature", element.getSignature().get(i), i);
        }
    }

    protected void composeContractFriendlyLanguageComponent(Turtle.Complex parent, String parentType, String name, Contract.FriendlyLanguageComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "friendly", name, element, index);
        if (element.hasContent()) {
            this.composeType(t, "Contract", "content", element.getContent(), -1);
        }
    }

    protected void composeContractLegalLanguageComponent(Turtle.Complex parent, String parentType, String name, Contract.LegalLanguageComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "legal", name, element, index);
        if (element.hasContent()) {
            this.composeType(t, "Contract", "content", element.getContent(), -1);
        }
    }

    protected void composeContractComputableLanguageComponent(Turtle.Complex parent, String parentType, String name, Contract.ComputableLanguageComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "rule", name, element, index);
        if (element.hasContent()) {
            this.composeType(t, "Contract", "content", element.getContent(), -1);
        }
    }

    protected void composeCoverage(Turtle.Complex parent, String parentType, String name, Coverage element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Coverage", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Coverage", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Coverage", "status", element.getStatusElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "Coverage", "type", element.getType(), -1);
        }
        if (element.hasPolicyHolder()) {
            this.composeReference(t, "Coverage", "policyHolder", element.getPolicyHolder(), -1);
        }
        if (element.hasSubscriber()) {
            this.composeReference(t, "Coverage", "subscriber", element.getSubscriber(), -1);
        }
        if (element.hasSubscriberIdElement()) {
            this.composeString(t, "Coverage", "subscriberId", element.getSubscriberIdElement(), -1);
        }
        if (element.hasBeneficiary()) {
            this.composeReference(t, "Coverage", "beneficiary", element.getBeneficiary(), -1);
        }
        if (element.hasDependentElement()) {
            this.composeString(t, "Coverage", "dependent", element.getDependentElement(), -1);
        }
        if (element.hasRelationship()) {
            this.composeCodeableConcept(t, "Coverage", "relationship", element.getRelationship(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "Coverage", "period", element.getPeriod(), -1);
        }
        for (i = 0; i < element.getPayor().size(); ++i) {
            this.composeReference(t, "Coverage", "payor", element.getPayor().get(i), i);
        }
        for (i = 0; i < element.getClass_().size(); ++i) {
            this.composeCoverageClassComponent(t, "Coverage", "class", element.getClass_().get(i), i);
        }
        if (element.hasOrderElement()) {
            this.composePositiveInt(t, "Coverage", "order", element.getOrderElement(), -1);
        }
        if (element.hasNetworkElement()) {
            this.composeString(t, "Coverage", "network", element.getNetworkElement(), -1);
        }
        for (i = 0; i < element.getCostToBeneficiary().size(); ++i) {
            this.composeCoverageCostToBeneficiaryComponent(t, "Coverage", "costToBeneficiary", element.getCostToBeneficiary().get(i), i);
        }
        if (element.hasSubrogationElement()) {
            this.composeBoolean(t, "Coverage", "subrogation", element.getSubrogationElement(), -1);
        }
        for (i = 0; i < element.getContract().size(); ++i) {
            this.composeReference(t, "Coverage", "contract", element.getContract().get(i), i);
        }
    }

    protected void composeCoverageClassComponent(Turtle.Complex parent, String parentType, String name, Coverage.ClassComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "class", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "Coverage", "type", element.getType(), -1);
        }
        if (element.hasValueElement()) {
            this.composeString(t, "Coverage", "value", element.getValueElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "Coverage", "name", element.getNameElement(), -1);
        }
    }

    protected void composeCoverageCostToBeneficiaryComponent(Turtle.Complex parent, String parentType, String name, Coverage.CostToBeneficiaryComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "costToBeneficiary", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "Coverage", "type", element.getType(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "Coverage", "value", element.getValue(), -1);
        }
        for (int i = 0; i < element.getException().size(); ++i) {
            this.composeCoverageExemptionComponent(t, "Coverage", "exception", element.getException().get(i), i);
        }
    }

    protected void composeCoverageExemptionComponent(Turtle.Complex parent, String parentType, String name, Coverage.ExemptionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "exception", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "Coverage", "type", element.getType(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "Coverage", "period", element.getPeriod(), -1);
        }
    }

    protected void composeCoverageEligibilityRequest(Turtle.Complex parent, String parentType, String name, CoverageEligibilityRequest element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "CoverageEligibilityRequest", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "CoverageEligibilityRequest", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "CoverageEligibilityRequest", "status", element.getStatusElement(), -1);
        }
        if (element.hasPriority()) {
            this.composeCodeableConcept(t, "CoverageEligibilityRequest", "priority", element.getPriority(), -1);
        }
        for (i = 0; i < element.getPurpose().size(); ++i) {
            this.composeEnum(t, "CoverageEligibilityRequest", "purpose", element.getPurpose().get(i), i);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "CoverageEligibilityRequest", "patient", element.getPatient(), -1);
        }
        if (element.hasServiced()) {
            this.composeType(t, "CoverageEligibilityRequest", "serviced", element.getServiced(), -1);
        }
        if (element.hasCreatedElement()) {
            this.composeDateTime(t, "CoverageEligibilityRequest", "created", element.getCreatedElement(), -1);
        }
        if (element.hasEnterer()) {
            this.composeReference(t, "CoverageEligibilityRequest", "enterer", element.getEnterer(), -1);
        }
        if (element.hasProvider()) {
            this.composeReference(t, "CoverageEligibilityRequest", "provider", element.getProvider(), -1);
        }
        if (element.hasInsurer()) {
            this.composeReference(t, "CoverageEligibilityRequest", "insurer", element.getInsurer(), -1);
        }
        if (element.hasFacility()) {
            this.composeReference(t, "CoverageEligibilityRequest", "facility", element.getFacility(), -1);
        }
        for (i = 0; i < element.getSupportingInfo().size(); ++i) {
            this.composeCoverageEligibilityRequestSupportingInformationComponent(t, "CoverageEligibilityRequest", "supportingInfo", element.getSupportingInfo().get(i), i);
        }
        for (i = 0; i < element.getInsurance().size(); ++i) {
            this.composeCoverageEligibilityRequestInsuranceComponent(t, "CoverageEligibilityRequest", "insurance", element.getInsurance().get(i), i);
        }
        for (i = 0; i < element.getItem().size(); ++i) {
            this.composeCoverageEligibilityRequestDetailsComponent(t, "CoverageEligibilityRequest", "item", element.getItem().get(i), i);
        }
    }

    protected void composeCoverageEligibilityRequestSupportingInformationComponent(Turtle.Complex parent, String parentType, String name, CoverageEligibilityRequest.SupportingInformationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "supportingInfo", name, element, index);
        if (element.hasSequenceElement()) {
            this.composePositiveInt(t, "CoverageEligibilityRequest", "sequence", element.getSequenceElement(), -1);
        }
        if (element.hasInformation()) {
            this.composeReference(t, "CoverageEligibilityRequest", "information", element.getInformation(), -1);
        }
        if (element.hasAppliesToAllElement()) {
            this.composeBoolean(t, "CoverageEligibilityRequest", "appliesToAll", element.getAppliesToAllElement(), -1);
        }
    }

    protected void composeCoverageEligibilityRequestInsuranceComponent(Turtle.Complex parent, String parentType, String name, CoverageEligibilityRequest.InsuranceComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "insurance", name, element, index);
        if (element.hasFocalElement()) {
            this.composeBoolean(t, "CoverageEligibilityRequest", "focal", element.getFocalElement(), -1);
        }
        if (element.hasCoverage()) {
            this.composeReference(t, "CoverageEligibilityRequest", "coverage", element.getCoverage(), -1);
        }
        if (element.hasBusinessArrangementElement()) {
            this.composeString(t, "CoverageEligibilityRequest", "businessArrangement", element.getBusinessArrangementElement(), -1);
        }
    }

    protected void composeCoverageEligibilityRequestDetailsComponent(Turtle.Complex parent, String parentType, String name, CoverageEligibilityRequest.DetailsComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "item", name, element, index);
        for (i = 0; i < element.getSupportingInfoSequence().size(); ++i) {
            this.composePositiveInt(t, "CoverageEligibilityRequest", "supportingInfoSequence", element.getSupportingInfoSequence().get(i), i);
        }
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "CoverageEligibilityRequest", "category", element.getCategory(), -1);
        }
        if (element.hasProductOrService()) {
            this.composeCodeableConcept(t, "CoverageEligibilityRequest", "productOrService", element.getProductOrService(), -1);
        }
        for (i = 0; i < element.getModifier().size(); ++i) {
            this.composeCodeableConcept(t, "CoverageEligibilityRequest", "modifier", element.getModifier().get(i), i);
        }
        if (element.hasProvider()) {
            this.composeReference(t, "CoverageEligibilityRequest", "provider", element.getProvider(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "CoverageEligibilityRequest", "quantity", element.getQuantity(), -1);
        }
        if (element.hasUnitPrice()) {
            this.composeMoney(t, "CoverageEligibilityRequest", "unitPrice", element.getUnitPrice(), -1);
        }
        if (element.hasFacility()) {
            this.composeReference(t, "CoverageEligibilityRequest", "facility", element.getFacility(), -1);
        }
        for (i = 0; i < element.getDiagnosis().size(); ++i) {
            this.composeCoverageEligibilityRequestDiagnosisComponent(t, "CoverageEligibilityRequest", "diagnosis", element.getDiagnosis().get(i), i);
        }
        for (i = 0; i < element.getDetail().size(); ++i) {
            this.composeReference(t, "CoverageEligibilityRequest", "detail", element.getDetail().get(i), i);
        }
    }

    protected void composeCoverageEligibilityRequestDiagnosisComponent(Turtle.Complex parent, String parentType, String name, CoverageEligibilityRequest.DiagnosisComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "diagnosis", name, element, index);
        if (element.hasDiagnosis()) {
            this.composeType(t, "CoverageEligibilityRequest", "diagnosis", element.getDiagnosis(), -1);
        }
    }

    protected void composeCoverageEligibilityResponse(Turtle.Complex parent, String parentType, String name, CoverageEligibilityResponse element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "CoverageEligibilityResponse", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "CoverageEligibilityResponse", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "CoverageEligibilityResponse", "status", element.getStatusElement(), -1);
        }
        for (i = 0; i < element.getPurpose().size(); ++i) {
            this.composeEnum(t, "CoverageEligibilityResponse", "purpose", element.getPurpose().get(i), i);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "CoverageEligibilityResponse", "patient", element.getPatient(), -1);
        }
        if (element.hasServiced()) {
            this.composeType(t, "CoverageEligibilityResponse", "serviced", element.getServiced(), -1);
        }
        if (element.hasCreatedElement()) {
            this.composeDateTime(t, "CoverageEligibilityResponse", "created", element.getCreatedElement(), -1);
        }
        if (element.hasRequestor()) {
            this.composeReference(t, "CoverageEligibilityResponse", "requestor", element.getRequestor(), -1);
        }
        if (element.hasRequest()) {
            this.composeReference(t, "CoverageEligibilityResponse", "request", element.getRequest(), -1);
        }
        if (element.hasOutcomeElement()) {
            this.composeEnum(t, "CoverageEligibilityResponse", "outcome", element.getOutcomeElement(), -1);
        }
        if (element.hasDispositionElement()) {
            this.composeString(t, "CoverageEligibilityResponse", "disposition", element.getDispositionElement(), -1);
        }
        if (element.hasInsurer()) {
            this.composeReference(t, "CoverageEligibilityResponse", "insurer", element.getInsurer(), -1);
        }
        for (i = 0; i < element.getInsurance().size(); ++i) {
            this.composeCoverageEligibilityResponseInsuranceComponent(t, "CoverageEligibilityResponse", "insurance", element.getInsurance().get(i), i);
        }
        if (element.hasPreAuthRefElement()) {
            this.composeString(t, "CoverageEligibilityResponse", "preAuthRef", element.getPreAuthRefElement(), -1);
        }
        if (element.hasForm()) {
            this.composeCodeableConcept(t, "CoverageEligibilityResponse", "form", element.getForm(), -1);
        }
        for (i = 0; i < element.getError().size(); ++i) {
            this.composeCoverageEligibilityResponseErrorsComponent(t, "CoverageEligibilityResponse", "error", element.getError().get(i), i);
        }
    }

    protected void composeCoverageEligibilityResponseInsuranceComponent(Turtle.Complex parent, String parentType, String name, CoverageEligibilityResponse.InsuranceComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "insurance", name, element, index);
        if (element.hasCoverage()) {
            this.composeReference(t, "CoverageEligibilityResponse", "coverage", element.getCoverage(), -1);
        }
        if (element.hasInforceElement()) {
            this.composeBoolean(t, "CoverageEligibilityResponse", "inforce", element.getInforceElement(), -1);
        }
        if (element.hasBenefitPeriod()) {
            this.composePeriod(t, "CoverageEligibilityResponse", "benefitPeriod", element.getBenefitPeriod(), -1);
        }
        for (int i = 0; i < element.getItem().size(); ++i) {
            this.composeCoverageEligibilityResponseItemsComponent(t, "CoverageEligibilityResponse", "item", element.getItem().get(i), i);
        }
    }

    protected void composeCoverageEligibilityResponseItemsComponent(Turtle.Complex parent, String parentType, String name, CoverageEligibilityResponse.ItemsComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "item", name, element, index);
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "CoverageEligibilityResponse", "category", element.getCategory(), -1);
        }
        if (element.hasProductOrService()) {
            this.composeCodeableConcept(t, "CoverageEligibilityResponse", "productOrService", element.getProductOrService(), -1);
        }
        for (i = 0; i < element.getModifier().size(); ++i) {
            this.composeCodeableConcept(t, "CoverageEligibilityResponse", "modifier", element.getModifier().get(i), i);
        }
        if (element.hasProvider()) {
            this.composeReference(t, "CoverageEligibilityResponse", "provider", element.getProvider(), -1);
        }
        if (element.hasExcludedElement()) {
            this.composeBoolean(t, "CoverageEligibilityResponse", "excluded", element.getExcludedElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "CoverageEligibilityResponse", "name", element.getNameElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "CoverageEligibilityResponse", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasNetwork()) {
            this.composeCodeableConcept(t, "CoverageEligibilityResponse", "network", element.getNetwork(), -1);
        }
        if (element.hasUnit()) {
            this.composeCodeableConcept(t, "CoverageEligibilityResponse", "unit", element.getUnit(), -1);
        }
        if (element.hasTerm()) {
            this.composeCodeableConcept(t, "CoverageEligibilityResponse", "term", element.getTerm(), -1);
        }
        for (i = 0; i < element.getBenefit().size(); ++i) {
            this.composeCoverageEligibilityResponseBenefitComponent(t, "CoverageEligibilityResponse", "benefit", element.getBenefit().get(i), i);
        }
        if (element.hasAuthorizationRequiredElement()) {
            this.composeBoolean(t, "CoverageEligibilityResponse", "authorizationRequired", element.getAuthorizationRequiredElement(), -1);
        }
        for (i = 0; i < element.getAuthorizationSupporting().size(); ++i) {
            this.composeCodeableConcept(t, "CoverageEligibilityResponse", "authorizationSupporting", element.getAuthorizationSupporting().get(i), i);
        }
        if (element.hasAuthorizationUrlElement()) {
            this.composeUri(t, "CoverageEligibilityResponse", "authorizationUrl", element.getAuthorizationUrlElement(), -1);
        }
    }

    protected void composeCoverageEligibilityResponseBenefitComponent(Turtle.Complex parent, String parentType, String name, CoverageEligibilityResponse.BenefitComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "benefit", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "CoverageEligibilityResponse", "type", element.getType(), -1);
        }
        if (element.hasAllowed()) {
            this.composeType(t, "CoverageEligibilityResponse", "allowed", element.getAllowed(), -1);
        }
        if (element.hasUsed()) {
            this.composeType(t, "CoverageEligibilityResponse", "used", element.getUsed(), -1);
        }
    }

    protected void composeCoverageEligibilityResponseErrorsComponent(Turtle.Complex parent, String parentType, String name, CoverageEligibilityResponse.ErrorsComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "error", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "CoverageEligibilityResponse", "code", element.getCode(), -1);
        }
    }

    protected void composeDetectedIssue(Turtle.Complex parent, String parentType, String name, DetectedIssue element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "DetectedIssue", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "DetectedIssue", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "DetectedIssue", "status", element.getStatusElement(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "DetectedIssue", "code", element.getCode(), -1);
        }
        if (element.hasSeverityElement()) {
            this.composeEnum(t, "DetectedIssue", "severity", element.getSeverityElement(), -1);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "DetectedIssue", "patient", element.getPatient(), -1);
        }
        if (element.hasIdentified()) {
            this.composeType(t, "DetectedIssue", "identified", element.getIdentified(), -1);
        }
        if (element.hasAuthor()) {
            this.composeReference(t, "DetectedIssue", "author", element.getAuthor(), -1);
        }
        for (i = 0; i < element.getImplicated().size(); ++i) {
            this.composeReference(t, "DetectedIssue", "implicated", element.getImplicated().get(i), i);
        }
        for (i = 0; i < element.getEvidence().size(); ++i) {
            this.composeDetectedIssueDetectedIssueEvidenceComponent(t, "DetectedIssue", "evidence", element.getEvidence().get(i), i);
        }
        if (element.hasDetailElement()) {
            this.composeString(t, "DetectedIssue", "detail", element.getDetailElement(), -1);
        }
        if (element.hasReferenceElement()) {
            this.composeUri(t, "DetectedIssue", "reference", element.getReferenceElement(), -1);
        }
        for (i = 0; i < element.getMitigation().size(); ++i) {
            this.composeDetectedIssueDetectedIssueMitigationComponent(t, "DetectedIssue", "mitigation", element.getMitigation().get(i), i);
        }
    }

    protected void composeDetectedIssueDetectedIssueEvidenceComponent(Turtle.Complex parent, String parentType, String name, DetectedIssue.DetectedIssueEvidenceComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "evidence", name, element, index);
        for (i = 0; i < element.getCode().size(); ++i) {
            this.composeCodeableConcept(t, "DetectedIssue", "code", element.getCode().get(i), i);
        }
        for (i = 0; i < element.getDetail().size(); ++i) {
            this.composeReference(t, "DetectedIssue", "detail", element.getDetail().get(i), i);
        }
    }

    protected void composeDetectedIssueDetectedIssueMitigationComponent(Turtle.Complex parent, String parentType, String name, DetectedIssue.DetectedIssueMitigationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "mitigation", name, element, index);
        if (element.hasAction()) {
            this.composeCodeableConcept(t, "DetectedIssue", "action", element.getAction(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "DetectedIssue", "date", element.getDateElement(), -1);
        }
        if (element.hasAuthor()) {
            this.composeReference(t, "DetectedIssue", "author", element.getAuthor(), -1);
        }
    }

    protected void composeDevice(Turtle.Complex parent, String parentType, String name, Device element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Device", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Device", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasDefinition()) {
            this.composeReference(t, "Device", "definition", element.getDefinition(), -1);
        }
        for (i = 0; i < element.getUdiCarrier().size(); ++i) {
            this.composeDeviceDeviceUdiCarrierComponent(t, "Device", "udiCarrier", element.getUdiCarrier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Device", "status", element.getStatusElement(), -1);
        }
        for (i = 0; i < element.getStatusReason().size(); ++i) {
            this.composeCodeableConcept(t, "Device", "statusReason", element.getStatusReason().get(i), i);
        }
        if (element.hasDistinctIdentifierElement()) {
            this.composeString(t, "Device", "distinctIdentifier", element.getDistinctIdentifierElement(), -1);
        }
        if (element.hasManufacturerElement()) {
            this.composeString(t, "Device", "manufacturer", element.getManufacturerElement(), -1);
        }
        if (element.hasManufactureDateElement()) {
            this.composeDateTime(t, "Device", "manufactureDate", element.getManufactureDateElement(), -1);
        }
        if (element.hasExpirationDateElement()) {
            this.composeDateTime(t, "Device", "expirationDate", element.getExpirationDateElement(), -1);
        }
        if (element.hasLotNumberElement()) {
            this.composeString(t, "Device", "lotNumber", element.getLotNumberElement(), -1);
        }
        if (element.hasSerialNumberElement()) {
            this.composeString(t, "Device", "serialNumber", element.getSerialNumberElement(), -1);
        }
        for (i = 0; i < element.getDeviceName().size(); ++i) {
            this.composeDeviceDeviceDeviceNameComponent(t, "Device", "deviceName", element.getDeviceName().get(i), i);
        }
        if (element.hasModelNumberElement()) {
            this.composeString(t, "Device", "modelNumber", element.getModelNumberElement(), -1);
        }
        if (element.hasPartNumberElement()) {
            this.composeString(t, "Device", "partNumber", element.getPartNumberElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "Device", "type", element.getType(), -1);
        }
        for (i = 0; i < element.getSpecialization().size(); ++i) {
            this.composeDeviceDeviceSpecializationComponent(t, "Device", "specialization", element.getSpecialization().get(i), i);
        }
        for (i = 0; i < element.getVersion().size(); ++i) {
            this.composeDeviceDeviceVersionComponent(t, "Device", "version", element.getVersion().get(i), i);
        }
        for (i = 0; i < element.getProperty().size(); ++i) {
            this.composeDeviceDevicePropertyComponent(t, "Device", "property", element.getProperty().get(i), i);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "Device", "patient", element.getPatient(), -1);
        }
        if (element.hasOwner()) {
            this.composeReference(t, "Device", "owner", element.getOwner(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeContactPoint(t, "Device", "contact", element.getContact().get(i), i);
        }
        if (element.hasLocation()) {
            this.composeReference(t, "Device", "location", element.getLocation(), -1);
        }
        if (element.hasUrlElement()) {
            this.composeUri(t, "Device", "url", element.getUrlElement(), -1);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "Device", "note", element.getNote().get(i), i);
        }
        for (i = 0; i < element.getSafety().size(); ++i) {
            this.composeCodeableConcept(t, "Device", "safety", element.getSafety().get(i), i);
        }
        if (element.hasParent()) {
            this.composeReference(t, "Device", "parent", element.getParent(), -1);
        }
    }

    protected void composeDeviceDeviceUdiCarrierComponent(Turtle.Complex parent, String parentType, String name, Device.DeviceUdiCarrierComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "udiCarrier", name, element, index);
        if (element.hasDeviceIdentifierElement()) {
            this.composeString(t, "Device", "deviceIdentifier", element.getDeviceIdentifierElement(), -1);
        }
        if (element.hasIssuerElement()) {
            this.composeUri(t, "Device", "issuer", element.getIssuerElement(), -1);
        }
        if (element.hasJurisdictionElement()) {
            this.composeUri(t, "Device", "jurisdiction", element.getJurisdictionElement(), -1);
        }
        if (element.hasCarrierAIDCElement()) {
            this.composeBase64Binary(t, "Device", "carrierAIDC", element.getCarrierAIDCElement(), -1);
        }
        if (element.hasCarrierHRFElement()) {
            this.composeString(t, "Device", "carrierHRF", element.getCarrierHRFElement(), -1);
        }
        if (element.hasEntryTypeElement()) {
            this.composeEnum(t, "Device", "entryType", element.getEntryTypeElement(), -1);
        }
    }

    protected void composeDeviceDeviceDeviceNameComponent(Turtle.Complex parent, String parentType, String name, Device.DeviceDeviceNameComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "deviceName", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "Device", "name", element.getNameElement(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeEnum(t, "Device", "type", element.getTypeElement(), -1);
        }
    }

    protected void composeDeviceDeviceSpecializationComponent(Turtle.Complex parent, String parentType, String name, Device.DeviceSpecializationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "specialization", name, element, index);
        if (element.hasSystemType()) {
            this.composeCodeableConcept(t, "Device", "systemType", element.getSystemType(), -1);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "Device", "version", element.getVersionElement(), -1);
        }
    }

    protected void composeDeviceDeviceVersionComponent(Turtle.Complex parent, String parentType, String name, Device.DeviceVersionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "version", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "Device", "type", element.getType(), -1);
        }
        if (element.hasComponent()) {
            this.composeIdentifier(t, "Device", "component", element.getComponent(), -1);
        }
        if (element.hasValueElement()) {
            this.composeString(t, "Device", "value", element.getValueElement(), -1);
        }
    }

    protected void composeDeviceDevicePropertyComponent(Turtle.Complex parent, String parentType, String name, Device.DevicePropertyComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "property", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "Device", "type", element.getType(), -1);
        }
        for (i = 0; i < element.getValueQuantity().size(); ++i) {
            this.composeQuantity(t, "Device", "valueQuantity", element.getValueQuantity().get(i), i);
        }
        for (i = 0; i < element.getValueCode().size(); ++i) {
            this.composeCodeableConcept(t, "Device", "valueCode", element.getValueCode().get(i), i);
        }
    }

    protected void composeDeviceDefinition(Turtle.Complex parent, String parentType, String name, DeviceDefinition element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "DeviceDefinition", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "DeviceDefinition", "identifier", element.getIdentifier().get(i), i);
        }
        for (i = 0; i < element.getUdiDeviceIdentifier().size(); ++i) {
            this.composeDeviceDefinitionDeviceDefinitionUdiDeviceIdentifierComponent(t, "DeviceDefinition", "udiDeviceIdentifier", element.getUdiDeviceIdentifier().get(i), i);
        }
        if (element.hasManufacturer()) {
            this.composeType(t, "DeviceDefinition", "manufacturer", element.getManufacturer(), -1);
        }
        for (i = 0; i < element.getDeviceName().size(); ++i) {
            this.composeDeviceDefinitionDeviceDefinitionDeviceNameComponent(t, "DeviceDefinition", "deviceName", element.getDeviceName().get(i), i);
        }
        if (element.hasModelNumberElement()) {
            this.composeString(t, "DeviceDefinition", "modelNumber", element.getModelNumberElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "DeviceDefinition", "type", element.getType(), -1);
        }
        for (i = 0; i < element.getSpecialization().size(); ++i) {
            this.composeDeviceDefinitionDeviceDefinitionSpecializationComponent(t, "DeviceDefinition", "specialization", element.getSpecialization().get(i), i);
        }
        for (i = 0; i < element.getVersion().size(); ++i) {
            this.composeString(t, "DeviceDefinition", "version", element.getVersion().get(i), i);
        }
        for (i = 0; i < element.getSafety().size(); ++i) {
            this.composeCodeableConcept(t, "DeviceDefinition", "safety", element.getSafety().get(i), i);
        }
        for (i = 0; i < element.getShelfLifeStorage().size(); ++i) {
            this.composeProductShelfLife(t, "DeviceDefinition", "shelfLifeStorage", element.getShelfLifeStorage().get(i), i);
        }
        if (element.hasPhysicalCharacteristics()) {
            this.composeProdCharacteristic(t, "DeviceDefinition", "physicalCharacteristics", element.getPhysicalCharacteristics(), -1);
        }
        for (i = 0; i < element.getLanguageCode().size(); ++i) {
            this.composeCodeableConcept(t, "DeviceDefinition", "languageCode", element.getLanguageCode().get(i), i);
        }
        for (i = 0; i < element.getCapability().size(); ++i) {
            this.composeDeviceDefinitionDeviceDefinitionCapabilityComponent(t, "DeviceDefinition", "capability", element.getCapability().get(i), i);
        }
        for (i = 0; i < element.getProperty().size(); ++i) {
            this.composeDeviceDefinitionDeviceDefinitionPropertyComponent(t, "DeviceDefinition", "property", element.getProperty().get(i), i);
        }
        if (element.hasOwner()) {
            this.composeReference(t, "DeviceDefinition", "owner", element.getOwner(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeContactPoint(t, "DeviceDefinition", "contact", element.getContact().get(i), i);
        }
        if (element.hasUrlElement()) {
            this.composeUri(t, "DeviceDefinition", "url", element.getUrlElement(), -1);
        }
        if (element.hasOnlineInformationElement()) {
            this.composeUri(t, "DeviceDefinition", "onlineInformation", element.getOnlineInformationElement(), -1);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "DeviceDefinition", "note", element.getNote().get(i), i);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "DeviceDefinition", "quantity", element.getQuantity(), -1);
        }
        if (element.hasParentDevice()) {
            this.composeReference(t, "DeviceDefinition", "parentDevice", element.getParentDevice(), -1);
        }
        for (i = 0; i < element.getMaterial().size(); ++i) {
            this.composeDeviceDefinitionDeviceDefinitionMaterialComponent(t, "DeviceDefinition", "material", element.getMaterial().get(i), i);
        }
    }

    protected void composeDeviceDefinitionDeviceDefinitionUdiDeviceIdentifierComponent(Turtle.Complex parent, String parentType, String name, DeviceDefinition.DeviceDefinitionUdiDeviceIdentifierComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "udiDeviceIdentifier", name, element, index);
        if (element.hasDeviceIdentifierElement()) {
            this.composeString(t, "DeviceDefinition", "deviceIdentifier", element.getDeviceIdentifierElement(), -1);
        }
        if (element.hasIssuerElement()) {
            this.composeUri(t, "DeviceDefinition", "issuer", element.getIssuerElement(), -1);
        }
        if (element.hasJurisdictionElement()) {
            this.composeUri(t, "DeviceDefinition", "jurisdiction", element.getJurisdictionElement(), -1);
        }
    }

    protected void composeDeviceDefinitionDeviceDefinitionDeviceNameComponent(Turtle.Complex parent, String parentType, String name, DeviceDefinition.DeviceDefinitionDeviceNameComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "deviceName", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "DeviceDefinition", "name", element.getNameElement(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeEnum(t, "DeviceDefinition", "type", element.getTypeElement(), -1);
        }
    }

    protected void composeDeviceDefinitionDeviceDefinitionSpecializationComponent(Turtle.Complex parent, String parentType, String name, DeviceDefinition.DeviceDefinitionSpecializationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "specialization", name, element, index);
        if (element.hasSystemTypeElement()) {
            this.composeString(t, "DeviceDefinition", "systemType", element.getSystemTypeElement(), -1);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "DeviceDefinition", "version", element.getVersionElement(), -1);
        }
    }

    protected void composeDeviceDefinitionDeviceDefinitionCapabilityComponent(Turtle.Complex parent, String parentType, String name, DeviceDefinition.DeviceDefinitionCapabilityComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "capability", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "DeviceDefinition", "type", element.getType(), -1);
        }
        for (int i = 0; i < element.getDescription().size(); ++i) {
            this.composeCodeableConcept(t, "DeviceDefinition", "description", element.getDescription().get(i), i);
        }
    }

    protected void composeDeviceDefinitionDeviceDefinitionPropertyComponent(Turtle.Complex parent, String parentType, String name, DeviceDefinition.DeviceDefinitionPropertyComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "property", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "DeviceDefinition", "type", element.getType(), -1);
        }
        for (i = 0; i < element.getValueQuantity().size(); ++i) {
            this.composeQuantity(t, "DeviceDefinition", "valueQuantity", element.getValueQuantity().get(i), i);
        }
        for (i = 0; i < element.getValueCode().size(); ++i) {
            this.composeCodeableConcept(t, "DeviceDefinition", "valueCode", element.getValueCode().get(i), i);
        }
    }

    protected void composeDeviceDefinitionDeviceDefinitionMaterialComponent(Turtle.Complex parent, String parentType, String name, DeviceDefinition.DeviceDefinitionMaterialComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "material", name, element, index);
        if (element.hasSubstance()) {
            this.composeCodeableConcept(t, "DeviceDefinition", "substance", element.getSubstance(), -1);
        }
        if (element.hasAlternateElement()) {
            this.composeBoolean(t, "DeviceDefinition", "alternate", element.getAlternateElement(), -1);
        }
        if (element.hasAllergenicIndicatorElement()) {
            this.composeBoolean(t, "DeviceDefinition", "allergenicIndicator", element.getAllergenicIndicatorElement(), -1);
        }
    }

    protected void composeDeviceMetric(Turtle.Complex parent, String parentType, String name, DeviceMetric element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "DeviceMetric", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "DeviceMetric", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "DeviceMetric", "type", element.getType(), -1);
        }
        if (element.hasUnit()) {
            this.composeCodeableConcept(t, "DeviceMetric", "unit", element.getUnit(), -1);
        }
        if (element.hasSource()) {
            this.composeReference(t, "DeviceMetric", "source", element.getSource(), -1);
        }
        if (element.hasParent()) {
            this.composeReference(t, "DeviceMetric", "parent", element.getParent(), -1);
        }
        if (element.hasOperationalStatusElement()) {
            this.composeEnum(t, "DeviceMetric", "operationalStatus", element.getOperationalStatusElement(), -1);
        }
        if (element.hasColorElement()) {
            this.composeEnum(t, "DeviceMetric", "color", element.getColorElement(), -1);
        }
        if (element.hasCategoryElement()) {
            this.composeEnum(t, "DeviceMetric", "category", element.getCategoryElement(), -1);
        }
        if (element.hasMeasurementPeriod()) {
            this.composeTiming(t, "DeviceMetric", "measurementPeriod", element.getMeasurementPeriod(), -1);
        }
        for (i = 0; i < element.getCalibration().size(); ++i) {
            this.composeDeviceMetricDeviceMetricCalibrationComponent(t, "DeviceMetric", "calibration", element.getCalibration().get(i), i);
        }
    }

    protected void composeDeviceMetricDeviceMetricCalibrationComponent(Turtle.Complex parent, String parentType, String name, DeviceMetric.DeviceMetricCalibrationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "calibration", name, element, index);
        if (element.hasTypeElement()) {
            this.composeEnum(t, "DeviceMetric", "type", element.getTypeElement(), -1);
        }
        if (element.hasStateElement()) {
            this.composeEnum(t, "DeviceMetric", "state", element.getStateElement(), -1);
        }
        if (element.hasTimeElement()) {
            this.composeInstant(t, "DeviceMetric", "time", element.getTimeElement(), -1);
        }
    }

    protected void composeDeviceRequest(Turtle.Complex parent, String parentType, String name, DeviceRequest element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "DeviceRequest", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "DeviceRequest", "identifier", element.getIdentifier().get(i), i);
        }
        for (i = 0; i < element.getInstantiatesCanonical().size(); ++i) {
            this.composeCanonical(t, "DeviceRequest", "instantiatesCanonical", element.getInstantiatesCanonical().get(i), i);
        }
        for (i = 0; i < element.getInstantiatesUri().size(); ++i) {
            this.composeUri(t, "DeviceRequest", "instantiatesUri", element.getInstantiatesUri().get(i), i);
        }
        for (i = 0; i < element.getBasedOn().size(); ++i) {
            this.composeReference(t, "DeviceRequest", "basedOn", element.getBasedOn().get(i), i);
        }
        for (i = 0; i < element.getPriorRequest().size(); ++i) {
            this.composeReference(t, "DeviceRequest", "priorRequest", element.getPriorRequest().get(i), i);
        }
        if (element.hasGroupIdentifier()) {
            this.composeIdentifier(t, "DeviceRequest", "groupIdentifier", element.getGroupIdentifier(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "DeviceRequest", "status", element.getStatusElement(), -1);
        }
        if (element.hasIntentElement()) {
            this.composeEnum(t, "DeviceRequest", "intent", element.getIntentElement(), -1);
        }
        if (element.hasPriorityElement()) {
            this.composeEnum(t, "DeviceRequest", "priority", element.getPriorityElement(), -1);
        }
        if (element.hasCode()) {
            this.composeType(t, "DeviceRequest", "code", element.getCode(), -1);
        }
        for (i = 0; i < element.getParameter().size(); ++i) {
            this.composeDeviceRequestDeviceRequestParameterComponent(t, "DeviceRequest", "parameter", element.getParameter().get(i), i);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "DeviceRequest", "subject", element.getSubject(), -1);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "DeviceRequest", "encounter", element.getEncounter(), -1);
        }
        if (element.hasOccurrence()) {
            this.composeType(t, "DeviceRequest", "occurrence", element.getOccurrence(), -1);
        }
        if (element.hasAuthoredOnElement()) {
            this.composeDateTime(t, "DeviceRequest", "authoredOn", element.getAuthoredOnElement(), -1);
        }
        if (element.hasRequester()) {
            this.composeReference(t, "DeviceRequest", "requester", element.getRequester(), -1);
        }
        if (element.hasPerformerType()) {
            this.composeCodeableConcept(t, "DeviceRequest", "performerType", element.getPerformerType(), -1);
        }
        if (element.hasPerformer()) {
            this.composeReference(t, "DeviceRequest", "performer", element.getPerformer(), -1);
        }
        for (i = 0; i < element.getReasonCode().size(); ++i) {
            this.composeCodeableConcept(t, "DeviceRequest", "reasonCode", element.getReasonCode().get(i), i);
        }
        for (i = 0; i < element.getReasonReference().size(); ++i) {
            this.composeReference(t, "DeviceRequest", "reasonReference", element.getReasonReference().get(i), i);
        }
        for (i = 0; i < element.getInsurance().size(); ++i) {
            this.composeReference(t, "DeviceRequest", "insurance", element.getInsurance().get(i), i);
        }
        for (i = 0; i < element.getSupportingInfo().size(); ++i) {
            this.composeReference(t, "DeviceRequest", "supportingInfo", element.getSupportingInfo().get(i), i);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "DeviceRequest", "note", element.getNote().get(i), i);
        }
        for (i = 0; i < element.getRelevantHistory().size(); ++i) {
            this.composeReference(t, "DeviceRequest", "relevantHistory", element.getRelevantHistory().get(i), i);
        }
    }

    protected void composeDeviceRequestDeviceRequestParameterComponent(Turtle.Complex parent, String parentType, String name, DeviceRequest.DeviceRequestParameterComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "parameter", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "DeviceRequest", "code", element.getCode(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "DeviceRequest", "value", element.getValue(), -1);
        }
    }

    protected void composeDeviceUseStatement(Turtle.Complex parent, String parentType, String name, DeviceUseStatement element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "DeviceUseStatement", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "DeviceUseStatement", "identifier", element.getIdentifier().get(i), i);
        }
        for (i = 0; i < element.getBasedOn().size(); ++i) {
            this.composeReference(t, "DeviceUseStatement", "basedOn", element.getBasedOn().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "DeviceUseStatement", "status", element.getStatusElement(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "DeviceUseStatement", "subject", element.getSubject(), -1);
        }
        for (i = 0; i < element.getDerivedFrom().size(); ++i) {
            this.composeReference(t, "DeviceUseStatement", "derivedFrom", element.getDerivedFrom().get(i), i);
        }
        if (element.hasTiming()) {
            this.composeType(t, "DeviceUseStatement", "timing", element.getTiming(), -1);
        }
        if (element.hasRecordedOnElement()) {
            this.composeDateTime(t, "DeviceUseStatement", "recordedOn", element.getRecordedOnElement(), -1);
        }
        if (element.hasSource()) {
            this.composeReference(t, "DeviceUseStatement", "source", element.getSource(), -1);
        }
        if (element.hasDevice()) {
            this.composeReference(t, "DeviceUseStatement", "device", element.getDevice(), -1);
        }
        for (i = 0; i < element.getReasonCode().size(); ++i) {
            this.composeCodeableConcept(t, "DeviceUseStatement", "reasonCode", element.getReasonCode().get(i), i);
        }
        for (i = 0; i < element.getReasonReference().size(); ++i) {
            this.composeReference(t, "DeviceUseStatement", "reasonReference", element.getReasonReference().get(i), i);
        }
        if (element.hasBodySite()) {
            this.composeCodeableConcept(t, "DeviceUseStatement", "bodySite", element.getBodySite(), -1);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "DeviceUseStatement", "note", element.getNote().get(i), i);
        }
    }

    protected void composeDiagnosticReport(Turtle.Complex parent, String parentType, String name, DiagnosticReport element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "DiagnosticReport", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "DiagnosticReport", "identifier", element.getIdentifier().get(i), i);
        }
        for (i = 0; i < element.getBasedOn().size(); ++i) {
            this.composeReference(t, "DiagnosticReport", "basedOn", element.getBasedOn().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "DiagnosticReport", "status", element.getStatusElement(), -1);
        }
        for (i = 0; i < element.getCategory().size(); ++i) {
            this.composeCodeableConcept(t, "DiagnosticReport", "category", element.getCategory().get(i), i);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "DiagnosticReport", "code", element.getCode(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "DiagnosticReport", "subject", element.getSubject(), -1);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "DiagnosticReport", "encounter", element.getEncounter(), -1);
        }
        if (element.hasEffective()) {
            this.composeType(t, "DiagnosticReport", "effective", element.getEffective(), -1);
        }
        if (element.hasIssuedElement()) {
            this.composeInstant(t, "DiagnosticReport", "issued", element.getIssuedElement(), -1);
        }
        for (i = 0; i < element.getPerformer().size(); ++i) {
            this.composeReference(t, "DiagnosticReport", "performer", element.getPerformer().get(i), i);
        }
        for (i = 0; i < element.getResultsInterpreter().size(); ++i) {
            this.composeReference(t, "DiagnosticReport", "resultsInterpreter", element.getResultsInterpreter().get(i), i);
        }
        for (i = 0; i < element.getSpecimen().size(); ++i) {
            this.composeReference(t, "DiagnosticReport", "specimen", element.getSpecimen().get(i), i);
        }
        for (i = 0; i < element.getResult().size(); ++i) {
            this.composeReference(t, "DiagnosticReport", "result", element.getResult().get(i), i);
        }
        for (i = 0; i < element.getImagingStudy().size(); ++i) {
            this.composeReference(t, "DiagnosticReport", "imagingStudy", element.getImagingStudy().get(i), i);
        }
        for (i = 0; i < element.getMedia().size(); ++i) {
            this.composeDiagnosticReportDiagnosticReportMediaComponent(t, "DiagnosticReport", "media", element.getMedia().get(i), i);
        }
        if (element.hasConclusionElement()) {
            this.composeString(t, "DiagnosticReport", "conclusion", element.getConclusionElement(), -1);
        }
        for (i = 0; i < element.getConclusionCode().size(); ++i) {
            this.composeCodeableConcept(t, "DiagnosticReport", "conclusionCode", element.getConclusionCode().get(i), i);
        }
        for (i = 0; i < element.getPresentedForm().size(); ++i) {
            this.composeAttachment(t, "DiagnosticReport", "presentedForm", element.getPresentedForm().get(i), i);
        }
    }

    protected void composeDiagnosticReportDiagnosticReportMediaComponent(Turtle.Complex parent, String parentType, String name, DiagnosticReport.DiagnosticReportMediaComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "media", name, element, index);
        if (element.hasCommentElement()) {
            this.composeString(t, "DiagnosticReport", "comment", element.getCommentElement(), -1);
        }
        if (element.hasLink()) {
            this.composeReference(t, "DiagnosticReport", "link", element.getLink(), -1);
        }
    }

    protected void composeDocumentManifest(Turtle.Complex parent, String parentType, String name, DocumentManifest element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "DocumentManifest", name, element, index);
        if (element.hasMasterIdentifier()) {
            this.composeIdentifier(t, "DocumentManifest", "masterIdentifier", element.getMasterIdentifier(), -1);
        }
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "DocumentManifest", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "DocumentManifest", "status", element.getStatusElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "DocumentManifest", "type", element.getType(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "DocumentManifest", "subject", element.getSubject(), -1);
        }
        if (element.hasCreatedElement()) {
            this.composeDateTime(t, "DocumentManifest", "created", element.getCreatedElement(), -1);
        }
        for (i = 0; i < element.getAuthor().size(); ++i) {
            this.composeReference(t, "DocumentManifest", "author", element.getAuthor().get(i), i);
        }
        for (i = 0; i < element.getRecipient().size(); ++i) {
            this.composeReference(t, "DocumentManifest", "recipient", element.getRecipient().get(i), i);
        }
        if (element.hasSourceElement()) {
            this.composeUri(t, "DocumentManifest", "source", element.getSourceElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "DocumentManifest", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getContent().size(); ++i) {
            this.composeReference(t, "DocumentManifest", "content", element.getContent().get(i), i);
        }
        for (i = 0; i < element.getRelated().size(); ++i) {
            this.composeDocumentManifestDocumentManifestRelatedComponent(t, "DocumentManifest", "related", element.getRelated().get(i), i);
        }
    }

    protected void composeDocumentManifestDocumentManifestRelatedComponent(Turtle.Complex parent, String parentType, String name, DocumentManifest.DocumentManifestRelatedComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "related", name, element, index);
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "DocumentManifest", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasRef()) {
            this.composeReference(t, "DocumentManifest", "ref", element.getRef(), -1);
        }
    }

    protected void composeDocumentReference(Turtle.Complex parent, String parentType, String name, DocumentReference element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "DocumentReference", name, element, index);
        if (element.hasMasterIdentifier()) {
            this.composeIdentifier(t, "DocumentReference", "masterIdentifier", element.getMasterIdentifier(), -1);
        }
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "DocumentReference", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "DocumentReference", "status", element.getStatusElement(), -1);
        }
        if (element.hasDocStatusElement()) {
            this.composeEnum(t, "DocumentReference", "docStatus", element.getDocStatusElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "DocumentReference", "type", element.getType(), -1);
        }
        for (i = 0; i < element.getCategory().size(); ++i) {
            this.composeCodeableConcept(t, "DocumentReference", "category", element.getCategory().get(i), i);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "DocumentReference", "subject", element.getSubject(), -1);
        }
        if (element.hasDateElement()) {
            this.composeInstant(t, "DocumentReference", "date", element.getDateElement(), -1);
        }
        for (i = 0; i < element.getAuthor().size(); ++i) {
            this.composeReference(t, "DocumentReference", "author", element.getAuthor().get(i), i);
        }
        if (element.hasAuthenticator()) {
            this.composeReference(t, "DocumentReference", "authenticator", element.getAuthenticator(), -1);
        }
        if (element.hasCustodian()) {
            this.composeReference(t, "DocumentReference", "custodian", element.getCustodian(), -1);
        }
        for (i = 0; i < element.getRelatesTo().size(); ++i) {
            this.composeDocumentReferenceDocumentReferenceRelatesToComponent(t, "DocumentReference", "relatesTo", element.getRelatesTo().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "DocumentReference", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getSecurityLabel().size(); ++i) {
            this.composeCodeableConcept(t, "DocumentReference", "securityLabel", element.getSecurityLabel().get(i), i);
        }
        for (i = 0; i < element.getContent().size(); ++i) {
            this.composeDocumentReferenceDocumentReferenceContentComponent(t, "DocumentReference", "content", element.getContent().get(i), i);
        }
        if (element.hasContext()) {
            this.composeDocumentReferenceDocumentReferenceContextComponent(t, "DocumentReference", "context", element.getContext(), -1);
        }
    }

    protected void composeDocumentReferenceDocumentReferenceRelatesToComponent(Turtle.Complex parent, String parentType, String name, DocumentReference.DocumentReferenceRelatesToComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "relatesTo", name, element, index);
        if (element.hasCodeElement()) {
            this.composeEnum(t, "DocumentReference", "code", element.getCodeElement(), -1);
        }
        if (element.hasTarget()) {
            this.composeReference(t, "DocumentReference", "target", element.getTarget(), -1);
        }
    }

    protected void composeDocumentReferenceDocumentReferenceContentComponent(Turtle.Complex parent, String parentType, String name, DocumentReference.DocumentReferenceContentComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "content", name, element, index);
        if (element.hasAttachment()) {
            this.composeAttachment(t, "DocumentReference", "attachment", element.getAttachment(), -1);
        }
        if (element.hasFormat()) {
            this.composeCoding(t, "DocumentReference", "format", element.getFormat(), -1);
        }
    }

    protected void composeDocumentReferenceDocumentReferenceContextComponent(Turtle.Complex parent, String parentType, String name, DocumentReference.DocumentReferenceContextComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "context", name, element, index);
        for (i = 0; i < element.getEncounter().size(); ++i) {
            this.composeReference(t, "DocumentReference", "encounter", element.getEncounter().get(i), i);
        }
        for (i = 0; i < element.getEvent().size(); ++i) {
            this.composeCodeableConcept(t, "DocumentReference", "event", element.getEvent().get(i), i);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "DocumentReference", "period", element.getPeriod(), -1);
        }
        if (element.hasFacilityType()) {
            this.composeCodeableConcept(t, "DocumentReference", "facilityType", element.getFacilityType(), -1);
        }
        if (element.hasPracticeSetting()) {
            this.composeCodeableConcept(t, "DocumentReference", "practiceSetting", element.getPracticeSetting(), -1);
        }
        if (element.hasSourcePatientInfo()) {
            this.composeReference(t, "DocumentReference", "sourcePatientInfo", element.getSourcePatientInfo(), -1);
        }
        for (i = 0; i < element.getRelated().size(); ++i) {
            this.composeReference(t, "DocumentReference", "related", element.getRelated().get(i), i);
        }
    }

    protected void composeEffectEvidenceSynthesis(Turtle.Complex parent, String parentType, String name, EffectEvidenceSynthesis element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "EffectEvidenceSynthesis", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "EffectEvidenceSynthesis", "url", element.getUrlElement(), -1);
        }
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "EffectEvidenceSynthesis", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "EffectEvidenceSynthesis", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "EffectEvidenceSynthesis", "name", element.getNameElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "EffectEvidenceSynthesis", "title", element.getTitleElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "EffectEvidenceSynthesis", "status", element.getStatusElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "EffectEvidenceSynthesis", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "EffectEvidenceSynthesis", "publisher", element.getPublisherElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeContactDetail(t, "EffectEvidenceSynthesis", "contact", element.getContact().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "EffectEvidenceSynthesis", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "EffectEvidenceSynthesis", "note", element.getNote().get(i), i);
        }
        for (i = 0; i < element.getUseContext().size(); ++i) {
            this.composeUsageContext(t, "EffectEvidenceSynthesis", "useContext", element.getUseContext().get(i), i);
        }
        for (i = 0; i < element.getJurisdiction().size(); ++i) {
            this.composeCodeableConcept(t, "EffectEvidenceSynthesis", "jurisdiction", element.getJurisdiction().get(i), i);
        }
        if (element.hasCopyrightElement()) {
            this.composeMarkdown(t, "EffectEvidenceSynthesis", "copyright", element.getCopyrightElement(), -1);
        }
        if (element.hasApprovalDateElement()) {
            this.composeDate(t, "EffectEvidenceSynthesis", "approvalDate", element.getApprovalDateElement(), -1);
        }
        if (element.hasLastReviewDateElement()) {
            this.composeDate(t, "EffectEvidenceSynthesis", "lastReviewDate", element.getLastReviewDateElement(), -1);
        }
        if (element.hasEffectivePeriod()) {
            this.composePeriod(t, "EffectEvidenceSynthesis", "effectivePeriod", element.getEffectivePeriod(), -1);
        }
        for (i = 0; i < element.getTopic().size(); ++i) {
            this.composeCodeableConcept(t, "EffectEvidenceSynthesis", "topic", element.getTopic().get(i), i);
        }
        for (i = 0; i < element.getAuthor().size(); ++i) {
            this.composeContactDetail(t, "EffectEvidenceSynthesis", "author", element.getAuthor().get(i), i);
        }
        for (i = 0; i < element.getEditor().size(); ++i) {
            this.composeContactDetail(t, "EffectEvidenceSynthesis", "editor", element.getEditor().get(i), i);
        }
        for (i = 0; i < element.getReviewer().size(); ++i) {
            this.composeContactDetail(t, "EffectEvidenceSynthesis", "reviewer", element.getReviewer().get(i), i);
        }
        for (i = 0; i < element.getEndorser().size(); ++i) {
            this.composeContactDetail(t, "EffectEvidenceSynthesis", "endorser", element.getEndorser().get(i), i);
        }
        for (i = 0; i < element.getRelatedArtifact().size(); ++i) {
            this.composeRelatedArtifact(t, "EffectEvidenceSynthesis", "relatedArtifact", element.getRelatedArtifact().get(i), i);
        }
        if (element.hasSynthesisType()) {
            this.composeCodeableConcept(t, "EffectEvidenceSynthesis", "synthesisType", element.getSynthesisType(), -1);
        }
        if (element.hasStudyType()) {
            this.composeCodeableConcept(t, "EffectEvidenceSynthesis", "studyType", element.getStudyType(), -1);
        }
        if (element.hasPopulation()) {
            this.composeReference(t, "EffectEvidenceSynthesis", "population", element.getPopulation(), -1);
        }
        if (element.hasExposure()) {
            this.composeReference(t, "EffectEvidenceSynthesis", "exposure", element.getExposure(), -1);
        }
        if (element.hasExposureAlternative()) {
            this.composeReference(t, "EffectEvidenceSynthesis", "exposureAlternative", element.getExposureAlternative(), -1);
        }
        if (element.hasOutcome()) {
            this.composeReference(t, "EffectEvidenceSynthesis", "outcome", element.getOutcome(), -1);
        }
        if (element.hasSampleSize()) {
            this.composeEffectEvidenceSynthesisEffectEvidenceSynthesisSampleSizeComponent(t, "EffectEvidenceSynthesis", "sampleSize", element.getSampleSize(), -1);
        }
        for (i = 0; i < element.getResultsByExposure().size(); ++i) {
            this.composeEffectEvidenceSynthesisEffectEvidenceSynthesisResultsByExposureComponent(t, "EffectEvidenceSynthesis", "resultsByExposure", element.getResultsByExposure().get(i), i);
        }
        for (i = 0; i < element.getEffectEstimate().size(); ++i) {
            this.composeEffectEvidenceSynthesisEffectEvidenceSynthesisEffectEstimateComponent(t, "EffectEvidenceSynthesis", "effectEstimate", element.getEffectEstimate().get(i), i);
        }
        for (i = 0; i < element.getCertainty().size(); ++i) {
            this.composeEffectEvidenceSynthesisEffectEvidenceSynthesisCertaintyComponent(t, "EffectEvidenceSynthesis", "certainty", element.getCertainty().get(i), i);
        }
    }

    protected void composeEffectEvidenceSynthesisEffectEvidenceSynthesisSampleSizeComponent(Turtle.Complex parent, String parentType, String name, EffectEvidenceSynthesis.EffectEvidenceSynthesisSampleSizeComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "sampleSize", name, element, index);
        if (element.hasDescriptionElement()) {
            this.composeString(t, "EffectEvidenceSynthesis", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasNumberOfStudiesElement()) {
            this.composeInteger(t, "EffectEvidenceSynthesis", "numberOfStudies", element.getNumberOfStudiesElement(), -1);
        }
        if (element.hasNumberOfParticipantsElement()) {
            this.composeInteger(t, "EffectEvidenceSynthesis", "numberOfParticipants", element.getNumberOfParticipantsElement(), -1);
        }
    }

    protected void composeEffectEvidenceSynthesisEffectEvidenceSynthesisResultsByExposureComponent(Turtle.Complex parent, String parentType, String name, EffectEvidenceSynthesis.EffectEvidenceSynthesisResultsByExposureComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "resultsByExposure", name, element, index);
        if (element.hasDescriptionElement()) {
            this.composeString(t, "EffectEvidenceSynthesis", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasExposureStateElement()) {
            this.composeEnum(t, "EffectEvidenceSynthesis", "exposureState", element.getExposureStateElement(), -1);
        }
        if (element.hasVariantState()) {
            this.composeCodeableConcept(t, "EffectEvidenceSynthesis", "variantState", element.getVariantState(), -1);
        }
        if (element.hasRiskEvidenceSynthesis()) {
            this.composeReference(t, "EffectEvidenceSynthesis", "riskEvidenceSynthesis", element.getRiskEvidenceSynthesis(), -1);
        }
    }

    protected void composeEffectEvidenceSynthesisEffectEvidenceSynthesisEffectEstimateComponent(Turtle.Complex parent, String parentType, String name, EffectEvidenceSynthesis.EffectEvidenceSynthesisEffectEstimateComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "effectEstimate", name, element, index);
        if (element.hasDescriptionElement()) {
            this.composeString(t, "EffectEvidenceSynthesis", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "EffectEvidenceSynthesis", "type", element.getType(), -1);
        }
        if (element.hasVariantState()) {
            this.composeCodeableConcept(t, "EffectEvidenceSynthesis", "variantState", element.getVariantState(), -1);
        }
        if (element.hasValueElement()) {
            this.composeDecimal(t, "EffectEvidenceSynthesis", "value", element.getValueElement(), -1);
        }
        if (element.hasUnitOfMeasure()) {
            this.composeCodeableConcept(t, "EffectEvidenceSynthesis", "unitOfMeasure", element.getUnitOfMeasure(), -1);
        }
        for (int i = 0; i < element.getPrecisionEstimate().size(); ++i) {
            this.composeEffectEvidenceSynthesisEffectEvidenceSynthesisEffectEstimatePrecisionEstimateComponent(t, "EffectEvidenceSynthesis", "precisionEstimate", element.getPrecisionEstimate().get(i), i);
        }
    }

    protected void composeEffectEvidenceSynthesisEffectEvidenceSynthesisEffectEstimatePrecisionEstimateComponent(Turtle.Complex parent, String parentType, String name, EffectEvidenceSynthesis.EffectEvidenceSynthesisEffectEstimatePrecisionEstimateComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "precisionEstimate", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "EffectEvidenceSynthesis", "type", element.getType(), -1);
        }
        if (element.hasLevelElement()) {
            this.composeDecimal(t, "EffectEvidenceSynthesis", "level", element.getLevelElement(), -1);
        }
        if (element.hasFromElement()) {
            this.composeDecimal(t, "EffectEvidenceSynthesis", "from", element.getFromElement(), -1);
        }
        if (element.hasToElement()) {
            this.composeDecimal(t, "EffectEvidenceSynthesis", "to", element.getToElement(), -1);
        }
    }

    protected void composeEffectEvidenceSynthesisEffectEvidenceSynthesisCertaintyComponent(Turtle.Complex parent, String parentType, String name, EffectEvidenceSynthesis.EffectEvidenceSynthesisCertaintyComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "certainty", name, element, index);
        for (i = 0; i < element.getRating().size(); ++i) {
            this.composeCodeableConcept(t, "EffectEvidenceSynthesis", "rating", element.getRating().get(i), i);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "EffectEvidenceSynthesis", "note", element.getNote().get(i), i);
        }
        for (i = 0; i < element.getCertaintySubcomponent().size(); ++i) {
            this.composeEffectEvidenceSynthesisEffectEvidenceSynthesisCertaintyCertaintySubcomponentComponent(t, "EffectEvidenceSynthesis", "certaintySubcomponent", element.getCertaintySubcomponent().get(i), i);
        }
    }

    protected void composeEffectEvidenceSynthesisEffectEvidenceSynthesisCertaintyCertaintySubcomponentComponent(Turtle.Complex parent, String parentType, String name, EffectEvidenceSynthesis.EffectEvidenceSynthesisCertaintyCertaintySubcomponentComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "certaintySubcomponent", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "EffectEvidenceSynthesis", "type", element.getType(), -1);
        }
        for (i = 0; i < element.getRating().size(); ++i) {
            this.composeCodeableConcept(t, "EffectEvidenceSynthesis", "rating", element.getRating().get(i), i);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "EffectEvidenceSynthesis", "note", element.getNote().get(i), i);
        }
    }

    protected void composeEncounter(Turtle.Complex parent, String parentType, String name, Encounter element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Encounter", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Encounter", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Encounter", "status", element.getStatusElement(), -1);
        }
        for (i = 0; i < element.getStatusHistory().size(); ++i) {
            this.composeEncounterStatusHistoryComponent(t, "Encounter", "statusHistory", element.getStatusHistory().get(i), i);
        }
        if (element.hasClass_()) {
            this.composeCoding(t, "Encounter", "class", element.getClass_(), -1);
        }
        for (i = 0; i < element.getClassHistory().size(); ++i) {
            this.composeEncounterClassHistoryComponent(t, "Encounter", "classHistory", element.getClassHistory().get(i), i);
        }
        for (i = 0; i < element.getType().size(); ++i) {
            this.composeCodeableConcept(t, "Encounter", "type", element.getType().get(i), i);
        }
        if (element.hasServiceType()) {
            this.composeCodeableConcept(t, "Encounter", "serviceType", element.getServiceType(), -1);
        }
        if (element.hasPriority()) {
            this.composeCodeableConcept(t, "Encounter", "priority", element.getPriority(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "Encounter", "subject", element.getSubject(), -1);
        }
        for (i = 0; i < element.getEpisodeOfCare().size(); ++i) {
            this.composeReference(t, "Encounter", "episodeOfCare", element.getEpisodeOfCare().get(i), i);
        }
        for (i = 0; i < element.getBasedOn().size(); ++i) {
            this.composeReference(t, "Encounter", "basedOn", element.getBasedOn().get(i), i);
        }
        for (i = 0; i < element.getParticipant().size(); ++i) {
            this.composeEncounterEncounterParticipantComponent(t, "Encounter", "participant", element.getParticipant().get(i), i);
        }
        for (i = 0; i < element.getAppointment().size(); ++i) {
            this.composeReference(t, "Encounter", "appointment", element.getAppointment().get(i), i);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "Encounter", "period", element.getPeriod(), -1);
        }
        if (element.hasLength()) {
            this.composeDuration(t, "Encounter", "length", element.getLength(), -1);
        }
        for (i = 0; i < element.getReasonCode().size(); ++i) {
            this.composeCodeableConcept(t, "Encounter", "reasonCode", element.getReasonCode().get(i), i);
        }
        for (i = 0; i < element.getReasonReference().size(); ++i) {
            this.composeReference(t, "Encounter", "reasonReference", element.getReasonReference().get(i), i);
        }
        for (i = 0; i < element.getDiagnosis().size(); ++i) {
            this.composeEncounterDiagnosisComponent(t, "Encounter", "diagnosis", element.getDiagnosis().get(i), i);
        }
        for (i = 0; i < element.getAccount().size(); ++i) {
            this.composeReference(t, "Encounter", "account", element.getAccount().get(i), i);
        }
        if (element.hasHospitalization()) {
            this.composeEncounterEncounterHospitalizationComponent(t, "Encounter", "hospitalization", element.getHospitalization(), -1);
        }
        for (i = 0; i < element.getLocation().size(); ++i) {
            this.composeEncounterEncounterLocationComponent(t, "Encounter", "location", element.getLocation().get(i), i);
        }
        if (element.hasServiceProvider()) {
            this.composeReference(t, "Encounter", "serviceProvider", element.getServiceProvider(), -1);
        }
        if (element.hasPartOf()) {
            this.composeReference(t, "Encounter", "partOf", element.getPartOf(), -1);
        }
    }

    protected void composeEncounterStatusHistoryComponent(Turtle.Complex parent, String parentType, String name, Encounter.StatusHistoryComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "statusHistory", name, element, index);
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Encounter", "status", element.getStatusElement(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "Encounter", "period", element.getPeriod(), -1);
        }
    }

    protected void composeEncounterClassHistoryComponent(Turtle.Complex parent, String parentType, String name, Encounter.ClassHistoryComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "classHistory", name, element, index);
        if (element.hasClass_()) {
            this.composeCoding(t, "Encounter", "class", element.getClass_(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "Encounter", "period", element.getPeriod(), -1);
        }
    }

    protected void composeEncounterEncounterParticipantComponent(Turtle.Complex parent, String parentType, String name, Encounter.EncounterParticipantComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "participant", name, element, index);
        for (int i = 0; i < element.getType().size(); ++i) {
            this.composeCodeableConcept(t, "Encounter", "type", element.getType().get(i), i);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "Encounter", "period", element.getPeriod(), -1);
        }
        if (element.hasIndividual()) {
            this.composeReference(t, "Encounter", "individual", element.getIndividual(), -1);
        }
    }

    protected void composeEncounterDiagnosisComponent(Turtle.Complex parent, String parentType, String name, Encounter.DiagnosisComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "diagnosis", name, element, index);
        if (element.hasCondition()) {
            this.composeReference(t, "Encounter", "condition", element.getCondition(), -1);
        }
        if (element.hasUse()) {
            this.composeCodeableConcept(t, "Encounter", "use", element.getUse(), -1);
        }
        if (element.hasRankElement()) {
            this.composePositiveInt(t, "Encounter", "rank", element.getRankElement(), -1);
        }
    }

    protected void composeEncounterEncounterHospitalizationComponent(Turtle.Complex parent, String parentType, String name, Encounter.EncounterHospitalizationComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "hospitalization", name, element, index);
        if (element.hasPreAdmissionIdentifier()) {
            this.composeIdentifier(t, "Encounter", "preAdmissionIdentifier", element.getPreAdmissionIdentifier(), -1);
        }
        if (element.hasOrigin()) {
            this.composeReference(t, "Encounter", "origin", element.getOrigin(), -1);
        }
        if (element.hasAdmitSource()) {
            this.composeCodeableConcept(t, "Encounter", "admitSource", element.getAdmitSource(), -1);
        }
        if (element.hasReAdmission()) {
            this.composeCodeableConcept(t, "Encounter", "reAdmission", element.getReAdmission(), -1);
        }
        for (i = 0; i < element.getDietPreference().size(); ++i) {
            this.composeCodeableConcept(t, "Encounter", "dietPreference", element.getDietPreference().get(i), i);
        }
        for (i = 0; i < element.getSpecialCourtesy().size(); ++i) {
            this.composeCodeableConcept(t, "Encounter", "specialCourtesy", element.getSpecialCourtesy().get(i), i);
        }
        for (i = 0; i < element.getSpecialArrangement().size(); ++i) {
            this.composeCodeableConcept(t, "Encounter", "specialArrangement", element.getSpecialArrangement().get(i), i);
        }
        if (element.hasDestination()) {
            this.composeReference(t, "Encounter", "destination", element.getDestination(), -1);
        }
        if (element.hasDischargeDisposition()) {
            this.composeCodeableConcept(t, "Encounter", "dischargeDisposition", element.getDischargeDisposition(), -1);
        }
    }

    protected void composeEncounterEncounterLocationComponent(Turtle.Complex parent, String parentType, String name, Encounter.EncounterLocationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "location", name, element, index);
        if (element.hasLocation()) {
            this.composeReference(t, "Encounter", "location", element.getLocation(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Encounter", "status", element.getStatusElement(), -1);
        }
        if (element.hasPhysicalType()) {
            this.composeCodeableConcept(t, "Encounter", "physicalType", element.getPhysicalType(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "Encounter", "period", element.getPeriod(), -1);
        }
    }

    protected void composeEndpoint(Turtle.Complex parent, String parentType, String name, Endpoint element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Endpoint", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Endpoint", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Endpoint", "status", element.getStatusElement(), -1);
        }
        if (element.hasConnectionType()) {
            this.composeCoding(t, "Endpoint", "connectionType", element.getConnectionType(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "Endpoint", "name", element.getNameElement(), -1);
        }
        if (element.hasManagingOrganization()) {
            this.composeReference(t, "Endpoint", "managingOrganization", element.getManagingOrganization(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeContactPoint(t, "Endpoint", "contact", element.getContact().get(i), i);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "Endpoint", "period", element.getPeriod(), -1);
        }
        for (i = 0; i < element.getPayloadType().size(); ++i) {
            this.composeCodeableConcept(t, "Endpoint", "payloadType", element.getPayloadType().get(i), i);
        }
        for (i = 0; i < element.getPayloadMimeType().size(); ++i) {
            this.composeCode(t, "Endpoint", "payloadMimeType", element.getPayloadMimeType().get(i), i);
        }
        if (element.hasAddressElement()) {
            this.composeUrl(t, "Endpoint", "address", element.getAddressElement(), -1);
        }
        for (i = 0; i < element.getHeader().size(); ++i) {
            this.composeString(t, "Endpoint", "header", element.getHeader().get(i), i);
        }
    }

    protected void composeEnrollmentRequest(Turtle.Complex parent, String parentType, String name, EnrollmentRequest element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "EnrollmentRequest", name, element, index);
        for (int i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "EnrollmentRequest", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "EnrollmentRequest", "status", element.getStatusElement(), -1);
        }
        if (element.hasCreatedElement()) {
            this.composeDateTime(t, "EnrollmentRequest", "created", element.getCreatedElement(), -1);
        }
        if (element.hasInsurer()) {
            this.composeReference(t, "EnrollmentRequest", "insurer", element.getInsurer(), -1);
        }
        if (element.hasProvider()) {
            this.composeReference(t, "EnrollmentRequest", "provider", element.getProvider(), -1);
        }
        if (element.hasCandidate()) {
            this.composeReference(t, "EnrollmentRequest", "candidate", element.getCandidate(), -1);
        }
        if (element.hasCoverage()) {
            this.composeReference(t, "EnrollmentRequest", "coverage", element.getCoverage(), -1);
        }
    }

    protected void composeEnrollmentResponse(Turtle.Complex parent, String parentType, String name, EnrollmentResponse element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "EnrollmentResponse", name, element, index);
        for (int i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "EnrollmentResponse", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "EnrollmentResponse", "status", element.getStatusElement(), -1);
        }
        if (element.hasRequest()) {
            this.composeReference(t, "EnrollmentResponse", "request", element.getRequest(), -1);
        }
        if (element.hasOutcomeElement()) {
            this.composeEnum(t, "EnrollmentResponse", "outcome", element.getOutcomeElement(), -1);
        }
        if (element.hasDispositionElement()) {
            this.composeString(t, "EnrollmentResponse", "disposition", element.getDispositionElement(), -1);
        }
        if (element.hasCreatedElement()) {
            this.composeDateTime(t, "EnrollmentResponse", "created", element.getCreatedElement(), -1);
        }
        if (element.hasOrganization()) {
            this.composeReference(t, "EnrollmentResponse", "organization", element.getOrganization(), -1);
        }
        if (element.hasRequestProvider()) {
            this.composeReference(t, "EnrollmentResponse", "requestProvider", element.getRequestProvider(), -1);
        }
    }

    protected void composeEpisodeOfCare(Turtle.Complex parent, String parentType, String name, EpisodeOfCare element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "EpisodeOfCare", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "EpisodeOfCare", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "EpisodeOfCare", "status", element.getStatusElement(), -1);
        }
        for (i = 0; i < element.getStatusHistory().size(); ++i) {
            this.composeEpisodeOfCareEpisodeOfCareStatusHistoryComponent(t, "EpisodeOfCare", "statusHistory", element.getStatusHistory().get(i), i);
        }
        for (i = 0; i < element.getType().size(); ++i) {
            this.composeCodeableConcept(t, "EpisodeOfCare", "type", element.getType().get(i), i);
        }
        for (i = 0; i < element.getDiagnosis().size(); ++i) {
            this.composeEpisodeOfCareDiagnosisComponent(t, "EpisodeOfCare", "diagnosis", element.getDiagnosis().get(i), i);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "EpisodeOfCare", "patient", element.getPatient(), -1);
        }
        if (element.hasManagingOrganization()) {
            this.composeReference(t, "EpisodeOfCare", "managingOrganization", element.getManagingOrganization(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "EpisodeOfCare", "period", element.getPeriod(), -1);
        }
        for (i = 0; i < element.getReferralRequest().size(); ++i) {
            this.composeReference(t, "EpisodeOfCare", "referralRequest", element.getReferralRequest().get(i), i);
        }
        if (element.hasCareManager()) {
            this.composeReference(t, "EpisodeOfCare", "careManager", element.getCareManager(), -1);
        }
        for (i = 0; i < element.getTeam().size(); ++i) {
            this.composeReference(t, "EpisodeOfCare", "team", element.getTeam().get(i), i);
        }
        for (i = 0; i < element.getAccount().size(); ++i) {
            this.composeReference(t, "EpisodeOfCare", "account", element.getAccount().get(i), i);
        }
    }

    protected void composeEpisodeOfCareEpisodeOfCareStatusHistoryComponent(Turtle.Complex parent, String parentType, String name, EpisodeOfCare.EpisodeOfCareStatusHistoryComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "statusHistory", name, element, index);
        if (element.hasStatusElement()) {
            this.composeEnum(t, "EpisodeOfCare", "status", element.getStatusElement(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "EpisodeOfCare", "period", element.getPeriod(), -1);
        }
    }

    protected void composeEpisodeOfCareDiagnosisComponent(Turtle.Complex parent, String parentType, String name, EpisodeOfCare.DiagnosisComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "diagnosis", name, element, index);
        if (element.hasCondition()) {
            this.composeReference(t, "EpisodeOfCare", "condition", element.getCondition(), -1);
        }
        if (element.hasRole()) {
            this.composeCodeableConcept(t, "EpisodeOfCare", "role", element.getRole(), -1);
        }
        if (element.hasRankElement()) {
            this.composePositiveInt(t, "EpisodeOfCare", "rank", element.getRankElement(), -1);
        }
    }

    protected void composeEventDefinition(Turtle.Complex parent, String parentType, String name, EventDefinition element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "EventDefinition", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "EventDefinition", "url", element.getUrlElement(), -1);
        }
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "EventDefinition", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "EventDefinition", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "EventDefinition", "name", element.getNameElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "EventDefinition", "title", element.getTitleElement(), -1);
        }
        if (element.hasSubtitleElement()) {
            this.composeString(t, "EventDefinition", "subtitle", element.getSubtitleElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "EventDefinition", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "EventDefinition", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasSubject()) {
            this.composeType(t, "EventDefinition", "subject", element.getSubject(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "EventDefinition", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "EventDefinition", "publisher", element.getPublisherElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeContactDetail(t, "EventDefinition", "contact", element.getContact().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "EventDefinition", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getUseContext().size(); ++i) {
            this.composeUsageContext(t, "EventDefinition", "useContext", element.getUseContext().get(i), i);
        }
        for (i = 0; i < element.getJurisdiction().size(); ++i) {
            this.composeCodeableConcept(t, "EventDefinition", "jurisdiction", element.getJurisdiction().get(i), i);
        }
        if (element.hasPurposeElement()) {
            this.composeMarkdown(t, "EventDefinition", "purpose", element.getPurposeElement(), -1);
        }
        if (element.hasUsageElement()) {
            this.composeString(t, "EventDefinition", "usage", element.getUsageElement(), -1);
        }
        if (element.hasCopyrightElement()) {
            this.composeMarkdown(t, "EventDefinition", "copyright", element.getCopyrightElement(), -1);
        }
        if (element.hasApprovalDateElement()) {
            this.composeDate(t, "EventDefinition", "approvalDate", element.getApprovalDateElement(), -1);
        }
        if (element.hasLastReviewDateElement()) {
            this.composeDate(t, "EventDefinition", "lastReviewDate", element.getLastReviewDateElement(), -1);
        }
        if (element.hasEffectivePeriod()) {
            this.composePeriod(t, "EventDefinition", "effectivePeriod", element.getEffectivePeriod(), -1);
        }
        for (i = 0; i < element.getTopic().size(); ++i) {
            this.composeCodeableConcept(t, "EventDefinition", "topic", element.getTopic().get(i), i);
        }
        for (i = 0; i < element.getAuthor().size(); ++i) {
            this.composeContactDetail(t, "EventDefinition", "author", element.getAuthor().get(i), i);
        }
        for (i = 0; i < element.getEditor().size(); ++i) {
            this.composeContactDetail(t, "EventDefinition", "editor", element.getEditor().get(i), i);
        }
        for (i = 0; i < element.getReviewer().size(); ++i) {
            this.composeContactDetail(t, "EventDefinition", "reviewer", element.getReviewer().get(i), i);
        }
        for (i = 0; i < element.getEndorser().size(); ++i) {
            this.composeContactDetail(t, "EventDefinition", "endorser", element.getEndorser().get(i), i);
        }
        for (i = 0; i < element.getRelatedArtifact().size(); ++i) {
            this.composeRelatedArtifact(t, "EventDefinition", "relatedArtifact", element.getRelatedArtifact().get(i), i);
        }
        for (i = 0; i < element.getTrigger().size(); ++i) {
            this.composeTriggerDefinition(t, "EventDefinition", "trigger", element.getTrigger().get(i), i);
        }
    }

    protected void composeEvidence(Turtle.Complex parent, String parentType, String name, Evidence element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Evidence", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "Evidence", "url", element.getUrlElement(), -1);
        }
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Evidence", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "Evidence", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "Evidence", "name", element.getNameElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "Evidence", "title", element.getTitleElement(), -1);
        }
        if (element.hasShortTitleElement()) {
            this.composeString(t, "Evidence", "shortTitle", element.getShortTitleElement(), -1);
        }
        if (element.hasSubtitleElement()) {
            this.composeString(t, "Evidence", "subtitle", element.getSubtitleElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Evidence", "status", element.getStatusElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "Evidence", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "Evidence", "publisher", element.getPublisherElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeContactDetail(t, "Evidence", "contact", element.getContact().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "Evidence", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "Evidence", "note", element.getNote().get(i), i);
        }
        for (i = 0; i < element.getUseContext().size(); ++i) {
            this.composeUsageContext(t, "Evidence", "useContext", element.getUseContext().get(i), i);
        }
        for (i = 0; i < element.getJurisdiction().size(); ++i) {
            this.composeCodeableConcept(t, "Evidence", "jurisdiction", element.getJurisdiction().get(i), i);
        }
        if (element.hasCopyrightElement()) {
            this.composeMarkdown(t, "Evidence", "copyright", element.getCopyrightElement(), -1);
        }
        if (element.hasApprovalDateElement()) {
            this.composeDate(t, "Evidence", "approvalDate", element.getApprovalDateElement(), -1);
        }
        if (element.hasLastReviewDateElement()) {
            this.composeDate(t, "Evidence", "lastReviewDate", element.getLastReviewDateElement(), -1);
        }
        if (element.hasEffectivePeriod()) {
            this.composePeriod(t, "Evidence", "effectivePeriod", element.getEffectivePeriod(), -1);
        }
        for (i = 0; i < element.getTopic().size(); ++i) {
            this.composeCodeableConcept(t, "Evidence", "topic", element.getTopic().get(i), i);
        }
        for (i = 0; i < element.getAuthor().size(); ++i) {
            this.composeContactDetail(t, "Evidence", "author", element.getAuthor().get(i), i);
        }
        for (i = 0; i < element.getEditor().size(); ++i) {
            this.composeContactDetail(t, "Evidence", "editor", element.getEditor().get(i), i);
        }
        for (i = 0; i < element.getReviewer().size(); ++i) {
            this.composeContactDetail(t, "Evidence", "reviewer", element.getReviewer().get(i), i);
        }
        for (i = 0; i < element.getEndorser().size(); ++i) {
            this.composeContactDetail(t, "Evidence", "endorser", element.getEndorser().get(i), i);
        }
        for (i = 0; i < element.getRelatedArtifact().size(); ++i) {
            this.composeRelatedArtifact(t, "Evidence", "relatedArtifact", element.getRelatedArtifact().get(i), i);
        }
        if (element.hasExposureBackground()) {
            this.composeReference(t, "Evidence", "exposureBackground", element.getExposureBackground(), -1);
        }
        for (i = 0; i < element.getExposureVariant().size(); ++i) {
            this.composeReference(t, "Evidence", "exposureVariant", element.getExposureVariant().get(i), i);
        }
        for (i = 0; i < element.getOutcome().size(); ++i) {
            this.composeReference(t, "Evidence", "outcome", element.getOutcome().get(i), i);
        }
    }

    protected void composeEvidenceVariable(Turtle.Complex parent, String parentType, String name, EvidenceVariable element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "EvidenceVariable", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "EvidenceVariable", "url", element.getUrlElement(), -1);
        }
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "EvidenceVariable", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "EvidenceVariable", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "EvidenceVariable", "name", element.getNameElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "EvidenceVariable", "title", element.getTitleElement(), -1);
        }
        if (element.hasShortTitleElement()) {
            this.composeString(t, "EvidenceVariable", "shortTitle", element.getShortTitleElement(), -1);
        }
        if (element.hasSubtitleElement()) {
            this.composeString(t, "EvidenceVariable", "subtitle", element.getSubtitleElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "EvidenceVariable", "status", element.getStatusElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "EvidenceVariable", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "EvidenceVariable", "publisher", element.getPublisherElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeContactDetail(t, "EvidenceVariable", "contact", element.getContact().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "EvidenceVariable", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "EvidenceVariable", "note", element.getNote().get(i), i);
        }
        for (i = 0; i < element.getUseContext().size(); ++i) {
            this.composeUsageContext(t, "EvidenceVariable", "useContext", element.getUseContext().get(i), i);
        }
        for (i = 0; i < element.getJurisdiction().size(); ++i) {
            this.composeCodeableConcept(t, "EvidenceVariable", "jurisdiction", element.getJurisdiction().get(i), i);
        }
        if (element.hasCopyrightElement()) {
            this.composeMarkdown(t, "EvidenceVariable", "copyright", element.getCopyrightElement(), -1);
        }
        if (element.hasApprovalDateElement()) {
            this.composeDate(t, "EvidenceVariable", "approvalDate", element.getApprovalDateElement(), -1);
        }
        if (element.hasLastReviewDateElement()) {
            this.composeDate(t, "EvidenceVariable", "lastReviewDate", element.getLastReviewDateElement(), -1);
        }
        if (element.hasEffectivePeriod()) {
            this.composePeriod(t, "EvidenceVariable", "effectivePeriod", element.getEffectivePeriod(), -1);
        }
        for (i = 0; i < element.getTopic().size(); ++i) {
            this.composeCodeableConcept(t, "EvidenceVariable", "topic", element.getTopic().get(i), i);
        }
        for (i = 0; i < element.getAuthor().size(); ++i) {
            this.composeContactDetail(t, "EvidenceVariable", "author", element.getAuthor().get(i), i);
        }
        for (i = 0; i < element.getEditor().size(); ++i) {
            this.composeContactDetail(t, "EvidenceVariable", "editor", element.getEditor().get(i), i);
        }
        for (i = 0; i < element.getReviewer().size(); ++i) {
            this.composeContactDetail(t, "EvidenceVariable", "reviewer", element.getReviewer().get(i), i);
        }
        for (i = 0; i < element.getEndorser().size(); ++i) {
            this.composeContactDetail(t, "EvidenceVariable", "endorser", element.getEndorser().get(i), i);
        }
        for (i = 0; i < element.getRelatedArtifact().size(); ++i) {
            this.composeRelatedArtifact(t, "EvidenceVariable", "relatedArtifact", element.getRelatedArtifact().get(i), i);
        }
        if (element.hasTypeElement()) {
            this.composeEnum(t, "EvidenceVariable", "type", element.getTypeElement(), -1);
        }
        for (i = 0; i < element.getCharacteristic().size(); ++i) {
            this.composeEvidenceVariableEvidenceVariableCharacteristicComponent(t, "EvidenceVariable", "characteristic", element.getCharacteristic().get(i), i);
        }
    }

    protected void composeEvidenceVariableEvidenceVariableCharacteristicComponent(Turtle.Complex parent, String parentType, String name, EvidenceVariable.EvidenceVariableCharacteristicComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "characteristic", name, element, index);
        if (element.hasDescriptionElement()) {
            this.composeString(t, "EvidenceVariable", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasDefinition()) {
            this.composeType(t, "EvidenceVariable", "definition", element.getDefinition(), -1);
        }
        for (int i = 0; i < element.getUsageContext().size(); ++i) {
            this.composeUsageContext(t, "EvidenceVariable", "usageContext", element.getUsageContext().get(i), i);
        }
        if (element.hasExcludeElement()) {
            this.composeBoolean(t, "EvidenceVariable", "exclude", element.getExcludeElement(), -1);
        }
        if (element.hasParticipantEffective()) {
            this.composeType(t, "EvidenceVariable", "participantEffective", element.getParticipantEffective(), -1);
        }
        if (element.hasTimeFromStart()) {
            this.composeDuration(t, "EvidenceVariable", "timeFromStart", element.getTimeFromStart(), -1);
        }
        if (element.hasGroupMeasureElement()) {
            this.composeEnum(t, "EvidenceVariable", "groupMeasure", element.getGroupMeasureElement(), -1);
        }
    }

    protected void composeExampleScenario(Turtle.Complex parent, String parentType, String name, ExampleScenario element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "ExampleScenario", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "ExampleScenario", "url", element.getUrlElement(), -1);
        }
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "ExampleScenario", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "ExampleScenario", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "ExampleScenario", "name", element.getNameElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "ExampleScenario", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "ExampleScenario", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "ExampleScenario", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "ExampleScenario", "publisher", element.getPublisherElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeContactDetail(t, "ExampleScenario", "contact", element.getContact().get(i), i);
        }
        for (i = 0; i < element.getUseContext().size(); ++i) {
            this.composeUsageContext(t, "ExampleScenario", "useContext", element.getUseContext().get(i), i);
        }
        for (i = 0; i < element.getJurisdiction().size(); ++i) {
            this.composeCodeableConcept(t, "ExampleScenario", "jurisdiction", element.getJurisdiction().get(i), i);
        }
        if (element.hasCopyrightElement()) {
            this.composeMarkdown(t, "ExampleScenario", "copyright", element.getCopyrightElement(), -1);
        }
        if (element.hasPurposeElement()) {
            this.composeMarkdown(t, "ExampleScenario", "purpose", element.getPurposeElement(), -1);
        }
        for (i = 0; i < element.getActor().size(); ++i) {
            this.composeExampleScenarioExampleScenarioActorComponent(t, "ExampleScenario", "actor", element.getActor().get(i), i);
        }
        for (i = 0; i < element.getInstance().size(); ++i) {
            this.composeExampleScenarioExampleScenarioInstanceComponent(t, "ExampleScenario", "instance", element.getInstance().get(i), i);
        }
        for (i = 0; i < element.getProcess().size(); ++i) {
            this.composeExampleScenarioExampleScenarioProcessComponent(t, "ExampleScenario", "process", element.getProcess().get(i), i);
        }
        for (i = 0; i < element.getWorkflow().size(); ++i) {
            this.composeCanonical(t, "ExampleScenario", "workflow", element.getWorkflow().get(i), i);
        }
    }

    protected void composeExampleScenarioExampleScenarioActorComponent(Turtle.Complex parent, String parentType, String name, ExampleScenario.ExampleScenarioActorComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "actor", name, element, index);
        if (element.hasActorIdElement()) {
            this.composeString(t, "ExampleScenario", "actorId", element.getActorIdElement(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeEnum(t, "ExampleScenario", "type", element.getTypeElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "ExampleScenario", "name", element.getNameElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "ExampleScenario", "description", element.getDescriptionElement(), -1);
        }
    }

    protected void composeExampleScenarioExampleScenarioInstanceComponent(Turtle.Complex parent, String parentType, String name, ExampleScenario.ExampleScenarioInstanceComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "instance", name, element, index);
        if (element.hasResourceIdElement()) {
            this.composeString(t, "ExampleScenario", "resourceId", element.getResourceIdElement(), -1);
        }
        if (element.hasResourceTypeElement()) {
            this.composeEnum(t, "ExampleScenario", "resourceType", element.getResourceTypeElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "ExampleScenario", "name", element.getNameElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "ExampleScenario", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getVersion().size(); ++i) {
            this.composeExampleScenarioExampleScenarioInstanceVersionComponent(t, "ExampleScenario", "version", element.getVersion().get(i), i);
        }
        for (i = 0; i < element.getContainedInstance().size(); ++i) {
            this.composeExampleScenarioExampleScenarioInstanceContainedInstanceComponent(t, "ExampleScenario", "containedInstance", element.getContainedInstance().get(i), i);
        }
    }

    protected void composeExampleScenarioExampleScenarioInstanceVersionComponent(Turtle.Complex parent, String parentType, String name, ExampleScenario.ExampleScenarioInstanceVersionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "version", name, element, index);
        if (element.hasVersionIdElement()) {
            this.composeString(t, "ExampleScenario", "versionId", element.getVersionIdElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "ExampleScenario", "description", element.getDescriptionElement(), -1);
        }
    }

    protected void composeExampleScenarioExampleScenarioInstanceContainedInstanceComponent(Turtle.Complex parent, String parentType, String name, ExampleScenario.ExampleScenarioInstanceContainedInstanceComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "containedInstance", name, element, index);
        if (element.hasResourceIdElement()) {
            this.composeString(t, "ExampleScenario", "resourceId", element.getResourceIdElement(), -1);
        }
        if (element.hasVersionIdElement()) {
            this.composeString(t, "ExampleScenario", "versionId", element.getVersionIdElement(), -1);
        }
    }

    protected void composeExampleScenarioExampleScenarioProcessComponent(Turtle.Complex parent, String parentType, String name, ExampleScenario.ExampleScenarioProcessComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "process", name, element, index);
        if (element.hasTitleElement()) {
            this.composeString(t, "ExampleScenario", "title", element.getTitleElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "ExampleScenario", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasPreConditionsElement()) {
            this.composeMarkdown(t, "ExampleScenario", "preConditions", element.getPreConditionsElement(), -1);
        }
        if (element.hasPostConditionsElement()) {
            this.composeMarkdown(t, "ExampleScenario", "postConditions", element.getPostConditionsElement(), -1);
        }
        for (int i = 0; i < element.getStep().size(); ++i) {
            this.composeExampleScenarioExampleScenarioProcessStepComponent(t, "ExampleScenario", "step", element.getStep().get(i), i);
        }
    }

    protected void composeExampleScenarioExampleScenarioProcessStepComponent(Turtle.Complex parent, String parentType, String name, ExampleScenario.ExampleScenarioProcessStepComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "step", name, element, index);
        for (i = 0; i < element.getProcess().size(); ++i) {
            this.composeExampleScenarioExampleScenarioProcessComponent(t, "ExampleScenario", "process", element.getProcess().get(i), i);
        }
        if (element.hasPauseElement()) {
            this.composeBoolean(t, "ExampleScenario", "pause", element.getPauseElement(), -1);
        }
        if (element.hasOperation()) {
            this.composeExampleScenarioExampleScenarioProcessStepOperationComponent(t, "ExampleScenario", "operation", element.getOperation(), -1);
        }
        for (i = 0; i < element.getAlternative().size(); ++i) {
            this.composeExampleScenarioExampleScenarioProcessStepAlternativeComponent(t, "ExampleScenario", "alternative", element.getAlternative().get(i), i);
        }
    }

    protected void composeExampleScenarioExampleScenarioProcessStepOperationComponent(Turtle.Complex parent, String parentType, String name, ExampleScenario.ExampleScenarioProcessStepOperationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "operation", name, element, index);
        if (element.hasNumberElement()) {
            this.composeString(t, "ExampleScenario", "number", element.getNumberElement(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeString(t, "ExampleScenario", "type", element.getTypeElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "ExampleScenario", "name", element.getNameElement(), -1);
        }
        if (element.hasInitiatorElement()) {
            this.composeString(t, "ExampleScenario", "initiator", element.getInitiatorElement(), -1);
        }
        if (element.hasReceiverElement()) {
            this.composeString(t, "ExampleScenario", "receiver", element.getReceiverElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "ExampleScenario", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasInitiatorActiveElement()) {
            this.composeBoolean(t, "ExampleScenario", "initiatorActive", element.getInitiatorActiveElement(), -1);
        }
        if (element.hasReceiverActiveElement()) {
            this.composeBoolean(t, "ExampleScenario", "receiverActive", element.getReceiverActiveElement(), -1);
        }
        if (element.hasRequest()) {
            this.composeExampleScenarioExampleScenarioInstanceContainedInstanceComponent(t, "ExampleScenario", "request", element.getRequest(), -1);
        }
        if (element.hasResponse()) {
            this.composeExampleScenarioExampleScenarioInstanceContainedInstanceComponent(t, "ExampleScenario", "response", element.getResponse(), -1);
        }
    }

    protected void composeExampleScenarioExampleScenarioProcessStepAlternativeComponent(Turtle.Complex parent, String parentType, String name, ExampleScenario.ExampleScenarioProcessStepAlternativeComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "alternative", name, element, index);
        if (element.hasTitleElement()) {
            this.composeString(t, "ExampleScenario", "title", element.getTitleElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "ExampleScenario", "description", element.getDescriptionElement(), -1);
        }
        for (int i = 0; i < element.getStep().size(); ++i) {
            this.composeExampleScenarioExampleScenarioProcessStepComponent(t, "ExampleScenario", "step", element.getStep().get(i), i);
        }
    }

    protected void composeExplanationOfBenefit(Turtle.Complex parent, String parentType, String name, ExplanationOfBenefit element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "ExplanationOfBenefit", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "ExplanationOfBenefit", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "ExplanationOfBenefit", "status", element.getStatusElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "type", element.getType(), -1);
        }
        if (element.hasSubType()) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "subType", element.getSubType(), -1);
        }
        if (element.hasUseElement()) {
            this.composeEnum(t, "ExplanationOfBenefit", "use", element.getUseElement(), -1);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "ExplanationOfBenefit", "patient", element.getPatient(), -1);
        }
        if (element.hasBillablePeriod()) {
            this.composePeriod(t, "ExplanationOfBenefit", "billablePeriod", element.getBillablePeriod(), -1);
        }
        if (element.hasCreatedElement()) {
            this.composeDateTime(t, "ExplanationOfBenefit", "created", element.getCreatedElement(), -1);
        }
        if (element.hasEnterer()) {
            this.composeReference(t, "ExplanationOfBenefit", "enterer", element.getEnterer(), -1);
        }
        if (element.hasInsurer()) {
            this.composeReference(t, "ExplanationOfBenefit", "insurer", element.getInsurer(), -1);
        }
        if (element.hasProvider()) {
            this.composeReference(t, "ExplanationOfBenefit", "provider", element.getProvider(), -1);
        }
        if (element.hasPriority()) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "priority", element.getPriority(), -1);
        }
        if (element.hasFundsReserveRequested()) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "fundsReserveRequested", element.getFundsReserveRequested(), -1);
        }
        if (element.hasFundsReserve()) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "fundsReserve", element.getFundsReserve(), -1);
        }
        for (i = 0; i < element.getRelated().size(); ++i) {
            this.composeExplanationOfBenefitRelatedClaimComponent(t, "ExplanationOfBenefit", "related", element.getRelated().get(i), i);
        }
        if (element.hasPrescription()) {
            this.composeReference(t, "ExplanationOfBenefit", "prescription", element.getPrescription(), -1);
        }
        if (element.hasOriginalPrescription()) {
            this.composeReference(t, "ExplanationOfBenefit", "originalPrescription", element.getOriginalPrescription(), -1);
        }
        if (element.hasPayee()) {
            this.composeExplanationOfBenefitPayeeComponent(t, "ExplanationOfBenefit", "payee", element.getPayee(), -1);
        }
        if (element.hasReferral()) {
            this.composeReference(t, "ExplanationOfBenefit", "referral", element.getReferral(), -1);
        }
        if (element.hasFacility()) {
            this.composeReference(t, "ExplanationOfBenefit", "facility", element.getFacility(), -1);
        }
        if (element.hasClaim()) {
            this.composeReference(t, "ExplanationOfBenefit", "claim", element.getClaim(), -1);
        }
        if (element.hasClaimResponse()) {
            this.composeReference(t, "ExplanationOfBenefit", "claimResponse", element.getClaimResponse(), -1);
        }
        if (element.hasOutcomeElement()) {
            this.composeEnum(t, "ExplanationOfBenefit", "outcome", element.getOutcomeElement(), -1);
        }
        if (element.hasDispositionElement()) {
            this.composeString(t, "ExplanationOfBenefit", "disposition", element.getDispositionElement(), -1);
        }
        for (i = 0; i < element.getPreAuthRef().size(); ++i) {
            this.composeString(t, "ExplanationOfBenefit", "preAuthRef", element.getPreAuthRef().get(i), i);
        }
        for (i = 0; i < element.getPreAuthRefPeriod().size(); ++i) {
            this.composePeriod(t, "ExplanationOfBenefit", "preAuthRefPeriod", element.getPreAuthRefPeriod().get(i), i);
        }
        for (i = 0; i < element.getCareTeam().size(); ++i) {
            this.composeExplanationOfBenefitCareTeamComponent(t, "ExplanationOfBenefit", "careTeam", element.getCareTeam().get(i), i);
        }
        for (i = 0; i < element.getSupportingInfo().size(); ++i) {
            this.composeExplanationOfBenefitSupportingInformationComponent(t, "ExplanationOfBenefit", "supportingInfo", element.getSupportingInfo().get(i), i);
        }
        for (i = 0; i < element.getDiagnosis().size(); ++i) {
            this.composeExplanationOfBenefitDiagnosisComponent(t, "ExplanationOfBenefit", "diagnosis", element.getDiagnosis().get(i), i);
        }
        for (i = 0; i < element.getProcedure().size(); ++i) {
            this.composeExplanationOfBenefitProcedureComponent(t, "ExplanationOfBenefit", "procedure", element.getProcedure().get(i), i);
        }
        if (element.hasPrecedenceElement()) {
            this.composePositiveInt(t, "ExplanationOfBenefit", "precedence", element.getPrecedenceElement(), -1);
        }
        for (i = 0; i < element.getInsurance().size(); ++i) {
            this.composeExplanationOfBenefitInsuranceComponent(t, "ExplanationOfBenefit", "insurance", element.getInsurance().get(i), i);
        }
        if (element.hasAccident()) {
            this.composeExplanationOfBenefitAccidentComponent(t, "ExplanationOfBenefit", "accident", element.getAccident(), -1);
        }
        for (i = 0; i < element.getItem().size(); ++i) {
            this.composeExplanationOfBenefitItemComponent(t, "ExplanationOfBenefit", "item", element.getItem().get(i), i);
        }
        for (i = 0; i < element.getAddItem().size(); ++i) {
            this.composeExplanationOfBenefitAddedItemComponent(t, "ExplanationOfBenefit", "addItem", element.getAddItem().get(i), i);
        }
        for (i = 0; i < element.getAdjudication().size(); ++i) {
            this.composeExplanationOfBenefitAdjudicationComponent(t, "ExplanationOfBenefit", "adjudication", element.getAdjudication().get(i), i);
        }
        for (i = 0; i < element.getTotal().size(); ++i) {
            this.composeExplanationOfBenefitTotalComponent(t, "ExplanationOfBenefit", "total", element.getTotal().get(i), i);
        }
        if (element.hasPayment()) {
            this.composeExplanationOfBenefitPaymentComponent(t, "ExplanationOfBenefit", "payment", element.getPayment(), -1);
        }
        if (element.hasFormCode()) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "formCode", element.getFormCode(), -1);
        }
        if (element.hasForm()) {
            this.composeAttachment(t, "ExplanationOfBenefit", "form", element.getForm(), -1);
        }
        for (i = 0; i < element.getProcessNote().size(); ++i) {
            this.composeExplanationOfBenefitNoteComponent(t, "ExplanationOfBenefit", "processNote", element.getProcessNote().get(i), i);
        }
        if (element.hasBenefitPeriod()) {
            this.composePeriod(t, "ExplanationOfBenefit", "benefitPeriod", element.getBenefitPeriod(), -1);
        }
        for (i = 0; i < element.getBenefitBalance().size(); ++i) {
            this.composeExplanationOfBenefitBenefitBalanceComponent(t, "ExplanationOfBenefit", "benefitBalance", element.getBenefitBalance().get(i), i);
        }
    }

    protected void composeExplanationOfBenefitRelatedClaimComponent(Turtle.Complex parent, String parentType, String name, ExplanationOfBenefit.RelatedClaimComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "related", name, element, index);
        if (element.hasClaim()) {
            this.composeReference(t, "ExplanationOfBenefit", "claim", element.getClaim(), -1);
        }
        if (element.hasRelationship()) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "relationship", element.getRelationship(), -1);
        }
        if (element.hasReference()) {
            this.composeIdentifier(t, "ExplanationOfBenefit", "reference", element.getReference(), -1);
        }
    }

    protected void composeExplanationOfBenefitPayeeComponent(Turtle.Complex parent, String parentType, String name, ExplanationOfBenefit.PayeeComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "payee", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "type", element.getType(), -1);
        }
        if (element.hasParty()) {
            this.composeReference(t, "ExplanationOfBenefit", "party", element.getParty(), -1);
        }
    }

    protected void composeExplanationOfBenefitCareTeamComponent(Turtle.Complex parent, String parentType, String name, ExplanationOfBenefit.CareTeamComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "careTeam", name, element, index);
        if (element.hasSequenceElement()) {
            this.composePositiveInt(t, "ExplanationOfBenefit", "sequence", element.getSequenceElement(), -1);
        }
        if (element.hasProvider()) {
            this.composeReference(t, "ExplanationOfBenefit", "provider", element.getProvider(), -1);
        }
        if (element.hasResponsibleElement()) {
            this.composeBoolean(t, "ExplanationOfBenefit", "responsible", element.getResponsibleElement(), -1);
        }
        if (element.hasRole()) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "role", element.getRole(), -1);
        }
        if (element.hasQualification()) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "qualification", element.getQualification(), -1);
        }
    }

    protected void composeExplanationOfBenefitSupportingInformationComponent(Turtle.Complex parent, String parentType, String name, ExplanationOfBenefit.SupportingInformationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "supportingInfo", name, element, index);
        if (element.hasSequenceElement()) {
            this.composePositiveInt(t, "ExplanationOfBenefit", "sequence", element.getSequenceElement(), -1);
        }
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "category", element.getCategory(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "code", element.getCode(), -1);
        }
        if (element.hasTiming()) {
            this.composeType(t, "ExplanationOfBenefit", "timing", element.getTiming(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "ExplanationOfBenefit", "value", element.getValue(), -1);
        }
        if (element.hasReason()) {
            this.composeCoding(t, "ExplanationOfBenefit", "reason", element.getReason(), -1);
        }
    }

    protected void composeExplanationOfBenefitDiagnosisComponent(Turtle.Complex parent, String parentType, String name, ExplanationOfBenefit.DiagnosisComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "diagnosis", name, element, index);
        if (element.hasSequenceElement()) {
            this.composePositiveInt(t, "ExplanationOfBenefit", "sequence", element.getSequenceElement(), -1);
        }
        if (element.hasDiagnosis()) {
            this.composeType(t, "ExplanationOfBenefit", "diagnosis", element.getDiagnosis(), -1);
        }
        for (int i = 0; i < element.getType().size(); ++i) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "type", element.getType().get(i), i);
        }
        if (element.hasOnAdmission()) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "onAdmission", element.getOnAdmission(), -1);
        }
        if (element.hasPackageCode()) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "packageCode", element.getPackageCode(), -1);
        }
    }

    protected void composeExplanationOfBenefitProcedureComponent(Turtle.Complex parent, String parentType, String name, ExplanationOfBenefit.ProcedureComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "procedure", name, element, index);
        if (element.hasSequenceElement()) {
            this.composePositiveInt(t, "ExplanationOfBenefit", "sequence", element.getSequenceElement(), -1);
        }
        for (i = 0; i < element.getType().size(); ++i) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "type", element.getType().get(i), i);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "ExplanationOfBenefit", "date", element.getDateElement(), -1);
        }
        if (element.hasProcedure()) {
            this.composeType(t, "ExplanationOfBenefit", "procedure", element.getProcedure(), -1);
        }
        for (i = 0; i < element.getUdi().size(); ++i) {
            this.composeReference(t, "ExplanationOfBenefit", "udi", element.getUdi().get(i), i);
        }
    }

    protected void composeExplanationOfBenefitInsuranceComponent(Turtle.Complex parent, String parentType, String name, ExplanationOfBenefit.InsuranceComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "insurance", name, element, index);
        if (element.hasFocalElement()) {
            this.composeBoolean(t, "ExplanationOfBenefit", "focal", element.getFocalElement(), -1);
        }
        if (element.hasCoverage()) {
            this.composeReference(t, "ExplanationOfBenefit", "coverage", element.getCoverage(), -1);
        }
        for (int i = 0; i < element.getPreAuthRef().size(); ++i) {
            this.composeString(t, "ExplanationOfBenefit", "preAuthRef", element.getPreAuthRef().get(i), i);
        }
    }

    protected void composeExplanationOfBenefitAccidentComponent(Turtle.Complex parent, String parentType, String name, ExplanationOfBenefit.AccidentComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "accident", name, element, index);
        if (element.hasDateElement()) {
            this.composeDate(t, "ExplanationOfBenefit", "date", element.getDateElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "type", element.getType(), -1);
        }
        if (element.hasLocation()) {
            this.composeType(t, "ExplanationOfBenefit", "location", element.getLocation(), -1);
        }
    }

    protected void composeExplanationOfBenefitItemComponent(Turtle.Complex parent, String parentType, String name, ExplanationOfBenefit.ItemComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "item", name, element, index);
        if (element.hasSequenceElement()) {
            this.composePositiveInt(t, "ExplanationOfBenefit", "sequence", element.getSequenceElement(), -1);
        }
        for (i = 0; i < element.getCareTeamSequence().size(); ++i) {
            this.composePositiveInt(t, "ExplanationOfBenefit", "careTeamSequence", element.getCareTeamSequence().get(i), i);
        }
        for (i = 0; i < element.getDiagnosisSequence().size(); ++i) {
            this.composePositiveInt(t, "ExplanationOfBenefit", "diagnosisSequence", element.getDiagnosisSequence().get(i), i);
        }
        for (i = 0; i < element.getProcedureSequence().size(); ++i) {
            this.composePositiveInt(t, "ExplanationOfBenefit", "procedureSequence", element.getProcedureSequence().get(i), i);
        }
        for (i = 0; i < element.getInformationSequence().size(); ++i) {
            this.composePositiveInt(t, "ExplanationOfBenefit", "informationSequence", element.getInformationSequence().get(i), i);
        }
        if (element.hasRevenue()) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "revenue", element.getRevenue(), -1);
        }
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "category", element.getCategory(), -1);
        }
        if (element.hasProductOrService()) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "productOrService", element.getProductOrService(), -1);
        }
        for (i = 0; i < element.getModifier().size(); ++i) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "modifier", element.getModifier().get(i), i);
        }
        for (i = 0; i < element.getProgramCode().size(); ++i) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "programCode", element.getProgramCode().get(i), i);
        }
        if (element.hasServiced()) {
            this.composeType(t, "ExplanationOfBenefit", "serviced", element.getServiced(), -1);
        }
        if (element.hasLocation()) {
            this.composeType(t, "ExplanationOfBenefit", "location", element.getLocation(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "ExplanationOfBenefit", "quantity", element.getQuantity(), -1);
        }
        if (element.hasUnitPrice()) {
            this.composeMoney(t, "ExplanationOfBenefit", "unitPrice", element.getUnitPrice(), -1);
        }
        if (element.hasFactorElement()) {
            this.composeDecimal(t, "ExplanationOfBenefit", "factor", element.getFactorElement(), -1);
        }
        if (element.hasNet()) {
            this.composeMoney(t, "ExplanationOfBenefit", "net", element.getNet(), -1);
        }
        for (i = 0; i < element.getUdi().size(); ++i) {
            this.composeReference(t, "ExplanationOfBenefit", "udi", element.getUdi().get(i), i);
        }
        if (element.hasBodySite()) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "bodySite", element.getBodySite(), -1);
        }
        for (i = 0; i < element.getSubSite().size(); ++i) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "subSite", element.getSubSite().get(i), i);
        }
        for (i = 0; i < element.getEncounter().size(); ++i) {
            this.composeReference(t, "ExplanationOfBenefit", "encounter", element.getEncounter().get(i), i);
        }
        for (i = 0; i < element.getNoteNumber().size(); ++i) {
            this.composePositiveInt(t, "ExplanationOfBenefit", "noteNumber", element.getNoteNumber().get(i), i);
        }
        for (i = 0; i < element.getAdjudication().size(); ++i) {
            this.composeExplanationOfBenefitAdjudicationComponent(t, "ExplanationOfBenefit", "adjudication", element.getAdjudication().get(i), i);
        }
        for (i = 0; i < element.getDetail().size(); ++i) {
            this.composeExplanationOfBenefitDetailComponent(t, "ExplanationOfBenefit", "detail", element.getDetail().get(i), i);
        }
    }

    protected void composeExplanationOfBenefitAdjudicationComponent(Turtle.Complex parent, String parentType, String name, ExplanationOfBenefit.AdjudicationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "adjudication", name, element, index);
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "category", element.getCategory(), -1);
        }
        if (element.hasReason()) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "reason", element.getReason(), -1);
        }
        if (element.hasAmount()) {
            this.composeMoney(t, "ExplanationOfBenefit", "amount", element.getAmount(), -1);
        }
        if (element.hasValueElement()) {
            this.composeDecimal(t, "ExplanationOfBenefit", "value", element.getValueElement(), -1);
        }
    }

    protected void composeExplanationOfBenefitDetailComponent(Turtle.Complex parent, String parentType, String name, ExplanationOfBenefit.DetailComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "detail", name, element, index);
        if (element.hasSequenceElement()) {
            this.composePositiveInt(t, "ExplanationOfBenefit", "sequence", element.getSequenceElement(), -1);
        }
        if (element.hasRevenue()) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "revenue", element.getRevenue(), -1);
        }
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "category", element.getCategory(), -1);
        }
        if (element.hasProductOrService()) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "productOrService", element.getProductOrService(), -1);
        }
        for (i = 0; i < element.getModifier().size(); ++i) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "modifier", element.getModifier().get(i), i);
        }
        for (i = 0; i < element.getProgramCode().size(); ++i) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "programCode", element.getProgramCode().get(i), i);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "ExplanationOfBenefit", "quantity", element.getQuantity(), -1);
        }
        if (element.hasUnitPrice()) {
            this.composeMoney(t, "ExplanationOfBenefit", "unitPrice", element.getUnitPrice(), -1);
        }
        if (element.hasFactorElement()) {
            this.composeDecimal(t, "ExplanationOfBenefit", "factor", element.getFactorElement(), -1);
        }
        if (element.hasNet()) {
            this.composeMoney(t, "ExplanationOfBenefit", "net", element.getNet(), -1);
        }
        for (i = 0; i < element.getUdi().size(); ++i) {
            this.composeReference(t, "ExplanationOfBenefit", "udi", element.getUdi().get(i), i);
        }
        for (i = 0; i < element.getNoteNumber().size(); ++i) {
            this.composePositiveInt(t, "ExplanationOfBenefit", "noteNumber", element.getNoteNumber().get(i), i);
        }
        for (i = 0; i < element.getAdjudication().size(); ++i) {
            this.composeExplanationOfBenefitAdjudicationComponent(t, "ExplanationOfBenefit", "adjudication", element.getAdjudication().get(i), i);
        }
        for (i = 0; i < element.getSubDetail().size(); ++i) {
            this.composeExplanationOfBenefitSubDetailComponent(t, "ExplanationOfBenefit", "subDetail", element.getSubDetail().get(i), i);
        }
    }

    protected void composeExplanationOfBenefitSubDetailComponent(Turtle.Complex parent, String parentType, String name, ExplanationOfBenefit.SubDetailComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "subDetail", name, element, index);
        if (element.hasSequenceElement()) {
            this.composePositiveInt(t, "ExplanationOfBenefit", "sequence", element.getSequenceElement(), -1);
        }
        if (element.hasRevenue()) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "revenue", element.getRevenue(), -1);
        }
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "category", element.getCategory(), -1);
        }
        if (element.hasProductOrService()) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "productOrService", element.getProductOrService(), -1);
        }
        for (i = 0; i < element.getModifier().size(); ++i) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "modifier", element.getModifier().get(i), i);
        }
        for (i = 0; i < element.getProgramCode().size(); ++i) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "programCode", element.getProgramCode().get(i), i);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "ExplanationOfBenefit", "quantity", element.getQuantity(), -1);
        }
        if (element.hasUnitPrice()) {
            this.composeMoney(t, "ExplanationOfBenefit", "unitPrice", element.getUnitPrice(), -1);
        }
        if (element.hasFactorElement()) {
            this.composeDecimal(t, "ExplanationOfBenefit", "factor", element.getFactorElement(), -1);
        }
        if (element.hasNet()) {
            this.composeMoney(t, "ExplanationOfBenefit", "net", element.getNet(), -1);
        }
        for (i = 0; i < element.getUdi().size(); ++i) {
            this.composeReference(t, "ExplanationOfBenefit", "udi", element.getUdi().get(i), i);
        }
        for (i = 0; i < element.getNoteNumber().size(); ++i) {
            this.composePositiveInt(t, "ExplanationOfBenefit", "noteNumber", element.getNoteNumber().get(i), i);
        }
        for (i = 0; i < element.getAdjudication().size(); ++i) {
            this.composeExplanationOfBenefitAdjudicationComponent(t, "ExplanationOfBenefit", "adjudication", element.getAdjudication().get(i), i);
        }
    }

    protected void composeExplanationOfBenefitAddedItemComponent(Turtle.Complex parent, String parentType, String name, ExplanationOfBenefit.AddedItemComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "addItem", name, element, index);
        for (i = 0; i < element.getItemSequence().size(); ++i) {
            this.composePositiveInt(t, "ExplanationOfBenefit", "itemSequence", element.getItemSequence().get(i), i);
        }
        for (i = 0; i < element.getDetailSequence().size(); ++i) {
            this.composePositiveInt(t, "ExplanationOfBenefit", "detailSequence", element.getDetailSequence().get(i), i);
        }
        for (i = 0; i < element.getSubDetailSequence().size(); ++i) {
            this.composePositiveInt(t, "ExplanationOfBenefit", "subDetailSequence", element.getSubDetailSequence().get(i), i);
        }
        for (i = 0; i < element.getProvider().size(); ++i) {
            this.composeReference(t, "ExplanationOfBenefit", "provider", element.getProvider().get(i), i);
        }
        if (element.hasProductOrService()) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "productOrService", element.getProductOrService(), -1);
        }
        for (i = 0; i < element.getModifier().size(); ++i) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "modifier", element.getModifier().get(i), i);
        }
        for (i = 0; i < element.getProgramCode().size(); ++i) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "programCode", element.getProgramCode().get(i), i);
        }
        if (element.hasServiced()) {
            this.composeType(t, "ExplanationOfBenefit", "serviced", element.getServiced(), -1);
        }
        if (element.hasLocation()) {
            this.composeType(t, "ExplanationOfBenefit", "location", element.getLocation(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "ExplanationOfBenefit", "quantity", element.getQuantity(), -1);
        }
        if (element.hasUnitPrice()) {
            this.composeMoney(t, "ExplanationOfBenefit", "unitPrice", element.getUnitPrice(), -1);
        }
        if (element.hasFactorElement()) {
            this.composeDecimal(t, "ExplanationOfBenefit", "factor", element.getFactorElement(), -1);
        }
        if (element.hasNet()) {
            this.composeMoney(t, "ExplanationOfBenefit", "net", element.getNet(), -1);
        }
        if (element.hasBodySite()) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "bodySite", element.getBodySite(), -1);
        }
        for (i = 0; i < element.getSubSite().size(); ++i) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "subSite", element.getSubSite().get(i), i);
        }
        for (i = 0; i < element.getNoteNumber().size(); ++i) {
            this.composePositiveInt(t, "ExplanationOfBenefit", "noteNumber", element.getNoteNumber().get(i), i);
        }
        for (i = 0; i < element.getAdjudication().size(); ++i) {
            this.composeExplanationOfBenefitAdjudicationComponent(t, "ExplanationOfBenefit", "adjudication", element.getAdjudication().get(i), i);
        }
        for (i = 0; i < element.getDetail().size(); ++i) {
            this.composeExplanationOfBenefitAddedItemDetailComponent(t, "ExplanationOfBenefit", "detail", element.getDetail().get(i), i);
        }
    }

    protected void composeExplanationOfBenefitAddedItemDetailComponent(Turtle.Complex parent, String parentType, String name, ExplanationOfBenefit.AddedItemDetailComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "detail", name, element, index);
        if (element.hasProductOrService()) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "productOrService", element.getProductOrService(), -1);
        }
        for (i = 0; i < element.getModifier().size(); ++i) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "modifier", element.getModifier().get(i), i);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "ExplanationOfBenefit", "quantity", element.getQuantity(), -1);
        }
        if (element.hasUnitPrice()) {
            this.composeMoney(t, "ExplanationOfBenefit", "unitPrice", element.getUnitPrice(), -1);
        }
        if (element.hasFactorElement()) {
            this.composeDecimal(t, "ExplanationOfBenefit", "factor", element.getFactorElement(), -1);
        }
        if (element.hasNet()) {
            this.composeMoney(t, "ExplanationOfBenefit", "net", element.getNet(), -1);
        }
        for (i = 0; i < element.getNoteNumber().size(); ++i) {
            this.composePositiveInt(t, "ExplanationOfBenefit", "noteNumber", element.getNoteNumber().get(i), i);
        }
        for (i = 0; i < element.getAdjudication().size(); ++i) {
            this.composeExplanationOfBenefitAdjudicationComponent(t, "ExplanationOfBenefit", "adjudication", element.getAdjudication().get(i), i);
        }
        for (i = 0; i < element.getSubDetail().size(); ++i) {
            this.composeExplanationOfBenefitAddedItemDetailSubDetailComponent(t, "ExplanationOfBenefit", "subDetail", element.getSubDetail().get(i), i);
        }
    }

    protected void composeExplanationOfBenefitAddedItemDetailSubDetailComponent(Turtle.Complex parent, String parentType, String name, ExplanationOfBenefit.AddedItemDetailSubDetailComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "subDetail", name, element, index);
        if (element.hasProductOrService()) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "productOrService", element.getProductOrService(), -1);
        }
        for (i = 0; i < element.getModifier().size(); ++i) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "modifier", element.getModifier().get(i), i);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "ExplanationOfBenefit", "quantity", element.getQuantity(), -1);
        }
        if (element.hasUnitPrice()) {
            this.composeMoney(t, "ExplanationOfBenefit", "unitPrice", element.getUnitPrice(), -1);
        }
        if (element.hasFactorElement()) {
            this.composeDecimal(t, "ExplanationOfBenefit", "factor", element.getFactorElement(), -1);
        }
        if (element.hasNet()) {
            this.composeMoney(t, "ExplanationOfBenefit", "net", element.getNet(), -1);
        }
        for (i = 0; i < element.getNoteNumber().size(); ++i) {
            this.composePositiveInt(t, "ExplanationOfBenefit", "noteNumber", element.getNoteNumber().get(i), i);
        }
        for (i = 0; i < element.getAdjudication().size(); ++i) {
            this.composeExplanationOfBenefitAdjudicationComponent(t, "ExplanationOfBenefit", "adjudication", element.getAdjudication().get(i), i);
        }
    }

    protected void composeExplanationOfBenefitTotalComponent(Turtle.Complex parent, String parentType, String name, ExplanationOfBenefit.TotalComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "total", name, element, index);
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "category", element.getCategory(), -1);
        }
        if (element.hasAmount()) {
            this.composeMoney(t, "ExplanationOfBenefit", "amount", element.getAmount(), -1);
        }
    }

    protected void composeExplanationOfBenefitPaymentComponent(Turtle.Complex parent, String parentType, String name, ExplanationOfBenefit.PaymentComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "payment", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "type", element.getType(), -1);
        }
        if (element.hasAdjustment()) {
            this.composeMoney(t, "ExplanationOfBenefit", "adjustment", element.getAdjustment(), -1);
        }
        if (element.hasAdjustmentReason()) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "adjustmentReason", element.getAdjustmentReason(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDate(t, "ExplanationOfBenefit", "date", element.getDateElement(), -1);
        }
        if (element.hasAmount()) {
            this.composeMoney(t, "ExplanationOfBenefit", "amount", element.getAmount(), -1);
        }
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "ExplanationOfBenefit", "identifier", element.getIdentifier(), -1);
        }
    }

    protected void composeExplanationOfBenefitNoteComponent(Turtle.Complex parent, String parentType, String name, ExplanationOfBenefit.NoteComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "processNote", name, element, index);
        if (element.hasNumberElement()) {
            this.composePositiveInt(t, "ExplanationOfBenefit", "number", element.getNumberElement(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeEnum(t, "ExplanationOfBenefit", "type", element.getTypeElement(), -1);
        }
        if (element.hasTextElement()) {
            this.composeString(t, "ExplanationOfBenefit", "text", element.getTextElement(), -1);
        }
        if (element.hasLanguage()) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "language", element.getLanguage(), -1);
        }
    }

    protected void composeExplanationOfBenefitBenefitBalanceComponent(Turtle.Complex parent, String parentType, String name, ExplanationOfBenefit.BenefitBalanceComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "benefitBalance", name, element, index);
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "category", element.getCategory(), -1);
        }
        if (element.hasExcludedElement()) {
            this.composeBoolean(t, "ExplanationOfBenefit", "excluded", element.getExcludedElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "ExplanationOfBenefit", "name", element.getNameElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "ExplanationOfBenefit", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasNetwork()) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "network", element.getNetwork(), -1);
        }
        if (element.hasUnit()) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "unit", element.getUnit(), -1);
        }
        if (element.hasTerm()) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "term", element.getTerm(), -1);
        }
        for (int i = 0; i < element.getFinancial().size(); ++i) {
            this.composeExplanationOfBenefitBenefitComponent(t, "ExplanationOfBenefit", "financial", element.getFinancial().get(i), i);
        }
    }

    protected void composeExplanationOfBenefitBenefitComponent(Turtle.Complex parent, String parentType, String name, ExplanationOfBenefit.BenefitComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "financial", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "type", element.getType(), -1);
        }
        if (element.hasAllowed()) {
            this.composeType(t, "ExplanationOfBenefit", "allowed", element.getAllowed(), -1);
        }
        if (element.hasUsed()) {
            this.composeType(t, "ExplanationOfBenefit", "used", element.getUsed(), -1);
        }
    }

    protected void composeFamilyMemberHistory(Turtle.Complex parent, String parentType, String name, FamilyMemberHistory element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "FamilyMemberHistory", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "FamilyMemberHistory", "identifier", element.getIdentifier().get(i), i);
        }
        for (i = 0; i < element.getInstantiatesCanonical().size(); ++i) {
            this.composeCanonical(t, "FamilyMemberHistory", "instantiatesCanonical", element.getInstantiatesCanonical().get(i), i);
        }
        for (i = 0; i < element.getInstantiatesUri().size(); ++i) {
            this.composeUri(t, "FamilyMemberHistory", "instantiatesUri", element.getInstantiatesUri().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "FamilyMemberHistory", "status", element.getStatusElement(), -1);
        }
        if (element.hasDataAbsentReason()) {
            this.composeCodeableConcept(t, "FamilyMemberHistory", "dataAbsentReason", element.getDataAbsentReason(), -1);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "FamilyMemberHistory", "patient", element.getPatient(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "FamilyMemberHistory", "date", element.getDateElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "FamilyMemberHistory", "name", element.getNameElement(), -1);
        }
        if (element.hasRelationship()) {
            this.composeCodeableConcept(t, "FamilyMemberHistory", "relationship", element.getRelationship(), -1);
        }
        if (element.hasSex()) {
            this.composeCodeableConcept(t, "FamilyMemberHistory", "sex", element.getSex(), -1);
        }
        if (element.hasBorn()) {
            this.composeType(t, "FamilyMemberHistory", "born", element.getBorn(), -1);
        }
        if (element.hasAge()) {
            this.composeType(t, "FamilyMemberHistory", "age", element.getAge(), -1);
        }
        if (element.hasEstimatedAgeElement()) {
            this.composeBoolean(t, "FamilyMemberHistory", "estimatedAge", element.getEstimatedAgeElement(), -1);
        }
        if (element.hasDeceased()) {
            this.composeType(t, "FamilyMemberHistory", "deceased", element.getDeceased(), -1);
        }
        for (i = 0; i < element.getReasonCode().size(); ++i) {
            this.composeCodeableConcept(t, "FamilyMemberHistory", "reasonCode", element.getReasonCode().get(i), i);
        }
        for (i = 0; i < element.getReasonReference().size(); ++i) {
            this.composeReference(t, "FamilyMemberHistory", "reasonReference", element.getReasonReference().get(i), i);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "FamilyMemberHistory", "note", element.getNote().get(i), i);
        }
        for (i = 0; i < element.getCondition().size(); ++i) {
            this.composeFamilyMemberHistoryFamilyMemberHistoryConditionComponent(t, "FamilyMemberHistory", "condition", element.getCondition().get(i), i);
        }
    }

    protected void composeFamilyMemberHistoryFamilyMemberHistoryConditionComponent(Turtle.Complex parent, String parentType, String name, FamilyMemberHistory.FamilyMemberHistoryConditionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "condition", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "FamilyMemberHistory", "code", element.getCode(), -1);
        }
        if (element.hasOutcome()) {
            this.composeCodeableConcept(t, "FamilyMemberHistory", "outcome", element.getOutcome(), -1);
        }
        if (element.hasContributedToDeathElement()) {
            this.composeBoolean(t, "FamilyMemberHistory", "contributedToDeath", element.getContributedToDeathElement(), -1);
        }
        if (element.hasOnset()) {
            this.composeType(t, "FamilyMemberHistory", "onset", element.getOnset(), -1);
        }
        for (int i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "FamilyMemberHistory", "note", element.getNote().get(i), i);
        }
    }

    protected void composeFlag(Turtle.Complex parent, String parentType, String name, Flag element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Flag", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Flag", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Flag", "status", element.getStatusElement(), -1);
        }
        for (i = 0; i < element.getCategory().size(); ++i) {
            this.composeCodeableConcept(t, "Flag", "category", element.getCategory().get(i), i);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "Flag", "code", element.getCode(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "Flag", "subject", element.getSubject(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "Flag", "period", element.getPeriod(), -1);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "Flag", "encounter", element.getEncounter(), -1);
        }
        if (element.hasAuthor()) {
            this.composeReference(t, "Flag", "author", element.getAuthor(), -1);
        }
    }

    protected void composeGoal(Turtle.Complex parent, String parentType, String name, Goal element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Goal", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Goal", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasLifecycleStatusElement()) {
            this.composeEnum(t, "Goal", "lifecycleStatus", element.getLifecycleStatusElement(), -1);
        }
        if (element.hasAchievementStatus()) {
            this.composeCodeableConcept(t, "Goal", "achievementStatus", element.getAchievementStatus(), -1);
        }
        for (i = 0; i < element.getCategory().size(); ++i) {
            this.composeCodeableConcept(t, "Goal", "category", element.getCategory().get(i), i);
        }
        if (element.hasPriority()) {
            this.composeCodeableConcept(t, "Goal", "priority", element.getPriority(), -1);
        }
        if (element.hasDescription()) {
            this.composeCodeableConcept(t, "Goal", "description", element.getDescription(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "Goal", "subject", element.getSubject(), -1);
        }
        if (element.hasStart()) {
            this.composeType(t, "Goal", "start", element.getStart(), -1);
        }
        for (i = 0; i < element.getTarget().size(); ++i) {
            this.composeGoalGoalTargetComponent(t, "Goal", "target", element.getTarget().get(i), i);
        }
        if (element.hasStatusDateElement()) {
            this.composeDate(t, "Goal", "statusDate", element.getStatusDateElement(), -1);
        }
        if (element.hasStatusReasonElement()) {
            this.composeString(t, "Goal", "statusReason", element.getStatusReasonElement(), -1);
        }
        if (element.hasExpressedBy()) {
            this.composeReference(t, "Goal", "expressedBy", element.getExpressedBy(), -1);
        }
        for (i = 0; i < element.getAddresses().size(); ++i) {
            this.composeReference(t, "Goal", "addresses", element.getAddresses().get(i), i);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "Goal", "note", element.getNote().get(i), i);
        }
        for (i = 0; i < element.getOutcomeCode().size(); ++i) {
            this.composeCodeableConcept(t, "Goal", "outcomeCode", element.getOutcomeCode().get(i), i);
        }
        for (i = 0; i < element.getOutcomeReference().size(); ++i) {
            this.composeReference(t, "Goal", "outcomeReference", element.getOutcomeReference().get(i), i);
        }
    }

    protected void composeGoalGoalTargetComponent(Turtle.Complex parent, String parentType, String name, Goal.GoalTargetComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "target", name, element, index);
        if (element.hasMeasure()) {
            this.composeCodeableConcept(t, "Goal", "measure", element.getMeasure(), -1);
        }
        if (element.hasDetail()) {
            this.composeType(t, "Goal", "detail", element.getDetail(), -1);
        }
        if (element.hasDue()) {
            this.composeType(t, "Goal", "due", element.getDue(), -1);
        }
    }

    protected void composeGraphDefinition(Turtle.Complex parent, String parentType, String name, GraphDefinition element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "GraphDefinition", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "GraphDefinition", "url", element.getUrlElement(), -1);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "GraphDefinition", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "GraphDefinition", "name", element.getNameElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "GraphDefinition", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "GraphDefinition", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "GraphDefinition", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "GraphDefinition", "publisher", element.getPublisherElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeContactDetail(t, "GraphDefinition", "contact", element.getContact().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "GraphDefinition", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getUseContext().size(); ++i) {
            this.composeUsageContext(t, "GraphDefinition", "useContext", element.getUseContext().get(i), i);
        }
        for (i = 0; i < element.getJurisdiction().size(); ++i) {
            this.composeCodeableConcept(t, "GraphDefinition", "jurisdiction", element.getJurisdiction().get(i), i);
        }
        if (element.hasPurposeElement()) {
            this.composeMarkdown(t, "GraphDefinition", "purpose", element.getPurposeElement(), -1);
        }
        if (element.hasStartElement()) {
            this.composeCode(t, "GraphDefinition", "start", element.getStartElement(), -1);
        }
        if (element.hasProfileElement()) {
            this.composeCanonical(t, "GraphDefinition", "profile", element.getProfileElement(), -1);
        }
        for (i = 0; i < element.getLink().size(); ++i) {
            this.composeGraphDefinitionGraphDefinitionLinkComponent(t, "GraphDefinition", "link", element.getLink().get(i), i);
        }
    }

    protected void composeGraphDefinitionGraphDefinitionLinkComponent(Turtle.Complex parent, String parentType, String name, GraphDefinition.GraphDefinitionLinkComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "link", name, element, index);
        if (element.hasPathElement()) {
            this.composeString(t, "GraphDefinition", "path", element.getPathElement(), -1);
        }
        if (element.hasSliceNameElement()) {
            this.composeString(t, "GraphDefinition", "sliceName", element.getSliceNameElement(), -1);
        }
        if (element.hasMinElement()) {
            this.composeInteger(t, "GraphDefinition", "min", element.getMinElement(), -1);
        }
        if (element.hasMaxElement()) {
            this.composeString(t, "GraphDefinition", "max", element.getMaxElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "GraphDefinition", "description", element.getDescriptionElement(), -1);
        }
        for (int i = 0; i < element.getTarget().size(); ++i) {
            this.composeGraphDefinitionGraphDefinitionLinkTargetComponent(t, "GraphDefinition", "target", element.getTarget().get(i), i);
        }
    }

    protected void composeGraphDefinitionGraphDefinitionLinkTargetComponent(Turtle.Complex parent, String parentType, String name, GraphDefinition.GraphDefinitionLinkTargetComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "target", name, element, index);
        if (element.hasTypeElement()) {
            this.composeCode(t, "GraphDefinition", "type", element.getTypeElement(), -1);
        }
        if (element.hasParamsElement()) {
            this.composeString(t, "GraphDefinition", "params", element.getParamsElement(), -1);
        }
        if (element.hasProfileElement()) {
            this.composeCanonical(t, "GraphDefinition", "profile", element.getProfileElement(), -1);
        }
        for (i = 0; i < element.getCompartment().size(); ++i) {
            this.composeGraphDefinitionGraphDefinitionLinkTargetCompartmentComponent(t, "GraphDefinition", "compartment", element.getCompartment().get(i), i);
        }
        for (i = 0; i < element.getLink().size(); ++i) {
            this.composeGraphDefinitionGraphDefinitionLinkComponent(t, "GraphDefinition", "link", element.getLink().get(i), i);
        }
    }

    protected void composeGraphDefinitionGraphDefinitionLinkTargetCompartmentComponent(Turtle.Complex parent, String parentType, String name, GraphDefinition.GraphDefinitionLinkTargetCompartmentComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "compartment", name, element, index);
        if (element.hasUseElement()) {
            this.composeEnum(t, "GraphDefinition", "use", element.getUseElement(), -1);
        }
        if (element.hasCodeElement()) {
            this.composeEnum(t, "GraphDefinition", "code", element.getCodeElement(), -1);
        }
        if (element.hasRuleElement()) {
            this.composeEnum(t, "GraphDefinition", "rule", element.getRuleElement(), -1);
        }
        if (element.hasExpressionElement()) {
            this.composeString(t, "GraphDefinition", "expression", element.getExpressionElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "GraphDefinition", "description", element.getDescriptionElement(), -1);
        }
    }

    protected void composeGroup(Turtle.Complex parent, String parentType, String name, Group element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Group", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Group", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasActiveElement()) {
            this.composeBoolean(t, "Group", "active", element.getActiveElement(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeEnum(t, "Group", "type", element.getTypeElement(), -1);
        }
        if (element.hasActualElement()) {
            this.composeBoolean(t, "Group", "actual", element.getActualElement(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "Group", "code", element.getCode(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "Group", "name", element.getNameElement(), -1);
        }
        if (element.hasQuantityElement()) {
            this.composeUnsignedInt(t, "Group", "quantity", element.getQuantityElement(), -1);
        }
        if (element.hasManagingEntity()) {
            this.composeReference(t, "Group", "managingEntity", element.getManagingEntity(), -1);
        }
        for (i = 0; i < element.getCharacteristic().size(); ++i) {
            this.composeGroupGroupCharacteristicComponent(t, "Group", "characteristic", element.getCharacteristic().get(i), i);
        }
        for (i = 0; i < element.getMember().size(); ++i) {
            this.composeGroupGroupMemberComponent(t, "Group", "member", element.getMember().get(i), i);
        }
    }

    protected void composeGroupGroupCharacteristicComponent(Turtle.Complex parent, String parentType, String name, Group.GroupCharacteristicComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "characteristic", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "Group", "code", element.getCode(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "Group", "value", element.getValue(), -1);
        }
        if (element.hasExcludeElement()) {
            this.composeBoolean(t, "Group", "exclude", element.getExcludeElement(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "Group", "period", element.getPeriod(), -1);
        }
    }

    protected void composeGroupGroupMemberComponent(Turtle.Complex parent, String parentType, String name, Group.GroupMemberComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "member", name, element, index);
        if (element.hasEntity()) {
            this.composeReference(t, "Group", "entity", element.getEntity(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "Group", "period", element.getPeriod(), -1);
        }
        if (element.hasInactiveElement()) {
            this.composeBoolean(t, "Group", "inactive", element.getInactiveElement(), -1);
        }
    }

    protected void composeGuidanceResponse(Turtle.Complex parent, String parentType, String name, GuidanceResponse element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "GuidanceResponse", name, element, index);
        if (element.hasRequestIdentifier()) {
            this.composeIdentifier(t, "GuidanceResponse", "requestIdentifier", element.getRequestIdentifier(), -1);
        }
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "GuidanceResponse", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasModule()) {
            this.composeType(t, "GuidanceResponse", "module", element.getModule(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "GuidanceResponse", "status", element.getStatusElement(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "GuidanceResponse", "subject", element.getSubject(), -1);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "GuidanceResponse", "encounter", element.getEncounter(), -1);
        }
        if (element.hasOccurrenceDateTimeElement()) {
            this.composeDateTime(t, "GuidanceResponse", "occurrenceDateTime", element.getOccurrenceDateTimeElement(), -1);
        }
        if (element.hasPerformer()) {
            this.composeReference(t, "GuidanceResponse", "performer", element.getPerformer(), -1);
        }
        for (i = 0; i < element.getReasonCode().size(); ++i) {
            this.composeCodeableConcept(t, "GuidanceResponse", "reasonCode", element.getReasonCode().get(i), i);
        }
        for (i = 0; i < element.getReasonReference().size(); ++i) {
            this.composeReference(t, "GuidanceResponse", "reasonReference", element.getReasonReference().get(i), i);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "GuidanceResponse", "note", element.getNote().get(i), i);
        }
        for (i = 0; i < element.getEvaluationMessage().size(); ++i) {
            this.composeReference(t, "GuidanceResponse", "evaluationMessage", element.getEvaluationMessage().get(i), i);
        }
        if (element.hasOutputParameters()) {
            this.composeReference(t, "GuidanceResponse", "outputParameters", element.getOutputParameters(), -1);
        }
        if (element.hasResult()) {
            this.composeReference(t, "GuidanceResponse", "result", element.getResult(), -1);
        }
        for (i = 0; i < element.getDataRequirement().size(); ++i) {
            this.composeDataRequirement(t, "GuidanceResponse", "dataRequirement", element.getDataRequirement().get(i), i);
        }
    }

    protected void composeHealthcareService(Turtle.Complex parent, String parentType, String name, HealthcareService element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "HealthcareService", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "HealthcareService", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasActiveElement()) {
            this.composeBoolean(t, "HealthcareService", "active", element.getActiveElement(), -1);
        }
        if (element.hasProvidedBy()) {
            this.composeReference(t, "HealthcareService", "providedBy", element.getProvidedBy(), -1);
        }
        for (i = 0; i < element.getCategory().size(); ++i) {
            this.composeCodeableConcept(t, "HealthcareService", "category", element.getCategory().get(i), i);
        }
        for (i = 0; i < element.getType().size(); ++i) {
            this.composeCodeableConcept(t, "HealthcareService", "type", element.getType().get(i), i);
        }
        for (i = 0; i < element.getSpecialty().size(); ++i) {
            this.composeCodeableConcept(t, "HealthcareService", "specialty", element.getSpecialty().get(i), i);
        }
        for (i = 0; i < element.getLocation().size(); ++i) {
            this.composeReference(t, "HealthcareService", "location", element.getLocation().get(i), i);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "HealthcareService", "name", element.getNameElement(), -1);
        }
        if (element.hasCommentElement()) {
            this.composeString(t, "HealthcareService", "comment", element.getCommentElement(), -1);
        }
        if (element.hasExtraDetailsElement()) {
            this.composeMarkdown(t, "HealthcareService", "extraDetails", element.getExtraDetailsElement(), -1);
        }
        if (element.hasPhoto()) {
            this.composeAttachment(t, "HealthcareService", "photo", element.getPhoto(), -1);
        }
        for (i = 0; i < element.getTelecom().size(); ++i) {
            this.composeContactPoint(t, "HealthcareService", "telecom", element.getTelecom().get(i), i);
        }
        for (i = 0; i < element.getCoverageArea().size(); ++i) {
            this.composeReference(t, "HealthcareService", "coverageArea", element.getCoverageArea().get(i), i);
        }
        for (i = 0; i < element.getServiceProvisionCode().size(); ++i) {
            this.composeCodeableConcept(t, "HealthcareService", "serviceProvisionCode", element.getServiceProvisionCode().get(i), i);
        }
        for (i = 0; i < element.getEligibility().size(); ++i) {
            this.composeHealthcareServiceHealthcareServiceEligibilityComponent(t, "HealthcareService", "eligibility", element.getEligibility().get(i), i);
        }
        for (i = 0; i < element.getProgram().size(); ++i) {
            this.composeCodeableConcept(t, "HealthcareService", "program", element.getProgram().get(i), i);
        }
        for (i = 0; i < element.getCharacteristic().size(); ++i) {
            this.composeCodeableConcept(t, "HealthcareService", "characteristic", element.getCharacteristic().get(i), i);
        }
        for (i = 0; i < element.getCommunication().size(); ++i) {
            this.composeCodeableConcept(t, "HealthcareService", "communication", element.getCommunication().get(i), i);
        }
        for (i = 0; i < element.getReferralMethod().size(); ++i) {
            this.composeCodeableConcept(t, "HealthcareService", "referralMethod", element.getReferralMethod().get(i), i);
        }
        if (element.hasAppointmentRequiredElement()) {
            this.composeBoolean(t, "HealthcareService", "appointmentRequired", element.getAppointmentRequiredElement(), -1);
        }
        for (i = 0; i < element.getAvailableTime().size(); ++i) {
            this.composeHealthcareServiceHealthcareServiceAvailableTimeComponent(t, "HealthcareService", "availableTime", element.getAvailableTime().get(i), i);
        }
        for (i = 0; i < element.getNotAvailable().size(); ++i) {
            this.composeHealthcareServiceHealthcareServiceNotAvailableComponent(t, "HealthcareService", "notAvailable", element.getNotAvailable().get(i), i);
        }
        if (element.hasAvailabilityExceptionsElement()) {
            this.composeString(t, "HealthcareService", "availabilityExceptions", element.getAvailabilityExceptionsElement(), -1);
        }
        for (i = 0; i < element.getEndpoint().size(); ++i) {
            this.composeReference(t, "HealthcareService", "endpoint", element.getEndpoint().get(i), i);
        }
    }

    protected void composeHealthcareServiceHealthcareServiceEligibilityComponent(Turtle.Complex parent, String parentType, String name, HealthcareService.HealthcareServiceEligibilityComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "eligibility", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "HealthcareService", "code", element.getCode(), -1);
        }
        if (element.hasCommentElement()) {
            this.composeMarkdown(t, "HealthcareService", "comment", element.getCommentElement(), -1);
        }
    }

    protected void composeHealthcareServiceHealthcareServiceAvailableTimeComponent(Turtle.Complex parent, String parentType, String name, HealthcareService.HealthcareServiceAvailableTimeComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "availableTime", name, element, index);
        for (int i = 0; i < element.getDaysOfWeek().size(); ++i) {
            this.composeEnum(t, "HealthcareService", "daysOfWeek", element.getDaysOfWeek().get(i), i);
        }
        if (element.hasAllDayElement()) {
            this.composeBoolean(t, "HealthcareService", "allDay", element.getAllDayElement(), -1);
        }
        if (element.hasAvailableStartTimeElement()) {
            this.composeTime(t, "HealthcareService", "availableStartTime", element.getAvailableStartTimeElement(), -1);
        }
        if (element.hasAvailableEndTimeElement()) {
            this.composeTime(t, "HealthcareService", "availableEndTime", element.getAvailableEndTimeElement(), -1);
        }
    }

    protected void composeHealthcareServiceHealthcareServiceNotAvailableComponent(Turtle.Complex parent, String parentType, String name, HealthcareService.HealthcareServiceNotAvailableComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "notAvailable", name, element, index);
        if (element.hasDescriptionElement()) {
            this.composeString(t, "HealthcareService", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasDuring()) {
            this.composePeriod(t, "HealthcareService", "during", element.getDuring(), -1);
        }
    }

    protected void composeImagingStudy(Turtle.Complex parent, String parentType, String name, ImagingStudy element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "ImagingStudy", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "ImagingStudy", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "ImagingStudy", "status", element.getStatusElement(), -1);
        }
        for (i = 0; i < element.getModality().size(); ++i) {
            this.composeCoding(t, "ImagingStudy", "modality", element.getModality().get(i), i);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "ImagingStudy", "subject", element.getSubject(), -1);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "ImagingStudy", "encounter", element.getEncounter(), -1);
        }
        if (element.hasStartedElement()) {
            this.composeDateTime(t, "ImagingStudy", "started", element.getStartedElement(), -1);
        }
        for (i = 0; i < element.getBasedOn().size(); ++i) {
            this.composeReference(t, "ImagingStudy", "basedOn", element.getBasedOn().get(i), i);
        }
        if (element.hasReferrer()) {
            this.composeReference(t, "ImagingStudy", "referrer", element.getReferrer(), -1);
        }
        for (i = 0; i < element.getInterpreter().size(); ++i) {
            this.composeReference(t, "ImagingStudy", "interpreter", element.getInterpreter().get(i), i);
        }
        for (i = 0; i < element.getEndpoint().size(); ++i) {
            this.composeReference(t, "ImagingStudy", "endpoint", element.getEndpoint().get(i), i);
        }
        if (element.hasNumberOfSeriesElement()) {
            this.composeUnsignedInt(t, "ImagingStudy", "numberOfSeries", element.getNumberOfSeriesElement(), -1);
        }
        if (element.hasNumberOfInstancesElement()) {
            this.composeUnsignedInt(t, "ImagingStudy", "numberOfInstances", element.getNumberOfInstancesElement(), -1);
        }
        if (element.hasProcedureReference()) {
            this.composeReference(t, "ImagingStudy", "procedureReference", element.getProcedureReference(), -1);
        }
        for (i = 0; i < element.getProcedureCode().size(); ++i) {
            this.composeCodeableConcept(t, "ImagingStudy", "procedureCode", element.getProcedureCode().get(i), i);
        }
        if (element.hasLocation()) {
            this.composeReference(t, "ImagingStudy", "location", element.getLocation(), -1);
        }
        for (i = 0; i < element.getReasonCode().size(); ++i) {
            this.composeCodeableConcept(t, "ImagingStudy", "reasonCode", element.getReasonCode().get(i), i);
        }
        for (i = 0; i < element.getReasonReference().size(); ++i) {
            this.composeReference(t, "ImagingStudy", "reasonReference", element.getReasonReference().get(i), i);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "ImagingStudy", "note", element.getNote().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "ImagingStudy", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getSeries().size(); ++i) {
            this.composeImagingStudyImagingStudySeriesComponent(t, "ImagingStudy", "series", element.getSeries().get(i), i);
        }
    }

    protected void composeImagingStudyImagingStudySeriesComponent(Turtle.Complex parent, String parentType, String name, ImagingStudy.ImagingStudySeriesComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "series", name, element, index);
        if (element.hasUidElement()) {
            this.composeId(t, "ImagingStudy", "uid", element.getUidElement(), -1);
        }
        if (element.hasNumberElement()) {
            this.composeUnsignedInt(t, "ImagingStudy", "number", element.getNumberElement(), -1);
        }
        if (element.hasModality()) {
            this.composeCoding(t, "ImagingStudy", "modality", element.getModality(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "ImagingStudy", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasNumberOfInstancesElement()) {
            this.composeUnsignedInt(t, "ImagingStudy", "numberOfInstances", element.getNumberOfInstancesElement(), -1);
        }
        for (i = 0; i < element.getEndpoint().size(); ++i) {
            this.composeReference(t, "ImagingStudy", "endpoint", element.getEndpoint().get(i), i);
        }
        if (element.hasBodySite()) {
            this.composeCoding(t, "ImagingStudy", "bodySite", element.getBodySite(), -1);
        }
        if (element.hasLaterality()) {
            this.composeCoding(t, "ImagingStudy", "laterality", element.getLaterality(), -1);
        }
        for (i = 0; i < element.getSpecimen().size(); ++i) {
            this.composeReference(t, "ImagingStudy", "specimen", element.getSpecimen().get(i), i);
        }
        if (element.hasStartedElement()) {
            this.composeDateTime(t, "ImagingStudy", "started", element.getStartedElement(), -1);
        }
        for (i = 0; i < element.getPerformer().size(); ++i) {
            this.composeImagingStudyImagingStudySeriesPerformerComponent(t, "ImagingStudy", "performer", element.getPerformer().get(i), i);
        }
        for (i = 0; i < element.getInstance().size(); ++i) {
            this.composeImagingStudyImagingStudySeriesInstanceComponent(t, "ImagingStudy", "instance", element.getInstance().get(i), i);
        }
    }

    protected void composeImagingStudyImagingStudySeriesPerformerComponent(Turtle.Complex parent, String parentType, String name, ImagingStudy.ImagingStudySeriesPerformerComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "performer", name, element, index);
        if (element.hasFunction()) {
            this.composeCodeableConcept(t, "ImagingStudy", "function", element.getFunction(), -1);
        }
        if (element.hasActor()) {
            this.composeReference(t, "ImagingStudy", "actor", element.getActor(), -1);
        }
    }

    protected void composeImagingStudyImagingStudySeriesInstanceComponent(Turtle.Complex parent, String parentType, String name, ImagingStudy.ImagingStudySeriesInstanceComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "instance", name, element, index);
        if (element.hasUidElement()) {
            this.composeId(t, "ImagingStudy", "uid", element.getUidElement(), -1);
        }
        if (element.hasSopClass()) {
            this.composeCoding(t, "ImagingStudy", "sopClass", element.getSopClass(), -1);
        }
        if (element.hasNumberElement()) {
            this.composeUnsignedInt(t, "ImagingStudy", "number", element.getNumberElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "ImagingStudy", "title", element.getTitleElement(), -1);
        }
    }

    protected void composeImmunization(Turtle.Complex parent, String parentType, String name, Immunization element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Immunization", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Immunization", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Immunization", "status", element.getStatusElement(), -1);
        }
        if (element.hasStatusReason()) {
            this.composeCodeableConcept(t, "Immunization", "statusReason", element.getStatusReason(), -1);
        }
        if (element.hasVaccineCode()) {
            this.composeCodeableConcept(t, "Immunization", "vaccineCode", element.getVaccineCode(), -1);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "Immunization", "patient", element.getPatient(), -1);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "Immunization", "encounter", element.getEncounter(), -1);
        }
        if (element.hasOccurrence()) {
            this.composeType(t, "Immunization", "occurrence", element.getOccurrence(), -1);
        }
        if (element.hasRecordedElement()) {
            this.composeDateTime(t, "Immunization", "recorded", element.getRecordedElement(), -1);
        }
        if (element.hasPrimarySourceElement()) {
            this.composeBoolean(t, "Immunization", "primarySource", element.getPrimarySourceElement(), -1);
        }
        if (element.hasReportOrigin()) {
            this.composeCodeableConcept(t, "Immunization", "reportOrigin", element.getReportOrigin(), -1);
        }
        if (element.hasLocation()) {
            this.composeReference(t, "Immunization", "location", element.getLocation(), -1);
        }
        if (element.hasManufacturer()) {
            this.composeReference(t, "Immunization", "manufacturer", element.getManufacturer(), -1);
        }
        if (element.hasLotNumberElement()) {
            this.composeString(t, "Immunization", "lotNumber", element.getLotNumberElement(), -1);
        }
        if (element.hasExpirationDateElement()) {
            this.composeDate(t, "Immunization", "expirationDate", element.getExpirationDateElement(), -1);
        }
        if (element.hasSite()) {
            this.composeCodeableConcept(t, "Immunization", "site", element.getSite(), -1);
        }
        if (element.hasRoute()) {
            this.composeCodeableConcept(t, "Immunization", "route", element.getRoute(), -1);
        }
        if (element.hasDoseQuantity()) {
            this.composeQuantity(t, "Immunization", "doseQuantity", element.getDoseQuantity(), -1);
        }
        for (i = 0; i < element.getPerformer().size(); ++i) {
            this.composeImmunizationImmunizationPerformerComponent(t, "Immunization", "performer", element.getPerformer().get(i), i);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "Immunization", "note", element.getNote().get(i), i);
        }
        for (i = 0; i < element.getReasonCode().size(); ++i) {
            this.composeCodeableConcept(t, "Immunization", "reasonCode", element.getReasonCode().get(i), i);
        }
        for (i = 0; i < element.getReasonReference().size(); ++i) {
            this.composeReference(t, "Immunization", "reasonReference", element.getReasonReference().get(i), i);
        }
        if (element.hasIsSubpotentElement()) {
            this.composeBoolean(t, "Immunization", "isSubpotent", element.getIsSubpotentElement(), -1);
        }
        for (i = 0; i < element.getSubpotentReason().size(); ++i) {
            this.composeCodeableConcept(t, "Immunization", "subpotentReason", element.getSubpotentReason().get(i), i);
        }
        for (i = 0; i < element.getEducation().size(); ++i) {
            this.composeImmunizationImmunizationEducationComponent(t, "Immunization", "education", element.getEducation().get(i), i);
        }
        for (i = 0; i < element.getProgramEligibility().size(); ++i) {
            this.composeCodeableConcept(t, "Immunization", "programEligibility", element.getProgramEligibility().get(i), i);
        }
        if (element.hasFundingSource()) {
            this.composeCodeableConcept(t, "Immunization", "fundingSource", element.getFundingSource(), -1);
        }
        for (i = 0; i < element.getReaction().size(); ++i) {
            this.composeImmunizationImmunizationReactionComponent(t, "Immunization", "reaction", element.getReaction().get(i), i);
        }
        for (i = 0; i < element.getProtocolApplied().size(); ++i) {
            this.composeImmunizationImmunizationProtocolAppliedComponent(t, "Immunization", "protocolApplied", element.getProtocolApplied().get(i), i);
        }
    }

    protected void composeImmunizationImmunizationPerformerComponent(Turtle.Complex parent, String parentType, String name, Immunization.ImmunizationPerformerComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "performer", name, element, index);
        if (element.hasFunction()) {
            this.composeCodeableConcept(t, "Immunization", "function", element.getFunction(), -1);
        }
        if (element.hasActor()) {
            this.composeReference(t, "Immunization", "actor", element.getActor(), -1);
        }
    }

    protected void composeImmunizationImmunizationEducationComponent(Turtle.Complex parent, String parentType, String name, Immunization.ImmunizationEducationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "education", name, element, index);
        if (element.hasDocumentTypeElement()) {
            this.composeString(t, "Immunization", "documentType", element.getDocumentTypeElement(), -1);
        }
        if (element.hasReferenceElement()) {
            this.composeUri(t, "Immunization", "reference", element.getReferenceElement(), -1);
        }
        if (element.hasPublicationDateElement()) {
            this.composeDateTime(t, "Immunization", "publicationDate", element.getPublicationDateElement(), -1);
        }
        if (element.hasPresentationDateElement()) {
            this.composeDateTime(t, "Immunization", "presentationDate", element.getPresentationDateElement(), -1);
        }
    }

    protected void composeImmunizationImmunizationReactionComponent(Turtle.Complex parent, String parentType, String name, Immunization.ImmunizationReactionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "reaction", name, element, index);
        if (element.hasDateElement()) {
            this.composeDateTime(t, "Immunization", "date", element.getDateElement(), -1);
        }
        if (element.hasDetail()) {
            this.composeReference(t, "Immunization", "detail", element.getDetail(), -1);
        }
        if (element.hasReportedElement()) {
            this.composeBoolean(t, "Immunization", "reported", element.getReportedElement(), -1);
        }
    }

    protected void composeImmunizationImmunizationProtocolAppliedComponent(Turtle.Complex parent, String parentType, String name, Immunization.ImmunizationProtocolAppliedComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "protocolApplied", name, element, index);
        if (element.hasSeriesElement()) {
            this.composeString(t, "Immunization", "series", element.getSeriesElement(), -1);
        }
        if (element.hasAuthority()) {
            this.composeReference(t, "Immunization", "authority", element.getAuthority(), -1);
        }
        for (int i = 0; i < element.getTargetDisease().size(); ++i) {
            this.composeCodeableConcept(t, "Immunization", "targetDisease", element.getTargetDisease().get(i), i);
        }
        if (element.hasDoseNumber()) {
            this.composeType(t, "Immunization", "doseNumber", element.getDoseNumber(), -1);
        }
        if (element.hasSeriesDoses()) {
            this.composeType(t, "Immunization", "seriesDoses", element.getSeriesDoses(), -1);
        }
    }

    protected void composeImmunizationEvaluation(Turtle.Complex parent, String parentType, String name, ImmunizationEvaluation element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "ImmunizationEvaluation", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "ImmunizationEvaluation", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "ImmunizationEvaluation", "status", element.getStatusElement(), -1);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "ImmunizationEvaluation", "patient", element.getPatient(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "ImmunizationEvaluation", "date", element.getDateElement(), -1);
        }
        if (element.hasAuthority()) {
            this.composeReference(t, "ImmunizationEvaluation", "authority", element.getAuthority(), -1);
        }
        if (element.hasTargetDisease()) {
            this.composeCodeableConcept(t, "ImmunizationEvaluation", "targetDisease", element.getTargetDisease(), -1);
        }
        if (element.hasImmunizationEvent()) {
            this.composeReference(t, "ImmunizationEvaluation", "immunizationEvent", element.getImmunizationEvent(), -1);
        }
        if (element.hasDoseStatus()) {
            this.composeCodeableConcept(t, "ImmunizationEvaluation", "doseStatus", element.getDoseStatus(), -1);
        }
        for (i = 0; i < element.getDoseStatusReason().size(); ++i) {
            this.composeCodeableConcept(t, "ImmunizationEvaluation", "doseStatusReason", element.getDoseStatusReason().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "ImmunizationEvaluation", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasSeriesElement()) {
            this.composeString(t, "ImmunizationEvaluation", "series", element.getSeriesElement(), -1);
        }
        if (element.hasDoseNumber()) {
            this.composeType(t, "ImmunizationEvaluation", "doseNumber", element.getDoseNumber(), -1);
        }
        if (element.hasSeriesDoses()) {
            this.composeType(t, "ImmunizationEvaluation", "seriesDoses", element.getSeriesDoses(), -1);
        }
    }

    protected void composeImmunizationRecommendation(Turtle.Complex parent, String parentType, String name, ImmunizationRecommendation element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "ImmunizationRecommendation", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "ImmunizationRecommendation", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "ImmunizationRecommendation", "patient", element.getPatient(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "ImmunizationRecommendation", "date", element.getDateElement(), -1);
        }
        if (element.hasAuthority()) {
            this.composeReference(t, "ImmunizationRecommendation", "authority", element.getAuthority(), -1);
        }
        for (i = 0; i < element.getRecommendation().size(); ++i) {
            this.composeImmunizationRecommendationImmunizationRecommendationRecommendationComponent(t, "ImmunizationRecommendation", "recommendation", element.getRecommendation().get(i), i);
        }
    }

    protected void composeImmunizationRecommendationImmunizationRecommendationRecommendationComponent(Turtle.Complex parent, String parentType, String name, ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "recommendation", name, element, index);
        for (i = 0; i < element.getVaccineCode().size(); ++i) {
            this.composeCodeableConcept(t, "ImmunizationRecommendation", "vaccineCode", element.getVaccineCode().get(i), i);
        }
        if (element.hasTargetDisease()) {
            this.composeCodeableConcept(t, "ImmunizationRecommendation", "targetDisease", element.getTargetDisease(), -1);
        }
        for (i = 0; i < element.getContraindicatedVaccineCode().size(); ++i) {
            this.composeCodeableConcept(t, "ImmunizationRecommendation", "contraindicatedVaccineCode", element.getContraindicatedVaccineCode().get(i), i);
        }
        if (element.hasForecastStatus()) {
            this.composeCodeableConcept(t, "ImmunizationRecommendation", "forecastStatus", element.getForecastStatus(), -1);
        }
        for (i = 0; i < element.getForecastReason().size(); ++i) {
            this.composeCodeableConcept(t, "ImmunizationRecommendation", "forecastReason", element.getForecastReason().get(i), i);
        }
        for (i = 0; i < element.getDateCriterion().size(); ++i) {
            this.composeImmunizationRecommendationImmunizationRecommendationRecommendationDateCriterionComponent(t, "ImmunizationRecommendation", "dateCriterion", element.getDateCriterion().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "ImmunizationRecommendation", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasSeriesElement()) {
            this.composeString(t, "ImmunizationRecommendation", "series", element.getSeriesElement(), -1);
        }
        if (element.hasDoseNumber()) {
            this.composeType(t, "ImmunizationRecommendation", "doseNumber", element.getDoseNumber(), -1);
        }
        if (element.hasSeriesDoses()) {
            this.composeType(t, "ImmunizationRecommendation", "seriesDoses", element.getSeriesDoses(), -1);
        }
        for (i = 0; i < element.getSupportingImmunization().size(); ++i) {
            this.composeReference(t, "ImmunizationRecommendation", "supportingImmunization", element.getSupportingImmunization().get(i), i);
        }
        for (i = 0; i < element.getSupportingPatientInformation().size(); ++i) {
            this.composeReference(t, "ImmunizationRecommendation", "supportingPatientInformation", element.getSupportingPatientInformation().get(i), i);
        }
    }

    protected void composeImmunizationRecommendationImmunizationRecommendationRecommendationDateCriterionComponent(Turtle.Complex parent, String parentType, String name, ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "dateCriterion", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "ImmunizationRecommendation", "code", element.getCode(), -1);
        }
        if (element.hasValueElement()) {
            this.composeDateTime(t, "ImmunizationRecommendation", "value", element.getValueElement(), -1);
        }
    }

    protected void composeImplementationGuide(Turtle.Complex parent, String parentType, String name, ImplementationGuide element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "ImplementationGuide", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "ImplementationGuide", "url", element.getUrlElement(), -1);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "ImplementationGuide", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "ImplementationGuide", "name", element.getNameElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "ImplementationGuide", "title", element.getTitleElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "ImplementationGuide", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "ImplementationGuide", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "ImplementationGuide", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "ImplementationGuide", "publisher", element.getPublisherElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeContactDetail(t, "ImplementationGuide", "contact", element.getContact().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "ImplementationGuide", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getUseContext().size(); ++i) {
            this.composeUsageContext(t, "ImplementationGuide", "useContext", element.getUseContext().get(i), i);
        }
        for (i = 0; i < element.getJurisdiction().size(); ++i) {
            this.composeCodeableConcept(t, "ImplementationGuide", "jurisdiction", element.getJurisdiction().get(i), i);
        }
        if (element.hasCopyrightElement()) {
            this.composeMarkdown(t, "ImplementationGuide", "copyright", element.getCopyrightElement(), -1);
        }
        if (element.hasPackageIdElement()) {
            this.composeId(t, "ImplementationGuide", "packageId", element.getPackageIdElement(), -1);
        }
        if (element.hasLicenseElement()) {
            this.composeEnum(t, "ImplementationGuide", "license", element.getLicenseElement(), -1);
        }
        for (i = 0; i < element.getFhirVersion().size(); ++i) {
            this.composeEnum(t, "ImplementationGuide", "fhirVersion", element.getFhirVersion().get(i), i);
        }
        for (i = 0; i < element.getDependsOn().size(); ++i) {
            this.composeImplementationGuideImplementationGuideDependsOnComponent(t, "ImplementationGuide", "dependsOn", element.getDependsOn().get(i), i);
        }
        for (i = 0; i < element.getGlobal().size(); ++i) {
            this.composeImplementationGuideImplementationGuideGlobalComponent(t, "ImplementationGuide", "global", element.getGlobal().get(i), i);
        }
        if (element.hasDefinition()) {
            this.composeImplementationGuideImplementationGuideDefinitionComponent(t, "ImplementationGuide", "definition", element.getDefinition(), -1);
        }
        if (element.hasManifest()) {
            this.composeImplementationGuideImplementationGuideManifestComponent(t, "ImplementationGuide", "manifest", element.getManifest(), -1);
        }
    }

    protected void composeImplementationGuideImplementationGuideDependsOnComponent(Turtle.Complex parent, String parentType, String name, ImplementationGuide.ImplementationGuideDependsOnComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "dependsOn", name, element, index);
        if (element.hasUriElement()) {
            this.composeCanonical(t, "ImplementationGuide", "uri", element.getUriElement(), -1);
        }
        if (element.hasPackageIdElement()) {
            this.composeId(t, "ImplementationGuide", "packageId", element.getPackageIdElement(), -1);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "ImplementationGuide", "version", element.getVersionElement(), -1);
        }
    }

    protected void composeImplementationGuideImplementationGuideGlobalComponent(Turtle.Complex parent, String parentType, String name, ImplementationGuide.ImplementationGuideGlobalComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "global", name, element, index);
        if (element.hasTypeElement()) {
            this.composeCode(t, "ImplementationGuide", "type", element.getTypeElement(), -1);
        }
        if (element.hasProfileElement()) {
            this.composeCanonical(t, "ImplementationGuide", "profile", element.getProfileElement(), -1);
        }
    }

    protected void composeImplementationGuideImplementationGuideDefinitionComponent(Turtle.Complex parent, String parentType, String name, ImplementationGuide.ImplementationGuideDefinitionComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "definition", name, element, index);
        for (i = 0; i < element.getGrouping().size(); ++i) {
            this.composeImplementationGuideImplementationGuideDefinitionGroupingComponent(t, "ImplementationGuide", "grouping", element.getGrouping().get(i), i);
        }
        for (i = 0; i < element.getResource().size(); ++i) {
            this.composeImplementationGuideImplementationGuideDefinitionResourceComponent(t, "ImplementationGuide", "resource", element.getResource().get(i), i);
        }
        if (element.hasPage()) {
            this.composeImplementationGuideImplementationGuideDefinitionPageComponent(t, "ImplementationGuide", "page", element.getPage(), -1);
        }
        for (i = 0; i < element.getParameter().size(); ++i) {
            this.composeImplementationGuideImplementationGuideDefinitionParameterComponent(t, "ImplementationGuide", "parameter", element.getParameter().get(i), i);
        }
        for (i = 0; i < element.getTemplate().size(); ++i) {
            this.composeImplementationGuideImplementationGuideDefinitionTemplateComponent(t, "ImplementationGuide", "template", element.getTemplate().get(i), i);
        }
    }

    protected void composeImplementationGuideImplementationGuideDefinitionGroupingComponent(Turtle.Complex parent, String parentType, String name, ImplementationGuide.ImplementationGuideDefinitionGroupingComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "grouping", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "ImplementationGuide", "name", element.getNameElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "ImplementationGuide", "description", element.getDescriptionElement(), -1);
        }
    }

    protected void composeImplementationGuideImplementationGuideDefinitionResourceComponent(Turtle.Complex parent, String parentType, String name, ImplementationGuide.ImplementationGuideDefinitionResourceComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "resource", name, element, index);
        if (element.hasReference()) {
            this.composeReference(t, "ImplementationGuide", "reference", element.getReference(), -1);
        }
        for (int i = 0; i < element.getFhirVersion().size(); ++i) {
            this.composeEnum(t, "ImplementationGuide", "fhirVersion", element.getFhirVersion().get(i), i);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "ImplementationGuide", "name", element.getNameElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "ImplementationGuide", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasExample()) {
            this.composeType(t, "ImplementationGuide", "example", element.getExample(), -1);
        }
        if (element.hasGroupingIdElement()) {
            this.composeId(t, "ImplementationGuide", "groupingId", element.getGroupingIdElement(), -1);
        }
    }

    protected void composeImplementationGuideImplementationGuideDefinitionPageComponent(Turtle.Complex parent, String parentType, String name, ImplementationGuide.ImplementationGuideDefinitionPageComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "page", name, element, index);
        if (element.hasName()) {
            this.composeType(t, "ImplementationGuide", "name", element.getName(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "ImplementationGuide", "title", element.getTitleElement(), -1);
        }
        if (element.hasGenerationElement()) {
            this.composeEnum(t, "ImplementationGuide", "generation", element.getGenerationElement(), -1);
        }
        for (int i = 0; i < element.getPage().size(); ++i) {
            this.composeImplementationGuideImplementationGuideDefinitionPageComponent(t, "ImplementationGuide", "page", element.getPage().get(i), i);
        }
    }

    protected void composeImplementationGuideImplementationGuideDefinitionParameterComponent(Turtle.Complex parent, String parentType, String name, ImplementationGuide.ImplementationGuideDefinitionParameterComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "parameter", name, element, index);
        if (element.hasCodeElement()) {
            this.composeString(t, "ImplementationGuide", "code", element.getCodeElement(), -1);
        }
        if (element.hasValueElement()) {
            this.composeString(t, "ImplementationGuide", "value", element.getValueElement(), -1);
        }
    }

    protected void composeImplementationGuideImplementationGuideDefinitionTemplateComponent(Turtle.Complex parent, String parentType, String name, ImplementationGuide.ImplementationGuideDefinitionTemplateComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "template", name, element, index);
        if (element.hasCodeElement()) {
            this.composeCode(t, "ImplementationGuide", "code", element.getCodeElement(), -1);
        }
        if (element.hasSourceElement()) {
            this.composeString(t, "ImplementationGuide", "source", element.getSourceElement(), -1);
        }
        if (element.hasScopeElement()) {
            this.composeString(t, "ImplementationGuide", "scope", element.getScopeElement(), -1);
        }
    }

    protected void composeImplementationGuideImplementationGuideManifestComponent(Turtle.Complex parent, String parentType, String name, ImplementationGuide.ImplementationGuideManifestComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "manifest", name, element, index);
        if (element.hasRenderingElement()) {
            this.composeUrl(t, "ImplementationGuide", "rendering", element.getRenderingElement(), -1);
        }
        for (i = 0; i < element.getResource().size(); ++i) {
            this.composeImplementationGuideManifestResourceComponent(t, "ImplementationGuide", "resource", element.getResource().get(i), i);
        }
        for (i = 0; i < element.getPage().size(); ++i) {
            this.composeImplementationGuideManifestPageComponent(t, "ImplementationGuide", "page", element.getPage().get(i), i);
        }
        for (i = 0; i < element.getImage().size(); ++i) {
            this.composeString(t, "ImplementationGuide", "image", element.getImage().get(i), i);
        }
        for (i = 0; i < element.getOther().size(); ++i) {
            this.composeString(t, "ImplementationGuide", "other", element.getOther().get(i), i);
        }
    }

    protected void composeImplementationGuideManifestResourceComponent(Turtle.Complex parent, String parentType, String name, ImplementationGuide.ManifestResourceComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "resource", name, element, index);
        if (element.hasReference()) {
            this.composeReference(t, "ImplementationGuide", "reference", element.getReference(), -1);
        }
        if (element.hasExample()) {
            this.composeType(t, "ImplementationGuide", "example", element.getExample(), -1);
        }
        if (element.hasRelativePathElement()) {
            this.composeUrl(t, "ImplementationGuide", "relativePath", element.getRelativePathElement(), -1);
        }
    }

    protected void composeImplementationGuideManifestPageComponent(Turtle.Complex parent, String parentType, String name, ImplementationGuide.ManifestPageComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "page", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "ImplementationGuide", "name", element.getNameElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "ImplementationGuide", "title", element.getTitleElement(), -1);
        }
        for (int i = 0; i < element.getAnchor().size(); ++i) {
            this.composeString(t, "ImplementationGuide", "anchor", element.getAnchor().get(i), i);
        }
    }

    protected void composeInsurancePlan(Turtle.Complex parent, String parentType, String name, InsurancePlan element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "InsurancePlan", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "InsurancePlan", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "InsurancePlan", "status", element.getStatusElement(), -1);
        }
        for (i = 0; i < element.getType().size(); ++i) {
            this.composeCodeableConcept(t, "InsurancePlan", "type", element.getType().get(i), i);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "InsurancePlan", "name", element.getNameElement(), -1);
        }
        for (i = 0; i < element.getAlias().size(); ++i) {
            this.composeString(t, "InsurancePlan", "alias", element.getAlias().get(i), i);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "InsurancePlan", "period", element.getPeriod(), -1);
        }
        if (element.hasOwnedBy()) {
            this.composeReference(t, "InsurancePlan", "ownedBy", element.getOwnedBy(), -1);
        }
        if (element.hasAdministeredBy()) {
            this.composeReference(t, "InsurancePlan", "administeredBy", element.getAdministeredBy(), -1);
        }
        for (i = 0; i < element.getCoverageArea().size(); ++i) {
            this.composeReference(t, "InsurancePlan", "coverageArea", element.getCoverageArea().get(i), i);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeInsurancePlanInsurancePlanContactComponent(t, "InsurancePlan", "contact", element.getContact().get(i), i);
        }
        for (i = 0; i < element.getEndpoint().size(); ++i) {
            this.composeReference(t, "InsurancePlan", "endpoint", element.getEndpoint().get(i), i);
        }
        for (i = 0; i < element.getNetwork().size(); ++i) {
            this.composeReference(t, "InsurancePlan", "network", element.getNetwork().get(i), i);
        }
        for (i = 0; i < element.getCoverage().size(); ++i) {
            this.composeInsurancePlanInsurancePlanCoverageComponent(t, "InsurancePlan", "coverage", element.getCoverage().get(i), i);
        }
        for (i = 0; i < element.getPlan().size(); ++i) {
            this.composeInsurancePlanInsurancePlanPlanComponent(t, "InsurancePlan", "plan", element.getPlan().get(i), i);
        }
    }

    protected void composeInsurancePlanInsurancePlanContactComponent(Turtle.Complex parent, String parentType, String name, InsurancePlan.InsurancePlanContactComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "contact", name, element, index);
        if (element.hasPurpose()) {
            this.composeCodeableConcept(t, "InsurancePlan", "purpose", element.getPurpose(), -1);
        }
        if (element.hasName()) {
            this.composeHumanName(t, "InsurancePlan", "name", element.getName(), -1);
        }
        for (int i = 0; i < element.getTelecom().size(); ++i) {
            this.composeContactPoint(t, "InsurancePlan", "telecom", element.getTelecom().get(i), i);
        }
        if (element.hasAddress()) {
            this.composeAddress(t, "InsurancePlan", "address", element.getAddress(), -1);
        }
    }

    protected void composeInsurancePlanInsurancePlanCoverageComponent(Turtle.Complex parent, String parentType, String name, InsurancePlan.InsurancePlanCoverageComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "coverage", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "InsurancePlan", "type", element.getType(), -1);
        }
        for (i = 0; i < element.getNetwork().size(); ++i) {
            this.composeReference(t, "InsurancePlan", "network", element.getNetwork().get(i), i);
        }
        for (i = 0; i < element.getBenefit().size(); ++i) {
            this.composeInsurancePlanCoverageBenefitComponent(t, "InsurancePlan", "benefit", element.getBenefit().get(i), i);
        }
    }

    protected void composeInsurancePlanCoverageBenefitComponent(Turtle.Complex parent, String parentType, String name, InsurancePlan.CoverageBenefitComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "benefit", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "InsurancePlan", "type", element.getType(), -1);
        }
        if (element.hasRequirementElement()) {
            this.composeString(t, "InsurancePlan", "requirement", element.getRequirementElement(), -1);
        }
        for (int i = 0; i < element.getLimit().size(); ++i) {
            this.composeInsurancePlanCoverageBenefitLimitComponent(t, "InsurancePlan", "limit", element.getLimit().get(i), i);
        }
    }

    protected void composeInsurancePlanCoverageBenefitLimitComponent(Turtle.Complex parent, String parentType, String name, InsurancePlan.CoverageBenefitLimitComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "limit", name, element, index);
        if (element.hasValue()) {
            this.composeQuantity(t, "InsurancePlan", "value", element.getValue(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "InsurancePlan", "code", element.getCode(), -1);
        }
    }

    protected void composeInsurancePlanInsurancePlanPlanComponent(Turtle.Complex parent, String parentType, String name, InsurancePlan.InsurancePlanPlanComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "plan", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "InsurancePlan", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "InsurancePlan", "type", element.getType(), -1);
        }
        for (i = 0; i < element.getCoverageArea().size(); ++i) {
            this.composeReference(t, "InsurancePlan", "coverageArea", element.getCoverageArea().get(i), i);
        }
        for (i = 0; i < element.getNetwork().size(); ++i) {
            this.composeReference(t, "InsurancePlan", "network", element.getNetwork().get(i), i);
        }
        for (i = 0; i < element.getGeneralCost().size(); ++i) {
            this.composeInsurancePlanInsurancePlanPlanGeneralCostComponent(t, "InsurancePlan", "generalCost", element.getGeneralCost().get(i), i);
        }
        for (i = 0; i < element.getSpecificCost().size(); ++i) {
            this.composeInsurancePlanInsurancePlanPlanSpecificCostComponent(t, "InsurancePlan", "specificCost", element.getSpecificCost().get(i), i);
        }
    }

    protected void composeInsurancePlanInsurancePlanPlanGeneralCostComponent(Turtle.Complex parent, String parentType, String name, InsurancePlan.InsurancePlanPlanGeneralCostComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "generalCost", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "InsurancePlan", "type", element.getType(), -1);
        }
        if (element.hasGroupSizeElement()) {
            this.composePositiveInt(t, "InsurancePlan", "groupSize", element.getGroupSizeElement(), -1);
        }
        if (element.hasCost()) {
            this.composeMoney(t, "InsurancePlan", "cost", element.getCost(), -1);
        }
        if (element.hasCommentElement()) {
            this.composeString(t, "InsurancePlan", "comment", element.getCommentElement(), -1);
        }
    }

    protected void composeInsurancePlanInsurancePlanPlanSpecificCostComponent(Turtle.Complex parent, String parentType, String name, InsurancePlan.InsurancePlanPlanSpecificCostComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "specificCost", name, element, index);
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "InsurancePlan", "category", element.getCategory(), -1);
        }
        for (int i = 0; i < element.getBenefit().size(); ++i) {
            this.composeInsurancePlanPlanBenefitComponent(t, "InsurancePlan", "benefit", element.getBenefit().get(i), i);
        }
    }

    protected void composeInsurancePlanPlanBenefitComponent(Turtle.Complex parent, String parentType, String name, InsurancePlan.PlanBenefitComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "benefit", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "InsurancePlan", "type", element.getType(), -1);
        }
        for (int i = 0; i < element.getCost().size(); ++i) {
            this.composeInsurancePlanPlanBenefitCostComponent(t, "InsurancePlan", "cost", element.getCost().get(i), i);
        }
    }

    protected void composeInsurancePlanPlanBenefitCostComponent(Turtle.Complex parent, String parentType, String name, InsurancePlan.PlanBenefitCostComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "cost", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "InsurancePlan", "type", element.getType(), -1);
        }
        if (element.hasApplicability()) {
            this.composeCodeableConcept(t, "InsurancePlan", "applicability", element.getApplicability(), -1);
        }
        for (int i = 0; i < element.getQualifiers().size(); ++i) {
            this.composeCodeableConcept(t, "InsurancePlan", "qualifiers", element.getQualifiers().get(i), i);
        }
        if (element.hasValue()) {
            this.composeQuantity(t, "InsurancePlan", "value", element.getValue(), -1);
        }
    }

    protected void composeInvoice(Turtle.Complex parent, String parentType, String name, Invoice element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Invoice", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Invoice", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Invoice", "status", element.getStatusElement(), -1);
        }
        if (element.hasCancelledReasonElement()) {
            this.composeString(t, "Invoice", "cancelledReason", element.getCancelledReasonElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "Invoice", "type", element.getType(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "Invoice", "subject", element.getSubject(), -1);
        }
        if (element.hasRecipient()) {
            this.composeReference(t, "Invoice", "recipient", element.getRecipient(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "Invoice", "date", element.getDateElement(), -1);
        }
        for (i = 0; i < element.getParticipant().size(); ++i) {
            this.composeInvoiceInvoiceParticipantComponent(t, "Invoice", "participant", element.getParticipant().get(i), i);
        }
        if (element.hasIssuer()) {
            this.composeReference(t, "Invoice", "issuer", element.getIssuer(), -1);
        }
        if (element.hasAccount()) {
            this.composeReference(t, "Invoice", "account", element.getAccount(), -1);
        }
        for (i = 0; i < element.getLineItem().size(); ++i) {
            this.composeInvoiceInvoiceLineItemComponent(t, "Invoice", "lineItem", element.getLineItem().get(i), i);
        }
        for (i = 0; i < element.getTotalPriceComponent().size(); ++i) {
            this.composeInvoiceInvoiceLineItemPriceComponentComponent(t, "Invoice", "totalPriceComponent", element.getTotalPriceComponent().get(i), i);
        }
        if (element.hasTotalNet()) {
            this.composeMoney(t, "Invoice", "totalNet", element.getTotalNet(), -1);
        }
        if (element.hasTotalGross()) {
            this.composeMoney(t, "Invoice", "totalGross", element.getTotalGross(), -1);
        }
        if (element.hasPaymentTermsElement()) {
            this.composeMarkdown(t, "Invoice", "paymentTerms", element.getPaymentTermsElement(), -1);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "Invoice", "note", element.getNote().get(i), i);
        }
    }

    protected void composeInvoiceInvoiceParticipantComponent(Turtle.Complex parent, String parentType, String name, Invoice.InvoiceParticipantComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "participant", name, element, index);
        if (element.hasRole()) {
            this.composeCodeableConcept(t, "Invoice", "role", element.getRole(), -1);
        }
        if (element.hasActor()) {
            this.composeReference(t, "Invoice", "actor", element.getActor(), -1);
        }
    }

    protected void composeInvoiceInvoiceLineItemComponent(Turtle.Complex parent, String parentType, String name, Invoice.InvoiceLineItemComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "lineItem", name, element, index);
        if (element.hasSequenceElement()) {
            this.composePositiveInt(t, "Invoice", "sequence", element.getSequenceElement(), -1);
        }
        if (element.hasChargeItem()) {
            this.composeType(t, "Invoice", "chargeItem", element.getChargeItem(), -1);
        }
        for (int i = 0; i < element.getPriceComponent().size(); ++i) {
            this.composeInvoiceInvoiceLineItemPriceComponentComponent(t, "Invoice", "priceComponent", element.getPriceComponent().get(i), i);
        }
    }

    protected void composeInvoiceInvoiceLineItemPriceComponentComponent(Turtle.Complex parent, String parentType, String name, Invoice.InvoiceLineItemPriceComponentComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "priceComponent", name, element, index);
        if (element.hasTypeElement()) {
            this.composeEnum(t, "Invoice", "type", element.getTypeElement(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "Invoice", "code", element.getCode(), -1);
        }
        if (element.hasFactorElement()) {
            this.composeDecimal(t, "Invoice", "factor", element.getFactorElement(), -1);
        }
        if (element.hasAmount()) {
            this.composeMoney(t, "Invoice", "amount", element.getAmount(), -1);
        }
    }

    protected void composeLibrary(Turtle.Complex parent, String parentType, String name, Library element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Library", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "Library", "url", element.getUrlElement(), -1);
        }
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Library", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "Library", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "Library", "name", element.getNameElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "Library", "title", element.getTitleElement(), -1);
        }
        if (element.hasSubtitleElement()) {
            this.composeString(t, "Library", "subtitle", element.getSubtitleElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Library", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "Library", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "Library", "type", element.getType(), -1);
        }
        if (element.hasSubject()) {
            this.composeType(t, "Library", "subject", element.getSubject(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "Library", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "Library", "publisher", element.getPublisherElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeContactDetail(t, "Library", "contact", element.getContact().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "Library", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getUseContext().size(); ++i) {
            this.composeUsageContext(t, "Library", "useContext", element.getUseContext().get(i), i);
        }
        for (i = 0; i < element.getJurisdiction().size(); ++i) {
            this.composeCodeableConcept(t, "Library", "jurisdiction", element.getJurisdiction().get(i), i);
        }
        if (element.hasPurposeElement()) {
            this.composeMarkdown(t, "Library", "purpose", element.getPurposeElement(), -1);
        }
        if (element.hasUsageElement()) {
            this.composeString(t, "Library", "usage", element.getUsageElement(), -1);
        }
        if (element.hasCopyrightElement()) {
            this.composeMarkdown(t, "Library", "copyright", element.getCopyrightElement(), -1);
        }
        if (element.hasApprovalDateElement()) {
            this.composeDate(t, "Library", "approvalDate", element.getApprovalDateElement(), -1);
        }
        if (element.hasLastReviewDateElement()) {
            this.composeDate(t, "Library", "lastReviewDate", element.getLastReviewDateElement(), -1);
        }
        if (element.hasEffectivePeriod()) {
            this.composePeriod(t, "Library", "effectivePeriod", element.getEffectivePeriod(), -1);
        }
        for (i = 0; i < element.getTopic().size(); ++i) {
            this.composeCodeableConcept(t, "Library", "topic", element.getTopic().get(i), i);
        }
        for (i = 0; i < element.getAuthor().size(); ++i) {
            this.composeContactDetail(t, "Library", "author", element.getAuthor().get(i), i);
        }
        for (i = 0; i < element.getEditor().size(); ++i) {
            this.composeContactDetail(t, "Library", "editor", element.getEditor().get(i), i);
        }
        for (i = 0; i < element.getReviewer().size(); ++i) {
            this.composeContactDetail(t, "Library", "reviewer", element.getReviewer().get(i), i);
        }
        for (i = 0; i < element.getEndorser().size(); ++i) {
            this.composeContactDetail(t, "Library", "endorser", element.getEndorser().get(i), i);
        }
        for (i = 0; i < element.getRelatedArtifact().size(); ++i) {
            this.composeRelatedArtifact(t, "Library", "relatedArtifact", element.getRelatedArtifact().get(i), i);
        }
        for (i = 0; i < element.getParameter().size(); ++i) {
            this.composeParameterDefinition(t, "Library", "parameter", element.getParameter().get(i), i);
        }
        for (i = 0; i < element.getDataRequirement().size(); ++i) {
            this.composeDataRequirement(t, "Library", "dataRequirement", element.getDataRequirement().get(i), i);
        }
        for (i = 0; i < element.getContent().size(); ++i) {
            this.composeAttachment(t, "Library", "content", element.getContent().get(i), i);
        }
    }

    protected void composeLinkage(Turtle.Complex parent, String parentType, String name, Linkage element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Linkage", name, element, index);
        if (element.hasActiveElement()) {
            this.composeBoolean(t, "Linkage", "active", element.getActiveElement(), -1);
        }
        if (element.hasAuthor()) {
            this.composeReference(t, "Linkage", "author", element.getAuthor(), -1);
        }
        for (int i = 0; i < element.getItem().size(); ++i) {
            this.composeLinkageLinkageItemComponent(t, "Linkage", "item", element.getItem().get(i), i);
        }
    }

    protected void composeLinkageLinkageItemComponent(Turtle.Complex parent, String parentType, String name, Linkage.LinkageItemComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "item", name, element, index);
        if (element.hasTypeElement()) {
            this.composeEnum(t, "Linkage", "type", element.getTypeElement(), -1);
        }
        if (element.hasResource()) {
            this.composeReference(t, "Linkage", "resource", element.getResource(), -1);
        }
    }

    protected void composeListResource(Turtle.Complex parent, String parentType, String name, ListResource element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "List", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "List", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "List", "status", element.getStatusElement(), -1);
        }
        if (element.hasModeElement()) {
            this.composeEnum(t, "List", "mode", element.getModeElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "List", "title", element.getTitleElement(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "List", "code", element.getCode(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "List", "subject", element.getSubject(), -1);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "List", "encounter", element.getEncounter(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "List", "date", element.getDateElement(), -1);
        }
        if (element.hasSource()) {
            this.composeReference(t, "List", "source", element.getSource(), -1);
        }
        if (element.hasOrderedBy()) {
            this.composeCodeableConcept(t, "List", "orderedBy", element.getOrderedBy(), -1);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "List", "note", element.getNote().get(i), i);
        }
        for (i = 0; i < element.getEntry().size(); ++i) {
            this.composeListResourceListEntryComponent(t, "List", "entry", element.getEntry().get(i), i);
        }
        if (element.hasEmptyReason()) {
            this.composeCodeableConcept(t, "List", "emptyReason", element.getEmptyReason(), -1);
        }
    }

    protected void composeListResourceListEntryComponent(Turtle.Complex parent, String parentType, String name, ListResource.ListEntryComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "entry", name, element, index);
        if (element.hasFlag()) {
            this.composeCodeableConcept(t, "List", "flag", element.getFlag(), -1);
        }
        if (element.hasDeletedElement()) {
            this.composeBoolean(t, "List", "deleted", element.getDeletedElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "List", "date", element.getDateElement(), -1);
        }
        if (element.hasItem()) {
            this.composeReference(t, "List", "item", element.getItem(), -1);
        }
    }

    protected void composeLocation(Turtle.Complex parent, String parentType, String name, Location element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Location", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Location", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Location", "status", element.getStatusElement(), -1);
        }
        if (element.hasOperationalStatus()) {
            this.composeCoding(t, "Location", "operationalStatus", element.getOperationalStatus(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "Location", "name", element.getNameElement(), -1);
        }
        for (i = 0; i < element.getAlias().size(); ++i) {
            this.composeString(t, "Location", "alias", element.getAlias().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "Location", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasModeElement()) {
            this.composeEnum(t, "Location", "mode", element.getModeElement(), -1);
        }
        for (i = 0; i < element.getType().size(); ++i) {
            this.composeCodeableConcept(t, "Location", "type", element.getType().get(i), i);
        }
        for (i = 0; i < element.getTelecom().size(); ++i) {
            this.composeContactPoint(t, "Location", "telecom", element.getTelecom().get(i), i);
        }
        if (element.hasAddress()) {
            this.composeAddress(t, "Location", "address", element.getAddress(), -1);
        }
        if (element.hasPhysicalType()) {
            this.composeCodeableConcept(t, "Location", "physicalType", element.getPhysicalType(), -1);
        }
        if (element.hasPosition()) {
            this.composeLocationLocationPositionComponent(t, "Location", "position", element.getPosition(), -1);
        }
        if (element.hasManagingOrganization()) {
            this.composeReference(t, "Location", "managingOrganization", element.getManagingOrganization(), -1);
        }
        if (element.hasPartOf()) {
            this.composeReference(t, "Location", "partOf", element.getPartOf(), -1);
        }
        for (i = 0; i < element.getHoursOfOperation().size(); ++i) {
            this.composeLocationLocationHoursOfOperationComponent(t, "Location", "hoursOfOperation", element.getHoursOfOperation().get(i), i);
        }
        if (element.hasAvailabilityExceptionsElement()) {
            this.composeString(t, "Location", "availabilityExceptions", element.getAvailabilityExceptionsElement(), -1);
        }
        for (i = 0; i < element.getEndpoint().size(); ++i) {
            this.composeReference(t, "Location", "endpoint", element.getEndpoint().get(i), i);
        }
    }

    protected void composeLocationLocationPositionComponent(Turtle.Complex parent, String parentType, String name, Location.LocationPositionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "position", name, element, index);
        if (element.hasLongitudeElement()) {
            this.composeDecimal(t, "Location", "longitude", element.getLongitudeElement(), -1);
        }
        if (element.hasLatitudeElement()) {
            this.composeDecimal(t, "Location", "latitude", element.getLatitudeElement(), -1);
        }
        if (element.hasAltitudeElement()) {
            this.composeDecimal(t, "Location", "altitude", element.getAltitudeElement(), -1);
        }
    }

    protected void composeLocationLocationHoursOfOperationComponent(Turtle.Complex parent, String parentType, String name, Location.LocationHoursOfOperationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "hoursOfOperation", name, element, index);
        for (int i = 0; i < element.getDaysOfWeek().size(); ++i) {
            this.composeEnum(t, "Location", "daysOfWeek", element.getDaysOfWeek().get(i), i);
        }
        if (element.hasAllDayElement()) {
            this.composeBoolean(t, "Location", "allDay", element.getAllDayElement(), -1);
        }
        if (element.hasOpeningTimeElement()) {
            this.composeTime(t, "Location", "openingTime", element.getOpeningTimeElement(), -1);
        }
        if (element.hasClosingTimeElement()) {
            this.composeTime(t, "Location", "closingTime", element.getClosingTimeElement(), -1);
        }
    }

    protected void composeMeasure(Turtle.Complex parent, String parentType, String name, Measure element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Measure", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "Measure", "url", element.getUrlElement(), -1);
        }
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Measure", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "Measure", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "Measure", "name", element.getNameElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "Measure", "title", element.getTitleElement(), -1);
        }
        if (element.hasSubtitleElement()) {
            this.composeString(t, "Measure", "subtitle", element.getSubtitleElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Measure", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "Measure", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasSubject()) {
            this.composeType(t, "Measure", "subject", element.getSubject(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "Measure", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "Measure", "publisher", element.getPublisherElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeContactDetail(t, "Measure", "contact", element.getContact().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "Measure", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getUseContext().size(); ++i) {
            this.composeUsageContext(t, "Measure", "useContext", element.getUseContext().get(i), i);
        }
        for (i = 0; i < element.getJurisdiction().size(); ++i) {
            this.composeCodeableConcept(t, "Measure", "jurisdiction", element.getJurisdiction().get(i), i);
        }
        if (element.hasPurposeElement()) {
            this.composeMarkdown(t, "Measure", "purpose", element.getPurposeElement(), -1);
        }
        if (element.hasUsageElement()) {
            this.composeString(t, "Measure", "usage", element.getUsageElement(), -1);
        }
        if (element.hasCopyrightElement()) {
            this.composeMarkdown(t, "Measure", "copyright", element.getCopyrightElement(), -1);
        }
        if (element.hasApprovalDateElement()) {
            this.composeDate(t, "Measure", "approvalDate", element.getApprovalDateElement(), -1);
        }
        if (element.hasLastReviewDateElement()) {
            this.composeDate(t, "Measure", "lastReviewDate", element.getLastReviewDateElement(), -1);
        }
        if (element.hasEffectivePeriod()) {
            this.composePeriod(t, "Measure", "effectivePeriod", element.getEffectivePeriod(), -1);
        }
        for (i = 0; i < element.getTopic().size(); ++i) {
            this.composeCodeableConcept(t, "Measure", "topic", element.getTopic().get(i), i);
        }
        for (i = 0; i < element.getAuthor().size(); ++i) {
            this.composeContactDetail(t, "Measure", "author", element.getAuthor().get(i), i);
        }
        for (i = 0; i < element.getEditor().size(); ++i) {
            this.composeContactDetail(t, "Measure", "editor", element.getEditor().get(i), i);
        }
        for (i = 0; i < element.getReviewer().size(); ++i) {
            this.composeContactDetail(t, "Measure", "reviewer", element.getReviewer().get(i), i);
        }
        for (i = 0; i < element.getEndorser().size(); ++i) {
            this.composeContactDetail(t, "Measure", "endorser", element.getEndorser().get(i), i);
        }
        for (i = 0; i < element.getRelatedArtifact().size(); ++i) {
            this.composeRelatedArtifact(t, "Measure", "relatedArtifact", element.getRelatedArtifact().get(i), i);
        }
        for (i = 0; i < element.getLibrary().size(); ++i) {
            this.composeCanonical(t, "Measure", "library", element.getLibrary().get(i), i);
        }
        if (element.hasDisclaimerElement()) {
            this.composeMarkdown(t, "Measure", "disclaimer", element.getDisclaimerElement(), -1);
        }
        if (element.hasScoring()) {
            this.composeCodeableConcept(t, "Measure", "scoring", element.getScoring(), -1);
        }
        if (element.hasCompositeScoring()) {
            this.composeCodeableConcept(t, "Measure", "compositeScoring", element.getCompositeScoring(), -1);
        }
        for (i = 0; i < element.getType().size(); ++i) {
            this.composeCodeableConcept(t, "Measure", "type", element.getType().get(i), i);
        }
        if (element.hasRiskAdjustmentElement()) {
            this.composeString(t, "Measure", "riskAdjustment", element.getRiskAdjustmentElement(), -1);
        }
        if (element.hasRateAggregationElement()) {
            this.composeString(t, "Measure", "rateAggregation", element.getRateAggregationElement(), -1);
        }
        if (element.hasRationaleElement()) {
            this.composeMarkdown(t, "Measure", "rationale", element.getRationaleElement(), -1);
        }
        if (element.hasClinicalRecommendationStatementElement()) {
            this.composeMarkdown(t, "Measure", "clinicalRecommendationStatement", element.getClinicalRecommendationStatementElement(), -1);
        }
        if (element.hasImprovementNotation()) {
            this.composeCodeableConcept(t, "Measure", "improvementNotation", element.getImprovementNotation(), -1);
        }
        for (i = 0; i < element.getDefinition().size(); ++i) {
            this.composeMarkdown(t, "Measure", "definition", element.getDefinition().get(i), i);
        }
        if (element.hasGuidanceElement()) {
            this.composeMarkdown(t, "Measure", "guidance", element.getGuidanceElement(), -1);
        }
        for (i = 0; i < element.getGroup().size(); ++i) {
            this.composeMeasureMeasureGroupComponent(t, "Measure", "group", element.getGroup().get(i), i);
        }
        for (i = 0; i < element.getSupplementalData().size(); ++i) {
            this.composeMeasureMeasureSupplementalDataComponent(t, "Measure", "supplementalData", element.getSupplementalData().get(i), i);
        }
    }

    protected void composeMeasureMeasureGroupComponent(Turtle.Complex parent, String parentType, String name, Measure.MeasureGroupComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "group", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "Measure", "code", element.getCode(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "Measure", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getPopulation().size(); ++i) {
            this.composeMeasureMeasureGroupPopulationComponent(t, "Measure", "population", element.getPopulation().get(i), i);
        }
        for (i = 0; i < element.getStratifier().size(); ++i) {
            this.composeMeasureMeasureGroupStratifierComponent(t, "Measure", "stratifier", element.getStratifier().get(i), i);
        }
    }

    protected void composeMeasureMeasureGroupPopulationComponent(Turtle.Complex parent, String parentType, String name, Measure.MeasureGroupPopulationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "population", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "Measure", "code", element.getCode(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "Measure", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasCriteria()) {
            this.composeExpression(t, "Measure", "criteria", element.getCriteria(), -1);
        }
    }

    protected void composeMeasureMeasureGroupStratifierComponent(Turtle.Complex parent, String parentType, String name, Measure.MeasureGroupStratifierComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "stratifier", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "Measure", "code", element.getCode(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "Measure", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasCriteria()) {
            this.composeExpression(t, "Measure", "criteria", element.getCriteria(), -1);
        }
        for (int i = 0; i < element.getComponent().size(); ++i) {
            this.composeMeasureMeasureGroupStratifierComponentComponent(t, "Measure", "component", element.getComponent().get(i), i);
        }
    }

    protected void composeMeasureMeasureGroupStratifierComponentComponent(Turtle.Complex parent, String parentType, String name, Measure.MeasureGroupStratifierComponentComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "component", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "Measure", "code", element.getCode(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "Measure", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasCriteria()) {
            this.composeExpression(t, "Measure", "criteria", element.getCriteria(), -1);
        }
    }

    protected void composeMeasureMeasureSupplementalDataComponent(Turtle.Complex parent, String parentType, String name, Measure.MeasureSupplementalDataComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "supplementalData", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "Measure", "code", element.getCode(), -1);
        }
        for (int i = 0; i < element.getUsage().size(); ++i) {
            this.composeCodeableConcept(t, "Measure", "usage", element.getUsage().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "Measure", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasCriteria()) {
            this.composeExpression(t, "Measure", "criteria", element.getCriteria(), -1);
        }
    }

    protected void composeMeasureReport(Turtle.Complex parent, String parentType, String name, MeasureReport element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "MeasureReport", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "MeasureReport", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "MeasureReport", "status", element.getStatusElement(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeEnum(t, "MeasureReport", "type", element.getTypeElement(), -1);
        }
        if (element.hasMeasureElement()) {
            this.composeCanonical(t, "MeasureReport", "measure", element.getMeasureElement(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "MeasureReport", "subject", element.getSubject(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "MeasureReport", "date", element.getDateElement(), -1);
        }
        if (element.hasReporter()) {
            this.composeReference(t, "MeasureReport", "reporter", element.getReporter(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "MeasureReport", "period", element.getPeriod(), -1);
        }
        if (element.hasImprovementNotation()) {
            this.composeCodeableConcept(t, "MeasureReport", "improvementNotation", element.getImprovementNotation(), -1);
        }
        for (i = 0; i < element.getGroup().size(); ++i) {
            this.composeMeasureReportMeasureReportGroupComponent(t, "MeasureReport", "group", element.getGroup().get(i), i);
        }
        for (i = 0; i < element.getEvaluatedResource().size(); ++i) {
            this.composeReference(t, "MeasureReport", "evaluatedResource", element.getEvaluatedResource().get(i), i);
        }
    }

    protected void composeMeasureReportMeasureReportGroupComponent(Turtle.Complex parent, String parentType, String name, MeasureReport.MeasureReportGroupComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "group", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "MeasureReport", "code", element.getCode(), -1);
        }
        for (i = 0; i < element.getPopulation().size(); ++i) {
            this.composeMeasureReportMeasureReportGroupPopulationComponent(t, "MeasureReport", "population", element.getPopulation().get(i), i);
        }
        if (element.hasMeasureScore()) {
            this.composeQuantity(t, "MeasureReport", "measureScore", element.getMeasureScore(), -1);
        }
        for (i = 0; i < element.getStratifier().size(); ++i) {
            this.composeMeasureReportMeasureReportGroupStratifierComponent(t, "MeasureReport", "stratifier", element.getStratifier().get(i), i);
        }
    }

    protected void composeMeasureReportMeasureReportGroupPopulationComponent(Turtle.Complex parent, String parentType, String name, MeasureReport.MeasureReportGroupPopulationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "population", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "MeasureReport", "code", element.getCode(), -1);
        }
        if (element.hasCountElement()) {
            this.composeInteger(t, "MeasureReport", "count", element.getCountElement(), -1);
        }
        if (element.hasSubjectResults()) {
            this.composeReference(t, "MeasureReport", "subjectResults", element.getSubjectResults(), -1);
        }
    }

    protected void composeMeasureReportMeasureReportGroupStratifierComponent(Turtle.Complex parent, String parentType, String name, MeasureReport.MeasureReportGroupStratifierComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "stratifier", name, element, index);
        for (i = 0; i < element.getCode().size(); ++i) {
            this.composeCodeableConcept(t, "MeasureReport", "code", element.getCode().get(i), i);
        }
        for (i = 0; i < element.getStratum().size(); ++i) {
            this.composeMeasureReportStratifierGroupComponent(t, "MeasureReport", "stratum", element.getStratum().get(i), i);
        }
    }

    protected void composeMeasureReportStratifierGroupComponent(Turtle.Complex parent, String parentType, String name, MeasureReport.StratifierGroupComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "stratum", name, element, index);
        if (element.hasValue()) {
            this.composeCodeableConcept(t, "MeasureReport", "value", element.getValue(), -1);
        }
        for (i = 0; i < element.getComponent().size(); ++i) {
            this.composeMeasureReportStratifierGroupComponentComponent(t, "MeasureReport", "component", element.getComponent().get(i), i);
        }
        for (i = 0; i < element.getPopulation().size(); ++i) {
            this.composeMeasureReportStratifierGroupPopulationComponent(t, "MeasureReport", "population", element.getPopulation().get(i), i);
        }
        if (element.hasMeasureScore()) {
            this.composeQuantity(t, "MeasureReport", "measureScore", element.getMeasureScore(), -1);
        }
    }

    protected void composeMeasureReportStratifierGroupComponentComponent(Turtle.Complex parent, String parentType, String name, MeasureReport.StratifierGroupComponentComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "component", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "MeasureReport", "code", element.getCode(), -1);
        }
        if (element.hasValue()) {
            this.composeCodeableConcept(t, "MeasureReport", "value", element.getValue(), -1);
        }
    }

    protected void composeMeasureReportStratifierGroupPopulationComponent(Turtle.Complex parent, String parentType, String name, MeasureReport.StratifierGroupPopulationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "population", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "MeasureReport", "code", element.getCode(), -1);
        }
        if (element.hasCountElement()) {
            this.composeInteger(t, "MeasureReport", "count", element.getCountElement(), -1);
        }
        if (element.hasSubjectResults()) {
            this.composeReference(t, "MeasureReport", "subjectResults", element.getSubjectResults(), -1);
        }
    }

    protected void composeMedia(Turtle.Complex parent, String parentType, String name, Media element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Media", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Media", "identifier", element.getIdentifier().get(i), i);
        }
        for (i = 0; i < element.getBasedOn().size(); ++i) {
            this.composeReference(t, "Media", "basedOn", element.getBasedOn().get(i), i);
        }
        for (i = 0; i < element.getPartOf().size(); ++i) {
            this.composeReference(t, "Media", "partOf", element.getPartOf().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Media", "status", element.getStatusElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "Media", "type", element.getType(), -1);
        }
        if (element.hasModality()) {
            this.composeCodeableConcept(t, "Media", "modality", element.getModality(), -1);
        }
        if (element.hasView()) {
            this.composeCodeableConcept(t, "Media", "view", element.getView(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "Media", "subject", element.getSubject(), -1);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "Media", "encounter", element.getEncounter(), -1);
        }
        if (element.hasCreated()) {
            this.composeType(t, "Media", "created", element.getCreated(), -1);
        }
        if (element.hasIssuedElement()) {
            this.composeInstant(t, "Media", "issued", element.getIssuedElement(), -1);
        }
        if (element.hasOperator()) {
            this.composeReference(t, "Media", "operator", element.getOperator(), -1);
        }
        for (i = 0; i < element.getReasonCode().size(); ++i) {
            this.composeCodeableConcept(t, "Media", "reasonCode", element.getReasonCode().get(i), i);
        }
        if (element.hasBodySite()) {
            this.composeCodeableConcept(t, "Media", "bodySite", element.getBodySite(), -1);
        }
        if (element.hasDeviceNameElement()) {
            this.composeString(t, "Media", "deviceName", element.getDeviceNameElement(), -1);
        }
        if (element.hasDevice()) {
            this.composeReference(t, "Media", "device", element.getDevice(), -1);
        }
        if (element.hasHeightElement()) {
            this.composePositiveInt(t, "Media", "height", element.getHeightElement(), -1);
        }
        if (element.hasWidthElement()) {
            this.composePositiveInt(t, "Media", "width", element.getWidthElement(), -1);
        }
        if (element.hasFramesElement()) {
            this.composePositiveInt(t, "Media", "frames", element.getFramesElement(), -1);
        }
        if (element.hasDurationElement()) {
            this.composeDecimal(t, "Media", "duration", element.getDurationElement(), -1);
        }
        if (element.hasContent()) {
            this.composeAttachment(t, "Media", "content", element.getContent(), -1);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "Media", "note", element.getNote().get(i), i);
        }
    }

    protected void composeMedication(Turtle.Complex parent, String parentType, String name, Medication element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Medication", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Medication", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "Medication", "code", element.getCode(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Medication", "status", element.getStatusElement(), -1);
        }
        if (element.hasManufacturer()) {
            this.composeReference(t, "Medication", "manufacturer", element.getManufacturer(), -1);
        }
        if (element.hasForm()) {
            this.composeCodeableConcept(t, "Medication", "form", element.getForm(), -1);
        }
        if (element.hasAmount()) {
            this.composeRatio(t, "Medication", "amount", element.getAmount(), -1);
        }
        for (i = 0; i < element.getIngredient().size(); ++i) {
            this.composeMedicationMedicationIngredientComponent(t, "Medication", "ingredient", element.getIngredient().get(i), i);
        }
        if (element.hasBatch()) {
            this.composeMedicationMedicationBatchComponent(t, "Medication", "batch", element.getBatch(), -1);
        }
    }

    protected void composeMedicationMedicationIngredientComponent(Turtle.Complex parent, String parentType, String name, Medication.MedicationIngredientComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "ingredient", name, element, index);
        if (element.hasItem()) {
            this.composeType(t, "Medication", "item", element.getItem(), -1);
        }
        if (element.hasIsActiveElement()) {
            this.composeBoolean(t, "Medication", "isActive", element.getIsActiveElement(), -1);
        }
        if (element.hasStrength()) {
            this.composeRatio(t, "Medication", "strength", element.getStrength(), -1);
        }
    }

    protected void composeMedicationMedicationBatchComponent(Turtle.Complex parent, String parentType, String name, Medication.MedicationBatchComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "batch", name, element, index);
        if (element.hasLotNumberElement()) {
            this.composeString(t, "Medication", "lotNumber", element.getLotNumberElement(), -1);
        }
        if (element.hasExpirationDateElement()) {
            this.composeDateTime(t, "Medication", "expirationDate", element.getExpirationDateElement(), -1);
        }
    }

    protected void composeMedicationAdministration(Turtle.Complex parent, String parentType, String name, MedicationAdministration element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "MedicationAdministration", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "MedicationAdministration", "identifier", element.getIdentifier().get(i), i);
        }
        for (i = 0; i < element.getInstantiates().size(); ++i) {
            this.composeUri(t, "MedicationAdministration", "instantiates", element.getInstantiates().get(i), i);
        }
        for (i = 0; i < element.getPartOf().size(); ++i) {
            this.composeReference(t, "MedicationAdministration", "partOf", element.getPartOf().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "MedicationAdministration", "status", element.getStatusElement(), -1);
        }
        for (i = 0; i < element.getStatusReason().size(); ++i) {
            this.composeCodeableConcept(t, "MedicationAdministration", "statusReason", element.getStatusReason().get(i), i);
        }
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "MedicationAdministration", "category", element.getCategory(), -1);
        }
        if (element.hasMedication()) {
            this.composeType(t, "MedicationAdministration", "medication", element.getMedication(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "MedicationAdministration", "subject", element.getSubject(), -1);
        }
        if (element.hasContext()) {
            this.composeReference(t, "MedicationAdministration", "context", element.getContext(), -1);
        }
        for (i = 0; i < element.getSupportingInformation().size(); ++i) {
            this.composeReference(t, "MedicationAdministration", "supportingInformation", element.getSupportingInformation().get(i), i);
        }
        if (element.hasEffective()) {
            this.composeType(t, "MedicationAdministration", "effective", element.getEffective(), -1);
        }
        for (i = 0; i < element.getPerformer().size(); ++i) {
            this.composeMedicationAdministrationMedicationAdministrationPerformerComponent(t, "MedicationAdministration", "performer", element.getPerformer().get(i), i);
        }
        for (i = 0; i < element.getReasonCode().size(); ++i) {
            this.composeCodeableConcept(t, "MedicationAdministration", "reasonCode", element.getReasonCode().get(i), i);
        }
        for (i = 0; i < element.getReasonReference().size(); ++i) {
            this.composeReference(t, "MedicationAdministration", "reasonReference", element.getReasonReference().get(i), i);
        }
        if (element.hasRequest()) {
            this.composeReference(t, "MedicationAdministration", "request", element.getRequest(), -1);
        }
        for (i = 0; i < element.getDevice().size(); ++i) {
            this.composeReference(t, "MedicationAdministration", "device", element.getDevice().get(i), i);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "MedicationAdministration", "note", element.getNote().get(i), i);
        }
        if (element.hasDosage()) {
            this.composeMedicationAdministrationMedicationAdministrationDosageComponent(t, "MedicationAdministration", "dosage", element.getDosage(), -1);
        }
        for (i = 0; i < element.getEventHistory().size(); ++i) {
            this.composeReference(t, "MedicationAdministration", "eventHistory", element.getEventHistory().get(i), i);
        }
    }

    protected void composeMedicationAdministrationMedicationAdministrationPerformerComponent(Turtle.Complex parent, String parentType, String name, MedicationAdministration.MedicationAdministrationPerformerComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "performer", name, element, index);
        if (element.hasFunction()) {
            this.composeCodeableConcept(t, "MedicationAdministration", "function", element.getFunction(), -1);
        }
        if (element.hasActor()) {
            this.composeReference(t, "MedicationAdministration", "actor", element.getActor(), -1);
        }
    }

    protected void composeMedicationAdministrationMedicationAdministrationDosageComponent(Turtle.Complex parent, String parentType, String name, MedicationAdministration.MedicationAdministrationDosageComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "dosage", name, element, index);
        if (element.hasTextElement()) {
            this.composeString(t, "MedicationAdministration", "text", element.getTextElement(), -1);
        }
        if (element.hasSite()) {
            this.composeCodeableConcept(t, "MedicationAdministration", "site", element.getSite(), -1);
        }
        if (element.hasRoute()) {
            this.composeCodeableConcept(t, "MedicationAdministration", "route", element.getRoute(), -1);
        }
        if (element.hasMethod()) {
            this.composeCodeableConcept(t, "MedicationAdministration", "method", element.getMethod(), -1);
        }
        if (element.hasDose()) {
            this.composeQuantity(t, "MedicationAdministration", "dose", element.getDose(), -1);
        }
        if (element.hasRate()) {
            this.composeType(t, "MedicationAdministration", "rate", element.getRate(), -1);
        }
    }

    protected void composeMedicationDispense(Turtle.Complex parent, String parentType, String name, MedicationDispense element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "MedicationDispense", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "MedicationDispense", "identifier", element.getIdentifier().get(i), i);
        }
        for (i = 0; i < element.getPartOf().size(); ++i) {
            this.composeReference(t, "MedicationDispense", "partOf", element.getPartOf().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "MedicationDispense", "status", element.getStatusElement(), -1);
        }
        if (element.hasStatusReason()) {
            this.composeType(t, "MedicationDispense", "statusReason", element.getStatusReason(), -1);
        }
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "MedicationDispense", "category", element.getCategory(), -1);
        }
        if (element.hasMedication()) {
            this.composeType(t, "MedicationDispense", "medication", element.getMedication(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "MedicationDispense", "subject", element.getSubject(), -1);
        }
        if (element.hasContext()) {
            this.composeReference(t, "MedicationDispense", "context", element.getContext(), -1);
        }
        for (i = 0; i < element.getSupportingInformation().size(); ++i) {
            this.composeReference(t, "MedicationDispense", "supportingInformation", element.getSupportingInformation().get(i), i);
        }
        for (i = 0; i < element.getPerformer().size(); ++i) {
            this.composeMedicationDispenseMedicationDispensePerformerComponent(t, "MedicationDispense", "performer", element.getPerformer().get(i), i);
        }
        if (element.hasLocation()) {
            this.composeReference(t, "MedicationDispense", "location", element.getLocation(), -1);
        }
        for (i = 0; i < element.getAuthorizingPrescription().size(); ++i) {
            this.composeReference(t, "MedicationDispense", "authorizingPrescription", element.getAuthorizingPrescription().get(i), i);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "MedicationDispense", "type", element.getType(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "MedicationDispense", "quantity", element.getQuantity(), -1);
        }
        if (element.hasDaysSupply()) {
            this.composeQuantity(t, "MedicationDispense", "daysSupply", element.getDaysSupply(), -1);
        }
        if (element.hasWhenPreparedElement()) {
            this.composeDateTime(t, "MedicationDispense", "whenPrepared", element.getWhenPreparedElement(), -1);
        }
        if (element.hasWhenHandedOverElement()) {
            this.composeDateTime(t, "MedicationDispense", "whenHandedOver", element.getWhenHandedOverElement(), -1);
        }
        if (element.hasDestination()) {
            this.composeReference(t, "MedicationDispense", "destination", element.getDestination(), -1);
        }
        for (i = 0; i < element.getReceiver().size(); ++i) {
            this.composeReference(t, "MedicationDispense", "receiver", element.getReceiver().get(i), i);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "MedicationDispense", "note", element.getNote().get(i), i);
        }
        for (i = 0; i < element.getDosageInstruction().size(); ++i) {
            this.composeDosage(t, "MedicationDispense", "dosageInstruction", element.getDosageInstruction().get(i), i);
        }
        if (element.hasSubstitution()) {
            this.composeMedicationDispenseMedicationDispenseSubstitutionComponent(t, "MedicationDispense", "substitution", element.getSubstitution(), -1);
        }
        for (i = 0; i < element.getDetectedIssue().size(); ++i) {
            this.composeReference(t, "MedicationDispense", "detectedIssue", element.getDetectedIssue().get(i), i);
        }
        for (i = 0; i < element.getEventHistory().size(); ++i) {
            this.composeReference(t, "MedicationDispense", "eventHistory", element.getEventHistory().get(i), i);
        }
    }

    protected void composeMedicationDispenseMedicationDispensePerformerComponent(Turtle.Complex parent, String parentType, String name, MedicationDispense.MedicationDispensePerformerComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "performer", name, element, index);
        if (element.hasFunction()) {
            this.composeCodeableConcept(t, "MedicationDispense", "function", element.getFunction(), -1);
        }
        if (element.hasActor()) {
            this.composeReference(t, "MedicationDispense", "actor", element.getActor(), -1);
        }
    }

    protected void composeMedicationDispenseMedicationDispenseSubstitutionComponent(Turtle.Complex parent, String parentType, String name, MedicationDispense.MedicationDispenseSubstitutionComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "substitution", name, element, index);
        if (element.hasWasSubstitutedElement()) {
            this.composeBoolean(t, "MedicationDispense", "wasSubstituted", element.getWasSubstitutedElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "MedicationDispense", "type", element.getType(), -1);
        }
        for (i = 0; i < element.getReason().size(); ++i) {
            this.composeCodeableConcept(t, "MedicationDispense", "reason", element.getReason().get(i), i);
        }
        for (i = 0; i < element.getResponsibleParty().size(); ++i) {
            this.composeReference(t, "MedicationDispense", "responsibleParty", element.getResponsibleParty().get(i), i);
        }
    }

    protected void composeMedicationKnowledge(Turtle.Complex parent, String parentType, String name, MedicationKnowledge element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "MedicationKnowledge", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "MedicationKnowledge", "code", element.getCode(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "MedicationKnowledge", "status", element.getStatusElement(), -1);
        }
        if (element.hasManufacturer()) {
            this.composeReference(t, "MedicationKnowledge", "manufacturer", element.getManufacturer(), -1);
        }
        if (element.hasDoseForm()) {
            this.composeCodeableConcept(t, "MedicationKnowledge", "doseForm", element.getDoseForm(), -1);
        }
        if (element.hasAmount()) {
            this.composeQuantity(t, "MedicationKnowledge", "amount", element.getAmount(), -1);
        }
        for (i = 0; i < element.getSynonym().size(); ++i) {
            this.composeString(t, "MedicationKnowledge", "synonym", element.getSynonym().get(i), i);
        }
        for (i = 0; i < element.getRelatedMedicationKnowledge().size(); ++i) {
            this.composeMedicationKnowledgeMedicationKnowledgeRelatedMedicationKnowledgeComponent(t, "MedicationKnowledge", "relatedMedicationKnowledge", element.getRelatedMedicationKnowledge().get(i), i);
        }
        for (i = 0; i < element.getAssociatedMedication().size(); ++i) {
            this.composeReference(t, "MedicationKnowledge", "associatedMedication", element.getAssociatedMedication().get(i), i);
        }
        for (i = 0; i < element.getProductType().size(); ++i) {
            this.composeCodeableConcept(t, "MedicationKnowledge", "productType", element.getProductType().get(i), i);
        }
        for (i = 0; i < element.getMonograph().size(); ++i) {
            this.composeMedicationKnowledgeMedicationKnowledgeMonographComponent(t, "MedicationKnowledge", "monograph", element.getMonograph().get(i), i);
        }
        for (i = 0; i < element.getIngredient().size(); ++i) {
            this.composeMedicationKnowledgeMedicationKnowledgeIngredientComponent(t, "MedicationKnowledge", "ingredient", element.getIngredient().get(i), i);
        }
        if (element.hasPreparationInstructionElement()) {
            this.composeMarkdown(t, "MedicationKnowledge", "preparationInstruction", element.getPreparationInstructionElement(), -1);
        }
        for (i = 0; i < element.getIntendedRoute().size(); ++i) {
            this.composeCodeableConcept(t, "MedicationKnowledge", "intendedRoute", element.getIntendedRoute().get(i), i);
        }
        for (i = 0; i < element.getCost().size(); ++i) {
            this.composeMedicationKnowledgeMedicationKnowledgeCostComponent(t, "MedicationKnowledge", "cost", element.getCost().get(i), i);
        }
        for (i = 0; i < element.getMonitoringProgram().size(); ++i) {
            this.composeMedicationKnowledgeMedicationKnowledgeMonitoringProgramComponent(t, "MedicationKnowledge", "monitoringProgram", element.getMonitoringProgram().get(i), i);
        }
        for (i = 0; i < element.getAdministrationGuidelines().size(); ++i) {
            this.composeMedicationKnowledgeMedicationKnowledgeAdministrationGuidelinesComponent(t, "MedicationKnowledge", "administrationGuidelines", element.getAdministrationGuidelines().get(i), i);
        }
        for (i = 0; i < element.getMedicineClassification().size(); ++i) {
            this.composeMedicationKnowledgeMedicationKnowledgeMedicineClassificationComponent(t, "MedicationKnowledge", "medicineClassification", element.getMedicineClassification().get(i), i);
        }
        if (element.hasPackaging()) {
            this.composeMedicationKnowledgeMedicationKnowledgePackagingComponent(t, "MedicationKnowledge", "packaging", element.getPackaging(), -1);
        }
        for (i = 0; i < element.getDrugCharacteristic().size(); ++i) {
            this.composeMedicationKnowledgeMedicationKnowledgeDrugCharacteristicComponent(t, "MedicationKnowledge", "drugCharacteristic", element.getDrugCharacteristic().get(i), i);
        }
        for (i = 0; i < element.getContraindication().size(); ++i) {
            this.composeReference(t, "MedicationKnowledge", "contraindication", element.getContraindication().get(i), i);
        }
        for (i = 0; i < element.getRegulatory().size(); ++i) {
            this.composeMedicationKnowledgeMedicationKnowledgeRegulatoryComponent(t, "MedicationKnowledge", "regulatory", element.getRegulatory().get(i), i);
        }
        for (i = 0; i < element.getKinetics().size(); ++i) {
            this.composeMedicationKnowledgeMedicationKnowledgeKineticsComponent(t, "MedicationKnowledge", "kinetics", element.getKinetics().get(i), i);
        }
    }

    protected void composeMedicationKnowledgeMedicationKnowledgeRelatedMedicationKnowledgeComponent(Turtle.Complex parent, String parentType, String name, MedicationKnowledge.MedicationKnowledgeRelatedMedicationKnowledgeComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "relatedMedicationKnowledge", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "MedicationKnowledge", "type", element.getType(), -1);
        }
        for (int i = 0; i < element.getReference().size(); ++i) {
            this.composeReference(t, "MedicationKnowledge", "reference", element.getReference().get(i), i);
        }
    }

    protected void composeMedicationKnowledgeMedicationKnowledgeMonographComponent(Turtle.Complex parent, String parentType, String name, MedicationKnowledge.MedicationKnowledgeMonographComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "monograph", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "MedicationKnowledge", "type", element.getType(), -1);
        }
        if (element.hasSource()) {
            this.composeReference(t, "MedicationKnowledge", "source", element.getSource(), -1);
        }
    }

    protected void composeMedicationKnowledgeMedicationKnowledgeIngredientComponent(Turtle.Complex parent, String parentType, String name, MedicationKnowledge.MedicationKnowledgeIngredientComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "ingredient", name, element, index);
        if (element.hasItem()) {
            this.composeType(t, "MedicationKnowledge", "item", element.getItem(), -1);
        }
        if (element.hasIsActiveElement()) {
            this.composeBoolean(t, "MedicationKnowledge", "isActive", element.getIsActiveElement(), -1);
        }
        if (element.hasStrength()) {
            this.composeRatio(t, "MedicationKnowledge", "strength", element.getStrength(), -1);
        }
    }

    protected void composeMedicationKnowledgeMedicationKnowledgeCostComponent(Turtle.Complex parent, String parentType, String name, MedicationKnowledge.MedicationKnowledgeCostComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "cost", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "MedicationKnowledge", "type", element.getType(), -1);
        }
        if (element.hasSourceElement()) {
            this.composeString(t, "MedicationKnowledge", "source", element.getSourceElement(), -1);
        }
        if (element.hasCost()) {
            this.composeMoney(t, "MedicationKnowledge", "cost", element.getCost(), -1);
        }
    }

    protected void composeMedicationKnowledgeMedicationKnowledgeMonitoringProgramComponent(Turtle.Complex parent, String parentType, String name, MedicationKnowledge.MedicationKnowledgeMonitoringProgramComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "monitoringProgram", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "MedicationKnowledge", "type", element.getType(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "MedicationKnowledge", "name", element.getNameElement(), -1);
        }
    }

    protected void composeMedicationKnowledgeMedicationKnowledgeAdministrationGuidelinesComponent(Turtle.Complex parent, String parentType, String name, MedicationKnowledge.MedicationKnowledgeAdministrationGuidelinesComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "administrationGuidelines", name, element, index);
        for (i = 0; i < element.getDosage().size(); ++i) {
            this.composeMedicationKnowledgeMedicationKnowledgeAdministrationGuidelinesDosageComponent(t, "MedicationKnowledge", "dosage", element.getDosage().get(i), i);
        }
        if (element.hasIndication()) {
            this.composeType(t, "MedicationKnowledge", "indication", element.getIndication(), -1);
        }
        for (i = 0; i < element.getPatientCharacteristics().size(); ++i) {
            this.composeMedicationKnowledgeMedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent(t, "MedicationKnowledge", "patientCharacteristics", element.getPatientCharacteristics().get(i), i);
        }
    }

    protected void composeMedicationKnowledgeMedicationKnowledgeAdministrationGuidelinesDosageComponent(Turtle.Complex parent, String parentType, String name, MedicationKnowledge.MedicationKnowledgeAdministrationGuidelinesDosageComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "dosage", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "MedicationKnowledge", "type", element.getType(), -1);
        }
        for (int i = 0; i < element.getDosage().size(); ++i) {
            this.composeDosage(t, "MedicationKnowledge", "dosage", element.getDosage().get(i), i);
        }
    }

    protected void composeMedicationKnowledgeMedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent(Turtle.Complex parent, String parentType, String name, MedicationKnowledge.MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "patientCharacteristics", name, element, index);
        if (element.hasCharacteristic()) {
            this.composeType(t, "MedicationKnowledge", "characteristic", element.getCharacteristic(), -1);
        }
        for (int i = 0; i < element.getValue().size(); ++i) {
            this.composeString(t, "MedicationKnowledge", "value", element.getValue().get(i), i);
        }
    }

    protected void composeMedicationKnowledgeMedicationKnowledgeMedicineClassificationComponent(Turtle.Complex parent, String parentType, String name, MedicationKnowledge.MedicationKnowledgeMedicineClassificationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "medicineClassification", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "MedicationKnowledge", "type", element.getType(), -1);
        }
        for (int i = 0; i < element.getClassification().size(); ++i) {
            this.composeCodeableConcept(t, "MedicationKnowledge", "classification", element.getClassification().get(i), i);
        }
    }

    protected void composeMedicationKnowledgeMedicationKnowledgePackagingComponent(Turtle.Complex parent, String parentType, String name, MedicationKnowledge.MedicationKnowledgePackagingComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "packaging", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "MedicationKnowledge", "type", element.getType(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "MedicationKnowledge", "quantity", element.getQuantity(), -1);
        }
    }

    protected void composeMedicationKnowledgeMedicationKnowledgeDrugCharacteristicComponent(Turtle.Complex parent, String parentType, String name, MedicationKnowledge.MedicationKnowledgeDrugCharacteristicComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "drugCharacteristic", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "MedicationKnowledge", "type", element.getType(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "MedicationKnowledge", "value", element.getValue(), -1);
        }
    }

    protected void composeMedicationKnowledgeMedicationKnowledgeRegulatoryComponent(Turtle.Complex parent, String parentType, String name, MedicationKnowledge.MedicationKnowledgeRegulatoryComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "regulatory", name, element, index);
        if (element.hasRegulatoryAuthority()) {
            this.composeReference(t, "MedicationKnowledge", "regulatoryAuthority", element.getRegulatoryAuthority(), -1);
        }
        for (i = 0; i < element.getSubstitution().size(); ++i) {
            this.composeMedicationKnowledgeMedicationKnowledgeRegulatorySubstitutionComponent(t, "MedicationKnowledge", "substitution", element.getSubstitution().get(i), i);
        }
        for (i = 0; i < element.getSchedule().size(); ++i) {
            this.composeMedicationKnowledgeMedicationKnowledgeRegulatoryScheduleComponent(t, "MedicationKnowledge", "schedule", element.getSchedule().get(i), i);
        }
        if (element.hasMaxDispense()) {
            this.composeMedicationKnowledgeMedicationKnowledgeRegulatoryMaxDispenseComponent(t, "MedicationKnowledge", "maxDispense", element.getMaxDispense(), -1);
        }
    }

    protected void composeMedicationKnowledgeMedicationKnowledgeRegulatorySubstitutionComponent(Turtle.Complex parent, String parentType, String name, MedicationKnowledge.MedicationKnowledgeRegulatorySubstitutionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "substitution", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "MedicationKnowledge", "type", element.getType(), -1);
        }
        if (element.hasAllowedElement()) {
            this.composeBoolean(t, "MedicationKnowledge", "allowed", element.getAllowedElement(), -1);
        }
    }

    protected void composeMedicationKnowledgeMedicationKnowledgeRegulatoryScheduleComponent(Turtle.Complex parent, String parentType, String name, MedicationKnowledge.MedicationKnowledgeRegulatoryScheduleComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "schedule", name, element, index);
        if (element.hasSchedule()) {
            this.composeCodeableConcept(t, "MedicationKnowledge", "schedule", element.getSchedule(), -1);
        }
    }

    protected void composeMedicationKnowledgeMedicationKnowledgeRegulatoryMaxDispenseComponent(Turtle.Complex parent, String parentType, String name, MedicationKnowledge.MedicationKnowledgeRegulatoryMaxDispenseComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "maxDispense", name, element, index);
        if (element.hasQuantity()) {
            this.composeQuantity(t, "MedicationKnowledge", "quantity", element.getQuantity(), -1);
        }
        if (element.hasPeriod()) {
            this.composeDuration(t, "MedicationKnowledge", "period", element.getPeriod(), -1);
        }
    }

    protected void composeMedicationKnowledgeMedicationKnowledgeKineticsComponent(Turtle.Complex parent, String parentType, String name, MedicationKnowledge.MedicationKnowledgeKineticsComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "kinetics", name, element, index);
        for (i = 0; i < element.getAreaUnderCurve().size(); ++i) {
            this.composeQuantity(t, "MedicationKnowledge", "areaUnderCurve", element.getAreaUnderCurve().get(i), i);
        }
        for (i = 0; i < element.getLethalDose50().size(); ++i) {
            this.composeQuantity(t, "MedicationKnowledge", "lethalDose50", element.getLethalDose50().get(i), i);
        }
        if (element.hasHalfLifePeriod()) {
            this.composeDuration(t, "MedicationKnowledge", "halfLifePeriod", element.getHalfLifePeriod(), -1);
        }
    }

    protected void composeMedicationRequest(Turtle.Complex parent, String parentType, String name, MedicationRequest element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "MedicationRequest", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "MedicationRequest", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "MedicationRequest", "status", element.getStatusElement(), -1);
        }
        if (element.hasStatusReason()) {
            this.composeCodeableConcept(t, "MedicationRequest", "statusReason", element.getStatusReason(), -1);
        }
        if (element.hasIntentElement()) {
            this.composeEnum(t, "MedicationRequest", "intent", element.getIntentElement(), -1);
        }
        for (i = 0; i < element.getCategory().size(); ++i) {
            this.composeCodeableConcept(t, "MedicationRequest", "category", element.getCategory().get(i), i);
        }
        if (element.hasPriorityElement()) {
            this.composeEnum(t, "MedicationRequest", "priority", element.getPriorityElement(), -1);
        }
        if (element.hasDoNotPerformElement()) {
            this.composeBoolean(t, "MedicationRequest", "doNotPerform", element.getDoNotPerformElement(), -1);
        }
        if (element.hasReported()) {
            this.composeType(t, "MedicationRequest", "reported", element.getReported(), -1);
        }
        if (element.hasMedication()) {
            this.composeType(t, "MedicationRequest", "medication", element.getMedication(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "MedicationRequest", "subject", element.getSubject(), -1);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "MedicationRequest", "encounter", element.getEncounter(), -1);
        }
        for (i = 0; i < element.getSupportingInformation().size(); ++i) {
            this.composeReference(t, "MedicationRequest", "supportingInformation", element.getSupportingInformation().get(i), i);
        }
        if (element.hasAuthoredOnElement()) {
            this.composeDateTime(t, "MedicationRequest", "authoredOn", element.getAuthoredOnElement(), -1);
        }
        if (element.hasRequester()) {
            this.composeReference(t, "MedicationRequest", "requester", element.getRequester(), -1);
        }
        if (element.hasPerformer()) {
            this.composeReference(t, "MedicationRequest", "performer", element.getPerformer(), -1);
        }
        if (element.hasPerformerType()) {
            this.composeCodeableConcept(t, "MedicationRequest", "performerType", element.getPerformerType(), -1);
        }
        if (element.hasRecorder()) {
            this.composeReference(t, "MedicationRequest", "recorder", element.getRecorder(), -1);
        }
        for (i = 0; i < element.getReasonCode().size(); ++i) {
            this.composeCodeableConcept(t, "MedicationRequest", "reasonCode", element.getReasonCode().get(i), i);
        }
        for (i = 0; i < element.getReasonReference().size(); ++i) {
            this.composeReference(t, "MedicationRequest", "reasonReference", element.getReasonReference().get(i), i);
        }
        for (i = 0; i < element.getInstantiatesCanonical().size(); ++i) {
            this.composeCanonical(t, "MedicationRequest", "instantiatesCanonical", element.getInstantiatesCanonical().get(i), i);
        }
        for (i = 0; i < element.getInstantiatesUri().size(); ++i) {
            this.composeUri(t, "MedicationRequest", "instantiatesUri", element.getInstantiatesUri().get(i), i);
        }
        for (i = 0; i < element.getBasedOn().size(); ++i) {
            this.composeReference(t, "MedicationRequest", "basedOn", element.getBasedOn().get(i), i);
        }
        if (element.hasGroupIdentifier()) {
            this.composeIdentifier(t, "MedicationRequest", "groupIdentifier", element.getGroupIdentifier(), -1);
        }
        if (element.hasCourseOfTherapyType()) {
            this.composeCodeableConcept(t, "MedicationRequest", "courseOfTherapyType", element.getCourseOfTherapyType(), -1);
        }
        for (i = 0; i < element.getInsurance().size(); ++i) {
            this.composeReference(t, "MedicationRequest", "insurance", element.getInsurance().get(i), i);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "MedicationRequest", "note", element.getNote().get(i), i);
        }
        for (i = 0; i < element.getDosageInstruction().size(); ++i) {
            this.composeDosage(t, "MedicationRequest", "dosageInstruction", element.getDosageInstruction().get(i), i);
        }
        if (element.hasDispenseRequest()) {
            this.composeMedicationRequestMedicationRequestDispenseRequestComponent(t, "MedicationRequest", "dispenseRequest", element.getDispenseRequest(), -1);
        }
        if (element.hasSubstitution()) {
            this.composeMedicationRequestMedicationRequestSubstitutionComponent(t, "MedicationRequest", "substitution", element.getSubstitution(), -1);
        }
        if (element.hasPriorPrescription()) {
            this.composeReference(t, "MedicationRequest", "priorPrescription", element.getPriorPrescription(), -1);
        }
        for (i = 0; i < element.getDetectedIssue().size(); ++i) {
            this.composeReference(t, "MedicationRequest", "detectedIssue", element.getDetectedIssue().get(i), i);
        }
        for (i = 0; i < element.getEventHistory().size(); ++i) {
            this.composeReference(t, "MedicationRequest", "eventHistory", element.getEventHistory().get(i), i);
        }
    }

    protected void composeMedicationRequestMedicationRequestDispenseRequestComponent(Turtle.Complex parent, String parentType, String name, MedicationRequest.MedicationRequestDispenseRequestComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "dispenseRequest", name, element, index);
        if (element.hasInitialFill()) {
            this.composeMedicationRequestMedicationRequestDispenseRequestInitialFillComponent(t, "MedicationRequest", "initialFill", element.getInitialFill(), -1);
        }
        if (element.hasDispenseInterval()) {
            this.composeDuration(t, "MedicationRequest", "dispenseInterval", element.getDispenseInterval(), -1);
        }
        if (element.hasValidityPeriod()) {
            this.composePeriod(t, "MedicationRequest", "validityPeriod", element.getValidityPeriod(), -1);
        }
        if (element.hasNumberOfRepeatsAllowedElement()) {
            this.composeUnsignedInt(t, "MedicationRequest", "numberOfRepeatsAllowed", element.getNumberOfRepeatsAllowedElement(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "MedicationRequest", "quantity", element.getQuantity(), -1);
        }
        if (element.hasExpectedSupplyDuration()) {
            this.composeDuration(t, "MedicationRequest", "expectedSupplyDuration", element.getExpectedSupplyDuration(), -1);
        }
        if (element.hasPerformer()) {
            this.composeReference(t, "MedicationRequest", "performer", element.getPerformer(), -1);
        }
    }

    protected void composeMedicationRequestMedicationRequestDispenseRequestInitialFillComponent(Turtle.Complex parent, String parentType, String name, MedicationRequest.MedicationRequestDispenseRequestInitialFillComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "initialFill", name, element, index);
        if (element.hasQuantity()) {
            this.composeQuantity(t, "MedicationRequest", "quantity", element.getQuantity(), -1);
        }
        if (element.hasDuration()) {
            this.composeDuration(t, "MedicationRequest", "duration", element.getDuration(), -1);
        }
    }

    protected void composeMedicationRequestMedicationRequestSubstitutionComponent(Turtle.Complex parent, String parentType, String name, MedicationRequest.MedicationRequestSubstitutionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "substitution", name, element, index);
        if (element.hasAllowed()) {
            this.composeType(t, "MedicationRequest", "allowed", element.getAllowed(), -1);
        }
        if (element.hasReason()) {
            this.composeCodeableConcept(t, "MedicationRequest", "reason", element.getReason(), -1);
        }
    }

    protected void composeMedicationStatement(Turtle.Complex parent, String parentType, String name, MedicationStatement element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "MedicationStatement", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "MedicationStatement", "identifier", element.getIdentifier().get(i), i);
        }
        for (i = 0; i < element.getBasedOn().size(); ++i) {
            this.composeReference(t, "MedicationStatement", "basedOn", element.getBasedOn().get(i), i);
        }
        for (i = 0; i < element.getPartOf().size(); ++i) {
            this.composeReference(t, "MedicationStatement", "partOf", element.getPartOf().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "MedicationStatement", "status", element.getStatusElement(), -1);
        }
        for (i = 0; i < element.getStatusReason().size(); ++i) {
            this.composeCodeableConcept(t, "MedicationStatement", "statusReason", element.getStatusReason().get(i), i);
        }
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "MedicationStatement", "category", element.getCategory(), -1);
        }
        if (element.hasMedication()) {
            this.composeType(t, "MedicationStatement", "medication", element.getMedication(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "MedicationStatement", "subject", element.getSubject(), -1);
        }
        if (element.hasContext()) {
            this.composeReference(t, "MedicationStatement", "context", element.getContext(), -1);
        }
        if (element.hasEffective()) {
            this.composeType(t, "MedicationStatement", "effective", element.getEffective(), -1);
        }
        if (element.hasDateAssertedElement()) {
            this.composeDateTime(t, "MedicationStatement", "dateAsserted", element.getDateAssertedElement(), -1);
        }
        if (element.hasInformationSource()) {
            this.composeReference(t, "MedicationStatement", "informationSource", element.getInformationSource(), -1);
        }
        for (i = 0; i < element.getDerivedFrom().size(); ++i) {
            this.composeReference(t, "MedicationStatement", "derivedFrom", element.getDerivedFrom().get(i), i);
        }
        for (i = 0; i < element.getReasonCode().size(); ++i) {
            this.composeCodeableConcept(t, "MedicationStatement", "reasonCode", element.getReasonCode().get(i), i);
        }
        for (i = 0; i < element.getReasonReference().size(); ++i) {
            this.composeReference(t, "MedicationStatement", "reasonReference", element.getReasonReference().get(i), i);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "MedicationStatement", "note", element.getNote().get(i), i);
        }
        for (i = 0; i < element.getDosage().size(); ++i) {
            this.composeDosage(t, "MedicationStatement", "dosage", element.getDosage().get(i), i);
        }
    }

    protected void composeMedicinalProduct(Turtle.Complex parent, String parentType, String name, MedicinalProduct element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "MedicinalProduct", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "MedicinalProduct", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "MedicinalProduct", "type", element.getType(), -1);
        }
        if (element.hasDomain()) {
            this.composeCoding(t, "MedicinalProduct", "domain", element.getDomain(), -1);
        }
        if (element.hasCombinedPharmaceuticalDoseForm()) {
            this.composeCodeableConcept(t, "MedicinalProduct", "combinedPharmaceuticalDoseForm", element.getCombinedPharmaceuticalDoseForm(), -1);
        }
        if (element.hasLegalStatusOfSupply()) {
            this.composeCodeableConcept(t, "MedicinalProduct", "legalStatusOfSupply", element.getLegalStatusOfSupply(), -1);
        }
        if (element.hasAdditionalMonitoringIndicator()) {
            this.composeCodeableConcept(t, "MedicinalProduct", "additionalMonitoringIndicator", element.getAdditionalMonitoringIndicator(), -1);
        }
        for (i = 0; i < element.getSpecialMeasures().size(); ++i) {
            this.composeString(t, "MedicinalProduct", "specialMeasures", element.getSpecialMeasures().get(i), i);
        }
        if (element.hasPaediatricUseIndicator()) {
            this.composeCodeableConcept(t, "MedicinalProduct", "paediatricUseIndicator", element.getPaediatricUseIndicator(), -1);
        }
        for (i = 0; i < element.getProductClassification().size(); ++i) {
            this.composeCodeableConcept(t, "MedicinalProduct", "productClassification", element.getProductClassification().get(i), i);
        }
        for (i = 0; i < element.getMarketingStatus().size(); ++i) {
            this.composeMarketingStatus(t, "MedicinalProduct", "marketingStatus", element.getMarketingStatus().get(i), i);
        }
        for (i = 0; i < element.getPharmaceuticalProduct().size(); ++i) {
            this.composeReference(t, "MedicinalProduct", "pharmaceuticalProduct", element.getPharmaceuticalProduct().get(i), i);
        }
        for (i = 0; i < element.getPackagedMedicinalProduct().size(); ++i) {
            this.composeReference(t, "MedicinalProduct", "packagedMedicinalProduct", element.getPackagedMedicinalProduct().get(i), i);
        }
        for (i = 0; i < element.getAttachedDocument().size(); ++i) {
            this.composeReference(t, "MedicinalProduct", "attachedDocument", element.getAttachedDocument().get(i), i);
        }
        for (i = 0; i < element.getMasterFile().size(); ++i) {
            this.composeReference(t, "MedicinalProduct", "masterFile", element.getMasterFile().get(i), i);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeReference(t, "MedicinalProduct", "contact", element.getContact().get(i), i);
        }
        for (i = 0; i < element.getClinicalTrial().size(); ++i) {
            this.composeReference(t, "MedicinalProduct", "clinicalTrial", element.getClinicalTrial().get(i), i);
        }
        for (i = 0; i < element.getName().size(); ++i) {
            this.composeMedicinalProductMedicinalProductNameComponent(t, "MedicinalProduct", "name", element.getName().get(i), i);
        }
        for (i = 0; i < element.getCrossReference().size(); ++i) {
            this.composeIdentifier(t, "MedicinalProduct", "crossReference", element.getCrossReference().get(i), i);
        }
        for (i = 0; i < element.getManufacturingBusinessOperation().size(); ++i) {
            this.composeMedicinalProductMedicinalProductManufacturingBusinessOperationComponent(t, "MedicinalProduct", "manufacturingBusinessOperation", element.getManufacturingBusinessOperation().get(i), i);
        }
        for (i = 0; i < element.getSpecialDesignation().size(); ++i) {
            this.composeMedicinalProductMedicinalProductSpecialDesignationComponent(t, "MedicinalProduct", "specialDesignation", element.getSpecialDesignation().get(i), i);
        }
    }

    protected void composeMedicinalProductMedicinalProductNameComponent(Turtle.Complex parent, String parentType, String name, MedicinalProduct.MedicinalProductNameComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "name", name, element, index);
        if (element.hasProductNameElement()) {
            this.composeString(t, "MedicinalProduct", "productName", element.getProductNameElement(), -1);
        }
        for (i = 0; i < element.getNamePart().size(); ++i) {
            this.composeMedicinalProductMedicinalProductNameNamePartComponent(t, "MedicinalProduct", "namePart", element.getNamePart().get(i), i);
        }
        for (i = 0; i < element.getCountryLanguage().size(); ++i) {
            this.composeMedicinalProductMedicinalProductNameCountryLanguageComponent(t, "MedicinalProduct", "countryLanguage", element.getCountryLanguage().get(i), i);
        }
    }

    protected void composeMedicinalProductMedicinalProductNameNamePartComponent(Turtle.Complex parent, String parentType, String name, MedicinalProduct.MedicinalProductNameNamePartComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "namePart", name, element, index);
        if (element.hasPartElement()) {
            this.composeString(t, "MedicinalProduct", "part", element.getPartElement(), -1);
        }
        if (element.hasType()) {
            this.composeCoding(t, "MedicinalProduct", "type", element.getType(), -1);
        }
    }

    protected void composeMedicinalProductMedicinalProductNameCountryLanguageComponent(Turtle.Complex parent, String parentType, String name, MedicinalProduct.MedicinalProductNameCountryLanguageComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "countryLanguage", name, element, index);
        if (element.hasCountry()) {
            this.composeCodeableConcept(t, "MedicinalProduct", "country", element.getCountry(), -1);
        }
        if (element.hasJurisdiction()) {
            this.composeCodeableConcept(t, "MedicinalProduct", "jurisdiction", element.getJurisdiction(), -1);
        }
        if (element.hasLanguage()) {
            this.composeCodeableConcept(t, "MedicinalProduct", "language", element.getLanguage(), -1);
        }
    }

    protected void composeMedicinalProductMedicinalProductManufacturingBusinessOperationComponent(Turtle.Complex parent, String parentType, String name, MedicinalProduct.MedicinalProductManufacturingBusinessOperationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "manufacturingBusinessOperation", name, element, index);
        if (element.hasOperationType()) {
            this.composeCodeableConcept(t, "MedicinalProduct", "operationType", element.getOperationType(), -1);
        }
        if (element.hasAuthorisationReferenceNumber()) {
            this.composeIdentifier(t, "MedicinalProduct", "authorisationReferenceNumber", element.getAuthorisationReferenceNumber(), -1);
        }
        if (element.hasEffectiveDateElement()) {
            this.composeDateTime(t, "MedicinalProduct", "effectiveDate", element.getEffectiveDateElement(), -1);
        }
        if (element.hasConfidentialityIndicator()) {
            this.composeCodeableConcept(t, "MedicinalProduct", "confidentialityIndicator", element.getConfidentialityIndicator(), -1);
        }
        for (int i = 0; i < element.getManufacturer().size(); ++i) {
            this.composeReference(t, "MedicinalProduct", "manufacturer", element.getManufacturer().get(i), i);
        }
        if (element.hasRegulator()) {
            this.composeReference(t, "MedicinalProduct", "regulator", element.getRegulator(), -1);
        }
    }

    protected void composeMedicinalProductMedicinalProductSpecialDesignationComponent(Turtle.Complex parent, String parentType, String name, MedicinalProduct.MedicinalProductSpecialDesignationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "specialDesignation", name, element, index);
        for (int i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "MedicinalProduct", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "MedicinalProduct", "type", element.getType(), -1);
        }
        if (element.hasIntendedUse()) {
            this.composeCodeableConcept(t, "MedicinalProduct", "intendedUse", element.getIntendedUse(), -1);
        }
        if (element.hasIndication()) {
            this.composeType(t, "MedicinalProduct", "indication", element.getIndication(), -1);
        }
        if (element.hasStatus()) {
            this.composeCodeableConcept(t, "MedicinalProduct", "status", element.getStatus(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "MedicinalProduct", "date", element.getDateElement(), -1);
        }
        if (element.hasSpecies()) {
            this.composeCodeableConcept(t, "MedicinalProduct", "species", element.getSpecies(), -1);
        }
    }

    protected void composeMedicinalProductAuthorization(Turtle.Complex parent, String parentType, String name, MedicinalProductAuthorization element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "MedicinalProductAuthorization", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "MedicinalProductAuthorization", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "MedicinalProductAuthorization", "subject", element.getSubject(), -1);
        }
        for (i = 0; i < element.getCountry().size(); ++i) {
            this.composeCodeableConcept(t, "MedicinalProductAuthorization", "country", element.getCountry().get(i), i);
        }
        for (i = 0; i < element.getJurisdiction().size(); ++i) {
            this.composeCodeableConcept(t, "MedicinalProductAuthorization", "jurisdiction", element.getJurisdiction().get(i), i);
        }
        if (element.hasStatus()) {
            this.composeCodeableConcept(t, "MedicinalProductAuthorization", "status", element.getStatus(), -1);
        }
        if (element.hasStatusDateElement()) {
            this.composeDateTime(t, "MedicinalProductAuthorization", "statusDate", element.getStatusDateElement(), -1);
        }
        if (element.hasRestoreDateElement()) {
            this.composeDateTime(t, "MedicinalProductAuthorization", "restoreDate", element.getRestoreDateElement(), -1);
        }
        if (element.hasValidityPeriod()) {
            this.composePeriod(t, "MedicinalProductAuthorization", "validityPeriod", element.getValidityPeriod(), -1);
        }
        if (element.hasDataExclusivityPeriod()) {
            this.composePeriod(t, "MedicinalProductAuthorization", "dataExclusivityPeriod", element.getDataExclusivityPeriod(), -1);
        }
        if (element.hasDateOfFirstAuthorizationElement()) {
            this.composeDateTime(t, "MedicinalProductAuthorization", "dateOfFirstAuthorization", element.getDateOfFirstAuthorizationElement(), -1);
        }
        if (element.hasInternationalBirthDateElement()) {
            this.composeDateTime(t, "MedicinalProductAuthorization", "internationalBirthDate", element.getInternationalBirthDateElement(), -1);
        }
        if (element.hasLegalBasis()) {
            this.composeCodeableConcept(t, "MedicinalProductAuthorization", "legalBasis", element.getLegalBasis(), -1);
        }
        for (i = 0; i < element.getJurisdictionalAuthorization().size(); ++i) {
            this.composeMedicinalProductAuthorizationMedicinalProductAuthorizationJurisdictionalAuthorizationComponent(t, "MedicinalProductAuthorization", "jurisdictionalAuthorization", element.getJurisdictionalAuthorization().get(i), i);
        }
        if (element.hasHolder()) {
            this.composeReference(t, "MedicinalProductAuthorization", "holder", element.getHolder(), -1);
        }
        if (element.hasRegulator()) {
            this.composeReference(t, "MedicinalProductAuthorization", "regulator", element.getRegulator(), -1);
        }
        if (element.hasProcedure()) {
            this.composeMedicinalProductAuthorizationMedicinalProductAuthorizationProcedureComponent(t, "MedicinalProductAuthorization", "procedure", element.getProcedure(), -1);
        }
    }

    protected void composeMedicinalProductAuthorizationMedicinalProductAuthorizationJurisdictionalAuthorizationComponent(Turtle.Complex parent, String parentType, String name, MedicinalProductAuthorization.MedicinalProductAuthorizationJurisdictionalAuthorizationComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "jurisdictionalAuthorization", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "MedicinalProductAuthorization", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasCountry()) {
            this.composeCodeableConcept(t, "MedicinalProductAuthorization", "country", element.getCountry(), -1);
        }
        for (i = 0; i < element.getJurisdiction().size(); ++i) {
            this.composeCodeableConcept(t, "MedicinalProductAuthorization", "jurisdiction", element.getJurisdiction().get(i), i);
        }
        if (element.hasLegalStatusOfSupply()) {
            this.composeCodeableConcept(t, "MedicinalProductAuthorization", "legalStatusOfSupply", element.getLegalStatusOfSupply(), -1);
        }
        if (element.hasValidityPeriod()) {
            this.composePeriod(t, "MedicinalProductAuthorization", "validityPeriod", element.getValidityPeriod(), -1);
        }
    }

    protected void composeMedicinalProductAuthorizationMedicinalProductAuthorizationProcedureComponent(Turtle.Complex parent, String parentType, String name, MedicinalProductAuthorization.MedicinalProductAuthorizationProcedureComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "procedure", name, element, index);
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "MedicinalProductAuthorization", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "MedicinalProductAuthorization", "type", element.getType(), -1);
        }
        if (element.hasDate()) {
            this.composeType(t, "MedicinalProductAuthorization", "date", element.getDate(), -1);
        }
        for (int i = 0; i < element.getApplication().size(); ++i) {
            this.composeMedicinalProductAuthorizationMedicinalProductAuthorizationProcedureComponent(t, "MedicinalProductAuthorization", "application", element.getApplication().get(i), i);
        }
    }

    protected void composeMedicinalProductContraindication(Turtle.Complex parent, String parentType, String name, MedicinalProductContraindication element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "MedicinalProductContraindication", name, element, index);
        for (i = 0; i < element.getSubject().size(); ++i) {
            this.composeReference(t, "MedicinalProductContraindication", "subject", element.getSubject().get(i), i);
        }
        if (element.hasDisease()) {
            this.composeCodeableConcept(t, "MedicinalProductContraindication", "disease", element.getDisease(), -1);
        }
        if (element.hasDiseaseStatus()) {
            this.composeCodeableConcept(t, "MedicinalProductContraindication", "diseaseStatus", element.getDiseaseStatus(), -1);
        }
        for (i = 0; i < element.getComorbidity().size(); ++i) {
            this.composeCodeableConcept(t, "MedicinalProductContraindication", "comorbidity", element.getComorbidity().get(i), i);
        }
        for (i = 0; i < element.getTherapeuticIndication().size(); ++i) {
            this.composeReference(t, "MedicinalProductContraindication", "therapeuticIndication", element.getTherapeuticIndication().get(i), i);
        }
        for (i = 0; i < element.getOtherTherapy().size(); ++i) {
            this.composeMedicinalProductContraindicationMedicinalProductContraindicationOtherTherapyComponent(t, "MedicinalProductContraindication", "otherTherapy", element.getOtherTherapy().get(i), i);
        }
        for (i = 0; i < element.getPopulation().size(); ++i) {
            this.composePopulation(t, "MedicinalProductContraindication", "population", element.getPopulation().get(i), i);
        }
    }

    protected void composeMedicinalProductContraindicationMedicinalProductContraindicationOtherTherapyComponent(Turtle.Complex parent, String parentType, String name, MedicinalProductContraindication.MedicinalProductContraindicationOtherTherapyComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "otherTherapy", name, element, index);
        if (element.hasTherapyRelationshipType()) {
            this.composeCodeableConcept(t, "MedicinalProductContraindication", "therapyRelationshipType", element.getTherapyRelationshipType(), -1);
        }
        if (element.hasMedication()) {
            this.composeType(t, "MedicinalProductContraindication", "medication", element.getMedication(), -1);
        }
    }

    protected void composeMedicinalProductIndication(Turtle.Complex parent, String parentType, String name, MedicinalProductIndication element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "MedicinalProductIndication", name, element, index);
        for (i = 0; i < element.getSubject().size(); ++i) {
            this.composeReference(t, "MedicinalProductIndication", "subject", element.getSubject().get(i), i);
        }
        if (element.hasDiseaseSymptomProcedure()) {
            this.composeCodeableConcept(t, "MedicinalProductIndication", "diseaseSymptomProcedure", element.getDiseaseSymptomProcedure(), -1);
        }
        if (element.hasDiseaseStatus()) {
            this.composeCodeableConcept(t, "MedicinalProductIndication", "diseaseStatus", element.getDiseaseStatus(), -1);
        }
        for (i = 0; i < element.getComorbidity().size(); ++i) {
            this.composeCodeableConcept(t, "MedicinalProductIndication", "comorbidity", element.getComorbidity().get(i), i);
        }
        if (element.hasIntendedEffect()) {
            this.composeCodeableConcept(t, "MedicinalProductIndication", "intendedEffect", element.getIntendedEffect(), -1);
        }
        if (element.hasDuration()) {
            this.composeQuantity(t, "MedicinalProductIndication", "duration", element.getDuration(), -1);
        }
        for (i = 0; i < element.getOtherTherapy().size(); ++i) {
            this.composeMedicinalProductIndicationMedicinalProductIndicationOtherTherapyComponent(t, "MedicinalProductIndication", "otherTherapy", element.getOtherTherapy().get(i), i);
        }
        for (i = 0; i < element.getUndesirableEffect().size(); ++i) {
            this.composeReference(t, "MedicinalProductIndication", "undesirableEffect", element.getUndesirableEffect().get(i), i);
        }
        for (i = 0; i < element.getPopulation().size(); ++i) {
            this.composePopulation(t, "MedicinalProductIndication", "population", element.getPopulation().get(i), i);
        }
    }

    protected void composeMedicinalProductIndicationMedicinalProductIndicationOtherTherapyComponent(Turtle.Complex parent, String parentType, String name, MedicinalProductIndication.MedicinalProductIndicationOtherTherapyComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "otherTherapy", name, element, index);
        if (element.hasTherapyRelationshipType()) {
            this.composeCodeableConcept(t, "MedicinalProductIndication", "therapyRelationshipType", element.getTherapyRelationshipType(), -1);
        }
        if (element.hasMedication()) {
            this.composeType(t, "MedicinalProductIndication", "medication", element.getMedication(), -1);
        }
    }

    protected void composeMedicinalProductIngredient(Turtle.Complex parent, String parentType, String name, MedicinalProductIngredient element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "MedicinalProductIngredient", name, element, index);
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "MedicinalProductIngredient", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasRole()) {
            this.composeCodeableConcept(t, "MedicinalProductIngredient", "role", element.getRole(), -1);
        }
        if (element.hasAllergenicIndicatorElement()) {
            this.composeBoolean(t, "MedicinalProductIngredient", "allergenicIndicator", element.getAllergenicIndicatorElement(), -1);
        }
        for (i = 0; i < element.getManufacturer().size(); ++i) {
            this.composeReference(t, "MedicinalProductIngredient", "manufacturer", element.getManufacturer().get(i), i);
        }
        for (i = 0; i < element.getSpecifiedSubstance().size(); ++i) {
            this.composeMedicinalProductIngredientMedicinalProductIngredientSpecifiedSubstanceComponent(t, "MedicinalProductIngredient", "specifiedSubstance", element.getSpecifiedSubstance().get(i), i);
        }
        if (element.hasSubstance()) {
            this.composeMedicinalProductIngredientMedicinalProductIngredientSubstanceComponent(t, "MedicinalProductIngredient", "substance", element.getSubstance(), -1);
        }
    }

    protected void composeMedicinalProductIngredientMedicinalProductIngredientSpecifiedSubstanceComponent(Turtle.Complex parent, String parentType, String name, MedicinalProductIngredient.MedicinalProductIngredientSpecifiedSubstanceComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "specifiedSubstance", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "MedicinalProductIngredient", "code", element.getCode(), -1);
        }
        if (element.hasGroup()) {
            this.composeCodeableConcept(t, "MedicinalProductIngredient", "group", element.getGroup(), -1);
        }
        if (element.hasConfidentiality()) {
            this.composeCodeableConcept(t, "MedicinalProductIngredient", "confidentiality", element.getConfidentiality(), -1);
        }
        for (int i = 0; i < element.getStrength().size(); ++i) {
            this.composeMedicinalProductIngredientMedicinalProductIngredientSpecifiedSubstanceStrengthComponent(t, "MedicinalProductIngredient", "strength", element.getStrength().get(i), i);
        }
    }

    protected void composeMedicinalProductIngredientMedicinalProductIngredientSpecifiedSubstanceStrengthComponent(Turtle.Complex parent, String parentType, String name, MedicinalProductIngredient.MedicinalProductIngredientSpecifiedSubstanceStrengthComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "strength", name, element, index);
        if (element.hasPresentation()) {
            this.composeRatio(t, "MedicinalProductIngredient", "presentation", element.getPresentation(), -1);
        }
        if (element.hasPresentationLowLimit()) {
            this.composeRatio(t, "MedicinalProductIngredient", "presentationLowLimit", element.getPresentationLowLimit(), -1);
        }
        if (element.hasConcentration()) {
            this.composeRatio(t, "MedicinalProductIngredient", "concentration", element.getConcentration(), -1);
        }
        if (element.hasConcentrationLowLimit()) {
            this.composeRatio(t, "MedicinalProductIngredient", "concentrationLowLimit", element.getConcentrationLowLimit(), -1);
        }
        if (element.hasMeasurementPointElement()) {
            this.composeString(t, "MedicinalProductIngredient", "measurementPoint", element.getMeasurementPointElement(), -1);
        }
        for (i = 0; i < element.getCountry().size(); ++i) {
            this.composeCodeableConcept(t, "MedicinalProductIngredient", "country", element.getCountry().get(i), i);
        }
        for (i = 0; i < element.getReferenceStrength().size(); ++i) {
            this.composeMedicinalProductIngredientMedicinalProductIngredientSpecifiedSubstanceStrengthReferenceStrengthComponent(t, "MedicinalProductIngredient", "referenceStrength", element.getReferenceStrength().get(i), i);
        }
    }

    protected void composeMedicinalProductIngredientMedicinalProductIngredientSpecifiedSubstanceStrengthReferenceStrengthComponent(Turtle.Complex parent, String parentType, String name, MedicinalProductIngredient.MedicinalProductIngredientSpecifiedSubstanceStrengthReferenceStrengthComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "referenceStrength", name, element, index);
        if (element.hasSubstance()) {
            this.composeCodeableConcept(t, "MedicinalProductIngredient", "substance", element.getSubstance(), -1);
        }
        if (element.hasStrength()) {
            this.composeRatio(t, "MedicinalProductIngredient", "strength", element.getStrength(), -1);
        }
        if (element.hasStrengthLowLimit()) {
            this.composeRatio(t, "MedicinalProductIngredient", "strengthLowLimit", element.getStrengthLowLimit(), -1);
        }
        if (element.hasMeasurementPointElement()) {
            this.composeString(t, "MedicinalProductIngredient", "measurementPoint", element.getMeasurementPointElement(), -1);
        }
        for (int i = 0; i < element.getCountry().size(); ++i) {
            this.composeCodeableConcept(t, "MedicinalProductIngredient", "country", element.getCountry().get(i), i);
        }
    }

    protected void composeMedicinalProductIngredientMedicinalProductIngredientSubstanceComponent(Turtle.Complex parent, String parentType, String name, MedicinalProductIngredient.MedicinalProductIngredientSubstanceComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "substance", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "MedicinalProductIngredient", "code", element.getCode(), -1);
        }
        for (int i = 0; i < element.getStrength().size(); ++i) {
            this.composeMedicinalProductIngredientMedicinalProductIngredientSpecifiedSubstanceStrengthComponent(t, "MedicinalProductIngredient", "strength", element.getStrength().get(i), i);
        }
    }

    protected void composeMedicinalProductInteraction(Turtle.Complex parent, String parentType, String name, MedicinalProductInteraction element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "MedicinalProductInteraction", name, element, index);
        for (i = 0; i < element.getSubject().size(); ++i) {
            this.composeReference(t, "MedicinalProductInteraction", "subject", element.getSubject().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "MedicinalProductInteraction", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getInteractant().size(); ++i) {
            this.composeMedicinalProductInteractionMedicinalProductInteractionInteractantComponent(t, "MedicinalProductInteraction", "interactant", element.getInteractant().get(i), i);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "MedicinalProductInteraction", "type", element.getType(), -1);
        }
        if (element.hasEffect()) {
            this.composeCodeableConcept(t, "MedicinalProductInteraction", "effect", element.getEffect(), -1);
        }
        if (element.hasIncidence()) {
            this.composeCodeableConcept(t, "MedicinalProductInteraction", "incidence", element.getIncidence(), -1);
        }
        if (element.hasManagement()) {
            this.composeCodeableConcept(t, "MedicinalProductInteraction", "management", element.getManagement(), -1);
        }
    }

    protected void composeMedicinalProductInteractionMedicinalProductInteractionInteractantComponent(Turtle.Complex parent, String parentType, String name, MedicinalProductInteraction.MedicinalProductInteractionInteractantComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "interactant", name, element, index);
        if (element.hasItem()) {
            this.composeType(t, "MedicinalProductInteraction", "item", element.getItem(), -1);
        }
    }

    protected void composeMedicinalProductManufactured(Turtle.Complex parent, String parentType, String name, MedicinalProductManufactured element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "MedicinalProductManufactured", name, element, index);
        if (element.hasManufacturedDoseForm()) {
            this.composeCodeableConcept(t, "MedicinalProductManufactured", "manufacturedDoseForm", element.getManufacturedDoseForm(), -1);
        }
        if (element.hasUnitOfPresentation()) {
            this.composeCodeableConcept(t, "MedicinalProductManufactured", "unitOfPresentation", element.getUnitOfPresentation(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "MedicinalProductManufactured", "quantity", element.getQuantity(), -1);
        }
        for (i = 0; i < element.getManufacturer().size(); ++i) {
            this.composeReference(t, "MedicinalProductManufactured", "manufacturer", element.getManufacturer().get(i), i);
        }
        for (i = 0; i < element.getIngredient().size(); ++i) {
            this.composeReference(t, "MedicinalProductManufactured", "ingredient", element.getIngredient().get(i), i);
        }
        if (element.hasPhysicalCharacteristics()) {
            this.composeProdCharacteristic(t, "MedicinalProductManufactured", "physicalCharacteristics", element.getPhysicalCharacteristics(), -1);
        }
        for (i = 0; i < element.getOtherCharacteristics().size(); ++i) {
            this.composeCodeableConcept(t, "MedicinalProductManufactured", "otherCharacteristics", element.getOtherCharacteristics().get(i), i);
        }
    }

    protected void composeMedicinalProductPackaged(Turtle.Complex parent, String parentType, String name, MedicinalProductPackaged element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "MedicinalProductPackaged", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "MedicinalProductPackaged", "identifier", element.getIdentifier().get(i), i);
        }
        for (i = 0; i < element.getSubject().size(); ++i) {
            this.composeReference(t, "MedicinalProductPackaged", "subject", element.getSubject().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "MedicinalProductPackaged", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasLegalStatusOfSupply()) {
            this.composeCodeableConcept(t, "MedicinalProductPackaged", "legalStatusOfSupply", element.getLegalStatusOfSupply(), -1);
        }
        for (i = 0; i < element.getMarketingStatus().size(); ++i) {
            this.composeMarketingStatus(t, "MedicinalProductPackaged", "marketingStatus", element.getMarketingStatus().get(i), i);
        }
        if (element.hasMarketingAuthorization()) {
            this.composeReference(t, "MedicinalProductPackaged", "marketingAuthorization", element.getMarketingAuthorization(), -1);
        }
        for (i = 0; i < element.getManufacturer().size(); ++i) {
            this.composeReference(t, "MedicinalProductPackaged", "manufacturer", element.getManufacturer().get(i), i);
        }
        for (i = 0; i < element.getBatchIdentifier().size(); ++i) {
            this.composeMedicinalProductPackagedMedicinalProductPackagedBatchIdentifierComponent(t, "MedicinalProductPackaged", "batchIdentifier", element.getBatchIdentifier().get(i), i);
        }
        for (i = 0; i < element.getPackageItem().size(); ++i) {
            this.composeMedicinalProductPackagedMedicinalProductPackagedPackageItemComponent(t, "MedicinalProductPackaged", "packageItem", element.getPackageItem().get(i), i);
        }
    }

    protected void composeMedicinalProductPackagedMedicinalProductPackagedBatchIdentifierComponent(Turtle.Complex parent, String parentType, String name, MedicinalProductPackaged.MedicinalProductPackagedBatchIdentifierComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "batchIdentifier", name, element, index);
        if (element.hasOuterPackaging()) {
            this.composeIdentifier(t, "MedicinalProductPackaged", "outerPackaging", element.getOuterPackaging(), -1);
        }
        if (element.hasImmediatePackaging()) {
            this.composeIdentifier(t, "MedicinalProductPackaged", "immediatePackaging", element.getImmediatePackaging(), -1);
        }
    }

    protected void composeMedicinalProductPackagedMedicinalProductPackagedPackageItemComponent(Turtle.Complex parent, String parentType, String name, MedicinalProductPackaged.MedicinalProductPackagedPackageItemComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "packageItem", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "MedicinalProductPackaged", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "MedicinalProductPackaged", "type", element.getType(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "MedicinalProductPackaged", "quantity", element.getQuantity(), -1);
        }
        for (i = 0; i < element.getMaterial().size(); ++i) {
            this.composeCodeableConcept(t, "MedicinalProductPackaged", "material", element.getMaterial().get(i), i);
        }
        for (i = 0; i < element.getAlternateMaterial().size(); ++i) {
            this.composeCodeableConcept(t, "MedicinalProductPackaged", "alternateMaterial", element.getAlternateMaterial().get(i), i);
        }
        for (i = 0; i < element.getDevice().size(); ++i) {
            this.composeReference(t, "MedicinalProductPackaged", "device", element.getDevice().get(i), i);
        }
        for (i = 0; i < element.getManufacturedItem().size(); ++i) {
            this.composeReference(t, "MedicinalProductPackaged", "manufacturedItem", element.getManufacturedItem().get(i), i);
        }
        for (i = 0; i < element.getPackageItem().size(); ++i) {
            this.composeMedicinalProductPackagedMedicinalProductPackagedPackageItemComponent(t, "MedicinalProductPackaged", "packageItem", element.getPackageItem().get(i), i);
        }
        if (element.hasPhysicalCharacteristics()) {
            this.composeProdCharacteristic(t, "MedicinalProductPackaged", "physicalCharacteristics", element.getPhysicalCharacteristics(), -1);
        }
        for (i = 0; i < element.getOtherCharacteristics().size(); ++i) {
            this.composeCodeableConcept(t, "MedicinalProductPackaged", "otherCharacteristics", element.getOtherCharacteristics().get(i), i);
        }
        for (i = 0; i < element.getShelfLifeStorage().size(); ++i) {
            this.composeProductShelfLife(t, "MedicinalProductPackaged", "shelfLifeStorage", element.getShelfLifeStorage().get(i), i);
        }
        for (i = 0; i < element.getManufacturer().size(); ++i) {
            this.composeReference(t, "MedicinalProductPackaged", "manufacturer", element.getManufacturer().get(i), i);
        }
    }

    protected void composeMedicinalProductPharmaceutical(Turtle.Complex parent, String parentType, String name, MedicinalProductPharmaceutical element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "MedicinalProductPharmaceutical", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "MedicinalProductPharmaceutical", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasAdministrableDoseForm()) {
            this.composeCodeableConcept(t, "MedicinalProductPharmaceutical", "administrableDoseForm", element.getAdministrableDoseForm(), -1);
        }
        if (element.hasUnitOfPresentation()) {
            this.composeCodeableConcept(t, "MedicinalProductPharmaceutical", "unitOfPresentation", element.getUnitOfPresentation(), -1);
        }
        for (i = 0; i < element.getIngredient().size(); ++i) {
            this.composeReference(t, "MedicinalProductPharmaceutical", "ingredient", element.getIngredient().get(i), i);
        }
        for (i = 0; i < element.getDevice().size(); ++i) {
            this.composeReference(t, "MedicinalProductPharmaceutical", "device", element.getDevice().get(i), i);
        }
        for (i = 0; i < element.getCharacteristics().size(); ++i) {
            this.composeMedicinalProductPharmaceuticalMedicinalProductPharmaceuticalCharacteristicsComponent(t, "MedicinalProductPharmaceutical", "characteristics", element.getCharacteristics().get(i), i);
        }
        for (i = 0; i < element.getRouteOfAdministration().size(); ++i) {
            this.composeMedicinalProductPharmaceuticalMedicinalProductPharmaceuticalRouteOfAdministrationComponent(t, "MedicinalProductPharmaceutical", "routeOfAdministration", element.getRouteOfAdministration().get(i), i);
        }
    }

    protected void composeMedicinalProductPharmaceuticalMedicinalProductPharmaceuticalCharacteristicsComponent(Turtle.Complex parent, String parentType, String name, MedicinalProductPharmaceutical.MedicinalProductPharmaceuticalCharacteristicsComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "characteristics", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "MedicinalProductPharmaceutical", "code", element.getCode(), -1);
        }
        if (element.hasStatus()) {
            this.composeCodeableConcept(t, "MedicinalProductPharmaceutical", "status", element.getStatus(), -1);
        }
    }

    protected void composeMedicinalProductPharmaceuticalMedicinalProductPharmaceuticalRouteOfAdministrationComponent(Turtle.Complex parent, String parentType, String name, MedicinalProductPharmaceutical.MedicinalProductPharmaceuticalRouteOfAdministrationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "routeOfAdministration", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "MedicinalProductPharmaceutical", "code", element.getCode(), -1);
        }
        if (element.hasFirstDose()) {
            this.composeQuantity(t, "MedicinalProductPharmaceutical", "firstDose", element.getFirstDose(), -1);
        }
        if (element.hasMaxSingleDose()) {
            this.composeQuantity(t, "MedicinalProductPharmaceutical", "maxSingleDose", element.getMaxSingleDose(), -1);
        }
        if (element.hasMaxDosePerDay()) {
            this.composeQuantity(t, "MedicinalProductPharmaceutical", "maxDosePerDay", element.getMaxDosePerDay(), -1);
        }
        if (element.hasMaxDosePerTreatmentPeriod()) {
            this.composeRatio(t, "MedicinalProductPharmaceutical", "maxDosePerTreatmentPeriod", element.getMaxDosePerTreatmentPeriod(), -1);
        }
        if (element.hasMaxTreatmentPeriod()) {
            this.composeDuration(t, "MedicinalProductPharmaceutical", "maxTreatmentPeriod", element.getMaxTreatmentPeriod(), -1);
        }
        for (int i = 0; i < element.getTargetSpecies().size(); ++i) {
            this.composeMedicinalProductPharmaceuticalMedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesComponent(t, "MedicinalProductPharmaceutical", "targetSpecies", element.getTargetSpecies().get(i), i);
        }
    }

    protected void composeMedicinalProductPharmaceuticalMedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesComponent(Turtle.Complex parent, String parentType, String name, MedicinalProductPharmaceutical.MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "targetSpecies", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "MedicinalProductPharmaceutical", "code", element.getCode(), -1);
        }
        for (int i = 0; i < element.getWithdrawalPeriod().size(); ++i) {
            this.composeMedicinalProductPharmaceuticalMedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent(t, "MedicinalProductPharmaceutical", "withdrawalPeriod", element.getWithdrawalPeriod().get(i), i);
        }
    }

    protected void composeMedicinalProductPharmaceuticalMedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent(Turtle.Complex parent, String parentType, String name, MedicinalProductPharmaceutical.MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "withdrawalPeriod", name, element, index);
        if (element.hasTissue()) {
            this.composeCodeableConcept(t, "MedicinalProductPharmaceutical", "tissue", element.getTissue(), -1);
        }
        if (element.hasValue()) {
            this.composeQuantity(t, "MedicinalProductPharmaceutical", "value", element.getValue(), -1);
        }
        if (element.hasSupportingInformationElement()) {
            this.composeString(t, "MedicinalProductPharmaceutical", "supportingInformation", element.getSupportingInformationElement(), -1);
        }
    }

    protected void composeMedicinalProductUndesirableEffect(Turtle.Complex parent, String parentType, String name, MedicinalProductUndesirableEffect element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "MedicinalProductUndesirableEffect", name, element, index);
        for (i = 0; i < element.getSubject().size(); ++i) {
            this.composeReference(t, "MedicinalProductUndesirableEffect", "subject", element.getSubject().get(i), i);
        }
        if (element.hasSymptomConditionEffect()) {
            this.composeCodeableConcept(t, "MedicinalProductUndesirableEffect", "symptomConditionEffect", element.getSymptomConditionEffect(), -1);
        }
        if (element.hasClassification()) {
            this.composeCodeableConcept(t, "MedicinalProductUndesirableEffect", "classification", element.getClassification(), -1);
        }
        if (element.hasFrequencyOfOccurrence()) {
            this.composeCodeableConcept(t, "MedicinalProductUndesirableEffect", "frequencyOfOccurrence", element.getFrequencyOfOccurrence(), -1);
        }
        for (i = 0; i < element.getPopulation().size(); ++i) {
            this.composePopulation(t, "MedicinalProductUndesirableEffect", "population", element.getPopulation().get(i), i);
        }
    }

    protected void composeMessageDefinition(Turtle.Complex parent, String parentType, String name, MessageDefinition element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "MessageDefinition", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "MessageDefinition", "url", element.getUrlElement(), -1);
        }
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "MessageDefinition", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "MessageDefinition", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "MessageDefinition", "name", element.getNameElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "MessageDefinition", "title", element.getTitleElement(), -1);
        }
        for (i = 0; i < element.getReplaces().size(); ++i) {
            this.composeCanonical(t, "MessageDefinition", "replaces", element.getReplaces().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "MessageDefinition", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "MessageDefinition", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "MessageDefinition", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "MessageDefinition", "publisher", element.getPublisherElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeContactDetail(t, "MessageDefinition", "contact", element.getContact().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "MessageDefinition", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getUseContext().size(); ++i) {
            this.composeUsageContext(t, "MessageDefinition", "useContext", element.getUseContext().get(i), i);
        }
        for (i = 0; i < element.getJurisdiction().size(); ++i) {
            this.composeCodeableConcept(t, "MessageDefinition", "jurisdiction", element.getJurisdiction().get(i), i);
        }
        if (element.hasPurposeElement()) {
            this.composeMarkdown(t, "MessageDefinition", "purpose", element.getPurposeElement(), -1);
        }
        if (element.hasCopyrightElement()) {
            this.composeMarkdown(t, "MessageDefinition", "copyright", element.getCopyrightElement(), -1);
        }
        if (element.hasBaseElement()) {
            this.composeCanonical(t, "MessageDefinition", "base", element.getBaseElement(), -1);
        }
        for (i = 0; i < element.getParent().size(); ++i) {
            this.composeCanonical(t, "MessageDefinition", "parent", element.getParent().get(i), i);
        }
        if (element.hasEvent()) {
            this.composeType(t, "MessageDefinition", "event", element.getEvent(), -1);
        }
        if (element.hasCategoryElement()) {
            this.composeEnum(t, "MessageDefinition", "category", element.getCategoryElement(), -1);
        }
        for (i = 0; i < element.getFocus().size(); ++i) {
            this.composeMessageDefinitionMessageDefinitionFocusComponent(t, "MessageDefinition", "focus", element.getFocus().get(i), i);
        }
        if (element.hasResponseRequiredElement()) {
            this.composeEnum(t, "MessageDefinition", "responseRequired", element.getResponseRequiredElement(), -1);
        }
        for (i = 0; i < element.getAllowedResponse().size(); ++i) {
            this.composeMessageDefinitionMessageDefinitionAllowedResponseComponent(t, "MessageDefinition", "allowedResponse", element.getAllowedResponse().get(i), i);
        }
        for (i = 0; i < element.getGraph().size(); ++i) {
            this.composeCanonical(t, "MessageDefinition", "graph", element.getGraph().get(i), i);
        }
    }

    protected void composeMessageDefinitionMessageDefinitionFocusComponent(Turtle.Complex parent, String parentType, String name, MessageDefinition.MessageDefinitionFocusComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "focus", name, element, index);
        if (element.hasCodeElement()) {
            this.composeCode(t, "MessageDefinition", "code", element.getCodeElement(), -1);
        }
        if (element.hasProfileElement()) {
            this.composeCanonical(t, "MessageDefinition", "profile", element.getProfileElement(), -1);
        }
        if (element.hasMinElement()) {
            this.composeUnsignedInt(t, "MessageDefinition", "min", element.getMinElement(), -1);
        }
        if (element.hasMaxElement()) {
            this.composeString(t, "MessageDefinition", "max", element.getMaxElement(), -1);
        }
    }

    protected void composeMessageDefinitionMessageDefinitionAllowedResponseComponent(Turtle.Complex parent, String parentType, String name, MessageDefinition.MessageDefinitionAllowedResponseComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "allowedResponse", name, element, index);
        if (element.hasMessageElement()) {
            this.composeCanonical(t, "MessageDefinition", "message", element.getMessageElement(), -1);
        }
        if (element.hasSituationElement()) {
            this.composeMarkdown(t, "MessageDefinition", "situation", element.getSituationElement(), -1);
        }
    }

    protected void composeMessageHeader(Turtle.Complex parent, String parentType, String name, MessageHeader element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "MessageHeader", name, element, index);
        if (element.hasEvent()) {
            this.composeType(t, "MessageHeader", "event", element.getEvent(), -1);
        }
        for (i = 0; i < element.getDestination().size(); ++i) {
            this.composeMessageHeaderMessageDestinationComponent(t, "MessageHeader", "destination", element.getDestination().get(i), i);
        }
        if (element.hasSender()) {
            this.composeReference(t, "MessageHeader", "sender", element.getSender(), -1);
        }
        if (element.hasEnterer()) {
            this.composeReference(t, "MessageHeader", "enterer", element.getEnterer(), -1);
        }
        if (element.hasAuthor()) {
            this.composeReference(t, "MessageHeader", "author", element.getAuthor(), -1);
        }
        if (element.hasSource()) {
            this.composeMessageHeaderMessageSourceComponent(t, "MessageHeader", "source", element.getSource(), -1);
        }
        if (element.hasResponsible()) {
            this.composeReference(t, "MessageHeader", "responsible", element.getResponsible(), -1);
        }
        if (element.hasReason()) {
            this.composeCodeableConcept(t, "MessageHeader", "reason", element.getReason(), -1);
        }
        if (element.hasResponse()) {
            this.composeMessageHeaderMessageHeaderResponseComponent(t, "MessageHeader", "response", element.getResponse(), -1);
        }
        for (i = 0; i < element.getFocus().size(); ++i) {
            this.composeReference(t, "MessageHeader", "focus", element.getFocus().get(i), i);
        }
        if (element.hasDefinitionElement()) {
            this.composeCanonical(t, "MessageHeader", "definition", element.getDefinitionElement(), -1);
        }
    }

    protected void composeMessageHeaderMessageDestinationComponent(Turtle.Complex parent, String parentType, String name, MessageHeader.MessageDestinationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "destination", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "MessageHeader", "name", element.getNameElement(), -1);
        }
        if (element.hasTarget()) {
            this.composeReference(t, "MessageHeader", "target", element.getTarget(), -1);
        }
        if (element.hasEndpointElement()) {
            this.composeUrl(t, "MessageHeader", "endpoint", element.getEndpointElement(), -1);
        }
        if (element.hasReceiver()) {
            this.composeReference(t, "MessageHeader", "receiver", element.getReceiver(), -1);
        }
    }

    protected void composeMessageHeaderMessageSourceComponent(Turtle.Complex parent, String parentType, String name, MessageHeader.MessageSourceComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "source", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "MessageHeader", "name", element.getNameElement(), -1);
        }
        if (element.hasSoftwareElement()) {
            this.composeString(t, "MessageHeader", "software", element.getSoftwareElement(), -1);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "MessageHeader", "version", element.getVersionElement(), -1);
        }
        if (element.hasContact()) {
            this.composeContactPoint(t, "MessageHeader", "contact", element.getContact(), -1);
        }
        if (element.hasEndpointElement()) {
            this.composeUrl(t, "MessageHeader", "endpoint", element.getEndpointElement(), -1);
        }
    }

    protected void composeMessageHeaderMessageHeaderResponseComponent(Turtle.Complex parent, String parentType, String name, MessageHeader.MessageHeaderResponseComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "response", name, element, index);
        if (element.hasIdentifierElement()) {
            this.composeId(t, "MessageHeader", "identifier", element.getIdentifierElement(), -1);
        }
        if (element.hasCodeElement()) {
            this.composeEnum(t, "MessageHeader", "code", element.getCodeElement(), -1);
        }
        if (element.hasDetails()) {
            this.composeReference(t, "MessageHeader", "details", element.getDetails(), -1);
        }
    }

    protected void composeMolecularSequence(Turtle.Complex parent, String parentType, String name, MolecularSequence element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "MolecularSequence", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "MolecularSequence", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasTypeElement()) {
            this.composeEnum(t, "MolecularSequence", "type", element.getTypeElement(), -1);
        }
        if (element.hasCoordinateSystemElement()) {
            this.composeInteger(t, "MolecularSequence", "coordinateSystem", element.getCoordinateSystemElement(), -1);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "MolecularSequence", "patient", element.getPatient(), -1);
        }
        if (element.hasSpecimen()) {
            this.composeReference(t, "MolecularSequence", "specimen", element.getSpecimen(), -1);
        }
        if (element.hasDevice()) {
            this.composeReference(t, "MolecularSequence", "device", element.getDevice(), -1);
        }
        if (element.hasPerformer()) {
            this.composeReference(t, "MolecularSequence", "performer", element.getPerformer(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "MolecularSequence", "quantity", element.getQuantity(), -1);
        }
        if (element.hasReferenceSeq()) {
            this.composeMolecularSequenceMolecularSequenceReferenceSeqComponent(t, "MolecularSequence", "referenceSeq", element.getReferenceSeq(), -1);
        }
        for (i = 0; i < element.getVariant().size(); ++i) {
            this.composeMolecularSequenceMolecularSequenceVariantComponent(t, "MolecularSequence", "variant", element.getVariant().get(i), i);
        }
        if (element.hasObservedSeqElement()) {
            this.composeString(t, "MolecularSequence", "observedSeq", element.getObservedSeqElement(), -1);
        }
        for (i = 0; i < element.getQuality().size(); ++i) {
            this.composeMolecularSequenceMolecularSequenceQualityComponent(t, "MolecularSequence", "quality", element.getQuality().get(i), i);
        }
        if (element.hasReadCoverageElement()) {
            this.composeInteger(t, "MolecularSequence", "readCoverage", element.getReadCoverageElement(), -1);
        }
        for (i = 0; i < element.getRepository().size(); ++i) {
            this.composeMolecularSequenceMolecularSequenceRepositoryComponent(t, "MolecularSequence", "repository", element.getRepository().get(i), i);
        }
        for (i = 0; i < element.getPointer().size(); ++i) {
            this.composeReference(t, "MolecularSequence", "pointer", element.getPointer().get(i), i);
        }
        for (i = 0; i < element.getStructureVariant().size(); ++i) {
            this.composeMolecularSequenceMolecularSequenceStructureVariantComponent(t, "MolecularSequence", "structureVariant", element.getStructureVariant().get(i), i);
        }
    }

    protected void composeMolecularSequenceMolecularSequenceReferenceSeqComponent(Turtle.Complex parent, String parentType, String name, MolecularSequence.MolecularSequenceReferenceSeqComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "referenceSeq", name, element, index);
        if (element.hasChromosome()) {
            this.composeCodeableConcept(t, "MolecularSequence", "chromosome", element.getChromosome(), -1);
        }
        if (element.hasGenomeBuildElement()) {
            this.composeString(t, "MolecularSequence", "genomeBuild", element.getGenomeBuildElement(), -1);
        }
        if (element.hasOrientationElement()) {
            this.composeEnum(t, "MolecularSequence", "orientation", element.getOrientationElement(), -1);
        }
        if (element.hasReferenceSeqId()) {
            this.composeCodeableConcept(t, "MolecularSequence", "referenceSeqId", element.getReferenceSeqId(), -1);
        }
        if (element.hasReferenceSeqPointer()) {
            this.composeReference(t, "MolecularSequence", "referenceSeqPointer", element.getReferenceSeqPointer(), -1);
        }
        if (element.hasReferenceSeqStringElement()) {
            this.composeString(t, "MolecularSequence", "referenceSeqString", element.getReferenceSeqStringElement(), -1);
        }
        if (element.hasStrandElement()) {
            this.composeEnum(t, "MolecularSequence", "strand", element.getStrandElement(), -1);
        }
        if (element.hasWindowStartElement()) {
            this.composeInteger(t, "MolecularSequence", "windowStart", element.getWindowStartElement(), -1);
        }
        if (element.hasWindowEndElement()) {
            this.composeInteger(t, "MolecularSequence", "windowEnd", element.getWindowEndElement(), -1);
        }
    }

    protected void composeMolecularSequenceMolecularSequenceVariantComponent(Turtle.Complex parent, String parentType, String name, MolecularSequence.MolecularSequenceVariantComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "variant", name, element, index);
        if (element.hasStartElement()) {
            this.composeInteger(t, "MolecularSequence", "start", element.getStartElement(), -1);
        }
        if (element.hasEndElement()) {
            this.composeInteger(t, "MolecularSequence", "end", element.getEndElement(), -1);
        }
        if (element.hasObservedAlleleElement()) {
            this.composeString(t, "MolecularSequence", "observedAllele", element.getObservedAlleleElement(), -1);
        }
        if (element.hasReferenceAlleleElement()) {
            this.composeString(t, "MolecularSequence", "referenceAllele", element.getReferenceAlleleElement(), -1);
        }
        if (element.hasCigarElement()) {
            this.composeString(t, "MolecularSequence", "cigar", element.getCigarElement(), -1);
        }
        if (element.hasVariantPointer()) {
            this.composeReference(t, "MolecularSequence", "variantPointer", element.getVariantPointer(), -1);
        }
    }

    protected void composeMolecularSequenceMolecularSequenceQualityComponent(Turtle.Complex parent, String parentType, String name, MolecularSequence.MolecularSequenceQualityComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "quality", name, element, index);
        if (element.hasTypeElement()) {
            this.composeEnum(t, "MolecularSequence", "type", element.getTypeElement(), -1);
        }
        if (element.hasStandardSequence()) {
            this.composeCodeableConcept(t, "MolecularSequence", "standardSequence", element.getStandardSequence(), -1);
        }
        if (element.hasStartElement()) {
            this.composeInteger(t, "MolecularSequence", "start", element.getStartElement(), -1);
        }
        if (element.hasEndElement()) {
            this.composeInteger(t, "MolecularSequence", "end", element.getEndElement(), -1);
        }
        if (element.hasScore()) {
            this.composeQuantity(t, "MolecularSequence", "score", element.getScore(), -1);
        }
        if (element.hasMethod()) {
            this.composeCodeableConcept(t, "MolecularSequence", "method", element.getMethod(), -1);
        }
        if (element.hasTruthTPElement()) {
            this.composeDecimal(t, "MolecularSequence", "truthTP", element.getTruthTPElement(), -1);
        }
        if (element.hasQueryTPElement()) {
            this.composeDecimal(t, "MolecularSequence", "queryTP", element.getQueryTPElement(), -1);
        }
        if (element.hasTruthFNElement()) {
            this.composeDecimal(t, "MolecularSequence", "truthFN", element.getTruthFNElement(), -1);
        }
        if (element.hasQueryFPElement()) {
            this.composeDecimal(t, "MolecularSequence", "queryFP", element.getQueryFPElement(), -1);
        }
        if (element.hasGtFPElement()) {
            this.composeDecimal(t, "MolecularSequence", "gtFP", element.getGtFPElement(), -1);
        }
        if (element.hasPrecisionElement()) {
            this.composeDecimal(t, "MolecularSequence", "precision", element.getPrecisionElement(), -1);
        }
        if (element.hasRecallElement()) {
            this.composeDecimal(t, "MolecularSequence", "recall", element.getRecallElement(), -1);
        }
        if (element.hasFScoreElement()) {
            this.composeDecimal(t, "MolecularSequence", "fScore", element.getFScoreElement(), -1);
        }
        if (element.hasRoc()) {
            this.composeMolecularSequenceMolecularSequenceQualityRocComponent(t, "MolecularSequence", "roc", element.getRoc(), -1);
        }
    }

    protected void composeMolecularSequenceMolecularSequenceQualityRocComponent(Turtle.Complex parent, String parentType, String name, MolecularSequence.MolecularSequenceQualityRocComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "roc", name, element, index);
        for (i = 0; i < element.getScore().size(); ++i) {
            this.composeInteger(t, "MolecularSequence", "score", element.getScore().get(i), i);
        }
        for (i = 0; i < element.getNumTP().size(); ++i) {
            this.composeInteger(t, "MolecularSequence", "numTP", element.getNumTP().get(i), i);
        }
        for (i = 0; i < element.getNumFP().size(); ++i) {
            this.composeInteger(t, "MolecularSequence", "numFP", element.getNumFP().get(i), i);
        }
        for (i = 0; i < element.getNumFN().size(); ++i) {
            this.composeInteger(t, "MolecularSequence", "numFN", element.getNumFN().get(i), i);
        }
        for (i = 0; i < element.getPrecision().size(); ++i) {
            this.composeDecimal(t, "MolecularSequence", "precision", element.getPrecision().get(i), i);
        }
        for (i = 0; i < element.getSensitivity().size(); ++i) {
            this.composeDecimal(t, "MolecularSequence", "sensitivity", element.getSensitivity().get(i), i);
        }
        for (i = 0; i < element.getFMeasure().size(); ++i) {
            this.composeDecimal(t, "MolecularSequence", "fMeasure", element.getFMeasure().get(i), i);
        }
    }

    protected void composeMolecularSequenceMolecularSequenceRepositoryComponent(Turtle.Complex parent, String parentType, String name, MolecularSequence.MolecularSequenceRepositoryComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "repository", name, element, index);
        if (element.hasTypeElement()) {
            this.composeEnum(t, "MolecularSequence", "type", element.getTypeElement(), -1);
        }
        if (element.hasUrlElement()) {
            this.composeUri(t, "MolecularSequence", "url", element.getUrlElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "MolecularSequence", "name", element.getNameElement(), -1);
        }
        if (element.hasDatasetIdElement()) {
            this.composeString(t, "MolecularSequence", "datasetId", element.getDatasetIdElement(), -1);
        }
        if (element.hasVariantsetIdElement()) {
            this.composeString(t, "MolecularSequence", "variantsetId", element.getVariantsetIdElement(), -1);
        }
        if (element.hasReadsetIdElement()) {
            this.composeString(t, "MolecularSequence", "readsetId", element.getReadsetIdElement(), -1);
        }
    }

    protected void composeMolecularSequenceMolecularSequenceStructureVariantComponent(Turtle.Complex parent, String parentType, String name, MolecularSequence.MolecularSequenceStructureVariantComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "structureVariant", name, element, index);
        if (element.hasVariantType()) {
            this.composeCodeableConcept(t, "MolecularSequence", "variantType", element.getVariantType(), -1);
        }
        if (element.hasExactElement()) {
            this.composeBoolean(t, "MolecularSequence", "exact", element.getExactElement(), -1);
        }
        if (element.hasLengthElement()) {
            this.composeInteger(t, "MolecularSequence", "length", element.getLengthElement(), -1);
        }
        if (element.hasOuter()) {
            this.composeMolecularSequenceMolecularSequenceStructureVariantOuterComponent(t, "MolecularSequence", "outer", element.getOuter(), -1);
        }
        if (element.hasInner()) {
            this.composeMolecularSequenceMolecularSequenceStructureVariantInnerComponent(t, "MolecularSequence", "inner", element.getInner(), -1);
        }
    }

    protected void composeMolecularSequenceMolecularSequenceStructureVariantOuterComponent(Turtle.Complex parent, String parentType, String name, MolecularSequence.MolecularSequenceStructureVariantOuterComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "outer", name, element, index);
        if (element.hasStartElement()) {
            this.composeInteger(t, "MolecularSequence", "start", element.getStartElement(), -1);
        }
        if (element.hasEndElement()) {
            this.composeInteger(t, "MolecularSequence", "end", element.getEndElement(), -1);
        }
    }

    protected void composeMolecularSequenceMolecularSequenceStructureVariantInnerComponent(Turtle.Complex parent, String parentType, String name, MolecularSequence.MolecularSequenceStructureVariantInnerComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "inner", name, element, index);
        if (element.hasStartElement()) {
            this.composeInteger(t, "MolecularSequence", "start", element.getStartElement(), -1);
        }
        if (element.hasEndElement()) {
            this.composeInteger(t, "MolecularSequence", "end", element.getEndElement(), -1);
        }
    }

    protected void composeNamingSystem(Turtle.Complex parent, String parentType, String name, NamingSystem element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "NamingSystem", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "NamingSystem", "name", element.getNameElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "NamingSystem", "status", element.getStatusElement(), -1);
        }
        if (element.hasKindElement()) {
            this.composeEnum(t, "NamingSystem", "kind", element.getKindElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "NamingSystem", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "NamingSystem", "publisher", element.getPublisherElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeContactDetail(t, "NamingSystem", "contact", element.getContact().get(i), i);
        }
        if (element.hasResponsibleElement()) {
            this.composeString(t, "NamingSystem", "responsible", element.getResponsibleElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "NamingSystem", "type", element.getType(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "NamingSystem", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getUseContext().size(); ++i) {
            this.composeUsageContext(t, "NamingSystem", "useContext", element.getUseContext().get(i), i);
        }
        for (i = 0; i < element.getJurisdiction().size(); ++i) {
            this.composeCodeableConcept(t, "NamingSystem", "jurisdiction", element.getJurisdiction().get(i), i);
        }
        if (element.hasUsageElement()) {
            this.composeString(t, "NamingSystem", "usage", element.getUsageElement(), -1);
        }
        for (i = 0; i < element.getUniqueId().size(); ++i) {
            this.composeNamingSystemNamingSystemUniqueIdComponent(t, "NamingSystem", "uniqueId", element.getUniqueId().get(i), i);
        }
    }

    protected void composeNamingSystemNamingSystemUniqueIdComponent(Turtle.Complex parent, String parentType, String name, NamingSystem.NamingSystemUniqueIdComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "uniqueId", name, element, index);
        if (element.hasTypeElement()) {
            this.composeEnum(t, "NamingSystem", "type", element.getTypeElement(), -1);
        }
        if (element.hasValueElement()) {
            this.composeString(t, "NamingSystem", "value", element.getValueElement(), -1);
        }
        if (element.hasPreferredElement()) {
            this.composeBoolean(t, "NamingSystem", "preferred", element.getPreferredElement(), -1);
        }
        if (element.hasCommentElement()) {
            this.composeString(t, "NamingSystem", "comment", element.getCommentElement(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "NamingSystem", "period", element.getPeriod(), -1);
        }
    }

    protected void composeNutritionOrder(Turtle.Complex parent, String parentType, String name, NutritionOrder element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "NutritionOrder", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "NutritionOrder", "identifier", element.getIdentifier().get(i), i);
        }
        for (i = 0; i < element.getInstantiatesCanonical().size(); ++i) {
            this.composeCanonical(t, "NutritionOrder", "instantiatesCanonical", element.getInstantiatesCanonical().get(i), i);
        }
        for (i = 0; i < element.getInstantiatesUri().size(); ++i) {
            this.composeUri(t, "NutritionOrder", "instantiatesUri", element.getInstantiatesUri().get(i), i);
        }
        for (i = 0; i < element.getInstantiates().size(); ++i) {
            this.composeUri(t, "NutritionOrder", "instantiates", element.getInstantiates().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "NutritionOrder", "status", element.getStatusElement(), -1);
        }
        if (element.hasIntentElement()) {
            this.composeEnum(t, "NutritionOrder", "intent", element.getIntentElement(), -1);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "NutritionOrder", "patient", element.getPatient(), -1);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "NutritionOrder", "encounter", element.getEncounter(), -1);
        }
        if (element.hasDateTimeElement()) {
            this.composeDateTime(t, "NutritionOrder", "dateTime", element.getDateTimeElement(), -1);
        }
        if (element.hasOrderer()) {
            this.composeReference(t, "NutritionOrder", "orderer", element.getOrderer(), -1);
        }
        for (i = 0; i < element.getAllergyIntolerance().size(); ++i) {
            this.composeReference(t, "NutritionOrder", "allergyIntolerance", element.getAllergyIntolerance().get(i), i);
        }
        for (i = 0; i < element.getFoodPreferenceModifier().size(); ++i) {
            this.composeCodeableConcept(t, "NutritionOrder", "foodPreferenceModifier", element.getFoodPreferenceModifier().get(i), i);
        }
        for (i = 0; i < element.getExcludeFoodModifier().size(); ++i) {
            this.composeCodeableConcept(t, "NutritionOrder", "excludeFoodModifier", element.getExcludeFoodModifier().get(i), i);
        }
        if (element.hasOralDiet()) {
            this.composeNutritionOrderNutritionOrderOralDietComponent(t, "NutritionOrder", "oralDiet", element.getOralDiet(), -1);
        }
        for (i = 0; i < element.getSupplement().size(); ++i) {
            this.composeNutritionOrderNutritionOrderSupplementComponent(t, "NutritionOrder", "supplement", element.getSupplement().get(i), i);
        }
        if (element.hasEnteralFormula()) {
            this.composeNutritionOrderNutritionOrderEnteralFormulaComponent(t, "NutritionOrder", "enteralFormula", element.getEnteralFormula(), -1);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "NutritionOrder", "note", element.getNote().get(i), i);
        }
    }

    protected void composeNutritionOrderNutritionOrderOralDietComponent(Turtle.Complex parent, String parentType, String name, NutritionOrder.NutritionOrderOralDietComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "oralDiet", name, element, index);
        for (i = 0; i < element.getType().size(); ++i) {
            this.composeCodeableConcept(t, "NutritionOrder", "type", element.getType().get(i), i);
        }
        for (i = 0; i < element.getSchedule().size(); ++i) {
            this.composeTiming(t, "NutritionOrder", "schedule", element.getSchedule().get(i), i);
        }
        for (i = 0; i < element.getNutrient().size(); ++i) {
            this.composeNutritionOrderNutritionOrderOralDietNutrientComponent(t, "NutritionOrder", "nutrient", element.getNutrient().get(i), i);
        }
        for (i = 0; i < element.getTexture().size(); ++i) {
            this.composeNutritionOrderNutritionOrderOralDietTextureComponent(t, "NutritionOrder", "texture", element.getTexture().get(i), i);
        }
        for (i = 0; i < element.getFluidConsistencyType().size(); ++i) {
            this.composeCodeableConcept(t, "NutritionOrder", "fluidConsistencyType", element.getFluidConsistencyType().get(i), i);
        }
        if (element.hasInstructionElement()) {
            this.composeString(t, "NutritionOrder", "instruction", element.getInstructionElement(), -1);
        }
    }

    protected void composeNutritionOrderNutritionOrderOralDietNutrientComponent(Turtle.Complex parent, String parentType, String name, NutritionOrder.NutritionOrderOralDietNutrientComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "nutrient", name, element, index);
        if (element.hasModifier()) {
            this.composeCodeableConcept(t, "NutritionOrder", "modifier", element.getModifier(), -1);
        }
        if (element.hasAmount()) {
            this.composeQuantity(t, "NutritionOrder", "amount", element.getAmount(), -1);
        }
    }

    protected void composeNutritionOrderNutritionOrderOralDietTextureComponent(Turtle.Complex parent, String parentType, String name, NutritionOrder.NutritionOrderOralDietTextureComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "texture", name, element, index);
        if (element.hasModifier()) {
            this.composeCodeableConcept(t, "NutritionOrder", "modifier", element.getModifier(), -1);
        }
        if (element.hasFoodType()) {
            this.composeCodeableConcept(t, "NutritionOrder", "foodType", element.getFoodType(), -1);
        }
    }

    protected void composeNutritionOrderNutritionOrderSupplementComponent(Turtle.Complex parent, String parentType, String name, NutritionOrder.NutritionOrderSupplementComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "supplement", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "NutritionOrder", "type", element.getType(), -1);
        }
        if (element.hasProductNameElement()) {
            this.composeString(t, "NutritionOrder", "productName", element.getProductNameElement(), -1);
        }
        for (int i = 0; i < element.getSchedule().size(); ++i) {
            this.composeTiming(t, "NutritionOrder", "schedule", element.getSchedule().get(i), i);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "NutritionOrder", "quantity", element.getQuantity(), -1);
        }
        if (element.hasInstructionElement()) {
            this.composeString(t, "NutritionOrder", "instruction", element.getInstructionElement(), -1);
        }
    }

    protected void composeNutritionOrderNutritionOrderEnteralFormulaComponent(Turtle.Complex parent, String parentType, String name, NutritionOrder.NutritionOrderEnteralFormulaComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "enteralFormula", name, element, index);
        if (element.hasBaseFormulaType()) {
            this.composeCodeableConcept(t, "NutritionOrder", "baseFormulaType", element.getBaseFormulaType(), -1);
        }
        if (element.hasBaseFormulaProductNameElement()) {
            this.composeString(t, "NutritionOrder", "baseFormulaProductName", element.getBaseFormulaProductNameElement(), -1);
        }
        if (element.hasAdditiveType()) {
            this.composeCodeableConcept(t, "NutritionOrder", "additiveType", element.getAdditiveType(), -1);
        }
        if (element.hasAdditiveProductNameElement()) {
            this.composeString(t, "NutritionOrder", "additiveProductName", element.getAdditiveProductNameElement(), -1);
        }
        if (element.hasCaloricDensity()) {
            this.composeQuantity(t, "NutritionOrder", "caloricDensity", element.getCaloricDensity(), -1);
        }
        if (element.hasRouteofAdministration()) {
            this.composeCodeableConcept(t, "NutritionOrder", "routeofAdministration", element.getRouteofAdministration(), -1);
        }
        for (int i = 0; i < element.getAdministration().size(); ++i) {
            this.composeNutritionOrderNutritionOrderEnteralFormulaAdministrationComponent(t, "NutritionOrder", "administration", element.getAdministration().get(i), i);
        }
        if (element.hasMaxVolumeToDeliver()) {
            this.composeQuantity(t, "NutritionOrder", "maxVolumeToDeliver", element.getMaxVolumeToDeliver(), -1);
        }
        if (element.hasAdministrationInstructionElement()) {
            this.composeString(t, "NutritionOrder", "administrationInstruction", element.getAdministrationInstructionElement(), -1);
        }
    }

    protected void composeNutritionOrderNutritionOrderEnteralFormulaAdministrationComponent(Turtle.Complex parent, String parentType, String name, NutritionOrder.NutritionOrderEnteralFormulaAdministrationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "administration", name, element, index);
        if (element.hasSchedule()) {
            this.composeTiming(t, "NutritionOrder", "schedule", element.getSchedule(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "NutritionOrder", "quantity", element.getQuantity(), -1);
        }
        if (element.hasRate()) {
            this.composeType(t, "NutritionOrder", "rate", element.getRate(), -1);
        }
    }

    protected void composeObservation(Turtle.Complex parent, String parentType, String name, Observation element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Observation", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Observation", "identifier", element.getIdentifier().get(i), i);
        }
        for (i = 0; i < element.getBasedOn().size(); ++i) {
            this.composeReference(t, "Observation", "basedOn", element.getBasedOn().get(i), i);
        }
        for (i = 0; i < element.getPartOf().size(); ++i) {
            this.composeReference(t, "Observation", "partOf", element.getPartOf().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Observation", "status", element.getStatusElement(), -1);
        }
        for (i = 0; i < element.getCategory().size(); ++i) {
            this.composeCodeableConcept(t, "Observation", "category", element.getCategory().get(i), i);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "Observation", "code", element.getCode(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "Observation", "subject", element.getSubject(), -1);
        }
        for (i = 0; i < element.getFocus().size(); ++i) {
            this.composeReference(t, "Observation", "focus", element.getFocus().get(i), i);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "Observation", "encounter", element.getEncounter(), -1);
        }
        if (element.hasEffective()) {
            this.composeType(t, "Observation", "effective", element.getEffective(), -1);
        }
        if (element.hasIssuedElement()) {
            this.composeInstant(t, "Observation", "issued", element.getIssuedElement(), -1);
        }
        for (i = 0; i < element.getPerformer().size(); ++i) {
            this.composeReference(t, "Observation", "performer", element.getPerformer().get(i), i);
        }
        if (element.hasValue()) {
            this.composeType(t, "Observation", "value", element.getValue(), -1);
        }
        if (element.hasDataAbsentReason()) {
            this.composeCodeableConcept(t, "Observation", "dataAbsentReason", element.getDataAbsentReason(), -1);
        }
        for (i = 0; i < element.getInterpretation().size(); ++i) {
            this.composeCodeableConcept(t, "Observation", "interpretation", element.getInterpretation().get(i), i);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "Observation", "note", element.getNote().get(i), i);
        }
        if (element.hasBodySite()) {
            this.composeCodeableConcept(t, "Observation", "bodySite", element.getBodySite(), -1);
        }
        if (element.hasMethod()) {
            this.composeCodeableConcept(t, "Observation", "method", element.getMethod(), -1);
        }
        if (element.hasSpecimen()) {
            this.composeReference(t, "Observation", "specimen", element.getSpecimen(), -1);
        }
        if (element.hasDevice()) {
            this.composeReference(t, "Observation", "device", element.getDevice(), -1);
        }
        for (i = 0; i < element.getReferenceRange().size(); ++i) {
            this.composeObservationObservationReferenceRangeComponent(t, "Observation", "referenceRange", element.getReferenceRange().get(i), i);
        }
        for (i = 0; i < element.getHasMember().size(); ++i) {
            this.composeReference(t, "Observation", "hasMember", element.getHasMember().get(i), i);
        }
        for (i = 0; i < element.getDerivedFrom().size(); ++i) {
            this.composeReference(t, "Observation", "derivedFrom", element.getDerivedFrom().get(i), i);
        }
        for (i = 0; i < element.getComponent().size(); ++i) {
            this.composeObservationObservationComponentComponent(t, "Observation", "component", element.getComponent().get(i), i);
        }
    }

    protected void composeObservationObservationReferenceRangeComponent(Turtle.Complex parent, String parentType, String name, Observation.ObservationReferenceRangeComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "referenceRange", name, element, index);
        if (element.hasLow()) {
            this.composeQuantity(t, "Observation", "low", element.getLow(), -1);
        }
        if (element.hasHigh()) {
            this.composeQuantity(t, "Observation", "high", element.getHigh(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "Observation", "type", element.getType(), -1);
        }
        for (int i = 0; i < element.getAppliesTo().size(); ++i) {
            this.composeCodeableConcept(t, "Observation", "appliesTo", element.getAppliesTo().get(i), i);
        }
        if (element.hasAge()) {
            this.composeRange(t, "Observation", "age", element.getAge(), -1);
        }
        if (element.hasTextElement()) {
            this.composeString(t, "Observation", "text", element.getTextElement(), -1);
        }
    }

    protected void composeObservationObservationComponentComponent(Turtle.Complex parent, String parentType, String name, Observation.ObservationComponentComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "component", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "Observation", "code", element.getCode(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "Observation", "value", element.getValue(), -1);
        }
        if (element.hasDataAbsentReason()) {
            this.composeCodeableConcept(t, "Observation", "dataAbsentReason", element.getDataAbsentReason(), -1);
        }
        for (i = 0; i < element.getInterpretation().size(); ++i) {
            this.composeCodeableConcept(t, "Observation", "interpretation", element.getInterpretation().get(i), i);
        }
        for (i = 0; i < element.getReferenceRange().size(); ++i) {
            this.composeObservationObservationReferenceRangeComponent(t, "Observation", "referenceRange", element.getReferenceRange().get(i), i);
        }
    }

    protected void composeObservationDefinition(Turtle.Complex parent, String parentType, String name, ObservationDefinition element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "ObservationDefinition", name, element, index);
        for (i = 0; i < element.getCategory().size(); ++i) {
            this.composeCodeableConcept(t, "ObservationDefinition", "category", element.getCategory().get(i), i);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "ObservationDefinition", "code", element.getCode(), -1);
        }
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "ObservationDefinition", "identifier", element.getIdentifier().get(i), i);
        }
        for (i = 0; i < element.getPermittedDataType().size(); ++i) {
            this.composeEnum(t, "ObservationDefinition", "permittedDataType", element.getPermittedDataType().get(i), i);
        }
        if (element.hasMultipleResultsAllowedElement()) {
            this.composeBoolean(t, "ObservationDefinition", "multipleResultsAllowed", element.getMultipleResultsAllowedElement(), -1);
        }
        if (element.hasMethod()) {
            this.composeCodeableConcept(t, "ObservationDefinition", "method", element.getMethod(), -1);
        }
        if (element.hasPreferredReportNameElement()) {
            this.composeString(t, "ObservationDefinition", "preferredReportName", element.getPreferredReportNameElement(), -1);
        }
        if (element.hasQuantitativeDetails()) {
            this.composeObservationDefinitionObservationDefinitionQuantitativeDetailsComponent(t, "ObservationDefinition", "quantitativeDetails", element.getQuantitativeDetails(), -1);
        }
        for (i = 0; i < element.getQualifiedInterval().size(); ++i) {
            this.composeObservationDefinitionObservationDefinitionQualifiedIntervalComponent(t, "ObservationDefinition", "qualifiedInterval", element.getQualifiedInterval().get(i), i);
        }
        if (element.hasValidCodedValueSet()) {
            this.composeReference(t, "ObservationDefinition", "validCodedValueSet", element.getValidCodedValueSet(), -1);
        }
        if (element.hasNormalCodedValueSet()) {
            this.composeReference(t, "ObservationDefinition", "normalCodedValueSet", element.getNormalCodedValueSet(), -1);
        }
        if (element.hasAbnormalCodedValueSet()) {
            this.composeReference(t, "ObservationDefinition", "abnormalCodedValueSet", element.getAbnormalCodedValueSet(), -1);
        }
        if (element.hasCriticalCodedValueSet()) {
            this.composeReference(t, "ObservationDefinition", "criticalCodedValueSet", element.getCriticalCodedValueSet(), -1);
        }
    }

    protected void composeObservationDefinitionObservationDefinitionQuantitativeDetailsComponent(Turtle.Complex parent, String parentType, String name, ObservationDefinition.ObservationDefinitionQuantitativeDetailsComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "quantitativeDetails", name, element, index);
        if (element.hasCustomaryUnit()) {
            this.composeCodeableConcept(t, "ObservationDefinition", "customaryUnit", element.getCustomaryUnit(), -1);
        }
        if (element.hasUnit()) {
            this.composeCodeableConcept(t, "ObservationDefinition", "unit", element.getUnit(), -1);
        }
        if (element.hasConversionFactorElement()) {
            this.composeDecimal(t, "ObservationDefinition", "conversionFactor", element.getConversionFactorElement(), -1);
        }
        if (element.hasDecimalPrecisionElement()) {
            this.composeInteger(t, "ObservationDefinition", "decimalPrecision", element.getDecimalPrecisionElement(), -1);
        }
    }

    protected void composeObservationDefinitionObservationDefinitionQualifiedIntervalComponent(Turtle.Complex parent, String parentType, String name, ObservationDefinition.ObservationDefinitionQualifiedIntervalComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "qualifiedInterval", name, element, index);
        if (element.hasCategoryElement()) {
            this.composeEnum(t, "ObservationDefinition", "category", element.getCategoryElement(), -1);
        }
        if (element.hasRange()) {
            this.composeRange(t, "ObservationDefinition", "range", element.getRange(), -1);
        }
        if (element.hasContext()) {
            this.composeCodeableConcept(t, "ObservationDefinition", "context", element.getContext(), -1);
        }
        for (int i = 0; i < element.getAppliesTo().size(); ++i) {
            this.composeCodeableConcept(t, "ObservationDefinition", "appliesTo", element.getAppliesTo().get(i), i);
        }
        if (element.hasGenderElement()) {
            this.composeEnum(t, "ObservationDefinition", "gender", element.getGenderElement(), -1);
        }
        if (element.hasAge()) {
            this.composeRange(t, "ObservationDefinition", "age", element.getAge(), -1);
        }
        if (element.hasGestationalAge()) {
            this.composeRange(t, "ObservationDefinition", "gestationalAge", element.getGestationalAge(), -1);
        }
        if (element.hasConditionElement()) {
            this.composeString(t, "ObservationDefinition", "condition", element.getConditionElement(), -1);
        }
    }

    protected void composeOperationDefinition(Turtle.Complex parent, String parentType, String name, OperationDefinition element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "OperationDefinition", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "OperationDefinition", "url", element.getUrlElement(), -1);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "OperationDefinition", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "OperationDefinition", "name", element.getNameElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "OperationDefinition", "title", element.getTitleElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "OperationDefinition", "status", element.getStatusElement(), -1);
        }
        if (element.hasKindElement()) {
            this.composeEnum(t, "OperationDefinition", "kind", element.getKindElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "OperationDefinition", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "OperationDefinition", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "OperationDefinition", "publisher", element.getPublisherElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeContactDetail(t, "OperationDefinition", "contact", element.getContact().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "OperationDefinition", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getUseContext().size(); ++i) {
            this.composeUsageContext(t, "OperationDefinition", "useContext", element.getUseContext().get(i), i);
        }
        for (i = 0; i < element.getJurisdiction().size(); ++i) {
            this.composeCodeableConcept(t, "OperationDefinition", "jurisdiction", element.getJurisdiction().get(i), i);
        }
        if (element.hasPurposeElement()) {
            this.composeMarkdown(t, "OperationDefinition", "purpose", element.getPurposeElement(), -1);
        }
        if (element.hasAffectsStateElement()) {
            this.composeBoolean(t, "OperationDefinition", "affectsState", element.getAffectsStateElement(), -1);
        }
        if (element.hasCodeElement()) {
            this.composeCode(t, "OperationDefinition", "code", element.getCodeElement(), -1);
        }
        if (element.hasCommentElement()) {
            this.composeMarkdown(t, "OperationDefinition", "comment", element.getCommentElement(), -1);
        }
        if (element.hasBaseElement()) {
            this.composeCanonical(t, "OperationDefinition", "base", element.getBaseElement(), -1);
        }
        for (i = 0; i < element.getResource().size(); ++i) {
            this.composeCode(t, "OperationDefinition", "resource", element.getResource().get(i), i);
        }
        if (element.hasSystemElement()) {
            this.composeBoolean(t, "OperationDefinition", "system", element.getSystemElement(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeBoolean(t, "OperationDefinition", "type", element.getTypeElement(), -1);
        }
        if (element.hasInstanceElement()) {
            this.composeBoolean(t, "OperationDefinition", "instance", element.getInstanceElement(), -1);
        }
        if (element.hasInputProfileElement()) {
            this.composeCanonical(t, "OperationDefinition", "inputProfile", element.getInputProfileElement(), -1);
        }
        if (element.hasOutputProfileElement()) {
            this.composeCanonical(t, "OperationDefinition", "outputProfile", element.getOutputProfileElement(), -1);
        }
        for (i = 0; i < element.getParameter().size(); ++i) {
            this.composeOperationDefinitionOperationDefinitionParameterComponent(t, "OperationDefinition", "parameter", element.getParameter().get(i), i);
        }
        for (i = 0; i < element.getOverload().size(); ++i) {
            this.composeOperationDefinitionOperationDefinitionOverloadComponent(t, "OperationDefinition", "overload", element.getOverload().get(i), i);
        }
    }

    protected void composeOperationDefinitionOperationDefinitionParameterComponent(Turtle.Complex parent, String parentType, String name, OperationDefinition.OperationDefinitionParameterComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "parameter", name, element, index);
        if (element.hasNameElement()) {
            this.composeCode(t, "OperationDefinition", "name", element.getNameElement(), -1);
        }
        if (element.hasUseElement()) {
            this.composeEnum(t, "OperationDefinition", "use", element.getUseElement(), -1);
        }
        if (element.hasMinElement()) {
            this.composeInteger(t, "OperationDefinition", "min", element.getMinElement(), -1);
        }
        if (element.hasMaxElement()) {
            this.composeString(t, "OperationDefinition", "max", element.getMaxElement(), -1);
        }
        if (element.hasDocumentationElement()) {
            this.composeString(t, "OperationDefinition", "documentation", element.getDocumentationElement(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeCode(t, "OperationDefinition", "type", element.getTypeElement(), -1);
        }
        for (i = 0; i < element.getTargetProfile().size(); ++i) {
            this.composeCanonical(t, "OperationDefinition", "targetProfile", element.getTargetProfile().get(i), i);
        }
        if (element.hasSearchTypeElement()) {
            this.composeEnum(t, "OperationDefinition", "searchType", element.getSearchTypeElement(), -1);
        }
        if (element.hasBinding()) {
            this.composeOperationDefinitionOperationDefinitionParameterBindingComponent(t, "OperationDefinition", "binding", element.getBinding(), -1);
        }
        for (i = 0; i < element.getReferencedFrom().size(); ++i) {
            this.composeOperationDefinitionOperationDefinitionParameterReferencedFromComponent(t, "OperationDefinition", "referencedFrom", element.getReferencedFrom().get(i), i);
        }
        for (i = 0; i < element.getPart().size(); ++i) {
            this.composeOperationDefinitionOperationDefinitionParameterComponent(t, "OperationDefinition", "part", element.getPart().get(i), i);
        }
    }

    protected void composeOperationDefinitionOperationDefinitionParameterBindingComponent(Turtle.Complex parent, String parentType, String name, OperationDefinition.OperationDefinitionParameterBindingComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "binding", name, element, index);
        if (element.hasStrengthElement()) {
            this.composeEnum(t, "OperationDefinition", "strength", element.getStrengthElement(), -1);
        }
        if (element.hasValueSetElement()) {
            this.composeCanonical(t, "OperationDefinition", "valueSet", element.getValueSetElement(), -1);
        }
    }

    protected void composeOperationDefinitionOperationDefinitionParameterReferencedFromComponent(Turtle.Complex parent, String parentType, String name, OperationDefinition.OperationDefinitionParameterReferencedFromComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "referencedFrom", name, element, index);
        if (element.hasSourceElement()) {
            this.composeString(t, "OperationDefinition", "source", element.getSourceElement(), -1);
        }
        if (element.hasSourceIdElement()) {
            this.composeString(t, "OperationDefinition", "sourceId", element.getSourceIdElement(), -1);
        }
    }

    protected void composeOperationDefinitionOperationDefinitionOverloadComponent(Turtle.Complex parent, String parentType, String name, OperationDefinition.OperationDefinitionOverloadComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "overload", name, element, index);
        for (int i = 0; i < element.getParameterName().size(); ++i) {
            this.composeString(t, "OperationDefinition", "parameterName", element.getParameterName().get(i), i);
        }
        if (element.hasCommentElement()) {
            this.composeString(t, "OperationDefinition", "comment", element.getCommentElement(), -1);
        }
    }

    protected void composeOperationOutcome(Turtle.Complex parent, String parentType, String name, OperationOutcome element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "OperationOutcome", name, element, index);
        for (int i = 0; i < element.getIssue().size(); ++i) {
            this.composeOperationOutcomeOperationOutcomeIssueComponent(t, "OperationOutcome", "issue", element.getIssue().get(i), i);
        }
    }

    protected void composeOperationOutcomeOperationOutcomeIssueComponent(Turtle.Complex parent, String parentType, String name, OperationOutcome.OperationOutcomeIssueComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "issue", name, element, index);
        if (element.hasSeverityElement()) {
            this.composeEnum(t, "OperationOutcome", "severity", element.getSeverityElement(), -1);
        }
        if (element.hasCodeElement()) {
            this.composeEnum(t, "OperationOutcome", "code", element.getCodeElement(), -1);
        }
        if (element.hasDetails()) {
            this.composeCodeableConcept(t, "OperationOutcome", "details", element.getDetails(), -1);
        }
        if (element.hasDiagnosticsElement()) {
            this.composeString(t, "OperationOutcome", "diagnostics", element.getDiagnosticsElement(), -1);
        }
        for (i = 0; i < element.getLocation().size(); ++i) {
            this.composeString(t, "OperationOutcome", "location", element.getLocation().get(i), i);
        }
        for (i = 0; i < element.getExpression().size(); ++i) {
            this.composeString(t, "OperationOutcome", "expression", element.getExpression().get(i), i);
        }
    }

    protected void composeOrganization(Turtle.Complex parent, String parentType, String name, Organization element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Organization", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Organization", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasActiveElement()) {
            this.composeBoolean(t, "Organization", "active", element.getActiveElement(), -1);
        }
        for (i = 0; i < element.getType().size(); ++i) {
            this.composeCodeableConcept(t, "Organization", "type", element.getType().get(i), i);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "Organization", "name", element.getNameElement(), -1);
        }
        for (i = 0; i < element.getAlias().size(); ++i) {
            this.composeString(t, "Organization", "alias", element.getAlias().get(i), i);
        }
        for (i = 0; i < element.getTelecom().size(); ++i) {
            this.composeContactPoint(t, "Organization", "telecom", element.getTelecom().get(i), i);
        }
        for (i = 0; i < element.getAddress().size(); ++i) {
            this.composeAddress(t, "Organization", "address", element.getAddress().get(i), i);
        }
        if (element.hasPartOf()) {
            this.composeReference(t, "Organization", "partOf", element.getPartOf(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeOrganizationOrganizationContactComponent(t, "Organization", "contact", element.getContact().get(i), i);
        }
        for (i = 0; i < element.getEndpoint().size(); ++i) {
            this.composeReference(t, "Organization", "endpoint", element.getEndpoint().get(i), i);
        }
    }

    protected void composeOrganizationOrganizationContactComponent(Turtle.Complex parent, String parentType, String name, Organization.OrganizationContactComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "contact", name, element, index);
        if (element.hasPurpose()) {
            this.composeCodeableConcept(t, "Organization", "purpose", element.getPurpose(), -1);
        }
        if (element.hasName()) {
            this.composeHumanName(t, "Organization", "name", element.getName(), -1);
        }
        for (int i = 0; i < element.getTelecom().size(); ++i) {
            this.composeContactPoint(t, "Organization", "telecom", element.getTelecom().get(i), i);
        }
        if (element.hasAddress()) {
            this.composeAddress(t, "Organization", "address", element.getAddress(), -1);
        }
    }

    protected void composeOrganizationAffiliation(Turtle.Complex parent, String parentType, String name, OrganizationAffiliation element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "OrganizationAffiliation", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "OrganizationAffiliation", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasActiveElement()) {
            this.composeBoolean(t, "OrganizationAffiliation", "active", element.getActiveElement(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "OrganizationAffiliation", "period", element.getPeriod(), -1);
        }
        if (element.hasOrganization()) {
            this.composeReference(t, "OrganizationAffiliation", "organization", element.getOrganization(), -1);
        }
        if (element.hasParticipatingOrganization()) {
            this.composeReference(t, "OrganizationAffiliation", "participatingOrganization", element.getParticipatingOrganization(), -1);
        }
        for (i = 0; i < element.getNetwork().size(); ++i) {
            this.composeReference(t, "OrganizationAffiliation", "network", element.getNetwork().get(i), i);
        }
        for (i = 0; i < element.getCode().size(); ++i) {
            this.composeCodeableConcept(t, "OrganizationAffiliation", "code", element.getCode().get(i), i);
        }
        for (i = 0; i < element.getSpecialty().size(); ++i) {
            this.composeCodeableConcept(t, "OrganizationAffiliation", "specialty", element.getSpecialty().get(i), i);
        }
        for (i = 0; i < element.getLocation().size(); ++i) {
            this.composeReference(t, "OrganizationAffiliation", "location", element.getLocation().get(i), i);
        }
        for (i = 0; i < element.getHealthcareService().size(); ++i) {
            this.composeReference(t, "OrganizationAffiliation", "healthcareService", element.getHealthcareService().get(i), i);
        }
        for (i = 0; i < element.getTelecom().size(); ++i) {
            this.composeContactPoint(t, "OrganizationAffiliation", "telecom", element.getTelecom().get(i), i);
        }
        for (i = 0; i < element.getEndpoint().size(); ++i) {
            this.composeReference(t, "OrganizationAffiliation", "endpoint", element.getEndpoint().get(i), i);
        }
    }

    protected void composePatient(Turtle.Complex parent, String parentType, String name, Patient element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Patient", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Patient", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasActiveElement()) {
            this.composeBoolean(t, "Patient", "active", element.getActiveElement(), -1);
        }
        for (i = 0; i < element.getName().size(); ++i) {
            this.composeHumanName(t, "Patient", "name", element.getName().get(i), i);
        }
        for (i = 0; i < element.getTelecom().size(); ++i) {
            this.composeContactPoint(t, "Patient", "telecom", element.getTelecom().get(i), i);
        }
        if (element.hasGenderElement()) {
            this.composeEnum(t, "Patient", "gender", element.getGenderElement(), -1);
        }
        if (element.hasBirthDateElement()) {
            this.composeDate(t, "Patient", "birthDate", element.getBirthDateElement(), -1);
        }
        if (element.hasDeceased()) {
            this.composeType(t, "Patient", "deceased", element.getDeceased(), -1);
        }
        for (i = 0; i < element.getAddress().size(); ++i) {
            this.composeAddress(t, "Patient", "address", element.getAddress().get(i), i);
        }
        if (element.hasMaritalStatus()) {
            this.composeCodeableConcept(t, "Patient", "maritalStatus", element.getMaritalStatus(), -1);
        }
        if (element.hasMultipleBirth()) {
            this.composeType(t, "Patient", "multipleBirth", element.getMultipleBirth(), -1);
        }
        for (i = 0; i < element.getPhoto().size(); ++i) {
            this.composeAttachment(t, "Patient", "photo", element.getPhoto().get(i), i);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composePatientContactComponent(t, "Patient", "contact", element.getContact().get(i), i);
        }
        for (i = 0; i < element.getCommunication().size(); ++i) {
            this.composePatientPatientCommunicationComponent(t, "Patient", "communication", element.getCommunication().get(i), i);
        }
        for (i = 0; i < element.getGeneralPractitioner().size(); ++i) {
            this.composeReference(t, "Patient", "generalPractitioner", element.getGeneralPractitioner().get(i), i);
        }
        if (element.hasManagingOrganization()) {
            this.composeReference(t, "Patient", "managingOrganization", element.getManagingOrganization(), -1);
        }
        for (i = 0; i < element.getLink().size(); ++i) {
            this.composePatientPatientLinkComponent(t, "Patient", "link", element.getLink().get(i), i);
        }
    }

    protected void composePatientContactComponent(Turtle.Complex parent, String parentType, String name, Patient.ContactComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "contact", name, element, index);
        for (i = 0; i < element.getRelationship().size(); ++i) {
            this.composeCodeableConcept(t, "Patient", "relationship", element.getRelationship().get(i), i);
        }
        if (element.hasName()) {
            this.composeHumanName(t, "Patient", "name", element.getName(), -1);
        }
        for (i = 0; i < element.getTelecom().size(); ++i) {
            this.composeContactPoint(t, "Patient", "telecom", element.getTelecom().get(i), i);
        }
        if (element.hasAddress()) {
            this.composeAddress(t, "Patient", "address", element.getAddress(), -1);
        }
        if (element.hasGenderElement()) {
            this.composeEnum(t, "Patient", "gender", element.getGenderElement(), -1);
        }
        if (element.hasOrganization()) {
            this.composeReference(t, "Patient", "organization", element.getOrganization(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "Patient", "period", element.getPeriod(), -1);
        }
    }

    protected void composePatientPatientCommunicationComponent(Turtle.Complex parent, String parentType, String name, Patient.PatientCommunicationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "communication", name, element, index);
        if (element.hasLanguage()) {
            this.composeCodeableConcept(t, "Patient", "language", element.getLanguage(), -1);
        }
        if (element.hasPreferredElement()) {
            this.composeBoolean(t, "Patient", "preferred", element.getPreferredElement(), -1);
        }
    }

    protected void composePatientPatientLinkComponent(Turtle.Complex parent, String parentType, String name, Patient.PatientLinkComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "link", name, element, index);
        if (element.hasOther()) {
            this.composeReference(t, "Patient", "other", element.getOther(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeEnum(t, "Patient", "type", element.getTypeElement(), -1);
        }
    }

    protected void composePaymentNotice(Turtle.Complex parent, String parentType, String name, PaymentNotice element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "PaymentNotice", name, element, index);
        for (int i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "PaymentNotice", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "PaymentNotice", "status", element.getStatusElement(), -1);
        }
        if (element.hasRequest()) {
            this.composeReference(t, "PaymentNotice", "request", element.getRequest(), -1);
        }
        if (element.hasResponse()) {
            this.composeReference(t, "PaymentNotice", "response", element.getResponse(), -1);
        }
        if (element.hasCreatedElement()) {
            this.composeDateTime(t, "PaymentNotice", "created", element.getCreatedElement(), -1);
        }
        if (element.hasProvider()) {
            this.composeReference(t, "PaymentNotice", "provider", element.getProvider(), -1);
        }
        if (element.hasPayment()) {
            this.composeReference(t, "PaymentNotice", "payment", element.getPayment(), -1);
        }
        if (element.hasPaymentDateElement()) {
            this.composeDate(t, "PaymentNotice", "paymentDate", element.getPaymentDateElement(), -1);
        }
        if (element.hasPayee()) {
            this.composeReference(t, "PaymentNotice", "payee", element.getPayee(), -1);
        }
        if (element.hasRecipient()) {
            this.composeReference(t, "PaymentNotice", "recipient", element.getRecipient(), -1);
        }
        if (element.hasAmount()) {
            this.composeMoney(t, "PaymentNotice", "amount", element.getAmount(), -1);
        }
        if (element.hasPaymentStatus()) {
            this.composeCodeableConcept(t, "PaymentNotice", "paymentStatus", element.getPaymentStatus(), -1);
        }
    }

    protected void composePaymentReconciliation(Turtle.Complex parent, String parentType, String name, PaymentReconciliation element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "PaymentReconciliation", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "PaymentReconciliation", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "PaymentReconciliation", "status", element.getStatusElement(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "PaymentReconciliation", "period", element.getPeriod(), -1);
        }
        if (element.hasCreatedElement()) {
            this.composeDateTime(t, "PaymentReconciliation", "created", element.getCreatedElement(), -1);
        }
        if (element.hasPaymentIssuer()) {
            this.composeReference(t, "PaymentReconciliation", "paymentIssuer", element.getPaymentIssuer(), -1);
        }
        if (element.hasRequest()) {
            this.composeReference(t, "PaymentReconciliation", "request", element.getRequest(), -1);
        }
        if (element.hasRequestor()) {
            this.composeReference(t, "PaymentReconciliation", "requestor", element.getRequestor(), -1);
        }
        if (element.hasOutcomeElement()) {
            this.composeEnum(t, "PaymentReconciliation", "outcome", element.getOutcomeElement(), -1);
        }
        if (element.hasDispositionElement()) {
            this.composeString(t, "PaymentReconciliation", "disposition", element.getDispositionElement(), -1);
        }
        if (element.hasPaymentDateElement()) {
            this.composeDate(t, "PaymentReconciliation", "paymentDate", element.getPaymentDateElement(), -1);
        }
        if (element.hasPaymentAmount()) {
            this.composeMoney(t, "PaymentReconciliation", "paymentAmount", element.getPaymentAmount(), -1);
        }
        if (element.hasPaymentIdentifier()) {
            this.composeIdentifier(t, "PaymentReconciliation", "paymentIdentifier", element.getPaymentIdentifier(), -1);
        }
        for (i = 0; i < element.getDetail().size(); ++i) {
            this.composePaymentReconciliationDetailsComponent(t, "PaymentReconciliation", "detail", element.getDetail().get(i), i);
        }
        if (element.hasFormCode()) {
            this.composeCodeableConcept(t, "PaymentReconciliation", "formCode", element.getFormCode(), -1);
        }
        for (i = 0; i < element.getProcessNote().size(); ++i) {
            this.composePaymentReconciliationNotesComponent(t, "PaymentReconciliation", "processNote", element.getProcessNote().get(i), i);
        }
    }

    protected void composePaymentReconciliationDetailsComponent(Turtle.Complex parent, String parentType, String name, PaymentReconciliation.DetailsComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "detail", name, element, index);
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "PaymentReconciliation", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasPredecessor()) {
            this.composeIdentifier(t, "PaymentReconciliation", "predecessor", element.getPredecessor(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "PaymentReconciliation", "type", element.getType(), -1);
        }
        if (element.hasRequest()) {
            this.composeReference(t, "PaymentReconciliation", "request", element.getRequest(), -1);
        }
        if (element.hasSubmitter()) {
            this.composeReference(t, "PaymentReconciliation", "submitter", element.getSubmitter(), -1);
        }
        if (element.hasResponse()) {
            this.composeReference(t, "PaymentReconciliation", "response", element.getResponse(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDate(t, "PaymentReconciliation", "date", element.getDateElement(), -1);
        }
        if (element.hasResponsible()) {
            this.composeReference(t, "PaymentReconciliation", "responsible", element.getResponsible(), -1);
        }
        if (element.hasPayee()) {
            this.composeReference(t, "PaymentReconciliation", "payee", element.getPayee(), -1);
        }
        if (element.hasAmount()) {
            this.composeMoney(t, "PaymentReconciliation", "amount", element.getAmount(), -1);
        }
    }

    protected void composePaymentReconciliationNotesComponent(Turtle.Complex parent, String parentType, String name, PaymentReconciliation.NotesComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "processNote", name, element, index);
        if (element.hasTypeElement()) {
            this.composeEnum(t, "PaymentReconciliation", "type", element.getTypeElement(), -1);
        }
        if (element.hasTextElement()) {
            this.composeString(t, "PaymentReconciliation", "text", element.getTextElement(), -1);
        }
    }

    protected void composePerson(Turtle.Complex parent, String parentType, String name, Person element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Person", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Person", "identifier", element.getIdentifier().get(i), i);
        }
        for (i = 0; i < element.getName().size(); ++i) {
            this.composeHumanName(t, "Person", "name", element.getName().get(i), i);
        }
        for (i = 0; i < element.getTelecom().size(); ++i) {
            this.composeContactPoint(t, "Person", "telecom", element.getTelecom().get(i), i);
        }
        if (element.hasGenderElement()) {
            this.composeEnum(t, "Person", "gender", element.getGenderElement(), -1);
        }
        if (element.hasBirthDateElement()) {
            this.composeDate(t, "Person", "birthDate", element.getBirthDateElement(), -1);
        }
        for (i = 0; i < element.getAddress().size(); ++i) {
            this.composeAddress(t, "Person", "address", element.getAddress().get(i), i);
        }
        if (element.hasPhoto()) {
            this.composeAttachment(t, "Person", "photo", element.getPhoto(), -1);
        }
        if (element.hasManagingOrganization()) {
            this.composeReference(t, "Person", "managingOrganization", element.getManagingOrganization(), -1);
        }
        if (element.hasActiveElement()) {
            this.composeBoolean(t, "Person", "active", element.getActiveElement(), -1);
        }
        for (i = 0; i < element.getLink().size(); ++i) {
            this.composePersonPersonLinkComponent(t, "Person", "link", element.getLink().get(i), i);
        }
    }

    protected void composePersonPersonLinkComponent(Turtle.Complex parent, String parentType, String name, Person.PersonLinkComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "link", name, element, index);
        if (element.hasTarget()) {
            this.composeReference(t, "Person", "target", element.getTarget(), -1);
        }
        if (element.hasAssuranceElement()) {
            this.composeEnum(t, "Person", "assurance", element.getAssuranceElement(), -1);
        }
    }

    protected void composePlanDefinition(Turtle.Complex parent, String parentType, String name, PlanDefinition element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "PlanDefinition", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "PlanDefinition", "url", element.getUrlElement(), -1);
        }
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "PlanDefinition", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "PlanDefinition", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "PlanDefinition", "name", element.getNameElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "PlanDefinition", "title", element.getTitleElement(), -1);
        }
        if (element.hasSubtitleElement()) {
            this.composeString(t, "PlanDefinition", "subtitle", element.getSubtitleElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "PlanDefinition", "type", element.getType(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "PlanDefinition", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "PlanDefinition", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasSubject()) {
            this.composeType(t, "PlanDefinition", "subject", element.getSubject(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "PlanDefinition", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "PlanDefinition", "publisher", element.getPublisherElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeContactDetail(t, "PlanDefinition", "contact", element.getContact().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "PlanDefinition", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getUseContext().size(); ++i) {
            this.composeUsageContext(t, "PlanDefinition", "useContext", element.getUseContext().get(i), i);
        }
        for (i = 0; i < element.getJurisdiction().size(); ++i) {
            this.composeCodeableConcept(t, "PlanDefinition", "jurisdiction", element.getJurisdiction().get(i), i);
        }
        if (element.hasPurposeElement()) {
            this.composeMarkdown(t, "PlanDefinition", "purpose", element.getPurposeElement(), -1);
        }
        if (element.hasUsageElement()) {
            this.composeString(t, "PlanDefinition", "usage", element.getUsageElement(), -1);
        }
        if (element.hasCopyrightElement()) {
            this.composeMarkdown(t, "PlanDefinition", "copyright", element.getCopyrightElement(), -1);
        }
        if (element.hasApprovalDateElement()) {
            this.composeDate(t, "PlanDefinition", "approvalDate", element.getApprovalDateElement(), -1);
        }
        if (element.hasLastReviewDateElement()) {
            this.composeDate(t, "PlanDefinition", "lastReviewDate", element.getLastReviewDateElement(), -1);
        }
        if (element.hasEffectivePeriod()) {
            this.composePeriod(t, "PlanDefinition", "effectivePeriod", element.getEffectivePeriod(), -1);
        }
        for (i = 0; i < element.getTopic().size(); ++i) {
            this.composeCodeableConcept(t, "PlanDefinition", "topic", element.getTopic().get(i), i);
        }
        for (i = 0; i < element.getAuthor().size(); ++i) {
            this.composeContactDetail(t, "PlanDefinition", "author", element.getAuthor().get(i), i);
        }
        for (i = 0; i < element.getEditor().size(); ++i) {
            this.composeContactDetail(t, "PlanDefinition", "editor", element.getEditor().get(i), i);
        }
        for (i = 0; i < element.getReviewer().size(); ++i) {
            this.composeContactDetail(t, "PlanDefinition", "reviewer", element.getReviewer().get(i), i);
        }
        for (i = 0; i < element.getEndorser().size(); ++i) {
            this.composeContactDetail(t, "PlanDefinition", "endorser", element.getEndorser().get(i), i);
        }
        for (i = 0; i < element.getRelatedArtifact().size(); ++i) {
            this.composeRelatedArtifact(t, "PlanDefinition", "relatedArtifact", element.getRelatedArtifact().get(i), i);
        }
        for (i = 0; i < element.getLibrary().size(); ++i) {
            this.composeCanonical(t, "PlanDefinition", "library", element.getLibrary().get(i), i);
        }
        for (i = 0; i < element.getGoal().size(); ++i) {
            this.composePlanDefinitionPlanDefinitionGoalComponent(t, "PlanDefinition", "goal", element.getGoal().get(i), i);
        }
        for (i = 0; i < element.getAction().size(); ++i) {
            this.composePlanDefinitionPlanDefinitionActionComponent(t, "PlanDefinition", "action", element.getAction().get(i), i);
        }
    }

    protected void composePlanDefinitionPlanDefinitionGoalComponent(Turtle.Complex parent, String parentType, String name, PlanDefinition.PlanDefinitionGoalComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "goal", name, element, index);
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "PlanDefinition", "category", element.getCategory(), -1);
        }
        if (element.hasDescription()) {
            this.composeCodeableConcept(t, "PlanDefinition", "description", element.getDescription(), -1);
        }
        if (element.hasPriority()) {
            this.composeCodeableConcept(t, "PlanDefinition", "priority", element.getPriority(), -1);
        }
        if (element.hasStart()) {
            this.composeCodeableConcept(t, "PlanDefinition", "start", element.getStart(), -1);
        }
        for (i = 0; i < element.getAddresses().size(); ++i) {
            this.composeCodeableConcept(t, "PlanDefinition", "addresses", element.getAddresses().get(i), i);
        }
        for (i = 0; i < element.getDocumentation().size(); ++i) {
            this.composeRelatedArtifact(t, "PlanDefinition", "documentation", element.getDocumentation().get(i), i);
        }
        for (i = 0; i < element.getTarget().size(); ++i) {
            this.composePlanDefinitionPlanDefinitionGoalTargetComponent(t, "PlanDefinition", "target", element.getTarget().get(i), i);
        }
    }

    protected void composePlanDefinitionPlanDefinitionGoalTargetComponent(Turtle.Complex parent, String parentType, String name, PlanDefinition.PlanDefinitionGoalTargetComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "target", name, element, index);
        if (element.hasMeasure()) {
            this.composeCodeableConcept(t, "PlanDefinition", "measure", element.getMeasure(), -1);
        }
        if (element.hasDetail()) {
            this.composeType(t, "PlanDefinition", "detail", element.getDetail(), -1);
        }
        if (element.hasDue()) {
            this.composeDuration(t, "PlanDefinition", "due", element.getDue(), -1);
        }
    }

    protected void composePlanDefinitionPlanDefinitionActionComponent(Turtle.Complex parent, String parentType, String name, PlanDefinition.PlanDefinitionActionComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "action", name, element, index);
        if (element.hasPrefixElement()) {
            this.composeString(t, "PlanDefinition", "prefix", element.getPrefixElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "PlanDefinition", "title", element.getTitleElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "PlanDefinition", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasTextEquivalentElement()) {
            this.composeString(t, "PlanDefinition", "textEquivalent", element.getTextEquivalentElement(), -1);
        }
        if (element.hasPriorityElement()) {
            this.composeEnum(t, "PlanDefinition", "priority", element.getPriorityElement(), -1);
        }
        for (i = 0; i < element.getCode().size(); ++i) {
            this.composeCodeableConcept(t, "PlanDefinition", "code", element.getCode().get(i), i);
        }
        for (i = 0; i < element.getReason().size(); ++i) {
            this.composeCodeableConcept(t, "PlanDefinition", "reason", element.getReason().get(i), i);
        }
        for (i = 0; i < element.getDocumentation().size(); ++i) {
            this.composeRelatedArtifact(t, "PlanDefinition", "documentation", element.getDocumentation().get(i), i);
        }
        for (i = 0; i < element.getGoalId().size(); ++i) {
            this.composeId(t, "PlanDefinition", "goalId", element.getGoalId().get(i), i);
        }
        if (element.hasSubject()) {
            this.composeType(t, "PlanDefinition", "subject", element.getSubject(), -1);
        }
        for (i = 0; i < element.getTrigger().size(); ++i) {
            this.composeTriggerDefinition(t, "PlanDefinition", "trigger", element.getTrigger().get(i), i);
        }
        for (i = 0; i < element.getCondition().size(); ++i) {
            this.composePlanDefinitionPlanDefinitionActionConditionComponent(t, "PlanDefinition", "condition", element.getCondition().get(i), i);
        }
        for (i = 0; i < element.getInput().size(); ++i) {
            this.composeDataRequirement(t, "PlanDefinition", "input", element.getInput().get(i), i);
        }
        for (i = 0; i < element.getOutput().size(); ++i) {
            this.composeDataRequirement(t, "PlanDefinition", "output", element.getOutput().get(i), i);
        }
        for (i = 0; i < element.getRelatedAction().size(); ++i) {
            this.composePlanDefinitionPlanDefinitionActionRelatedActionComponent(t, "PlanDefinition", "relatedAction", element.getRelatedAction().get(i), i);
        }
        if (element.hasTiming()) {
            this.composeType(t, "PlanDefinition", "timing", element.getTiming(), -1);
        }
        for (i = 0; i < element.getParticipant().size(); ++i) {
            this.composePlanDefinitionPlanDefinitionActionParticipantComponent(t, "PlanDefinition", "participant", element.getParticipant().get(i), i);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "PlanDefinition", "type", element.getType(), -1);
        }
        if (element.hasGroupingBehaviorElement()) {
            this.composeEnum(t, "PlanDefinition", "groupingBehavior", element.getGroupingBehaviorElement(), -1);
        }
        if (element.hasSelectionBehaviorElement()) {
            this.composeEnum(t, "PlanDefinition", "selectionBehavior", element.getSelectionBehaviorElement(), -1);
        }
        if (element.hasRequiredBehaviorElement()) {
            this.composeEnum(t, "PlanDefinition", "requiredBehavior", element.getRequiredBehaviorElement(), -1);
        }
        if (element.hasPrecheckBehaviorElement()) {
            this.composeEnum(t, "PlanDefinition", "precheckBehavior", element.getPrecheckBehaviorElement(), -1);
        }
        if (element.hasCardinalityBehaviorElement()) {
            this.composeEnum(t, "PlanDefinition", "cardinalityBehavior", element.getCardinalityBehaviorElement(), -1);
        }
        if (element.hasDefinition()) {
            this.composeType(t, "PlanDefinition", "definition", element.getDefinition(), -1);
        }
        if (element.hasTransformElement()) {
            this.composeCanonical(t, "PlanDefinition", "transform", element.getTransformElement(), -1);
        }
        for (i = 0; i < element.getDynamicValue().size(); ++i) {
            this.composePlanDefinitionPlanDefinitionActionDynamicValueComponent(t, "PlanDefinition", "dynamicValue", element.getDynamicValue().get(i), i);
        }
        for (i = 0; i < element.getAction().size(); ++i) {
            this.composePlanDefinitionPlanDefinitionActionComponent(t, "PlanDefinition", "action", element.getAction().get(i), i);
        }
    }

    protected void composePlanDefinitionPlanDefinitionActionConditionComponent(Turtle.Complex parent, String parentType, String name, PlanDefinition.PlanDefinitionActionConditionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "condition", name, element, index);
        if (element.hasKindElement()) {
            this.composeEnum(t, "PlanDefinition", "kind", element.getKindElement(), -1);
        }
        if (element.hasExpression()) {
            this.composeExpression(t, "PlanDefinition", "expression", element.getExpression(), -1);
        }
    }

    protected void composePlanDefinitionPlanDefinitionActionRelatedActionComponent(Turtle.Complex parent, String parentType, String name, PlanDefinition.PlanDefinitionActionRelatedActionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "relatedAction", name, element, index);
        if (element.hasActionIdElement()) {
            this.composeId(t, "PlanDefinition", "actionId", element.getActionIdElement(), -1);
        }
        if (element.hasRelationshipElement()) {
            this.composeEnum(t, "PlanDefinition", "relationship", element.getRelationshipElement(), -1);
        }
        if (element.hasOffset()) {
            this.composeType(t, "PlanDefinition", "offset", element.getOffset(), -1);
        }
    }

    protected void composePlanDefinitionPlanDefinitionActionParticipantComponent(Turtle.Complex parent, String parentType, String name, PlanDefinition.PlanDefinitionActionParticipantComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "participant", name, element, index);
        if (element.hasTypeElement()) {
            this.composeEnum(t, "PlanDefinition", "type", element.getTypeElement(), -1);
        }
        if (element.hasRole()) {
            this.composeCodeableConcept(t, "PlanDefinition", "role", element.getRole(), -1);
        }
    }

    protected void composePlanDefinitionPlanDefinitionActionDynamicValueComponent(Turtle.Complex parent, String parentType, String name, PlanDefinition.PlanDefinitionActionDynamicValueComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "dynamicValue", name, element, index);
        if (element.hasPathElement()) {
            this.composeString(t, "PlanDefinition", "path", element.getPathElement(), -1);
        }
        if (element.hasExpression()) {
            this.composeExpression(t, "PlanDefinition", "expression", element.getExpression(), -1);
        }
    }

    protected void composePractitioner(Turtle.Complex parent, String parentType, String name, Practitioner element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Practitioner", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Practitioner", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasActiveElement()) {
            this.composeBoolean(t, "Practitioner", "active", element.getActiveElement(), -1);
        }
        for (i = 0; i < element.getName().size(); ++i) {
            this.composeHumanName(t, "Practitioner", "name", element.getName().get(i), i);
        }
        for (i = 0; i < element.getTelecom().size(); ++i) {
            this.composeContactPoint(t, "Practitioner", "telecom", element.getTelecom().get(i), i);
        }
        for (i = 0; i < element.getAddress().size(); ++i) {
            this.composeAddress(t, "Practitioner", "address", element.getAddress().get(i), i);
        }
        if (element.hasGenderElement()) {
            this.composeEnum(t, "Practitioner", "gender", element.getGenderElement(), -1);
        }
        if (element.hasBirthDateElement()) {
            this.composeDate(t, "Practitioner", "birthDate", element.getBirthDateElement(), -1);
        }
        for (i = 0; i < element.getPhoto().size(); ++i) {
            this.composeAttachment(t, "Practitioner", "photo", element.getPhoto().get(i), i);
        }
        for (i = 0; i < element.getQualification().size(); ++i) {
            this.composePractitionerPractitionerQualificationComponent(t, "Practitioner", "qualification", element.getQualification().get(i), i);
        }
        for (i = 0; i < element.getCommunication().size(); ++i) {
            this.composeCodeableConcept(t, "Practitioner", "communication", element.getCommunication().get(i), i);
        }
    }

    protected void composePractitionerPractitionerQualificationComponent(Turtle.Complex parent, String parentType, String name, Practitioner.PractitionerQualificationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "qualification", name, element, index);
        for (int i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Practitioner", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "Practitioner", "code", element.getCode(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "Practitioner", "period", element.getPeriod(), -1);
        }
        if (element.hasIssuer()) {
            this.composeReference(t, "Practitioner", "issuer", element.getIssuer(), -1);
        }
    }

    protected void composePractitionerRole(Turtle.Complex parent, String parentType, String name, PractitionerRole element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "PractitionerRole", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "PractitionerRole", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasActiveElement()) {
            this.composeBoolean(t, "PractitionerRole", "active", element.getActiveElement(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "PractitionerRole", "period", element.getPeriod(), -1);
        }
        if (element.hasPractitioner()) {
            this.composeReference(t, "PractitionerRole", "practitioner", element.getPractitioner(), -1);
        }
        if (element.hasOrganization()) {
            this.composeReference(t, "PractitionerRole", "organization", element.getOrganization(), -1);
        }
        for (i = 0; i < element.getCode().size(); ++i) {
            this.composeCodeableConcept(t, "PractitionerRole", "code", element.getCode().get(i), i);
        }
        for (i = 0; i < element.getSpecialty().size(); ++i) {
            this.composeCodeableConcept(t, "PractitionerRole", "specialty", element.getSpecialty().get(i), i);
        }
        for (i = 0; i < element.getLocation().size(); ++i) {
            this.composeReference(t, "PractitionerRole", "location", element.getLocation().get(i), i);
        }
        for (i = 0; i < element.getHealthcareService().size(); ++i) {
            this.composeReference(t, "PractitionerRole", "healthcareService", element.getHealthcareService().get(i), i);
        }
        for (i = 0; i < element.getTelecom().size(); ++i) {
            this.composeContactPoint(t, "PractitionerRole", "telecom", element.getTelecom().get(i), i);
        }
        for (i = 0; i < element.getAvailableTime().size(); ++i) {
            this.composePractitionerRolePractitionerRoleAvailableTimeComponent(t, "PractitionerRole", "availableTime", element.getAvailableTime().get(i), i);
        }
        for (i = 0; i < element.getNotAvailable().size(); ++i) {
            this.composePractitionerRolePractitionerRoleNotAvailableComponent(t, "PractitionerRole", "notAvailable", element.getNotAvailable().get(i), i);
        }
        if (element.hasAvailabilityExceptionsElement()) {
            this.composeString(t, "PractitionerRole", "availabilityExceptions", element.getAvailabilityExceptionsElement(), -1);
        }
        for (i = 0; i < element.getEndpoint().size(); ++i) {
            this.composeReference(t, "PractitionerRole", "endpoint", element.getEndpoint().get(i), i);
        }
    }

    protected void composePractitionerRolePractitionerRoleAvailableTimeComponent(Turtle.Complex parent, String parentType, String name, PractitionerRole.PractitionerRoleAvailableTimeComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "availableTime", name, element, index);
        for (int i = 0; i < element.getDaysOfWeek().size(); ++i) {
            this.composeEnum(t, "PractitionerRole", "daysOfWeek", element.getDaysOfWeek().get(i), i);
        }
        if (element.hasAllDayElement()) {
            this.composeBoolean(t, "PractitionerRole", "allDay", element.getAllDayElement(), -1);
        }
        if (element.hasAvailableStartTimeElement()) {
            this.composeTime(t, "PractitionerRole", "availableStartTime", element.getAvailableStartTimeElement(), -1);
        }
        if (element.hasAvailableEndTimeElement()) {
            this.composeTime(t, "PractitionerRole", "availableEndTime", element.getAvailableEndTimeElement(), -1);
        }
    }

    protected void composePractitionerRolePractitionerRoleNotAvailableComponent(Turtle.Complex parent, String parentType, String name, PractitionerRole.PractitionerRoleNotAvailableComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "notAvailable", name, element, index);
        if (element.hasDescriptionElement()) {
            this.composeString(t, "PractitionerRole", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasDuring()) {
            this.composePeriod(t, "PractitionerRole", "during", element.getDuring(), -1);
        }
    }

    protected void composeProcedure(Turtle.Complex parent, String parentType, String name, Procedure element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Procedure", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Procedure", "identifier", element.getIdentifier().get(i), i);
        }
        for (i = 0; i < element.getInstantiatesCanonical().size(); ++i) {
            this.composeCanonical(t, "Procedure", "instantiatesCanonical", element.getInstantiatesCanonical().get(i), i);
        }
        for (i = 0; i < element.getInstantiatesUri().size(); ++i) {
            this.composeUri(t, "Procedure", "instantiatesUri", element.getInstantiatesUri().get(i), i);
        }
        for (i = 0; i < element.getBasedOn().size(); ++i) {
            this.composeReference(t, "Procedure", "basedOn", element.getBasedOn().get(i), i);
        }
        for (i = 0; i < element.getPartOf().size(); ++i) {
            this.composeReference(t, "Procedure", "partOf", element.getPartOf().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Procedure", "status", element.getStatusElement(), -1);
        }
        if (element.hasStatusReason()) {
            this.composeCodeableConcept(t, "Procedure", "statusReason", element.getStatusReason(), -1);
        }
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "Procedure", "category", element.getCategory(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "Procedure", "code", element.getCode(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "Procedure", "subject", element.getSubject(), -1);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "Procedure", "encounter", element.getEncounter(), -1);
        }
        if (element.hasPerformed()) {
            this.composeType(t, "Procedure", "performed", element.getPerformed(), -1);
        }
        if (element.hasRecorder()) {
            this.composeReference(t, "Procedure", "recorder", element.getRecorder(), -1);
        }
        if (element.hasAsserter()) {
            this.composeReference(t, "Procedure", "asserter", element.getAsserter(), -1);
        }
        for (i = 0; i < element.getPerformer().size(); ++i) {
            this.composeProcedureProcedurePerformerComponent(t, "Procedure", "performer", element.getPerformer().get(i), i);
        }
        if (element.hasLocation()) {
            this.composeReference(t, "Procedure", "location", element.getLocation(), -1);
        }
        for (i = 0; i < element.getReasonCode().size(); ++i) {
            this.composeCodeableConcept(t, "Procedure", "reasonCode", element.getReasonCode().get(i), i);
        }
        for (i = 0; i < element.getReasonReference().size(); ++i) {
            this.composeReference(t, "Procedure", "reasonReference", element.getReasonReference().get(i), i);
        }
        for (i = 0; i < element.getBodySite().size(); ++i) {
            this.composeCodeableConcept(t, "Procedure", "bodySite", element.getBodySite().get(i), i);
        }
        if (element.hasOutcome()) {
            this.composeCodeableConcept(t, "Procedure", "outcome", element.getOutcome(), -1);
        }
        for (i = 0; i < element.getReport().size(); ++i) {
            this.composeReference(t, "Procedure", "report", element.getReport().get(i), i);
        }
        for (i = 0; i < element.getComplication().size(); ++i) {
            this.composeCodeableConcept(t, "Procedure", "complication", element.getComplication().get(i), i);
        }
        for (i = 0; i < element.getComplicationDetail().size(); ++i) {
            this.composeReference(t, "Procedure", "complicationDetail", element.getComplicationDetail().get(i), i);
        }
        for (i = 0; i < element.getFollowUp().size(); ++i) {
            this.composeCodeableConcept(t, "Procedure", "followUp", element.getFollowUp().get(i), i);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "Procedure", "note", element.getNote().get(i), i);
        }
        for (i = 0; i < element.getFocalDevice().size(); ++i) {
            this.composeProcedureProcedureFocalDeviceComponent(t, "Procedure", "focalDevice", element.getFocalDevice().get(i), i);
        }
        for (i = 0; i < element.getUsedReference().size(); ++i) {
            this.composeReference(t, "Procedure", "usedReference", element.getUsedReference().get(i), i);
        }
        for (i = 0; i < element.getUsedCode().size(); ++i) {
            this.composeCodeableConcept(t, "Procedure", "usedCode", element.getUsedCode().get(i), i);
        }
    }

    protected void composeProcedureProcedurePerformerComponent(Turtle.Complex parent, String parentType, String name, Procedure.ProcedurePerformerComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "performer", name, element, index);
        if (element.hasFunction()) {
            this.composeCodeableConcept(t, "Procedure", "function", element.getFunction(), -1);
        }
        if (element.hasActor()) {
            this.composeReference(t, "Procedure", "actor", element.getActor(), -1);
        }
        if (element.hasOnBehalfOf()) {
            this.composeReference(t, "Procedure", "onBehalfOf", element.getOnBehalfOf(), -1);
        }
    }

    protected void composeProcedureProcedureFocalDeviceComponent(Turtle.Complex parent, String parentType, String name, Procedure.ProcedureFocalDeviceComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "focalDevice", name, element, index);
        if (element.hasAction()) {
            this.composeCodeableConcept(t, "Procedure", "action", element.getAction(), -1);
        }
        if (element.hasManipulated()) {
            this.composeReference(t, "Procedure", "manipulated", element.getManipulated(), -1);
        }
    }

    protected void composeProvenance(Turtle.Complex parent, String parentType, String name, Provenance element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Provenance", name, element, index);
        for (i = 0; i < element.getTarget().size(); ++i) {
            this.composeReference(t, "Provenance", "target", element.getTarget().get(i), i);
        }
        if (element.hasOccurred()) {
            this.composeType(t, "Provenance", "occurred", element.getOccurred(), -1);
        }
        if (element.hasRecordedElement()) {
            this.composeInstant(t, "Provenance", "recorded", element.getRecordedElement(), -1);
        }
        for (i = 0; i < element.getPolicy().size(); ++i) {
            this.composeUri(t, "Provenance", "policy", element.getPolicy().get(i), i);
        }
        if (element.hasLocation()) {
            this.composeReference(t, "Provenance", "location", element.getLocation(), -1);
        }
        for (i = 0; i < element.getReason().size(); ++i) {
            this.composeCodeableConcept(t, "Provenance", "reason", element.getReason().get(i), i);
        }
        if (element.hasActivity()) {
            this.composeCodeableConcept(t, "Provenance", "activity", element.getActivity(), -1);
        }
        for (i = 0; i < element.getAgent().size(); ++i) {
            this.composeProvenanceProvenanceAgentComponent(t, "Provenance", "agent", element.getAgent().get(i), i);
        }
        for (i = 0; i < element.getEntity().size(); ++i) {
            this.composeProvenanceProvenanceEntityComponent(t, "Provenance", "entity", element.getEntity().get(i), i);
        }
        for (i = 0; i < element.getSignature().size(); ++i) {
            this.composeSignature(t, "Provenance", "signature", element.getSignature().get(i), i);
        }
    }

    protected void composeProvenanceProvenanceAgentComponent(Turtle.Complex parent, String parentType, String name, Provenance.ProvenanceAgentComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "agent", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "Provenance", "type", element.getType(), -1);
        }
        for (int i = 0; i < element.getRole().size(); ++i) {
            this.composeCodeableConcept(t, "Provenance", "role", element.getRole().get(i), i);
        }
        if (element.hasWho()) {
            this.composeReference(t, "Provenance", "who", element.getWho(), -1);
        }
        if (element.hasOnBehalfOf()) {
            this.composeReference(t, "Provenance", "onBehalfOf", element.getOnBehalfOf(), -1);
        }
    }

    protected void composeProvenanceProvenanceEntityComponent(Turtle.Complex parent, String parentType, String name, Provenance.ProvenanceEntityComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "entity", name, element, index);
        if (element.hasRoleElement()) {
            this.composeEnum(t, "Provenance", "role", element.getRoleElement(), -1);
        }
        if (element.hasWhat()) {
            this.composeReference(t, "Provenance", "what", element.getWhat(), -1);
        }
        for (int i = 0; i < element.getAgent().size(); ++i) {
            this.composeProvenanceProvenanceAgentComponent(t, "Provenance", "agent", element.getAgent().get(i), i);
        }
    }

    protected void composeQuestionnaire(Turtle.Complex parent, String parentType, String name, Questionnaire element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Questionnaire", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "Questionnaire", "url", element.getUrlElement(), -1);
        }
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Questionnaire", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "Questionnaire", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "Questionnaire", "name", element.getNameElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "Questionnaire", "title", element.getTitleElement(), -1);
        }
        for (i = 0; i < element.getDerivedFrom().size(); ++i) {
            this.composeCanonical(t, "Questionnaire", "derivedFrom", element.getDerivedFrom().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Questionnaire", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "Questionnaire", "experimental", element.getExperimentalElement(), -1);
        }
        for (i = 0; i < element.getSubjectType().size(); ++i) {
            this.composeCode(t, "Questionnaire", "subjectType", element.getSubjectType().get(i), i);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "Questionnaire", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "Questionnaire", "publisher", element.getPublisherElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeContactDetail(t, "Questionnaire", "contact", element.getContact().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "Questionnaire", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getUseContext().size(); ++i) {
            this.composeUsageContext(t, "Questionnaire", "useContext", element.getUseContext().get(i), i);
        }
        for (i = 0; i < element.getJurisdiction().size(); ++i) {
            this.composeCodeableConcept(t, "Questionnaire", "jurisdiction", element.getJurisdiction().get(i), i);
        }
        if (element.hasPurposeElement()) {
            this.composeMarkdown(t, "Questionnaire", "purpose", element.getPurposeElement(), -1);
        }
        if (element.hasCopyrightElement()) {
            this.composeMarkdown(t, "Questionnaire", "copyright", element.getCopyrightElement(), -1);
        }
        if (element.hasApprovalDateElement()) {
            this.composeDate(t, "Questionnaire", "approvalDate", element.getApprovalDateElement(), -1);
        }
        if (element.hasLastReviewDateElement()) {
            this.composeDate(t, "Questionnaire", "lastReviewDate", element.getLastReviewDateElement(), -1);
        }
        if (element.hasEffectivePeriod()) {
            this.composePeriod(t, "Questionnaire", "effectivePeriod", element.getEffectivePeriod(), -1);
        }
        for (i = 0; i < element.getCode().size(); ++i) {
            this.composeCoding(t, "Questionnaire", "code", element.getCode().get(i), i);
        }
        for (i = 0; i < element.getItem().size(); ++i) {
            this.composeQuestionnaireQuestionnaireItemComponent(t, "Questionnaire", "item", element.getItem().get(i), i);
        }
    }

    protected void composeQuestionnaireQuestionnaireItemComponent(Turtle.Complex parent, String parentType, String name, Questionnaire.QuestionnaireItemComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "item", name, element, index);
        if (element.hasLinkIdElement()) {
            this.composeString(t, "Questionnaire", "linkId", element.getLinkIdElement(), -1);
        }
        if (element.hasDefinitionElement()) {
            this.composeUri(t, "Questionnaire", "definition", element.getDefinitionElement(), -1);
        }
        for (i = 0; i < element.getCode().size(); ++i) {
            this.composeCoding(t, "Questionnaire", "code", element.getCode().get(i), i);
        }
        if (element.hasPrefixElement()) {
            this.composeString(t, "Questionnaire", "prefix", element.getPrefixElement(), -1);
        }
        if (element.hasTextElement()) {
            this.composeString(t, "Questionnaire", "text", element.getTextElement(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeEnum(t, "Questionnaire", "type", element.getTypeElement(), -1);
        }
        for (i = 0; i < element.getEnableWhen().size(); ++i) {
            this.composeQuestionnaireQuestionnaireItemEnableWhenComponent(t, "Questionnaire", "enableWhen", element.getEnableWhen().get(i), i);
        }
        if (element.hasEnableBehaviorElement()) {
            this.composeEnum(t, "Questionnaire", "enableBehavior", element.getEnableBehaviorElement(), -1);
        }
        if (element.hasRequiredElement()) {
            this.composeBoolean(t, "Questionnaire", "required", element.getRequiredElement(), -1);
        }
        if (element.hasRepeatsElement()) {
            this.composeBoolean(t, "Questionnaire", "repeats", element.getRepeatsElement(), -1);
        }
        if (element.hasReadOnlyElement()) {
            this.composeBoolean(t, "Questionnaire", "readOnly", element.getReadOnlyElement(), -1);
        }
        if (element.hasMaxLengthElement()) {
            this.composeInteger(t, "Questionnaire", "maxLength", element.getMaxLengthElement(), -1);
        }
        if (element.hasAnswerValueSetElement()) {
            this.composeCanonical(t, "Questionnaire", "answerValueSet", element.getAnswerValueSetElement(), -1);
        }
        for (i = 0; i < element.getAnswerOption().size(); ++i) {
            this.composeQuestionnaireQuestionnaireItemAnswerOptionComponent(t, "Questionnaire", "answerOption", element.getAnswerOption().get(i), i);
        }
        for (i = 0; i < element.getInitial().size(); ++i) {
            this.composeQuestionnaireQuestionnaireItemInitialComponent(t, "Questionnaire", "initial", element.getInitial().get(i), i);
        }
        for (i = 0; i < element.getItem().size(); ++i) {
            this.composeQuestionnaireQuestionnaireItemComponent(t, "Questionnaire", "item", element.getItem().get(i), i);
        }
    }

    protected void composeQuestionnaireQuestionnaireItemEnableWhenComponent(Turtle.Complex parent, String parentType, String name, Questionnaire.QuestionnaireItemEnableWhenComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "enableWhen", name, element, index);
        if (element.hasQuestionElement()) {
            this.composeString(t, "Questionnaire", "question", element.getQuestionElement(), -1);
        }
        if (element.hasOperatorElement()) {
            this.composeEnum(t, "Questionnaire", "operator", element.getOperatorElement(), -1);
        }
        if (element.hasAnswer()) {
            this.composeType(t, "Questionnaire", "answer", element.getAnswer(), -1);
        }
    }

    protected void composeQuestionnaireQuestionnaireItemAnswerOptionComponent(Turtle.Complex parent, String parentType, String name, Questionnaire.QuestionnaireItemAnswerOptionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "answerOption", name, element, index);
        if (element.hasValue()) {
            this.composeType(t, "Questionnaire", "value", element.getValue(), -1);
        }
        if (element.hasInitialSelectedElement()) {
            this.composeBoolean(t, "Questionnaire", "initialSelected", element.getInitialSelectedElement(), -1);
        }
    }

    protected void composeQuestionnaireQuestionnaireItemInitialComponent(Turtle.Complex parent, String parentType, String name, Questionnaire.QuestionnaireItemInitialComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "initial", name, element, index);
        if (element.hasValue()) {
            this.composeType(t, "Questionnaire", "value", element.getValue(), -1);
        }
    }

    protected void composeQuestionnaireResponse(Turtle.Complex parent, String parentType, String name, QuestionnaireResponse element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "QuestionnaireResponse", name, element, index);
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "QuestionnaireResponse", "identifier", element.getIdentifier(), -1);
        }
        for (i = 0; i < element.getBasedOn().size(); ++i) {
            this.composeReference(t, "QuestionnaireResponse", "basedOn", element.getBasedOn().get(i), i);
        }
        for (i = 0; i < element.getPartOf().size(); ++i) {
            this.composeReference(t, "QuestionnaireResponse", "partOf", element.getPartOf().get(i), i);
        }
        if (element.hasQuestionnaireElement()) {
            this.composeCanonical(t, "QuestionnaireResponse", "questionnaire", element.getQuestionnaireElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "QuestionnaireResponse", "status", element.getStatusElement(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "QuestionnaireResponse", "subject", element.getSubject(), -1);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "QuestionnaireResponse", "encounter", element.getEncounter(), -1);
        }
        if (element.hasAuthoredElement()) {
            this.composeDateTime(t, "QuestionnaireResponse", "authored", element.getAuthoredElement(), -1);
        }
        if (element.hasAuthor()) {
            this.composeReference(t, "QuestionnaireResponse", "author", element.getAuthor(), -1);
        }
        if (element.hasSource()) {
            this.composeReference(t, "QuestionnaireResponse", "source", element.getSource(), -1);
        }
        for (i = 0; i < element.getItem().size(); ++i) {
            this.composeQuestionnaireResponseQuestionnaireResponseItemComponent(t, "QuestionnaireResponse", "item", element.getItem().get(i), i);
        }
    }

    protected void composeQuestionnaireResponseQuestionnaireResponseItemComponent(Turtle.Complex parent, String parentType, String name, QuestionnaireResponse.QuestionnaireResponseItemComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "item", name, element, index);
        if (element.hasLinkIdElement()) {
            this.composeString(t, "QuestionnaireResponse", "linkId", element.getLinkIdElement(), -1);
        }
        if (element.hasDefinitionElement()) {
            this.composeUri(t, "QuestionnaireResponse", "definition", element.getDefinitionElement(), -1);
        }
        if (element.hasTextElement()) {
            this.composeString(t, "QuestionnaireResponse", "text", element.getTextElement(), -1);
        }
        for (i = 0; i < element.getAnswer().size(); ++i) {
            this.composeQuestionnaireResponseQuestionnaireResponseItemAnswerComponent(t, "QuestionnaireResponse", "answer", element.getAnswer().get(i), i);
        }
        for (i = 0; i < element.getItem().size(); ++i) {
            this.composeQuestionnaireResponseQuestionnaireResponseItemComponent(t, "QuestionnaireResponse", "item", element.getItem().get(i), i);
        }
    }

    protected void composeQuestionnaireResponseQuestionnaireResponseItemAnswerComponent(Turtle.Complex parent, String parentType, String name, QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "answer", name, element, index);
        if (element.hasValue()) {
            this.composeType(t, "QuestionnaireResponse", "value", element.getValue(), -1);
        }
        for (int i = 0; i < element.getItem().size(); ++i) {
            this.composeQuestionnaireResponseQuestionnaireResponseItemComponent(t, "QuestionnaireResponse", "item", element.getItem().get(i), i);
        }
    }

    protected void composeRelatedPerson(Turtle.Complex parent, String parentType, String name, RelatedPerson element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "RelatedPerson", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "RelatedPerson", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasActiveElement()) {
            this.composeBoolean(t, "RelatedPerson", "active", element.getActiveElement(), -1);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "RelatedPerson", "patient", element.getPatient(), -1);
        }
        for (i = 0; i < element.getRelationship().size(); ++i) {
            this.composeCodeableConcept(t, "RelatedPerson", "relationship", element.getRelationship().get(i), i);
        }
        for (i = 0; i < element.getName().size(); ++i) {
            this.composeHumanName(t, "RelatedPerson", "name", element.getName().get(i), i);
        }
        for (i = 0; i < element.getTelecom().size(); ++i) {
            this.composeContactPoint(t, "RelatedPerson", "telecom", element.getTelecom().get(i), i);
        }
        if (element.hasGenderElement()) {
            this.composeEnum(t, "RelatedPerson", "gender", element.getGenderElement(), -1);
        }
        if (element.hasBirthDateElement()) {
            this.composeDate(t, "RelatedPerson", "birthDate", element.getBirthDateElement(), -1);
        }
        for (i = 0; i < element.getAddress().size(); ++i) {
            this.composeAddress(t, "RelatedPerson", "address", element.getAddress().get(i), i);
        }
        for (i = 0; i < element.getPhoto().size(); ++i) {
            this.composeAttachment(t, "RelatedPerson", "photo", element.getPhoto().get(i), i);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "RelatedPerson", "period", element.getPeriod(), -1);
        }
        for (i = 0; i < element.getCommunication().size(); ++i) {
            this.composeRelatedPersonRelatedPersonCommunicationComponent(t, "RelatedPerson", "communication", element.getCommunication().get(i), i);
        }
    }

    protected void composeRelatedPersonRelatedPersonCommunicationComponent(Turtle.Complex parent, String parentType, String name, RelatedPerson.RelatedPersonCommunicationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "communication", name, element, index);
        if (element.hasLanguage()) {
            this.composeCodeableConcept(t, "RelatedPerson", "language", element.getLanguage(), -1);
        }
        if (element.hasPreferredElement()) {
            this.composeBoolean(t, "RelatedPerson", "preferred", element.getPreferredElement(), -1);
        }
    }

    protected void composeRequestGroup(Turtle.Complex parent, String parentType, String name, RequestGroup element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "RequestGroup", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "RequestGroup", "identifier", element.getIdentifier().get(i), i);
        }
        for (i = 0; i < element.getInstantiatesCanonical().size(); ++i) {
            this.composeCanonical(t, "RequestGroup", "instantiatesCanonical", element.getInstantiatesCanonical().get(i), i);
        }
        for (i = 0; i < element.getInstantiatesUri().size(); ++i) {
            this.composeUri(t, "RequestGroup", "instantiatesUri", element.getInstantiatesUri().get(i), i);
        }
        for (i = 0; i < element.getBasedOn().size(); ++i) {
            this.composeReference(t, "RequestGroup", "basedOn", element.getBasedOn().get(i), i);
        }
        for (i = 0; i < element.getReplaces().size(); ++i) {
            this.composeReference(t, "RequestGroup", "replaces", element.getReplaces().get(i), i);
        }
        if (element.hasGroupIdentifier()) {
            this.composeIdentifier(t, "RequestGroup", "groupIdentifier", element.getGroupIdentifier(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "RequestGroup", "status", element.getStatusElement(), -1);
        }
        if (element.hasIntentElement()) {
            this.composeEnum(t, "RequestGroup", "intent", element.getIntentElement(), -1);
        }
        if (element.hasPriorityElement()) {
            this.composeEnum(t, "RequestGroup", "priority", element.getPriorityElement(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "RequestGroup", "code", element.getCode(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "RequestGroup", "subject", element.getSubject(), -1);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "RequestGroup", "encounter", element.getEncounter(), -1);
        }
        if (element.hasAuthoredOnElement()) {
            this.composeDateTime(t, "RequestGroup", "authoredOn", element.getAuthoredOnElement(), -1);
        }
        if (element.hasAuthor()) {
            this.composeReference(t, "RequestGroup", "author", element.getAuthor(), -1);
        }
        for (i = 0; i < element.getReasonCode().size(); ++i) {
            this.composeCodeableConcept(t, "RequestGroup", "reasonCode", element.getReasonCode().get(i), i);
        }
        for (i = 0; i < element.getReasonReference().size(); ++i) {
            this.composeReference(t, "RequestGroup", "reasonReference", element.getReasonReference().get(i), i);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "RequestGroup", "note", element.getNote().get(i), i);
        }
        for (i = 0; i < element.getAction().size(); ++i) {
            this.composeRequestGroupRequestGroupActionComponent(t, "RequestGroup", "action", element.getAction().get(i), i);
        }
    }

    protected void composeRequestGroupRequestGroupActionComponent(Turtle.Complex parent, String parentType, String name, RequestGroup.RequestGroupActionComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "action", name, element, index);
        if (element.hasPrefixElement()) {
            this.composeString(t, "RequestGroup", "prefix", element.getPrefixElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "RequestGroup", "title", element.getTitleElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "RequestGroup", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasTextEquivalentElement()) {
            this.composeString(t, "RequestGroup", "textEquivalent", element.getTextEquivalentElement(), -1);
        }
        if (element.hasPriorityElement()) {
            this.composeEnum(t, "RequestGroup", "priority", element.getPriorityElement(), -1);
        }
        for (i = 0; i < element.getCode().size(); ++i) {
            this.composeCodeableConcept(t, "RequestGroup", "code", element.getCode().get(i), i);
        }
        for (i = 0; i < element.getDocumentation().size(); ++i) {
            this.composeRelatedArtifact(t, "RequestGroup", "documentation", element.getDocumentation().get(i), i);
        }
        for (i = 0; i < element.getCondition().size(); ++i) {
            this.composeRequestGroupRequestGroupActionConditionComponent(t, "RequestGroup", "condition", element.getCondition().get(i), i);
        }
        for (i = 0; i < element.getRelatedAction().size(); ++i) {
            this.composeRequestGroupRequestGroupActionRelatedActionComponent(t, "RequestGroup", "relatedAction", element.getRelatedAction().get(i), i);
        }
        if (element.hasTiming()) {
            this.composeType(t, "RequestGroup", "timing", element.getTiming(), -1);
        }
        for (i = 0; i < element.getParticipant().size(); ++i) {
            this.composeReference(t, "RequestGroup", "participant", element.getParticipant().get(i), i);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "RequestGroup", "type", element.getType(), -1);
        }
        if (element.hasGroupingBehaviorElement()) {
            this.composeEnum(t, "RequestGroup", "groupingBehavior", element.getGroupingBehaviorElement(), -1);
        }
        if (element.hasSelectionBehaviorElement()) {
            this.composeEnum(t, "RequestGroup", "selectionBehavior", element.getSelectionBehaviorElement(), -1);
        }
        if (element.hasRequiredBehaviorElement()) {
            this.composeEnum(t, "RequestGroup", "requiredBehavior", element.getRequiredBehaviorElement(), -1);
        }
        if (element.hasPrecheckBehaviorElement()) {
            this.composeEnum(t, "RequestGroup", "precheckBehavior", element.getPrecheckBehaviorElement(), -1);
        }
        if (element.hasCardinalityBehaviorElement()) {
            this.composeEnum(t, "RequestGroup", "cardinalityBehavior", element.getCardinalityBehaviorElement(), -1);
        }
        if (element.hasResource()) {
            this.composeReference(t, "RequestGroup", "resource", element.getResource(), -1);
        }
        for (i = 0; i < element.getAction().size(); ++i) {
            this.composeRequestGroupRequestGroupActionComponent(t, "RequestGroup", "action", element.getAction().get(i), i);
        }
    }

    protected void composeRequestGroupRequestGroupActionConditionComponent(Turtle.Complex parent, String parentType, String name, RequestGroup.RequestGroupActionConditionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "condition", name, element, index);
        if (element.hasKindElement()) {
            this.composeEnum(t, "RequestGroup", "kind", element.getKindElement(), -1);
        }
        if (element.hasExpression()) {
            this.composeExpression(t, "RequestGroup", "expression", element.getExpression(), -1);
        }
    }

    protected void composeRequestGroupRequestGroupActionRelatedActionComponent(Turtle.Complex parent, String parentType, String name, RequestGroup.RequestGroupActionRelatedActionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "relatedAction", name, element, index);
        if (element.hasActionIdElement()) {
            this.composeId(t, "RequestGroup", "actionId", element.getActionIdElement(), -1);
        }
        if (element.hasRelationshipElement()) {
            this.composeEnum(t, "RequestGroup", "relationship", element.getRelationshipElement(), -1);
        }
        if (element.hasOffset()) {
            this.composeType(t, "RequestGroup", "offset", element.getOffset(), -1);
        }
    }

    protected void composeResearchDefinition(Turtle.Complex parent, String parentType, String name, ResearchDefinition element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "ResearchDefinition", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "ResearchDefinition", "url", element.getUrlElement(), -1);
        }
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "ResearchDefinition", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "ResearchDefinition", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "ResearchDefinition", "name", element.getNameElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "ResearchDefinition", "title", element.getTitleElement(), -1);
        }
        if (element.hasShortTitleElement()) {
            this.composeString(t, "ResearchDefinition", "shortTitle", element.getShortTitleElement(), -1);
        }
        if (element.hasSubtitleElement()) {
            this.composeString(t, "ResearchDefinition", "subtitle", element.getSubtitleElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "ResearchDefinition", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "ResearchDefinition", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasSubject()) {
            this.composeType(t, "ResearchDefinition", "subject", element.getSubject(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "ResearchDefinition", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "ResearchDefinition", "publisher", element.getPublisherElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeContactDetail(t, "ResearchDefinition", "contact", element.getContact().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "ResearchDefinition", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getComment().size(); ++i) {
            this.composeString(t, "ResearchDefinition", "comment", element.getComment().get(i), i);
        }
        for (i = 0; i < element.getUseContext().size(); ++i) {
            this.composeUsageContext(t, "ResearchDefinition", "useContext", element.getUseContext().get(i), i);
        }
        for (i = 0; i < element.getJurisdiction().size(); ++i) {
            this.composeCodeableConcept(t, "ResearchDefinition", "jurisdiction", element.getJurisdiction().get(i), i);
        }
        if (element.hasPurposeElement()) {
            this.composeMarkdown(t, "ResearchDefinition", "purpose", element.getPurposeElement(), -1);
        }
        if (element.hasUsageElement()) {
            this.composeString(t, "ResearchDefinition", "usage", element.getUsageElement(), -1);
        }
        if (element.hasCopyrightElement()) {
            this.composeMarkdown(t, "ResearchDefinition", "copyright", element.getCopyrightElement(), -1);
        }
        if (element.hasApprovalDateElement()) {
            this.composeDate(t, "ResearchDefinition", "approvalDate", element.getApprovalDateElement(), -1);
        }
        if (element.hasLastReviewDateElement()) {
            this.composeDate(t, "ResearchDefinition", "lastReviewDate", element.getLastReviewDateElement(), -1);
        }
        if (element.hasEffectivePeriod()) {
            this.composePeriod(t, "ResearchDefinition", "effectivePeriod", element.getEffectivePeriod(), -1);
        }
        for (i = 0; i < element.getTopic().size(); ++i) {
            this.composeCodeableConcept(t, "ResearchDefinition", "topic", element.getTopic().get(i), i);
        }
        for (i = 0; i < element.getAuthor().size(); ++i) {
            this.composeContactDetail(t, "ResearchDefinition", "author", element.getAuthor().get(i), i);
        }
        for (i = 0; i < element.getEditor().size(); ++i) {
            this.composeContactDetail(t, "ResearchDefinition", "editor", element.getEditor().get(i), i);
        }
        for (i = 0; i < element.getReviewer().size(); ++i) {
            this.composeContactDetail(t, "ResearchDefinition", "reviewer", element.getReviewer().get(i), i);
        }
        for (i = 0; i < element.getEndorser().size(); ++i) {
            this.composeContactDetail(t, "ResearchDefinition", "endorser", element.getEndorser().get(i), i);
        }
        for (i = 0; i < element.getRelatedArtifact().size(); ++i) {
            this.composeRelatedArtifact(t, "ResearchDefinition", "relatedArtifact", element.getRelatedArtifact().get(i), i);
        }
        for (i = 0; i < element.getLibrary().size(); ++i) {
            this.composeCanonical(t, "ResearchDefinition", "library", element.getLibrary().get(i), i);
        }
        if (element.hasPopulation()) {
            this.composeReference(t, "ResearchDefinition", "population", element.getPopulation(), -1);
        }
        if (element.hasExposure()) {
            this.composeReference(t, "ResearchDefinition", "exposure", element.getExposure(), -1);
        }
        if (element.hasExposureAlternative()) {
            this.composeReference(t, "ResearchDefinition", "exposureAlternative", element.getExposureAlternative(), -1);
        }
        if (element.hasOutcome()) {
            this.composeReference(t, "ResearchDefinition", "outcome", element.getOutcome(), -1);
        }
    }

    protected void composeResearchElementDefinition(Turtle.Complex parent, String parentType, String name, ResearchElementDefinition element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "ResearchElementDefinition", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "ResearchElementDefinition", "url", element.getUrlElement(), -1);
        }
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "ResearchElementDefinition", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "ResearchElementDefinition", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "ResearchElementDefinition", "name", element.getNameElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "ResearchElementDefinition", "title", element.getTitleElement(), -1);
        }
        if (element.hasShortTitleElement()) {
            this.composeString(t, "ResearchElementDefinition", "shortTitle", element.getShortTitleElement(), -1);
        }
        if (element.hasSubtitleElement()) {
            this.composeString(t, "ResearchElementDefinition", "subtitle", element.getSubtitleElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "ResearchElementDefinition", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "ResearchElementDefinition", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasSubject()) {
            this.composeType(t, "ResearchElementDefinition", "subject", element.getSubject(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "ResearchElementDefinition", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "ResearchElementDefinition", "publisher", element.getPublisherElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeContactDetail(t, "ResearchElementDefinition", "contact", element.getContact().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "ResearchElementDefinition", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getComment().size(); ++i) {
            this.composeString(t, "ResearchElementDefinition", "comment", element.getComment().get(i), i);
        }
        for (i = 0; i < element.getUseContext().size(); ++i) {
            this.composeUsageContext(t, "ResearchElementDefinition", "useContext", element.getUseContext().get(i), i);
        }
        for (i = 0; i < element.getJurisdiction().size(); ++i) {
            this.composeCodeableConcept(t, "ResearchElementDefinition", "jurisdiction", element.getJurisdiction().get(i), i);
        }
        if (element.hasPurposeElement()) {
            this.composeMarkdown(t, "ResearchElementDefinition", "purpose", element.getPurposeElement(), -1);
        }
        if (element.hasUsageElement()) {
            this.composeString(t, "ResearchElementDefinition", "usage", element.getUsageElement(), -1);
        }
        if (element.hasCopyrightElement()) {
            this.composeMarkdown(t, "ResearchElementDefinition", "copyright", element.getCopyrightElement(), -1);
        }
        if (element.hasApprovalDateElement()) {
            this.composeDate(t, "ResearchElementDefinition", "approvalDate", element.getApprovalDateElement(), -1);
        }
        if (element.hasLastReviewDateElement()) {
            this.composeDate(t, "ResearchElementDefinition", "lastReviewDate", element.getLastReviewDateElement(), -1);
        }
        if (element.hasEffectivePeriod()) {
            this.composePeriod(t, "ResearchElementDefinition", "effectivePeriod", element.getEffectivePeriod(), -1);
        }
        for (i = 0; i < element.getTopic().size(); ++i) {
            this.composeCodeableConcept(t, "ResearchElementDefinition", "topic", element.getTopic().get(i), i);
        }
        for (i = 0; i < element.getAuthor().size(); ++i) {
            this.composeContactDetail(t, "ResearchElementDefinition", "author", element.getAuthor().get(i), i);
        }
        for (i = 0; i < element.getEditor().size(); ++i) {
            this.composeContactDetail(t, "ResearchElementDefinition", "editor", element.getEditor().get(i), i);
        }
        for (i = 0; i < element.getReviewer().size(); ++i) {
            this.composeContactDetail(t, "ResearchElementDefinition", "reviewer", element.getReviewer().get(i), i);
        }
        for (i = 0; i < element.getEndorser().size(); ++i) {
            this.composeContactDetail(t, "ResearchElementDefinition", "endorser", element.getEndorser().get(i), i);
        }
        for (i = 0; i < element.getRelatedArtifact().size(); ++i) {
            this.composeRelatedArtifact(t, "ResearchElementDefinition", "relatedArtifact", element.getRelatedArtifact().get(i), i);
        }
        for (i = 0; i < element.getLibrary().size(); ++i) {
            this.composeCanonical(t, "ResearchElementDefinition", "library", element.getLibrary().get(i), i);
        }
        if (element.hasTypeElement()) {
            this.composeEnum(t, "ResearchElementDefinition", "type", element.getTypeElement(), -1);
        }
        if (element.hasVariableTypeElement()) {
            this.composeEnum(t, "ResearchElementDefinition", "variableType", element.getVariableTypeElement(), -1);
        }
        for (i = 0; i < element.getCharacteristic().size(); ++i) {
            this.composeResearchElementDefinitionResearchElementDefinitionCharacteristicComponent(t, "ResearchElementDefinition", "characteristic", element.getCharacteristic().get(i), i);
        }
    }

    protected void composeResearchElementDefinitionResearchElementDefinitionCharacteristicComponent(Turtle.Complex parent, String parentType, String name, ResearchElementDefinition.ResearchElementDefinitionCharacteristicComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "characteristic", name, element, index);
        if (element.hasDefinition()) {
            this.composeType(t, "ResearchElementDefinition", "definition", element.getDefinition(), -1);
        }
        for (int i = 0; i < element.getUsageContext().size(); ++i) {
            this.composeUsageContext(t, "ResearchElementDefinition", "usageContext", element.getUsageContext().get(i), i);
        }
        if (element.hasExcludeElement()) {
            this.composeBoolean(t, "ResearchElementDefinition", "exclude", element.getExcludeElement(), -1);
        }
        if (element.hasUnitOfMeasure()) {
            this.composeCodeableConcept(t, "ResearchElementDefinition", "unitOfMeasure", element.getUnitOfMeasure(), -1);
        }
        if (element.hasStudyEffectiveDescriptionElement()) {
            this.composeString(t, "ResearchElementDefinition", "studyEffectiveDescription", element.getStudyEffectiveDescriptionElement(), -1);
        }
        if (element.hasStudyEffective()) {
            this.composeType(t, "ResearchElementDefinition", "studyEffective", element.getStudyEffective(), -1);
        }
        if (element.hasStudyEffectiveTimeFromStart()) {
            this.composeDuration(t, "ResearchElementDefinition", "studyEffectiveTimeFromStart", element.getStudyEffectiveTimeFromStart(), -1);
        }
        if (element.hasStudyEffectiveGroupMeasureElement()) {
            this.composeEnum(t, "ResearchElementDefinition", "studyEffectiveGroupMeasure", element.getStudyEffectiveGroupMeasureElement(), -1);
        }
        if (element.hasParticipantEffectiveDescriptionElement()) {
            this.composeString(t, "ResearchElementDefinition", "participantEffectiveDescription", element.getParticipantEffectiveDescriptionElement(), -1);
        }
        if (element.hasParticipantEffective()) {
            this.composeType(t, "ResearchElementDefinition", "participantEffective", element.getParticipantEffective(), -1);
        }
        if (element.hasParticipantEffectiveTimeFromStart()) {
            this.composeDuration(t, "ResearchElementDefinition", "participantEffectiveTimeFromStart", element.getParticipantEffectiveTimeFromStart(), -1);
        }
        if (element.hasParticipantEffectiveGroupMeasureElement()) {
            this.composeEnum(t, "ResearchElementDefinition", "participantEffectiveGroupMeasure", element.getParticipantEffectiveGroupMeasureElement(), -1);
        }
    }

    protected void composeResearchStudy(Turtle.Complex parent, String parentType, String name, ResearchStudy element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "ResearchStudy", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "ResearchStudy", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "ResearchStudy", "title", element.getTitleElement(), -1);
        }
        for (i = 0; i < element.getProtocol().size(); ++i) {
            this.composeReference(t, "ResearchStudy", "protocol", element.getProtocol().get(i), i);
        }
        for (i = 0; i < element.getPartOf().size(); ++i) {
            this.composeReference(t, "ResearchStudy", "partOf", element.getPartOf().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "ResearchStudy", "status", element.getStatusElement(), -1);
        }
        if (element.hasPrimaryPurposeType()) {
            this.composeCodeableConcept(t, "ResearchStudy", "primaryPurposeType", element.getPrimaryPurposeType(), -1);
        }
        if (element.hasPhase()) {
            this.composeCodeableConcept(t, "ResearchStudy", "phase", element.getPhase(), -1);
        }
        for (i = 0; i < element.getCategory().size(); ++i) {
            this.composeCodeableConcept(t, "ResearchStudy", "category", element.getCategory().get(i), i);
        }
        for (i = 0; i < element.getFocus().size(); ++i) {
            this.composeCodeableConcept(t, "ResearchStudy", "focus", element.getFocus().get(i), i);
        }
        for (i = 0; i < element.getCondition().size(); ++i) {
            this.composeCodeableConcept(t, "ResearchStudy", "condition", element.getCondition().get(i), i);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeContactDetail(t, "ResearchStudy", "contact", element.getContact().get(i), i);
        }
        for (i = 0; i < element.getRelatedArtifact().size(); ++i) {
            this.composeRelatedArtifact(t, "ResearchStudy", "relatedArtifact", element.getRelatedArtifact().get(i), i);
        }
        for (i = 0; i < element.getKeyword().size(); ++i) {
            this.composeCodeableConcept(t, "ResearchStudy", "keyword", element.getKeyword().get(i), i);
        }
        for (i = 0; i < element.getLocation().size(); ++i) {
            this.composeCodeableConcept(t, "ResearchStudy", "location", element.getLocation().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "ResearchStudy", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getEnrollment().size(); ++i) {
            this.composeReference(t, "ResearchStudy", "enrollment", element.getEnrollment().get(i), i);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "ResearchStudy", "period", element.getPeriod(), -1);
        }
        if (element.hasSponsor()) {
            this.composeReference(t, "ResearchStudy", "sponsor", element.getSponsor(), -1);
        }
        if (element.hasPrincipalInvestigator()) {
            this.composeReference(t, "ResearchStudy", "principalInvestigator", element.getPrincipalInvestigator(), -1);
        }
        for (i = 0; i < element.getSite().size(); ++i) {
            this.composeReference(t, "ResearchStudy", "site", element.getSite().get(i), i);
        }
        if (element.hasReasonStopped()) {
            this.composeCodeableConcept(t, "ResearchStudy", "reasonStopped", element.getReasonStopped(), -1);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "ResearchStudy", "note", element.getNote().get(i), i);
        }
        for (i = 0; i < element.getArm().size(); ++i) {
            this.composeResearchStudyResearchStudyArmComponent(t, "ResearchStudy", "arm", element.getArm().get(i), i);
        }
        for (i = 0; i < element.getObjective().size(); ++i) {
            this.composeResearchStudyResearchStudyObjectiveComponent(t, "ResearchStudy", "objective", element.getObjective().get(i), i);
        }
    }

    protected void composeResearchStudyResearchStudyArmComponent(Turtle.Complex parent, String parentType, String name, ResearchStudy.ResearchStudyArmComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "arm", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "ResearchStudy", "name", element.getNameElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "ResearchStudy", "type", element.getType(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "ResearchStudy", "description", element.getDescriptionElement(), -1);
        }
    }

    protected void composeResearchStudyResearchStudyObjectiveComponent(Turtle.Complex parent, String parentType, String name, ResearchStudy.ResearchStudyObjectiveComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "objective", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "ResearchStudy", "name", element.getNameElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "ResearchStudy", "type", element.getType(), -1);
        }
    }

    protected void composeResearchSubject(Turtle.Complex parent, String parentType, String name, ResearchSubject element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "ResearchSubject", name, element, index);
        for (int i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "ResearchSubject", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "ResearchSubject", "status", element.getStatusElement(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "ResearchSubject", "period", element.getPeriod(), -1);
        }
        if (element.hasStudy()) {
            this.composeReference(t, "ResearchSubject", "study", element.getStudy(), -1);
        }
        if (element.hasIndividual()) {
            this.composeReference(t, "ResearchSubject", "individual", element.getIndividual(), -1);
        }
        if (element.hasAssignedArmElement()) {
            this.composeString(t, "ResearchSubject", "assignedArm", element.getAssignedArmElement(), -1);
        }
        if (element.hasActualArmElement()) {
            this.composeString(t, "ResearchSubject", "actualArm", element.getActualArmElement(), -1);
        }
        if (element.hasConsent()) {
            this.composeReference(t, "ResearchSubject", "consent", element.getConsent(), -1);
        }
    }

    protected void composeRiskAssessment(Turtle.Complex parent, String parentType, String name, RiskAssessment element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "RiskAssessment", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "RiskAssessment", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasBasedOn()) {
            this.composeReference(t, "RiskAssessment", "basedOn", element.getBasedOn(), -1);
        }
        if (element.hasParent()) {
            this.composeReference(t, "RiskAssessment", "parent", element.getParent(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "RiskAssessment", "status", element.getStatusElement(), -1);
        }
        if (element.hasMethod()) {
            this.composeCodeableConcept(t, "RiskAssessment", "method", element.getMethod(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "RiskAssessment", "code", element.getCode(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "RiskAssessment", "subject", element.getSubject(), -1);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "RiskAssessment", "encounter", element.getEncounter(), -1);
        }
        if (element.hasOccurrence()) {
            this.composeType(t, "RiskAssessment", "occurrence", element.getOccurrence(), -1);
        }
        if (element.hasCondition()) {
            this.composeReference(t, "RiskAssessment", "condition", element.getCondition(), -1);
        }
        if (element.hasPerformer()) {
            this.composeReference(t, "RiskAssessment", "performer", element.getPerformer(), -1);
        }
        for (i = 0; i < element.getReasonCode().size(); ++i) {
            this.composeCodeableConcept(t, "RiskAssessment", "reasonCode", element.getReasonCode().get(i), i);
        }
        for (i = 0; i < element.getReasonReference().size(); ++i) {
            this.composeReference(t, "RiskAssessment", "reasonReference", element.getReasonReference().get(i), i);
        }
        for (i = 0; i < element.getBasis().size(); ++i) {
            this.composeReference(t, "RiskAssessment", "basis", element.getBasis().get(i), i);
        }
        for (i = 0; i < element.getPrediction().size(); ++i) {
            this.composeRiskAssessmentRiskAssessmentPredictionComponent(t, "RiskAssessment", "prediction", element.getPrediction().get(i), i);
        }
        if (element.hasMitigationElement()) {
            this.composeString(t, "RiskAssessment", "mitigation", element.getMitigationElement(), -1);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "RiskAssessment", "note", element.getNote().get(i), i);
        }
    }

    protected void composeRiskAssessmentRiskAssessmentPredictionComponent(Turtle.Complex parent, String parentType, String name, RiskAssessment.RiskAssessmentPredictionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "prediction", name, element, index);
        if (element.hasOutcome()) {
            this.composeCodeableConcept(t, "RiskAssessment", "outcome", element.getOutcome(), -1);
        }
        if (element.hasProbability()) {
            this.composeType(t, "RiskAssessment", "probability", element.getProbability(), -1);
        }
        if (element.hasQualitativeRisk()) {
            this.composeCodeableConcept(t, "RiskAssessment", "qualitativeRisk", element.getQualitativeRisk(), -1);
        }
        if (element.hasRelativeRiskElement()) {
            this.composeDecimal(t, "RiskAssessment", "relativeRisk", element.getRelativeRiskElement(), -1);
        }
        if (element.hasWhen()) {
            this.composeType(t, "RiskAssessment", "when", element.getWhen(), -1);
        }
        if (element.hasRationaleElement()) {
            this.composeString(t, "RiskAssessment", "rationale", element.getRationaleElement(), -1);
        }
    }

    protected void composeRiskEvidenceSynthesis(Turtle.Complex parent, String parentType, String name, RiskEvidenceSynthesis element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "RiskEvidenceSynthesis", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "RiskEvidenceSynthesis", "url", element.getUrlElement(), -1);
        }
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "RiskEvidenceSynthesis", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "RiskEvidenceSynthesis", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "RiskEvidenceSynthesis", "name", element.getNameElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "RiskEvidenceSynthesis", "title", element.getTitleElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "RiskEvidenceSynthesis", "status", element.getStatusElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "RiskEvidenceSynthesis", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "RiskEvidenceSynthesis", "publisher", element.getPublisherElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeContactDetail(t, "RiskEvidenceSynthesis", "contact", element.getContact().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "RiskEvidenceSynthesis", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "RiskEvidenceSynthesis", "note", element.getNote().get(i), i);
        }
        for (i = 0; i < element.getUseContext().size(); ++i) {
            this.composeUsageContext(t, "RiskEvidenceSynthesis", "useContext", element.getUseContext().get(i), i);
        }
        for (i = 0; i < element.getJurisdiction().size(); ++i) {
            this.composeCodeableConcept(t, "RiskEvidenceSynthesis", "jurisdiction", element.getJurisdiction().get(i), i);
        }
        if (element.hasCopyrightElement()) {
            this.composeMarkdown(t, "RiskEvidenceSynthesis", "copyright", element.getCopyrightElement(), -1);
        }
        if (element.hasApprovalDateElement()) {
            this.composeDate(t, "RiskEvidenceSynthesis", "approvalDate", element.getApprovalDateElement(), -1);
        }
        if (element.hasLastReviewDateElement()) {
            this.composeDate(t, "RiskEvidenceSynthesis", "lastReviewDate", element.getLastReviewDateElement(), -1);
        }
        if (element.hasEffectivePeriod()) {
            this.composePeriod(t, "RiskEvidenceSynthesis", "effectivePeriod", element.getEffectivePeriod(), -1);
        }
        for (i = 0; i < element.getTopic().size(); ++i) {
            this.composeCodeableConcept(t, "RiskEvidenceSynthesis", "topic", element.getTopic().get(i), i);
        }
        for (i = 0; i < element.getAuthor().size(); ++i) {
            this.composeContactDetail(t, "RiskEvidenceSynthesis", "author", element.getAuthor().get(i), i);
        }
        for (i = 0; i < element.getEditor().size(); ++i) {
            this.composeContactDetail(t, "RiskEvidenceSynthesis", "editor", element.getEditor().get(i), i);
        }
        for (i = 0; i < element.getReviewer().size(); ++i) {
            this.composeContactDetail(t, "RiskEvidenceSynthesis", "reviewer", element.getReviewer().get(i), i);
        }
        for (i = 0; i < element.getEndorser().size(); ++i) {
            this.composeContactDetail(t, "RiskEvidenceSynthesis", "endorser", element.getEndorser().get(i), i);
        }
        for (i = 0; i < element.getRelatedArtifact().size(); ++i) {
            this.composeRelatedArtifact(t, "RiskEvidenceSynthesis", "relatedArtifact", element.getRelatedArtifact().get(i), i);
        }
        if (element.hasSynthesisType()) {
            this.composeCodeableConcept(t, "RiskEvidenceSynthesis", "synthesisType", element.getSynthesisType(), -1);
        }
        if (element.hasStudyType()) {
            this.composeCodeableConcept(t, "RiskEvidenceSynthesis", "studyType", element.getStudyType(), -1);
        }
        if (element.hasPopulation()) {
            this.composeReference(t, "RiskEvidenceSynthesis", "population", element.getPopulation(), -1);
        }
        if (element.hasExposure()) {
            this.composeReference(t, "RiskEvidenceSynthesis", "exposure", element.getExposure(), -1);
        }
        if (element.hasOutcome()) {
            this.composeReference(t, "RiskEvidenceSynthesis", "outcome", element.getOutcome(), -1);
        }
        if (element.hasSampleSize()) {
            this.composeRiskEvidenceSynthesisRiskEvidenceSynthesisSampleSizeComponent(t, "RiskEvidenceSynthesis", "sampleSize", element.getSampleSize(), -1);
        }
        if (element.hasRiskEstimate()) {
            this.composeRiskEvidenceSynthesisRiskEvidenceSynthesisRiskEstimateComponent(t, "RiskEvidenceSynthesis", "riskEstimate", element.getRiskEstimate(), -1);
        }
        for (i = 0; i < element.getCertainty().size(); ++i) {
            this.composeRiskEvidenceSynthesisRiskEvidenceSynthesisCertaintyComponent(t, "RiskEvidenceSynthesis", "certainty", element.getCertainty().get(i), i);
        }
    }

    protected void composeRiskEvidenceSynthesisRiskEvidenceSynthesisSampleSizeComponent(Turtle.Complex parent, String parentType, String name, RiskEvidenceSynthesis.RiskEvidenceSynthesisSampleSizeComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "sampleSize", name, element, index);
        if (element.hasDescriptionElement()) {
            this.composeString(t, "RiskEvidenceSynthesis", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasNumberOfStudiesElement()) {
            this.composeInteger(t, "RiskEvidenceSynthesis", "numberOfStudies", element.getNumberOfStudiesElement(), -1);
        }
        if (element.hasNumberOfParticipantsElement()) {
            this.composeInteger(t, "RiskEvidenceSynthesis", "numberOfParticipants", element.getNumberOfParticipantsElement(), -1);
        }
    }

    protected void composeRiskEvidenceSynthesisRiskEvidenceSynthesisRiskEstimateComponent(Turtle.Complex parent, String parentType, String name, RiskEvidenceSynthesis.RiskEvidenceSynthesisRiskEstimateComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "riskEstimate", name, element, index);
        if (element.hasDescriptionElement()) {
            this.composeString(t, "RiskEvidenceSynthesis", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "RiskEvidenceSynthesis", "type", element.getType(), -1);
        }
        if (element.hasValueElement()) {
            this.composeDecimal(t, "RiskEvidenceSynthesis", "value", element.getValueElement(), -1);
        }
        if (element.hasUnitOfMeasure()) {
            this.composeCodeableConcept(t, "RiskEvidenceSynthesis", "unitOfMeasure", element.getUnitOfMeasure(), -1);
        }
        if (element.hasDenominatorCountElement()) {
            this.composeInteger(t, "RiskEvidenceSynthesis", "denominatorCount", element.getDenominatorCountElement(), -1);
        }
        if (element.hasNumeratorCountElement()) {
            this.composeInteger(t, "RiskEvidenceSynthesis", "numeratorCount", element.getNumeratorCountElement(), -1);
        }
        for (int i = 0; i < element.getPrecisionEstimate().size(); ++i) {
            this.composeRiskEvidenceSynthesisRiskEvidenceSynthesisRiskEstimatePrecisionEstimateComponent(t, "RiskEvidenceSynthesis", "precisionEstimate", element.getPrecisionEstimate().get(i), i);
        }
    }

    protected void composeRiskEvidenceSynthesisRiskEvidenceSynthesisRiskEstimatePrecisionEstimateComponent(Turtle.Complex parent, String parentType, String name, RiskEvidenceSynthesis.RiskEvidenceSynthesisRiskEstimatePrecisionEstimateComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "precisionEstimate", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "RiskEvidenceSynthesis", "type", element.getType(), -1);
        }
        if (element.hasLevelElement()) {
            this.composeDecimal(t, "RiskEvidenceSynthesis", "level", element.getLevelElement(), -1);
        }
        if (element.hasFromElement()) {
            this.composeDecimal(t, "RiskEvidenceSynthesis", "from", element.getFromElement(), -1);
        }
        if (element.hasToElement()) {
            this.composeDecimal(t, "RiskEvidenceSynthesis", "to", element.getToElement(), -1);
        }
    }

    protected void composeRiskEvidenceSynthesisRiskEvidenceSynthesisCertaintyComponent(Turtle.Complex parent, String parentType, String name, RiskEvidenceSynthesis.RiskEvidenceSynthesisCertaintyComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "certainty", name, element, index);
        for (i = 0; i < element.getRating().size(); ++i) {
            this.composeCodeableConcept(t, "RiskEvidenceSynthesis", "rating", element.getRating().get(i), i);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "RiskEvidenceSynthesis", "note", element.getNote().get(i), i);
        }
        for (i = 0; i < element.getCertaintySubcomponent().size(); ++i) {
            this.composeRiskEvidenceSynthesisRiskEvidenceSynthesisCertaintyCertaintySubcomponentComponent(t, "RiskEvidenceSynthesis", "certaintySubcomponent", element.getCertaintySubcomponent().get(i), i);
        }
    }

    protected void composeRiskEvidenceSynthesisRiskEvidenceSynthesisCertaintyCertaintySubcomponentComponent(Turtle.Complex parent, String parentType, String name, RiskEvidenceSynthesis.RiskEvidenceSynthesisCertaintyCertaintySubcomponentComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "certaintySubcomponent", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "RiskEvidenceSynthesis", "type", element.getType(), -1);
        }
        for (i = 0; i < element.getRating().size(); ++i) {
            this.composeCodeableConcept(t, "RiskEvidenceSynthesis", "rating", element.getRating().get(i), i);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "RiskEvidenceSynthesis", "note", element.getNote().get(i), i);
        }
    }

    protected void composeSchedule(Turtle.Complex parent, String parentType, String name, Schedule element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Schedule", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Schedule", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasActiveElement()) {
            this.composeBoolean(t, "Schedule", "active", element.getActiveElement(), -1);
        }
        for (i = 0; i < element.getServiceCategory().size(); ++i) {
            this.composeCodeableConcept(t, "Schedule", "serviceCategory", element.getServiceCategory().get(i), i);
        }
        for (i = 0; i < element.getServiceType().size(); ++i) {
            this.composeCodeableConcept(t, "Schedule", "serviceType", element.getServiceType().get(i), i);
        }
        for (i = 0; i < element.getSpecialty().size(); ++i) {
            this.composeCodeableConcept(t, "Schedule", "specialty", element.getSpecialty().get(i), i);
        }
        for (i = 0; i < element.getActor().size(); ++i) {
            this.composeReference(t, "Schedule", "actor", element.getActor().get(i), i);
        }
        if (element.hasPlanningHorizon()) {
            this.composePeriod(t, "Schedule", "planningHorizon", element.getPlanningHorizon(), -1);
        }
        if (element.hasCommentElement()) {
            this.composeString(t, "Schedule", "comment", element.getCommentElement(), -1);
        }
    }

    protected void composeSearchParameter(Turtle.Complex parent, String parentType, String name, SearchParameter element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "SearchParameter", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "SearchParameter", "url", element.getUrlElement(), -1);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "SearchParameter", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "SearchParameter", "name", element.getNameElement(), -1);
        }
        if (element.hasDerivedFromElement()) {
            this.composeCanonical(t, "SearchParameter", "derivedFrom", element.getDerivedFromElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "SearchParameter", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "SearchParameter", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "SearchParameter", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "SearchParameter", "publisher", element.getPublisherElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeContactDetail(t, "SearchParameter", "contact", element.getContact().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "SearchParameter", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getUseContext().size(); ++i) {
            this.composeUsageContext(t, "SearchParameter", "useContext", element.getUseContext().get(i), i);
        }
        for (i = 0; i < element.getJurisdiction().size(); ++i) {
            this.composeCodeableConcept(t, "SearchParameter", "jurisdiction", element.getJurisdiction().get(i), i);
        }
        if (element.hasPurposeElement()) {
            this.composeMarkdown(t, "SearchParameter", "purpose", element.getPurposeElement(), -1);
        }
        if (element.hasCodeElement()) {
            this.composeCode(t, "SearchParameter", "code", element.getCodeElement(), -1);
        }
        for (i = 0; i < element.getBase().size(); ++i) {
            this.composeCode(t, "SearchParameter", "base", element.getBase().get(i), i);
        }
        if (element.hasTypeElement()) {
            this.composeEnum(t, "SearchParameter", "type", element.getTypeElement(), -1);
        }
        if (element.hasExpressionElement()) {
            this.composeString(t, "SearchParameter", "expression", element.getExpressionElement(), -1);
        }
        if (element.hasXpathElement()) {
            this.composeString(t, "SearchParameter", "xpath", element.getXpathElement(), -1);
        }
        if (element.hasXpathUsageElement()) {
            this.composeEnum(t, "SearchParameter", "xpathUsage", element.getXpathUsageElement(), -1);
        }
        for (i = 0; i < element.getTarget().size(); ++i) {
            this.composeCode(t, "SearchParameter", "target", element.getTarget().get(i), i);
        }
        if (element.hasMultipleOrElement()) {
            this.composeBoolean(t, "SearchParameter", "multipleOr", element.getMultipleOrElement(), -1);
        }
        if (element.hasMultipleAndElement()) {
            this.composeBoolean(t, "SearchParameter", "multipleAnd", element.getMultipleAndElement(), -1);
        }
        for (i = 0; i < element.getComparator().size(); ++i) {
            this.composeEnum(t, "SearchParameter", "comparator", element.getComparator().get(i), i);
        }
        for (i = 0; i < element.getModifier().size(); ++i) {
            this.composeEnum(t, "SearchParameter", "modifier", element.getModifier().get(i), i);
        }
        for (i = 0; i < element.getChain().size(); ++i) {
            this.composeString(t, "SearchParameter", "chain", element.getChain().get(i), i);
        }
        for (i = 0; i < element.getComponent().size(); ++i) {
            this.composeSearchParameterSearchParameterComponentComponent(t, "SearchParameter", "component", element.getComponent().get(i), i);
        }
    }

    protected void composeSearchParameterSearchParameterComponentComponent(Turtle.Complex parent, String parentType, String name, SearchParameter.SearchParameterComponentComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "component", name, element, index);
        if (element.hasDefinitionElement()) {
            this.composeCanonical(t, "SearchParameter", "definition", element.getDefinitionElement(), -1);
        }
        if (element.hasExpressionElement()) {
            this.composeString(t, "SearchParameter", "expression", element.getExpressionElement(), -1);
        }
    }

    protected void composeServiceRequest(Turtle.Complex parent, String parentType, String name, ServiceRequest element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "ServiceRequest", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "ServiceRequest", "identifier", element.getIdentifier().get(i), i);
        }
        for (i = 0; i < element.getInstantiatesCanonical().size(); ++i) {
            this.composeCanonical(t, "ServiceRequest", "instantiatesCanonical", element.getInstantiatesCanonical().get(i), i);
        }
        for (i = 0; i < element.getInstantiatesUri().size(); ++i) {
            this.composeUri(t, "ServiceRequest", "instantiatesUri", element.getInstantiatesUri().get(i), i);
        }
        for (i = 0; i < element.getBasedOn().size(); ++i) {
            this.composeReference(t, "ServiceRequest", "basedOn", element.getBasedOn().get(i), i);
        }
        for (i = 0; i < element.getReplaces().size(); ++i) {
            this.composeReference(t, "ServiceRequest", "replaces", element.getReplaces().get(i), i);
        }
        if (element.hasRequisition()) {
            this.composeIdentifier(t, "ServiceRequest", "requisition", element.getRequisition(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "ServiceRequest", "status", element.getStatusElement(), -1);
        }
        if (element.hasIntentElement()) {
            this.composeEnum(t, "ServiceRequest", "intent", element.getIntentElement(), -1);
        }
        for (i = 0; i < element.getCategory().size(); ++i) {
            this.composeCodeableConcept(t, "ServiceRequest", "category", element.getCategory().get(i), i);
        }
        if (element.hasPriorityElement()) {
            this.composeEnum(t, "ServiceRequest", "priority", element.getPriorityElement(), -1);
        }
        if (element.hasDoNotPerformElement()) {
            this.composeBoolean(t, "ServiceRequest", "doNotPerform", element.getDoNotPerformElement(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "ServiceRequest", "code", element.getCode(), -1);
        }
        for (i = 0; i < element.getOrderDetail().size(); ++i) {
            this.composeCodeableConcept(t, "ServiceRequest", "orderDetail", element.getOrderDetail().get(i), i);
        }
        if (element.hasQuantity()) {
            this.composeType(t, "ServiceRequest", "quantity", element.getQuantity(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "ServiceRequest", "subject", element.getSubject(), -1);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "ServiceRequest", "encounter", element.getEncounter(), -1);
        }
        if (element.hasOccurrence()) {
            this.composeType(t, "ServiceRequest", "occurrence", element.getOccurrence(), -1);
        }
        if (element.hasAsNeeded()) {
            this.composeType(t, "ServiceRequest", "asNeeded", element.getAsNeeded(), -1);
        }
        if (element.hasAuthoredOnElement()) {
            this.composeDateTime(t, "ServiceRequest", "authoredOn", element.getAuthoredOnElement(), -1);
        }
        if (element.hasRequester()) {
            this.composeReference(t, "ServiceRequest", "requester", element.getRequester(), -1);
        }
        if (element.hasPerformerType()) {
            this.composeCodeableConcept(t, "ServiceRequest", "performerType", element.getPerformerType(), -1);
        }
        for (i = 0; i < element.getPerformer().size(); ++i) {
            this.composeReference(t, "ServiceRequest", "performer", element.getPerformer().get(i), i);
        }
        for (i = 0; i < element.getLocationCode().size(); ++i) {
            this.composeCodeableConcept(t, "ServiceRequest", "locationCode", element.getLocationCode().get(i), i);
        }
        for (i = 0; i < element.getLocationReference().size(); ++i) {
            this.composeReference(t, "ServiceRequest", "locationReference", element.getLocationReference().get(i), i);
        }
        for (i = 0; i < element.getReasonCode().size(); ++i) {
            this.composeCodeableConcept(t, "ServiceRequest", "reasonCode", element.getReasonCode().get(i), i);
        }
        for (i = 0; i < element.getReasonReference().size(); ++i) {
            this.composeReference(t, "ServiceRequest", "reasonReference", element.getReasonReference().get(i), i);
        }
        for (i = 0; i < element.getInsurance().size(); ++i) {
            this.composeReference(t, "ServiceRequest", "insurance", element.getInsurance().get(i), i);
        }
        for (i = 0; i < element.getSupportingInfo().size(); ++i) {
            this.composeReference(t, "ServiceRequest", "supportingInfo", element.getSupportingInfo().get(i), i);
        }
        for (i = 0; i < element.getSpecimen().size(); ++i) {
            this.composeReference(t, "ServiceRequest", "specimen", element.getSpecimen().get(i), i);
        }
        for (i = 0; i < element.getBodySite().size(); ++i) {
            this.composeCodeableConcept(t, "ServiceRequest", "bodySite", element.getBodySite().get(i), i);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "ServiceRequest", "note", element.getNote().get(i), i);
        }
        if (element.hasPatientInstructionElement()) {
            this.composeString(t, "ServiceRequest", "patientInstruction", element.getPatientInstructionElement(), -1);
        }
        for (i = 0; i < element.getRelevantHistory().size(); ++i) {
            this.composeReference(t, "ServiceRequest", "relevantHistory", element.getRelevantHistory().get(i), i);
        }
    }

    protected void composeSlot(Turtle.Complex parent, String parentType, String name, Slot element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Slot", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Slot", "identifier", element.getIdentifier().get(i), i);
        }
        for (i = 0; i < element.getServiceCategory().size(); ++i) {
            this.composeCodeableConcept(t, "Slot", "serviceCategory", element.getServiceCategory().get(i), i);
        }
        for (i = 0; i < element.getServiceType().size(); ++i) {
            this.composeCodeableConcept(t, "Slot", "serviceType", element.getServiceType().get(i), i);
        }
        for (i = 0; i < element.getSpecialty().size(); ++i) {
            this.composeCodeableConcept(t, "Slot", "specialty", element.getSpecialty().get(i), i);
        }
        if (element.hasAppointmentType()) {
            this.composeCodeableConcept(t, "Slot", "appointmentType", element.getAppointmentType(), -1);
        }
        if (element.hasSchedule()) {
            this.composeReference(t, "Slot", "schedule", element.getSchedule(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Slot", "status", element.getStatusElement(), -1);
        }
        if (element.hasStartElement()) {
            this.composeInstant(t, "Slot", "start", element.getStartElement(), -1);
        }
        if (element.hasEndElement()) {
            this.composeInstant(t, "Slot", "end", element.getEndElement(), -1);
        }
        if (element.hasOverbookedElement()) {
            this.composeBoolean(t, "Slot", "overbooked", element.getOverbookedElement(), -1);
        }
        if (element.hasCommentElement()) {
            this.composeString(t, "Slot", "comment", element.getCommentElement(), -1);
        }
    }

    protected void composeSpecimen(Turtle.Complex parent, String parentType, String name, Specimen element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Specimen", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Specimen", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasAccessionIdentifier()) {
            this.composeIdentifier(t, "Specimen", "accessionIdentifier", element.getAccessionIdentifier(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Specimen", "status", element.getStatusElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "Specimen", "type", element.getType(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "Specimen", "subject", element.getSubject(), -1);
        }
        if (element.hasReceivedTimeElement()) {
            this.composeDateTime(t, "Specimen", "receivedTime", element.getReceivedTimeElement(), -1);
        }
        for (i = 0; i < element.getParent().size(); ++i) {
            this.composeReference(t, "Specimen", "parent", element.getParent().get(i), i);
        }
        for (i = 0; i < element.getRequest().size(); ++i) {
            this.composeReference(t, "Specimen", "request", element.getRequest().get(i), i);
        }
        if (element.hasCollection()) {
            this.composeSpecimenSpecimenCollectionComponent(t, "Specimen", "collection", element.getCollection(), -1);
        }
        for (i = 0; i < element.getProcessing().size(); ++i) {
            this.composeSpecimenSpecimenProcessingComponent(t, "Specimen", "processing", element.getProcessing().get(i), i);
        }
        for (i = 0; i < element.getContainer().size(); ++i) {
            this.composeSpecimenSpecimenContainerComponent(t, "Specimen", "container", element.getContainer().get(i), i);
        }
        for (i = 0; i < element.getCondition().size(); ++i) {
            this.composeCodeableConcept(t, "Specimen", "condition", element.getCondition().get(i), i);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "Specimen", "note", element.getNote().get(i), i);
        }
    }

    protected void composeSpecimenSpecimenCollectionComponent(Turtle.Complex parent, String parentType, String name, Specimen.SpecimenCollectionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "collection", name, element, index);
        if (element.hasCollector()) {
            this.composeReference(t, "Specimen", "collector", element.getCollector(), -1);
        }
        if (element.hasCollected()) {
            this.composeType(t, "Specimen", "collected", element.getCollected(), -1);
        }
        if (element.hasDuration()) {
            this.composeDuration(t, "Specimen", "duration", element.getDuration(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "Specimen", "quantity", element.getQuantity(), -1);
        }
        if (element.hasMethod()) {
            this.composeCodeableConcept(t, "Specimen", "method", element.getMethod(), -1);
        }
        if (element.hasBodySite()) {
            this.composeCodeableConcept(t, "Specimen", "bodySite", element.getBodySite(), -1);
        }
        if (element.hasFastingStatus()) {
            this.composeType(t, "Specimen", "fastingStatus", element.getFastingStatus(), -1);
        }
    }

    protected void composeSpecimenSpecimenProcessingComponent(Turtle.Complex parent, String parentType, String name, Specimen.SpecimenProcessingComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "processing", name, element, index);
        if (element.hasDescriptionElement()) {
            this.composeString(t, "Specimen", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasProcedure()) {
            this.composeCodeableConcept(t, "Specimen", "procedure", element.getProcedure(), -1);
        }
        for (int i = 0; i < element.getAdditive().size(); ++i) {
            this.composeReference(t, "Specimen", "additive", element.getAdditive().get(i), i);
        }
        if (element.hasTime()) {
            this.composeType(t, "Specimen", "time", element.getTime(), -1);
        }
    }

    protected void composeSpecimenSpecimenContainerComponent(Turtle.Complex parent, String parentType, String name, Specimen.SpecimenContainerComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "container", name, element, index);
        for (int i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Specimen", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "Specimen", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "Specimen", "type", element.getType(), -1);
        }
        if (element.hasCapacity()) {
            this.composeQuantity(t, "Specimen", "capacity", element.getCapacity(), -1);
        }
        if (element.hasSpecimenQuantity()) {
            this.composeQuantity(t, "Specimen", "specimenQuantity", element.getSpecimenQuantity(), -1);
        }
        if (element.hasAdditive()) {
            this.composeType(t, "Specimen", "additive", element.getAdditive(), -1);
        }
    }

    protected void composeSpecimenDefinition(Turtle.Complex parent, String parentType, String name, SpecimenDefinition element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "SpecimenDefinition", name, element, index);
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "SpecimenDefinition", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasTypeCollected()) {
            this.composeCodeableConcept(t, "SpecimenDefinition", "typeCollected", element.getTypeCollected(), -1);
        }
        for (i = 0; i < element.getPatientPreparation().size(); ++i) {
            this.composeCodeableConcept(t, "SpecimenDefinition", "patientPreparation", element.getPatientPreparation().get(i), i);
        }
        if (element.hasTimeAspectElement()) {
            this.composeString(t, "SpecimenDefinition", "timeAspect", element.getTimeAspectElement(), -1);
        }
        for (i = 0; i < element.getCollection().size(); ++i) {
            this.composeCodeableConcept(t, "SpecimenDefinition", "collection", element.getCollection().get(i), i);
        }
        for (i = 0; i < element.getTypeTested().size(); ++i) {
            this.composeSpecimenDefinitionSpecimenDefinitionTypeTestedComponent(t, "SpecimenDefinition", "typeTested", element.getTypeTested().get(i), i);
        }
    }

    protected void composeSpecimenDefinitionSpecimenDefinitionTypeTestedComponent(Turtle.Complex parent, String parentType, String name, SpecimenDefinition.SpecimenDefinitionTypeTestedComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "typeTested", name, element, index);
        if (element.hasIsDerivedElement()) {
            this.composeBoolean(t, "SpecimenDefinition", "isDerived", element.getIsDerivedElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "SpecimenDefinition", "type", element.getType(), -1);
        }
        if (element.hasPreferenceElement()) {
            this.composeEnum(t, "SpecimenDefinition", "preference", element.getPreferenceElement(), -1);
        }
        if (element.hasContainer()) {
            this.composeSpecimenDefinitionSpecimenDefinitionTypeTestedContainerComponent(t, "SpecimenDefinition", "container", element.getContainer(), -1);
        }
        if (element.hasRequirementElement()) {
            this.composeString(t, "SpecimenDefinition", "requirement", element.getRequirementElement(), -1);
        }
        if (element.hasRetentionTime()) {
            this.composeDuration(t, "SpecimenDefinition", "retentionTime", element.getRetentionTime(), -1);
        }
        for (i = 0; i < element.getRejectionCriterion().size(); ++i) {
            this.composeCodeableConcept(t, "SpecimenDefinition", "rejectionCriterion", element.getRejectionCriterion().get(i), i);
        }
        for (i = 0; i < element.getHandling().size(); ++i) {
            this.composeSpecimenDefinitionSpecimenDefinitionTypeTestedHandlingComponent(t, "SpecimenDefinition", "handling", element.getHandling().get(i), i);
        }
    }

    protected void composeSpecimenDefinitionSpecimenDefinitionTypeTestedContainerComponent(Turtle.Complex parent, String parentType, String name, SpecimenDefinition.SpecimenDefinitionTypeTestedContainerComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "container", name, element, index);
        if (element.hasMaterial()) {
            this.composeCodeableConcept(t, "SpecimenDefinition", "material", element.getMaterial(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "SpecimenDefinition", "type", element.getType(), -1);
        }
        if (element.hasCap()) {
            this.composeCodeableConcept(t, "SpecimenDefinition", "cap", element.getCap(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "SpecimenDefinition", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasCapacity()) {
            this.composeQuantity(t, "SpecimenDefinition", "capacity", element.getCapacity(), -1);
        }
        if (element.hasMinimumVolume()) {
            this.composeType(t, "SpecimenDefinition", "minimumVolume", element.getMinimumVolume(), -1);
        }
        for (int i = 0; i < element.getAdditive().size(); ++i) {
            this.composeSpecimenDefinitionSpecimenDefinitionTypeTestedContainerAdditiveComponent(t, "SpecimenDefinition", "additive", element.getAdditive().get(i), i);
        }
        if (element.hasPreparationElement()) {
            this.composeString(t, "SpecimenDefinition", "preparation", element.getPreparationElement(), -1);
        }
    }

    protected void composeSpecimenDefinitionSpecimenDefinitionTypeTestedContainerAdditiveComponent(Turtle.Complex parent, String parentType, String name, SpecimenDefinition.SpecimenDefinitionTypeTestedContainerAdditiveComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "additive", name, element, index);
        if (element.hasAdditive()) {
            this.composeType(t, "SpecimenDefinition", "additive", element.getAdditive(), -1);
        }
    }

    protected void composeSpecimenDefinitionSpecimenDefinitionTypeTestedHandlingComponent(Turtle.Complex parent, String parentType, String name, SpecimenDefinition.SpecimenDefinitionTypeTestedHandlingComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "handling", name, element, index);
        if (element.hasTemperatureQualifier()) {
            this.composeCodeableConcept(t, "SpecimenDefinition", "temperatureQualifier", element.getTemperatureQualifier(), -1);
        }
        if (element.hasTemperatureRange()) {
            this.composeRange(t, "SpecimenDefinition", "temperatureRange", element.getTemperatureRange(), -1);
        }
        if (element.hasMaxDuration()) {
            this.composeDuration(t, "SpecimenDefinition", "maxDuration", element.getMaxDuration(), -1);
        }
        if (element.hasInstructionElement()) {
            this.composeString(t, "SpecimenDefinition", "instruction", element.getInstructionElement(), -1);
        }
    }

    protected void composeStructureDefinition(Turtle.Complex parent, String parentType, String name, StructureDefinition element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "StructureDefinition", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "StructureDefinition", "url", element.getUrlElement(), -1);
        }
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "StructureDefinition", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "StructureDefinition", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "StructureDefinition", "name", element.getNameElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "StructureDefinition", "title", element.getTitleElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "StructureDefinition", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "StructureDefinition", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "StructureDefinition", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "StructureDefinition", "publisher", element.getPublisherElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeContactDetail(t, "StructureDefinition", "contact", element.getContact().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "StructureDefinition", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getUseContext().size(); ++i) {
            this.composeUsageContext(t, "StructureDefinition", "useContext", element.getUseContext().get(i), i);
        }
        for (i = 0; i < element.getJurisdiction().size(); ++i) {
            this.composeCodeableConcept(t, "StructureDefinition", "jurisdiction", element.getJurisdiction().get(i), i);
        }
        if (element.hasPurposeElement()) {
            this.composeMarkdown(t, "StructureDefinition", "purpose", element.getPurposeElement(), -1);
        }
        if (element.hasCopyrightElement()) {
            this.composeMarkdown(t, "StructureDefinition", "copyright", element.getCopyrightElement(), -1);
        }
        for (i = 0; i < element.getKeyword().size(); ++i) {
            this.composeCoding(t, "StructureDefinition", "keyword", element.getKeyword().get(i), i);
        }
        if (element.hasFhirVersionElement()) {
            this.composeEnum(t, "StructureDefinition", "fhirVersion", element.getFhirVersionElement(), -1);
        }
        for (i = 0; i < element.getMapping().size(); ++i) {
            this.composeStructureDefinitionStructureDefinitionMappingComponent(t, "StructureDefinition", "mapping", element.getMapping().get(i), i);
        }
        if (element.hasKindElement()) {
            this.composeEnum(t, "StructureDefinition", "kind", element.getKindElement(), -1);
        }
        if (element.hasAbstractElement()) {
            this.composeBoolean(t, "StructureDefinition", "abstract", element.getAbstractElement(), -1);
        }
        for (i = 0; i < element.getContext().size(); ++i) {
            this.composeStructureDefinitionStructureDefinitionContextComponent(t, "StructureDefinition", "context", element.getContext().get(i), i);
        }
        for (i = 0; i < element.getContextInvariant().size(); ++i) {
            this.composeString(t, "StructureDefinition", "contextInvariant", element.getContextInvariant().get(i), i);
        }
        if (element.hasTypeElement()) {
            this.composeUri(t, "StructureDefinition", "type", element.getTypeElement(), -1);
        }
        if (element.hasBaseDefinitionElement()) {
            this.composeCanonical(t, "StructureDefinition", "baseDefinition", element.getBaseDefinitionElement(), -1);
        }
        if (element.hasDerivationElement()) {
            this.composeEnum(t, "StructureDefinition", "derivation", element.getDerivationElement(), -1);
        }
        if (element.hasSnapshot()) {
            this.composeStructureDefinitionStructureDefinitionSnapshotComponent(t, "StructureDefinition", "snapshot", element.getSnapshot(), -1);
        }
        if (element.hasDifferential()) {
            this.composeStructureDefinitionStructureDefinitionDifferentialComponent(t, "StructureDefinition", "differential", element.getDifferential(), -1);
        }
    }

    protected void composeStructureDefinitionStructureDefinitionMappingComponent(Turtle.Complex parent, String parentType, String name, StructureDefinition.StructureDefinitionMappingComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "mapping", name, element, index);
        if (element.hasIdentityElement()) {
            this.composeId(t, "StructureDefinition", "identity", element.getIdentityElement(), -1);
        }
        if (element.hasUriElement()) {
            this.composeUri(t, "StructureDefinition", "uri", element.getUriElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "StructureDefinition", "name", element.getNameElement(), -1);
        }
        if (element.hasCommentElement()) {
            this.composeString(t, "StructureDefinition", "comment", element.getCommentElement(), -1);
        }
    }

    protected void composeStructureDefinitionStructureDefinitionContextComponent(Turtle.Complex parent, String parentType, String name, StructureDefinition.StructureDefinitionContextComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "context", name, element, index);
        if (element.hasTypeElement()) {
            this.composeEnum(t, "StructureDefinition", "type", element.getTypeElement(), -1);
        }
        if (element.hasExpressionElement()) {
            this.composeString(t, "StructureDefinition", "expression", element.getExpressionElement(), -1);
        }
    }

    protected void composeStructureDefinitionStructureDefinitionSnapshotComponent(Turtle.Complex parent, String parentType, String name, StructureDefinition.StructureDefinitionSnapshotComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "snapshot", name, element, index);
        for (int i = 0; i < element.getElement().size(); ++i) {
            this.composeElementDefinition(t, "StructureDefinition", "element", element.getElement().get(i), i);
        }
    }

    protected void composeStructureDefinitionStructureDefinitionDifferentialComponent(Turtle.Complex parent, String parentType, String name, StructureDefinition.StructureDefinitionDifferentialComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "differential", name, element, index);
        for (int i = 0; i < element.getElement().size(); ++i) {
            this.composeElementDefinition(t, "StructureDefinition", "element", element.getElement().get(i), i);
        }
    }

    protected void composeStructureMap(Turtle.Complex parent, String parentType, String name, StructureMap element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "StructureMap", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "StructureMap", "url", element.getUrlElement(), -1);
        }
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "StructureMap", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "StructureMap", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "StructureMap", "name", element.getNameElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "StructureMap", "title", element.getTitleElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "StructureMap", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "StructureMap", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "StructureMap", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "StructureMap", "publisher", element.getPublisherElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeContactDetail(t, "StructureMap", "contact", element.getContact().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "StructureMap", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getUseContext().size(); ++i) {
            this.composeUsageContext(t, "StructureMap", "useContext", element.getUseContext().get(i), i);
        }
        for (i = 0; i < element.getJurisdiction().size(); ++i) {
            this.composeCodeableConcept(t, "StructureMap", "jurisdiction", element.getJurisdiction().get(i), i);
        }
        if (element.hasPurposeElement()) {
            this.composeMarkdown(t, "StructureMap", "purpose", element.getPurposeElement(), -1);
        }
        if (element.hasCopyrightElement()) {
            this.composeMarkdown(t, "StructureMap", "copyright", element.getCopyrightElement(), -1);
        }
        for (i = 0; i < element.getStructure().size(); ++i) {
            this.composeStructureMapStructureMapStructureComponent(t, "StructureMap", "structure", element.getStructure().get(i), i);
        }
        for (i = 0; i < element.getImport().size(); ++i) {
            this.composeCanonical(t, "StructureMap", "import", element.getImport().get(i), i);
        }
        for (i = 0; i < element.getGroup().size(); ++i) {
            this.composeStructureMapStructureMapGroupComponent(t, "StructureMap", "group", element.getGroup().get(i), i);
        }
    }

    protected void composeStructureMapStructureMapStructureComponent(Turtle.Complex parent, String parentType, String name, StructureMap.StructureMapStructureComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "structure", name, element, index);
        if (element.hasUrlElement()) {
            this.composeCanonical(t, "StructureMap", "url", element.getUrlElement(), -1);
        }
        if (element.hasModeElement()) {
            this.composeEnum(t, "StructureMap", "mode", element.getModeElement(), -1);
        }
        if (element.hasAliasElement()) {
            this.composeString(t, "StructureMap", "alias", element.getAliasElement(), -1);
        }
        if (element.hasDocumentationElement()) {
            this.composeString(t, "StructureMap", "documentation", element.getDocumentationElement(), -1);
        }
    }

    protected void composeStructureMapStructureMapGroupComponent(Turtle.Complex parent, String parentType, String name, StructureMap.StructureMapGroupComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "group", name, element, index);
        if (element.hasNameElement()) {
            this.composeId(t, "StructureMap", "name", element.getNameElement(), -1);
        }
        if (element.hasExtendsElement()) {
            this.composeId(t, "StructureMap", "extends", element.getExtendsElement(), -1);
        }
        if (element.hasTypeModeElement()) {
            this.composeEnum(t, "StructureMap", "typeMode", element.getTypeModeElement(), -1);
        }
        if (element.hasDocumentationElement()) {
            this.composeString(t, "StructureMap", "documentation", element.getDocumentationElement(), -1);
        }
        for (i = 0; i < element.getInput().size(); ++i) {
            this.composeStructureMapStructureMapGroupInputComponent(t, "StructureMap", "input", element.getInput().get(i), i);
        }
        for (i = 0; i < element.getRule().size(); ++i) {
            this.composeStructureMapStructureMapGroupRuleComponent(t, "StructureMap", "rule", element.getRule().get(i), i);
        }
    }

    protected void composeStructureMapStructureMapGroupInputComponent(Turtle.Complex parent, String parentType, String name, StructureMap.StructureMapGroupInputComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "input", name, element, index);
        if (element.hasNameElement()) {
            this.composeId(t, "StructureMap", "name", element.getNameElement(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeString(t, "StructureMap", "type", element.getTypeElement(), -1);
        }
        if (element.hasModeElement()) {
            this.composeEnum(t, "StructureMap", "mode", element.getModeElement(), -1);
        }
        if (element.hasDocumentationElement()) {
            this.composeString(t, "StructureMap", "documentation", element.getDocumentationElement(), -1);
        }
    }

    protected void composeStructureMapStructureMapGroupRuleComponent(Turtle.Complex parent, String parentType, String name, StructureMap.StructureMapGroupRuleComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "rule", name, element, index);
        if (element.hasNameElement()) {
            this.composeId(t, "StructureMap", "name", element.getNameElement(), -1);
        }
        for (i = 0; i < element.getSource().size(); ++i) {
            this.composeStructureMapStructureMapGroupRuleSourceComponent(t, "StructureMap", "source", element.getSource().get(i), i);
        }
        for (i = 0; i < element.getTarget().size(); ++i) {
            this.composeStructureMapStructureMapGroupRuleTargetComponent(t, "StructureMap", "target", element.getTarget().get(i), i);
        }
        for (i = 0; i < element.getRule().size(); ++i) {
            this.composeStructureMapStructureMapGroupRuleComponent(t, "StructureMap", "rule", element.getRule().get(i), i);
        }
        for (i = 0; i < element.getDependent().size(); ++i) {
            this.composeStructureMapStructureMapGroupRuleDependentComponent(t, "StructureMap", "dependent", element.getDependent().get(i), i);
        }
        if (element.hasDocumentationElement()) {
            this.composeString(t, "StructureMap", "documentation", element.getDocumentationElement(), -1);
        }
    }

    protected void composeStructureMapStructureMapGroupRuleSourceComponent(Turtle.Complex parent, String parentType, String name, StructureMap.StructureMapGroupRuleSourceComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "source", name, element, index);
        if (element.hasContextElement()) {
            this.composeId(t, "StructureMap", "context", element.getContextElement(), -1);
        }
        if (element.hasMinElement()) {
            this.composeInteger(t, "StructureMap", "min", element.getMinElement(), -1);
        }
        if (element.hasMaxElement()) {
            this.composeString(t, "StructureMap", "max", element.getMaxElement(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeString(t, "StructureMap", "type", element.getTypeElement(), -1);
        }
        if (element.hasDefaultValue()) {
            this.composeType(t, "StructureMap", "defaultValue", element.getDefaultValue(), -1);
        }
        if (element.hasElementElement()) {
            this.composeString(t, "StructureMap", "element", element.getElementElement(), -1);
        }
        if (element.hasListModeElement()) {
            this.composeEnum(t, "StructureMap", "listMode", element.getListModeElement(), -1);
        }
        if (element.hasVariableElement()) {
            this.composeId(t, "StructureMap", "variable", element.getVariableElement(), -1);
        }
        if (element.hasConditionElement()) {
            this.composeString(t, "StructureMap", "condition", element.getConditionElement(), -1);
        }
        if (element.hasCheckElement()) {
            this.composeString(t, "StructureMap", "check", element.getCheckElement(), -1);
        }
        if (element.hasLogMessageElement()) {
            this.composeString(t, "StructureMap", "logMessage", element.getLogMessageElement(), -1);
        }
    }

    protected void composeStructureMapStructureMapGroupRuleTargetComponent(Turtle.Complex parent, String parentType, String name, StructureMap.StructureMapGroupRuleTargetComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "target", name, element, index);
        if (element.hasContextElement()) {
            this.composeId(t, "StructureMap", "context", element.getContextElement(), -1);
        }
        if (element.hasContextTypeElement()) {
            this.composeEnum(t, "StructureMap", "contextType", element.getContextTypeElement(), -1);
        }
        if (element.hasElementElement()) {
            this.composeString(t, "StructureMap", "element", element.getElementElement(), -1);
        }
        if (element.hasVariableElement()) {
            this.composeId(t, "StructureMap", "variable", element.getVariableElement(), -1);
        }
        for (i = 0; i < element.getListMode().size(); ++i) {
            this.composeEnum(t, "StructureMap", "listMode", element.getListMode().get(i), i);
        }
        if (element.hasListRuleIdElement()) {
            this.composeId(t, "StructureMap", "listRuleId", element.getListRuleIdElement(), -1);
        }
        if (element.hasTransformElement()) {
            this.composeEnum(t, "StructureMap", "transform", element.getTransformElement(), -1);
        }
        for (i = 0; i < element.getParameter().size(); ++i) {
            this.composeStructureMapStructureMapGroupRuleTargetParameterComponent(t, "StructureMap", "parameter", element.getParameter().get(i), i);
        }
    }

    protected void composeStructureMapStructureMapGroupRuleTargetParameterComponent(Turtle.Complex parent, String parentType, String name, StructureMap.StructureMapGroupRuleTargetParameterComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "parameter", name, element, index);
        if (element.hasValue()) {
            this.composeType(t, "StructureMap", "value", element.getValue(), -1);
        }
    }

    protected void composeStructureMapStructureMapGroupRuleDependentComponent(Turtle.Complex parent, String parentType, String name, StructureMap.StructureMapGroupRuleDependentComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "dependent", name, element, index);
        if (element.hasNameElement()) {
            this.composeId(t, "StructureMap", "name", element.getNameElement(), -1);
        }
        for (int i = 0; i < element.getVariable().size(); ++i) {
            this.composeString(t, "StructureMap", "variable", element.getVariable().get(i), i);
        }
    }

    protected void composeSubscription(Turtle.Complex parent, String parentType, String name, Subscription element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Subscription", name, element, index);
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Subscription", "status", element.getStatusElement(), -1);
        }
        for (int i = 0; i < element.getContact().size(); ++i) {
            this.composeContactPoint(t, "Subscription", "contact", element.getContact().get(i), i);
        }
        if (element.hasEndElement()) {
            this.composeInstant(t, "Subscription", "end", element.getEndElement(), -1);
        }
        if (element.hasReasonElement()) {
            this.composeString(t, "Subscription", "reason", element.getReasonElement(), -1);
        }
        if (element.hasCriteriaElement()) {
            this.composeString(t, "Subscription", "criteria", element.getCriteriaElement(), -1);
        }
        if (element.hasErrorElement()) {
            this.composeString(t, "Subscription", "error", element.getErrorElement(), -1);
        }
        if (element.hasChannel()) {
            this.composeSubscriptionSubscriptionChannelComponent(t, "Subscription", "channel", element.getChannel(), -1);
        }
    }

    protected void composeSubscriptionSubscriptionChannelComponent(Turtle.Complex parent, String parentType, String name, Subscription.SubscriptionChannelComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "channel", name, element, index);
        if (element.hasTypeElement()) {
            this.composeEnum(t, "Subscription", "type", element.getTypeElement(), -1);
        }
        if (element.hasEndpointElement()) {
            this.composeUrl(t, "Subscription", "endpoint", element.getEndpointElement(), -1);
        }
        if (element.hasPayloadElement()) {
            this.composeCode(t, "Subscription", "payload", element.getPayloadElement(), -1);
        }
        for (int i = 0; i < element.getHeader().size(); ++i) {
            this.composeString(t, "Subscription", "header", element.getHeader().get(i), i);
        }
    }

    protected void composeSubstance(Turtle.Complex parent, String parentType, String name, Substance element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Substance", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Substance", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Substance", "status", element.getStatusElement(), -1);
        }
        for (i = 0; i < element.getCategory().size(); ++i) {
            this.composeCodeableConcept(t, "Substance", "category", element.getCategory().get(i), i);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "Substance", "code", element.getCode(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "Substance", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getInstance().size(); ++i) {
            this.composeSubstanceSubstanceInstanceComponent(t, "Substance", "instance", element.getInstance().get(i), i);
        }
        for (i = 0; i < element.getIngredient().size(); ++i) {
            this.composeSubstanceSubstanceIngredientComponent(t, "Substance", "ingredient", element.getIngredient().get(i), i);
        }
    }

    protected void composeSubstanceSubstanceInstanceComponent(Turtle.Complex parent, String parentType, String name, Substance.SubstanceInstanceComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "instance", name, element, index);
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "Substance", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasExpiryElement()) {
            this.composeDateTime(t, "Substance", "expiry", element.getExpiryElement(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "Substance", "quantity", element.getQuantity(), -1);
        }
    }

    protected void composeSubstanceSubstanceIngredientComponent(Turtle.Complex parent, String parentType, String name, Substance.SubstanceIngredientComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "ingredient", name, element, index);
        if (element.hasQuantity()) {
            this.composeRatio(t, "Substance", "quantity", element.getQuantity(), -1);
        }
        if (element.hasSubstance()) {
            this.composeType(t, "Substance", "substance", element.getSubstance(), -1);
        }
    }

    protected void composeSubstanceNucleicAcid(Turtle.Complex parent, String parentType, String name, SubstanceNucleicAcid element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "SubstanceNucleicAcid", name, element, index);
        if (element.hasSequenceType()) {
            this.composeCodeableConcept(t, "SubstanceNucleicAcid", "sequenceType", element.getSequenceType(), -1);
        }
        if (element.hasNumberOfSubunitsElement()) {
            this.composeInteger(t, "SubstanceNucleicAcid", "numberOfSubunits", element.getNumberOfSubunitsElement(), -1);
        }
        if (element.hasAreaOfHybridisationElement()) {
            this.composeString(t, "SubstanceNucleicAcid", "areaOfHybridisation", element.getAreaOfHybridisationElement(), -1);
        }
        if (element.hasOligoNucleotideType()) {
            this.composeCodeableConcept(t, "SubstanceNucleicAcid", "oligoNucleotideType", element.getOligoNucleotideType(), -1);
        }
        for (int i = 0; i < element.getSubunit().size(); ++i) {
            this.composeSubstanceNucleicAcidSubstanceNucleicAcidSubunitComponent(t, "SubstanceNucleicAcid", "subunit", element.getSubunit().get(i), i);
        }
    }

    protected void composeSubstanceNucleicAcidSubstanceNucleicAcidSubunitComponent(Turtle.Complex parent, String parentType, String name, SubstanceNucleicAcid.SubstanceNucleicAcidSubunitComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "subunit", name, element, index);
        if (element.hasSubunitElement()) {
            this.composeInteger(t, "SubstanceNucleicAcid", "subunit", element.getSubunitElement(), -1);
        }
        if (element.hasSequenceElement()) {
            this.composeString(t, "SubstanceNucleicAcid", "sequence", element.getSequenceElement(), -1);
        }
        if (element.hasLengthElement()) {
            this.composeInteger(t, "SubstanceNucleicAcid", "length", element.getLengthElement(), -1);
        }
        if (element.hasSequenceAttachment()) {
            this.composeAttachment(t, "SubstanceNucleicAcid", "sequenceAttachment", element.getSequenceAttachment(), -1);
        }
        if (element.hasFivePrime()) {
            this.composeCodeableConcept(t, "SubstanceNucleicAcid", "fivePrime", element.getFivePrime(), -1);
        }
        if (element.hasThreePrime()) {
            this.composeCodeableConcept(t, "SubstanceNucleicAcid", "threePrime", element.getThreePrime(), -1);
        }
        for (i = 0; i < element.getLinkage().size(); ++i) {
            this.composeSubstanceNucleicAcidSubstanceNucleicAcidSubunitLinkageComponent(t, "SubstanceNucleicAcid", "linkage", element.getLinkage().get(i), i);
        }
        for (i = 0; i < element.getSugar().size(); ++i) {
            this.composeSubstanceNucleicAcidSubstanceNucleicAcidSubunitSugarComponent(t, "SubstanceNucleicAcid", "sugar", element.getSugar().get(i), i);
        }
    }

    protected void composeSubstanceNucleicAcidSubstanceNucleicAcidSubunitLinkageComponent(Turtle.Complex parent, String parentType, String name, SubstanceNucleicAcid.SubstanceNucleicAcidSubunitLinkageComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "linkage", name, element, index);
        if (element.hasConnectivityElement()) {
            this.composeString(t, "SubstanceNucleicAcid", "connectivity", element.getConnectivityElement(), -1);
        }
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "SubstanceNucleicAcid", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "SubstanceNucleicAcid", "name", element.getNameElement(), -1);
        }
        if (element.hasResidueSiteElement()) {
            this.composeString(t, "SubstanceNucleicAcid", "residueSite", element.getResidueSiteElement(), -1);
        }
    }

    protected void composeSubstanceNucleicAcidSubstanceNucleicAcidSubunitSugarComponent(Turtle.Complex parent, String parentType, String name, SubstanceNucleicAcid.SubstanceNucleicAcidSubunitSugarComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "sugar", name, element, index);
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "SubstanceNucleicAcid", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "SubstanceNucleicAcid", "name", element.getNameElement(), -1);
        }
        if (element.hasResidueSiteElement()) {
            this.composeString(t, "SubstanceNucleicAcid", "residueSite", element.getResidueSiteElement(), -1);
        }
    }

    protected void composeSubstancePolymer(Turtle.Complex parent, String parentType, String name, SubstancePolymer element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "SubstancePolymer", name, element, index);
        if (element.hasClass_()) {
            this.composeCodeableConcept(t, "SubstancePolymer", "class", element.getClass_(), -1);
        }
        if (element.hasGeometry()) {
            this.composeCodeableConcept(t, "SubstancePolymer", "geometry", element.getGeometry(), -1);
        }
        for (i = 0; i < element.getCopolymerConnectivity().size(); ++i) {
            this.composeCodeableConcept(t, "SubstancePolymer", "copolymerConnectivity", element.getCopolymerConnectivity().get(i), i);
        }
        for (i = 0; i < element.getModification().size(); ++i) {
            this.composeString(t, "SubstancePolymer", "modification", element.getModification().get(i), i);
        }
        for (i = 0; i < element.getMonomerSet().size(); ++i) {
            this.composeSubstancePolymerSubstancePolymerMonomerSetComponent(t, "SubstancePolymer", "monomerSet", element.getMonomerSet().get(i), i);
        }
        for (i = 0; i < element.getRepeat().size(); ++i) {
            this.composeSubstancePolymerSubstancePolymerRepeatComponent(t, "SubstancePolymer", "repeat", element.getRepeat().get(i), i);
        }
    }

    protected void composeSubstancePolymerSubstancePolymerMonomerSetComponent(Turtle.Complex parent, String parentType, String name, SubstancePolymer.SubstancePolymerMonomerSetComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "monomerSet", name, element, index);
        if (element.hasRatioType()) {
            this.composeCodeableConcept(t, "SubstancePolymer", "ratioType", element.getRatioType(), -1);
        }
        for (int i = 0; i < element.getStartingMaterial().size(); ++i) {
            this.composeSubstancePolymerSubstancePolymerMonomerSetStartingMaterialComponent(t, "SubstancePolymer", "startingMaterial", element.getStartingMaterial().get(i), i);
        }
    }

    protected void composeSubstancePolymerSubstancePolymerMonomerSetStartingMaterialComponent(Turtle.Complex parent, String parentType, String name, SubstancePolymer.SubstancePolymerMonomerSetStartingMaterialComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "startingMaterial", name, element, index);
        if (element.hasMaterial()) {
            this.composeCodeableConcept(t, "SubstancePolymer", "material", element.getMaterial(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "SubstancePolymer", "type", element.getType(), -1);
        }
        if (element.hasIsDefiningElement()) {
            this.composeBoolean(t, "SubstancePolymer", "isDefining", element.getIsDefiningElement(), -1);
        }
        if (element.hasAmount()) {
            this.composeSubstanceAmount(t, "SubstancePolymer", "amount", element.getAmount(), -1);
        }
    }

    protected void composeSubstancePolymerSubstancePolymerRepeatComponent(Turtle.Complex parent, String parentType, String name, SubstancePolymer.SubstancePolymerRepeatComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "repeat", name, element, index);
        if (element.hasNumberOfUnitsElement()) {
            this.composeInteger(t, "SubstancePolymer", "numberOfUnits", element.getNumberOfUnitsElement(), -1);
        }
        if (element.hasAverageMolecularFormulaElement()) {
            this.composeString(t, "SubstancePolymer", "averageMolecularFormula", element.getAverageMolecularFormulaElement(), -1);
        }
        if (element.hasRepeatUnitAmountType()) {
            this.composeCodeableConcept(t, "SubstancePolymer", "repeatUnitAmountType", element.getRepeatUnitAmountType(), -1);
        }
        for (int i = 0; i < element.getRepeatUnit().size(); ++i) {
            this.composeSubstancePolymerSubstancePolymerRepeatRepeatUnitComponent(t, "SubstancePolymer", "repeatUnit", element.getRepeatUnit().get(i), i);
        }
    }

    protected void composeSubstancePolymerSubstancePolymerRepeatRepeatUnitComponent(Turtle.Complex parent, String parentType, String name, SubstancePolymer.SubstancePolymerRepeatRepeatUnitComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "repeatUnit", name, element, index);
        if (element.hasOrientationOfPolymerisation()) {
            this.composeCodeableConcept(t, "SubstancePolymer", "orientationOfPolymerisation", element.getOrientationOfPolymerisation(), -1);
        }
        if (element.hasRepeatUnitElement()) {
            this.composeString(t, "SubstancePolymer", "repeatUnit", element.getRepeatUnitElement(), -1);
        }
        if (element.hasAmount()) {
            this.composeSubstanceAmount(t, "SubstancePolymer", "amount", element.getAmount(), -1);
        }
        for (i = 0; i < element.getDegreeOfPolymerisation().size(); ++i) {
            this.composeSubstancePolymerSubstancePolymerRepeatRepeatUnitDegreeOfPolymerisationComponent(t, "SubstancePolymer", "degreeOfPolymerisation", element.getDegreeOfPolymerisation().get(i), i);
        }
        for (i = 0; i < element.getStructuralRepresentation().size(); ++i) {
            this.composeSubstancePolymerSubstancePolymerRepeatRepeatUnitStructuralRepresentationComponent(t, "SubstancePolymer", "structuralRepresentation", element.getStructuralRepresentation().get(i), i);
        }
    }

    protected void composeSubstancePolymerSubstancePolymerRepeatRepeatUnitDegreeOfPolymerisationComponent(Turtle.Complex parent, String parentType, String name, SubstancePolymer.SubstancePolymerRepeatRepeatUnitDegreeOfPolymerisationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "degreeOfPolymerisation", name, element, index);
        if (element.hasDegree()) {
            this.composeCodeableConcept(t, "SubstancePolymer", "degree", element.getDegree(), -1);
        }
        if (element.hasAmount()) {
            this.composeSubstanceAmount(t, "SubstancePolymer", "amount", element.getAmount(), -1);
        }
    }

    protected void composeSubstancePolymerSubstancePolymerRepeatRepeatUnitStructuralRepresentationComponent(Turtle.Complex parent, String parentType, String name, SubstancePolymer.SubstancePolymerRepeatRepeatUnitStructuralRepresentationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "structuralRepresentation", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "SubstancePolymer", "type", element.getType(), -1);
        }
        if (element.hasRepresentationElement()) {
            this.composeString(t, "SubstancePolymer", "representation", element.getRepresentationElement(), -1);
        }
        if (element.hasAttachment()) {
            this.composeAttachment(t, "SubstancePolymer", "attachment", element.getAttachment(), -1);
        }
    }

    protected void composeSubstanceProtein(Turtle.Complex parent, String parentType, String name, SubstanceProtein element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "SubstanceProtein", name, element, index);
        if (element.hasSequenceType()) {
            this.composeCodeableConcept(t, "SubstanceProtein", "sequenceType", element.getSequenceType(), -1);
        }
        if (element.hasNumberOfSubunitsElement()) {
            this.composeInteger(t, "SubstanceProtein", "numberOfSubunits", element.getNumberOfSubunitsElement(), -1);
        }
        for (i = 0; i < element.getDisulfideLinkage().size(); ++i) {
            this.composeString(t, "SubstanceProtein", "disulfideLinkage", element.getDisulfideLinkage().get(i), i);
        }
        for (i = 0; i < element.getSubunit().size(); ++i) {
            this.composeSubstanceProteinSubstanceProteinSubunitComponent(t, "SubstanceProtein", "subunit", element.getSubunit().get(i), i);
        }
    }

    protected void composeSubstanceProteinSubstanceProteinSubunitComponent(Turtle.Complex parent, String parentType, String name, SubstanceProtein.SubstanceProteinSubunitComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "subunit", name, element, index);
        if (element.hasSubunitElement()) {
            this.composeInteger(t, "SubstanceProtein", "subunit", element.getSubunitElement(), -1);
        }
        if (element.hasSequenceElement()) {
            this.composeString(t, "SubstanceProtein", "sequence", element.getSequenceElement(), -1);
        }
        if (element.hasLengthElement()) {
            this.composeInteger(t, "SubstanceProtein", "length", element.getLengthElement(), -1);
        }
        if (element.hasSequenceAttachment()) {
            this.composeAttachment(t, "SubstanceProtein", "sequenceAttachment", element.getSequenceAttachment(), -1);
        }
        if (element.hasNTerminalModificationId()) {
            this.composeIdentifier(t, "SubstanceProtein", "nTerminalModificationId", element.getNTerminalModificationId(), -1);
        }
        if (element.hasNTerminalModificationElement()) {
            this.composeString(t, "SubstanceProtein", "nTerminalModification", element.getNTerminalModificationElement(), -1);
        }
        if (element.hasCTerminalModificationId()) {
            this.composeIdentifier(t, "SubstanceProtein", "cTerminalModificationId", element.getCTerminalModificationId(), -1);
        }
        if (element.hasCTerminalModificationElement()) {
            this.composeString(t, "SubstanceProtein", "cTerminalModification", element.getCTerminalModificationElement(), -1);
        }
    }

    protected void composeSubstanceReferenceInformation(Turtle.Complex parent, String parentType, String name, SubstanceReferenceInformation element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "SubstanceReferenceInformation", name, element, index);
        if (element.hasCommentElement()) {
            this.composeString(t, "SubstanceReferenceInformation", "comment", element.getCommentElement(), -1);
        }
        for (i = 0; i < element.getGene().size(); ++i) {
            this.composeSubstanceReferenceInformationSubstanceReferenceInformationGeneComponent(t, "SubstanceReferenceInformation", "gene", element.getGene().get(i), i);
        }
        for (i = 0; i < element.getClassification().size(); ++i) {
            this.composeSubstanceReferenceInformationSubstanceReferenceInformationClassificationComponent(t, "SubstanceReferenceInformation", "classification", element.getClassification().get(i), i);
        }
        for (i = 0; i < element.getTarget().size(); ++i) {
            this.composeSubstanceReferenceInformationSubstanceReferenceInformationTargetComponent(t, "SubstanceReferenceInformation", "target", element.getTarget().get(i), i);
        }
    }

    protected void composeSubstanceReferenceInformationSubstanceReferenceInformationGeneComponent(Turtle.Complex parent, String parentType, String name, SubstanceReferenceInformation.SubstanceReferenceInformationGeneComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "gene", name, element, index);
        if (element.hasGeneSequenceOrigin()) {
            this.composeCodeableConcept(t, "SubstanceReferenceInformation", "geneSequenceOrigin", element.getGeneSequenceOrigin(), -1);
        }
        if (element.hasGene()) {
            this.composeCodeableConcept(t, "SubstanceReferenceInformation", "gene", element.getGene(), -1);
        }
        for (int i = 0; i < element.getSource().size(); ++i) {
            this.composeReference(t, "SubstanceReferenceInformation", "source", element.getSource().get(i), i);
        }
    }

    protected void composeSubstanceReferenceInformationSubstanceReferenceInformationGeneElementComponent(Turtle.Complex parent, String parentType, String name, SubstanceReferenceInformation.SubstanceReferenceInformationGeneElementComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "geneElement", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "SubstanceReferenceInformation", "type", element.getType(), -1);
        }
        if (element.hasElement()) {
            this.composeIdentifier(t, "SubstanceReferenceInformation", "element", element.getElement(), -1);
        }
        for (int i = 0; i < element.getSource().size(); ++i) {
            this.composeReference(t, "SubstanceReferenceInformation", "source", element.getSource().get(i), i);
        }
    }

    protected void composeSubstanceReferenceInformationSubstanceReferenceInformationClassificationComponent(Turtle.Complex parent, String parentType, String name, SubstanceReferenceInformation.SubstanceReferenceInformationClassificationComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "classification", name, element, index);
        if (element.hasDomain()) {
            this.composeCodeableConcept(t, "SubstanceReferenceInformation", "domain", element.getDomain(), -1);
        }
        if (element.hasClassification()) {
            this.composeCodeableConcept(t, "SubstanceReferenceInformation", "classification", element.getClassification(), -1);
        }
        for (i = 0; i < element.getSubtype().size(); ++i) {
            this.composeCodeableConcept(t, "SubstanceReferenceInformation", "subtype", element.getSubtype().get(i), i);
        }
        for (i = 0; i < element.getSource().size(); ++i) {
            this.composeReference(t, "SubstanceReferenceInformation", "source", element.getSource().get(i), i);
        }
    }

    protected void composeSubstanceReferenceInformationSubstanceReferenceInformationTargetComponent(Turtle.Complex parent, String parentType, String name, SubstanceReferenceInformation.SubstanceReferenceInformationTargetComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "target", name, element, index);
        if (element.hasTarget()) {
            this.composeIdentifier(t, "SubstanceReferenceInformation", "target", element.getTarget(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "SubstanceReferenceInformation", "type", element.getType(), -1);
        }
        if (element.hasInteraction()) {
            this.composeCodeableConcept(t, "SubstanceReferenceInformation", "interaction", element.getInteraction(), -1);
        }
        if (element.hasOrganism()) {
            this.composeCodeableConcept(t, "SubstanceReferenceInformation", "organism", element.getOrganism(), -1);
        }
        if (element.hasOrganismType()) {
            this.composeCodeableConcept(t, "SubstanceReferenceInformation", "organismType", element.getOrganismType(), -1);
        }
        if (element.hasAmount()) {
            this.composeType(t, "SubstanceReferenceInformation", "amount", element.getAmount(), -1);
        }
        if (element.hasAmountType()) {
            this.composeCodeableConcept(t, "SubstanceReferenceInformation", "amountType", element.getAmountType(), -1);
        }
        for (int i = 0; i < element.getSource().size(); ++i) {
            this.composeReference(t, "SubstanceReferenceInformation", "source", element.getSource().get(i), i);
        }
    }

    protected void composeSubstanceSourceMaterial(Turtle.Complex parent, String parentType, String name, SubstanceSourceMaterial element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "SubstanceSourceMaterial", name, element, index);
        if (element.hasSourceMaterialClass()) {
            this.composeCodeableConcept(t, "SubstanceSourceMaterial", "sourceMaterialClass", element.getSourceMaterialClass(), -1);
        }
        if (element.hasSourceMaterialType()) {
            this.composeCodeableConcept(t, "SubstanceSourceMaterial", "sourceMaterialType", element.getSourceMaterialType(), -1);
        }
        if (element.hasSourceMaterialState()) {
            this.composeCodeableConcept(t, "SubstanceSourceMaterial", "sourceMaterialState", element.getSourceMaterialState(), -1);
        }
        if (element.hasOrganismId()) {
            this.composeIdentifier(t, "SubstanceSourceMaterial", "organismId", element.getOrganismId(), -1);
        }
        if (element.hasOrganismNameElement()) {
            this.composeString(t, "SubstanceSourceMaterial", "organismName", element.getOrganismNameElement(), -1);
        }
        for (i = 0; i < element.getParentSubstanceId().size(); ++i) {
            this.composeIdentifier(t, "SubstanceSourceMaterial", "parentSubstanceId", element.getParentSubstanceId().get(i), i);
        }
        for (i = 0; i < element.getParentSubstanceName().size(); ++i) {
            this.composeString(t, "SubstanceSourceMaterial", "parentSubstanceName", element.getParentSubstanceName().get(i), i);
        }
        for (i = 0; i < element.getCountryOfOrigin().size(); ++i) {
            this.composeCodeableConcept(t, "SubstanceSourceMaterial", "countryOfOrigin", element.getCountryOfOrigin().get(i), i);
        }
        for (i = 0; i < element.getGeographicalLocation().size(); ++i) {
            this.composeString(t, "SubstanceSourceMaterial", "geographicalLocation", element.getGeographicalLocation().get(i), i);
        }
        if (element.hasDevelopmentStage()) {
            this.composeCodeableConcept(t, "SubstanceSourceMaterial", "developmentStage", element.getDevelopmentStage(), -1);
        }
        for (i = 0; i < element.getFractionDescription().size(); ++i) {
            this.composeSubstanceSourceMaterialSubstanceSourceMaterialFractionDescriptionComponent(t, "SubstanceSourceMaterial", "fractionDescription", element.getFractionDescription().get(i), i);
        }
        if (element.hasOrganism()) {
            this.composeSubstanceSourceMaterialSubstanceSourceMaterialOrganismComponent(t, "SubstanceSourceMaterial", "organism", element.getOrganism(), -1);
        }
        for (i = 0; i < element.getPartDescription().size(); ++i) {
            this.composeSubstanceSourceMaterialSubstanceSourceMaterialPartDescriptionComponent(t, "SubstanceSourceMaterial", "partDescription", element.getPartDescription().get(i), i);
        }
    }

    protected void composeSubstanceSourceMaterialSubstanceSourceMaterialFractionDescriptionComponent(Turtle.Complex parent, String parentType, String name, SubstanceSourceMaterial.SubstanceSourceMaterialFractionDescriptionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "fractionDescription", name, element, index);
        if (element.hasFractionElement()) {
            this.composeString(t, "SubstanceSourceMaterial", "fraction", element.getFractionElement(), -1);
        }
        if (element.hasMaterialType()) {
            this.composeCodeableConcept(t, "SubstanceSourceMaterial", "materialType", element.getMaterialType(), -1);
        }
    }

    protected void composeSubstanceSourceMaterialSubstanceSourceMaterialOrganismComponent(Turtle.Complex parent, String parentType, String name, SubstanceSourceMaterial.SubstanceSourceMaterialOrganismComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "organism", name, element, index);
        if (element.hasFamily()) {
            this.composeCodeableConcept(t, "SubstanceSourceMaterial", "family", element.getFamily(), -1);
        }
        if (element.hasGenus()) {
            this.composeCodeableConcept(t, "SubstanceSourceMaterial", "genus", element.getGenus(), -1);
        }
        if (element.hasSpecies()) {
            this.composeCodeableConcept(t, "SubstanceSourceMaterial", "species", element.getSpecies(), -1);
        }
        if (element.hasIntraspecificType()) {
            this.composeCodeableConcept(t, "SubstanceSourceMaterial", "intraspecificType", element.getIntraspecificType(), -1);
        }
        if (element.hasIntraspecificDescriptionElement()) {
            this.composeString(t, "SubstanceSourceMaterial", "intraspecificDescription", element.getIntraspecificDescriptionElement(), -1);
        }
        for (int i = 0; i < element.getAuthor().size(); ++i) {
            this.composeSubstanceSourceMaterialSubstanceSourceMaterialOrganismAuthorComponent(t, "SubstanceSourceMaterial", "author", element.getAuthor().get(i), i);
        }
        if (element.hasHybrid()) {
            this.composeSubstanceSourceMaterialSubstanceSourceMaterialOrganismHybridComponent(t, "SubstanceSourceMaterial", "hybrid", element.getHybrid(), -1);
        }
        if (element.hasOrganismGeneral()) {
            this.composeSubstanceSourceMaterialSubstanceSourceMaterialOrganismOrganismGeneralComponent(t, "SubstanceSourceMaterial", "organismGeneral", element.getOrganismGeneral(), -1);
        }
    }

    protected void composeSubstanceSourceMaterialSubstanceSourceMaterialOrganismAuthorComponent(Turtle.Complex parent, String parentType, String name, SubstanceSourceMaterial.SubstanceSourceMaterialOrganismAuthorComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "author", name, element, index);
        if (element.hasAuthorType()) {
            this.composeCodeableConcept(t, "SubstanceSourceMaterial", "authorType", element.getAuthorType(), -1);
        }
        if (element.hasAuthorDescriptionElement()) {
            this.composeString(t, "SubstanceSourceMaterial", "authorDescription", element.getAuthorDescriptionElement(), -1);
        }
    }

    protected void composeSubstanceSourceMaterialSubstanceSourceMaterialOrganismHybridComponent(Turtle.Complex parent, String parentType, String name, SubstanceSourceMaterial.SubstanceSourceMaterialOrganismHybridComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "hybrid", name, element, index);
        if (element.hasMaternalOrganismIdElement()) {
            this.composeString(t, "SubstanceSourceMaterial", "maternalOrganismId", element.getMaternalOrganismIdElement(), -1);
        }
        if (element.hasMaternalOrganismNameElement()) {
            this.composeString(t, "SubstanceSourceMaterial", "maternalOrganismName", element.getMaternalOrganismNameElement(), -1);
        }
        if (element.hasPaternalOrganismIdElement()) {
            this.composeString(t, "SubstanceSourceMaterial", "paternalOrganismId", element.getPaternalOrganismIdElement(), -1);
        }
        if (element.hasPaternalOrganismNameElement()) {
            this.composeString(t, "SubstanceSourceMaterial", "paternalOrganismName", element.getPaternalOrganismNameElement(), -1);
        }
        if (element.hasHybridType()) {
            this.composeCodeableConcept(t, "SubstanceSourceMaterial", "hybridType", element.getHybridType(), -1);
        }
    }

    protected void composeSubstanceSourceMaterialSubstanceSourceMaterialOrganismOrganismGeneralComponent(Turtle.Complex parent, String parentType, String name, SubstanceSourceMaterial.SubstanceSourceMaterialOrganismOrganismGeneralComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "organismGeneral", name, element, index);
        if (element.hasKingdom()) {
            this.composeCodeableConcept(t, "SubstanceSourceMaterial", "kingdom", element.getKingdom(), -1);
        }
        if (element.hasPhylum()) {
            this.composeCodeableConcept(t, "SubstanceSourceMaterial", "phylum", element.getPhylum(), -1);
        }
        if (element.hasClass_()) {
            this.composeCodeableConcept(t, "SubstanceSourceMaterial", "class", element.getClass_(), -1);
        }
        if (element.hasOrder()) {
            this.composeCodeableConcept(t, "SubstanceSourceMaterial", "order", element.getOrder(), -1);
        }
    }

    protected void composeSubstanceSourceMaterialSubstanceSourceMaterialPartDescriptionComponent(Turtle.Complex parent, String parentType, String name, SubstanceSourceMaterial.SubstanceSourceMaterialPartDescriptionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "partDescription", name, element, index);
        if (element.hasPart()) {
            this.composeCodeableConcept(t, "SubstanceSourceMaterial", "part", element.getPart(), -1);
        }
        if (element.hasPartLocation()) {
            this.composeCodeableConcept(t, "SubstanceSourceMaterial", "partLocation", element.getPartLocation(), -1);
        }
    }

    protected void composeSubstanceSpecification(Turtle.Complex parent, String parentType, String name, SubstanceSpecification element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "SubstanceSpecification", name, element, index);
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "SubstanceSpecification", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "SubstanceSpecification", "type", element.getType(), -1);
        }
        if (element.hasStatus()) {
            this.composeCodeableConcept(t, "SubstanceSpecification", "status", element.getStatus(), -1);
        }
        if (element.hasDomain()) {
            this.composeCodeableConcept(t, "SubstanceSpecification", "domain", element.getDomain(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "SubstanceSpecification", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getSource().size(); ++i) {
            this.composeReference(t, "SubstanceSpecification", "source", element.getSource().get(i), i);
        }
        if (element.hasCommentElement()) {
            this.composeString(t, "SubstanceSpecification", "comment", element.getCommentElement(), -1);
        }
        for (i = 0; i < element.getMoiety().size(); ++i) {
            this.composeSubstanceSpecificationSubstanceSpecificationMoietyComponent(t, "SubstanceSpecification", "moiety", element.getMoiety().get(i), i);
        }
        for (i = 0; i < element.getProperty().size(); ++i) {
            this.composeSubstanceSpecificationSubstanceSpecificationPropertyComponent(t, "SubstanceSpecification", "property", element.getProperty().get(i), i);
        }
        if (element.hasReferenceInformation()) {
            this.composeReference(t, "SubstanceSpecification", "referenceInformation", element.getReferenceInformation(), -1);
        }
        if (element.hasStructure()) {
            this.composeSubstanceSpecificationSubstanceSpecificationStructureComponent(t, "SubstanceSpecification", "structure", element.getStructure(), -1);
        }
        for (i = 0; i < element.getCode().size(); ++i) {
            this.composeSubstanceSpecificationSubstanceSpecificationCodeComponent(t, "SubstanceSpecification", "code", element.getCode().get(i), i);
        }
        for (i = 0; i < element.getName().size(); ++i) {
            this.composeSubstanceSpecificationSubstanceSpecificationNameComponent(t, "SubstanceSpecification", "name", element.getName().get(i), i);
        }
        for (i = 0; i < element.getMolecularWeight().size(); ++i) {
            this.composeSubstanceSpecificationSubstanceSpecificationStructureIsotopeMolecularWeightComponent(t, "SubstanceSpecification", "molecularWeight", element.getMolecularWeight().get(i), i);
        }
        for (i = 0; i < element.getRelationship().size(); ++i) {
            this.composeSubstanceSpecificationSubstanceSpecificationRelationshipComponent(t, "SubstanceSpecification", "relationship", element.getRelationship().get(i), i);
        }
        if (element.hasNucleicAcid()) {
            this.composeReference(t, "SubstanceSpecification", "nucleicAcid", element.getNucleicAcid(), -1);
        }
        if (element.hasPolymer()) {
            this.composeReference(t, "SubstanceSpecification", "polymer", element.getPolymer(), -1);
        }
        if (element.hasProtein()) {
            this.composeReference(t, "SubstanceSpecification", "protein", element.getProtein(), -1);
        }
        if (element.hasSourceMaterial()) {
            this.composeReference(t, "SubstanceSpecification", "sourceMaterial", element.getSourceMaterial(), -1);
        }
    }

    protected void composeSubstanceSpecificationSubstanceSpecificationMoietyComponent(Turtle.Complex parent, String parentType, String name, SubstanceSpecification.SubstanceSpecificationMoietyComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "moiety", name, element, index);
        if (element.hasRole()) {
            this.composeCodeableConcept(t, "SubstanceSpecification", "role", element.getRole(), -1);
        }
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "SubstanceSpecification", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "SubstanceSpecification", "name", element.getNameElement(), -1);
        }
        if (element.hasStereochemistry()) {
            this.composeCodeableConcept(t, "SubstanceSpecification", "stereochemistry", element.getStereochemistry(), -1);
        }
        if (element.hasOpticalActivity()) {
            this.composeCodeableConcept(t, "SubstanceSpecification", "opticalActivity", element.getOpticalActivity(), -1);
        }
        if (element.hasMolecularFormulaElement()) {
            this.composeString(t, "SubstanceSpecification", "molecularFormula", element.getMolecularFormulaElement(), -1);
        }
        if (element.hasAmount()) {
            this.composeType(t, "SubstanceSpecification", "amount", element.getAmount(), -1);
        }
    }

    protected void composeSubstanceSpecificationSubstanceSpecificationPropertyComponent(Turtle.Complex parent, String parentType, String name, SubstanceSpecification.SubstanceSpecificationPropertyComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "property", name, element, index);
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "SubstanceSpecification", "category", element.getCategory(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "SubstanceSpecification", "code", element.getCode(), -1);
        }
        if (element.hasParametersElement()) {
            this.composeString(t, "SubstanceSpecification", "parameters", element.getParametersElement(), -1);
        }
        if (element.hasDefiningSubstance()) {
            this.composeType(t, "SubstanceSpecification", "definingSubstance", element.getDefiningSubstance(), -1);
        }
        if (element.hasAmount()) {
            this.composeType(t, "SubstanceSpecification", "amount", element.getAmount(), -1);
        }
    }

    protected void composeSubstanceSpecificationSubstanceSpecificationStructureComponent(Turtle.Complex parent, String parentType, String name, SubstanceSpecification.SubstanceSpecificationStructureComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "structure", name, element, index);
        if (element.hasStereochemistry()) {
            this.composeCodeableConcept(t, "SubstanceSpecification", "stereochemistry", element.getStereochemistry(), -1);
        }
        if (element.hasOpticalActivity()) {
            this.composeCodeableConcept(t, "SubstanceSpecification", "opticalActivity", element.getOpticalActivity(), -1);
        }
        if (element.hasMolecularFormulaElement()) {
            this.composeString(t, "SubstanceSpecification", "molecularFormula", element.getMolecularFormulaElement(), -1);
        }
        if (element.hasMolecularFormulaByMoietyElement()) {
            this.composeString(t, "SubstanceSpecification", "molecularFormulaByMoiety", element.getMolecularFormulaByMoietyElement(), -1);
        }
        for (i = 0; i < element.getIsotope().size(); ++i) {
            this.composeSubstanceSpecificationSubstanceSpecificationSt