/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4.model.BackboneElement;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Condition;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.Coverage;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.DateType;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Location;
import org.hl7.fhir.r4.model.Money;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.Patient;
import org.hl7.fhir.r4.model.Period;
import org.hl7.fhir.r4.model.PositiveIntType;
import org.hl7.fhir.r4.model.Practitioner;
import org.hl7.fhir.r4.model.PractitionerRole;
import org.hl7.fhir.r4.model.PrimitiveType;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.Quantity;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="CoverageEligibilityRequest", profile="http://hl7.org/fhir/StructureDefinition/CoverageEligibilityRequest")
public class CoverageEligibilityRequest
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Business Identifier for coverage eligiblity request", formalDefinition="A unique identifier assigned to this coverage eligiblity request.")
    protected List<Identifier> identifier;
    @Child(name="status", type={CodeType.class}, order=1, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="active | cancelled | draft | entered-in-error", formalDefinition="The status of the resource instance.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/fm-status")
    protected Enumeration<EligibilityRequestStatus> status;
    @Child(name="priority", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Desired processing priority", formalDefinition="When the requestor expects the processor to complete processing.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/process-priority")
    protected CodeableConcept priority;
    @Child(name="purpose", type={CodeType.class}, order=3, min=1, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="auth-requirements | benefits | discovery | validation", formalDefinition="Code to specify whether requesting: prior authorization requirements for some service categories or billing codes; benefits for coverages specified or discovered; discovery and return of coverages for the patient; and/or validation that the specified coverage is in-force at the date/period specified or 'now' if not specified.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/eligibilityrequest-purpose")
    protected List<Enumeration<EligibilityRequestPurpose>> purpose;
    @Child(name="patient", type={Patient.class}, order=4, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Intended recipient of products and services", formalDefinition="The party who is the beneficiary of the supplied coverage and for whom eligibility is sought.")
    protected Reference patient;
    protected Patient patientTarget;
    @Child(name="serviced", type={DateType.class, Period.class}, order=5, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Estimated date or dates of service", formalDefinition="The date or dates when the enclosed suite of services were performed or completed.")
    protected Type serviced;
    @Child(name="created", type={DateTimeType.class}, order=6, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Creation date", formalDefinition="The date when this resource was created.")
    protected DateTimeType created;
    @Child(name="enterer", type={Practitioner.class, PractitionerRole.class}, order=7, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Author", formalDefinition="Person who created the request.")
    protected Reference enterer;
    protected Resource entererTarget;
    @Child(name="provider", type={Practitioner.class, PractitionerRole.class, Organization.class}, order=8, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Party responsible for the request", formalDefinition="The provider which is responsible for the request.")
    protected Reference provider;
    protected Resource providerTarget;
    @Child(name="insurer", type={Organization.class}, order=9, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Coverage issuer", formalDefinition="The Insurer who issued the coverage in question and is the recipient of the request.")
    protected Reference insurer;
    protected Organization insurerTarget;
    @Child(name="facility", type={Location.class}, order=10, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Servicing facility", formalDefinition="Facility where the services are intended to be provided.")
    protected Reference facility;
    protected Location facilityTarget;
    @Child(name="supportingInfo", type={}, order=11, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Supporting information", formalDefinition="Additional information codes regarding exceptions, special considerations, the condition, situation, prior or concurrent issues.")
    protected List<SupportingInformationComponent> supportingInfo;
    @Child(name="insurance", type={}, order=12, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Patient insurance information", formalDefinition="Financial instruments for reimbursement for the health care products and services.")
    protected List<InsuranceComponent> insurance;
    @Child(name="item", type={}, order=13, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Item to be evaluated for eligibiity", formalDefinition="Service categories or billable services for which benefit details and/or an authorization prior to service delivery may be required by the payor.")
    protected List<DetailsComponent> item;
    private static final long serialVersionUID = 1371127108L;
    @SearchParamDefinition(name="identifier", path="CoverageEligibilityRequest.identifier", description="The business identifier of the Eligibility", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="provider", path="CoverageEligibilityRequest.provider", description="The reference to the provider", type="reference", providesMembershipIn={@Compartment(name="Practitioner")}, target={Organization.class, Practitioner.class, PractitionerRole.class})
    public static final String SP_PROVIDER = "provider";
    public static final ReferenceClientParam PROVIDER = new ReferenceClientParam("provider");
    public static final Include INCLUDE_PROVIDER = new Include("CoverageEligibilityRequest:provider").toLocked();
    @SearchParamDefinition(name="patient", path="CoverageEligibilityRequest.patient", description="The reference to the patient", type="reference", providesMembershipIn={@Compartment(name="Patient")}, target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("CoverageEligibilityRequest:patient").toLocked();
    @SearchParamDefinition(name="created", path="CoverageEligibilityRequest.created", description="The creation date for the EOB", type="date")
    public static final String SP_CREATED = "created";
    public static final DateClientParam CREATED = new DateClientParam("created");
    @SearchParamDefinition(name="enterer", path="CoverageEligibilityRequest.enterer", description="The party who is responsible for the request", type="reference", providesMembershipIn={@Compartment(name="Practitioner")}, target={Practitioner.class, PractitionerRole.class})
    public static final String SP_ENTERER = "enterer";
    public static final ReferenceClientParam ENTERER = new ReferenceClientParam("enterer");
    public static final Include INCLUDE_ENTERER = new Include("CoverageEligibilityRequest:enterer").toLocked();
    @SearchParamDefinition(name="facility", path="CoverageEligibilityRequest.facility", description="Facility responsible for the goods and services", type="reference", target={Location.class})
    public static final String SP_FACILITY = "facility";
    public static final ReferenceClientParam FACILITY = new ReferenceClientParam("facility");
    public static final Include INCLUDE_FACILITY = new Include("CoverageEligibilityRequest:facility").toLocked();
    @SearchParamDefinition(name="status", path="CoverageEligibilityRequest.status", description="The status of the EligibilityRequest", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public CoverageEligibilityRequest() {
    }

    public CoverageEligibilityRequest(Enumeration<EligibilityRequestStatus> status, Reference patient, DateTimeType created, Reference insurer) {
        this.status = status;
        this.patient = patient;
        this.created = created;
        this.insurer = insurer;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public CoverageEligibilityRequest setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public CoverageEligibilityRequest addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Enumeration<EligibilityRequestStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CoverageEligibilityRequest.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<EligibilityRequestStatus>(new EligibilityRequestStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public CoverageEligibilityRequest setStatusElement(Enumeration<EligibilityRequestStatus> value) {
        this.status = value;
        return this;
    }

    public EligibilityRequestStatus getStatus() {
        return this.status == null ? null : (EligibilityRequestStatus)((Object)this.status.getValue());
    }

    public CoverageEligibilityRequest setStatus(EligibilityRequestStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<EligibilityRequestStatus>(new EligibilityRequestStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public CodeableConcept getPriority() {
        if (this.priority == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CoverageEligibilityRequest.priority");
            }
            if (Configuration.doAutoCreate()) {
                this.priority = new CodeableConcept();
            }
        }
        return this.priority;
    }

    public boolean hasPriority() {
        return this.priority != null && !this.priority.isEmpty();
    }

    public CoverageEligibilityRequest setPriority(CodeableConcept value) {
        this.priority = value;
        return this;
    }

    public List<Enumeration<EligibilityRequestPurpose>> getPurpose() {
        if (this.purpose == null) {
            this.purpose = new ArrayList<Enumeration<EligibilityRequestPurpose>>();
        }
        return this.purpose;
    }

    public CoverageEligibilityRequest setPurpose(List<Enumeration<EligibilityRequestPurpose>> thePurpose) {
        this.purpose = thePurpose;
        return this;
    }

    public boolean hasPurpose() {
        if (this.purpose == null) {
            return false;
        }
        for (Enumeration<EligibilityRequestPurpose> item : this.purpose) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Enumeration<EligibilityRequestPurpose> addPurposeElement() {
        Enumeration<EligibilityRequestPurpose> t = new Enumeration<EligibilityRequestPurpose>(new EligibilityRequestPurposeEnumFactory());
        if (this.purpose == null) {
            this.purpose = new ArrayList<Enumeration<EligibilityRequestPurpose>>();
        }
        this.purpose.add(t);
        return t;
    }

    public CoverageEligibilityRequest addPurpose(EligibilityRequestPurpose value) {
        Enumeration<EligibilityRequestPurpose> t = new Enumeration<EligibilityRequestPurpose>(new EligibilityRequestPurposeEnumFactory());
        t.setValue((Object)value);
        if (this.purpose == null) {
            this.purpose = new ArrayList<Enumeration<EligibilityRequestPurpose>>();
        }
        this.purpose.add(t);
        return this;
    }

    public boolean hasPurpose(EligibilityRequestPurpose value) {
        if (this.purpose == null) {
            return false;
        }
        for (Enumeration<EligibilityRequestPurpose> v : this.purpose) {
            if (!((EligibilityRequestPurpose)((Object)v.getValue())).equals((Object)value)) continue;
            return true;
        }
        return false;
    }

    public Reference getPatient() {
        if (this.patient == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CoverageEligibilityRequest.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patient = new Reference();
            }
        }
        return this.patient;
    }

    public boolean hasPatient() {
        return this.patient != null && !this.patient.isEmpty();
    }

    public CoverageEligibilityRequest setPatient(Reference value) {
        this.patient = value;
        return this;
    }

    public Patient getPatientTarget() {
        if (this.patientTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CoverageEligibilityRequest.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patientTarget = new Patient();
            }
        }
        return this.patientTarget;
    }

    public CoverageEligibilityRequest setPatientTarget(Patient value) {
        this.patientTarget = value;
        return this;
    }

    public Type getServiced() {
        return this.serviced;
    }

    public DateType getServicedDateType() throws FHIRException {
        if (this.serviced == null) {
            this.serviced = new DateType();
        }
        if (!(this.serviced instanceof DateType)) {
            throw new FHIRException("Type mismatch: the type DateType was expected, but " + this.serviced.getClass().getName() + " was encountered");
        }
        return (DateType)this.serviced;
    }

    public boolean hasServicedDateType() {
        return this != null && this.serviced instanceof DateType;
    }

    public Period getServicedPeriod() throws FHIRException {
        if (this.serviced == null) {
            this.serviced = new Period();
        }
        if (!(this.serviced instanceof Period)) {
            throw new FHIRException("Type mismatch: the type Period was expected, but " + this.serviced.getClass().getName() + " was encountered");
        }
        return (Period)this.serviced;
    }

    public boolean hasServicedPeriod() {
        return this != null && this.serviced instanceof Period;
    }

    public boolean hasServiced() {
        return this.serviced != null && !this.serviced.isEmpty();
    }

    public CoverageEligibilityRequest setServiced(Type value) {
        if (value != null && !(value instanceof DateType) && !(value instanceof Period)) {
            throw new Error("Not the right type for CoverageEligibilityRequest.serviced[x]: " + value.fhirType());
        }
        this.serviced = value;
        return this;
    }

    public DateTimeType getCreatedElement() {
        if (this.created == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CoverageEligibilityRequest.created");
            }
            if (Configuration.doAutoCreate()) {
                this.created = new DateTimeType();
            }
        }
        return this.created;
    }

    public boolean hasCreatedElement() {
        return this.created != null && !this.created.isEmpty();
    }

    public boolean hasCreated() {
        return this.created != null && !this.created.isEmpty();
    }

    public CoverageEligibilityRequest setCreatedElement(DateTimeType value) {
        this.created = value;
        return this;
    }

    public Date getCreated() {
        return this.created == null ? null : (Date)this.created.getValue();
    }

    public CoverageEligibilityRequest setCreated(Date value) {
        if (this.created == null) {
            this.created = new DateTimeType();
        }
        this.created.setValue(value);
        return this;
    }

    public Reference getEnterer() {
        if (this.enterer == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CoverageEligibilityRequest.enterer");
            }
            if (Configuration.doAutoCreate()) {
                this.enterer = new Reference();
            }
        }
        return this.enterer;
    }

    public boolean hasEnterer() {
        return this.enterer != null && !this.enterer.isEmpty();
    }

    public CoverageEligibilityRequest setEnterer(Reference value) {
        this.enterer = value;
        return this;
    }

    public Resource getEntererTarget() {
        return this.entererTarget;
    }

    public CoverageEligibilityRequest setEntererTarget(Resource value) {
        this.entererTarget = value;
        return this;
    }

    public Reference getProvider() {
        if (this.provider == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CoverageEligibilityRequest.provider");
            }
            if (Configuration.doAutoCreate()) {
                this.provider = new Reference();
            }
        }
        return this.provider;
    }

    public boolean hasProvider() {
        return this.provider != null && !this.provider.isEmpty();
    }

    public CoverageEligibilityRequest setProvider(Reference value) {
        this.provider = value;
        return this;
    }

    public Resource getProviderTarget() {
        return this.providerTarget;
    }

    public CoverageEligibilityRequest setProviderTarget(Resource value) {
        this.providerTarget = value;
        return this;
    }

    public Reference getInsurer() {
        if (this.insurer == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CoverageEligibilityRequest.insurer");
            }
            if (Configuration.doAutoCreate()) {
                this.insurer = new Reference();
            }
        }
        return this.insurer;
    }

    public boolean hasInsurer() {
        return this.insurer != null && !this.insurer.isEmpty();
    }

    public CoverageEligibilityRequest setInsurer(Reference value) {
        this.insurer = value;
        return this;
    }

    public Organization getInsurerTarget() {
        if (this.insurerTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CoverageEligibilityRequest.insurer");
            }
            if (Configuration.doAutoCreate()) {
                this.insurerTarget = new Organization();
            }
        }
        return this.insurerTarget;
    }

    public CoverageEligibilityRequest setInsurerTarget(Organization value) {
        this.insurerTarget = value;
        return this;
    }

    public Reference getFacility() {
        if (this.facility == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CoverageEligibilityRequest.facility");
            }
            if (Configuration.doAutoCreate()) {
                this.facility = new Reference();
            }
        }
        return this.facility;
    }

    public boolean hasFacility() {
        return this.facility != null && !this.facility.isEmpty();
    }

    public CoverageEligibilityRequest setFacility(Reference value) {
        this.facility = value;
        return this;
    }

    public Location getFacilityTarget() {
        if (this.facilityTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CoverageEligibilityRequest.facility");
            }
            if (Configuration.doAutoCreate()) {
                this.facilityTarget = new Location();
            }
        }
        return this.facilityTarget;
    }

    public CoverageEligibilityRequest setFacilityTarget(Location value) {
        this.facilityTarget = value;
        return this;
    }

    public List<SupportingInformationComponent> getSupportingInfo() {
        if (this.supportingInfo == null) {
            this.supportingInfo = new ArrayList<SupportingInformationComponent>();
        }
        return this.supportingInfo;
    }

    public CoverageEligibilityRequest setSupportingInfo(List<SupportingInformationComponent> theSupportingInfo) {
        this.supportingInfo = theSupportingInfo;
        return this;
    }

    public boolean hasSupportingInfo() {
        if (this.supportingInfo == null) {
            return false;
        }
        for (SupportingInformationComponent item : this.supportingInfo) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public SupportingInformationComponent addSupportingInfo() {
        SupportingInformationComponent t = new SupportingInformationComponent();
        if (this.supportingInfo == null) {
            this.supportingInfo = new ArrayList<SupportingInformationComponent>();
        }
        this.supportingInfo.add(t);
        return t;
    }

    public CoverageEligibilityRequest addSupportingInfo(SupportingInformationComponent t) {
        if (t == null) {
            return this;
        }
        if (this.supportingInfo == null) {
            this.supportingInfo = new ArrayList<SupportingInformationComponent>();
        }
        this.supportingInfo.add(t);
        return this;
    }

    public SupportingInformationComponent getSupportingInfoFirstRep() {
        if (this.getSupportingInfo().isEmpty()) {
            this.addSupportingInfo();
        }
        return this.getSupportingInfo().get(0);
    }

    public List<InsuranceComponent> getInsurance() {
        if (this.insurance == null) {
            this.insurance = new ArrayList<InsuranceComponent>();
        }
        return this.insurance;
    }

    public CoverageEligibilityRequest setInsurance(List<InsuranceComponent> theInsurance) {
        this.insurance = theInsurance;
        return this;
    }

    public boolean hasInsurance() {
        if (this.insurance == null) {
            return false;
        }
        for (InsuranceComponent item : this.insurance) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public InsuranceComponent addInsurance() {
        InsuranceComponent t = new InsuranceComponent();
        if (this.insurance == null) {
            this.insurance = new ArrayList<InsuranceComponent>();
        }
        this.insurance.add(t);
        return t;
    }

    public CoverageEligibilityRequest addInsurance(InsuranceComponent t) {
        if (t == null) {
            return this;
        }
        if (this.insurance == null) {
            this.insurance = new ArrayList<InsuranceComponent>();
        }
        this.insurance.add(t);
        return this;
    }

    public InsuranceComponent getInsuranceFirstRep() {
        if (this.getInsurance().isEmpty()) {
            this.addInsurance();
        }
        return this.getInsurance().get(0);
    }

    public List<DetailsComponent> getItem() {
        if (this.item == null) {
            this.item = new ArrayList<DetailsComponent>();
        }
        return this.item;
    }

    public CoverageEligibilityRequest setItem(List<DetailsComponent> theItem) {
        this.item = theItem;
        return this;
    }

    public boolean hasItem() {
        if (this.item == null) {
            return false;
        }
        for (DetailsComponent item : this.item) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DetailsComponent addItem() {
        DetailsComponent t = new DetailsComponent();
        if (this.item == null) {
            this.item = new ArrayList<DetailsComponent>();
        }
        this.item.add(t);
        return t;
    }

    public CoverageEligibilityRequest addItem(DetailsComponent t) {
        if (t == null) {
            return this;
        }
        if (this.item == null) {
            this.item = new ArrayList<DetailsComponent>();
        }
        this.item.add(t);
        return this;
    }

    public DetailsComponent getItemFirstRep() {
        if (this.getItem().isEmpty()) {
            this.addItem();
        }
        return this.getItem().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "A unique identifier assigned to this coverage eligiblity request.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_STATUS, "code", "The status of the resource instance.", 0, 1, this.status));
        children.add(new Property("priority", "CodeableConcept", "When the requestor expects the processor to complete processing.", 0, 1, this.priority));
        children.add(new Property("purpose", "code", "Code to specify whether requesting: prior authorization requirements for some service categories or billing codes; benefits for coverages specified or discovered; discovery and return of coverages for the patient; and/or validation that the specified coverage is in-force at the date/period specified or 'now' if not specified.", 0, Integer.MAX_VALUE, this.purpose));
        children.add(new Property(SP_PATIENT, "Reference(Patient)", "The party who is the beneficiary of the supplied coverage and for whom eligibility is sought.", 0, 1, this.patient));
        children.add(new Property("serviced[x]", "date|Period", "The date or dates when the enclosed suite of services were performed or completed.", 0, 1, this.serviced));
        children.add(new Property(SP_CREATED, "dateTime", "The date when this resource was created.", 0, 1, this.created));
        children.add(new Property(SP_ENTERER, "Reference(Practitioner|PractitionerRole)", "Person who created the request.", 0, 1, this.enterer));
        children.add(new Property(SP_PROVIDER, "Reference(Practitioner|PractitionerRole|Organization)", "The provider which is responsible for the request.", 0, 1, this.provider));
        children.add(new Property("insurer", "Reference(Organization)", "The Insurer who issued the coverage in question and is the recipient of the request.", 0, 1, this.insurer));
        children.add(new Property(SP_FACILITY, "Reference(Location)", "Facility where the services are intended to be provided.", 0, 1, this.facility));
        children.add(new Property("supportingInfo", "", "Additional information codes regarding exceptions, special considerations, the condition, situation, prior or concurrent issues.", 0, Integer.MAX_VALUE, this.supportingInfo));
        children.add(new Property("insurance", "", "Financial instruments for reimbursement for the health care products and services.", 0, Integer.MAX_VALUE, this.insurance));
        children.add(new Property("item", "", "Service categories or billable services for which benefit details and/or an authorization prior to service delivery may be required by the payor.", 0, Integer.MAX_VALUE, this.item));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "A unique identifier assigned to this coverage eligiblity request.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The status of the resource instance.", 0, 1, this.status);
            }
            case -1165461084: {
                return new Property("priority", "CodeableConcept", "When the requestor expects the processor to complete processing.", 0, 1, this.priority);
            }
            case -220463842: {
                return new Property("purpose", "code", "Code to specify whether requesting: prior authorization requirements for some service categories or billing codes; benefits for coverages specified or discovered; discovery and return of coverages for the patient; and/or validation that the specified coverage is in-force at the date/period specified or 'now' if not specified.", 0, Integer.MAX_VALUE, this.purpose);
            }
            case -791418107: {
                return new Property(SP_PATIENT, "Reference(Patient)", "The party who is the beneficiary of the supplied coverage and for whom eligibility is sought.", 0, 1, this.patient);
            }
            case -1927922223: {
                return new Property("serviced[x]", "date|Period", "The date or dates when the enclosed suite of services were performed or completed.", 0, 1, this.serviced);
            }
            case 1379209295: {
                return new Property("serviced[x]", "date|Period", "The date or dates when the enclosed suite of services were performed or completed.", 0, 1, this.serviced);
            }
            case 363246749: {
                return new Property("serviced[x]", "date|Period", "The date or dates when the enclosed suite of services were performed or completed.", 0, 1, this.serviced);
            }
            case 1534966512: {
                return new Property("serviced[x]", "date|Period", "The date or dates when the enclosed suite of services were performed or completed.", 0, 1, this.serviced);
            }
            case 1028554472: {
                return new Property(SP_CREATED, "dateTime", "The date when this resource was created.", 0, 1, this.created);
            }
            case -1591951995: {
                return new Property(SP_ENTERER, "Reference(Practitioner|PractitionerRole)", "Person who created the request.", 0, 1, this.enterer);
            }
            case -987494927: {
                return new Property(SP_PROVIDER, "Reference(Practitioner|PractitionerRole|Organization)", "The provider which is responsible for the request.", 0, 1, this.provider);
            }
            case 1957615864: {
                return new Property("insurer", "Reference(Organization)", "The Insurer who issued the coverage in question and is the recipient of the request.", 0, 1, this.insurer);
            }
            case 501116579: {
                return new Property(SP_FACILITY, "Reference(Location)", "Facility where the services are intended to be provided.", 0, 1, this.facility);
            }
            case 1922406657: {
                return new Property("supportingInfo", "", "Additional information codes regarding exceptions, special considerations, the condition, situation, prior or concurrent issues.", 0, Integer.MAX_VALUE, this.supportingInfo);
            }
            case 73049818: {
                return new Property("insurance", "", "Financial instruments for reimbursement for the health care products and services.", 0, Integer.MAX_VALUE, this.insurance);
            }
            case 3242771: {
                return new Property("item", "", "Service categories or billable services for which benefit details and/or an authorization prior to service delivery may be required by the payor.", 0, Integer.MAX_VALUE, this.item);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case -1165461084: {
                Base[] baseArray;
                if (this.priority == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.priority;
                }
                return baseArray;
            }
            case -220463842: {
                return this.purpose == null ? new Base[]{} : this.purpose.toArray(new Base[this.purpose.size()]);
            }
            case -791418107: {
                Base[] baseArray;
                if (this.patient == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.patient;
                }
                return baseArray;
            }
            case 1379209295: {
                Base[] baseArray;
                if (this.serviced == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.serviced;
                }
                return baseArray;
            }
            case 1028554472: {
                Base[] baseArray;
                if (this.created == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.created;
                }
                return baseArray;
            }
            case -1591951995: {
                Base[] baseArray;
                if (this.enterer == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.enterer;
                }
                return baseArray;
            }
            case -987494927: {
                Base[] baseArray;
                if (this.provider == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.provider;
                }
                return baseArray;
            }
            case 1957615864: {
                Base[] baseArray;
                if (this.insurer == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.insurer;
                }
                return baseArray;
            }
            case 501116579: {
                Base[] baseArray;
                if (this.facility == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.facility;
                }
                return baseArray;
            }
            case 1922406657: {
                return this.supportingInfo == null ? new Base[]{} : this.supportingInfo.toArray(new Base[this.supportingInfo.size()]);
            }
            case 73049818: {
                return this.insurance == null ? new Base[]{} : this.insurance.toArray(new Base[this.insurance.size()]);
            }
            case 3242771: {
                return this.item == null ? new Base[]{} : this.item.toArray(new Base[this.item.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case -892481550: {
                value = new EligibilityRequestStatusEnumFactory().fromType(this.castToCode(value));
                this.status = value;
                return value;
            }
            case -1165461084: {
                this.priority = this.castToCodeableConcept(value);
                return value;
            }
            case -220463842: {
                value = new EligibilityRequestPurposeEnumFactory().fromType(this.castToCode(value));
                this.getPurpose().add(value);
                return value;
            }
            case -791418107: {
                this.patient = this.castToReference(value);
                return value;
            }
            case 1379209295: {
                this.serviced = this.castToType(value);
                return value;
            }
            case 1028554472: {
                this.created = this.castToDateTime(value);
                return value;
            }
            case -1591951995: {
                this.enterer = this.castToReference(value);
                return value;
            }
            case -987494927: {
                this.provider = this.castToReference(value);
                return value;
            }
            case 1957615864: {
                this.insurer = this.castToReference(value);
                return value;
            }
            case 501116579: {
                this.facility = this.castToReference(value);
                return value;
            }
            case 1922406657: {
                this.getSupportingInfo().add((SupportingInformationComponent)((Object)value));
                return value;
            }
            case 73049818: {
                this.getInsurance().add((InsuranceComponent)((Object)value));
                return value;
            }
            case 3242771: {
                this.getItem().add((DetailsComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_STATUS)) {
            value = new EligibilityRequestStatusEnumFactory().fromType(this.castToCode(value));
            this.status = value;
        } else if (name.equals("priority")) {
            this.priority = this.castToCodeableConcept(value);
        } else if (name.equals("purpose")) {
            value = new EligibilityRequestPurposeEnumFactory().fromType(this.castToCode(value));
            this.getPurpose().add(value);
        } else if (name.equals(SP_PATIENT)) {
            this.patient = this.castToReference(value);
        } else if (name.equals("serviced[x]")) {
            this.serviced = this.castToType(value);
        } else if (name.equals(SP_CREATED)) {
            this.created = this.castToDateTime(value);
        } else if (name.equals(SP_ENTERER)) {
            this.enterer = this.castToReference(value);
        } else if (name.equals(SP_PROVIDER)) {
            this.provider = this.castToReference(value);
        } else if (name.equals("insurer")) {
            this.insurer = this.castToReference(value);
        } else if (name.equals(SP_FACILITY)) {
            this.facility = this.castToReference(value);
        } else if (name.equals("supportingInfo")) {
            this.getSupportingInfo().add((SupportingInformationComponent)((Object)value));
        } else if (name.equals("insurance")) {
            this.getInsurance().add((InsuranceComponent)((Object)value));
        } else if (name.equals("item")) {
            this.getItem().add((DetailsComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public void removeChild(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().remove(this.castToIdentifier(value));
        } else if (name.equals(SP_STATUS)) {
            this.status = null;
        } else if (name.equals("priority")) {
            this.priority = null;
        } else if (name.equals("purpose")) {
            this.getPurpose().remove((Enumeration)value);
        } else if (name.equals(SP_PATIENT)) {
            this.patient = null;
        } else if (name.equals("serviced[x]")) {
            this.serviced = null;
        } else if (name.equals(SP_CREATED)) {
            this.created = null;
        } else if (name.equals(SP_ENTERER)) {
            this.enterer = null;
        } else if (name.equals(SP_PROVIDER)) {
            this.provider = null;
        } else if (name.equals("insurer")) {
            this.insurer = null;
        } else if (name.equals(SP_FACILITY)) {
            this.facility = null;
        } else if (name.equals("supportingInfo")) {
            this.getSupportingInfo().remove((SupportingInformationComponent)value);
        } else if (name.equals("insurance")) {
            this.getInsurance().remove((InsuranceComponent)value);
        } else if (name.equals("item")) {
            this.getItem().remove((DetailsComponent)value);
        } else {
            super.removeChild(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -1165461084: {
                return this.getPriority();
            }
            case -220463842: {
                return this.addPurposeElement();
            }
            case -791418107: {
                return this.getPatient();
            }
            case -1927922223: {
                return this.getServiced();
            }
            case 1379209295: {
                return this.getServiced();
            }
            case 1028554472: {
                return this.getCreatedElement();
            }
            case -1591951995: {
                return this.getEnterer();
            }
            case -987494927: {
                return this.getProvider();
            }
            case 1957615864: {
                return this.getInsurer();
            }
            case 501116579: {
                return this.getFacility();
            }
            case 1922406657: {
                return this.addSupportingInfo();
            }
            case 73049818: {
                return this.addInsurance();
            }
            case 3242771: {
                return this.addItem();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case -1165461084: {
                return new String[]{"CodeableConcept"};
            }
            case -220463842: {
                return new String[]{"code"};
            }
            case -791418107: {
                return new String[]{"Reference"};
            }
            case 1379209295: {
                return new String[]{"date", "Period"};
            }
            case 1028554472: {
                return new String[]{"dateTime"};
            }
            case -1591951995: {
                return new String[]{"Reference"};
            }
            case -987494927: {
                return new String[]{"Reference"};
            }
            case 1957615864: {
                return new String[]{"Reference"};
            }
            case 501116579: {
                return new String[]{"Reference"};
            }
            case 1922406657: {
                return new String[0];
            }
            case 73049818: {
                return new String[0];
            }
            case 3242771: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a singleton property CoverageEligibilityRequest.status");
        }
        if (name.equals("priority")) {
            this.priority = new CodeableConcept();
            return this.priority;
        }
        if (name.equals("purpose")) {
            throw new FHIRException("Cannot call addChild on a singleton property CoverageEligibilityRequest.purpose");
        }
        if (name.equals(SP_PATIENT)) {
            this.patient = new Reference();
            return this.patient;
        }
        if (name.equals("servicedDate")) {
            this.serviced = new DateType();
            return this.serviced;
        }
        if (name.equals("servicedPeriod")) {
            this.serviced = new Period();
            return this.serviced;
        }
        if (name.equals(SP_CREATED)) {
            throw new FHIRException("Cannot call addChild on a singleton property CoverageEligibilityRequest.created");
        }
        if (name.equals(SP_ENTERER)) {
            this.enterer = new Reference();
            return this.enterer;
        }
        if (name.equals(SP_PROVIDER)) {
            this.provider = new Reference();
            return this.provider;
        }
        if (name.equals("insurer")) {
            this.insurer = new Reference();
            return this.insurer;
        }
        if (name.equals(SP_FACILITY)) {
            this.facility = new Reference();
            return this.facility;
        }
        if (name.equals("supportingInfo")) {
            return this.addSupportingInfo();
        }
        if (name.equals("insurance")) {
            return this.addInsurance();
        }
        if (name.equals("item")) {
            return this.addItem();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "CoverageEligibilityRequest";
    }

    @Override
    public CoverageEligibilityRequest copy() {
        CoverageEligibilityRequest dst = new CoverageEligibilityRequest();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(CoverageEligibilityRequest dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        CodeableConcept codeableConcept = dst.priority = this.priority == null ? null : this.priority.copy();
        if (this.purpose != null) {
            dst.purpose = new ArrayList<Enumeration<EligibilityRequestPurpose>>();
            for (Enumeration enumeration : this.purpose) {
                dst.purpose.add((Enumeration<EligibilityRequestPurpose>)enumeration.copy());
            }
        }
        dst.patient = this.patient == null ? null : this.patient.copy();
        dst.serviced = this.serviced == null ? null : this.serviced.copy();
        dst.created = this.created == null ? null : this.created.copy();
        dst.enterer = this.enterer == null ? null : this.enterer.copy();
        dst.provider = this.provider == null ? null : this.provider.copy();
        dst.insurer = this.insurer == null ? null : this.insurer.copy();
        Reference reference = dst.facility = this.facility == null ? null : this.facility.copy();
        if (this.supportingInfo != null) {
            dst.supportingInfo = new ArrayList<SupportingInformationComponent>();
            for (SupportingInformationComponent supportingInformationComponent : this.supportingInfo) {
                dst.supportingInfo.add(supportingInformationComponent.copy());
            }
        }
        if (this.insurance != null) {
            dst.insurance = new ArrayList<InsuranceComponent>();
            for (InsuranceComponent insuranceComponent : this.insurance) {
                dst.insurance.add(insuranceComponent.copy());
            }
        }
        if (this.item != null) {
            dst.item = new ArrayList<DetailsComponent>();
            for (DetailsComponent detailsComponent : this.item) {
                dst.item.add(detailsComponent.copy());
            }
        }
    }

    protected CoverageEligibilityRequest typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof CoverageEligibilityRequest)) {
            return false;
        }
        CoverageEligibilityRequest o = (CoverageEligibilityRequest)other_;
        return CoverageEligibilityRequest.compareDeep(this.identifier, o.identifier, true) && CoverageEligibilityRequest.compareDeep(this.status, o.status, true) && CoverageEligibilityRequest.compareDeep(this.priority, o.priority, true) && CoverageEligibilityRequest.compareDeep(this.purpose, o.purpose, true) && CoverageEligibilityRequest.compareDeep(this.patient, o.patient, true) && CoverageEligibilityRequest.compareDeep(this.serviced, o.serviced, true) && CoverageEligibilityRequest.compareDeep(this.created, o.created, true) && CoverageEligibilityRequest.compareDeep(this.enterer, o.enterer, true) && CoverageEligibilityRequest.compareDeep(this.provider, o.provider, true) && CoverageEligibilityRequest.compareDeep(this.insurer, o.insurer, true) && CoverageEligibilityRequest.compareDeep(this.facility, o.facility, true) && CoverageEligibilityRequest.compareDeep(this.supportingInfo, o.supportingInfo, true) && CoverageEligibilityRequest.compareDeep(this.insurance, o.insurance, true) && CoverageEligibilityRequest.compareDeep(this.item, o.item, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof CoverageEligibilityRequest)) {
            return false;
        }
        CoverageEligibilityRequest o = (CoverageEligibilityRequest)other_;
        return CoverageEligibilityRequest.compareValues(this.status, o.status, true) && CoverageEligibilityRequest.compareValues(this.purpose, o.purpose, true) && CoverageEligibilityRequest.compareValues(this.created, o.created, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.status, this.priority, this.purpose, this.patient, this.serviced, this.created, this.enterer, this.provider, this.insurer, this.facility, this.supportingInfo, this.insurance, this.item});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.CoverageEligibilityRequest;
    }

    @Block
    public static class DiagnosisComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="diagnosis", type={CodeableConcept.class, Condition.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Nature of illness or problem", formalDefinition="The nature of illness or problem in a coded form or as a reference to an external defined Condition.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/icd-10")
        protected Type diagnosis;
        private static final long serialVersionUID = -454532709L;

        public Type getDiagnosis() {
            return this.diagnosis;
        }

        public CodeableConcept getDiagnosisCodeableConcept() throws FHIRException {
            if (this.diagnosis == null) {
                this.diagnosis = new CodeableConcept();
            }
            if (!(this.diagnosis instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.diagnosis.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.diagnosis;
        }

        public boolean hasDiagnosisCodeableConcept() {
            return this != null && this.diagnosis instanceof CodeableConcept;
        }

        public Reference getDiagnosisReference() throws FHIRException {
            if (this.diagnosis == null) {
                this.diagnosis = new Reference();
            }
            if (!(this.diagnosis instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.diagnosis.getClass().getName() + " was encountered");
            }
            return (Reference)this.diagnosis;
        }

        public boolean hasDiagnosisReference() {
            return this != null && this.diagnosis instanceof Reference;
        }

        public boolean hasDiagnosis() {
            return this.diagnosis != null && !this.diagnosis.isEmpty();
        }

        public DiagnosisComponent setDiagnosis(Type value) {
            if (value != null && !(value instanceof CodeableConcept) && !(value instanceof Reference)) {
                throw new Error("Not the right type for CoverageEligibilityRequest.item.diagnosis.diagnosis[x]: " + value.fhirType());
            }
            this.diagnosis = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("diagnosis[x]", "CodeableConcept|Reference(Condition)", "The nature of illness or problem in a coded form or as a reference to an external defined Condition.", 0, 1, this.diagnosis));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1487009809: {
                    return new Property("diagnosis[x]", "CodeableConcept|Reference(Condition)", "The nature of illness or problem in a coded form or as a reference to an external defined Condition.", 0, 1, this.diagnosis);
                }
                case 1196993265: {
                    return new Property("diagnosis[x]", "CodeableConcept|Reference(Condition)", "The nature of illness or problem in a coded form or as a reference to an external defined Condition.", 0, 1, this.diagnosis);
                }
                case 277781616: {
                    return new Property("diagnosis[x]", "CodeableConcept|Reference(Condition)", "The nature of illness or problem in a coded form or as a reference to an external defined Condition.", 0, 1, this.diagnosis);
                }
                case 2050454362: {
                    return new Property("diagnosis[x]", "CodeableConcept|Reference(Condition)", "The nature of illness or problem in a coded form or as a reference to an external defined Condition.", 0, 1, this.diagnosis);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1196993265: {
                    Base[] baseArray;
                    if (this.diagnosis == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.diagnosis;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1196993265: {
                    this.diagnosis = this.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (!name.equals("diagnosis[x]")) {
                return super.setProperty(name, value);
            }
            this.diagnosis = this.castToType(value);
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("diagnosis[x]")) {
                this.diagnosis = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1487009809: {
                    return this.getDiagnosis();
                }
                case 1196993265: {
                    return this.getDiagnosis();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1196993265: {
                    return new String[]{"CodeableConcept", "Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("diagnosisCodeableConcept")) {
                this.diagnosis = new CodeableConcept();
                return this.diagnosis;
            }
            if (name.equals("diagnosisReference")) {
                this.diagnosis = new Reference();
                return this.diagnosis;
            }
            return super.addChild(name);
        }

        @Override
        public DiagnosisComponent copy() {
            DiagnosisComponent dst = new DiagnosisComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(DiagnosisComponent dst) {
            super.copyValues(dst);
            dst.diagnosis = this.diagnosis == null ? null : this.diagnosis.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof DiagnosisComponent)) {
                return false;
            }
            DiagnosisComponent o = (DiagnosisComponent)other_;
            return DiagnosisComponent.compareDeep(this.diagnosis, o.diagnosis, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof DiagnosisComponent)) {
                return false;
            }
            DiagnosisComponent o = (DiagnosisComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.diagnosis});
        }

        @Override
        public String fhirType() {
            return "CoverageEligibilityRequest.item.diagnosis";
        }
    }

    @Block
    public static class DetailsComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="supportingInfoSequence", type={PositiveIntType.class}, order=1, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Applicable exception or supporting information", formalDefinition="Exceptions, special conditions and supporting information applicable for this service or product line.")
        protected List<PositiveIntType> supportingInfoSequence;
        @Child(name="category", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Benefit classification", formalDefinition="Code to identify the general type of benefits under which products and services are provided.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/ex-benefitcategory")
        protected CodeableConcept category;
        @Child(name="productOrService", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Billing, service, product, or drug code", formalDefinition="This contains the product, service, drug or other billing code for the item.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/service-uscls")
        protected CodeableConcept productOrService;
        @Child(name="modifier", type={CodeableConcept.class}, order=4, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Product or service billing modifiers", formalDefinition="Item typification or modifiers codes to convey additional context for the product or service.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/claim-modifiers")
        protected List<CodeableConcept> modifier;
        @Child(name="provider", type={Practitioner.class, PractitionerRole.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Perfoming practitioner", formalDefinition="The practitioner who is responsible for the product or service to be rendered to the patient.")
        protected Reference provider;
        protected Resource providerTarget;
        @Child(name="quantity", type={Quantity.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Count of products or services", formalDefinition="The number of repetitions of a service or product.")
        protected Quantity quantity;
        @Child(name="unitPrice", type={Money.class}, order=7, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Fee, charge or cost per item", formalDefinition="The amount charged to the patient by the provider for a single unit.")
        protected Money unitPrice;
        @Child(name="facility", type={Location.class, Organization.class}, order=8, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Servicing facility", formalDefinition="Facility where the services will be provided.")
        protected Reference facility;
        protected Resource facilityTarget;
        @Child(name="diagnosis", type={}, order=9, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Applicable diagnosis", formalDefinition="Patient diagnosis for which care is sought.")
        protected List<DiagnosisComponent> diagnosis;
        @Child(name="detail", type={Reference.class}, order=10, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Product or service details", formalDefinition="The plan/proposal/order describing the proposed service in detail.")
        protected List<Reference> detail;
        protected List<Resource> detailTarget;
        private static final long serialVersionUID = 389110539L;

        public List<PositiveIntType> getSupportingInfoSequence() {
            if (this.supportingInfoSequence == null) {
                this.supportingInfoSequence = new ArrayList<PositiveIntType>();
            }
            return this.supportingInfoSequence;
        }

        public DetailsComponent setSupportingInfoSequence(List<PositiveIntType> theSupportingInfoSequence) {
            this.supportingInfoSequence = theSupportingInfoSequence;
            return this;
        }

        public boolean hasSupportingInfoSequence() {
            if (this.supportingInfoSequence == null) {
                return false;
            }
            for (PositiveIntType item : this.supportingInfoSequence) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public PositiveIntType addSupportingInfoSequenceElement() {
            PositiveIntType t = new PositiveIntType();
            if (this.supportingInfoSequence == null) {
                this.supportingInfoSequence = new ArrayList<PositiveIntType>();
            }
            this.supportingInfoSequence.add(t);
            return t;
        }

        public DetailsComponent addSupportingInfoSequence(int value) {
            PositiveIntType t = new PositiveIntType();
            t.setValue((Object)value);
            if (this.supportingInfoSequence == null) {
                this.supportingInfoSequence = new ArrayList<PositiveIntType>();
            }
            this.supportingInfoSequence.add(t);
            return this;
        }

        public boolean hasSupportingInfoSequence(int value) {
            if (this.supportingInfoSequence == null) {
                return false;
            }
            for (PositiveIntType v : this.supportingInfoSequence) {
                if (!((Integer)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept getCategory() {
            if (this.category == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DetailsComponent.category");
                }
                if (Configuration.doAutoCreate()) {
                    this.category = new CodeableConcept();
                }
            }
            return this.category;
        }

        public boolean hasCategory() {
            return this.category != null && !this.category.isEmpty();
        }

        public DetailsComponent setCategory(CodeableConcept value) {
            this.category = value;
            return this;
        }

        public CodeableConcept getProductOrService() {
            if (this.productOrService == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DetailsComponent.productOrService");
                }
                if (Configuration.doAutoCreate()) {
                    this.productOrService = new CodeableConcept();
                }
            }
            return this.productOrService;
        }

        public boolean hasProductOrService() {
            return this.productOrService != null && !this.productOrService.isEmpty();
        }

        public DetailsComponent setProductOrService(CodeableConcept value) {
            this.productOrService = value;
            return this;
        }

        public List<CodeableConcept> getModifier() {
            if (this.modifier == null) {
                this.modifier = new ArrayList<CodeableConcept>();
            }
            return this.modifier;
        }

        public DetailsComponent setModifier(List<CodeableConcept> theModifier) {
            this.modifier = theModifier;
            return this;
        }

        public boolean hasModifier() {
            if (this.modifier == null) {
                return false;
            }
            for (CodeableConcept item : this.modifier) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addModifier() {
            CodeableConcept t = new CodeableConcept();
            if (this.modifier == null) {
                this.modifier = new ArrayList<CodeableConcept>();
            }
            this.modifier.add(t);
            return t;
        }

        public DetailsComponent addModifier(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.modifier == null) {
                this.modifier = new ArrayList<CodeableConcept>();
            }
            this.modifier.add(t);
            return this;
        }

        public CodeableConcept getModifierFirstRep() {
            if (this.getModifier().isEmpty()) {
                this.addModifier();
            }
            return this.getModifier().get(0);
        }

        public Reference getProvider() {
            if (this.provider == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DetailsComponent.provider");
                }
                if (Configuration.doAutoCreate()) {
                    this.provider = new Reference();
                }
            }
            return this.provider;
        }

        public boolean hasProvider() {
            return this.provider != null && !this.provider.isEmpty();
        }

        public DetailsComponent setProvider(Reference value) {
            this.provider = value;
            return this;
        }

        public Resource getProviderTarget() {
            return this.providerTarget;
        }

        public DetailsComponent setProviderTarget(Resource value) {
            this.providerTarget = value;
            return this;
        }

        public Quantity getQuantity() {
            if (this.quantity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DetailsComponent.quantity");
                }
                if (Configuration.doAutoCreate()) {
                    this.quantity = new Quantity();
                }
            }
            return this.quantity;
        }

        public boolean hasQuantity() {
            return this.quantity != null && !this.quantity.isEmpty();
        }

        public DetailsComponent setQuantity(Quantity value) {
            this.quantity = value;
            return this;
        }

        public Money getUnitPrice() {
            if (this.unitPrice == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DetailsComponent.unitPrice");
                }
                if (Configuration.doAutoCreate()) {
                    this.unitPrice = new Money();
                }
            }
            return this.unitPrice;
        }

        public boolean hasUnitPrice() {
            return this.unitPrice != null && !this.unitPrice.isEmpty();
        }

        public DetailsComponent setUnitPrice(Money value) {
            this.unitPrice = value;
            return this;
        }

        public Reference getFacility() {
            if (this.facility == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DetailsComponent.facility");
                }
                if (Configuration.doAutoCreate()) {
                    this.facility = new Reference();
                }
            }
            return this.facility;
        }

        public boolean hasFacility() {
            return this.facility != null && !this.facility.isEmpty();
        }

        public DetailsComponent setFacility(Reference value) {
            this.facility = value;
            return this;
        }

        public Resource getFacilityTarget() {
            return this.facilityTarget;
        }

        public DetailsComponent setFacilityTarget(Resource value) {
            this.facilityTarget = value;
            return this;
        }

        public List<DiagnosisComponent> getDiagnosis() {
            if (this.diagnosis == null) {
                this.diagnosis = new ArrayList<DiagnosisComponent>();
            }
            return this.diagnosis;
        }

        public DetailsComponent setDiagnosis(List<DiagnosisComponent> theDiagnosis) {
            this.diagnosis = theDiagnosis;
            return this;
        }

        public boolean hasDiagnosis() {
            if (this.diagnosis == null) {
                return false;
            }
            for (DiagnosisComponent item : this.diagnosis) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public DiagnosisComponent addDiagnosis() {
            DiagnosisComponent t = new DiagnosisComponent();
            if (this.diagnosis == null) {
                this.diagnosis = new ArrayList<DiagnosisComponent>();
            }
            this.diagnosis.add(t);
            return t;
        }

        public DetailsComponent addDiagnosis(DiagnosisComponent t) {
            if (t == null) {
                return this;
            }
            if (this.diagnosis == null) {
                this.diagnosis = new ArrayList<DiagnosisComponent>();
            }
            this.diagnosis.add(t);
            return this;
        }

        public DiagnosisComponent getDiagnosisFirstRep() {
            if (this.getDiagnosis().isEmpty()) {
                this.addDiagnosis();
            }
            return this.getDiagnosis().get(0);
        }

        public List<Reference> getDetail() {
            if (this.detail == null) {
                this.detail = new ArrayList<Reference>();
            }
            return this.detail;
        }

        public DetailsComponent setDetail(List<Reference> theDetail) {
            this.detail = theDetail;
            return this;
        }

        public boolean hasDetail() {
            if (this.detail == null) {
                return false;
            }
            for (Reference item : this.detail) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addDetail() {
            Reference t = new Reference();
            if (this.detail == null) {
                this.detail = new ArrayList<Reference>();
            }
            this.detail.add(t);
            return t;
        }

        public DetailsComponent addDetail(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.detail == null) {
                this.detail = new ArrayList<Reference>();
            }
            this.detail.add(t);
            return this;
        }

        public Reference getDetailFirstRep() {
            if (this.getDetail().isEmpty()) {
                this.addDetail();
            }
            return this.getDetail().get(0);
        }

        @Deprecated
        public List<Resource> getDetailTarget() {
            if (this.detailTarget == null) {
                this.detailTarget = new ArrayList<Resource>();
            }
            return this.detailTarget;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("supportingInfoSequence", "positiveInt", "Exceptions, special conditions and supporting information applicable for this service or product line.", 0, Integer.MAX_VALUE, this.supportingInfoSequence));
            children.add(new Property("category", "CodeableConcept", "Code to identify the general type of benefits under which products and services are provided.", 0, 1, this.category));
            children.add(new Property("productOrService", "CodeableConcept", "This contains the product, service, drug or other billing code for the item.", 0, 1, this.productOrService));
            children.add(new Property("modifier", "CodeableConcept", "Item typification or modifiers codes to convey additional context for the product or service.", 0, Integer.MAX_VALUE, this.modifier));
            children.add(new Property(CoverageEligibilityRequest.SP_PROVIDER, "Reference(Practitioner|PractitionerRole)", "The practitioner who is responsible for the product or service to be rendered to the patient.", 0, 1, this.provider));
            children.add(new Property("quantity", "SimpleQuantity", "The number of repetitions of a service or product.", 0, 1, this.quantity));
            children.add(new Property("unitPrice", "Money", "The amount charged to the patient by the provider for a single unit.", 0, 1, this.unitPrice));
            children.add(new Property(CoverageEligibilityRequest.SP_FACILITY, "Reference(Location|Organization)", "Facility where the services will be provided.", 0, 1, this.facility));
            children.add(new Property("diagnosis", "", "Patient diagnosis for which care is sought.", 0, Integer.MAX_VALUE, this.diagnosis));
            children.add(new Property("detail", "Reference(Any)", "The plan/proposal/order describing the proposed service in detail.", 0, Integer.MAX_VALUE, this.detail));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -595860510: {
                    return new Property("supportingInfoSequence", "positiveInt", "Exceptions, special conditions and supporting information applicable for this service or product line.", 0, Integer.MAX_VALUE, this.supportingInfoSequence);
                }
                case 50511102: {
                    return new Property("category", "CodeableConcept", "Code to identify the general type of benefits under which products and services are provided.", 0, 1, this.category);
                }
                case 1957227299: {
                    return new Property("productOrService", "CodeableConcept", "This contains the product, service, drug or other billing code for the item.", 0, 1, this.productOrService);
                }
                case -615513385: {
                    return new Property("modifier", "CodeableConcept", "Item typification or modifiers codes to convey additional context for the product or service.", 0, Integer.MAX_VALUE, this.modifier);
                }
                case -987494927: {
                    return new Property(CoverageEligibilityRequest.SP_PROVIDER, "Reference(Practitioner|PractitionerRole)", "The practitioner who is responsible for the product or service to be rendered to the patient.", 0, 1, this.provider);
                }
                case -1285004149: {
                    return new Property("quantity", "SimpleQuantity", "The number of repetitions of a service or product.", 0, 1, this.quantity);
                }
                case -486196699: {
                    return new Property("unitPrice", "Money", "The amount charged to the patient by the provider for a single unit.", 0, 1, this.unitPrice);
                }
                case 501116579: {
                    return new Property(CoverageEligibilityRequest.SP_FACILITY, "Reference(Location|Organization)", "Facility where the services will be provided.", 0, 1, this.facility);
                }
                case 1196993265: {
                    return new Property("diagnosis", "", "Patient diagnosis for which care is sought.", 0, Integer.MAX_VALUE, this.diagnosis);
                }
                case -1335224239: {
                    return new Property("detail", "Reference(Any)", "The plan/proposal/order describing the proposed service in detail.", 0, Integer.MAX_VALUE, this.detail);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -595860510: {
                    return this.supportingInfoSequence == null ? new Base[]{} : this.supportingInfoSequence.toArray(new Base[this.supportingInfoSequence.size()]);
                }
                case 50511102: {
                    Base[] baseArray;
                    if (this.category == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.category;
                    }
                    return baseArray;
                }
                case 1957227299: {
                    Base[] baseArray;
                    if (this.productOrService == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.productOrService;
                    }
                    return baseArray;
                }
                case -615513385: {
                    return this.modifier == null ? new Base[]{} : this.modifier.toArray(new Base[this.modifier.size()]);
                }
                case -987494927: {
                    Base[] baseArray;
                    if (this.provider == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.provider;
                    }
                    return baseArray;
                }
                case -1285004149: {
                    Base[] baseArray;
                    if (this.quantity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.quantity;
                    }
                    return baseArray;
                }
                case -486196699: {
                    Base[] baseArray;
                    if (this.unitPrice == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.unitPrice;
                    }
                    return baseArray;
                }
                case 501116579: {
                    Base[] baseArray;
                    if (this.facility == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.facility;
                    }
                    return baseArray;
                }
                case 1196993265: {
                    return this.diagnosis == null ? new Base[]{} : this.diagnosis.toArray(new Base[this.diagnosis.size()]);
                }
                case -1335224239: {
                    return this.detail == null ? new Base[]{} : this.detail.toArray(new Base[this.detail.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -595860510: {
                    this.getSupportingInfoSequence().add(this.castToPositiveInt(value));
                    return value;
                }
                case 50511102: {
                    this.category = this.castToCodeableConcept(value);
                    return value;
                }
                case 1957227299: {
                    this.productOrService = this.castToCodeableConcept(value);
                    return value;
                }
                case -615513385: {
                    this.getModifier().add(this.castToCodeableConcept(value));
                    return value;
                }
                case -987494927: {
                    this.provider = this.castToReference(value);
                    return value;
                }
                case -1285004149: {
                    this.quantity = this.castToQuantity(value);
                    return value;
                }
                case -486196699: {
                    this.unitPrice = this.castToMoney(value);
                    return value;
                }
                case 501116579: {
                    this.facility = this.castToReference(value);
                    return value;
                }
                case 1196993265: {
                    this.getDiagnosis().add((DiagnosisComponent)value);
                    return value;
                }
                case -1335224239: {
                    this.getDetail().add(this.castToReference(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("supportingInfoSequence")) {
                this.getSupportingInfoSequence().add(this.castToPositiveInt(value));
            } else if (name.equals("category")) {
                this.category = this.castToCodeableConcept(value);
            } else if (name.equals("productOrService")) {
                this.productOrService = this.castToCodeableConcept(value);
            } else if (name.equals("modifier")) {
                this.getModifier().add(this.castToCodeableConcept(value));
            } else if (name.equals(CoverageEligibilityRequest.SP_PROVIDER)) {
                this.provider = this.castToReference(value);
            } else if (name.equals("quantity")) {
                this.quantity = this.castToQuantity(value);
            } else if (name.equals("unitPrice")) {
                this.unitPrice = this.castToMoney(value);
            } else if (name.equals(CoverageEligibilityRequest.SP_FACILITY)) {
                this.facility = this.castToReference(value);
            } else if (name.equals("diagnosis")) {
                this.getDiagnosis().add((DiagnosisComponent)value);
            } else if (name.equals("detail")) {
                this.getDetail().add(this.castToReference(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("supportingInfoSequence")) {
                this.getSupportingInfoSequence().remove(this.castToPositiveInt(value));
            } else if (name.equals("category")) {
                this.category = null;
            } else if (name.equals("productOrService")) {
                this.productOrService = null;
            } else if (name.equals("modifier")) {
                this.getModifier().remove(this.castToCodeableConcept(value));
            } else if (name.equals(CoverageEligibilityRequest.SP_PROVIDER)) {
                this.provider = null;
            } else if (name.equals("quantity")) {
                this.quantity = null;
            } else if (name.equals("unitPrice")) {
                this.unitPrice = null;
            } else if (name.equals(CoverageEligibilityRequest.SP_FACILITY)) {
                this.facility = null;
            } else if (name.equals("diagnosis")) {
                this.getDiagnosis().remove((DiagnosisComponent)value);
            } else if (name.equals("detail")) {
                this.getDetail().remove(this.castToReference(value));
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -595860510: {
                    return this.addSupportingInfoSequenceElement();
                }
                case 50511102: {
                    return this.getCategory();
                }
                case 1957227299: {
                    return this.getProductOrService();
                }
                case -615513385: {
                    return this.addModifier();
                }
                case -987494927: {
                    return this.getProvider();
                }
                case -1285004149: {
                    return this.getQuantity();
                }
                case -486196699: {
                    return this.getUnitPrice();
                }
                case 501116579: {
                    return this.getFacility();
                }
                case 1196993265: {
                    return this.addDiagnosis();
                }
                case -1335224239: {
                    return this.addDetail();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -595860510: {
                    return new String[]{"positiveInt"};
                }
                case 50511102: {
                    return new String[]{"CodeableConcept"};
                }
                case 1957227299: {
                    return new String[]{"CodeableConcept"};
                }
                case -615513385: {
                    return new String[]{"CodeableConcept"};
                }
                case -987494927: {
                    return new String[]{"Reference"};
                }
                case -1285004149: {
                    return new String[]{"SimpleQuantity"};
                }
                case -486196699: {
                    return new String[]{"Money"};
                }
                case 501116579: {
                    return new String[]{"Reference"};
                }
                case 1196993265: {
                    return new String[0];
                }
                case -1335224239: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("supportingInfoSequence")) {
                throw new FHIRException("Cannot call addChild on a singleton property CoverageEligibilityRequest.supportingInfoSequence");
            }
            if (name.equals("category")) {
                this.category = new CodeableConcept();
                return this.category;
            }
            if (name.equals("productOrService")) {
                this.productOrService = new CodeableConcept();
                return this.productOrService;
            }
            if (name.equals("modifier")) {
                return this.addModifier();
            }
            if (name.equals(CoverageEligibilityRequest.SP_PROVIDER)) {
                this.provider = new Reference();
                return this.provider;
            }
            if (name.equals("quantity")) {
                this.quantity = new Quantity();
                return this.quantity;
            }
            if (name.equals("unitPrice")) {
                this.unitPrice = new Money();
                return this.unitPrice;
            }
            if (name.equals(CoverageEligibilityRequest.SP_FACILITY)) {
                this.facility = new Reference();
                return this.facility;
            }
            if (name.equals("diagnosis")) {
                return this.addDiagnosis();
            }
            if (name.equals("detail")) {
                return this.addDetail();
            }
            return super.addChild(name);
        }

        @Override
        public DetailsComponent copy() {
            DetailsComponent dst = new DetailsComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(DetailsComponent dst) {
            super.copyValues(dst);
            if (this.supportingInfoSequence != null) {
                dst.supportingInfoSequence = new ArrayList<PositiveIntType>();
                for (PositiveIntType positiveIntType : this.supportingInfoSequence) {
                    dst.supportingInfoSequence.add(positiveIntType.copy());
                }
            }
            dst.category = this.category == null ? null : this.category.copy();
            CodeableConcept codeableConcept = dst.productOrService = this.productOrService == null ? null : this.productOrService.copy();
            if (this.modifier != null) {
                dst.modifier = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept2 : this.modifier) {
                    dst.modifier.add(codeableConcept2.copy());
                }
            }
            dst.provider = this.provider == null ? null : this.provider.copy();
            dst.quantity = this.quantity == null ? null : this.quantity.copy();
            dst.unitPrice = this.unitPrice == null ? null : this.unitPrice.copy();
            Reference reference = dst.facility = this.facility == null ? null : this.facility.copy();
            if (this.diagnosis != null) {
                dst.diagnosis = new ArrayList<DiagnosisComponent>();
                for (DiagnosisComponent diagnosisComponent : this.diagnosis) {
                    dst.diagnosis.add(diagnosisComponent.copy());
                }
            }
            if (this.detail != null) {
                dst.detail = new ArrayList<Reference>();
                for (Reference reference2 : this.detail) {
                    dst.detail.add(reference2.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof DetailsComponent)) {
                return false;
            }
            DetailsComponent o = (DetailsComponent)other_;
            return DetailsComponent.compareDeep(this.supportingInfoSequence, o.supportingInfoSequence, true) && DetailsComponent.compareDeep(this.category, o.category, true) && DetailsComponent.compareDeep(this.productOrService, o.productOrService, true) && DetailsComponent.compareDeep(this.modifier, o.modifier, true) && DetailsComponent.compareDeep(this.provider, o.provider, true) && DetailsComponent.compareDeep(this.quantity, o.quantity, true) && DetailsComponent.compareDeep(this.unitPrice, o.unitPrice, true) && DetailsComponent.compareDeep(this.facility, o.facility, true) && DetailsComponent.compareDeep(this.diagnosis, o.diagnosis, true) && DetailsComponent.compareDeep(this.detail, o.detail, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof DetailsComponent)) {
                return false;
            }
            DetailsComponent o = (DetailsComponent)other_;
            return DetailsComponent.compareValues(this.supportingInfoSequence, o.supportingInfoSequence, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.supportingInfoSequence, this.category, this.productOrService, this.modifier, this.provider, this.quantity, this.unitPrice, this.facility, this.diagnosis, this.detail});
        }

        @Override
        public String fhirType() {
            return "CoverageEligibilityRequest.item";
        }
    }

    @Block
    public static class InsuranceComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="focal", type={BooleanType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Applicable coverage", formalDefinition="A flag to indicate that this Coverage is to be used for evaluation of this request when set to true.")
        protected BooleanType focal;
        @Child(name="coverage", type={Coverage.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Insurance information", formalDefinition="Reference to the insurance card level information contained in the Coverage resource. The coverage issuing insurer will use these details to locate the patient's actual coverage within the insurer's information system.")
        protected Reference coverage;
        protected Coverage coverageTarget;
        @Child(name="businessArrangement", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Additional provider contract number", formalDefinition="A business agreement number established between the provider and the insurer for special business processing purposes.")
        protected StringType businessArrangement;
        private static final long serialVersionUID = 692505842L;

        public InsuranceComponent() {
        }

        public InsuranceComponent(Reference coverage) {
            this.coverage = coverage;
        }

        public BooleanType getFocalElement() {
            if (this.focal == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InsuranceComponent.focal");
                }
                if (Configuration.doAutoCreate()) {
                    this.focal = new BooleanType();
                }
            }
            return this.focal;
        }

        public boolean hasFocalElement() {
            return this.focal != null && !this.focal.isEmpty();
        }

        public boolean hasFocal() {
            return this.focal != null && !this.focal.isEmpty();
        }

        public InsuranceComponent setFocalElement(BooleanType value) {
            this.focal = value;
            return this;
        }

        public boolean getFocal() {
            return this.focal == null || this.focal.isEmpty() ? false : (Boolean)this.focal.getValue();
        }

        public InsuranceComponent setFocal(boolean value) {
            if (this.focal == null) {
                this.focal = new BooleanType();
            }
            this.focal.setValue((Object)value);
            return this;
        }

        public Reference getCoverage() {
            if (this.coverage == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InsuranceComponent.coverage");
                }
                if (Configuration.doAutoCreate()) {
                    this.coverage = new Reference();
                }
            }
            return this.coverage;
        }

        public boolean hasCoverage() {
            return this.coverage != null && !this.coverage.isEmpty();
        }

        public InsuranceComponent setCoverage(Reference value) {
            this.coverage = value;
            return this;
        }

        public Coverage getCoverageTarget() {
            if (this.coverageTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InsuranceComponent.coverage");
                }
                if (Configuration.doAutoCreate()) {
                    this.coverageTarget = new Coverage();
                }
            }
            return this.coverageTarget;
        }

        public InsuranceComponent setCoverageTarget(Coverage value) {
            this.coverageTarget = value;
            return this;
        }

        public StringType getBusinessArrangementElement() {
            if (this.businessArrangement == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InsuranceComponent.businessArrangement");
                }
                if (Configuration.doAutoCreate()) {
                    this.businessArrangement = new StringType();
                }
            }
            return this.businessArrangement;
        }

        public boolean hasBusinessArrangementElement() {
            return this.businessArrangement != null && !this.businessArrangement.isEmpty();
        }

        public boolean hasBusinessArrangement() {
            return this.businessArrangement != null && !this.businessArrangement.isEmpty();
        }

        public InsuranceComponent setBusinessArrangementElement(StringType value) {
            this.businessArrangement = value;
            return this;
        }

        public String getBusinessArrangement() {
            return this.businessArrangement == null ? null : (String)this.businessArrangement.getValue();
        }

        public InsuranceComponent setBusinessArrangement(String value) {
            if (Utilities.noString((String)value)) {
                this.businessArrangement = null;
            } else {
                if (this.businessArrangement == null) {
                    this.businessArrangement = new StringType();
                }
                this.businessArrangement.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("focal", "boolean", "A flag to indicate that this Coverage is to be used for evaluation of this request when set to true.", 0, 1, this.focal));
            children.add(new Property("coverage", "Reference(Coverage)", "Reference to the insurance card level information contained in the Coverage resource. The coverage issuing insurer will use these details to locate the patient's actual coverage within the insurer's information system.", 0, 1, this.coverage));
            children.add(new Property("businessArrangement", "string", "A business agreement number established between the provider and the insurer for special business processing purposes.", 0, 1, this.businessArrangement));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 97604197: {
                    return new Property("focal", "boolean", "A flag to indicate that this Coverage is to be used for evaluation of this request when set to true.", 0, 1, this.focal);
                }
                case -351767064: {
                    return new Property("coverage", "Reference(Coverage)", "Reference to the insurance card level information contained in the Coverage resource. The coverage issuing insurer will use these details to locate the patient's actual coverage within the insurer's information system.", 0, 1, this.coverage);
                }
                case 259920682: {
                    return new Property("businessArrangement", "string", "A business agreement number established between the provider and the insurer for special business processing purposes.", 0, 1, this.businessArrangement);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 97604197: {
                    Base[] baseArray;
                    if (this.focal == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.focal;
                    }
                    return baseArray;
                }
                case -351767064: {
                    Base[] baseArray;
                    if (this.coverage == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.coverage;
                    }
                    return baseArray;
                }
                case 259920682: {
                    Base[] baseArray;
                    if (this.businessArrangement == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.businessArrangement;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 97604197: {
                    this.focal = this.castToBoolean(value);
                    return value;
                }
                case -351767064: {
                    this.coverage = this.castToReference(value);
                    return value;
                }
                case 259920682: {
                    this.businessArrangement = this.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("focal")) {
                this.focal = this.castToBoolean(value);
            } else if (name.equals("coverage")) {
                this.coverage = this.castToReference(value);
            } else if (name.equals("businessArrangement")) {
                this.businessArrangement = this.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("focal")) {
                this.focal = null;
            } else if (name.equals("coverage")) {
                this.coverage = null;
            } else if (name.equals("businessArrangement")) {
                this.businessArrangement = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 97604197: {
                    return this.getFocalElement();
                }
                case -351767064: {
                    return this.getCoverage();
                }
                case 259920682: {
                    return this.getBusinessArrangementElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 97604197: {
                    return new String[]{"boolean"};
                }
                case -351767064: {
                    return new String[]{"Reference"};
                }
                case 259920682: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("focal")) {
                throw new FHIRException("Cannot call addChild on a singleton property CoverageEligibilityRequest.focal");
            }
            if (name.equals("coverage")) {
                this.coverage = new Reference();
                return this.coverage;
            }
            if (name.equals("businessArrangement")) {
                throw new FHIRException("Cannot call addChild on a singleton property CoverageEligibilityRequest.businessArrangement");
            }
            return super.addChild(name);
        }

        @Override
        public InsuranceComponent copy() {
            InsuranceComponent dst = new InsuranceComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(InsuranceComponent dst) {
            super.copyValues(dst);
            dst.focal = this.focal == null ? null : this.focal.copy();
            dst.coverage = this.coverage == null ? null : this.coverage.copy();
            dst.businessArrangement = this.businessArrangement == null ? null : this.businessArrangement.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof InsuranceComponent)) {
                return false;
            }
            InsuranceComponent o = (InsuranceComponent)other_;
            return InsuranceComponent.compareDeep(this.focal, o.focal, true) && InsuranceComponent.compareDeep(this.coverage, o.coverage, true) && InsuranceComponent.compareDeep(this.businessArrangement, o.businessArrangement, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof InsuranceComponent)) {
                return false;
            }
            InsuranceComponent o = (InsuranceComponent)other_;
            return InsuranceComponent.compareValues(this.focal, o.focal, true) && InsuranceComponent.compareValues(this.businessArrangement, o.businessArrangement, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.focal, this.coverage, this.businessArrangement});
        }

        @Override
        public String fhirType() {
            return "CoverageEligibilityRequest.insurance";
        }
    }

    @Block
    public static class SupportingInformationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="sequence", type={PositiveIntType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Information instance identifier", formalDefinition="A number to uniquely identify supporting information entries.")
        protected PositiveIntType sequence;
        @Child(name="information", type={Reference.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Data to be provided", formalDefinition="Additional data or information such as resources, documents, images etc. including references to the data or the actual inclusion of the data.")
        protected Reference information;
        protected Resource informationTarget;
        @Child(name="appliesToAll", type={BooleanType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Applies to all items", formalDefinition="The supporting materials are applicable for all detail items, product/servce categories and specific billing codes.")
        protected BooleanType appliesToAll;
        private static final long serialVersionUID = 819254843L;

        public SupportingInformationComponent() {
        }

        public SupportingInformationComponent(PositiveIntType sequence, Reference information) {
            this.sequence = sequence;
            this.information = information;
        }

        public PositiveIntType getSequenceElement() {
            if (this.sequence == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SupportingInformationComponent.sequence");
                }
                if (Configuration.doAutoCreate()) {
                    this.sequence = new PositiveIntType();
                }
            }
            return this.sequence;
        }

        public boolean hasSequenceElement() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public boolean hasSequence() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public SupportingInformationComponent setSequenceElement(PositiveIntType value) {
            this.sequence = value;
            return this;
        }

        public int getSequence() {
            return this.sequence == null || this.sequence.isEmpty() ? 0 : (Integer)this.sequence.getValue();
        }

        public SupportingInformationComponent setSequence(int value) {
            if (this.sequence == null) {
                this.sequence = new PositiveIntType();
            }
            this.sequence.setValue((Object)value);
            return this;
        }

        public Reference getInformation() {
            if (this.information == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SupportingInformationComponent.information");
                }
                if (Configuration.doAutoCreate()) {
                    this.information = new Reference();
                }
            }
            return this.information;
        }

        public boolean hasInformation() {
            return this.information != null && !this.information.isEmpty();
        }

        public SupportingInformationComponent setInformation(Reference value) {
            this.information = value;
            return this;
        }

        public Resource getInformationTarget() {
            return this.informationTarget;
        }

        public SupportingInformationComponent setInformationTarget(Resource value) {
            this.informationTarget = value;
            return this;
        }

        public BooleanType getAppliesToAllElement() {
            if (this.appliesToAll == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SupportingInformationComponent.appliesToAll");
                }
                if (Configuration.doAutoCreate()) {
                    this.appliesToAll = new BooleanType();
                }
            }
            return this.appliesToAll;
        }

        public boolean hasAppliesToAllElement() {
            return this.appliesToAll != null && !this.appliesToAll.isEmpty();
        }

        public boolean hasAppliesToAll() {
            return this.appliesToAll != null && !this.appliesToAll.isEmpty();
        }

        public SupportingInformationComponent setAppliesToAllElement(BooleanType value) {
            this.appliesToAll = value;
            return this;
        }

        public boolean getAppliesToAll() {
            return this.appliesToAll == null || this.appliesToAll.isEmpty() ? false : (Boolean)this.appliesToAll.getValue();
        }

        public SupportingInformationComponent setAppliesToAll(boolean value) {
            if (this.appliesToAll == null) {
                this.appliesToAll = new BooleanType();
            }
            this.appliesToAll.setValue((Object)value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("sequence", "positiveInt", "A number to uniquely identify supporting information entries.", 0, 1, this.sequence));
            children.add(new Property("information", "Reference(Any)", "Additional data or information such as resources, documents, images etc. including references to the data or the actual inclusion of the data.", 0, 1, this.information));
            children.add(new Property("appliesToAll", "boolean", "The supporting materials are applicable for all detail items, product/servce categories and specific billing codes.", 0, 1, this.appliesToAll));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1349547969: {
                    return new Property("sequence", "positiveInt", "A number to uniquely identify supporting information entries.", 0, 1, this.sequence);
                }
                case 1968600364: {
                    return new Property("information", "Reference(Any)", "Additional data or information such as resources, documents, images etc. including references to the data or the actual inclusion of the data.", 0, 1, this.information);
                }
                case -1096846342: {
                    return new Property("appliesToAll", "boolean", "The supporting materials are applicable for all detail items, product/servce categories and specific billing codes.", 0, 1, this.appliesToAll);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    Base[] baseArray;
                    if (this.sequence == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.sequence;
                    }
                    return baseArray;
                }
                case 1968600364: {
                    Base[] baseArray;
                    if (this.information == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.information;
                    }
                    return baseArray;
                }
                case -1096846342: {
                    Base[] baseArray;
                    if (this.appliesToAll == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.appliesToAll;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    this.sequence = this.castToPositiveInt(value);
                    return value;
                }
                case 1968600364: {
                    this.information = this.castToReference(value);
                    return value;
                }
                case -1096846342: {
                    this.appliesToAll = this.castToBoolean(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("sequence")) {
                this.sequence = this.castToPositiveInt(value);
            } else if (name.equals("information")) {
                this.information = this.castToReference(value);
            } else if (name.equals("appliesToAll")) {
                this.appliesToAll = this.castToBoolean(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("sequence")) {
                this.sequence = null;
            } else if (name.equals("information")) {
                this.information = null;
            } else if (name.equals("appliesToAll")) {
                this.appliesToAll = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    return this.getSequenceElement();
                }
                case 1968600364: {
                    return this.getInformation();
                }
                case -1096846342: {
                    return this.getAppliesToAllElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    return new String[]{"positiveInt"};
                }
                case 1968600364: {
                    return new String[]{"Reference"};
                }
                case -1096846342: {
                    return new String[]{"boolean"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("sequence")) {
                throw new FHIRException("Cannot call addChild on a singleton property CoverageEligibilityRequest.sequence");
            }
            if (name.equals("information")) {
                this.information = new Reference();
                return this.information;
            }
            if (name.equals("appliesToAll")) {
                throw new FHIRException("Cannot call addChild on a singleton property CoverageEligibilityRequest.appliesToAll");
            }
            return super.addChild(name);
        }

        @Override
        public SupportingInformationComponent copy() {
            SupportingInformationComponent dst = new SupportingInformationComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SupportingInformationComponent dst) {
            super.copyValues(dst);
            dst.sequence = this.sequence == null ? null : this.sequence.copy();
            dst.information = this.information == null ? null : this.information.copy();
            dst.appliesToAll = this.appliesToAll == null ? null : this.appliesToAll.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SupportingInformationComponent)) {
                return false;
            }
            SupportingInformationComponent o = (SupportingInformationComponent)other_;
            return SupportingInformationComponent.compareDeep(this.sequence, o.sequence, true) && SupportingInformationComponent.compareDeep(this.information, o.information, true) && SupportingInformationComponent.compareDeep(this.appliesToAll, o.appliesToAll, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SupportingInformationComponent)) {
                return false;
            }
            SupportingInformationComponent o = (SupportingInformationComponent)other_;
            return SupportingInformationComponent.compareValues(this.sequence, o.sequence, true) && SupportingInformationComponent.compareValues(this.appliesToAll, o.appliesToAll, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.sequence, this.information, this.appliesToAll});
        }

        @Override
        public String fhirType() {
            return "CoverageEligibilityRequest.supportingInfo";
        }
    }

    public static class EligibilityRequestPurposeEnumFactory
    implements EnumFactory<EligibilityRequestPurpose> {
        @Override
        public EligibilityRequestPurpose fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("auth-requirements".equals(codeString)) {
                return EligibilityRequestPurpose.AUTHREQUIREMENTS;
            }
            if ("benefits".equals(codeString)) {
                return EligibilityRequestPurpose.BENEFITS;
            }
            if ("discovery".equals(codeString)) {
                return EligibilityRequestPurpose.DISCOVERY;
            }
            if ("validation".equals(codeString)) {
                return EligibilityRequestPurpose.VALIDATION;
            }
            throw new IllegalArgumentException("Unknown EligibilityRequestPurpose code '" + codeString + "'");
        }

        public Enumeration<EligibilityRequestPurpose> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<EligibilityRequestPurpose>(this, EligibilityRequestPurpose.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<EligibilityRequestPurpose>(this, EligibilityRequestPurpose.NULL, code);
            }
            if ("auth-requirements".equals(codeString)) {
                return new Enumeration<EligibilityRequestPurpose>(this, EligibilityRequestPurpose.AUTHREQUIREMENTS, code);
            }
            if ("benefits".equals(codeString)) {
                return new Enumeration<EligibilityRequestPurpose>(this, EligibilityRequestPurpose.BENEFITS, code);
            }
            if ("discovery".equals(codeString)) {
                return new Enumeration<EligibilityRequestPurpose>(this, EligibilityRequestPurpose.DISCOVERY, code);
            }
            if ("validation".equals(codeString)) {
                return new Enumeration<EligibilityRequestPurpose>(this, EligibilityRequestPurpose.VALIDATION, code);
            }
            throw new FHIRException("Unknown EligibilityRequestPurpose code '" + codeString + "'");
        }

        @Override
        public String toCode(EligibilityRequestPurpose code) {
            if (code == EligibilityRequestPurpose.NULL) {
                return null;
            }
            if (code == EligibilityRequestPurpose.AUTHREQUIREMENTS) {
                return "auth-requirements";
            }
            if (code == EligibilityRequestPurpose.BENEFITS) {
                return "benefits";
            }
            if (code == EligibilityRequestPurpose.DISCOVERY) {
                return "discovery";
            }
            if (code == EligibilityRequestPurpose.VALIDATION) {
                return "validation";
            }
            return "?";
        }

        @Override
        public String toSystem(EligibilityRequestPurpose code) {
            return code.getSystem();
        }
    }

    public static enum EligibilityRequestPurpose {
        AUTHREQUIREMENTS,
        BENEFITS,
        DISCOVERY,
        VALIDATION,
        NULL;


        public static EligibilityRequestPurpose fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("auth-requirements".equals(codeString)) {
                return AUTHREQUIREMENTS;
            }
            if ("benefits".equals(codeString)) {
                return BENEFITS;
            }
            if ("discovery".equals(codeString)) {
                return DISCOVERY;
            }
            if ("validation".equals(codeString)) {
                return VALIDATION;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown EligibilityRequestPurpose code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case AUTHREQUIREMENTS: {
                    return "auth-requirements";
                }
                case BENEFITS: {
                    return "benefits";
                }
                case DISCOVERY: {
                    return "discovery";
                }
                case VALIDATION: {
                    return "validation";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case AUTHREQUIREMENTS: {
                    return "http://hl7.org/fhir/eligibilityrequest-purpose";
                }
                case BENEFITS: {
                    return "http://hl7.org/fhir/eligibilityrequest-purpose";
                }
                case DISCOVERY: {
                    return "http://hl7.org/fhir/eligibilityrequest-purpose";
                }
                case VALIDATION: {
                    return "http://hl7.org/fhir/eligibilityrequest-purpose";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case AUTHREQUIREMENTS: {
                    return "The prior authorization requirements for the listed, or discovered if specified, converages for the categories of service and/or specifed biling codes are requested.";
                }
                case BENEFITS: {
                    return "The plan benefits and optionally benefits consumed  for the listed, or discovered if specified, converages are requested.";
                }
                case DISCOVERY: {
                    return "The insurer is requested to report on any coverages which they are aware of in addition to any specifed.";
                }
                case VALIDATION: {
                    return "A check that the specified coverages are in-force is requested.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case AUTHREQUIREMENTS: {
                    return "Coverage auth-requirements";
                }
                case BENEFITS: {
                    return "Coverage benefits";
                }
                case DISCOVERY: {
                    return "Coverage Discovery";
                }
                case VALIDATION: {
                    return "Coverage Validation";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class EligibilityRequestStatusEnumFactory
    implements EnumFactory<EligibilityRequestStatus> {
        @Override
        public EligibilityRequestStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("active".equals(codeString)) {
                return EligibilityRequestStatus.ACTIVE;
            }
            if ("cancelled".equals(codeString)) {
                return EligibilityRequestStatus.CANCELLED;
            }
            if ("draft".equals(codeString)) {
                return EligibilityRequestStatus.DRAFT;
            }
            if ("entered-in-error".equals(codeString)) {
                return EligibilityRequestStatus.ENTEREDINERROR;
            }
            throw new IllegalArgumentException("Unknown EligibilityRequestStatus code '" + codeString + "'");
        }

        public Enumeration<EligibilityRequestStatus> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<EligibilityRequestStatus>(this, EligibilityRequestStatus.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<EligibilityRequestStatus>(this, EligibilityRequestStatus.NULL, code);
            }
            if ("active".equals(codeString)) {
                return new Enumeration<EligibilityRequestStatus>(this, EligibilityRequestStatus.ACTIVE, code);
            }
            if ("cancelled".equals(codeString)) {
                return new Enumeration<EligibilityRequestStatus>(this, EligibilityRequestStatus.CANCELLED, code);
            }
            if ("draft".equals(codeString)) {
                return new Enumeration<EligibilityRequestStatus>(this, EligibilityRequestStatus.DRAFT, code);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<EligibilityRequestStatus>(this, EligibilityRequestStatus.ENTEREDINERROR, code);
            }
            throw new FHIRException("Unknown EligibilityRequestStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(EligibilityRequestStatus code) {
            if (code == EligibilityRequestStatus.NULL) {
                return null;
            }
            if (code == EligibilityRequestStatus.ACTIVE) {
                return "active";
            }
            if (code == EligibilityRequestStatus.CANCELLED) {
                return "cancelled";
            }
            if (code == EligibilityRequestStatus.DRAFT) {
                return "draft";
            }
            if (code == EligibilityRequestStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            return "?";
        }

        @Override
        public String toSystem(EligibilityRequestStatus code) {
            return code.getSystem();
        }
    }

    public static enum EligibilityRequestStatus {
        ACTIVE,
        CANCELLED,
        DRAFT,
        ENTEREDINERROR,
        NULL;


        public static EligibilityRequestStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("active".equals(codeString)) {
                return ACTIVE;
            }
            if ("cancelled".equals(codeString)) {
                return CANCELLED;
            }
            if ("draft".equals(codeString)) {
                return DRAFT;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown EligibilityRequestStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ACTIVE: {
                    return "active";
                }
                case CANCELLED: {
                    return "cancelled";
                }
                case DRAFT: {
                    return "draft";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ACTIVE: {
                    return "http://hl7.org/fhir/fm-status";
                }
                case CANCELLED: {
                    return "http://hl7.org/fhir/fm-status";
                }
                case DRAFT: {
                    return "http://hl7.org/fhir/fm-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/fm-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ACTIVE: {
                    return "The instance is currently in-force.";
                }
                case CANCELLED: {
                    return "The instance is withdrawn, rescinded or reversed.";
                }
                case DRAFT: {
                    return "A new instance the contents of which is not complete.";
                }
                case ENTEREDINERROR: {
                    return "The instance was entered in error.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ACTIVE: {
                    return "Active";
                }
                case CANCELLED: {
                    return "Cancelled";
                }
                case DRAFT: {
                    return "Draft";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

