/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.codesystems.ConsentScope;

public class ConsentScopeEnumFactory
implements EnumFactory<ConsentScope> {
    @Override
    public ConsentScope fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("adr".equals(codeString)) {
            return ConsentScope.ADR;
        }
        if ("research".equals(codeString)) {
            return ConsentScope.RESEARCH;
        }
        if ("patient-privacy".equals(codeString)) {
            return ConsentScope.PATIENTPRIVACY;
        }
        if ("treatment".equals(codeString)) {
            return ConsentScope.TREATMENT;
        }
        throw new IllegalArgumentException("Unknown ConsentScope code '" + codeString + "'");
    }

    @Override
    public String toCode(ConsentScope code) {
        if (code == ConsentScope.NULL) {
            return null;
        }
        if (code == ConsentScope.ADR) {
            return "adr";
        }
        if (code == ConsentScope.RESEARCH) {
            return "research";
        }
        if (code == ConsentScope.PATIENTPRIVACY) {
            return "patient-privacy";
        }
        if (code == ConsentScope.TREATMENT) {
            return "treatment";
        }
        return "?";
    }

    @Override
    public String toSystem(ConsentScope code) {
        return code.getSystem();
    }
}

