/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.codesystems.CoverageClass;

public class CoverageClassEnumFactory
implements EnumFactory<CoverageClass> {
    @Override
    public CoverageClass fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("group".equals(codeString)) {
            return CoverageClass.GROUP;
        }
        if ("subgroup".equals(codeString)) {
            return CoverageClass.SUBGROUP;
        }
        if ("plan".equals(codeString)) {
            return CoverageClass.PLAN;
        }
        if ("subplan".equals(codeString)) {
            return CoverageClass.SUBPLAN;
        }
        if ("class".equals(codeString)) {
            return CoverageClass.CLASS;
        }
        if ("subclass".equals(codeString)) {
            return CoverageClass.SUBCLASS;
        }
        if ("sequence".equals(codeString)) {
            return CoverageClass.SEQUENCE;
        }
        if ("rxbin".equals(codeString)) {
            return CoverageClass.RXBIN;
        }
        if ("rxpcn".equals(codeString)) {
            return CoverageClass.RXPCN;
        }
        if ("rxid".equals(codeString)) {
            return CoverageClass.RXID;
        }
        if ("rxgroup".equals(codeString)) {
            return CoverageClass.RXGROUP;
        }
        throw new IllegalArgumentException("Unknown CoverageClass code '" + codeString + "'");
    }

    @Override
    public String toCode(CoverageClass code) {
        if (code == CoverageClass.NULL) {
            return null;
        }
        if (code == CoverageClass.GROUP) {
            return "group";
        }
        if (code == CoverageClass.SUBGROUP) {
            return "subgroup";
        }
        if (code == CoverageClass.PLAN) {
            return "plan";
        }
        if (code == CoverageClass.SUBPLAN) {
            return "subplan";
        }
        if (code == CoverageClass.CLASS) {
            return "class";
        }
        if (code == CoverageClass.SUBCLASS) {
            return "subclass";
        }
        if (code == CoverageClass.SEQUENCE) {
            return "sequence";
        }
        if (code == CoverageClass.RXBIN) {
            return "rxbin";
        }
        if (code == CoverageClass.RXPCN) {
            return "rxpcn";
        }
        if (code == CoverageClass.RXID) {
            return "rxid";
        }
        if (code == CoverageClass.RXGROUP) {
            return "rxgroup";
        }
        return "?";
    }

    @Override
    public String toSystem(CoverageClass code) {
        return code.getSystem();
    }
}

