/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum CoverageFinancialException {
    RETIRED,
    FOSTER,
    NULL;


    public static CoverageFinancialException fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("retired".equals(codeString)) {
            return RETIRED;
        }
        if ("foster".equals(codeString)) {
            return FOSTER;
        }
        throw new FHIRException("Unknown CoverageFinancialException code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case RETIRED: {
                return "retired";
            }
            case FOSTER: {
                return "foster";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/ex-coverage-financial-exception";
    }

    public String getDefinition() {
        switch (this) {
            case RETIRED: {
                return "Retired persons have all copays and deductibles reduced.";
            }
            case FOSTER: {
                return "Children in the foster care have all copays and deductibles waived.";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case RETIRED: {
                return "Retired";
            }
            case FOSTER: {
                return "Foster child";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

