/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.codesystems.FlagCategory;

public class FlagCategoryEnumFactory
implements EnumFactory<FlagCategory> {
    @Override
    public FlagCategory fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("diet".equals(codeString)) {
            return FlagCategory.DIET;
        }
        if ("drug".equals(codeString)) {
            return FlagCategory.DRUG;
        }
        if ("lab".equals(codeString)) {
            return FlagCategory.LAB;
        }
        if ("admin".equals(codeString)) {
            return FlagCategory.ADMIN;
        }
        if ("contact".equals(codeString)) {
            return FlagCategory.CONTACT;
        }
        if ("clinical".equals(codeString)) {
            return FlagCategory.CLINICAL;
        }
        if ("behavioral".equals(codeString)) {
            return FlagCategory.BEHAVIORAL;
        }
        if ("research".equals(codeString)) {
            return FlagCategory.RESEARCH;
        }
        if ("advance-directive".equals(codeString)) {
            return FlagCategory.ADVANCEDIRECTIVE;
        }
        if ("safety".equals(codeString)) {
            return FlagCategory.SAFETY;
        }
        throw new IllegalArgumentException("Unknown FlagCategory code '" + codeString + "'");
    }

    @Override
    public String toCode(FlagCategory code) {
        if (code == FlagCategory.NULL) {
            return null;
        }
        if (code == FlagCategory.DIET) {
            return "diet";
        }
        if (code == FlagCategory.DRUG) {
            return "drug";
        }
        if (code == FlagCategory.LAB) {
            return "lab";
        }
        if (code == FlagCategory.ADMIN) {
            return "admin";
        }
        if (code == FlagCategory.CONTACT) {
            return "contact";
        }
        if (code == FlagCategory.CLINICAL) {
            return "clinical";
        }
        if (code == FlagCategory.BEHAVIORAL) {
            return "behavioral";
        }
        if (code == FlagCategory.RESEARCH) {
            return "research";
        }
        if (code == FlagCategory.ADVANCEDIRECTIVE) {
            return "advance-directive";
        }
        if (code == FlagCategory.SAFETY) {
            return "safety";
        }
        return "?";
    }

    @Override
    public String toSystem(FlagCategory code) {
        return code.getSystem();
    }
}

