/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.codesystems.GroupType;

public class GroupTypeEnumFactory
implements EnumFactory<GroupType> {
    @Override
    public GroupType fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("person".equals(codeString)) {
            return GroupType.PERSON;
        }
        if ("animal".equals(codeString)) {
            return GroupType.ANIMAL;
        }
        if ("practitioner".equals(codeString)) {
            return GroupType.PRACTITIONER;
        }
        if ("device".equals(codeString)) {
            return GroupType.DEVICE;
        }
        if ("medication".equals(codeString)) {
            return GroupType.MEDICATION;
        }
        if ("substance".equals(codeString)) {
            return GroupType.SUBSTANCE;
        }
        throw new IllegalArgumentException("Unknown GroupType code '" + codeString + "'");
    }

    @Override
    public String toCode(GroupType code) {
        if (code == GroupType.NULL) {
            return null;
        }
        if (code == GroupType.PERSON) {
            return "person";
        }
        if (code == GroupType.ANIMAL) {
            return "animal";
        }
        if (code == GroupType.PRACTITIONER) {
            return "practitioner";
        }
        if (code == GroupType.DEVICE) {
            return "device";
        }
        if (code == GroupType.MEDICATION) {
            return "medication";
        }
        if (code == GroupType.SUBSTANCE) {
            return "substance";
        }
        return "?";
    }

    @Override
    public String toSystem(GroupType code) {
        return code.getSystem();
    }
}

