/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.codesystems.HistoryAbsentReason;

public class HistoryAbsentReasonEnumFactory
implements EnumFactory<HistoryAbsentReason> {
    @Override
    public HistoryAbsentReason fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("subject-unknown".equals(codeString)) {
            return HistoryAbsentReason.SUBJECTUNKNOWN;
        }
        if ("withheld".equals(codeString)) {
            return HistoryAbsentReason.WITHHELD;
        }
        if ("unable-to-obtain".equals(codeString)) {
            return HistoryAbsentReason.UNABLETOOBTAIN;
        }
        if ("deferred".equals(codeString)) {
            return HistoryAbsentReason.DEFERRED;
        }
        throw new IllegalArgumentException("Unknown HistoryAbsentReason code '" + codeString + "'");
    }

    @Override
    public String toCode(HistoryAbsentReason code) {
        if (code == HistoryAbsentReason.NULL) {
            return null;
        }
        if (code == HistoryAbsentReason.SUBJECTUNKNOWN) {
            return "subject-unknown";
        }
        if (code == HistoryAbsentReason.WITHHELD) {
            return "withheld";
        }
        if (code == HistoryAbsentReason.UNABLETOOBTAIN) {
            return "unable-to-obtain";
        }
        if (code == HistoryAbsentReason.DEFERRED) {
            return "deferred";
        }
        return "?";
    }

    @Override
    public String toSystem(HistoryAbsentReason code) {
        return code.getSystem();
    }
}

