/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.codesystems.QualityType;

public class QualityTypeEnumFactory
implements EnumFactory<QualityType> {
    @Override
    public QualityType fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("indel".equals(codeString)) {
            return QualityType.INDEL;
        }
        if ("snp".equals(codeString)) {
            return QualityType.SNP;
        }
        if ("unknown".equals(codeString)) {
            return QualityType.UNKNOWN;
        }
        throw new IllegalArgumentException("Unknown QualityType code '" + codeString + "'");
    }

    @Override
    public String toCode(QualityType code) {
        if (code == QualityType.NULL) {
            return null;
        }
        if (code == QualityType.INDEL) {
            return "indel";
        }
        if (code == QualityType.SNP) {
            return "snp";
        }
        if (code == QualityType.UNKNOWN) {
            return "unknown";
        }
        return "?";
    }

    @Override
    public String toSystem(QualityType code) {
        return code.getSystem();
    }
}

