/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum SearchComparator {
    EQ,
    NE,
    GT,
    LT,
    GE,
    LE,
    SA,
    EB,
    AP,
    NULL;


    public static SearchComparator fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("eq".equals(codeString)) {
            return EQ;
        }
        if ("ne".equals(codeString)) {
            return NE;
        }
        if ("gt".equals(codeString)) {
            return GT;
        }
        if ("lt".equals(codeString)) {
            return LT;
        }
        if ("ge".equals(codeString)) {
            return GE;
        }
        if ("le".equals(codeString)) {
            return LE;
        }
        if ("sa".equals(codeString)) {
            return SA;
        }
        if ("eb".equals(codeString)) {
            return EB;
        }
        if ("ap".equals(codeString)) {
            return AP;
        }
        throw new FHIRException("Unknown SearchComparator code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case EQ: {
                return "eq";
            }
            case NE: {
                return "ne";
            }
            case GT: {
                return "gt";
            }
            case LT: {
                return "lt";
            }
            case GE: {
                return "ge";
            }
            case LE: {
                return "le";
            }
            case SA: {
                return "sa";
            }
            case EB: {
                return "eb";
            }
            case AP: {
                return "ap";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/search-comparator";
    }

    public String getDefinition() {
        switch (this) {
            case EQ: {
                return "the value for the parameter in the resource is equal to the provided value.";
            }
            case NE: {
                return "the value for the parameter in the resource is not equal to the provided value.";
            }
            case GT: {
                return "the value for the parameter in the resource is greater than the provided value.";
            }
            case LT: {
                return "the value for the parameter in the resource is less than the provided value.";
            }
            case GE: {
                return "the value for the parameter in the resource is greater or equal to the provided value.";
            }
            case LE: {
                return "the value for the parameter in the resource is less or equal to the provided value.";
            }
            case SA: {
                return "the value for the parameter in the resource starts after the provided value.";
            }
            case EB: {
                return "the value for the parameter in the resource ends before the provided value.";
            }
            case AP: {
                return "the value for the parameter in the resource is approximately the same to the provided value.";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case EQ: {
                return "Equals";
            }
            case NE: {
                return "Not Equals";
            }
            case GT: {
                return "Greater Than";
            }
            case LT: {
                return "Less Than";
            }
            case GE: {
                return "Greater or Equals";
            }
            case LE: {
                return "Less of Equal";
            }
            case SA: {
                return "Starts After";
            }
            case EB: {
                return "Ends Before";
            }
            case AP: {
                return "Approximately";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

