/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.codesystems.StudyType;

public class StudyTypeEnumFactory
implements EnumFactory<StudyType> {
    @Override
    public StudyType fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("RCT".equals(codeString)) {
            return StudyType.RCT;
        }
        if ("CCT".equals(codeString)) {
            return StudyType.CCT;
        }
        if ("cohort".equals(codeString)) {
            return StudyType.COHORT;
        }
        if ("case-control".equals(codeString)) {
            return StudyType.CASECONTROL;
        }
        if ("series".equals(codeString)) {
            return StudyType.SERIES;
        }
        if ("case-report".equals(codeString)) {
            return StudyType.CASEREPORT;
        }
        if ("mixed".equals(codeString)) {
            return StudyType.MIXED;
        }
        throw new IllegalArgumentException("Unknown StudyType code '" + codeString + "'");
    }

    @Override
    public String toCode(StudyType code) {
        if (code == StudyType.NULL) {
            return null;
        }
        if (code == StudyType.RCT) {
            return "RCT";
        }
        if (code == StudyType.CCT) {
            return "CCT";
        }
        if (code == StudyType.COHORT) {
            return "cohort";
        }
        if (code == StudyType.CASECONTROL) {
            return "case-control";
        }
        if (code == StudyType.SERIES) {
            return "series";
        }
        if (code == StudyType.CASEREPORT) {
            return "case-report";
        }
        if (code == StudyType.MIXED) {
            return "mixed";
        }
        return "?";
    }

    @Override
    public String toSystem(StudyType code) {
        return code.getSystem();
    }
}

