/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.codesystems.TaskCode;

public class TaskCodeEnumFactory
implements EnumFactory<TaskCode> {
    @Override
    public TaskCode fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("approve".equals(codeString)) {
            return TaskCode.APPROVE;
        }
        if ("fulfill".equals(codeString)) {
            return TaskCode.FULFILL;
        }
        if ("abort".equals(codeString)) {
            return TaskCode.ABORT;
        }
        if ("replace".equals(codeString)) {
            return TaskCode.REPLACE;
        }
        if ("change".equals(codeString)) {
            return TaskCode.CHANGE;
        }
        if ("suspend".equals(codeString)) {
            return TaskCode.SUSPEND;
        }
        if ("resume".equals(codeString)) {
            return TaskCode.RESUME;
        }
        throw new IllegalArgumentException("Unknown TaskCode code '" + codeString + "'");
    }

    @Override
    public String toCode(TaskCode code) {
        if (code == TaskCode.NULL) {
            return null;
        }
        if (code == TaskCode.APPROVE) {
            return "approve";
        }
        if (code == TaskCode.FULFILL) {
            return "fulfill";
        }
        if (code == TaskCode.ABORT) {
            return "abort";
        }
        if (code == TaskCode.REPLACE) {
            return "replace";
        }
        if (code == TaskCode.CHANGE) {
            return "change";
        }
        if (code == TaskCode.SUSPEND) {
            return "suspend";
        }
        if (code == TaskCode.RESUME) {
            return "resume";
        }
        return "?";
    }

    @Override
    public String toSystem(TaskCode code) {
        return code.getSystem();
    }
}

