/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.utils.client;

import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.utils.client.EFhirClientException;
import org.hl7.fhir.utilities.Utilities;

public class ResourceAddress {
    public static final String REGEX_ID_WITH_HISTORY = "(.*)(/)([a-zA-Z0-9]*)(/)([a-z0-9\\-\\.]{1,64})(/_history/)([a-z0-9\\-\\.]{1,64})$";
    private URI baseServiceUri;

    public ResourceAddress(String endpointPath) throws URISyntaxException {
        this.baseServiceUri = ResourceAddress.buildAbsoluteURI(endpointPath);
    }

    public ResourceAddress(URI baseServiceUri) {
        this.baseServiceUri = baseServiceUri;
    }

    public URI getBaseServiceUri() {
        return this.baseServiceUri;
    }

    public <T extends Resource> URI resolveOperationURLFromClass(Class<T> resourceClass, String name, String parameters) {
        return this.baseServiceUri.resolve(this.nameForClassWithSlash(resourceClass) + "$" + name + "?" + parameters);
    }

    public <T extends Resource> URI resolveSearchUri(Class<T> resourceClass, Map<String, String> parameters) {
        return ResourceAddress.appendHttpParameters(this.baseServiceUri.resolve(this.nameForClassWithSlash(resourceClass) + "_search"), parameters);
    }

    private <T extends Resource> String nameForClassWithSlash(Class<T> resourceClass) {
        String n = this.nameForClass(resourceClass);
        return n == null ? "" : n + "/";
    }

    public <T extends Resource> URI resolveOperationUri(Class<T> resourceClass, String opName) {
        return this.baseServiceUri.resolve(this.nameForClassWithSlash(resourceClass) + "$" + opName);
    }

    public <T extends Resource> URI resolveGetResource(Class<T> resourceClass, String id) {
        return this.baseServiceUri.resolve(this.nameForClassWithSlash(resourceClass) + "/" + id);
    }

    public <T extends Resource> URI resolveOperationUri(Class<T> resourceClass, String opName, Map<String, String> parameters) {
        return ResourceAddress.appendHttpParameters(this.baseServiceUri.resolve(this.nameForClassWithSlash(resourceClass) + "$" + opName), parameters);
    }

    public <T extends Resource> URI resolveValidateUri(Class<T> resourceClass, String id) {
        return this.baseServiceUri.resolve(this.nameForClassWithSlash(resourceClass) + "$validate/" + id);
    }

    public <T extends Resource> URI resolveGetUriFromResourceClass(Class<T> resourceClass) {
        return this.baseServiceUri.resolve(this.nameForClass(resourceClass));
    }

    public <T extends Resource> URI resolveGetUriFromResourceClassAndId(Class<T> resourceClass, String id) {
        return this.baseServiceUri.resolve(this.nameForClass(resourceClass) + "/" + id);
    }

    public URI resolveGetUriFromResourceClassAndId(String resourceClass, String id) {
        return this.baseServiceUri.resolve(resourceClass + "/" + id);
    }

    public <T extends Resource> URI resolveGetUriFromResourceClassAndIdAndVersion(Class<T> resourceClass, String id, String version) {
        return this.baseServiceUri.resolve(this.nameForClass(resourceClass) + "/" + id + "/_history/" + version);
    }

    public <T extends Resource> URI resolveGetUriFromResourceClassAndCanonical(Class<T> resourceClass, String canonicalUrl) {
        if (canonicalUrl.contains("|")) {
            return this.baseServiceUri.resolve(this.nameForClass(resourceClass) + "?url=" + canonicalUrl.substring(0, canonicalUrl.indexOf("|")) + "&version=" + canonicalUrl.substring(canonicalUrl.indexOf("|") + 1));
        }
        return this.baseServiceUri.resolve(this.nameForClass(resourceClass) + "?url=" + canonicalUrl);
    }

    public URI resolveGetHistoryForAllResources(int count) {
        if (count > 0) {
            return ResourceAddress.appendHttpParameter(this.baseServiceUri.resolve("_history"), "_count", "" + count);
        }
        return this.baseServiceUri.resolve("_history");
    }

    public <T extends Resource> URI resolveGetHistoryForResourceId(Class<T> resourceClass, String id, int count) {
        return this.resolveGetHistoryUriForResourceId(resourceClass, id, null, count);
    }

    protected <T extends Resource> URI resolveGetHistoryUriForResourceId(Class<T> resourceClass, String id, Object since, int count) {
        Map<String, String> parameters = this.getHistoryParameters(since, count);
        return ResourceAddress.appendHttpParameters(this.baseServiceUri.resolve(this.nameForClass(resourceClass) + "/" + id + "/_history"), parameters);
    }

    public <T extends Resource> URI resolveGetHistoryForResourceType(Class<T> resourceClass, int count) {
        Map<String, String> parameters = this.getHistoryParameters(null, count);
        return ResourceAddress.appendHttpParameters(this.baseServiceUri.resolve(this.nameForClass(resourceClass) + "/_history"), parameters);
    }

    public <T extends Resource> URI resolveGetHistoryForResourceType(Class<T> resourceClass, Object since, int count) {
        Map<String, String> parameters = this.getHistoryParameters(since, count);
        return ResourceAddress.appendHttpParameters(this.baseServiceUri.resolve(this.nameForClass(resourceClass) + "/_history"), parameters);
    }

    public URI resolveGetHistoryForAllResources(Calendar since, int count) {
        Map<String, String> parameters = this.getHistoryParameters(since, count);
        return ResourceAddress.appendHttpParameters(this.baseServiceUri.resolve("_history"), parameters);
    }

    public URI resolveGetHistoryForAllResources(Date since, int count) {
        Map<String, String> parameters = this.getHistoryParameters(since, count);
        return ResourceAddress.appendHttpParameters(this.baseServiceUri.resolve("_history"), parameters);
    }

    public Map<String, String> getHistoryParameters(Object since, int count) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (since != null) {
            parameters.put("_since", since.toString());
        }
        if (count > 0) {
            parameters.put("_count", "" + count);
        }
        return parameters;
    }

    public <T extends Resource> URI resolveGetHistoryForResourceId(Class<T> resourceClass, String id, Calendar since, int count) {
        return this.resolveGetHistoryUriForResourceId(resourceClass, id, since, count);
    }

    public <T extends Resource> URI resolveGetHistoryForResourceId(Class<T> resourceClass, String id, Date since, int count) {
        return this.resolveGetHistoryUriForResourceId(resourceClass, id, since, count);
    }

    public <T extends Resource> URI resolveGetHistoryForResourceType(Class<T> resourceClass, Calendar since, int count) {
        return this.resolveGetHistoryForResourceType(resourceClass, ResourceAddress.getCalendarDateInIsoTimeFormat(since), count);
    }

    public <T extends Resource> URI resolveGetHistoryForResourceType(Class<T> resourceClass, Date since, int count) {
        return this.resolveGetHistoryForResourceType(resourceClass, since.toString(), count);
    }

    public <T extends Resource> URI resolveGetAllTags() {
        return this.baseServiceUri.resolve("_tags");
    }

    public <T extends Resource> URI resolveGetAllTagsForResourceType(Class<T> resourceClass) {
        return this.baseServiceUri.resolve(this.nameForClass(resourceClass) + "/_tags");
    }

    public <T extends Resource> URI resolveGetTagsForReference(Class<T> resourceClass, String id) {
        return this.baseServiceUri.resolve(this.nameForClass(resourceClass) + "/" + id + "/_tags");
    }

    public <T extends Resource> URI resolveGetTagsForResourceVersion(Class<T> resourceClass, String id, String version) {
        return this.baseServiceUri.resolve(this.nameForClass(resourceClass) + "/" + id + "/_history/" + version + "/_tags");
    }

    public <T extends Resource> URI resolveDeleteTagsForResourceVersion(Class<T> resourceClass, String id, String version) {
        return this.baseServiceUri.resolve(this.nameForClass(resourceClass) + "/" + id + "/_history/" + version + "/_tags/_delete");
    }

    public <T extends Resource> String nameForClass(Class<T> resourceClass) {
        if (resourceClass == null) {
            return null;
        }
        String res = resourceClass.getSimpleName();
        if (res.equals("List_")) {
            return "List";
        }
        return res;
    }

    public URI resolveMetadataUri(boolean quick) {
        return this.baseServiceUri.resolve(quick ? "metadata?_summary=true" : "metadata");
    }

    public URI resolveMetadataTxCaps() {
        return this.baseServiceUri.resolve("metadata?mode=terminology");
    }

    public static ResourceVersionedIdentifier parseCreateLocation(String locationResponseHeader) {
        Pattern pattern = Pattern.compile(REGEX_ID_WITH_HISTORY);
        Matcher matcher = pattern.matcher(locationResponseHeader);
        ResourceVersionedIdentifier parsedHeader = null;
        if (matcher.matches()) {
            String serviceRoot = matcher.group(1);
            String resourceType = matcher.group(3);
            String id = matcher.group(5);
            String version = matcher.group(7);
            parsedHeader = new ResourceVersionedIdentifier(serviceRoot, resourceType, id, version);
        }
        return parsedHeader;
    }

    public static URI buildAbsoluteURI(String absoluteURI) {
        if (StringUtils.isBlank((CharSequence)absoluteURI)) {
            throw new EFhirClientException(0, "Invalid URI", new URISyntaxException(absoluteURI, "URI/URL cannot be blank"));
        }
        String endpoint = ResourceAddress.appendForwardSlashToPath(absoluteURI);
        return ResourceAddress.buildEndpointUriFromString(endpoint);
    }

    public static String appendForwardSlashToPath(String path) {
        if (((String)path).lastIndexOf(47) != ((String)path).length() - 1) {
            path = (String)path + "/";
        }
        return path;
    }

    public static URI buildEndpointUriFromString(String endpointPath) {
        URI uri = null;
        try {
            URIBuilder uriBuilder = new URIBuilder(endpointPath);
            uri = uriBuilder.build();
            String scheme = uri.getScheme();
            String host = uri.getHost();
            if (!scheme.equalsIgnoreCase("http") && !scheme.equalsIgnoreCase("https")) {
                throw new EFhirClientException("Scheme must be 'http' or 'https': " + uri);
            }
            if (StringUtils.isBlank((CharSequence)host)) {
                throw new EFhirClientException("host cannot be blank: " + uri);
            }
        }
        catch (URISyntaxException e) {
            throw new EFhirClientException(0, "Invalid URI", e);
        }
        return uri;
    }

    public static URI appendQueryStringToUri(URI uri, String parameterName, String parameterValue) {
        URI modifiedUri = null;
        try {
            URIBuilder uriBuilder = new URIBuilder(uri);
            uriBuilder.setQuery(parameterName + "=" + parameterValue);
            modifiedUri = uriBuilder.build();
        }
        catch (Exception e) {
            throw new EFhirClientException(0, "Unable to append query parameter '" + parameterName + "=" + parameterValue + " to URI " + uri, e);
        }
        return modifiedUri;
    }

    public static String buildRelativePathFromResourceType(ResourceType resourceType) {
        return resourceType.toString() + "/";
    }

    public static String buildRelativePathFromResourceType(ResourceType resourceType, String id) {
        return ResourceAddress.buildRelativePathFromResourceType(resourceType) + "@" + id;
    }

    public static String buildRelativePathFromReference(Resource resource) {
        return ResourceAddress.buildRelativePathFromResourceType(resource.getResourceType());
    }

    public static String buildRelativePathFromReference(Resource resource, String id) {
        return ResourceAddress.buildRelativePathFromResourceType(resource.getResourceType(), id);
    }

    public static String getCalendarDateInIsoTimeFormat(Calendar calendar) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss", new Locale("en", "US"));
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
        return format.format(calendar.getTime());
    }

    public static URI appendHttpParameter(URI basePath, String httpParameterName, String httpParameterValue) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(httpParameterName, httpParameterValue);
        return ResourceAddress.appendHttpParameters(basePath, parameters);
    }

    public static URI appendHttpParameters(URI basePath, Map<String, String> parameters) {
        try {
            Set<String> httpParameterNames = parameters.keySet();
            Object query = basePath.getQuery();
            for (String httpParameterName : httpParameterNames) {
                query = query != null ? (String)query + "&" : "";
                query = (String)query + httpParameterName + "=" + Utilities.encodeUri((String)parameters.get(httpParameterName));
            }
            return new URI(basePath.getScheme(), basePath.getUserInfo(), basePath.getHost(), basePath.getPort(), basePath.getPath(), (String)query, basePath.getFragment());
        }
        catch (Exception e) {
            throw new EFhirClientException(0, "Error appending http parameter", e);
        }
    }

    public static class ResourceVersionedIdentifier {
        private String serviceRoot;
        private String resourceType;
        private String id;
        private String version;
        private URI resourceLocation;

        public ResourceVersionedIdentifier(String serviceRoot, String resourceType, String id, String version, URI resourceLocation) {
            this.serviceRoot = serviceRoot;
            this.resourceType = resourceType;
            this.id = id;
            this.version = version;
            this.resourceLocation = resourceLocation;
        }

        public ResourceVersionedIdentifier(String resourceType, String id, String version, URI resourceLocation) {
            this(null, resourceType, id, version, resourceLocation);
        }

        public ResourceVersionedIdentifier(String serviceRoot, String resourceType, String id, String version) {
            this(serviceRoot, resourceType, id, version, null);
        }

        public ResourceVersionedIdentifier(String resourceType, String id, String version) {
            this(null, resourceType, id, version, null);
        }

        public ResourceVersionedIdentifier(String resourceType, String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        protected void setId(String id) {
            this.id = id;
        }

        public String getVersionId() {
            return this.version;
        }

        protected void setVersionId(String version) {
            this.version = version;
        }

        public String getResourceType() {
            return this.resourceType;
        }

        public void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public String getServiceRoot() {
            return this.serviceRoot;
        }

        public void setServiceRoot(String serviceRoot) {
            this.serviceRoot = serviceRoot;
        }

        public String getResourcePath() {
            return this.serviceRoot + "/" + this.resourceType + "/" + this.id;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public URI getResourceLocation() {
            return this.resourceLocation;
        }

        public void setResourceLocation(URI resourceLocation) {
            this.resourceLocation = resourceLocation;
        }
    }
}

