/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.conformance;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.conformance.ProfileComparer;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.context.SimpleWorkerContext;
import org.hl7.fhir.r5.formats.IParser;
import org.hl7.fhir.r5.formats.JsonParser;
import org.hl7.fhir.r5.formats.XmlParser;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CapabilityStatement;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Element;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.utils.KeyGenerator;
import org.hl7.fhir.r5.utils.OperationOutcomeUtilities;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.MarkDownProcessor;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.utilities.xhtml.NodeType;
import org.hl7.fhir.utilities.xhtml.XhtmlComposer;
import org.hl7.fhir.utilities.xhtml.XhtmlDocument;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;
import org.hl7.fhir.utilities.xhtml.XhtmlParser;

public class CapabilityStatementUtilities {
    private IWorkerContext context;
    private String selfName;
    private String otherName;
    private CapabilityStatementComparisonOutput output;
    private XhtmlDocument html;
    private MarkDownProcessor markdown = new MarkDownProcessor(MarkDownProcessor.Dialect.COMMON_MARK);
    private String folder;
    private KeyGenerator keygen;
    private static final int BUFFER_SIZE = 4096;

    public CapabilityStatementUtilities(SimpleWorkerContext context, String folder, KeyGenerator keygen) throws IOException {
        this.context = context;
        this.folder = folder;
        this.keygen = keygen;
        if (!new File(Utilities.path((String[])new String[]{folder, "conparison-zip-marker.bin"})).exists()) {
            String f = Utilities.path((String[])new String[]{folder, "comparison.zip"});
            this.download("https://www.fhir.org/archive/comparison.zip", f);
            this.unzip(f, folder);
        }
    }

    public void unzip(String zipFilePath, String destDirectory) throws IOException {
        File destDir = new File(destDirectory);
        if (!destDir.exists()) {
            destDir.mkdir();
        }
        ZipInputStream zipIn = new ZipInputStream(new FileInputStream(zipFilePath));
        ZipEntry entry = zipIn.getNextEntry();
        while (entry != null) {
            String filePath = destDirectory + File.separator + entry.getName();
            if (!entry.isDirectory()) {
                this.extractFile(zipIn, filePath);
            } else {
                File dir = new File(filePath);
                dir.mkdir();
            }
            zipIn.closeEntry();
            entry = zipIn.getNextEntry();
        }
        zipIn.close();
    }

    private void extractFile(ZipInputStream zipIn, String filePath) throws IOException {
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(filePath));
        byte[] bytesIn = new byte[4096];
        int read = 0;
        while ((read = zipIn.read(bytesIn)) != -1) {
            bos.write(bytesIn, 0, read);
        }
        bos.close();
    }

    public void saveToFile() throws IOException {
        String s = new XhtmlComposer(true, true).compose(this.html);
        TextFile.stringToFile((String)s, (String)Utilities.path((String[])new String[]{this.folder, "index.html"}));
    }

    public CapabilityStatementComparisonOutput isCompatible(String selfName, String otherName, CapabilityStatement self, CapabilityStatement other) throws DefinitionException, FHIRFormatError, IOException {
        this.selfName = selfName;
        this.otherName = otherName;
        this.output = new CapabilityStatementComparisonOutput();
        XhtmlNode x = this.startHtml();
        this.information(x, ValidationMessage.IssueType.INVARIANT, self.getUrl(), "Comparing " + selfName + " to " + otherName + ", to see if a server that implements " + otherName + " also implements " + selfName + "");
        this.information(x, ValidationMessage.IssueType.INVARIANT, self.getUrl(), "  " + selfName + ": " + self.getUrl() + "|" + self.getVersion());
        this.information(x, ValidationMessage.IssueType.INVARIANT, self.getUrl(), "  " + otherName + ": " + other.getUrl() + "|" + other.getVersion());
        if (self.getRest().size() != 1 || self.getRestFirstRep().getMode() != Enumerations.RestfulCapabilityMode.SERVER) {
            this.fatal(x, ValidationMessage.IssueType.INVARIANT, self.getUrl() + "#rest", "The CapabilityStatement Comparison tool can only compare CapabilityStatements with a single server component");
        }
        if (other.getRest().size() != 1 || other.getRestFirstRep().getMode() != Enumerations.RestfulCapabilityMode.SERVER) {
            this.fatal(x, ValidationMessage.IssueType.INVARIANT, other.getUrl() + "#rest", "The CapabilityStatement Comparison tool can only compare CapabilityStatements with a single server component");
        }
        if (self.getRest().size() == 1 && other.getRest().size() == 1) {
            XhtmlNode tbl = this.startTable(x, self, other);
            this.compareRest(tbl, self.getUrl(), self.getRest().get(0), other.getRest().get(0), this.output.subset.addRest().setMode(Enumerations.RestfulCapabilityMode.SERVER), this.output.superset.addRest().setMode(Enumerations.RestfulCapabilityMode.SERVER));
        }
        if (this.folder != null) {
            this.saveToFile();
        }
        this.output.outcome = OperationOutcomeUtilities.createOutcome(this.output.messages);
        this.sortCapabilityStatement(this.output.subset);
        this.sortCapabilityStatement(this.output.superset);
        return this.output;
    }

    private void compareRest(XhtmlNode tbl, String path, CapabilityStatement.CapabilityStatementRestComponent self, CapabilityStatement.CapabilityStatementRestComponent other, CapabilityStatement.CapabilityStatementRestComponent intersection, CapabilityStatement.CapabilityStatementRestComponent union) throws DefinitionException, FHIRFormatError, IOException {
        this.compareSecurity(tbl, path, self, other, intersection, union);
        ArrayList<CapabilityStatement.CapabilityStatementRestResourceComponent> ol = new ArrayList<CapabilityStatement.CapabilityStatementRestResourceComponent>();
        ArrayList<CapabilityStatement.CapabilityStatementRestResourceComponent> olr = new ArrayList<CapabilityStatement.CapabilityStatementRestResourceComponent>();
        ol.addAll(other.getResource());
        for (CapabilityStatement.CapabilityStatementRestResourceComponent r : self.getResource()) {
            CapabilityStatement.CapabilityStatementRestResourceComponent o = null;
            for (CapabilityStatement.CapabilityStatementRestResourceComponent t : ol) {
                if (!t.getType().equals(r.getType())) continue;
                o = t;
                break;
            }
            XhtmlNode tr = tbl.tr();
            tr.style("background-color: #dddddd");
            tr.td().b().addText(r.getType());
            tr.td().tx("Present");
            if (o == null) {
                union.addResource(r);
                XhtmlNode p = tr.td().para("Absent");
                XhtmlNode td = tr.td();
                String s = this.getConfStatus(r);
                if (Utilities.existsInList((String)s, (String[])new String[]{"SHALL", "SHOULD"})) {
                    this.error(td, ValidationMessage.IssueType.NOTFOUND, path + ".resource.where(type = '" + r.getType() + "')", this.selfName + " specifies the resource " + r.getType() + " as " + s + " but " + this.otherName + " does not cover it");
                    p.style("background-color: #ffe6e6; border: 1px solid #ff1a1a; margin-width: 10px");
                }
                tr = tbl.tr();
                tr.td().para().tx(XhtmlNode.NBSP + " - Conformance");
                this.genConf(tr.td().para(), r, null);
                tr.td().style("background-color: #eeeeee");
                tr.td();
                tr = tbl.tr();
                tr.td().para().tx(XhtmlNode.NBSP + " - Profile");
                this.genProfile(tr.td().para(), r, null);
                tr.td().style("background-color: #eeeeee");
                tr.td();
                tr = tbl.tr();
                tr.td().para().tx(XhtmlNode.NBSP + " - Interactions");
                this.genInt(tr.td(), r, null, false);
                tr.td().style("background-color: #eeeeee");
                tr.td();
                tr = tbl.tr();
                tr.td().para().tx(XhtmlNode.NBSP + " - Search Parameters");
                this.genSP(tr.td(), r, null, false);
                tr.td().style("background-color: #eeeeee");
                tr.td();
                continue;
            }
            olr.add(o);
            tr.td().tx("Present");
            tr.td().nbsp();
            this.compareResource(path + ".resource.where(type = '" + r.getType() + "')", r, o, tbl, intersection.addResource().setType(r.getType()), union.addResource().setType(r.getType()));
        }
        for (CapabilityStatement.CapabilityStatementRestResourceComponent t : ol) {
            XhtmlNode tr = tbl.tr();
            if (olr.contains(t)) continue;
            union.addResource(t);
            tr.td().addText(t.getType());
            XhtmlNode td = tr.td();
            td.style("background-color: #eeeeee").para("Absent");
            td = tr.td();
            this.genConf(td, t, null);
            this.genProfile(td, t, null);
            this.genInt(td, t, null, false);
            this.genSP(td, t, null, false);
            if (!this.isProhibited(t)) continue;
            this.error(td, ValidationMessage.IssueType.INVARIANT, path + ".resource", this.selfName + " does not specify the resource " + t.getType() + " but " + this.otherName + " prohibits it");
        }
    }

    private void genConf(XhtmlNode x, CapabilityStatement.CapabilityStatementRestResourceComponent r, CapabilityStatement.CapabilityStatementRestResourceComponent other) {
        String s = this.getConfStatus(r);
        String so = other != null ? this.getConfStatus(other) : null;
        x.add(this.same(s == null ? "(not specified)" : s, s == null && so == null || s != null && s.equals(so)));
    }

    private void genProfile(XhtmlNode x, CapabilityStatement.CapabilityStatementRestResourceComponent r, CapabilityStatement.CapabilityStatementRestResourceComponent other) {
        String s = this.getProfile(r);
        if (s == null) {
            s = "(not specified)";
        }
        String so = other == null ? null : (this.getProfile(other) == null ? this.getProfile(other) : "(not specified)");
        x.add(this.same(s, s == null && so == null || s != null && s.equals(so)));
    }

    private String getProfile(CapabilityStatement.CapabilityStatementRestResourceComponent r) {
        if (r.hasSupportedProfile() && r.getSupportedProfile().size() == 1) {
            return r.getSupportedProfile().get(0).asStringValue();
        }
        return r.getProfile();
    }

    private void genInt(XhtmlNode td, CapabilityStatement.CapabilityStatementRestResourceComponent r, CapabilityStatement.CapabilityStatementRestResourceComponent other, boolean errorIfNoMatch) {
        boolean first = true;
        for (CapabilityStatement.ResourceInteractionComponent i : r.getInteraction()) {
            if (first) {
                first = false;
            } else {
                td.tx(", ");
            }
            if (this.exists(other, i)) {
                td.code().span("background-color: #bbff99; border: 1px solid #44cc00; margin-width: 10px", null).tx(i.getCode().toCode());
                continue;
            }
            if (errorIfNoMatch) {
                td.code().span("background-color: #ffe6e6; border: 1px solid #ff1a1a; margin-width: 10px", null).tx(i.getCode().toCode());
                continue;
            }
            td.code(i.getCode().toCode());
        }
    }

    private boolean exists(CapabilityStatement.CapabilityStatementRestResourceComponent other, CapabilityStatement.ResourceInteractionComponent i) {
        if (other == null) {
            return false;
        }
        for (CapabilityStatement.ResourceInteractionComponent t : other.getInteraction()) {
            if (!t.getCode().equals((Object)i.getCode())) continue;
            return true;
        }
        return false;
    }

    private void genSP(XhtmlNode td, CapabilityStatement.CapabilityStatementRestResourceComponent r, CapabilityStatement.CapabilityStatementRestResourceComponent other, boolean errorIfNoMatch) {
        boolean first = true;
        for (CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent i : r.getSearchParam()) {
            if (first) {
                first = false;
            } else {
                td.tx(", ");
            }
            if (this.exists(other, i)) {
                td.code().span("background-color: #bbff99; border: 1px solid #44cc00; margin-width: 10px", null).tx(i.getName());
                continue;
            }
            if (errorIfNoMatch) {
                td.code().span("background-color: #ffe6e6; border: 1px solid #ff1a1a; margin-width: 10px", null).tx(i.getName());
                continue;
            }
            td.code(i.getName());
        }
    }

    private boolean exists(CapabilityStatement.CapabilityStatementRestResourceComponent other, CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent i) {
        if (other == null) {
            return false;
        }
        for (CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent t : other.getSearchParam()) {
            if (!t.getName().equals(i.getName())) continue;
            return true;
        }
        return false;
    }

    public void compareSecurity(XhtmlNode tbl, String path, CapabilityStatement.CapabilityStatementRestComponent self, CapabilityStatement.CapabilityStatementRestComponent other, CapabilityStatement.CapabilityStatementRestComponent intersection, CapabilityStatement.CapabilityStatementRestComponent union) {
        XhtmlNode tr = tbl.tr();
        tr.td().b().addText("Security");
        tr.td().para(this.gen(self.getSecurity()));
        tr.td().para(this.gen(other.getSecurity()));
        XhtmlNode td = tr.td();
        if (self.hasSecurity() && !other.hasSecurity()) {
            this.error(td, ValidationMessage.IssueType.CONFLICT, path + ".security", this.selfName + " specifies some security requirements (" + this.gen(self.getSecurity()) + ") but " + this.otherName + " doesn't");
        } else if (!self.hasSecurity() && other.hasSecurity()) {
            this.error(td, ValidationMessage.IssueType.CONFLICT, path + ".security", this.selfName + " does not specify security requirements but " + this.otherName + " does (" + this.gen(self.getSecurity()) + ")");
        } else if (self.hasSecurity() && other.hasSecurity()) {
            this.compareSecurity(td, path + ".security", self.getSecurity(), other.getSecurity(), intersection.getSecurity(), union.getSecurity());
        }
    }

    private void compareResource(String path, CapabilityStatement.CapabilityStatementRestResourceComponent self, CapabilityStatement.CapabilityStatementRestResourceComponent other, XhtmlNode tbl, CapabilityStatement.CapabilityStatementRestResourceComponent intersection, CapabilityStatement.CapabilityStatementRestResourceComponent union) throws DefinitionException, FHIRFormatError, IOException {
        XhtmlNode tr = tbl.tr();
        tr.td().para().tx(XhtmlNode.NBSP + " - Conformance");
        this.genConf(tr.td(), self, other);
        this.genConf(tr.td(), other, self);
        tr.td().nbsp();
        tr = tbl.tr();
        tr.td().para().tx(XhtmlNode.NBSP + " - Profile");
        this.genProfile(tr.td(), self, other);
        this.genProfile(tr.td(), other, self);
        this.compareProfiles(tr.td(), path, this.getProfile(self), this.getProfile(other), self.getType(), intersection, union);
        this.compareResourceInteractions(path, self, other, tbl, intersection, union);
        this.compareResourceSearchParams(path, self, other, tbl, intersection, union);
    }

    private void compareProfiles(XhtmlNode td, String path, String urlL, String urlR, String type, CapabilityStatement.CapabilityStatementRestResourceComponent intersection, CapabilityStatement.CapabilityStatementRestResourceComponent union) throws DefinitionException, FHIRFormatError, IOException {
        if (urlL == null) {
            urlL = "http://hl7.org/fhir/StructureDefinition/" + type;
        }
        if (urlR == null) {
            urlR = "http://hl7.org/fhir/StructureDefinition/" + type;
        }
        StructureDefinition sdL = this.context.fetchResource(StructureDefinition.class, urlL);
        StructureDefinition sdR = this.context.fetchResource(StructureDefinition.class, urlR);
        if (sdL == null) {
            this.error(td, ValidationMessage.IssueType.NOTFOUND, path, "Unable to resolve " + urlL);
        }
        if (sdR == null) {
            this.error(td, ValidationMessage.IssueType.NOTFOUND, path, "Unable to resolve " + urlR);
        }
        if (sdL != null && sdR != null && sdL != sdR) {
            if (sdR.getUrl().equals(sdL.getBaseDefinition())) {
                this.information(td, null, path, "The profile specified by " + this.selfName + " is inherited from the profile specified by " + this.otherName);
                intersection.setProfile(sdL.getUrl());
                union.setProfile(sdR.getUrl());
            } else if (sdL.getUrl().equals(sdR.getBaseDefinition())) {
                this.information(td, null, path, "The profile specified by " + this.otherName + " is inherited from the profile specified by " + this.selfName);
                intersection.setProfile(sdR.getUrl());
                union.setProfile(sdL.getUrl());
            } else if (this.folder != null) {
                try {
                    ProfileComparer pc = new ProfileComparer(this.context, this.keygen, this.folder);
                    pc.setId("api-ep." + type);
                    pc.setTitle("Comparison - " + this.selfName + " vs " + this.otherName);
                    pc.setLeftName(this.selfName + ": " + sdL.present());
                    pc.setLeftLink(sdL.getUserString("path"));
                    pc.setRightName(this.otherName + ": " + sdR.present());
                    pc.setRightLink(sdR.getUserString("path"));
                    pc.compareProfiles(sdL, sdR);
                    System.out.println("Generate Comparison between " + pc.getLeftName() + " and " + pc.getRightName());
                    pc.generate();
                    for (ProfileComparer.ProfileComparison cmp : pc.getComparisons()) {
                        new XmlParser().setOutputStyle(IParser.OutputStyle.PRETTY).compose(new FileOutputStream(Utilities.path((String[])new String[]{this.folder, cmp.getSubset().fhirType() + "-" + cmp.getSubset().getId() + ".xml"})), cmp.getSubset());
                        new JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).compose(new FileOutputStream(Utilities.path((String[])new String[]{this.folder, cmp.getSubset().fhirType() + "-" + cmp.getSubset().getId() + ".json"})), cmp.getSubset());
                        new XmlParser().setOutputStyle(IParser.OutputStyle.PRETTY).compose(new FileOutputStream(Utilities.path((String[])new String[]{this.folder, cmp.getSuperset().fhirType() + "-" + cmp.getSuperset().getId() + ".xml"})), cmp.getSuperset());
                        new JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).compose(new FileOutputStream(Utilities.path((String[])new String[]{this.folder, cmp.getSuperset().fhirType() + "-" + cmp.getSuperset().getId() + ".json"})), cmp.getSuperset());
                    }
                    for (ValueSet vs : pc.getValuesets()) {
                        new XmlParser().setOutputStyle(IParser.OutputStyle.PRETTY).compose(new FileOutputStream(Utilities.path((String[])new String[]{this.folder, vs.fhirType() + "-" + vs.getId() + ".xml"})), vs);
                        new JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).compose(new FileOutputStream(Utilities.path((String[])new String[]{this.folder, vs.fhirType() + "-" + vs.getId() + ".json"})), vs);
                    }
                    intersection.setProfile(pc.getComparisons().get(0).getSubset().getUrl());
                    union.setProfile(pc.getComparisons().get(0).getSuperset().getUrl());
                    td.ah(pc.getId() + ".html").tx("Comparison...");
                    td.tx(pc.getErrCount() + " " + Utilities.pluralize((String)"error", (int)pc.getErrCount()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.error(td, ValidationMessage.IssueType.EXCEPTION, path, "Error comparing profiles: " + e.getMessage());
                }
            } else {
                this.information(td, null, path, "Use the validator to compare the profiles");
            }
        }
    }

    private void compareResourceInteractions(String path, CapabilityStatement.CapabilityStatementRestResourceComponent self, CapabilityStatement.CapabilityStatementRestResourceComponent other, XhtmlNode tbl, CapabilityStatement.CapabilityStatementRestResourceComponent intersection, CapabilityStatement.CapabilityStatementRestResourceComponent union) {
        XhtmlNode tr = tbl.tr();
        tr.td().para().tx(XhtmlNode.NBSP + " - Interactions");
        this.genInt(tr.td(), self, other, true);
        this.genInt(tr.td(), other, self, false);
        XhtmlNode td = tr.td();
        ArrayList<CapabilityStatement.ResourceInteractionComponent> ol = new ArrayList<CapabilityStatement.ResourceInteractionComponent>();
        ArrayList<CapabilityStatement.ResourceInteractionComponent> olr = new ArrayList<CapabilityStatement.ResourceInteractionComponent>();
        ol.addAll(other.getInteraction());
        for (CapabilityStatement.ResourceInteractionComponent r : self.getInteraction()) {
            CapabilityStatement.ResourceInteractionComponent o = null;
            for (CapabilityStatement.ResourceInteractionComponent t : ol) {
                if (!t.getCode().equals((Object)r.getCode())) continue;
                o = t;
                break;
            }
            union.addInteraction(r);
            if (o == null) {
                this.error(td, ValidationMessage.IssueType.NOTFOUND, path + ".interaction.where(code = '" + (Object)((Object)r.getCode()) + "')", this.selfName + " specifies the interaction " + (Object)((Object)r.getCode()) + " but " + this.otherName + " does not");
                continue;
            }
            intersection.addInteraction(r);
            olr.add(o);
        }
        for (CapabilityStatement.ResourceInteractionComponent t : ol) {
            union.addInteraction(t);
            if (olr.contains(t) || !this.isProhibited(t)) continue;
            this.error(td, ValidationMessage.IssueType.CONFLICT, path + ".interaction", this.selfName + " does not specify the interaction " + (Object)((Object)t.getCode()) + " but " + this.otherName + " prohibits it");
        }
    }

    private void compareResourceSearchParams(String path, CapabilityStatement.CapabilityStatementRestResourceComponent self, CapabilityStatement.CapabilityStatementRestResourceComponent other, XhtmlNode tbl, CapabilityStatement.CapabilityStatementRestResourceComponent intersection, CapabilityStatement.CapabilityStatementRestResourceComponent union) {
        XhtmlNode tr = tbl.tr();
        tr.td().para().tx(XhtmlNode.NBSP + " - Search Params");
        this.genSP(tr.td(), self, other, true);
        this.genSP(tr.td(), other, self, false);
        XhtmlNode td = tr.td();
        ArrayList<CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent> ol = new ArrayList<CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent>();
        ArrayList<CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent> olr = new ArrayList<CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent>();
        ol.addAll(other.getSearchParam());
        for (CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent r : self.getSearchParam()) {
            CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent o = null;
            for (CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent t : ol) {
                if (!t.getName().equals(r.getName())) continue;
                o = t;
                break;
            }
            union.addSearchParam(r);
            if (o == null) {
                this.error(td, ValidationMessage.IssueType.NOTFOUND, path + ".searchParam.where(name = '" + r.getName() + "')", this.selfName + " specifies the search parameter " + r.getName() + " but " + this.otherName + " does not");
                continue;
            }
            intersection.addSearchParam(r);
            olr.add(o);
        }
        for (CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent t : ol) {
            if (!olr.contains(t)) {
                union.addSearchParam(t);
            }
            if (olr.contains(t) || !this.isProhibited(t)) continue;
            this.error(td, ValidationMessage.IssueType.CONFLICT, path + "", this.selfName + " does not specify the search parameter " + t.getName() + " but " + this.otherName + " prohibits it");
        }
    }

    private String getConfStatus(Element t) {
        return t.hasExtension("http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation") ? t.getExtensionString("http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation") : null;
    }

    private boolean isShouldOrShall(Element t) {
        return t.hasExtension("http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation") && ("SHALL".equals(t.getExtensionString("http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation")) || "SHOULD".equals(t.getExtensionString("http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation")));
    }

    private boolean isProhibited(Element t) {
        return t.hasExtension("http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation") && "SHALL NOT".equals(t.getExtensionString("http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation"));
    }

    private void compareSecurity(XhtmlNode td, String path, CapabilityStatement.CapabilityStatementRestSecurityComponent self, CapabilityStatement.CapabilityStatementRestSecurityComponent other, CapabilityStatement.CapabilityStatementRestSecurityComponent intersection, CapabilityStatement.CapabilityStatementRestSecurityComponent union) {
        if (self.getCors() && !other.getCors()) {
            this.error(td, ValidationMessage.IssueType.CONFLICT, path + ".security.cors", this.selfName + " specifies CORS but " + this.otherName + " doesn't");
        } else if (!self.getCors() && other.getCors()) {
            this.error(td, ValidationMessage.IssueType.CONFLICT, path + ".security.cors", this.selfName + " does not specify CORS but " + this.otherName + " does");
        }
        if (self.getCors() || other.getCors()) {
            union.setCors(true);
        }
        if (self.getCors() && other.getCors()) {
            union.setCors(true);
        }
        ArrayList<CodeableConcept> ol = new ArrayList<CodeableConcept>();
        ArrayList<CodeableConcept> olr = new ArrayList<CodeableConcept>();
        ol.addAll(other.getService());
        for (CodeableConcept cc : self.getService()) {
            CodeableConcept o = null;
            for (CodeableConcept t : ol) {
                if (!this.isMatch(t, cc)) continue;
                o = t;
                break;
            }
            union.getService().add(cc);
            if (o == null) {
                this.error(td, ValidationMessage.IssueType.CONFLICT, path + ".security.cors", this.selfName + " specifies the security option " + this.gen(cc) + " but " + this.otherName + " does not");
                continue;
            }
            intersection.getService().add(cc);
            olr.add(o);
        }
        for (CodeableConcept cc : ol) {
            if (olr.contains(cc)) continue;
            union.getService().add(cc);
            this.error(td, ValidationMessage.IssueType.CONFLICT, path + ".security.cors", this.selfName + " does not specify the security option " + this.gen(cc) + " but " + this.otherName + " does");
        }
    }

    private boolean isMatch(CodeableConcept self, CodeableConcept other) {
        for (Coding s : self.getCoding()) {
            for (Coding o : other.getCoding()) {
                if (!this.isMatch(s, o)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isMatch(Coding s, Coding o) {
        return s.hasCode() && s.getCode().equals(o.getCode()) && s.hasSystem() && s.getSystem().equals(o.getSystem());
    }

    private String gen(CapabilityStatement.CapabilityStatementRestSecurityComponent security) {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        for (CodeableConcept cc : security.getService()) {
            b.append(this.gen(cc));
        }
        if (security.getCors()) {
            b.append("(CORS)");
        }
        if (Utilities.noString((String)b.toString())) {
            return "(none specified)";
        }
        return b.toString();
    }

    private String gen(CodeableConcept cc) {
        if (cc.hasText()) {
            return cc.getText();
        }
        if (cc.hasCoding()) {
            return this.gen(cc.getCoding().get(0));
        }
        return "?gen-cc?";
    }

    private String gen(Coding coding) {
        if (coding.hasDisplay()) {
            return coding.getDisplay();
        }
        if (coding.hasCode()) {
            return coding.getCode();
        }
        return "?gen-c?";
    }

    private XhtmlNode startHtml() {
        this.html = new XhtmlDocument();
        XhtmlNode doc = this.html.addTag("html");
        XhtmlNode head = doc.addTag("head");
        head.addTag("title").addText("Comparison of " + this.selfName + " to " + this.otherName);
        head.addTag("link").setAttribute("rel", "stylesheet").setAttribute("href", "fhir.css");
        XhtmlNode body = doc.addTag("body").style("background-color: white");
        body.h1().addText("Comparison of " + this.selfName + " to " + this.otherName);
        return body;
    }

    private void addMarkdown(XhtmlNode x, String text) throws FHIRFormatError, IOException, DefinitionException {
        if (text != null) {
            XhtmlDocument m;
            while (text.contains("[[[")) {
                String left = text.substring(0, text.indexOf("[[["));
                String link = text.substring(text.indexOf("[[[") + 3, text.indexOf("]]]"));
                String right = text.substring(text.indexOf("]]]") + 3);
                String url = link;
                String[] parts = link.split("\\#");
                StructureDefinition p = this.context.fetchResource(StructureDefinition.class, parts[0]);
                if (p == null) {
                    p = this.context.fetchTypeDefinition(parts[0]);
                }
                if (p == null) {
                    p = this.context.fetchResource(StructureDefinition.class, link);
                }
                if (p != null) {
                    url = p.getUserString("path");
                    if (url == null) {
                        url = p.getUserString("filename");
                    }
                } else {
                    throw new DefinitionException("Unable to resolve markdown link " + link);
                }
                text = left + "[" + link + "](" + url + ")" + right;
            }
            String s = this.markdown.process(Utilities.escapeXml((String)text), "narrative generator");
            XhtmlParser p = new XhtmlParser();
            try {
                m = p.parse("<div>" + s + "</div>", "div");
            }
            catch (FHIRFormatError e) {
                throw new FHIRFormatError(e.getMessage(), (Throwable)e);
            }
            x.getChildNodes().addAll(m.getChildNodes());
        }
    }

    private XhtmlNode startTable(XhtmlNode x, CapabilityStatement self, CapabilityStatement other) {
        XhtmlNode tbl = x.table("grid");
        XhtmlNode tr = tbl.tr();
        tr.td().b().nbsp();
        tr.td().b().addText(this.selfName);
        tr.td().b().addText(this.otherName);
        tr.td().b().addText("Comparison");
        return tbl;
    }

    private void download(String address, String filename) throws IOException {
        URL url = new URL(address);
        URLConnection c = url.openConnection();
        InputStream s = c.getInputStream();
        FileOutputStream f = new FileOutputStream(filename);
        CapabilityStatementUtilities.transfer(s, f, 1024);
        f.close();
    }

    public static void transfer(InputStream in, OutputStream out, int buffer) throws IOException {
        byte[] read = new byte[buffer];
        while (0 < (buffer = in.read(read))) {
            out.write(read, 0, buffer);
        }
    }

    private void fatal(XhtmlNode x, ValidationMessage.IssueType type, String path, String message) {
        XhtmlNode ul;
        this.output.messages.add(new ValidationMessage(ValidationMessage.Source.ProfileComparer, type, path, message, ValidationMessage.IssueSeverity.FATAL));
        if ("ul".equals(x.getName())) {
            ul = x;
        } else {
            ul = null;
            for (XhtmlNode c : x.getChildNodes()) {
                if (!"ul".equals(c.getName())) continue;
                ul = c;
            }
            if (ul == null) {
                ul = x.ul();
            }
        }
        ul.li().b().style("color: maroon").addText(message);
    }

    private void error(XhtmlNode x, ValidationMessage.IssueType type, String path, String message) {
        XhtmlNode ul;
        this.output.messages.add(new ValidationMessage(ValidationMessage.Source.ProfileComparer, type, path, message, ValidationMessage.IssueSeverity.ERROR));
        if ("ul".equals(x.getName())) {
            ul = x;
        } else {
            ul = null;
            for (XhtmlNode c : x.getChildNodes()) {
                if (!"ul".equals(c.getName())) continue;
                ul = c;
            }
            if (ul == null) {
                ul = x.ul();
            }
        }
        ul.li().b().style("color: maroon").addText(message);
    }

    private void information(XhtmlNode x, ValidationMessage.IssueType type, String path, String message) {
        XhtmlNode ul;
        if (type != null) {
            this.output.messages.add(new ValidationMessage(ValidationMessage.Source.ProfileComparer, type, path, message, ValidationMessage.IssueSeverity.INFORMATION));
        }
        if ("ul".equals(x.getName())) {
            ul = x;
        } else {
            ul = null;
            for (XhtmlNode c : x.getChildNodes()) {
                if (!"ul".equals(c.getName())) continue;
                ul = c;
            }
            if (ul == null) {
                ul = x.ul();
            }
        }
        ul.li().addText(message);
    }

    private XhtmlNode same(String text, boolean test) {
        XhtmlNode span = new XhtmlNode(NodeType.Element, "span");
        if (test) {
            span.style("background-color: #bbff99; border: 1px solid #44cc00; margin-width: 10px");
        }
        span.tx(text);
        return span;
    }

    private int compareStr(String l, String r) {
        if (l == null && r == null) {
            return r == null ? 0 : -1;
        }
        if (r == null) {
            return 1;
        }
        return l.compareTo(r);
    }

    private void sortCapabilityStatement(CapabilityStatement cs) {
        this.sortExtensions(cs);
        Collections.sort(cs.getRest(), new CapabilityStatementRestSorter());
        for (CapabilityStatement.CapabilityStatementRestComponent csr : cs.getRest()) {
            Collections.sort(csr.getSecurity().getService(), new CodeableConceptSorter());
            Collections.sort(csr.getCompartment(), new CanonicalTypeSorter());
            Collections.sort(csr.getResource(), new CapabilityStatementRestResourceSorter());
            for (CapabilityStatement.CapabilityStatementRestResourceComponent r : csr.getResource()) {
                Collections.sort(r.getSupportedProfile(), new CanonicalTypeSorter());
                Collections.sort(r.getInteraction(), new CapabilityStatementRestResourceInteractionSorter());
                Collections.sort(r.getReferencePolicy(), new EnumSorter());
                Collections.sort(r.getSearchInclude(), new StringTypeSorter());
                Collections.sort(r.getSearchRevInclude(), new StringTypeSorter());
                Collections.sort(r.getSearchParam(), new SearchParamSorter());
                Collections.sort(r.getOperation(), new OperationSorter());
            }
            Collections.sort(csr.getInteraction(), new SystemInteractionComponentSorter());
            Collections.sort(csr.getSearchParam(), new SearchParamSorter());
            Collections.sort(csr.getOperation(), new OperationSorter());
        }
    }

    private void sortExtensions(DomainResource dr) {
        Collections.sort(dr.getExtension(), new ExtensionSorter());
        for (Property p : dr.children()) {
            for (Base b : p.getValues()) {
                if (!(b instanceof Element)) continue;
                this.sortExtensions((Element)b);
            }
        }
    }

    private void sortExtensions(Element e) {
        Collections.sort(e.getExtension(), new ExtensionSorter());
        for (Property p : e.children()) {
            for (Base b : p.getValues()) {
                if (!(b instanceof Element)) continue;
                this.sortExtensions((Element)b);
            }
        }
    }

    public class CodeableConceptSorter
    implements Comparator<CodeableConcept> {
        @Override
        public int compare(CodeableConcept l, CodeableConcept r) {
            Collections.sort(l.getCoding(), new CodingSorter());
            Collections.sort(r.getCoding(), new CodingSorter());
            return CapabilityStatementUtilities.this.compareStr(this.cgen(l), this.cgen(r));
        }

        private String cgen(CodeableConcept cc) {
            if (cc.hasCoding()) {
                return "" + cc.getCodingFirstRep().getSystem() + "#" + cc.getCodingFirstRep().getCode();
            }
            return "~" + cc.getText();
        }
    }

    public class CodingSorter
    implements Comparator<Coding> {
        @Override
        public int compare(Coding l, Coding r) {
            return CapabilityStatementUtilities.this.compareStr("" + l.getSystem() + "#" + l.getCode(), "" + r.getSystem() + "#" + r.getCode());
        }
    }

    public class ExtensionSorter
    implements Comparator<Extension> {
        @Override
        public int compare(Extension l, Extension r) {
            return CapabilityStatementUtilities.this.compareStr(l.getUrl(), r.getUrl());
        }
    }

    public class EnumSorter
    implements Comparator<Enumeration> {
        @Override
        public int compare(Enumeration l, Enumeration r) {
            return CapabilityStatementUtilities.this.compareStr(l.getCode(), r.getCode());
        }
    }

    public class StringTypeSorter
    implements Comparator<StringType> {
        @Override
        public int compare(StringType l, StringType r) {
            return CapabilityStatementUtilities.this.compareStr((String)l.getValue(), (String)r.getValue());
        }
    }

    public class CanonicalTypeSorter
    implements Comparator<CanonicalType> {
        @Override
        public int compare(CanonicalType l, CanonicalType r) {
            return CapabilityStatementUtilities.this.compareStr((String)l.getValue(), (String)r.getValue());
        }
    }

    public class OperationSorter
    implements Comparator<CapabilityStatement.CapabilityStatementRestResourceOperationComponent> {
        @Override
        public int compare(CapabilityStatement.CapabilityStatementRestResourceOperationComponent l, CapabilityStatement.CapabilityStatementRestResourceOperationComponent r) {
            return CapabilityStatementUtilities.this.compareStr(l.getName(), r.getName());
        }
    }

    public class SearchParamSorter
    implements Comparator<CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent> {
        @Override
        public int compare(CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent l, CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent r) {
            return CapabilityStatementUtilities.this.compareStr(l.getName(), r.getName());
        }
    }

    public class SystemInteractionComponentSorter
    implements Comparator<CapabilityStatement.SystemInteractionComponent> {
        @Override
        public int compare(CapabilityStatement.SystemInteractionComponent l, CapabilityStatement.SystemInteractionComponent r) {
            return CapabilityStatementUtilities.this.compareStr(l.hasCode() ? l.getCode().toCode() : null, r.hasCode() ? r.getCode().toCode() : null);
        }
    }

    public class CapabilityStatementRestResourceInteractionSorter
    implements Comparator<CapabilityStatement.ResourceInteractionComponent> {
        @Override
        public int compare(CapabilityStatement.ResourceInteractionComponent l, CapabilityStatement.ResourceInteractionComponent r) {
            return CapabilityStatementUtilities.this.compareStr(l.hasCode() ? l.getCode().toCode() : null, r.hasCode() ? r.getCode().toCode() : null);
        }
    }

    public class CapabilityStatementRestResourceSorter
    implements Comparator<CapabilityStatement.CapabilityStatementRestResourceComponent> {
        @Override
        public int compare(CapabilityStatement.CapabilityStatementRestResourceComponent l, CapabilityStatement.CapabilityStatementRestResourceComponent r) {
            return CapabilityStatementUtilities.this.compareStr(l.getType(), r.getType());
        }
    }

    public class CapabilityStatementRestSorter
    implements Comparator<CapabilityStatement.CapabilityStatementRestComponent> {
        @Override
        public int compare(CapabilityStatement.CapabilityStatementRestComponent l, CapabilityStatement.CapabilityStatementRestComponent r) {
            return CapabilityStatementUtilities.this.compareStr(l.hasMode() ? l.getMode().toCode() : null, r.hasMode() ? r.getMode().toCode() : null);
        }
    }

    public class CapabilityStatementComparisonOutput {
        private CapabilityStatement superset;
        private CapabilityStatement subset;
        private OperationOutcome outcome;
        private List<ValidationMessage> messages = new ArrayList<ValidationMessage>();

        public CapabilityStatementComparisonOutput() {
            this.subset = new CapabilityStatement();
            CapabilityStatementUtilities.this.keygen.genId(this.subset);
            this.subset.setDate(new Date());
            this.subset.setName("intersection of " + CapabilityStatementUtilities.this.selfName + " and " + CapabilityStatementUtilities.this.otherName);
            this.subset.setStatus(Enumerations.PublicationStatus.DRAFT);
            this.superset = new CapabilityStatement();
            CapabilityStatementUtilities.this.keygen.genId(this.superset);
            this.superset.setDate(this.subset.getDate());
            this.superset.setName("union of " + CapabilityStatementUtilities.this.selfName + " and " + CapabilityStatementUtilities.this.otherName);
            this.superset.setStatus(Enumerations.PublicationStatus.DRAFT);
        }

        public CapabilityStatement getSuperset() {
            return this.superset;
        }

        public CapabilityStatement getSubset() {
            return this.subset;
        }

        public OperationOutcome getOutcome() {
            return this.outcome;
        }

        public List<ValidationMessage> getMessages() {
            return this.messages;
        }
    }
}

