/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.context;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.utilities.VersionUtilities;

public class CanonicalResourceManager<T extends CanonicalResource> {
    private boolean enforceUniqueId;
    private List<CachedCanonicalResource<T>> list = new ArrayList<CachedCanonicalResource<T>>();
    private Map<String, T> map = new HashMap<String, T>();

    public CanonicalResourceManager(boolean enforceUniqueId) {
        this.enforceUniqueId = enforceUniqueId;
    }

    public void copy(CanonicalResourceManager<T> source) {
        this.list.clear();
        this.map.clear();
        this.list.addAll(source.list);
        this.map.putAll(source.map);
    }

    public void see(T r, IWorkerContext.PackageVersion packgeInfo) {
        if (!((Resource)r).hasId()) {
            ((Resource)r).setId(UUID.randomUUID().toString());
        }
        if (this.enforceUniqueId && this.map.containsKey(((Resource)r).getId())) {
            this.drop(((Resource)r).getId());
        }
        if (packgeInfo != null && packgeInfo.getId().startsWith("hl7.terminology")) {
            ArrayList<CachedCanonicalResource<T>> toDrop = new ArrayList<CachedCanonicalResource<T>>();
            for (CachedCanonicalResource<T> cachedCanonicalResource : this.list) {
                if (!((CanonicalResource)cachedCanonicalResource.getResource()).getUrl().equals(((CanonicalResource)r).getUrl()) || !this.isBasePackage(cachedCanonicalResource.getPackageInfo())) continue;
                toDrop.add(cachedCanonicalResource);
            }
            for (CachedCanonicalResource<Object> cachedCanonicalResource : toDrop) {
                this.drop(cachedCanonicalResource.getId());
            }
        }
        this.list.add(new CachedCanonicalResource(this, r, packgeInfo));
        this.map.put(((Resource)r).getId(), r);
        if (((CanonicalResource)r).hasUrl()) {
            if (((CanonicalResource)r).hasVersion()) {
                this.map.put(((CanonicalResource)r).getUrl() + "|" + ((CanonicalResource)r).getVersion(), r);
            }
            this.updateList(((CanonicalResource)r).getUrl(), ((CanonicalResource)r).getVersion());
        }
    }

    private boolean isBasePackage(IWorkerContext.PackageVersion packageInfo) {
        return packageInfo == null ? false : VersionUtilities.isCorePackage((String)packageInfo.getId());
    }

    private void updateList(String url, String version) {
        ArrayList<CachedCanonicalResource<T>> rl = new ArrayList<CachedCanonicalResource<T>>();
        for (CachedCanonicalResource<T> t : this.list) {
            if (!url.equals(t.getUrl()) || rl.contains(t)) continue;
            rl.add(t);
        }
        if (rl.size() > 0) {
            Collections.sort(rl, new MetadataResourceVersionComparator());
            this.map.put(url, ((CachedCanonicalResource)rl.get(rl.size() - 1)).getResource());
            if (version != null) {
                String lv;
                CanonicalResource latest = null;
                for (CachedCanonicalResource cachedCanonicalResource : rl) {
                    if (!VersionUtilities.versionsCompatible((String)((CanonicalResource)cachedCanonicalResource.getResource()).getVersion(), (String)version)) continue;
                    latest = cachedCanonicalResource.getResource();
                }
                if (latest != null && (lv = VersionUtilities.getMajMin((String)latest.getVersion())) != null && !lv.equals(version)) {
                    this.map.put(url + "|" + lv, ((CachedCanonicalResource)rl.get(rl.size() - 1)).getResource());
                }
            }
        }
    }

    public T get(String url) {
        return (T)((CanonicalResource)this.map.get(url));
    }

    public boolean has(String url) {
        return this.map.containsKey(url);
    }

    public T get(String system, String version) {
        if (version == null) {
            return this.get(system);
        }
        if (this.map.containsKey(system + "|" + version)) {
            return (T)((CanonicalResource)this.map.get(system + "|" + version));
        }
        String mm = VersionUtilities.getMajMin((String)version);
        if (mm != null) {
            return (T)((CanonicalResource)this.map.get(system + "|" + mm));
        }
        return null;
    }

    public boolean has(String system, String version) {
        if (this.map.containsKey(system + "|" + version)) {
            return true;
        }
        String mm = VersionUtilities.getMajMin((String)version);
        if (mm != null) {
            return this.map.containsKey(system + "|" + mm);
        }
        return false;
    }

    public int size() {
        return this.list.size();
    }

    public void drop(String id) {
        CachedCanonicalResource<T> res = null;
        do {
            res = null;
            for (CachedCanonicalResource<T> t : this.list) {
                if (!t.getId().equals(id)) continue;
                res = t;
            }
            if (res == null) continue;
            this.list.remove(res);
            this.map.remove(id);
            this.map.remove(res.getUrl());
            if (res.hasVersion()) {
                this.map.remove(res.getUrl() + "|" + res.getVersion());
                String mm = VersionUtilities.getMajMin((String)res.getVersion());
                if (mm != null) {
                    this.map.remove(res.getUrl() + "|" + mm);
                }
            }
            this.updateList(res.getUrl(), res.getVersion());
        } while (res != null);
    }

    public void listAll(List<T> result) {
        for (CachedCanonicalResource<T> t : this.list) {
            result.add(t.getResource());
        }
    }

    public void listAllM(List<CanonicalResource> result) {
        for (CachedCanonicalResource<T> t : this.list) {
            result.add((CanonicalResource)t.getResource());
        }
    }

    public void clear() {
        this.list.clear();
        this.map.clear();
    }

    public List<T> getList() {
        ArrayList<T> res = new ArrayList<T>();
        for (CachedCanonicalResource<T> t : this.list) {
            if (res.contains(t.getResource())) continue;
            res.add(t.getResource());
        }
        return res;
    }

    public List<T> getSortedList() {
        List<T> res = this.getList();
        Collections.sort(res, new CanonicalListSorter());
        return res;
    }

    public Set<String> keys() {
        return this.map.keySet();
    }

    public boolean isEnforceUniqueId() {
        return this.enforceUniqueId;
    }

    public class MetadataResourceVersionComparator<T1 extends CachedCanonicalResource<T>>
    implements Comparator<T1> {
        @Override
        public int compare(T1 arg1, T1 arg2) {
            String v1 = ((CanonicalResource)((CachedCanonicalResource)arg1).getResource()).getVersion();
            String v2 = ((CanonicalResource)((CachedCanonicalResource)arg2).getResource()).getVersion();
            if (v1 == null && v2 == null) {
                return Integer.compare(CanonicalResourceManager.this.list.indexOf(arg1), CanonicalResourceManager.this.list.indexOf(arg2));
            }
            if (v1 == null) {
                return -1;
            }
            if (v2 == null) {
                return 1;
            }
            String mm1 = VersionUtilities.getMajMin((String)v1);
            String mm2 = VersionUtilities.getMajMin((String)v2);
            if (mm1 == null || mm2 == null) {
                return v1.compareTo(v2);
            }
            return mm1.compareTo(mm2);
        }
    }

    private static class CachedCanonicalResource<T1 extends CanonicalResource> {
        private T1 resource;
        private IWorkerContext.PackageVersion packageInfo;
        final /* synthetic */ CanonicalResourceManager this$0;

        public CachedCanonicalResource(T1 resource, IWorkerContext.PackageVersion packageInfo) {
            this.this$0 = var1_1;
            this.resource = resource;
            this.packageInfo = packageInfo;
        }

        public T1 getResource() {
            return this.resource;
        }

        public IWorkerContext.PackageVersion getPackageInfo() {
            return this.packageInfo;
        }

        public String getUrl() {
            return ((CanonicalResource)this.resource).getUrl();
        }

        public String getId() {
            return ((Resource)this.resource).getId();
        }

        public String getVersion() {
            return ((CanonicalResource)this.resource).getVersion();
        }

        public boolean hasVersion() {
            return ((CanonicalResource)this.resource).hasVersion();
        }
    }

    public class CanonicalListSorter
    implements Comparator<CanonicalResource> {
        @Override
        public int compare(CanonicalResource arg0, CanonicalResource arg1) {
            String u0 = arg0.getUrl();
            String u1 = arg1.getUrl();
            return u0.compareTo(u1);
        }
    }
}

